# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-6768 (kernel)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64291);
 script_cve_id("CVE-2009-1385", "CVE-2009-1389");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.8");
 script_tag(name:"risk_factor", value:"High");
 name = "Fedora Core 11 FEDORA-2009-6768 (kernel)";
 script_name(name);

 desc = "The remote host is missing an update to kernel
announced via advisory FEDORA-2009-6768.

Update Information:

Update to kernel 2.6.29.5:
http://www.kernel.org/pub/linux/kernel/v2.6/ChangeLog-2.6.29.5    Includes DRM
modesetting bug fixes.    Adds driver for VIA SD/MMC controllers and full
support for the Nano processor in 64-bit mode.

ChangeLog:

* Tue Jun 16 2009 Chuck Ebbert  2.6.29.5-191
- Copy latest version of the -mm streaming IO and executable pages patches from F-10
- Copy the saner-vm-settings patch from F-10:
change writeback interval from 5,30 seconds to 3,10 seconds
- Comment out the null credentials debugging patch (bug #494067)
* Tue Jun 16 2009 Chuck Ebbert  2.6.29.5-190
- Two r8169 driver updates from 2.6.30
- Update via-sdmmc driver
* Tue Jun 16 2009 Chuck Ebbert  2.6.29.5-189
- New debug patch for bug #494067, now enabled for non-debug kernels too.
* Tue Jun 16 2009 Chuck Ebbert  2.6.29.5-188
- Avoid lockup on OOM with /dev/zero
* Tue Jun 16 2009 Chuck Ebbert  2.6.29.5-187
- Drop the disable of mwait on VIA Nano processor. The lockup bug is
fixed by BIOS updates.
* Tue Jun 16 2009 Ben Skeggs  2.6.29.5-186
- nouveau: Use VBIOS image from PRAMIN in preference to PROM (#492658)
* Tue Jun 16 2009 Dave Airlie  2.6.29.5-185
- drm-connector-dpms-fix.patch - allow hw to dpms off
- drm-dont-frob-i2c.patch - don't play with i2c bits just do EDID
- drm-intel-tv-fix.patch - fixed intel tv after connector dpms
- drm-modesetting-radeon-fixes.patch - fix AGP issues (go faster) (otaylor)
- drm-radeon-fix-ring-commit.patch - fix stability on some radeons
- drm-radeon-new-pciids.patch - add rv770/790 support
- drm-intel-vmalloc.patch - fix vmalloc patch

References:

[ 1 ] Bug #502981 - CVE-2009-1385 kernel: e1000_clean_rx_irq() denial of service
https://bugzilla.redhat.com/show_bug.cgi?id=502981
[ 2 ] Bug #504726 - CVE-2009-1389 kernel: r8169: fix crash when large packets are received
https://bugzilla.redhat.com/show_bug.cgi?id=504726

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update kernel' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-6768

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 11 FEDORA-2009-6768 (kernel)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"kernel", rpm:"kernel~2.6.29.5~191.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-devel", rpm:"kernel-devel~2.6.29.5~191.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-headers", rpm:"kernel-headers~2.6.29.5~191.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debuginfo", rpm:"kernel-debuginfo~2.6.29.5~191.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debuginfo-common", rpm:"kernel-debuginfo-common~2.6.29.5~191.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAE", rpm:"kernel-PAE~2.6.29.5~191.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAE-devel", rpm:"kernel-PAE-devel~2.6.29.5~191.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAEdebug", rpm:"kernel-PAEdebug~2.6.29.5~191.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAEdebug-devel", rpm:"kernel-PAEdebug-devel~2.6.29.5~191.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAE-debuginfo", rpm:"kernel-PAE-debuginfo~2.6.29.5~191.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAEdebug-debuginfo", rpm:"kernel-PAEdebug-debuginfo~2.6.29.5~191.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-doc", rpm:"kernel-doc~2.6.29.5~191.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-firmware", rpm:"kernel-firmware~2.6.29.5~191.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-bootwrapper", rpm:"kernel-bootwrapper~2.6.29.5~191.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-smp", rpm:"kernel-smp~2.6.29.5~191.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-smp-devel", rpm:"kernel-smp-devel~2.6.29.5~191.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-smp-debuginfo", rpm:"kernel-smp-debuginfo~2.6.29.5~191.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debug", rpm:"kernel-debug~2.6.29.5~191.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debug-devel", rpm:"kernel-debug-devel~2.6.29.5~191.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debug-debuginfo", rpm:"kernel-debug-debuginfo~2.6.29.5~191.fc11", rls:"FC11")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
