###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for automake14 FEDORA-2010-1718
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861750);
  script_version("$Revision: 8150 $: 1.0");
  script_tag(name:"cvss_base", value:"4.6");
  script_tag(name:"risk_factor", value:"Medium");
  script_xref(name: "FEDORA", value: "2010-1718");
  script_cve_id("CVE-2009-4029");
  script_name("Fedora Update for automake14 FEDORA-2010-1718");
  desc = "

  Vulnerability Insight:
  Automake is a tool for automatically generating
  `Makefile.in' files compliant with the GNU Coding Standards.
  
  This package contains Automake 1.4, an older version of Automake.
  You should install it if you need to run automake in a project that
  has not yet been updated to work with newer versions of Automake.


  Affected Software/OS:
  automake14 on Fedora 12

  Fix: Please Install the Updated Packages.

  References:
  http://lists.fedoraproject.org/pipermail/package-announce/2010-March/036419.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of automake14");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC12")
{

  if(isrpmvuln(pkg:"automake14", rpm:"automake14~1.4p6~20.fc12", rls:"FC12"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}