###############################################################################
# OpenVAS Vulnerability Test
#
# HP-UX Update for useradd(1M) HPSBUX02366
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(835198);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"6.0");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "HPSBUX", value: "02366");
  script_cve_id("CVE-2009-0719");
  script_name( "HP-UX Update for useradd(1M) HPSBUX02366");
  desc = "

  Vulnerability Insight:
  A potential security vulnerability has been identified in HP-UX running the 
  useradd(1M) command. The vulnerability could be exploited locally to allow 
  unauthorized access to directories or files. 

  Impact:
  Local unauthorized access

  Affected Software/OS:
  useradd(1M) on
  HP-UX B.11.11, B.11.23, B.11.31 running the useradd(1M) command 

  Fix: Please Install the Updated Packages.

  References:
  http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c01539431-2

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of useradd(1M)");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("HP-UX Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-hpux.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "HPUX11.31")
{

  if(ishpuxpkgvuln(pkg:"OS-Core.SYS2-ADMIN", patch_list:['PHCO_38547'], rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.23")
{

  if(ishpuxpkgvuln(pkg:"OS-Core.SYS-ADMIN", patch_list:['PHCO_38491'], rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"OS-Core.SYS2-ADMIN", patch_list:['PHCO_38491'], rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.11")
{

  if(ishpuxpkgvuln(pkg:"OS-Core.SYS-ADMIN", patch_list:['PHCO_38492'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}