##############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_usebb_detect.nasl 5850 2009-11-24 09:05:29Z nov $
#
# UseBB Version Detection
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
################################################################################

if(description)
{
  script_id(901056);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("UseBB Version Detection");
  desc = "
  Overview: This script detects the installed UseBB version and sets
  the result in KB.

  Risk factor:None";

  script_description(desc);
  script_summary("Set KB for the version of UseBB ");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

usebbPort = get_http_port(default:80);
if(!usebbPort){
  exit(0);
}

foreach dir (make_list("/", "/UseBB", "/forum", cgi_dirs()))
{
  sndReq = http_get(item:string(dir, "/index.php"), port:usebbPort);
  rcvRes = http_send_recv(port:usebbPort, data:sndReq);

  if("UseBB" >< rcvRes && egrep(pattern:"^HTTP/.* 200 OK", string:rcvRes))
  {
    sndReq = http_get(item:string(dir, "/Changelog.txt"), port:usebbPort);
    rcvRes = http_send_recv(port:usebbPort, data:sndReq);

    usebbVer = eregmatch(pattern:"UseBB (([0-9.]+)( ?(beta|RC|a|b)( ?[0-9]+)?)?)",
                          string:rcvRes);
    if(usebbVer[1]!= NULL)
    {
      usebbVer = ereg_replace(pattern:" ", string:usebbVer[1], replace: ".");
      set_kb_item(name:"www/"+ usebbPort + "/UseBB", value:usebbVer + " under " + dir);
      security_note(data:"UseBB version " + usebbVer + " running at " +
                         "location " + dir +  " was detected on the host");
    }
  }
}
