Minutes from 28th OpenVDB TSC meeting, September 26th, 2019, (GMT)

Attendees: *Nick* A., *Dan* B., *Jeff* L., *Ken* M., *Peter* C.

Agenda:

1) Confirm quorum
2) Select TSC member to take minutes
3) OpenVDB 6.2 postmortem
4) Proposal for new improved interpolates
5) (OVDB-117) MeshToVolume non-deterministic bug
6) Windows CI
7) Update on copyright notices
8) User feedback (usd/python bindings/Maya support) 
9) Plans for ABI=7

1) Quorum was confirmed.

2) Secretary was Nick Avramoussis

3) OpenVDB 6.2 postmortem

An issue was reported with the OpenVDB 6.2.0 release which broke ABI
compatibility with Houdini. This was reproducible with a vanilla install of the
toolkit (on Linux) and manifested during serialization of OpenVDB Point Data
Grids into Houdini file formats (.bgeo and subsequent derivations) as a
segmentation fault. Generally, the definition of ABI compatibility that we apply
to the software is isolated to the Grid and Transform objects. Ken mentioned
that the major ABI definition should guarantee a reinterpret cast of the Grid.
However the io::StreamMetadata and internally held io::StreamMetadata::Impl
objects can also be passed between libraries using OpenVDB. These classes are
used for file IO and hold information about the current state of the IO stream.
In the above case, the StreamMetadata object was being constructed by Houdini
and passed across the library boundary to the writeBuffers() methods. This
function is unique for OpenVDB Point serialization in that it accesses auxiliary
stream metadata. Changes to the memory layout of the io::StreamMetadata::Impl
class made in PR #436 (OVDB-91) meant that the relative position of the
auxiliary stream metadata was no longer correct when passed across the library
boundary. Similar changes have been made to this class before, but have been
fortunate enough to be 1) small enough in bytes that the padding and alignment
resulted in the memory layout remaining the same, 2) members after the inserted
members were not accessed in the serialization routine or 3) they were only
appended to the end of the class. The proposed and agreed upon fix is to move
the new members added in #436 to the end of the class and to consider the
StreamMetadata object as part of the major ABI.

Note that this is not an issue for deserialization. The problem arises when
creating a VDB using a native SOP and serializating into a .vdb file or creating
the VDB using an ASWF SOP and serializing into a .bgeo file. Despite being
casted across the library boundary, the virtual functions still point at the
library definition from which the grid was authored.

There was discussion in regards to creating tests for problems specifically
related to Houdini ABI. Dan suggested that whilst a fully Houdini integration
test would be useful, it was probably not necessary for testing this particular
bug - instead, a binary which links to both the Houdini deployed version of
OpenVDB and the CI built OpenVDB could be used to test compatibility.

4) Proposal for new improved interpolates

A proposal from Ken to introduce new interpolators. Currently the existing
methods in Interpolation.h support zero, first and second order interpolation
with collocated and staggered grids. They're implemented as static classes with
no members which, whilst providing a very simple and easy to use interface,
requires them to fetch all stencil points on every sample call. There are
additional issues with some of the staggered implementations which perform
unnecessary operations on unused extents. Ken proposed a re-work of the current
methods to solve these issues and potentially introduce new third order
interpolators. Discussion on how this would differ from the methods available in
math/Stencils.h which currently provide various interpolation methods from
cached buffers of grid points. It could be possible to use the stencil framework
for efficient caching and fetching of values with a separate framework for the
interpolation algorithms. Discussion on how introducing new non-static classes
would impact the API of methods which are templated on the current static
interpolators, as these methods would need to construct these objects.
Suggestion would be to update all uses of the interpolation with any new ones
and mark the old ones as deprecated. Note that these interpolators are currently
not being unit tested. Any new interpolators should attempt to match the output
of the existing methods exactly. Ken to create a jira ticket with a description
of the proposal and notify the mailing list.


5) (OVDB-117) MeshToVolume non-deterministic bug

Nick reported a non deterministic bug with the MeshToVolume algorithm which is
producing different results with the same input. This originally came from a
regression test testing a P2LS operation followed by a level set rebuild.
OVDB-117 contains a main which has isolated the issue down to the
tools::meshToVolume call and, more specifically, to the first threaded operation
mesh_to_volume_internal::VoxelizePolygons. Attempts have been made to isolate
this down even further, however the suspicion is that it is related to threading
and the TLS primitive ID tree which is being used to track triangle visits to
individual voxels. Has not been reproduced unthreaded and requires multiple
instances of the binary to catch quickly. More testing to be performed.

6) Windows CI

A number of github issues regarding the windows CMake build have been raised.
Nick attempting to field these, however it has been challenging without a
Windows CI matrix. Dan mentioned that github actions has recently been made
available (open BETA). Dan to share an example implementation of github actions
which can be run from a forked repository and potentially share a version for
Windows which could be extended.

7) Update on copyright notices

DreamWorks are currently in discussions with the Linux Foundation on the best
way to proceed with any potential copyright notice changes. Changes to copyright
notices stalled on this decision.

8) User feedback (usd/python bindings/Maya support) 
9) Plans for ABI=7

Time.

11) Next Meeting

Next planned meeting is:

October 10th 2019. 3pm-4pm EDT (GMT-4).
