///////////////////////////////////////////////////////////////////////////////
// 
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __LAMMPS_DATA_WRITER_H
#define __LAMMPS_DATA_WRITER_H

#include <core/Core.h>
#include "../MultiFileWriter.h"

namespace AtomViz {

/**
 * \brief This exporter class writes LAMMPS text dump files.  
 * 
 * \sa LAMMPSDataParser
 * \author Alexander Stukowski 
 */ 
class ATOMVIZ_DLLEXPORT LAMMPSDataWriter : public MultiFileWriter
{
public:

	/// \brief Constructs a new instance of this class. 
	/// \param isLoading Specifies whether the object's data fields will be initialized from the 
	///                  data stored in a scene file after the instance has been created.
	LAMMPSDataWriter(bool isLoading = false) : MultiFileWriter(isLoading) {}

protected:

	// From MultiFileWriter:

	/// \brief Writes the output file.
	virtual bool writeAtomsFile(const QString& filepath, DataSet* dataset, const QVector<TimeTicks>& exportFrames, bool suppressDialogs);	
	
private:
	
	Q_OBJECT
	DECLARE_SERIALIZABLE_PLUGIN_CLASS(LAMMPSDataWriter)
};

};	// End of namespace AtomViz

#endif // __LAMMPS_DATA_WRITER_H
