'\"
'\" Copyright (c) 2003-2004 Paul H Alfille, MD
'\" (paul.alfille@gmail.com)
'\"
'\" Device manual page for the OWFS -- 1-wire filesystem package
'\" Based on Dallas Semiconductor, Inc's datasheets, and trial and error.
'\"
'\" Free for all use. No waranty. None. Use at your own risk.
'\" $Id$
'\"
.TH DS1991 3  2003 "OWFS Manpage" "One-Wire File System"
.SH NAME
.B DS1991
\- 1152bit MultiKey iButton
.SH SYNOPSIS
Non-volatile memory with password protection.
.PP
.B 02
[.]XXXXXXXXXXXX[XX][/[
.B subkey0/reset.
.I hex_pwd
|
.B subkey0/password.
.I hex_pwd
|
.B subkey0/secure_data.
.I hex_pwd
|
.B subkey0/id.
.I hex_pwd
.PP
.B 02
[.]XXXXXXXXXXXX[XX][/[
.B subkey1/reset.
.I hex_pwd
|
.B subkey1/password.
.I hex_pwd
|
.B subkey1/secure_data.
.I hex_pwd
|
.B subkey1/id.
.I hex_pwd
.PP
.B 02
[.]XXXXXXXXXXXX[XX][/[
.B subkey0/reset.
.I hex_pwd
|
.B subkey2/password.
.I hex_pwd
|
.B subkey2/secure_data.
.I hex_pwd
|
.B subkey2/id.
.I hex_pwd
.so man3/standard_mini.3so
]]
.SH FAMILY CODE
.PP
.I 02
.SH SPECIAL PROPERTIES
.SS subkey[0|1|2]/reset.hex_pwd
.I write-only, yes-no
.br
Initialize one of the three secure data areas and set a new password.
.PP
The extension (hex_pwd) is the new 8-byte password in hexidecimal (e.g. password.000204006080A0C0E for bytes 0,2,4,6,8,10,12,14)
.PP
The data must be "1" or "yes" to actually reset the subkey.
.PP
.I Note: writing a password will clear any existing data and ID.
.SS subkey[0|1|2]/password.hex_pwd
.I write-only, binary
.br
Change the 
.I password 
of one of the secure subkey areas 
.I without losing data.
.PP
The extension (hex_pwd) is the existing 8-byte 
.I password 
in hexidecimal (e.g. password.00020406080A0C0E for bytes 0,2,4,6,8,10,12,14)
.PP
The data portion is 8 bytes that will be used as a new 
.I password.
.SS subkey[0|1|2]/secure_data.hex_pwd
.I read-write, binary
.br
Read or write data in one of the three sucure data areas.
.PP
The extension (hex_pwd) is the existing 8-byte password in hexidecimal (e.g. password.00020406080A0C0E for bytes 0,2,4,6,8,10,12,14)
.PP
The data portion binary data. Up to 48 bytes in each subkey area, starting at location 0. If the wrong password is specified, "random data" is returned on read and data is silently ignored on write.
.SS subkey[0|1|2]/id.hex_pwd
.I read-write, binary
.br
Read or write the subkey
.I id.
.PP
The extension (hex_pwd) is the existing 8-byte password in hexidecimal (e.g. password.00020406080A0C0E for bytes 0,2,4,6,8,10,12,14)
.PP
The data portion 8 binary bytes. This is the subkey 
.I id.
The correct password must be used to write a new 
.I id
but not to read it.
.SH STANDARD PROPERTIES
.so man3/standard.3so
.SH ALARMS
None.
.SH DESCRIPTION
.so man3/description.3so
.SS DS1991
The
.B DS1991 (3)
is an iButton with password protected non-volatile memory. Data is read/written with error checking (transparent to the user). The memory is divided into 3 different pages with 3 separate passwords.
.PP
In theory, choosing an incorrect password is hard to discern because the chip responds normally but with incorrect data. There is a published analysis suggesting that the "random data" follows a pattern and so a concerted attack might be successful.
.PP
The password (in hexidecimal) is used a the file extension
.B 02.1234123414/subkey0/id.
.I password
allowing a password to be passed to the program within the filesystem paradigm.
.SH ADDRESSING
.so man3/addressing.3so
.SH DATASHEET
.br
http://pdfserv.maxim-ic.com/en/ds/DS1991.pdf
.SH SEE ALSO
.so man3/seealso.3so
.SH AVAILABILITY
http://www.owfs.org
.SH AUTHOR
Christian Magnusson (mag@mag.cx) and Paul Alfille
