/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.spline;

import org.j3d.geom.GeometryData;
import org.j3d.geom.GeometryGenerator;
import org.j3d.geom.InvalidArraySizeException;
import org.j3d.geom.UnsupportedTypeException;

public class BezierGenerator
extends GeometryGenerator {
    private static final int DEFAULT_FACETS = 16;
    private static int[] FACTORIALS = new int[]{1, 1, 2, 6, 24, 120, 720};
    private int facetCount;
    private float[] controlPointCoordinates;
    private int numControlPoints;
    private float[] curveCoordinates;
    private int numCurveValues;
    private boolean curveChanged;

    public BezierGenerator() {
        this(16);
    }

    public BezierGenerator(int n) {
        if (n < 3) {
            throw new IllegalArgumentException("Number of facets is < 3");
        }
        this.curveChanged = true;
        this.facetCount = n;
        this.numControlPoints = 0;
        this.numCurveValues = 0;
        this.controlPointCoordinates = new float[9];
        this.curveCoordinates = new float[(n + 1) * 3];
    }

    public void setFacetCount(int n) {
        if (n < 3) {
            throw new IllegalArgumentException("Number of facets is < 3");
        }
        if (this.facetCount != n) {
            this.curveChanged = true;
        }
        this.facetCount = n;
    }

    public void setControlPoints(float[] fArray) {
        this.setControlPoints(fArray, fArray.length / 3);
    }

    public void setControlPoints(float[] fArray, int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Number of valid points < 1");
        }
        if (n * 3 > this.controlPointCoordinates.length) {
            this.controlPointCoordinates = new float[n * 3];
        }
        System.arraycopy(fArray, 0, this.controlPointCoordinates, 0, n * 3);
        this.numControlPoints = n;
        this.curveChanged = true;
    }

    public int getVertexCount(GeometryData geometryData) throws UnsupportedTypeException {
        int n = 0;
        switch (geometryData.geometryType) {
            case 9: {
                n = (this.facetCount + 1) * 2;
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                n = this.facetCount + 1;
                break;
            }
            default: {
                throw new UnsupportedTypeException("Unknown geometry type: " + geometryData.geometryType);
            }
        }
        return n;
    }

    public void generate(GeometryData geometryData) throws UnsupportedTypeException, InvalidArraySizeException {
        switch (geometryData.geometryType) {
            case 9: {
                this.unindexedLines(geometryData);
                break;
            }
            case 10: {
                this.lineStrips(geometryData);
                break;
            }
            case 11: {
                this.indexedLines(geometryData);
                break;
            }
            case 12: {
                this.indexedLineStrips(geometryData);
                break;
            }
            default: {
                throw new UnsupportedTypeException("Unknown geometry type: " + geometryData.geometryType);
            }
        }
    }

    private void unindexedLines(GeometryData geometryData) throws InvalidArraySizeException {
        this.generateUnindexedLineCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateUnindexedLineNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateLineTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateLineTexture3D(geometryData);
        }
    }

    private void indexedLines(GeometryData geometryData) throws InvalidArraySizeException {
        this.generateIndexedLineCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateIndexedLineNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateLineTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateLineTexture3D(geometryData);
        }
        int n = (this.facetCount + 1) * 2;
        if (geometryData.indexes == null) {
            geometryData.indexes = new int[n];
        } else if (geometryData.indexes.length < n) {
            throw new InvalidArraySizeException("Index values", geometryData.coordinates.length, n);
        }
        int[] nArray = geometryData.indexes;
        geometryData.indexesCount = n;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            nArray[n3++] = n2++;
            nArray[n3++] = n2;
        }
    }

    private void lineStrips(GeometryData geometryData) throws InvalidArraySizeException {
        this.generateIndexedLineCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateIndexedLineNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateLineTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateLineTexture3D(geometryData);
        }
        if (geometryData.stripCounts == null) {
            geometryData.stripCounts = new int[1];
        } else if (geometryData.stripCounts.length < 1) {
            throw new InvalidArraySizeException("Strip counts", geometryData.stripCounts.length, 1);
        }
        geometryData.numStrips = 1;
        geometryData.stripCounts[0] = this.facetCount + 1;
    }

    private void indexedLineStrips(GeometryData geometryData) throws InvalidArraySizeException {
        this.generateIndexedLineCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateIndexedLineNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateLineTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateLineTexture3D(geometryData);
        }
        int n = (this.facetCount + 1) * 2;
        if (geometryData.indexes == null) {
            geometryData.indexes = new int[n];
        } else if (geometryData.indexes.length < n) {
            throw new InvalidArraySizeException("Index values", geometryData.indexes.length, n);
        }
        int[] nArray = geometryData.indexes;
        geometryData.indexesCount = n;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            nArray[n3++] = n2++;
            nArray[n3++] = n2;
        }
        if (geometryData.stripCounts == null) {
            geometryData.stripCounts = new int[1];
        } else if (geometryData.stripCounts.length < 1) {
            throw new InvalidArraySizeException("Strip counts", geometryData.stripCounts.length, 1);
        }
        geometryData.numStrips = 1;
        geometryData.stripCounts[0] = this.facetCount + 1;
    }

    private void generateUnindexedLineCoordinates(GeometryData geometryData) throws InvalidArraySizeException {
        int n = this.getVertexCount(geometryData);
        if (geometryData.coordinates == null) {
            geometryData.coordinates = new float[n * 3];
        } else if (geometryData.coordinates.length < n * 3) {
            throw new InvalidArraySizeException("Coordinates", geometryData.coordinates.length, n * 3);
        }
        float[] fArray = geometryData.coordinates;
        geometryData.vertexCount = n;
        this.regenerateCurve();
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this.facetCount; ++i) {
            fArray[n2] = this.curveCoordinates[n3];
            fArray[++n2] = this.curveCoordinates[n3 + 1];
            fArray[++n2] = this.curveCoordinates[n3 + 2];
            fArray[++n2] = this.curveCoordinates[n3 + 3];
            fArray[++n2] = this.curveCoordinates[n3 + 4];
            fArray[++n2] = this.curveCoordinates[n3 + 5];
            ++n2;
            n3 += 3;
        }
    }

    private void generateIndexedLineCoordinates(GeometryData geometryData) throws InvalidArraySizeException {
        int n = this.getVertexCount(geometryData);
        if (geometryData.coordinates == null) {
            geometryData.coordinates = new float[n * 3];
        } else if (geometryData.coordinates.length < n * 3) {
            throw new InvalidArraySizeException("Coordinates", geometryData.coordinates.length, n * 3);
        }
        float[] fArray = geometryData.coordinates;
        geometryData.vertexCount = n;
        this.regenerateCurve();
        System.arraycopy(this.curveCoordinates, 0, fArray, 0, this.numCurveValues);
    }

    private void generateUnindexedLineNormals(GeometryData geometryData) throws InvalidArraySizeException {
        int n = geometryData.vertexCount * 3;
        if (geometryData.normals == null) {
            geometryData.normals = new float[n];
        } else if (geometryData.normals.length < n) {
            throw new InvalidArraySizeException("Normals", geometryData.normals.length, n);
        }
    }

    private void generateIndexedLineNormals(GeometryData geometryData) throws InvalidArraySizeException {
        int n = geometryData.vertexCount * 3;
        if (geometryData.normals == null) {
            geometryData.normals = new float[n];
        } else if (geometryData.normals.length < n) {
            throw new InvalidArraySizeException("Normals", geometryData.normals.length, n);
        }
    }

    private void generateLineTexture2D(GeometryData geometryData) throws InvalidArraySizeException {
        int n = geometryData.vertexCount * 2;
        if (geometryData.textureCoordinates == null) {
            geometryData.textureCoordinates = new float[n];
        } else if (geometryData.textureCoordinates.length < n) {
            throw new InvalidArraySizeException("2D Texture coordinates", geometryData.textureCoordinates.length, n);
        }
        float[] fArray = geometryData.textureCoordinates;
    }

    private void generateLineTexture3D(GeometryData geometryData) throws InvalidArraySizeException {
        int n = geometryData.vertexCount * 2;
        if (geometryData.textureCoordinates == null) {
            geometryData.textureCoordinates = new float[n];
        } else if (geometryData.textureCoordinates.length < n) {
            throw new InvalidArraySizeException("3D Texture coordinates", geometryData.textureCoordinates.length, n);
        }
        float[] fArray = geometryData.textureCoordinates;
    }

    private final void regenerateCurve() {
        int n;
        if (!this.curveChanged) {
            return;
        }
        this.curveChanged = false;
        this.numCurveValues = (this.facetCount + 1) * 3;
        if (this.curveCoordinates == null || this.numCurveValues > this.curveCoordinates.length) {
            this.curveCoordinates = new float[this.numCurveValues];
        }
        int n2 = 0;
        float f = 1.0f / (float)this.facetCount;
        for (n = 0; n < this.facetCount; ++n) {
            this.calcSinglePoint((float)n * f, n2);
            n2 += 3;
        }
        n = this.numControlPoints * 3;
        this.curveCoordinates[this.numCurveValues - 3] = this.controlPointCoordinates[n - 3];
        this.curveCoordinates[this.numCurveValues - 2] = this.controlPointCoordinates[n - 2];
        this.curveCoordinates[this.numCurveValues - 1] = this.controlPointCoordinates[n - 1];
    }

    private void calcSinglePoint(float f, int n) {
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        double d = 1.0;
        double d2 = Math.pow(1.0f - f, this.numControlPoints - 1);
        for (int i = 0; i < this.numControlPoints; ++i) {
            int n2 = this.numControlPoints - 1;
            int n3 = i;
            int n4 = this.numControlPoints - 1 - i;
            double d3 = d * d2;
            d *= (double)f;
            d2 /= (double)(1.0f - f);
            while (n2 >= 1) {
                d3 *= (double)n2;
                --n2;
                if (n3 > 1) {
                    d3 /= (double)n3;
                    --n3;
                }
                if (n4 <= 1) continue;
                d3 /= (double)n4;
                --n4;
            }
            f2 = (float)((double)f2 + (double)this.controlPointCoordinates[i * 3] * d3);
            f3 = (float)((double)f3 + (double)this.controlPointCoordinates[i * 3 + 1] * d3);
            f4 = (float)((double)f4 + (double)this.controlPointCoordinates[i * 3 + 2] * d3);
        }
        this.curveCoordinates[n] = f2;
        this.curveCoordinates[n + 1] = f3;
        this.curveCoordinates[n + 2] = f4;
    }
}

