//============================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//============================================================================
#ifndef vtk_m_thirdparty_diy_serialization_h
#define vtk_m_thirdparty_diy_serialization_h

#include <vtkm/thirdparty/diy/Configure.h>

#if VTKM_USE_EXTERNAL_DIY
#define VTKM_DIY_INCLUDE(header) <diy/header>
#else
#define VTKM_DIY_INCLUDE(header) <vtkmdiy/include/vtkmdiy/header>
#define diy vtkmdiy // mangle namespace diy (see below comments)
#endif

// clang-format off
VTKM_THIRDPARTY_PRE_INCLUDE
#include VTKM_DIY_INCLUDE(serialization.hpp)
#undef VTKM_DIY_INCLUDE
VTKM_THIRDPARTY_POST_INCLUDE
// clang-format on

// When using an external DIY
// We need to alias the diy namespace to
// vtkmdiy so that VTK-m uses it properly
#if VTKM_USE_EXTERNAL_DIY
namespace vtkmdiy = ::diy;

#else
// The aliasing approach fails for when we
// want to us an internal version since
// the diy namespace already points to the
// external version. Instead we use macro
// replacement to make sure all diy classes
// are placed in vtkmdiy placed
#undef diy // mangle namespace diy

#endif

#endif
