#include "Platform.h"
#include <string.h>
#include <stdio.h>
#include "MKTReader.h"
#include "BaseCommunication.h"

#define base CSYOReader

CMKTReader::CMKTReader(CReader *Owner, CBaseCommunication *Communicator)
	:base(Owner, Communicator)
{
}

CMKTReader::~CMKTReader(void)
{
}




void CMKTReader::SetHWString(char *String)
{
	strcpy(String, "MKT_");
}

void CMKTReader::GetProductString(uint8_t *Product)
{
	memcpy(Product, "CJMKT", 5);
}

void CMKTReader::CompressModifyStructure(CCID_Message& Message)
{
	if (Message.Data.Secure.Data.Modify.bNumberMessage == 0)
	{
		memmove(&(Message.Data.Secure.Data.Modify.bMsgIndex2), Message.Data.Secure.Data.Modify.bTeoPrologue, Message.dwLength - 17);
		Message.dwLength -= 2;
	}
	else if (Message.Data.Secure.Data.Modify.bNumberMessage != 3)
	{
		memmove(&(Message.Data.Secure.Data.Modify.bMsgIndex3), Message.Data.Secure.Data.Modify.bTeoPrologue, Message.dwLength - 17);
		Message.dwLength -= 1;
	}
}

