/* 
 */

/*

    Copyright (C) 2014 Ferrero Andrea

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program. If not, see <http://www.gnu.org/licenses/>.


 */

/*

    These files are distributed with PhotoFlow - http://aferrero2707.github.io/PhotoFlow/

 */

#ifndef VIPS_PROCESSOR_H
#define VIPS_PROCESSOR_H


#include "operation.hh"
#include "blender.hh"
#include "photoflow.hh"


namespace PF
{


  class ProcessorBase
  {
    OpParBase* op_par_base;
  public:
    ProcessorBase(OpParBase* p): op_par_base(p) {}
    virtual ~ProcessorBase() 
    {
      //std::cout<<"~ProcessorBase(): deleting "<<(void*)op_par_base<<std::endl;
      //delete op_par_base;
      //std::cout<<"~ProcessorBase(): "<<(void*)op_par_base<<" deleted"<<std::endl;
    }


    OpParBase* get_par() { return op_par_base; }

    virtual void process(VipsRegion** in, int n, int in_first,
			 VipsRegion* imap, VipsRegion* omap, 
			 VipsRegion* out) = 0;  
  };
}


#endif /*VIPS_PARITHMETIC_H*/


