<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="1.0">

<!-- 
     This file contains templates for upgrading DigImageML files from
     DTD version 0.02 to PhotoML DTD version 0.10.

     Copyright © 2005 Brendt Wohlberg <photoml@wohlberg.net>

     This is free software; you can redistribute it and/or modify it 
     under the terms of version 2 of the GNU General Public License 
     at http://www.gnu.org/licenses/gpl-2.0.txt.

     This software is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the 
     GNU General Public License for more details.
-->

<xsl:output method="xml" indent="yes"
            doctype-public="-//BW//DTD PhotoML 0.10//EN"
            doctype-system="photo.dtd"/>


<!-- Default template -->
<xsl:template match="@*|*|text()|comment()">
  <xsl:copy>
    <xsl:apply-templates select="@*|*|text()|comment()"/>
  </xsl:copy>
</xsl:template>


<!-- Handle changes to top level element -->
<xsl:template match="digimage">
  <photo>
    <xsl:apply-templates/>
  </photo>
</xsl:template>


<!-- Handle changes to image element -->
<xsl:template match="image">
  <digimage>
    <xsl:apply-templates select="@*|*|text()|comment()"/>
  </digimage>
</xsl:template>


<!-- Handle changes to format element -->
<xsl:template match="format">
  <fileformat>
    <xsl:choose>
      <xsl:when test=".='BMP' or .='JPEG' or .='J2K' or .='PNG' or .='PSD' or .='TIFF'">
        <xsl:attribute name="std">
          <xsl:value-of select="translate(.,'BDEFGIJKMNPST','bdefgijkmnpst')"/>
        </xsl:attribute>
      </xsl:when>
      <xsl:otherwise>
        <xsl:apply-templates select="@*|*|text()|comment()"/>
      </xsl:otherwise>
    </xsl:choose>
  </fileformat>
</xsl:template>


<!-- Handle changes to hash element -->
<xsl:template match="hash">
  <image-hash>
    <xsl:apply-templates select="@*|*|text()|comment()"/>
  </image-hash>
</xsl:template>


</xsl:stylesheet>
