/*
 * Copyright (c) 1994 Cygnus Support.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * and/or other materials related to such
 * distribution and use acknowledge that the software was developed
 * at Cygnus Support, Inc.  Cygnus Support, Inc. may not be used to
 * endorse or promote products derived from this software without
 * specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */
#include "test.h"
 one_line_type sinhf_vec[] = {
{36, 0,123,__LINE__, 0xbff826c1, 0x0a6e4b4b, 0xbff33333, 0x33333333},	/* -1.50946=f(-1.2)*/
{36, 0,123,__LINE__, 0xbff7dce5, 0xc81d8706, 0xbff30a3d, 0x70a3d70a},	/* -1.49143=f(-1.19)*/
{35, 0,123,__LINE__, 0xbff793a6, 0xb057853c, 0xbff2e147, 0xae147ae1},	/* -1.47355=f(-1.18)*/
{36, 0,123,__LINE__, 0xbff74b02, 0x5586d3a4, 0xbff2b851, 0xeb851eb8},	/* -1.45581=f(-1.17)*/
{38, 0,123,__LINE__, 0xbff702f6, 0xa2239e23, 0xbff28f5c, 0x28f5c28f},	/* -1.43822=f(-1.16)*/
{34, 0,123,__LINE__, 0xbff6bb81, 0xbe047ac7, 0xbff26666, 0x66666666},	/* -1.42078=f(-1.15)*/
{35, 0,123,__LINE__, 0xbff674a1, 0xd4dc59d3, 0xbff23d70, 0xa3d70a3d},	/* -1.40347=f(-1.14)*/
{36, 0,123,__LINE__, 0xbff62e55, 0x162e88aa, 0xbff2147a, 0xe147ae14},	/* -1.38631=f(-1.13)*/
{36, 0,123,__LINE__, 0xbff5e899, 0xb542cdba, 0xbff1eb85, 0x1eb851eb},	/* -1.36929=f(-1.12)*/
{35, 0,123,__LINE__, 0xbff5a36d, 0xe9199d17, 0xbff1c28f, 0x5c28f5c2},	/* -1.3524=f(-1.11)*/
{35, 0,123,__LINE__, 0xbff55ecf, 0xec60657d, 0xbff19999, 0x99999999},	/* -1.33565=f(-1.1)*/
{38, 0,123,__LINE__, 0xbff51abd, 0xfd65f565, 0xbff170a3, 0xd70a3d70},	/* -1.31903=f(-1.09)*/
{39, 0,123,__LINE__, 0xbff4d736, 0x5e0ef7e2, 0xbff147ae, 0x147ae147},	/* -1.30254=f(-1.08)*/
{35, 0,123,__LINE__, 0xbff49437, 0x53ca8908, 0xbff11eb8, 0x51eb851e},	/* -1.28619=f(-1.07)*/
{35, 0,123,__LINE__, 0xbff451be, 0xf3cd38e2, 0xbff0f5c2, 0x8f5c28f5},	/* -1.26996=f(-1.06)*/
{35, 0,123,__LINE__, 0xbff40fcb, 0xf253d039, 0xbff0cccc, 0xcccccccc},	/* -1.25386=f(-1.05)*/
{35, 0,123,__LINE__, 0xbff3ce5c, 0x6b06c623, 0xbff0a3d7, 0x0a3d70a3},	/* -1.23788=f(-1.04)*/
{36, 0,123,__LINE__, 0xbff38d6e, 0xb10e94cd, 0xbff07ae1, 0x47ae147a},	/* -1.22203=f(-1.03)*/
{37, 0,123,__LINE__, 0xbff34d01, 0x1ae66389, 0xbff051eb, 0x851eb851},	/* -1.2063=f(-1.02)*/
{38, 0,123,__LINE__, 0xbff30d12, 0x02512219, 0xbff028f5, 0xc28f5c28},	/* -1.19069=f(-1.01)*/
{37, 0,123,__LINE__, 0xbff2cd9f, 0xc44eb982, 0xbfefffff, 0xfffffffe},	/* -1.1752=f(-1)*/
{39, 0,123,__LINE__, 0xbff28ea8, 0xc111520b, 0xbfefae14, 0x7ae147ac},	/* -1.15983=f(-0.99)*/
{37, 0,123,__LINE__, 0xbff2502b, 0x5bf2ae39, 0xbfef5c28, 0xf5c28f5a},	/* -1.14457=f(-0.98)*/
{37, 0,123,__LINE__, 0xbff21225, 0xfb699a70, 0xbfef0a3d, 0x70a3d708},	/* -1.12943=f(-0.97)*/
{36, 0,123,__LINE__, 0xbff1d496, 0xf10a85c0, 0xbfeeb851, 0xeb851eb6},	/* -1.1144=f(-0.96)*/
{37, 0,123,__LINE__, 0xbff1977c, 0xd97e1e2e, 0xbfee6666, 0x66666664},	/* -1.09948=f(-0.95)*/
{36, 0,123,__LINE__, 0xbff15ad6, 0x0c30d82e, 0xbfee147a, 0xe147ae12},	/* -1.08468=f(-0.94)*/
{37, 0,123,__LINE__, 0xbff11ea0, 0xfba59956, 0xbfedc28f, 0x5c28f5c0},	/* -1.06998=f(-0.93)*/
{38, 0,123,__LINE__, 0xbff0e2dc, 0x1d48ac07, 0xbfed70a3, 0xd70a3d6e},	/* -1.05539=f(-0.92)*/
{36, 0,123,__LINE__, 0xbff0a785, 0xe965a58c, 0xbfed1eb8, 0x51eb851c},	/* -1.0409=f(-0.91)*/
{37, 0,123,__LINE__, 0xbff06c9c, 0xc42f72fa, 0xbfeccccc, 0xccccccca},	/* -1.02652=f(-0.9)*/
{37, 0,123,__LINE__, 0xbff0321f, 0x5997d584, 0xbfec7ae1, 0x47ae1478},	/* -1.01224=f(-0.89)*/
{37, 0,123,__LINE__, 0xbfeff018, 0x26684115, 0xbfec28f5, 0xc28f5c26},	/* -0.998058=f(-0.88)*/
{36, 0,123,__LINE__, 0xbfef7cc2, 0xe8d30ee2, 0xbfebd70a, 0x3d70a3d4},	/* -0.98398=f(-0.87)*/
{37, 0,123,__LINE__, 0xbfef0a3c, 0x0696384b, 0xbfeb851e, 0xb851eb82},	/* -0.969999=f(-0.86)*/
{35, 0,123,__LINE__, 0xbfee9880, 0x912044af, 0xbfeb3333, 0x33333330},	/* -0.956116=f(-0.85)*/
{36, 0,123,__LINE__, 0xbfee278d, 0x731cc7dd, 0xbfeae147, 0xae147ade},	/* -0.942328=f(-0.84)*/
{40, 0,123,__LINE__, 0xbfedb760, 0x208e7006, 0xbfea8f5c, 0x28f5c28c},	/* -0.928635=f(-0.83)*/
{36, 0,123,__LINE__, 0xbfed47f5, 0x8e044cc6, 0xbfea3d70, 0xa3d70a3a},	/* -0.915034=f(-0.82)*/
{39, 0,123,__LINE__, 0xbfecd94a, 0xe14fa2c5, 0xbfe9eb85, 0x1eb851e8},	/* -0.901525=f(-0.81)*/
{37, 0,123,__LINE__, 0xbfec6b5d, 0x452b57cf, 0xbfe99999, 0x99999996},	/* -0.888106=f(-0.8)*/
{36, 0,123,__LINE__, 0xbfebfe29, 0xe92961a9, 0xbfe947ae, 0x147ae144},	/* -0.874776=f(-0.79)*/
{36, 0,123,__LINE__, 0xbfeb91ad, 0xd763639f, 0xbfe8f5c2, 0x8f5c28f2},	/* -0.861533=f(-0.78)*/
{38, 0,123,__LINE__, 0xbfeb25e6, 0x9da229e4, 0xbfe8a3d7, 0x0a3d70a0},	/* -0.848377=f(-0.77)*/
{35, 0,123,__LINE__, 0xbfeabad1, 0x4f0aa07a, 0xbfe851eb, 0x851eb84e},	/* -0.835305=f(-0.76)*/
{36, 0,123,__LINE__, 0xbfea506b, 0x2dd3c690, 0xbfe7ffff, 0xfffffffc},	/* -0.822317=f(-0.75)*/
{40, 0,123,__LINE__, 0xbfe9e6b1, 0x80b0a7e0, 0xbfe7ae14, 0x7ae147aa},	/* -0.809411=f(-0.74)*/
{36, 0,123,__LINE__, 0xbfe97da1, 0x92be82d9, 0xbfe75c28, 0xf5c28f58},	/* -0.796586=f(-0.73)*/
{36, 0,123,__LINE__, 0xbfe91538, 0xb3730bad, 0xbfe70a3d, 0x70a3d706},	/* -0.783841=f(-0.72)*/
{36, 0,123,__LINE__, 0xbfe8ad74, 0x0e21cb27, 0xbfe6b851, 0xeb851eb4},	/* -0.771174=f(-0.71)*/
{36, 0,123,__LINE__, 0xbfe84651, 0x4bcd45b4, 0xbfe66666, 0x66666662},	/* -0.758584=f(-0.7)*/
{43, 0,123,__LINE__, 0xbfe7dfcd, 0x9fe28d58, 0xbfe6147a, 0xe147ae10},	/* -0.74607=f(-0.69)*/
{36, 0,123,__LINE__, 0xbfe779e6, 0x6a8a0085, 0xbfe5c28f, 0x5c28f5be},	/* -0.73363=f(-0.68)*/
{36, 0,123,__LINE__, 0xbfe71499, 0x0fed64ff, 0xbfe570a3, 0xd70a3d6c},	/* -0.721264=f(-0.67)*/
{37, 0,123,__LINE__, 0xbfe6afe2, 0xf826cf19, 0xbfe51eb8, 0x51eb851a},	/* -0.708971=f(-0.66)*/
{36, 0,123,__LINE__, 0xbfe64bc1, 0x682f47f1, 0xbfe4cccc, 0xccccccc8},	/* -0.696747=f(-0.65)*/
{39, 0,123,__LINE__, 0xbfe5e832, 0x1e07e76d, 0xbfe47ae1, 0x47ae1476},	/* -0.684594=f(-0.64)*/
{37, 0,123,__LINE__, 0xbfe58532, 0x65fc2bab, 0xbfe428f5, 0xc28f5c24},	/* -0.672509=f(-0.63)*/
{36, 0,123,__LINE__, 0xbfe522bf, 0xb73e6ac5, 0xbfe3d70a, 0x3d70a3d2},	/* -0.660492=f(-0.62)*/
{36, 0,123,__LINE__, 0xbfe4c0d7, 0x8c9d4813, 0xbfe3851e, 0xb851eb80},	/* -0.64854=f(-0.61)*/
{37, 0,123,__LINE__, 0xbfe45f77, 0x64732fcc, 0xbfe33333, 0x3333332e},	/* -0.636654=f(-0.6)*/
{37, 0,123,__LINE__, 0xbfe3fe9c, 0x9ada40af, 0xbfe2e147, 0xae147adc},	/* -0.624831=f(-0.59)*/
{40, 0,123,__LINE__, 0xbfe39e45, 0x00bd4edf, 0xbfe28f5c, 0x28f5c28a},	/* -0.61307=f(-0.58)*/
{37, 0,123,__LINE__, 0xbfe33e6d, 0xf8c899e6, 0xbfe23d70, 0xa3d70a38},	/* -0.601371=f(-0.57)*/
{36, 0,123,__LINE__, 0xbfe2df15, 0x0ee251a8, 0xbfe1eb85, 0x1eb851e6},	/* -0.589732=f(-0.56)*/
{36, 0,123,__LINE__, 0xbfe28037, 0xd22b2d4d, 0xbfe19999, 0x99999994},	/* -0.578152=f(-0.55)*/
{36, 0,123,__LINE__, 0xbfe221d3, 0xd4ee6c0c, 0xbfe147ae, 0x147ae142},	/* -0.566629=f(-0.54)*/
{37, 0,123,__LINE__, 0xbfe1c3e6, 0x87f82a0f, 0xbfe0f5c2, 0x8f5c28f0},	/* -0.555164=f(-0.53)*/
{36, 0,123,__LINE__, 0xbfe1666d, 0xcd198ff9, 0xbfe0a3d7, 0x0a3d709e},	/* -0.543754=f(-0.52)*/
{37, 0,123,__LINE__, 0xbfe10967, 0x1af69546, 0xbfe051eb, 0x851eb84c},	/* -0.532398=f(-0.51)*/
{36, 0,123,__LINE__, 0xbfe0acd0, 0x0fe63b97, 0xbfdfffff, 0xfffffff4},	/* -0.521095=f(-0.5)*/
{36, 0,123,__LINE__, 0xbfe050a6, 0x4d1b3fca, 0xbfdf5c28, 0xf5c28f50},	/* -0.509845=f(-0.49)*/
{36, 0,123,__LINE__, 0xbfdfe9ce, 0xc9672827, 0xbfdeb851, 0xeb851eac},	/* -0.498645=f(-0.48)*/
{38, 0,123,__LINE__, 0xbfdf3322, 0x42822080, 0xbfde147a, 0xe147ae08},	/* -0.487496=f(-0.47)*/
{36, 0,123,__LINE__, 0xbfde7d42, 0x346e2690, 0xbfdd70a3, 0xd70a3d64},	/* -0.476395=f(-0.46)*/
{36, 0,123,__LINE__, 0xbfddc829, 0xd3edc251, 0xbfdccccc, 0xccccccc0},	/* -0.465342=f(-0.45)*/
{37, 0,123,__LINE__, 0xbfdd13d4, 0xc4e94514, 0xbfdc28f5, 0xc28f5c1c},	/* -0.454335=f(-0.44)*/
{37, 0,123,__LINE__, 0xbfdc603e, 0x46194e38, 0xbfdb851e, 0xb851eb78},	/* -0.443374=f(-0.43)*/
{37, 0,123,__LINE__, 0xbfdbad61, 0x9bac424b, 0xbfdae147, 0xae147ad4},	/* -0.432457=f(-0.42)*/
{36, 0,123,__LINE__, 0xbfdafb3a, 0x774de991, 0xbfda3d70, 0xa3d70a30},	/* -0.421584=f(-0.41)*/
{37, 0,123,__LINE__, 0xbfda49c4, 0x26704970, 0xbfd99999, 0x9999998c},	/* -0.410752=f(-0.4)*/
{37, 0,123,__LINE__, 0xbfd998f9, 0xfb9669ab, 0xbfd8f5c2, 0x8f5c28e8},	/* -0.399962=f(-0.39)*/
{36, 0,123,__LINE__, 0xbfd8e8d7, 0xb5318a9c, 0xbfd851eb, 0x851eb844},	/* -0.389212=f(-0.38)*/
{36, 0,123,__LINE__, 0xbfd83958, 0xae5800c8, 0xbfd7ae14, 0x7ae147a0},	/* -0.3785=f(-0.37)*/
{36, 0,123,__LINE__, 0xbfd78a78, 0x68e6249e, 0xbfd70a3d, 0x70a3d6fc},	/* -0.367827=f(-0.36)*/
{36, 0,123,__LINE__, 0xbfd6dc32, 0x48cdd492, 0xbfd66666, 0x66666658},	/* -0.35719=f(-0.35)*/
{38, 0,123,__LINE__, 0xbfd62e82, 0x1c018e85, 0xbfd5c28f, 0x5c28f5b4},	/* -0.346589=f(-0.34)*/
{36, 0,123,__LINE__, 0xbfd58163, 0x4e1e6ed3, 0xbfd51eb8, 0x51eb8510},	/* -0.336022=f(-0.33)*/
{36, 0,123,__LINE__, 0xbfd4d4d1, 0x4eebdaeb, 0xbfd47ae1, 0x47ae146c},	/* -0.325489=f(-0.32)*/
{36, 0,123,__LINE__, 0xbfd428c7, 0xf6dc2e7d, 0xbfd3d70a, 0x3d70a3c8},	/* -0.314989=f(-0.31)*/
{38, 0,123,__LINE__, 0xbfd37d42, 0xbcb616a7, 0xbfd33333, 0x33333324},	/* -0.30452=f(-0.3)*/
{37, 0,123,__LINE__, 0xbfd2d23d, 0x1b095232, 0xbfd28f5c, 0x28f5c280},	/* -0.294082=f(-0.29)*/
{36, 0,123,__LINE__, 0xbfd227b2, 0xf3d30af2, 0xbfd1eb85, 0x1eb851dc},	/* -0.283673=f(-0.28)*/
{37, 0,123,__LINE__, 0xbfd17d9f, 0xc7f7ede1, 0xbfd147ae, 0x147ae138},	/* -0.273292=f(-0.27)*/
{37, 0,123,__LINE__, 0xbfd0d3ff, 0x1bc5617f, 0xbfd0a3d7, 0x0a3d7094},	/* -0.262939=f(-0.26)*/
{37, 0,123,__LINE__, 0xbfd02acc, 0xd9d08102, 0xbfcfffff, 0xffffffe0},	/* -0.252612=f(-0.25)*/
{36, 0,123,__LINE__, 0xbfcf0408, 0xf73869c7, 0xbfceb851, 0xeb851e98},	/* -0.242311=f(-0.24)*/
{44, 0,123,__LINE__, 0xbfcdb343, 0x9ff70491, 0xbfcd70a3, 0xd70a3d50},	/* -0.232033=f(-0.23)*/
{36, 0,123,__LINE__, 0xbfcc6340, 0xcd010ea1, 0xbfcc28f5, 0xc28f5c08},	/* -0.221779=f(-0.22)*/
{37, 0,123,__LINE__, 0xbfcb13f8, 0x052953cc, 0xbfcae147, 0xae147ac0},	/* -0.211547=f(-0.21)*/
{36, 0,123,__LINE__, 0xbfc9c560, 0xd3bd3683, 0xbfc99999, 0x99999978},	/* -0.201336=f(-0.2)*/
{37, 0,123,__LINE__, 0xbfc87772, 0x6697e012, 0xbfc851eb, 0x851eb830},	/* -0.191145=f(-0.19)*/
{36, 0,123,__LINE__, 0xbfc72a24, 0x727a917e, 0xbfc70a3d, 0x70a3d6e8},	/* -0.180974=f(-0.18)*/
{36, 0,123,__LINE__, 0xbfc5dd6e, 0x2dee7b97, 0xbfc5c28f, 0x5c28f5a0},	/* -0.17082=f(-0.17)*/
{36, 0,123,__LINE__, 0xbfc49147, 0x350c990c, 0xbfc47ae1, 0x47ae1458},	/* -0.160684=f(-0.16)*/
{37, 0,123,__LINE__, 0xbfc345a7, 0x2761067a, 0xbfc33333, 0x33333310},	/* -0.150563=f(-0.15)*/
{37, 0,123,__LINE__, 0xbfc1fa85, 0x46ca5781, 0xbfc1eb85, 0x1eb851c8},	/* -0.140458=f(-0.14)*/
{37, 0,123,__LINE__, 0xbfc0afd9, 0x3990890c, 0xbfc0a3d7, 0x0a3d7080},	/* -0.130366=f(-0.13)*/
{36, 0,123,__LINE__, 0xbfbecb35, 0x316874ec, 0xbfbeb851, 0xeb851e71},	/* -0.120288=f(-0.12)*/
{40, 0,123,__LINE__, 0xbfbc3781, 0xbf7c84bb, 0xbfbc28f5, 0xc28f5be2},	/* -0.110222=f(-0.11)*/
{37, 0,123,__LINE__, 0xbfb9a487, 0x39e9f300, 0xbfb99999, 0x99999953},	/* -0.100167=f(-0.1)*/
{39, 0,123,__LINE__, 0xbfb71234, 0xc1f95d61, 0xbfb70a3d, 0x70a3d6c4},	/* -0.0901216=f(-0.09)*/
{38, 0,123,__LINE__, 0xbfb48079, 0x5d2683dc, 0xbfb47ae1, 0x47ae1435},	/* -0.0800854=f(-0.08)*/
{36, 0,123,__LINE__, 0xbfb1ef44, 0x7520e5cf, 0xbfb1eb85, 0x1eb851a6},	/* -0.0700572=f(-0.07)*/
{36, 0,123,__LINE__, 0xbfaebd0a, 0x0d4ac833, 0xbfaeb851, 0xeb851e2d},	/* -0.060036=f(-0.06)*/
{38, 0,123,__LINE__, 0xbfa99c54, 0xc35980c7, 0xbfa99999, 0x9999990e},	/* -0.0500208=f(-0.05)*/
{36, 0,123,__LINE__, 0xbfa47c47, 0x314b0eb7, 0xbfa47ae1, 0x47ae13ef},	/* -0.0400107=f(-0.04)*/
{40, 0,123,__LINE__, 0xbf9eb97f, 0xe0e298a5, 0xbf9eb851, 0xeb851da0},	/* -0.0300045=f(-0.03)*/
{37, 0,123,__LINE__, 0xbf947b3a, 0xbaf2e768, 0xbf947ae1, 0x47ae1362},	/* -0.0200013=f(-0.02)*/
{39, 0,123,__LINE__, 0xbf847af7, 0x9ea6bc49, 0xbf847ae1, 0x47ae1249},	/* -0.0100002=f(-0.01)*/
{64, 0,123,__LINE__, 0x3cd19000, 0x00000000, 0x3cd19000, 0x00000000},	/* 9.74915e-16=f(9.74915e-16)*/
{39, 0,123,__LINE__, 0x3f847af7, 0x9ea6bc49, 0x3f847ae1, 0x47ae16ad},	/* 0.0100002=f(0.01)*/
{37, 0,123,__LINE__, 0x3f947b3a, 0xbaf2e768, 0x3f947ae1, 0x47ae1594},	/* 0.0200013=f(0.02)*/
{40, 0,123,__LINE__, 0x3f9eb97f, 0xe0e298a5, 0x3f9eb851, 0xeb851fd2},	/* 0.0300045=f(0.03)*/
{36, 0,123,__LINE__, 0x3fa47c47, 0x314b0eb7, 0x3fa47ae1, 0x47ae1508},	/* 0.0400107=f(0.04)*/
{38, 0,123,__LINE__, 0x3fa99c54, 0xc35980c7, 0x3fa99999, 0x99999a27},	/* 0.0500208=f(0.05)*/
{36, 0,123,__LINE__, 0x3faebd0a, 0x0d4ac833, 0x3faeb851, 0xeb851f46},	/* 0.060036=f(0.06)*/
{36, 0,123,__LINE__, 0x3fb1ef44, 0x7520e5cf, 0x3fb1eb85, 0x1eb85232},	/* 0.0700572=f(0.07)*/
{38, 0,123,__LINE__, 0x3fb48079, 0x5d2683dc, 0x3fb47ae1, 0x47ae14c1},	/* 0.0800854=f(0.08)*/
{39, 0,123,__LINE__, 0x3fb71234, 0xc1f95d61, 0x3fb70a3d, 0x70a3d750},	/* 0.0901216=f(0.09)*/
{37, 0,123,__LINE__, 0x3fb9a487, 0x39e9f300, 0x3fb99999, 0x999999df},	/* 0.100167=f(0.1)*/
{40, 0,123,__LINE__, 0x3fbc3781, 0xbf7c84bb, 0x3fbc28f5, 0xc28f5c6e},	/* 0.110222=f(0.11)*/
{36, 0,123,__LINE__, 0x3fbecb35, 0x316874ec, 0x3fbeb851, 0xeb851efd},	/* 0.120288=f(0.12)*/
{37, 0,123,__LINE__, 0x3fc0afd9, 0x3990890c, 0x3fc0a3d7, 0x0a3d70c6},	/* 0.130366=f(0.13)*/
{37, 0,123,__LINE__, 0x3fc1fa85, 0x46ca5781, 0x3fc1eb85, 0x1eb8520e},	/* 0.140458=f(0.14)*/
{37, 0,123,__LINE__, 0x3fc345a7, 0x2761067a, 0x3fc33333, 0x33333356},	/* 0.150563=f(0.15)*/
{36, 0,123,__LINE__, 0x3fc49147, 0x350c990c, 0x3fc47ae1, 0x47ae149e},	/* 0.160684=f(0.16)*/
{36, 0,123,__LINE__, 0x3fc5dd6e, 0x2dee7b97, 0x3fc5c28f, 0x5c28f5e6},	/* 0.17082=f(0.17)*/
{36, 0,123,__LINE__, 0x3fc72a24, 0x727a917e, 0x3fc70a3d, 0x70a3d72e},	/* 0.180974=f(0.18)*/
{37, 0,123,__LINE__, 0x3fc87772, 0x6697e012, 0x3fc851eb, 0x851eb876},	/* 0.191145=f(0.19)*/
{36, 0,123,__LINE__, 0x3fc9c560, 0xd3bd3683, 0x3fc99999, 0x999999be},	/* 0.201336=f(0.2)*/
{37, 0,123,__LINE__, 0x3fcb13f8, 0x052953cc, 0x3fcae147, 0xae147b06},	/* 0.211547=f(0.21)*/
{36, 0,123,__LINE__, 0x3fcc6340, 0xcd010ea1, 0x3fcc28f5, 0xc28f5c4e},	/* 0.221779=f(0.22)*/
{44, 0,123,__LINE__, 0x3fcdb343, 0x9ff70491, 0x3fcd70a3, 0xd70a3d96},	/* 0.232033=f(0.23)*/
{36, 0,123,__LINE__, 0x3fcf0408, 0xf73869c7, 0x3fceb851, 0xeb851ede},	/* 0.242311=f(0.24)*/
{37, 0,123,__LINE__, 0x3fd02acc, 0xd9d08102, 0x3fd00000, 0x00000013},	/* 0.252612=f(0.25)*/
{37, 0,123,__LINE__, 0x3fd0d3ff, 0x1bc5617f, 0x3fd0a3d7, 0x0a3d70b7},	/* 0.262939=f(0.26)*/
{37, 0,123,__LINE__, 0x3fd17d9f, 0xc7f7ede1, 0x3fd147ae, 0x147ae15b},	/* 0.273292=f(0.27)*/
{36, 0,123,__LINE__, 0x3fd227b2, 0xf3d30af2, 0x3fd1eb85, 0x1eb851ff},	/* 0.283673=f(0.28)*/
{37, 0,123,__LINE__, 0x3fd2d23d, 0x1b095232, 0x3fd28f5c, 0x28f5c2a3},	/* 0.294082=f(0.29)*/
{38, 0,123,__LINE__, 0x3fd37d42, 0xbcb616a7, 0x3fd33333, 0x33333347},	/* 0.30452=f(0.3)*/
{36, 0,123,__LINE__, 0x3fd428c7, 0xf6dc2e7d, 0x3fd3d70a, 0x3d70a3eb},	/* 0.314989=f(0.31)*/
{36, 0,123,__LINE__, 0x3fd4d4d1, 0x4eebdaeb, 0x3fd47ae1, 0x47ae148f},	/* 0.325489=f(0.32)*/
{36, 0,123,__LINE__, 0x3fd58163, 0x4e1e6ed3, 0x3fd51eb8, 0x51eb8533},	/* 0.336022=f(0.33)*/
{38, 0,123,__LINE__, 0x3fd62e82, 0x1c018e85, 0x3fd5c28f, 0x5c28f5d7},	/* 0.346589=f(0.34)*/
{36, 0,123,__LINE__, 0x3fd6dc32, 0x48cdd492, 0x3fd66666, 0x6666667b},	/* 0.35719=f(0.35)*/
{36, 0,123,__LINE__, 0x3fd78a78, 0x68e6249e, 0x3fd70a3d, 0x70a3d71f},	/* 0.367827=f(0.36)*/
{36, 0,123,__LINE__, 0x3fd83958, 0xae5800c8, 0x3fd7ae14, 0x7ae147c3},	/* 0.3785=f(0.37)*/
{36, 0,123,__LINE__, 0x3fd8e8d7, 0xb5318a9c, 0x3fd851eb, 0x851eb867},	/* 0.389212=f(0.38)*/
{37, 0,123,__LINE__, 0x3fd998f9, 0xfb9669ab, 0x3fd8f5c2, 0x8f5c290b},	/* 0.399962=f(0.39)*/
{37, 0,123,__LINE__, 0x3fda49c4, 0x26704970, 0x3fd99999, 0x999999af},	/* 0.410752=f(0.4)*/
{36, 0,123,__LINE__, 0x3fdafb3a, 0x774de991, 0x3fda3d70, 0xa3d70a53},	/* 0.421584=f(0.41)*/
{37, 0,123,__LINE__, 0x3fdbad61, 0x9bac424b, 0x3fdae147, 0xae147af7},	/* 0.432457=f(0.42)*/
{37, 0,123,__LINE__, 0x3fdc603e, 0x46194e38, 0x3fdb851e, 0xb851eb9b},	/* 0.443374=f(0.43)*/
{37, 0,123,__LINE__, 0x3fdd13d4, 0xc4e94514, 0x3fdc28f5, 0xc28f5c3f},	/* 0.454335=f(0.44)*/
{36, 0,123,__LINE__, 0x3fddc829, 0xd3edc251, 0x3fdccccc, 0xcccccce3},	/* 0.465342=f(0.45)*/
{36, 0,123,__LINE__, 0x3fde7d42, 0x346e2690, 0x3fdd70a3, 0xd70a3d87},	/* 0.476395=f(0.46)*/
{38, 0,123,__LINE__, 0x3fdf3322, 0x42822080, 0x3fde147a, 0xe147ae2b},	/* 0.487496=f(0.47)*/
{36, 0,123,__LINE__, 0x3fdfe9ce, 0xc9672827, 0x3fdeb851, 0xeb851ecf},	/* 0.498645=f(0.48)*/
{36, 0,123,__LINE__, 0x3fe050a6, 0x4d1b3fca, 0x3fdf5c28, 0xf5c28f73},	/* 0.509845=f(0.49)*/
{36, 0,123,__LINE__, 0x3fe0acd0, 0x0fe63b97, 0x3fe00000, 0x0000000b},	/* 0.521095=f(0.5)*/
{37, 0,123,__LINE__, 0x3fe10967, 0x1af69546, 0x3fe051eb, 0x851eb85d},	/* 0.532398=f(0.51)*/
{36, 0,123,__LINE__, 0x3fe1666d, 0xcd198ff9, 0x3fe0a3d7, 0x0a3d70af},	/* 0.543754=f(0.52)*/
{37, 0,123,__LINE__, 0x3fe1c3e6, 0x87f82a0f, 0x3fe0f5c2, 0x8f5c2901},	/* 0.555164=f(0.53)*/
{36, 0,123,__LINE__, 0x3fe221d3, 0xd4ee6c0c, 0x3fe147ae, 0x147ae153},	/* 0.566629=f(0.54)*/
{36, 0,123,__LINE__, 0x3fe28037, 0xd22b2d4d, 0x3fe19999, 0x999999a5},	/* 0.578152=f(0.55)*/
{36, 0,123,__LINE__, 0x3fe2df15, 0x0ee251a8, 0x3fe1eb85, 0x1eb851f7},	/* 0.589732=f(0.56)*/
{37, 0,123,__LINE__, 0x3fe33e6d, 0xf8c899e6, 0x3fe23d70, 0xa3d70a49},	/* 0.601371=f(0.57)*/
{40, 0,123,__LINE__, 0x3fe39e45, 0x00bd4edf, 0x3fe28f5c, 0x28f5c29b},	/* 0.61307=f(0.58)*/
{37, 0,123,__LINE__, 0x3fe3fe9c, 0x9ada40af, 0x3fe2e147, 0xae147aed},	/* 0.624831=f(0.59)*/
{37, 0,123,__LINE__, 0x3fe45f77, 0x64732fcc, 0x3fe33333, 0x3333333f},	/* 0.636654=f(0.6)*/
{36, 0,123,__LINE__, 0x3fe4c0d7, 0x8c9d4813, 0x3fe3851e, 0xb851eb91},	/* 0.64854=f(0.61)*/
{36, 0,123,__LINE__, 0x3fe522bf, 0xb73e6ac5, 0x3fe3d70a, 0x3d70a3e3},	/* 0.660492=f(0.62)*/
{37, 0,123,__LINE__, 0x3fe58532, 0x65fc2bab, 0x3fe428f5, 0xc28f5c35},	/* 0.672509=f(0.63)*/
{39, 0,123,__LINE__, 0x3fe5e832, 0x1e07e76d, 0x3fe47ae1, 0x47ae1487},	/* 0.684594=f(0.64)*/
{36, 0,123,__LINE__, 0x3fe64bc1, 0x682f47f1, 0x3fe4cccc, 0xccccccd9},	/* 0.696747=f(0.65)*/
{37, 0,123,__LINE__, 0x3fe6afe2, 0xf826cf19, 0x3fe51eb8, 0x51eb852b},	/* 0.708971=f(0.66)*/
{36, 0,123,__LINE__, 0x3fe71499, 0x0fed64ff, 0x3fe570a3, 0xd70a3d7d},	/* 0.721264=f(0.67)*/
{36, 0,123,__LINE__, 0x3fe779e6, 0x6a8a0085, 0x3fe5c28f, 0x5c28f5cf},	/* 0.73363=f(0.68)*/
{43, 0,123,__LINE__, 0x3fe7dfcd, 0x9fe28d58, 0x3fe6147a, 0xe147ae21},	/* 0.74607=f(0.69)*/
{36, 0,123,__LINE__, 0x3fe84651, 0x4bcd45b4, 0x3fe66666, 0x66666673},	/* 0.758584=f(0.7)*/
{36, 0,123,__LINE__, 0x3fe8ad74, 0x0e21cb27, 0x3fe6b851, 0xeb851ec5},	/* 0.771174=f(0.71)*/
{36, 0,123,__LINE__, 0x3fe91538, 0xb3730bad, 0x3fe70a3d, 0x70a3d717},	/* 0.783841=f(0.72)*/
{36, 0,123,__LINE__, 0x3fe97da1, 0x92be82d9, 0x3fe75c28, 0xf5c28f69},	/* 0.796586=f(0.73)*/
{40, 0,123,__LINE__, 0x3fe9e6b1, 0x80b0a7e0, 0x3fe7ae14, 0x7ae147bb},	/* 0.809411=f(0.74)*/
{36, 0,123,__LINE__, 0x3fea506b, 0x2dd3c690, 0x3fe80000, 0x0000000d},	/* 0.822317=f(0.75)*/
{35, 0,123,__LINE__, 0x3feabad1, 0x4f0aa07a, 0x3fe851eb, 0x851eb85f},	/* 0.835305=f(0.76)*/
{38, 0,123,__LINE__, 0x3feb25e6, 0x9da229e4, 0x3fe8a3d7, 0x0a3d70b1},	/* 0.848377=f(0.77)*/
{36, 0,123,__LINE__, 0x3feb91ad, 0xd763639f, 0x3fe8f5c2, 0x8f5c2903},	/* 0.861533=f(0.78)*/
{36, 0,123,__LINE__, 0x3febfe29, 0xe92961a9, 0x3fe947ae, 0x147ae155},	/* 0.874776=f(0.79)*/
{37, 0,123,__LINE__, 0x3fec6b5d, 0x452b57cf, 0x3fe99999, 0x999999a7},	/* 0.888106=f(0.8)*/
{39, 0,123,__LINE__, 0x3fecd94a, 0xe14fa2c5, 0x3fe9eb85, 0x1eb851f9},	/* 0.901525=f(0.81)*/
{36, 0,123,__LINE__, 0x3fed47f5, 0x8e044cc6, 0x3fea3d70, 0xa3d70a4b},	/* 0.915034=f(0.82)*/
{40, 0,123,__LINE__, 0x3fedb760, 0x208e7006, 0x3fea8f5c, 0x28f5c29d},	/* 0.928635=f(0.83)*/
{36, 0,123,__LINE__, 0x3fee278d, 0x731cc7dd, 0x3feae147, 0xae147aef},	/* 0.942328=f(0.84)*/
{35, 0,123,__LINE__, 0x3fee9880, 0x912044af, 0x3feb3333, 0x33333341},	/* 0.956116=f(0.85)*/
{37, 0,123,__LINE__, 0x3fef0a3c, 0x0696384b, 0x3feb851e, 0xb851eb93},	/* 0.969999=f(0.86)*/
{36, 0,123,__LINE__, 0x3fef7cc2, 0xe8d30ee2, 0x3febd70a, 0x3d70a3e5},	/* 0.98398=f(0.87)*/
{37, 0,123,__LINE__, 0x3feff018, 0x26684115, 0x3fec28f5, 0xc28f5c37},	/* 0.998058=f(0.88)*/
{37, 0,123,__LINE__, 0x3ff0321f, 0x5997d584, 0x3fec7ae1, 0x47ae1489},	/* 1.01224=f(0.89)*/
{37, 0,123,__LINE__, 0x3ff06c9c, 0xc42f72fa, 0x3feccccc, 0xccccccdb},	/* 1.02652=f(0.9)*/
{36, 0,123,__LINE__, 0x3ff0a785, 0xe965a58c, 0x3fed1eb8, 0x51eb852d},	/* 1.0409=f(0.91)*/
{38, 0,123,__LINE__, 0x3ff0e2dc, 0x1d48ac07, 0x3fed70a3, 0xd70a3d7f},	/* 1.05539=f(0.92)*/
{37, 0,123,__LINE__, 0x3ff11ea0, 0xfba59956, 0x3fedc28f, 0x5c28f5d1},	/* 1.06998=f(0.93)*/
{36, 0,123,__LINE__, 0x3ff15ad6, 0x0c30d82e, 0x3fee147a, 0xe147ae23},	/* 1.08468=f(0.94)*/
{37, 0,123,__LINE__, 0x3ff1977c, 0xd97e1e2e, 0x3fee6666, 0x66666675},	/* 1.09948=f(0.95)*/
{36, 0,123,__LINE__, 0x3ff1d496, 0xf10a85c0, 0x3feeb851, 0xeb851ec7},	/* 1.1144=f(0.96)*/
{37, 0,123,__LINE__, 0x3ff21225, 0xfb699a70, 0x3fef0a3d, 0x70a3d719},	/* 1.12943=f(0.97)*/
{37, 0,123,__LINE__, 0x3ff2502b, 0x5bf2ae39, 0x3fef5c28, 0xf5c28f6b},	/* 1.14457=f(0.98)*/
{39, 0,123,__LINE__, 0x3ff28ea8, 0xc111520b, 0x3fefae14, 0x7ae147bd},	/* 1.15983=f(0.99)*/
{37, 0,123,__LINE__, 0x3ff2cd9f, 0xc44eb982, 0x3ff00000, 0x00000007},	/* 1.1752=f(1)*/
{38, 0,123,__LINE__, 0x3ff30d12, 0x02512219, 0x3ff028f5, 0xc28f5c30},	/* 1.19069=f(1.01)*/
{37, 0,123,__LINE__, 0x3ff34d01, 0x1ae66389, 0x3ff051eb, 0x851eb859},	/* 1.2063=f(1.02)*/
{36, 0,123,__LINE__, 0x3ff38d6e, 0xb10e94cd, 0x3ff07ae1, 0x47ae1482},	/* 1.22203=f(1.03)*/
{35, 0,123,__LINE__, 0x3ff3ce5c, 0x6b06c623, 0x3ff0a3d7, 0x0a3d70ab},	/* 1.23788=f(1.04)*/
{35, 0,123,__LINE__, 0x3ff40fcb, 0xf253d039, 0x3ff0cccc, 0xccccccd4},	/* 1.25386=f(1.05)*/
{35, 0,123,__LINE__, 0x3ff451be, 0xf3cd38e2, 0x3ff0f5c2, 0x8f5c28fd},	/* 1.26996=f(1.06)*/
{35, 0,123,__LINE__, 0x3ff49437, 0x53ca8908, 0x3ff11eb8, 0x51eb8526},	/* 1.28619=f(1.07)*/
{39, 0,123,__LINE__, 0x3ff4d736, 0x5e0ef7e2, 0x3ff147ae, 0x147ae14f},	/* 1.30254=f(1.08)*/
{38, 0,123,__LINE__, 0x3ff51abd, 0xfd65f565, 0x3ff170a3, 0xd70a3d78},	/* 1.31903=f(1.09)*/
{35, 0,123,__LINE__, 0x3ff55ecf, 0xec60657d, 0x3ff19999, 0x999999a1},	/* 1.33565=f(1.1)*/
{35, 0,123,__LINE__, 0x3ff5a36d, 0xe9199d17, 0x3ff1c28f, 0x5c28f5ca},	/* 1.3524=f(1.11)*/
{36, 0,123,__LINE__, 0x3ff5e899, 0xb542cdba, 0x3ff1eb85, 0x1eb851f3},	/* 1.36929=f(1.12)*/
{36, 0,123,__LINE__, 0x3ff62e55, 0x162e88aa, 0x3ff2147a, 0xe147ae1c},	/* 1.38631=f(1.13)*/
{35, 0,123,__LINE__, 0x3ff674a1, 0xd4dc59d3, 0x3ff23d70, 0xa3d70a45},	/* 1.40347=f(1.14)*/
{34, 0,123,__LINE__, 0x3ff6bb81, 0xbe047ac7, 0x3ff26666, 0x6666666e},	/* 1.42078=f(1.15)*/
{38, 0,123,__LINE__, 0x3ff702f6, 0xa2239e23, 0x3ff28f5c, 0x28f5c297},	/* 1.43822=f(1.16)*/
{36, 0,123,__LINE__, 0x3ff74b02, 0x5586d3a4, 0x3ff2b851, 0xeb851ec0},	/* 1.45581=f(1.17)*/
{35, 0,123,__LINE__, 0x3ff793a6, 0xb057853c, 0x3ff2e147, 0xae147ae9},	/* 1.47355=f(1.18)*/
{36, 0,123,__LINE__, 0x3ff7dce5, 0xc81d8706, 0x3ff30a3d, 0x70a3d712},	/* 1.49143=f(1.19)*/
{32, 0,123,__LINE__, 0xc070bbeb, 0x471a3321, 0xc01921fb, 0x54442d18},	/* -267.745=f(-6.28319)*/
{35, 0,123,__LINE__, 0xc04bd3c3, 0x52817e9b, 0xc012d97c, 0x7f3321d2},	/* -55.6544=f(-4.71239)*/
{35, 0,123,__LINE__, 0xc02718f4, 0x7f73f26d, 0xc00921fb, 0x54442d18},	/* -11.5487=f(-3.14159)*/
{35, 0,123,__LINE__, 0xc002690f, 0x74d668ce, 0xbff921fb, 0x54442d18},	/* -2.3013=f(-1.5708)*/
{64, 0,123,__LINE__, 0x00000000, 0x00000000, 0x00000000, 0x00000000},	/* 0=f(0)*/
{35, 0,123,__LINE__, 0x4002690f, 0x74d668ce, 0x3ff921fb, 0x54442d18},	/* 2.3013=f(1.5708)*/
{35, 0,123,__LINE__, 0x402718f4, 0x7f73f26d, 0x400921fb, 0x54442d18},	/* 11.5487=f(3.14159)*/
{35, 0,123,__LINE__, 0x404bd3c3, 0x52817e9b, 0x4012d97c, 0x7f3321d2},	/* 55.6544=f(4.71239)*/
{32, 0,123,__LINE__, 0xc2937047, 0x00000000, 0xc03e0000, 0x00000000},	/* -5.34324e+12=f(-30)*/
{31, 0,123,__LINE__, 0xc26c68aa, 0x60000000, 0xc03c4ccc, 0xcccccccd},	/* -9.76121e+11=f(-28.3)*/
{31, 0,123,__LINE__, 0xc244c264, 0x20000000, 0xc03a9999, 0x9999999a},	/* -1.78321e+11=f(-26.6)*/
{30, 0,123,__LINE__, 0xc21e56ce, 0xa0000000, 0xc038e666, 0x66666667},	/* -3.25764e+10=f(-24.9)*/
{31, 0,123,__LINE__, 0xc1f62b7a, 0x40000000, 0xc0373333, 0x33333334},	/* -5.95117e+09=f(-23.2)*/
{34, 0,123,__LINE__, 0xc1d03343, 0x00327298, 0xc0358000, 0x00000001},	/* -1.08718e+09=f(-21.5)*/
{32, 0,123,__LINE__, 0xc1a7ad16, 0x22c02a42, 0xc033cccc, 0xccccccce},	/* -1.9861e+08=f(-19.8)*/
{33, 0,123,__LINE__, 0xc1814d0c, 0x30372843, 0xc0321999, 0x9999999b},	/* -3.62828e+07=f(-18.1)*/
{31, 0,123,__LINE__, 0xc15948e8, 0x42ac1001, 0xc0306666, 0x66666668},	/* -6.62826e+06=f(-16.4)*/
{32, 0,123,__LINE__, 0xc13279f9, 0x95ee7af4, 0xc02d6666, 0x6666666a},	/* -1.21087e+06=f(-14.7)*/
{32, 0,123,__LINE__, 0xc10b00b5, 0x916a31a5, 0xc02a0000, 0x00000004},	/* -221207=f(-13)*/
{33, 0,123,__LINE__, 0xc0e3bb5a, 0x7274d3b1, 0xc0269999, 0x9999999e},	/* -40410.8=f(-11.3)*/
{32, 0,123,__LINE__, 0xc0bcd664, 0xc0ae6a19, 0xc0233333, 0x33333338},	/* -7382.39=f(-9.6)*/
{34, 0,123,__LINE__, 0xc0951290, 0x7e73e74b, 0xc01f9999, 0x999999a3},	/* -1348.64=f(-7.9)*/
{34, 0,123,__LINE__, 0xc06ecbf3, 0x5ff370b8, 0xc018cccc, 0xccccccd6},	/* -246.373=f(-6.2)*/
{35, 0,123,__LINE__, 0xc0468062, 0xab5fa9fc, 0xc0120000, 0x00000009},	/* -45.003=f(-4.5)*/
{35, 0,123,__LINE__, 0xc0206243, 0x122992c5, 0xc0066666, 0x66666678},	/* -8.19192=f(-2.8)*/
{35, 0,123,__LINE__, 0xbff55ecf, 0xec60657d, 0xbff19999, 0x999999bd},	/* -1.33565=f(-1.1)*/
{37, 0,123,__LINE__, 0x3fe45f77, 0x64732fcc, 0x3fe33333, 0x333332ec},	/* 0.636654=f(0.6)*/
{35, 0,123,__LINE__, 0x4013bf72, 0xda433165, 0x40026666, 0x66666654},	/* 4.93696=f(2.3)*/
{34, 0,123,__LINE__, 0x403b4a38, 0x03703631, 0x400fffff, 0xffffffee},	/* 27.2899=f(4)*/
{34, 0,123,__LINE__, 0x4062add2, 0xef902efc, 0x4016cccc, 0xccccccc4},	/* 149.432=f(5.7)*/
{34, 0,123,__LINE__, 0x40898fef, 0x97148a5e, 0x401d9999, 0x99999991},	/* 817.992=f(7.4)*/
{34, 0,123,__LINE__, 0x40b17da5, 0xe396ff2f, 0x40223333, 0x3333332f},	/* 4477.65=f(9.1)*/
{33, 0,123,__LINE__, 0x40d7ef99, 0xef564e82, 0x40259999, 0x99999995},	/* 24510.4=f(10.8)*/
{33, 0,123,__LINE__, 0x410060c5, 0x2564c04e, 0x4028ffff, 0xfffffffb},	/* 134169=f(12.5)*/
{32, 0,123,__LINE__, 0x412669bf, 0xe8d45356, 0x402c6666, 0x66666661},	/* 734432=f(14.2)*/
{32, 0,123,__LINE__, 0x414eac08, 0x8ee237d0, 0x402fcccc, 0xccccccc7},	/* 4.02024e+06=f(15.9)*/
{32, 0,123,__LINE__, 0x4174fcb4, 0xd298a772, 0x40319999, 0x99999997},	/* 2.20066e+07=f(17.6)*/
{31, 0,123,__LINE__, 0x419cb878, 0x3447914e, 0x40334ccc, 0xccccccca},	/* 1.20463e+08=f(19.3)*/
{33, 0,123,__LINE__, 0x41c3a6e1, 0xfd9eecfd, 0x4034ffff, 0xfffffffd},	/* 6.59408e+08=f(21)*/
{33, 0,123,__LINE__, 0x41eae4b3, 0xc0000000, 0x4036b333, 0x33333330},	/* 3.60957e+09=f(22.7)*/
{31, 0,123,__LINE__, 0x421266ce, 0x80000000, 0x40386666, 0x66666663},	/* 1.97586e+10=f(24.4)*/
{31, 0,123,__LINE__, 0x42392eae, 0xa0000000, 0x403a1999, 0x99999996},	/* 1.08157e+11=f(26.1)*/
{31, 0,123,__LINE__, 0x42613b18, 0x40000000, 0x403bcccc, 0xccccccc9},	/* 5.92047e+11=f(27.8)*/
{31, 0,123,__LINE__, 0x42879487, 0xa0000000, 0x403d7fff, 0xfffffffc},	/* 3.24084e+12=f(29.5)*/
{0},};
void test_sinhf(int m)   {run_vector_1(m,sinhf_vec,(char *)(sinhf),"sinhf","ff");   }	
