// Code generated by go-swagger; DO NOT EDIT.

// Copyright Prometheus Team
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package alert

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the generate command

import (
	"errors"
	"net/url"
	golangswaggerpaths "path"

	"github.com/go-openapi/swag"
)

// GetAlertsURL generates an URL for the get alerts operation
type GetAlertsURL struct {
	Active      *bool
	Filter      []string
	Inhibited   *bool
	Receiver    *string
	Silenced    *bool
	Unprocessed *bool

	_basePath string
	// avoid unkeyed usage
	_ struct{}
}

// WithBasePath sets the base path for this url builder, only required when it's different from the
// base path specified in the swagger spec.
// When the value of the base path is an empty string
func (o *GetAlertsURL) WithBasePath(bp string) *GetAlertsURL {
	o.SetBasePath(bp)
	return o
}

// SetBasePath sets the base path for this url builder, only required when it's different from the
// base path specified in the swagger spec.
// When the value of the base path is an empty string
func (o *GetAlertsURL) SetBasePath(bp string) {
	o._basePath = bp
}

// Build a url path and query string
func (o *GetAlertsURL) Build() (*url.URL, error) {
	var _result url.URL

	var _path = "/alerts"

	_basePath := o._basePath
	if _basePath == "" {
		_basePath = "/api/v2/"
	}
	_result.Path = golangswaggerpaths.Join(_basePath, _path)

	qs := make(url.Values)

	var activeQ string
	if o.Active != nil {
		activeQ = swag.FormatBool(*o.Active)
	}
	if activeQ != "" {
		qs.Set("active", activeQ)
	}

	var filterIR []string
	for _, filterI := range o.Filter {
		filterIS := filterI
		if filterIS != "" {
			filterIR = append(filterIR, filterIS)
		}
	}

	filter := swag.JoinByFormat(filterIR, "multi")

	for _, qsv := range filter {
		qs.Add("filter", qsv)
	}

	var inhibitedQ string
	if o.Inhibited != nil {
		inhibitedQ = swag.FormatBool(*o.Inhibited)
	}
	if inhibitedQ != "" {
		qs.Set("inhibited", inhibitedQ)
	}

	var receiverQ string
	if o.Receiver != nil {
		receiverQ = *o.Receiver
	}
	if receiverQ != "" {
		qs.Set("receiver", receiverQ)
	}

	var silencedQ string
	if o.Silenced != nil {
		silencedQ = swag.FormatBool(*o.Silenced)
	}
	if silencedQ != "" {
		qs.Set("silenced", silencedQ)
	}

	var unprocessedQ string
	if o.Unprocessed != nil {
		unprocessedQ = swag.FormatBool(*o.Unprocessed)
	}
	if unprocessedQ != "" {
		qs.Set("unprocessed", unprocessedQ)
	}

	_result.RawQuery = qs.Encode()

	return &_result, nil
}

// Must is a helper function to panic when the url builder returns an error
func (o *GetAlertsURL) Must(u *url.URL, err error) *url.URL {
	if err != nil {
		panic(err)
	}
	if u == nil {
		panic("url can't be nil")
	}
	return u
}

// String returns the string representation of the path with query string
func (o *GetAlertsURL) String() string {
	return o.Must(o.Build()).String()
}

// BuildFull builds a full url with scheme, host, path and query string
func (o *GetAlertsURL) BuildFull(scheme, host string) (*url.URL, error) {
	if scheme == "" {
		return nil, errors.New("scheme is required for a full url on GetAlertsURL")
	}
	if host == "" {
		return nil, errors.New("host is required for a full url on GetAlertsURL")
	}

	base, err := o.Build()
	if err != nil {
		return nil, err
	}

	base.Scheme = scheme
	base.Host = host
	return base, nil
}

// StringFull returns the string representation of a complete url
func (o *GetAlertsURL) StringFull(scheme, host string) string {
	return o.Must(o.BuildFull(scheme, host)).String()
}
