import resolve from "rollup-plugin-node-resolve";
import babel from "rollup-plugin-babel";
import commonjs from 'rollup-plugin-commonjs';
import json from 'rollup-plugin-json';
export default {
	input: "dist/index.js",
	plugins: [
		json({
			preferConst: true,
			include: ['data/**']
		}),
		commonjs({
			include: 'node_modules/**'
		}),
		resolve({
			extensions: [ '.js', '.json' ],
			mainFields: ['module', 'main'],
			preferBuiltins: false,
			customResolveOptions: {
				moduleDirectory: ['/usr/lib/nodejs','/usr/share/nodejs','.'],
			}
		}),
		babel({
			presets: [[
				'es2015', {
					modules: false
				}
			]]
		})
	],
	output: {
		extend: true,
		file: "dist/psl.js",
		format: "iife",
		name: "psl"
	}
}
