# Changes since [3.2.1](./3.2.1.md) #

- Require Python 3.6 or higher (mainly becuase of f-strings)

- New format support
	- Add support to write Kobo dictionary, [#205](https://github.com/ilius/pyglossary/issues/205)
	- Add support to write EPUB-2
	- Add support to read AppleDict Binary (.dictionary)
	- Add support to read and write Aard 2 (slob), [#116](https://github.com/ilius/pyglossary/issues/116)

- Glossary: detect and load Writer class from plugins
	- Remove write function from plugin if it has Writer class

- Glossary: call `gc.collect()` on indirect mode after reading/writing each 128 entries
	- To free up memory and avoid running out of RAM for large glossaries

- Glossary: remove empty and duplicate alternate words when converting, using Entry Filter, [#188](https://github.com/ilius/pyglossary/issues/188)

- Add command line options to remove html tags:
	- `--remove-html=tag1,tag2,tag3`
	- `--remove-html-all`

- Re-design format-specific options
	- Allow specifying format-specific read/write options in ui_gtk and ui_tk
	- Add much better and cleaner codebase for handling options in `option.py`
	- Implement validation of options in command line, GTK and Tkinter interfaces
	- Add tests for `option.py` in `option_test.py`
	- Avoid using None as default value of option argument
	- Check default value of plugin options and show warning if invalid
	- Add IntOption class, use it in Omnidic plugin
	- Add DictOption, use it for appledict defaultPrefs
	- And `optionsProp` to all plugins
		- Containing value type, allowed values and optional comment
    - Remove `readOptions` and `writeOptions` from all plugins
    	- Detect options from functions' signature and `optionsProp` variables
		- Avoid using `**kwargs` in plugin `read`, `Reader.open` or `write` functions

- Add `depends` variable to plugins
	- To let GUI install plugin dependencies
	- Type: `dict`, keys are module names, values are pip's package name
	- Add `Glossary.formatsDepends`

- Minor fixes and improvements in Glossary class:
	- Return with error if output file path is an existing directory
	- Fix empty zip when creating `DIRECTORY.zip` as output glossary
	- Do not uncompress gz/bz2/zip input files automatically
	- Ignore "read" function of plugin if "Reader" class is present
	- Cleaning: Add Glossary.init() classmethod to initialize the class, can be called multiple times
	- Some refactoring and cleaning, and add some logs
	- Small optimization: `index % 100` -> `index & 0x7f`
	- Allow having progressbar by position in file and size of file
		- use for `appledict_bin.py`
	- Do not write resource file names as entries to text file in `Glossary.writeTxt`


- StarDict plugin
	- Always open `.ifo` file as UTF-8
	- Fix output filenames without .ifo extention creating hidden files, [#187](https://github.com/ilius/pyglossary/issues/187)

- Babylon BGL plugin
	- Fix bytes metedata values `b'...'` and some refactoring in readType3
	- Skip empty info values
	- Fix non-string info values written as empty
	- Prefix 3 info keys with `bgl_`
	- Fix NameError in debug mode in `stripHtmlTags`
	- Some refactoring

- Octopus MDict plugin
	- Fix Python 3 bug in `readmdict.py`: https://bitbucket.org/xwang/mdict-analysis/commits/8f66c30
	- Support multiple mdd files ([#203](https://github.com/ilius/pyglossary/issues/203))

- Change yes/no options in AppleDict and ABBYY Lingvo DSL plugins to boolean
	- To keep compatibility of command line flags, fix yes/no manually in ui_cmd.py

- AppleDict plugin:
	- Fix `echo` problem in `Makefile` ([#177](https://github.com/ilius/pyglossary/issues/177))
	- Add dark mode support for AppleDict output ([#177](https://github.com/ilius/pyglossary/issues/177))
	- Add comments for `optionsProp`
	- Use keyword argument `features=` and fix a warning about from_encoding=


- Fix misspelled "extension" (as "extention") in plugins
- Detect entries with `span` tag as html, [#193](https://github.com/ilius/pyglossary/issues/193)
- Refactoring in ui_gtk and ui_tk
- Fix some deprecated API in ui_gtk
- Fix minor bugs and improvements in ui_tk and ui_gtk
- Update setup.py to adapt packaging with wheel, [#189](https://github.com/ilius/pyglossary/issues/189)
- Add type hints to codebase and plugins

- Refactoring and style changes:
	- rename `pyglossary.pyw` to main.py, add a small `pyglossary.pyw` for compatibility
	- Switch to f-strings in glossary.py and freedict.py
	- main.py: replace single quotes with double quotes
	- PEP-8 style fixes





