# pyOCD debugger
# Copyright (c) 2023 Analog Devices, Inc.
# SPDX-License-Identifier: Apache-2.0
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from ...coresight.coresight_target import CoreSightTarget
from ...core.memory_map import (FlashRegion, RamRegion, MemoryMap)
from ...debug.svd.loader import SVDFile


FLASH_ALGO = {
    'load_address' : 0x20000000,

    # Flash algorithm as a hex string
    'instructions': [
    0xe7fdbe00,
    0x4770ba40, 0x4770ba40, 0x4770ba40, 0x4770bac0, 0x4770bac0, 0x4770bac0, 0x0030ea4f, 0x00004770,
    0x0030ea4f, 0x00004770, 0x0030ea4f, 0x00004770, 0xf04fb538, 0x24004180, 0xf4206888, 0x608870e0,
    0xf4406888, 0x60882000, 0xf012688a, 0xd0fb6f00, 0xf4206888, 0xf4406060, 0x60886000, 0xf412688a,
    0xd0fb5f00, 0xf4206888, 0x60882080, 0xf8d0480f, 0xf0211100, 0xf8c00101, 0x46681100, 0xf840f000,
    0xbf0c2800, 0x20014620, 0x2000bd38, 0xb5104770, 0xf84df000, 0xbd102000, 0xf000b510, 0x2000f8c4,
    0xb510bd10, 0xfa0af000, 0xbd102000, 0x4002a000, 0x4280f04f, 0xf4006890, 0x48fa6160, 0x6f00f5b1,
    0x48f9bf08, 0xdc0bd017, 0xf5b1b1a9, 0xbf086f80, 0xd01048f6, 0x6fc0f5b1, 0xf44fbf08, 0xe00a50fa,
    0x6f20f5b1, 0xf44fbf08, 0xd00400e1, 0x6f40f5b1, 0xf44fbf08, 0x68914000, 0x1182f3c1, 0x477040c8,
    0xbc23f000, 0x4bea2100, 0xe00e4aea, 0x2901b169, 0x4610bf0c, 0x68802000, 0x0007f010, 0x4770bf18,
    0x29021c49, 0x4770bfa8, 0x4618e7f0, 0xe92de7f3, 0x4fde4df0, 0x4ddb2400, 0x4880f04f, 0xb374f8df,
    0xea4f4ed9, 0xe00c1a67, 0x2c01b15c, 0x4658bf0c, 0x68812000, 0x0f07f011, 0xf06fd005, 0xe8bd0005,
    0x48d38df0, 0xf8d8e7f5, 0xf4011008, 0xf5b16160, 0xbf086f00, 0xd01a4631, 0xb1b9dc0c, 0x6f80f5b1,
    0x4639bf08, 0xf5b1d013, 0xbf086fc0, 0x51faf44f, 0xe00bd00d, 0x6f20f5b1, 0xf44fbf08, 0xd00601e1,
    0x6f40f5b1, 0xf44fbf08, 0xd0004100, 0xf8d84629, 0xf3c22008, 0x40d11282, 0xf1fafbb1, 0x6a416041,
    0x0f02f011, 0x6a41d003, 0x0102f021, 0x68816241, 0x4170f021, 0x5100f041, 0x68816081, 0x417ff421,
    0x412af441, 0x68816081, 0x0102f041, 0x68816081, 0x0f07f011, 0x6881d1fb, 0x4170f021, 0x6a416081,
    0x0f02f011, 0x6a41d007, 0x0102f021, 0xf06f6241, 0xe8bd0006, 0xf0008df0, 0x1c64fb82, 0xdb932c02,
    0xe8bd2000, 0xb5108df0, 0xb0824604, 0x90002000, 0x46684621, 0xfb8bf000, 0xbf1c2800, 0xbd10b002,
    0x4620a901, 0xfba3f000, 0xbfbc2800, 0xbd10b002, 0xf0009800, 0x2800fad5, 0xb002bf1c, 0xf8ddbd10,
    0xf8dcc000, 0xf4200008, 0xf440407f, 0xf8cc40aa, 0x98010008, 0x0000f8cc, 0x0008f8dc, 0x0004f040,
    0x0008f8cc, 0x20004a8a, 0xe0204b8a, 0x2801b1f8, 0x4619bf0c, 0x68892100, 0x0f07f011, 0x1c40d1f3,
    0xdbf32802, 0x0008f8dc, 0x4070f020, 0x0008f8cc, 0x0024f8dc, 0x0f02f010, 0xf8dcd00b, 0xf0200024,
    0xf8cc0002, 0xb0020024, 0x0006f06f, 0x4611bd10, 0xf000e7e1, 0xb002fb24, 0xbd102000, 0xf3c0b570,
    0x1a84020c, 0x000cf3c1, 0x42ac1a0d, 0x4620d809, 0xff99f7ff, 0xbf182800, 0xf504bd70, 0x42ac5400,
    0x2000d9f5, 0xb530bd70, 0xb0834604, 0x460d2000, 0x0f0ff014, 0xbf1e9000, 0x0002f06f, 0xbd30b003,
    0x46684621, 0xfb13f000, 0xbf1c2800, 0xbd30b003, 0x4620a901, 0xfb2bf000, 0xbfbc2800, 0xbd30b003,
    0xf0009800, 0x2800fa5d, 0xb003bf1c, 0x9a00bd30, 0xf0206890, 0x60900010, 0x60109801, 0x63106828,
    0x63506868, 0x639068a8, 0x63d068e8, 0xf0406890, 0x60900001, 0xf0106890, 0xd1fb0f07, 0xf0206890,
    0x60904070, 0xf0106a50, 0xd0070f02, 0xf0206a50, 0x62500002, 0xf06fb003, 0xbd300086, 0xfabff000,
    0xf1042004, 0x42a10110, 0xeb04bf88, 0xd9030080, 0x1b04f854, 0xd8fb42a0, 0x2000b003, 0xe92dbd30,
    0xb08641f0, 0x460f2500, 0x9500493b, 0x95039502, 0x95059504, 0xf412680a, 0xbf076f00, 0xf4116809,
    0xf06f5f80, 0xb0060046, 0xe8bdbf18, 0xf01081f0, 0xbf1e0f03, 0x0002f06f, 0xe8bdb006, 0x220181f0,
    0x1d034601, 0xbf88428b, 0x0282eb00, 0xbf00d904, 0x3b04f851, 0xd8fb428a, 0x060ff020, 0x080ff000,
    0x46684631, 0xfa93f000, 0xbf1c2800, 0xe8bdb006, 0xa90181f0, 0xf0004630, 0x2800faaa, 0xb006bfbc,
    0x81f0e8bd, 0xf0009800, 0x2800f9db, 0xb006bf1c, 0x81f0e8bd, 0xf1064634, 0x42860010, 0xa902bf38,
    0xbf00d207, 0x2b04f854, 0x2025f841, 0x42841c6d, 0xe9ddd3f8, 0x60010100, 0x0f04f1b8, 0x9702bf38,
    0xf1b8d309, 0xbf380f08, 0xd3049703, 0x0f0cf1b8, 0x9704bf34, 0xa9029705, 0xf7ff4630, 0xb006ff34,
    0x81f0e8bd, 0x03938700, 0x05b8d800, 0x01e84800, 0x40029000, 0x40029400, 0x40006c00, 0x41f0e92d,
    0x4616b084, 0x4605460f, 0x0f03f010, 0xf025d029, 0xf0050003, 0xf1c80803, 0x68000404, 0xf1c49000,
    0x46690004, 0x46224408, 0xf0004631, 0xeba5fa85, 0x99000008, 0xff63f7ff, 0xbf1c2800, 0xe8bdb004,
    0x442581f0, 0x44261b3f, 0x4628e00b, 0xf7ff6831, 0x2800ff56, 0xb004bf1c, 0x81f0e8bd, 0x1d361d2d,
    0x2f041f3f, 0xf015d302, 0xd1ee0f0f, 0xbf282f10, 0x0800f04f, 0x462cd361, 0x0f0ff015, 0x8004f8cd,
    0xb004d004, 0x0002f06f, 0x81f0e8bd, 0xa8014629, 0xf9fdf000, 0xbf1c2800, 0xe8bdb004, 0xa90281f0,
    0xf0004620, 0x2800fa14, 0xb004bfbc, 0x81f0e8bd, 0xf0009801, 0x2800f945, 0xb004bf1c, 0x81f0e8bd,
    0x68889901, 0x0010f020, 0x98026088, 0x68306008, 0x68706308, 0x68b06348, 0x68f06388, 0x688863c8,
    0x0001f040, 0x68886088, 0x0f07f010, 0x6888d1fb, 0x4070f020, 0x6a486088, 0x0f02f010, 0x9801d009,
    0xf0206a40, 0x62480002, 0xf06fb004, 0xe8bd0086, 0xf00081f0, 0x2004f9a4, 0x0110f104, 0xbf8842a1,
    0x0080eb04, 0xbf00d904, 0x1b04f854, 0xd8fb42a0, 0x36103510, 0x2f103f10, 0x2f04d29d, 0x4628d30d,
    0xf7ff6831, 0x2800fedc, 0xb004bf1c, 0x81f0e8bd, 0x1d361d2d, 0x2f041f3f, 0xb17fd2f1, 0x90006828,
    0x4631463a, 0xf0004668, 0x4628fa2c, 0xf7ff9900, 0x2800fec6, 0xb004bf1c, 0x81f0e8bd, 0xb0042000,
    0x81f0e8bd, 0x47f0e92d, 0xf3c04688, 0x1a47010c, 0x040cf3c0, 0x000cf3c8, 0xeba84692, 0xf5c00500,
    0x42a35600, 0x42b3bf28, 0x42afd304, 0x19a0d128, 0xd9034298, 0x0002f06f, 0x87f0e8bd, 0x46394622,
    0xf0004650, 0xeb0af9b9, 0x46050084, 0x46414632, 0xf9b2f000, 0xf7ff4638, 0x2800fdc6, 0xe8bdbf18,
    0x465287f0, 0x46384621, 0xff08f7ff, 0xbf182800, 0x87f0e8bd, 0x4631462a, 0xe8bd4640, 0xe6fd47f0,
    0x46394622, 0xf0004650, 0x4638f997, 0xfdabf7ff, 0xbf182800, 0x87f0e8bd, 0x46214652, 0xf7ff4638,
    0x2800feed, 0xe8bdbf18, 0x463287f0, 0x46504641, 0xf982f000, 0xf7ff4628, 0x2800fd96, 0xe8bdbf18,
    0x465287f0, 0x46404631, 0xfed8f7ff, 0xbf182800, 0x87f0e8bd, 0x5100f507, 0x020cf3c1, 0x5000f5a5,
    0xf3c01a8c, 0x1a45010c, 0xd80a42ac, 0xf7ff4620, 0x2800fd7a, 0xe8bdbf18, 0xf50487f0, 0x42ac5400,
    0x2000d9f4, 0x87f0e8bd, 0x7040f410, 0xf06fbf04, 0x47700002, 0x6a4a494b, 0x62484310, 0x47702000,
    0x7040f410, 0xf06fbf04, 0x47700002, 0x6a4a4945, 0x0000ea22, 0x20006248, 0x48424770, 0xf0006a40,
    0x47700003, 0x0003f010, 0xf06fbf04, 0x47700002, 0x6a4a493c, 0x62484050, 0x47702000, 0x2100b508,
    0xf1a09100, 0xf5b15184, 0xbf244f00, 0x0002f06f, 0x4601bd08, 0xf0004668, 0x2800f8ca, 0xbd08bf18,
    0x98004931, 0x49316401, 0x49316401, 0x20006401, 0xb508bd08, 0x91002100, 0x5184f1a0, 0x4f00f5b1,
    0xf06fbf24, 0xbd080002, 0x46684601, 0xf8aff000, 0xbf182800, 0x4827bd08, 0x64089900, 0xbd082000,
    0xf0116881, 0xbf1c0f07, 0x0005f06f, 0xf04f4770, 0x68994380, 0x6260f401, 0xf5b2491f, 0xbf086f00,
    0xd017491e, 0xb1aadc0b, 0x6f80f5b2, 0x491cbf08, 0xf5b2d010, 0xbf086fc0, 0x51faf44f, 0xf5b2e00a,
    0xbf086f20, 0x01e1f44f, 0xf5b2d004, 0xbf086f40, 0x4100f44f, 0xf3c2689a, 0x40d11282, 0xfbb14a11,
    0x6041f1f2, 0xf0116a41, 0xd0030f02, 0xf0216a41, 0x62410102, 0xf0216881, 0xf0414170, 0x60815100,
    0x47702000, 0x40029000, 0x3a7f5ca3, 0xa1e34f20, 0x9608b2c1, 0xdeadbeef, 0x03938700, 0x05b8d800,
    0x01e84800, 0x000f4240, 0xf04f2101, 0x281f4280, 0x6c92d906, 0xfa013820, 0x4202f000, 0xe006d005,
    0xfa016a52, 0x4202f000, 0x2001d101, 0x20004770, 0x22014770, 0x4180f04f, 0xd906281f, 0x38206c8b,
    0xf000fa02, 0x64884318, 0x6a4b4770, 0xf000fa02, 0x62484318, 0x22014770, 0x4180f04f, 0xd907281f,
    0x38206c8b, 0xf000fa02, 0x0000ea23, 0x47706488, 0xfa026a4b, 0xea23f000, 0x62480000, 0x48324770,
    0xf8d0b081, 0xf0811100, 0xf8c00101, 0xf8d01100, 0xf0811100, 0xf8c00101, 0xf04f1100, 0x68005080,
    0x6800482a, 0xb0019000, 0x20004770, 0xf1a14770, 0x4a275380, 0x2f00f5b3, 0xf5a3d30a, 0x4b252c00,
    0x2f00f5bc, 0xf1a1d310, 0xf5bc5c84, 0xd2014f80, 0xe00a6002, 0x5184f1a1, 0x4180f5a1, 0x4f80f5b1,
    0xf06fbf24, 0x47700002, 0x20006003, 0xf1a04770, 0xf5b25280, 0xbf3c2f00, 0x0012f3c0, 0xd31f6008,
    0x5280f1a0, 0x2200f5a2, 0x2f00f5b2, 0xf5a0bf3c, 0xf3c02000, 0xd3120012, 0x5284f1a0, 0x4f80f5b2,
    0xf5a2d309, 0xf5b24280, 0xbf324f80, 0x4080f5a0, 0x0002f06f, 0xf3c04770, 0xf500000d, 0x60082000,
    0x47702000, 0x47702000, 0x4002a000, 0x10002000, 0x40029000, 0x40029400, 0xf2402a03, 0xf0108030,
    0xf0000c03, 0xf8118015, 0xf1bc3b01, 0x44620f02, 0xf811bf98, 0xf800cb01, 0xbf383b01, 0x3b01f811,
    0x0204f1a2, 0xf800bf98, 0xbf38cb01, 0x3b01f800, 0x0303f011, 0x8025f000, 0xf0c03a08, 0xf8518008,
    0x3a083b04, 0xcb04f851, 0x1008e8a0, 0x1d12e7f5, 0xf851bf5c, 0xf8403b04, 0xf3af3b04, 0x07d28000,
    0xf811bf24, 0xf8113b01, 0xbf48cb01, 0x2b01f811, 0xf800bf24, 0xf8003b01, 0xbf48cb01, 0x2b01f800,
    0xb5104770, 0xf0c03a20, 0xe8b1800b, 0x3a205018, 0x5018e8a0, 0x5018e8b1, 0x5018e8a0, 0xaff5f4bf,
    0x7c02ea5f, 0xe8b1bf24, 0xe8a05018, 0xbf445018, 0xc018c918, 0x4010e8bd, 0x7c82ea5f, 0xf851bf24,
    0xf8403b04, 0xbf083b04, 0x07d24770, 0xf831bf28, 0xbf483b02, 0x2b01f811, 0xf820bf28, 0xbf483b02,
    0x2b01f800, 0x00004770, 0x00000000
    ],

    # Relative function addresses
    'pc_init': 0x20000035,
    'pc_unInit': 0x2000008f,
    'pc_program_page': 0x200000a7,
    'pc_erase_sector': 0x2000009d,
    'pc_eraseAll': 0x20000093,

    'static_base' : 0x20000000 + 0x00000004 + 0x00000ae8,
    'begin_stack' : 0x200022f0,
    'end_stack' : 0x200012f0,
    'begin_data' : 0x20000000 + 0x1000,
    'page_size' : 0x400,
    'analyzer_supported' : False,
    'analyzer_address' : 0x00000000,
    # Enable double buffering
    'page_buffers' : [
        0x20000af0,
        0x20000ef0
    ],
    'min_program_length' : 0x400,

    # Relative region addresses and sizes
    'ro_start': 0x4,
    'ro_size': 0xae8,
    'rw_start': 0xaec,
    'rw_size': 0x4,
    'zi_start': 0xaf0,
    'zi_size': 0x0,

    # Flash information
    'flash_start': 0x10000000,
    'flash_size': 0x100000,
    'sector_sizes': (
        (0x0, 0x2000),
    )
}

class MAX32666(CoreSightTarget):

    VENDOR = "Maxim"

    MEMORY_MAP = MemoryMap(
        FlashRegion(    start=0x10000000,  length=0x100000,  blocksize=0x2000, is_boot_memory=True, algo=FLASH_ALGO),
        RamRegion(      start=0x20000000,  length=0x8C000),
        )

    def __init__(self, session):
        super().__init__(session, self.MEMORY_MAP)
        self._svd_location = SVDFile.from_builtin("max32665.svd")
