'''OpenGL extension EXT.separate_depth_stencil

This module customises the behaviour of the 
OpenGL.raw.GLES2.EXT.separate_depth_stencil to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension adds support for binding a different image to the depth and
	stencil attachments of a framebuffer object.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/EXT/separate_depth_stencil.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.EXT.separate_depth_stencil import *
from OpenGL.raw.GLES2.EXT.separate_depth_stencil import _EXTENSION_NAME

def glInitSeparateDepthStencilEXT():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION