;-------------------------------------------------------------------------------
; The GIMP -- an image manipulation program
; Copyright (C) 1995 Spencer Kimball and Peter Mattis
;-------------------------------------------------------------------------------
; pysycache-scale-720.scm : a script for scale pictures to the correct
;                           size of pictures for the pysycache windows
; Copyright (C) 2006 Vincent DEROO (vincent.pysycache@free.fr)
;-------------------------------------------------------------------------------
;
;
; This program is free software; you can redistribute it and/or 
; modify it under the terms of the GNU General Public License 
; as published by the Free Software Foundation; either version 2 
; of the License, or (at your option) any later version. 
; 
; This program is distributed in the hope that it will be useful, 
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
; GNU General Public License for more details. 
; 
; You should have received a copy of the GNU General Public License 
; along with this program; if not, write to the Free Software 
; Foundation, Inc. : 
; 51 Franklin Street, Fifth Floor, Boston, MA02110-1301, USA
;-------------------------------------------------------------------------------




       
;-------------------------------------------------------------------------------
; 
;-------------------------------------------------------------------------------
(define (script-fu-pysycache-scale-720
	img
	draw
	WorkOnCopy)

	(let*	(		;recuperation de la taille de l'image originale
				(ImgWidth (car (gimp-image-width img)))
				(ImgHeight (car (gimp-image-height img)))
			)

			(if (= (* 3 ImgWidth) (* 4 ImgHeight) )
				(begin

				
				(if (= WorkOnCopy TRUE)
					(begin
						;------------------------ work on copy ---------------------
						(let*	(	;new image
									(MyImg (car (gimp-image-new ImgWidth ImgHeight RGB)))
									(layBG (car (gimp-layer-new-from-drawable draw MyImg)))
								)
								(gimp-image-add-layer MyImg layBG -1)
								(let* 	(
										(MyDraw (car (gimp-image-get-active-drawable MyImg)))
									)
									(gimp-image-resize MyImg 720 540 0 0)
									(gimp-drawable-transform-scale MyDraw 0 0 720 540 0 2 TRUE 6 FALSE)
									(gimp-selection-all MyImg)
									(gimp-display-new MyImg)
								)
						)
					)
					(begin
						;--------------- work on the original image ----------------
						(gimp-image-resize img 720 540 0 0)
						(gimp-drawable-transform-scale draw 0 0 720 540 0 2 TRUE 6 FALSE)
						(gimp-selection-all img)
					)
				)
				(gimp-displays-flush)		
				
				)
				(begin
					(gimp-message "Picture is not in  4 / 3 format. Abort" )
				)
			)
	)
)


;-------------------------------------------------------------------------------
; Register in the Gimp menus
;-------------------------------------------------------------------------------
(script-fu-register "script-fu-pysycache-scale-720"
		    _"<Image>/Script-Fu/Pysycache/Scale pictures in 720x540..."
		    "Scales a picture to the correct size of the windows of Pysycache (720 x 540).\
Pictures should be in landscape orientation and have a ratio of 4/3. "
		    "Vincent DEROO (contact.pysycache@free.fr)"
		    "Vincent DEROO"
		    "16/09/2006 - v 1.0"
		    "RGB GRAY RGBA GRAYA"
			
		SF-IMAGE "Image" 0
		SF-DRAWABLE "Drawable" 0
		SF-TOGGLE _"Work on copy" TRUE)
