# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ApiManagementServiceNameAvailabilityResult(Model):
    """Response of the CheckNameAvailability operation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name_available: True if the name is available and can be used to
     create a new API Management service; otherwise false.
    :vartype name_available: bool
    :ivar message: If reason == invalid, provide the user with the reason why
     the given name is invalid, and provide the resource naming requirements so
     that the user can select a valid name. If reason == AlreadyExists, explain
     that <resourceName> is already in use, and direct them to select a
     different name.
    :vartype message: str
    :param reason: Invalid indicates the name provided does not match the
     resource provider’s naming requirements (incorrect length, unsupported
     characters, etc.)  AlreadyExists indicates that the name is already in use
     and is therefore unavailable. Possible values include: 'Valid', 'Invalid',
     'AlreadyExists'
    :type reason: str or
     ~azure.mgmt.apimanagement.models.NameAvailabilityReason
    """

    _validation = {
        'name_available': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'message': {'key': 'message', 'type': 'str'},
        'reason': {'key': 'reason', 'type': 'NameAvailabilityReason'},
    }

    def __init__(self, *, reason=None, **kwargs) -> None:
        super(ApiManagementServiceNameAvailabilityResult, self).__init__(**kwargs)
        self.name_available = None
        self.message = None
        self.reason = reason
