# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class IssueAttachmentContract(Resource):
    """Issue Attachment Contract details.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type for API Management resource.
    :vartype type: str
    :param title: Required. Filename by which the binary data will be saved.
    :type title: str
    :param content_format: Required. Either 'link' if content is provided via
     an HTTP link or the MIME type of the Base64-encoded binary data provided
     in the 'content' property.
    :type content_format: str
    :param content: Required. An HTTP link or Base64-encoded binary data.
    :type content: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'title': {'required': True},
        'content_format': {'required': True},
        'content': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'title': {'key': 'properties.title', 'type': 'str'},
        'content_format': {'key': 'properties.contentFormat', 'type': 'str'},
        'content': {'key': 'properties.content', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(IssueAttachmentContract, self).__init__(**kwargs)
        self.title = kwargs.get('title', None)
        self.content_format = kwargs.get('content_format', None)
        self.content = kwargs.get('content', None)
