# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ResourceRequirements(Model):
    """The resource requirements.

    All required parameters must be populated in order to send to Azure.

    :param requests: Required. The resource requests of this container
     instance.
    :type requests: ~azure.mgmt.containerinstance.models.ResourceRequests
    :param limits: The resource limits of this container instance.
    :type limits: ~azure.mgmt.containerinstance.models.ResourceLimits
    """

    _validation = {
        'requests': {'required': True},
    }

    _attribute_map = {
        'requests': {'key': 'requests', 'type': 'ResourceRequests'},
        'limits': {'key': 'limits', 'type': 'ResourceLimits'},
    }

    def __init__(self, **kwargs):
        super(ResourceRequirements, self).__init__(**kwargs)
        self.requests = kwargs.get('requests', None)
        self.limits = kwargs.get('limits', None)
