# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ScriptAction(Model):
    """Custom script action to run on HDI ondemand cluster once it's up.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The user provided name of the script action.
    :type name: str
    :param uri: Required. The URI for the script action.
    :type uri: str
    :param roles: Required. The node types on which the script action should
     be executed.
    :type roles: object
    :param parameters: The parameters for the script action.
    :type parameters: str
    """

    _validation = {
        'name': {'required': True},
        'uri': {'required': True},
        'roles': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
        'roles': {'key': 'roles', 'type': 'object'},
        'parameters': {'key': 'parameters', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ScriptAction, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.uri = kwargs.get('uri', None)
        self.roles = kwargs.get('roles', None)
        self.parameters = kwargs.get('parameters', None)
