# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .container_registry_event_data import ContainerRegistryEventData


class ContainerRegistryImageDeletedEventData(ContainerRegistryEventData):
    """Schema of the Data property of an EventGridEvent for a
    Microsoft.ContainerRegistry.ImageDeleted event.

    :param id: The event ID.
    :type id: str
    :param timestamp: The time at which the event occurred.
    :type timestamp: datetime
    :param action: The action that encompasses the provided event.
    :type action: str
    :param target: The target of the event.
    :type target: ~azure.eventgrid.models.ContainerRegistryEventTarget
    :param request: The request that generated the event.
    :type request: ~azure.eventgrid.models.ContainerRegistryEventRequest
    :param actor: The agent that initiated the event. For most situations,
     this could be from the authorization context of the request.
    :type actor: ~azure.eventgrid.models.ContainerRegistryEventActor
    :param source: The registry node that generated the event. Put
     differently, while the actor initiates the event, the source generates it.
    :type source: ~azure.eventgrid.models.ContainerRegistryEventSource
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'action': {'key': 'action', 'type': 'str'},
        'target': {'key': 'target', 'type': 'ContainerRegistryEventTarget'},
        'request': {'key': 'request', 'type': 'ContainerRegistryEventRequest'},
        'actor': {'key': 'actor', 'type': 'ContainerRegistryEventActor'},
        'source': {'key': 'source', 'type': 'ContainerRegistryEventSource'},
    }

    def __init__(self, **kwargs):
        super(ContainerRegistryImageDeletedEventData, self).__init__(**kwargs)
