# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class AbnormalTimePeriod(msrest.serialization.Model):
    """Class representing Abnormal Time Period identified in diagnosis.

    :param start_time: Start time of the downtime.
    :type start_time: ~datetime.datetime
    :param end_time: End time of the downtime.
    :type end_time: ~datetime.datetime
    :param events: List of Possible Cause of downtime.
    :type events: list[~azure.mgmt.web.v2021_01_01.models.DetectorAbnormalTimePeriod]
    :param solutions: List of proposed solutions.
    :type solutions: list[~azure.mgmt.web.v2021_01_01.models.Solution]
    """

    _attribute_map = {
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'events': {'key': 'events', 'type': '[DetectorAbnormalTimePeriod]'},
        'solutions': {'key': 'solutions', 'type': '[Solution]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AbnormalTimePeriod, self).__init__(**kwargs)
        self.start_time = kwargs.get('start_time', None)
        self.end_time = kwargs.get('end_time', None)
        self.events = kwargs.get('events', None)
        self.solutions = kwargs.get('solutions', None)


class Address(msrest.serialization.Model):
    """Address information for domain registration.

    All required parameters must be populated in order to send to Azure.

    :param address1: Required. First line of an Address.
    :type address1: str
    :param address2: The second line of the Address. Optional.
    :type address2: str
    :param city: Required. The city for the address.
    :type city: str
    :param country: Required. The country for the address.
    :type country: str
    :param postal_code: Required. The postal code for the address.
    :type postal_code: str
    :param state: Required. The state or province for the address.
    :type state: str
    """

    _validation = {
        'address1': {'required': True},
        'city': {'required': True},
        'country': {'required': True},
        'postal_code': {'required': True},
        'state': {'required': True},
    }

    _attribute_map = {
        'address1': {'key': 'address1', 'type': 'str'},
        'address2': {'key': 'address2', 'type': 'str'},
        'city': {'key': 'city', 'type': 'str'},
        'country': {'key': 'country', 'type': 'str'},
        'postal_code': {'key': 'postalCode', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Address, self).__init__(**kwargs)
        self.address1 = kwargs['address1']
        self.address2 = kwargs.get('address2', None)
        self.city = kwargs['city']
        self.country = kwargs['country']
        self.postal_code = kwargs['postal_code']
        self.state = kwargs['state']


class ProxyOnlyResource(msrest.serialization.Model):
    """Azure proxy only resource. This resource is not tracked by Azure Resource Manager.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProxyOnlyResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.kind = kwargs.get('kind', None)
        self.type = None


class AddressResponse(ProxyOnlyResource):
    """Describes main public IP address and any extra virtual IPs.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param service_ip_address: Main public virtual IP.
    :type service_ip_address: str
    :param internal_ip_address: Virtual Network internal IP address of the App Service Environment
     if it is in internal load-balancing mode.
    :type internal_ip_address: str
    :param outbound_ip_addresses: IP addresses appearing on outbound connections.
    :type outbound_ip_addresses: list[str]
    :param vip_mappings: Additional virtual IPs.
    :type vip_mappings: list[~azure.mgmt.web.v2021_01_01.models.VirtualIPMapping]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'service_ip_address': {'key': 'properties.serviceIpAddress', 'type': 'str'},
        'internal_ip_address': {'key': 'properties.internalIpAddress', 'type': 'str'},
        'outbound_ip_addresses': {'key': 'properties.outboundIpAddresses', 'type': '[str]'},
        'vip_mappings': {'key': 'properties.vipMappings', 'type': '[VirtualIPMapping]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AddressResponse, self).__init__(**kwargs)
        self.service_ip_address = kwargs.get('service_ip_address', None)
        self.internal_ip_address = kwargs.get('internal_ip_address', None)
        self.outbound_ip_addresses = kwargs.get('outbound_ip_addresses', None)
        self.vip_mappings = kwargs.get('vip_mappings', None)


class AllowedAudiencesValidation(msrest.serialization.Model):
    """The configuration settings of the Allowed Audiences validation flow.

    :param allowed_audiences: The configuration settings of the allowed list of audiences from
     which to validate the JWT token.
    :type allowed_audiences: list[str]
    """

    _attribute_map = {
        'allowed_audiences': {'key': 'allowedAudiences', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AllowedAudiencesValidation, self).__init__(**kwargs)
        self.allowed_audiences = kwargs.get('allowed_audiences', None)


class AnalysisData(msrest.serialization.Model):
    """Class Representing Detector Evidence used for analysis.

    :param source: Name of the Detector.
    :type source: str
    :param detector_definition: Detector Definition.
    :type detector_definition: ~azure.mgmt.web.v2021_01_01.models.DetectorDefinition
    :param metrics: Source Metrics.
    :type metrics: list[~azure.mgmt.web.v2021_01_01.models.DiagnosticMetricSet]
    :param data: Additional Source Data.
    :type data: list[list[~azure.mgmt.web.v2021_01_01.models.NameValuePair]]
    :param detector_meta_data: Detector Meta Data.
    :type detector_meta_data: ~azure.mgmt.web.v2021_01_01.models.ResponseMetaData
    """

    _attribute_map = {
        'source': {'key': 'source', 'type': 'str'},
        'detector_definition': {'key': 'detectorDefinition', 'type': 'DetectorDefinition'},
        'metrics': {'key': 'metrics', 'type': '[DiagnosticMetricSet]'},
        'data': {'key': 'data', 'type': '[[NameValuePair]]'},
        'detector_meta_data': {'key': 'detectorMetaData', 'type': 'ResponseMetaData'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AnalysisData, self).__init__(**kwargs)
        self.source = kwargs.get('source', None)
        self.detector_definition = kwargs.get('detector_definition', None)
        self.metrics = kwargs.get('metrics', None)
        self.data = kwargs.get('data', None)
        self.detector_meta_data = kwargs.get('detector_meta_data', None)


class AnalysisDefinition(ProxyOnlyResource):
    """Definition of Analysis.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar description: Description of the Analysis.
    :vartype description: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'description': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AnalysisDefinition, self).__init__(**kwargs)
        self.description = None


class ApiDefinitionInfo(msrest.serialization.Model):
    """Information about the formal API definition for the app.

    :param url: The URL of the API definition.
    :type url: str
    """

    _attribute_map = {
        'url': {'key': 'url', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApiDefinitionInfo, self).__init__(**kwargs)
        self.url = kwargs.get('url', None)


class ApiKVReference(ProxyOnlyResource):
    """Description of site key vault references.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param reference:
    :type reference: str
    :param status:  Possible values include: "Initialized", "Resolved", "InvalidSyntax",
     "MSINotEnabled", "VaultNotFound", "SecretNotFound", "SecretVersionNotFound",
     "AccessToKeyVaultDenied", "OtherReasons", "FetchTimedOut", "UnauthorizedClient".
    :type status: str or ~azure.mgmt.web.v2021_01_01.models.ResolveStatus
    :param vault_name:
    :type vault_name: str
    :param secret_name:
    :type secret_name: str
    :param secret_version:
    :type secret_version: str
    :param identity_type: Managed service identity.
    :type identity_type: ~azure.mgmt.web.v2021_01_01.models.ManagedServiceIdentity
    :param details:
    :type details: str
    :param source:  The only acceptable values to pass in are None and "KeyVault". The default
     value is None.
    :type source: str
    :param active_version:
    :type active_version: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'reference': {'key': 'properties.reference', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'vault_name': {'key': 'properties.vaultName', 'type': 'str'},
        'secret_name': {'key': 'properties.secretName', 'type': 'str'},
        'secret_version': {'key': 'properties.secretVersion', 'type': 'str'},
        'identity_type': {'key': 'properties.identityType', 'type': 'ManagedServiceIdentity'},
        'details': {'key': 'properties.details', 'type': 'str'},
        'source': {'key': 'properties.source', 'type': 'str'},
        'active_version': {'key': 'properties.activeVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApiKVReference, self).__init__(**kwargs)
        self.reference = kwargs.get('reference', None)
        self.status = kwargs.get('status', None)
        self.vault_name = kwargs.get('vault_name', None)
        self.secret_name = kwargs.get('secret_name', None)
        self.secret_version = kwargs.get('secret_version', None)
        self.identity_type = kwargs.get('identity_type', None)
        self.details = kwargs.get('details', None)
        self.source = kwargs.get('source', None)
        self.active_version = kwargs.get('active_version', None)


class ApiKVReferenceCollection(msrest.serialization.Model):
    """ApiKVReferenceCollection.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2021_01_01.models.ApiKVReference]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ApiKVReference]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApiKVReferenceCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class ApiManagementConfig(msrest.serialization.Model):
    """Azure API management (APIM) configuration linked to the app.

    :param id: APIM-Api Identifier.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApiManagementConfig, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)


class AppInsightsWebAppStackSettings(msrest.serialization.Model):
    """App Insights Web App stack settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar is_supported: :code:`<code>true</code>` if remote Application Insights is supported for
     the stack; otherwise, :code:`<code>false</code>`.
    :vartype is_supported: bool
    :ivar is_default_off: :code:`<code>true</code>` if Application Insights is disabled by default
     for the stack; otherwise, :code:`<code>false</code>`.
    :vartype is_default_off: bool
    """

    _validation = {
        'is_supported': {'readonly': True},
        'is_default_off': {'readonly': True},
    }

    _attribute_map = {
        'is_supported': {'key': 'isSupported', 'type': 'bool'},
        'is_default_off': {'key': 'isDefaultOff', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AppInsightsWebAppStackSettings, self).__init__(**kwargs)
        self.is_supported = None
        self.is_default_off = None


class Apple(msrest.serialization.Model):
    """The configuration settings of the Apple provider.

    :param enabled: :code:`<code>false</code>` if the Apple provider should not be enabled despite
     the set registration; otherwise, :code:`<code>true</code>`.
    :type enabled: bool
    :param registration: The configuration settings of the Apple registration.
    :type registration: ~azure.mgmt.web.v2021_01_01.models.AppleRegistration
    :param login: The configuration settings of the login flow.
    :type login: ~azure.mgmt.web.v2021_01_01.models.LoginScopes
    """

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'registration': {'key': 'registration', 'type': 'AppleRegistration'},
        'login': {'key': 'login', 'type': 'LoginScopes'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Apple, self).__init__(**kwargs)
        self.enabled = kwargs.get('enabled', None)
        self.registration = kwargs.get('registration', None)
        self.login = kwargs.get('login', None)


class AppleRegistration(msrest.serialization.Model):
    """The configuration settings of the registration for the Apple provider.

    :param client_id: The Client ID of the app used for login.
    :type client_id: str
    :param client_secret_setting_name: The app setting name that contains the client secret.
    :type client_secret_setting_name: str
    """

    _attribute_map = {
        'client_id': {'key': 'clientId', 'type': 'str'},
        'client_secret_setting_name': {'key': 'clientSecretSettingName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AppleRegistration, self).__init__(**kwargs)
        self.client_id = kwargs.get('client_id', None)
        self.client_secret_setting_name = kwargs.get('client_secret_setting_name', None)


class ApplicationLogsConfig(msrest.serialization.Model):
    """Application logs configuration.

    :param file_system: Application logs to file system configuration.
    :type file_system: ~azure.mgmt.web.v2021_01_01.models.FileSystemApplicationLogsConfig
    :param azure_table_storage: Application logs to azure table storage configuration.
    :type azure_table_storage:
     ~azure.mgmt.web.v2021_01_01.models.AzureTableStorageApplicationLogsConfig
    :param azure_blob_storage: Application logs to blob storage configuration.
    :type azure_blob_storage:
     ~azure.mgmt.web.v2021_01_01.models.AzureBlobStorageApplicationLogsConfig
    """

    _attribute_map = {
        'file_system': {'key': 'fileSystem', 'type': 'FileSystemApplicationLogsConfig'},
        'azure_table_storage': {'key': 'azureTableStorage', 'type': 'AzureTableStorageApplicationLogsConfig'},
        'azure_blob_storage': {'key': 'azureBlobStorage', 'type': 'AzureBlobStorageApplicationLogsConfig'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationLogsConfig, self).__init__(**kwargs)
        self.file_system = kwargs.get('file_system', None)
        self.azure_table_storage = kwargs.get('azure_table_storage', None)
        self.azure_blob_storage = kwargs.get('azure_blob_storage', None)


class ApplicationStack(msrest.serialization.Model):
    """Application stack.

    :param name: Application stack name.
    :type name: str
    :param display: Application stack display name.
    :type display: str
    :param dependency: Application stack dependency.
    :type dependency: str
    :param major_versions: List of major versions available.
    :type major_versions: list[~azure.mgmt.web.v2021_01_01.models.StackMajorVersion]
    :param frameworks: List of frameworks associated with application stack.
    :type frameworks: list[~azure.mgmt.web.v2021_01_01.models.ApplicationStack]
    :param is_deprecated: :code:`<code>true</code>` if this is the stack is deprecated; otherwise,
     :code:`<code>false</code>`.
    :type is_deprecated: list[~azure.mgmt.web.v2021_01_01.models.ApplicationStack]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'str'},
        'dependency': {'key': 'dependency', 'type': 'str'},
        'major_versions': {'key': 'majorVersions', 'type': '[StackMajorVersion]'},
        'frameworks': {'key': 'frameworks', 'type': '[ApplicationStack]'},
        'is_deprecated': {'key': 'isDeprecated', 'type': '[ApplicationStack]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationStack, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display = kwargs.get('display', None)
        self.dependency = kwargs.get('dependency', None)
        self.major_versions = kwargs.get('major_versions', None)
        self.frameworks = kwargs.get('frameworks', None)
        self.is_deprecated = kwargs.get('is_deprecated', None)


class ApplicationStackCollection(msrest.serialization.Model):
    """Collection of Application Stacks.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2021_01_01.models.ApplicationStackResource]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ApplicationStackResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationStackCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class ApplicationStackResource(ProxyOnlyResource):
    """ARM resource for a ApplicationStack.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param name_properties_name: Application stack name.
    :type name_properties_name: str
    :param display: Application stack display name.
    :type display: str
    :param dependency: Application stack dependency.
    :type dependency: str
    :param major_versions: List of major versions available.
    :type major_versions: list[~azure.mgmt.web.v2021_01_01.models.StackMajorVersion]
    :param frameworks: List of frameworks associated with application stack.
    :type frameworks: list[~azure.mgmt.web.v2021_01_01.models.ApplicationStack]
    :param is_deprecated: :code:`<code>true</code>` if this is the stack is deprecated; otherwise,
     :code:`<code>false</code>`.
    :type is_deprecated: list[~azure.mgmt.web.v2021_01_01.models.ApplicationStack]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name_properties_name': {'key': 'properties.name', 'type': 'str'},
        'display': {'key': 'properties.display', 'type': 'str'},
        'dependency': {'key': 'properties.dependency', 'type': 'str'},
        'major_versions': {'key': 'properties.majorVersions', 'type': '[StackMajorVersion]'},
        'frameworks': {'key': 'properties.frameworks', 'type': '[ApplicationStack]'},
        'is_deprecated': {'key': 'properties.isDeprecated', 'type': '[ApplicationStack]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationStackResource, self).__init__(**kwargs)
        self.name_properties_name = kwargs.get('name_properties_name', None)
        self.display = kwargs.get('display', None)
        self.dependency = kwargs.get('dependency', None)
        self.major_versions = kwargs.get('major_versions', None)
        self.frameworks = kwargs.get('frameworks', None)
        self.is_deprecated = kwargs.get('is_deprecated', None)


class AppLogsConfiguration(msrest.serialization.Model):
    """AppLogsConfiguration.

    :param destination:
    :type destination: str
    :param log_analytics_configuration:
    :type log_analytics_configuration: ~azure.mgmt.web.v2021_01_01.models.LogAnalyticsConfiguration
    """

    _attribute_map = {
        'destination': {'key': 'destination', 'type': 'str'},
        'log_analytics_configuration': {'key': 'logAnalyticsConfiguration', 'type': 'LogAnalyticsConfiguration'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AppLogsConfiguration, self).__init__(**kwargs)
        self.destination = kwargs.get('destination', None)
        self.log_analytics_configuration = kwargs.get('log_analytics_configuration', None)


class AppRegistration(msrest.serialization.Model):
    """The configuration settings of the app registration for providers that have app ids and app secrets.

    :param app_id: The App ID of the app used for login.
    :type app_id: str
    :param app_secret_setting_name: The app setting name that contains the app secret.
    :type app_secret_setting_name: str
    """

    _attribute_map = {
        'app_id': {'key': 'appId', 'type': 'str'},
        'app_secret_setting_name': {'key': 'appSecretSettingName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AppRegistration, self).__init__(**kwargs)
        self.app_id = kwargs.get('app_id', None)
        self.app_secret_setting_name = kwargs.get('app_secret_setting_name', None)


class AppServiceCertificate(msrest.serialization.Model):
    """Key Vault container for a certificate that is purchased through Azure.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param key_vault_id: Key Vault resource Id.
    :type key_vault_id: str
    :param key_vault_secret_name: Key Vault secret name.
    :type key_vault_secret_name: str
    :ivar provisioning_state: Status of the Key Vault secret. Possible values include:
     "Initialized", "WaitingOnCertificateOrder", "Succeeded", "CertificateOrderFailed",
     "OperationNotPermittedOnKeyVault", "AzureServiceUnauthorizedToAccessKeyVault",
     "KeyVaultDoesNotExist", "KeyVaultSecretDoesNotExist", "UnknownError", "ExternalPrivateKey",
     "Unknown".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2021_01_01.models.KeyVaultSecretStatus
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'key_vault_id': {'key': 'keyVaultId', 'type': 'str'},
        'key_vault_secret_name': {'key': 'keyVaultSecretName', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AppServiceCertificate, self).__init__(**kwargs)
        self.key_vault_id = kwargs.get('key_vault_id', None)
        self.key_vault_secret_name = kwargs.get('key_vault_secret_name', None)
        self.provisioning_state = None


class AppServiceCertificateCollection(msrest.serialization.Model):
    """Collection of certificate order certificates.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2021_01_01.models.AppServiceCertificateResource]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AppServiceCertificateResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AppServiceCertificateCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class Resource(msrest.serialization.Model):
    """Azure resource. This resource is tracked in Azure Resource Manager.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :param location: Required. Resource Location.
    :type location: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'location': {'required': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.kind = kwargs.get('kind', None)
        self.location = kwargs['location']
        self.type = None
        self.tags = kwargs.get('tags', None)


class AppServiceCertificateOrder(Resource):
    """SSL certificate purchase order.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :param location: Required. Resource Location.
    :type location: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param certificates: State of the Key Vault secret.
    :type certificates: dict[str, ~azure.mgmt.web.v2021_01_01.models.AppServiceCertificate]
    :param distinguished_name: Certificate distinguished name.
    :type distinguished_name: str
    :ivar domain_verification_token: Domain verification token.
    :vartype domain_verification_token: str
    :param validity_in_years: Duration in years (must be 1).
    :type validity_in_years: int
    :param key_size: Certificate key size.
    :type key_size: int
    :param product_type: Certificate product type. Possible values include:
     "StandardDomainValidatedSsl", "StandardDomainValidatedWildCardSsl".
    :type product_type: str or ~azure.mgmt.web.v2021_01_01.models.CertificateProductType
    :param auto_renew: :code:`<code>true</code>` if the certificate should be automatically renewed
     when it expires; otherwise, :code:`<code>false</code>`.
    :type auto_renew: bool
    :ivar provisioning_state: Status of certificate order. Possible values include: "Succeeded",
     "Failed", "Canceled", "InProgress", "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2021_01_01.models.ProvisioningState
    :ivar status: Current order status. Possible values include: "Pendingissuance", "Issued",
     "Revoked", "Canceled", "Denied", "Pendingrevocation", "PendingRekey", "Unused", "Expired",
     "NotSubmitted".
    :vartype status: str or ~azure.mgmt.web.v2021_01_01.models.CertificateOrderStatus
    :ivar signed_certificate: Signed certificate.
    :vartype signed_certificate: ~azure.mgmt.web.v2021_01_01.models.CertificateDetails
    :param csr: Last CSR that was created for this order.
    :type csr: str
    :ivar intermediate: Intermediate certificate.
    :vartype intermediate: ~azure.mgmt.web.v2021_01_01.models.CertificateDetails
    :ivar root: Root certificate.
    :vartype root: ~azure.mgmt.web.v2021_01_01.models.CertificateDetails
    :ivar serial_number: Current serial number of the certificate.
    :vartype serial_number: str
    :ivar last_certificate_issuance_time: Certificate last issuance time.
    :vartype last_certificate_issuance_time: ~datetime.datetime
    :ivar expiration_time: Certificate expiration time.
    :vartype expiration_time: ~datetime.datetime
    :ivar is_private_key_external: :code:`<code>true</code>` if private key is external; otherwise,
     :code:`<code>false</code>`.
    :vartype is_private_key_external: bool
    :ivar app_service_certificate_not_renewable_reasons: Reasons why App Service Certificate is not
     renewable at the current moment.
    :vartype app_service_certificate_not_renewable_reasons: list[str or
     ~azure.mgmt.web.v2021_01_01.models.AppServiceCertificateOrderPropertiesAppServiceCertificateNotRenewableReasonsItem]
    :ivar next_auto_renewal_time_stamp: Time stamp when the certificate would be auto renewed next.
    :vartype next_auto_renewal_time_stamp: ~datetime.datetime
    :ivar contact: Contact info.
    :vartype contact: ~azure.mgmt.web.v2021_01_01.models.CertificateOrderContact
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'location': {'required': True},
        'type': {'readonly': True},
        'domain_verification_token': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'status': {'readonly': True},
        'signed_certificate': {'readonly': True},
        'intermediate': {'readonly': True},
        'root': {'readonly': True},
        'serial_number': {'readonly': True},
        'last_certificate_issuance_time': {'readonly': True},
        'expiration_time': {'readonly': True},
        'is_private_key_external': {'readonly': True},
        'app_service_certificate_not_renewable_reasons': {'readonly': True},
        'next_auto_renewal_time_stamp': {'readonly': True},
        'contact': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'certificates': {'key': 'properties.certificates', 'type': '{AppServiceCertificate}'},
        'distinguished_name': {'key': 'properties.distinguishedName', 'type': 'str'},
        'domain_verification_token': {'key': 'properties.domainVerificationToken', 'type': 'str'},
        'validity_in_years': {'key': 'properties.validityInYears', 'type': 'int'},
        'key_size': {'key': 'properties.keySize', 'type': 'int'},
        'product_type': {'key': 'properties.productType', 'type': 'str'},
        'auto_renew': {'key': 'properties.autoRenew', 'type': 'bool'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'signed_certificate': {'key': 'properties.signedCertificate', 'type': 'CertificateDetails'},
        'csr': {'key': 'properties.csr', 'type': 'str'},
        'intermediate': {'key': 'properties.intermediate', 'type': 'CertificateDetails'},
        'root': {'key': 'properties.root', 'type': 'CertificateDetails'},
        'serial_number': {'key': 'properties.serialNumber', 'type': 'str'},
        'last_certificate_issuance_time': {'key': 'properties.lastCertificateIssuanceTime', 'type': 'iso-8601'},
        'expiration_time': {'key': 'properties.expirationTime', 'type': 'iso-8601'},
        'is_private_key_external': {'key': 'properties.isPrivateKeyExternal', 'type': 'bool'},
        'app_service_certificate_not_renewable_reasons': {'key': 'properties.appServiceCertificateNotRenewableReasons', 'type': '[str]'},
        'next_auto_renewal_time_stamp': {'key': 'properties.nextAutoRenewalTimeStamp', 'type': 'iso-8601'},
        'contact': {'key': 'properties.contact', 'type': 'CertificateOrderContact'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AppServiceCertificateOrder, self).__init__(**kwargs)
        self.certificates = kwargs.get('certificates', None)
        self.distinguished_name = kwargs.get('distinguished_name', None)
        self.domain_verification_token = None
        self.validity_in_years = kwargs.get('validity_in_years', 1)
        self.key_size = kwargs.get('key_size', 2048)
        self.product_type = kwargs.get('product_type', None)
        self.auto_renew = kwargs.get('auto_renew', True)
        self.provisioning_state = None
        self.status = None
        self.signed_certificate = None
        self.csr = kwargs.get('csr', None)
        self.intermediate = None
        self.root = None
        self.serial_number = None
        self.last_certificate_issuance_time = None
        self.expiration_time = None
        self.is_private_key_external = None
        self.app_service_certificate_not_renewable_reasons = None
        self.next_auto_renewal_time_stamp = None
        self.contact = None


class AppServiceCertificateOrderCollection(msrest.serialization.Model):
    """Collection of certificate orders.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2021_01_01.models.AppServiceCertificateOrder]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AppServiceCertificateOrder]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AppServiceCertificateOrderCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class AppServiceCertificateOrderPatchResource(ProxyOnlyResource):
    """ARM resource for a certificate order that is purchased through Azure.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param certificates: State of the Key Vault secret.
    :type certificates: dict[str, ~azure.mgmt.web.v2021_01_01.models.AppServiceCertificate]
    :param distinguished_name: Certificate distinguished name.
    :type distinguished_name: str
    :ivar domain_verification_token: Domain verification token.
    :vartype domain_verification_token: str
    :param validity_in_years: Duration in years (must be 1).
    :type validity_in_years: int
    :param key_size: Certificate key size.
    :type key_size: int
    :param product_type: Certificate product type. Possible values include:
     "StandardDomainValidatedSsl", "StandardDomainValidatedWildCardSsl".
    :type product_type: str or ~azure.mgmt.web.v2021_01_01.models.CertificateProductType
    :param auto_renew: :code:`<code>true</code>` if the certificate should be automatically renewed
     when it expires; otherwise, :code:`<code>false</code>`.
    :type auto_renew: bool
    :ivar provisioning_state: Status of certificate order. Possible values include: "Succeeded",
     "Failed", "Canceled", "InProgress", "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2021_01_01.models.ProvisioningState
    :ivar status: Current order status. Possible values include: "Pendingissuance", "Issued",
     "Revoked", "Canceled", "Denied", "Pendingrevocation", "PendingRekey", "Unused", "Expired",
     "NotSubmitted".
    :vartype status: str or ~azure.mgmt.web.v2021_01_01.models.CertificateOrderStatus
    :ivar signed_certificate: Signed certificate.
    :vartype signed_certificate: ~azure.mgmt.web.v2021_01_01.models.CertificateDetails
    :param csr: Last CSR that was created for this order.
    :type csr: str
    :ivar intermediate: Intermediate certificate.
    :vartype intermediate: ~azure.mgmt.web.v2021_01_01.models.CertificateDetails
    :ivar root: Root certificate.
    :vartype root: ~azure.mgmt.web.v2021_01_01.models.CertificateDetails
    :ivar serial_number: Current serial number of the certificate.
    :vartype serial_number: str
    :ivar last_certificate_issuance_time: Certificate last issuance time.
    :vartype last_certificate_issuance_time: ~datetime.datetime
    :ivar expiration_time: Certificate expiration time.
    :vartype expiration_time: ~datetime.datetime
    :ivar is_private_key_external: :code:`<code>true</code>` if private key is external; otherwise,
     :code:`<code>false</code>`.
    :vartype is_private_key_external: bool
    :ivar app_service_certificate_not_renewable_reasons: Reasons why App Service Certificate is not
     renewable at the current moment.
    :vartype app_service_certificate_not_renewable_reasons: list[str or
     ~azure.mgmt.web.v2021_01_01.models.AppServiceCertificateOrderPatchResourcePropertiesAppServiceCertificateNotRenewableReasonsItem]
    :ivar next_auto_renewal_time_stamp: Time stamp when the certificate would be auto renewed next.
    :vartype next_auto_renewal_time_stamp: ~datetime.datetime
    :ivar contact: Contact info.
    :vartype contact: ~azure.mgmt.web.v2021_01_01.models.CertificateOrderContact
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'domain_verification_token': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'status': {'readonly': True},
        'signed_certificate': {'readonly': True},
        'intermediate': {'readonly': True},
        'root': {'readonly': True},
        'serial_number': {'readonly': True},
        'last_certificate_issuance_time': {'readonly': True},
        'expiration_time': {'readonly': True},
        'is_private_key_external': {'readonly': True},
        'app_service_certificate_not_renewable_reasons': {'readonly': True},
        'next_auto_renewal_time_stamp': {'readonly': True},
        'contact': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'certificates': {'key': 'properties.certificates', 'type': '{AppServiceCertificate}'},
        'distinguished_name': {'key': 'properties.distinguishedName', 'type': 'str'},
        'domain_verification_token': {'key': 'properties.domainVerificationToken', 'type': 'str'},
        'validity_in_years': {'key': 'properties.validityInYears', 'type': 'int'},
        'key_size': {'key': 'properties.keySize', 'type': 'int'},
        'product_type': {'key': 'properties.productType', 'type': 'str'},
        'auto_renew': {'key': 'properties.autoRenew', 'type': 'bool'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'signed_certificate': {'key': 'properties.signedCertificate', 'type': 'CertificateDetails'},
        'csr': {'key': 'properties.csr', 'type': 'str'},
        'intermediate': {'key': 'properties.intermediate', 'type': 'CertificateDetails'},
        'root': {'key': 'properties.root', 'type': 'CertificateDetails'},
        'serial_number': {'key': 'properties.serialNumber', 'type': 'str'},
        'last_certificate_issuance_time': {'key': 'properties.lastCertificateIssuanceTime', 'type': 'iso-8601'},
        'expiration_time': {'key': 'properties.expirationTime', 'type': 'iso-8601'},
        'is_private_key_external': {'key': 'properties.isPrivateKeyExternal', 'type': 'bool'},
        'app_service_certificate_not_renewable_reasons': {'key': 'properties.appServiceCertificateNotRenewableReasons', 'type': '[str]'},
        'next_auto_renewal_time_stamp': {'key': 'properties.nextAutoRenewalTimeStamp', 'type': 'iso-8601'},
        'contact': {'key': 'properties.contact', 'type': 'CertificateOrderContact'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AppServiceCertificateOrderPatchResource, self).__init__(**kwargs)
        self.certificates = kwargs.get('certificates', None)
        self.distinguished_name = kwargs.get('distinguished_name', None)
        self.domain_verification_token = None
        self.validity_in_years = kwargs.get('validity_in_years', 1)
        self.key_size = kwargs.get('key_size', 2048)
        self.product_type = kwargs.get('product_type', None)
        self.auto_renew = kwargs.get('auto_renew', True)
        self.provisioning_state = None
        self.status = None
        self.signed_certificate = None
        self.csr = kwargs.get('csr', None)
        self.intermediate = None
        self.root = None
        self.serial_number = None
        self.last_certificate_issuance_time = None
        self.expiration_time = None
        self.is_private_key_external = None
        self.app_service_certificate_not_renewable_reasons = None
        self.next_auto_renewal_time_stamp = None
        self.contact = None


class AppServiceCertificatePatchResource(ProxyOnlyResource):
    """Key Vault container ARM resource for a certificate that is purchased through Azure.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param key_vault_id: Key Vault resource Id.
    :type key_vault_id: str
    :param key_vault_secret_name: Key Vault secret name.
    :type key_vault_secret_name: str
    :ivar provisioning_state: Status of the Key Vault secret. Possible values include:
     "Initialized", "WaitingOnCertificateOrder", "Succeeded", "CertificateOrderFailed",
     "OperationNotPermittedOnKeyVault", "AzureServiceUnauthorizedToAccessKeyVault",
     "KeyVaultDoesNotExist", "KeyVaultSecretDoesNotExist", "UnknownError", "ExternalPrivateKey",
     "Unknown".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2021_01_01.models.KeyVaultSecretStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'key_vault_id': {'key': 'properties.keyVaultId', 'type': 'str'},
        'key_vault_secret_name': {'key': 'properties.keyVaultSecretName', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AppServiceCertificatePatchResource, self).__init__(**kwargs)
        self.key_vault_id = kwargs.get('key_vault_id', None)
        self.key_vault_secret_name = kwargs.get('key_vault_secret_name', None)
        self.provisioning_state = None


class AppServiceCertificateResource(Resource):
    """Key Vault container ARM resource for a certificate that is purchased through Azure.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :param location: Required. Resource Location.
    :type location: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param key_vault_id: Key Vault resource Id.
    :type key_vault_id: str
    :param key_vault_secret_name: Key Vault secret name.
    :type key_vault_secret_name: str
    :ivar provisioning_state: Status of the Key Vault secret. Possible values include:
     "Initialized", "WaitingOnCertificateOrder", "Succeeded", "CertificateOrderFailed",
     "OperationNotPermittedOnKeyVault", "AzureServiceUnauthorizedToAccessKeyVault",
     "KeyVaultDoesNotExist", "KeyVaultSecretDoesNotExist", "UnknownError", "ExternalPrivateKey",
     "Unknown".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2021_01_01.models.KeyVaultSecretStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'location': {'required': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'key_vault_id': {'key': 'properties.keyVaultId', 'type': 'str'},
        'key_vault_secret_name': {'key': 'properties.keyVaultSecretName', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AppServiceCertificateResource, self).__init__(**kwargs)
        self.key_vault_id = kwargs.get('key_vault_id', None)
        self.key_vault_secret_name = kwargs.get('key_vault_secret_name', None)
        self.provisioning_state = None


class AppServiceEnvironment(msrest.serialization.Model):
    """Description of an App Service Environment.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar provisioning_state: Provisioning state of the App Service Environment. Possible values
     include: "Succeeded", "Failed", "Canceled", "InProgress", "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2021_01_01.models.ProvisioningState
    :ivar status: Current status of the App Service Environment. Possible values include:
     "Preparing", "Ready", "Scaling", "Deleting".
    :vartype status: str or ~azure.mgmt.web.v2021_01_01.models.HostingEnvironmentStatus
    :param virtual_network: Required. Description of the Virtual Network.
    :type virtual_network: ~azure.mgmt.web.v2021_01_01.models.VirtualNetworkProfile
    :param internal_load_balancing_mode: Specifies which endpoints to serve internally in the
     Virtual Network for the App Service Environment. Possible values include: "None", "Web",
     "Publishing", "Web, Publishing".
    :type internal_load_balancing_mode: str or ~azure.mgmt.web.v2021_01_01.models.LoadBalancingMode
    :param multi_size: Front-end VM size, e.g. "Medium", "Large".
    :type multi_size: str
    :ivar multi_role_count: Number of front-end instances.
    :vartype multi_role_count: int
    :param ipssl_address_count: Number of IP SSL addresses reserved for the App Service
     Environment.
    :type ipssl_address_count: int
    :param dns_suffix: DNS suffix of the App Service Environment.
    :type dns_suffix: str
    :ivar maximum_number_of_machines: Maximum number of VMs in the App Service Environment.
    :vartype maximum_number_of_machines: int
    :param front_end_scale_factor: Scale factor for front-ends.
    :type front_end_scale_factor: int
    :ivar suspended: :code:`<code>true</code>` if the App Service Environment is suspended;
     otherwise, :code:`<code>false</code>`. The environment can be suspended, e.g. when the
     management endpoint is no longer available
      (most likely because NSG blocked the incoming traffic).
    :vartype suspended: bool
    :param cluster_settings: Custom settings for changing the behavior of the App Service
     Environment.
    :type cluster_settings: list[~azure.mgmt.web.v2021_01_01.models.NameValuePair]
    :param user_whitelisted_ip_ranges: User added ip ranges to whitelist on ASE db.
    :type user_whitelisted_ip_ranges: list[str]
    :ivar has_linux_workers: Flag that displays whether an ASE has linux workers or not.
    :vartype has_linux_workers: bool
    :ivar dedicated_host_count: Dedicated Host Count.
    :vartype dedicated_host_count: int
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'status': {'readonly': True},
        'virtual_network': {'required': True},
        'multi_role_count': {'readonly': True},
        'maximum_number_of_machines': {'readonly': True},
        'suspended': {'readonly': True},
        'has_linux_workers': {'readonly': True},
        'dedicated_host_count': {'readonly': True},
    }

    _attribute_map = {
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'virtual_network': {'key': 'virtualNetwork', 'type': 'VirtualNetworkProfile'},
        'internal_load_balancing_mode': {'key': 'internalLoadBalancingMode', 'type': 'str'},
        'multi_size': {'key': 'multiSize', 'type': 'str'},
        'multi_role_count': {'key': 'multiRoleCount', 'type': 'int'},
        'ipssl_address_count': {'key': 'ipsslAddressCount', 'type': 'int'},
        'dns_suffix': {'key': 'dnsSuffix', 'type': 'str'},
        'maximum_number_of_machines': {'key': 'maximumNumberOfMachines', 'type': 'int'},
        'front_end_scale_factor': {'key': 'frontEndScaleFactor', 'type': 'int'},
        'suspended': {'key': 'suspended', 'type': 'bool'},
        'cluster_settings': {'key': 'clusterSettings', 'type': '[NameValuePair]'},
        'user_whitelisted_ip_ranges': {'key': 'userWhitelistedIpRanges', 'type': '[str]'},
        'has_linux_workers': {'key': 'hasLinuxWorkers', 'type': 'bool'},
        'dedicated_host_count': {'key': 'dedicatedHostCount', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AppServiceEnvironment, self).__init__(**kwargs)
        self.provisioning_state = None
        self.status = None
        self.virtual_network = kwargs['virtual_network']
        self.internal_load_balancing_mode = kwargs.get('internal_load_balancing_mode', None)
        self.multi_size = kwargs.get('multi_size', None)
        self.multi_role_count = None
        self.ipssl_address_count = kwargs.get('ipssl_address_count', None)
        self.dns_suffix = kwargs.get('dns_suffix', None)
        self.maximum_number_of_machines = None
        self.front_end_scale_factor = kwargs.get('front_end_scale_factor', None)
        self.suspended = None
        self.cluster_settings = kwargs.get('cluster_settings', None)
        self.user_whitelisted_ip_ranges = kwargs.get('user_whitelisted_ip_ranges', None)
        self.has_linux_workers = None
        self.dedicated_host_count = None


class AppServiceEnvironmentCollection(msrest.serialization.Model):
    """Collection of App Service Environments.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2021_01_01.models.AppServiceEnvironmentResource]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AppServiceEnvironmentResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AppServiceEnvironmentCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class AppServiceEnvironmentPatchResource(ProxyOnlyResource):
    """ARM resource for a app service environment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar provisioning_state: Provisioning state of the App Service Environment. Possible values
     include: "Succeeded", "Failed", "Canceled", "InProgress", "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2021_01_01.models.ProvisioningState
    :ivar status: Current status of the App Service Environment. Possible values include:
     "Preparing", "Ready", "Scaling", "Deleting".
    :vartype status: str or ~azure.mgmt.web.v2021_01_01.models.HostingEnvironmentStatus
    :param virtual_network: Description of the Virtual Network.
    :type virtual_network: ~azure.mgmt.web.v2021_01_01.models.VirtualNetworkProfile
    :param internal_load_balancing_mode: Specifies which endpoints to serve internally in the
     Virtual Network for the App Service Environment. Possible values include: "None", "Web",
     "Publishing", "Web, Publishing".
    :type internal_load_balancing_mode: str or ~azure.mgmt.web.v2021_01_01.models.LoadBalancingMode
    :param multi_size: Front-end VM size, e.g. "Medium", "Large".
    :type multi_size: str
    :ivar multi_role_count: Number of front-end instances.
    :vartype multi_role_count: int
    :param ipssl_address_count: Number of IP SSL addresses reserved for the App Service
     Environment.
    :type ipssl_address_count: int
    :param dns_suffix: DNS suffix of the App Service Environment.
    :type dns_suffix: str
    :ivar maximum_number_of_machines: Maximum number of VMs in the App Service Environment.
    :vartype maximum_number_of_machines: int
    :param front_end_scale_factor: Scale factor for front-ends.
    :type front_end_scale_factor: int
    :ivar suspended: :code:`<code>true</code>` if the App Service Environment is suspended;
     otherwise, :code:`<code>false</code>`. The environment can be suspended, e.g. when the
     management endpoint is no longer available
      (most likely because NSG blocked the incoming traffic).
    :vartype suspended: bool
    :param cluster_settings: Custom settings for changing the behavior of the App Service
     Environment.
    :type cluster_settings: list[~azure.mgmt.web.v2021_01_01.models.NameValuePair]
    :param user_whitelisted_ip_ranges: User added ip ranges to whitelist on ASE db.
    :type user_whitelisted_ip_ranges: list[str]
    :ivar has_linux_workers: Flag that displays whether an ASE has linux workers or not.
    :vartype has_linux_workers: bool
    :ivar dedicated_host_count: Dedicated Host Count.
    :vartype dedicated_host_count: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'status': {'readonly': True},
        'multi_role_count': {'readonly': True},
        'maximum_number_of_machines': {'readonly': True},
        'suspended': {'readonly': True},
        'has_linux_workers': {'readonly': True},
        'dedicated_host_count': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'virtual_network': {'key': 'properties.virtualNetwork', 'type': 'VirtualNetworkProfile'},
        'internal_load_balancing_mode': {'key': 'properties.internalLoadBalancingMode', 'type': 'str'},
        'multi_size': {'key': 'properties.multiSize', 'type': 'str'},
        'multi_role_count': {'key': 'properties.multiRoleCount', 'type': 'int'},
        'ipssl_address_count': {'key': 'properties.ipsslAddressCount', 'type': 'int'},
        'dns_suffix': {'key': 'properties.dnsSuffix', 'type': 'str'},
        'maximum_number_of_machines': {'key': 'properties.maximumNumberOfMachines', 'type': 'int'},
        'front_end_scale_factor': {'key': 'properties.frontEndScaleFactor', 'type': 'int'},
        'suspended': {'key': 'properties.suspended', 'type': 'bool'},
        'cluster_settings': {'key': 'properties.clusterSettings', 'type': '[NameValuePair]'},
        'user_whitelisted_ip_ranges': {'key': 'properties.userWhitelistedIpRanges', 'type': '[str]'},
        'has_linux_workers': {'key': 'properties.hasLinuxWorkers', 'type': 'bool'},
        'dedicated_host_count': {'key': 'properties.dedicatedHostCount', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AppServiceEnvironmentPatchResource, self).__init__(**kwargs)
        self.provisioning_state = None
        self.status = None
        self.virtual_network = kwargs.get('virtual_network', None)
        self.internal_load_balancing_mode = kwargs.get('internal_load_balancing_mode', None)
        self.multi_size = kwargs.get('multi_size', None)
        self.multi_role_count = None
        self.ipssl_address_count = kwargs.get('ipssl_address_count', None)
        self.dns_suffix = kwargs.get('dns_suffix', None)
        self.maximum_number_of_machines = None
        self.front_end_scale_factor = kwargs.get('front_end_scale_factor', None)
        self.suspended = None
        self.cluster_settings = kwargs.get('cluster_settings', None)
        self.user_whitelisted_ip_ranges = kwargs.get('user_whitelisted_ip_ranges', None)
        self.has_linux_workers = None
        self.dedicated_host_count = None


class AppServiceEnvironmentResource(Resource):
    """App Service Environment ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :param location: Required. Resource Location.
    :type location: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar provisioning_state: Provisioning state of the App Service Environment. Possible values
     include: "Succeeded", "Failed", "Canceled", "InProgress", "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2021_01_01.models.ProvisioningState
    :ivar status: Current status of the App Service Environment. Possible values include:
     "Preparing", "Ready", "Scaling", "Deleting".
    :vartype status: str or ~azure.mgmt.web.v2021_01_01.models.HostingEnvironmentStatus
    :param virtual_network: Description of the Virtual Network.
    :type virtual_network: ~azure.mgmt.web.v2021_01_01.models.VirtualNetworkProfile
    :param internal_load_balancing_mode: Specifies which endpoints to serve internally in the
     Virtual Network for the App Service Environment. Possible values include: "None", "Web",
     "Publishing", "Web, Publishing".
    :type internal_load_balancing_mode: str or ~azure.mgmt.web.v2021_01_01.models.LoadBalancingMode
    :param multi_size: Front-end VM size, e.g. "Medium", "Large".
    :type multi_size: str
    :ivar multi_role_count: Number of front-end instances.
    :vartype multi_role_count: int
    :param ipssl_address_count: Number of IP SSL addresses reserved for the App Service
     Environment.
    :type ipssl_address_count: int
    :param dns_suffix: DNS suffix of the App Service Environment.
    :type dns_suffix: str
    :ivar maximum_number_of_machines: Maximum number of VMs in the App Service Environment.
    :vartype maximum_number_of_machines: int
    :param front_end_scale_factor: Scale factor for front-ends.
    :type front_end_scale_factor: int
    :ivar suspended: :code:`<code>true</code>` if the App Service Environment is suspended;
     otherwise, :code:`<code>false</code>`. The environment can be suspended, e.g. when the
     management endpoint is no longer available
      (most likely because NSG blocked the incoming traffic).
    :vartype suspended: bool
    :param cluster_settings: Custom settings for changing the behavior of the App Service
     Environment.
    :type cluster_settings: list[~azure.mgmt.web.v2021_01_01.models.NameValuePair]
    :param user_whitelisted_ip_ranges: User added ip ranges to whitelist on ASE db.
    :type user_whitelisted_ip_ranges: list[str]
    :ivar has_linux_workers: Flag that displays whether an ASE has linux workers or not.
    :vartype has_linux_workers: bool
    :ivar dedicated_host_count: Dedicated Host Count.
    :vartype dedicated_host_count: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'location': {'required': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'status': {'readonly': True},
        'multi_role_count': {'readonly': True},
        'maximum_number_of_machines': {'readonly': True},
        'suspended': {'readonly': True},
        'has_linux_workers': {'readonly': True},
        'dedicated_host_count': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'virtual_network': {'key': 'properties.virtualNetwork', 'type': 'VirtualNetworkProfile'},
        'internal_load_balancing_mode': {'key': 'properties.internalLoadBalancingMode', 'type': 'str'},
        'multi_size': {'key': 'properties.multiSize', 'type': 'str'},
        'multi_role_count': {'key': 'properties.multiRoleCount', 'type': 'int'},
        'ipssl_address_count': {'key': 'properties.ipsslAddressCount', 'type': 'int'},
        'dns_suffix': {'key': 'properties.dnsSuffix', 'type': 'str'},
        'maximum_number_of_machines': {'key': 'properties.maximumNumberOfMachines', 'type': 'int'},
        'front_end_scale_factor': {'key': 'properties.frontEndScaleFactor', 'type': 'int'},
        'suspended': {'key': 'properties.suspended', 'type': 'bool'},
        'cluster_settings': {'key': 'properties.clusterSettings', 'type': '[NameValuePair]'},
        'user_whitelisted_ip_ranges': {'key': 'properties.userWhitelistedIpRanges', 'type': '[str]'},
        'has_linux_workers': {'key': 'properties.hasLinuxWorkers', 'type': 'bool'},
        'dedicated_host_count': {'key': 'properties.dedicatedHostCount', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AppServiceEnvironmentResource, self).__init__(**kwargs)
        self.provisioning_state = None
        self.status = None
        self.virtual_network = kwargs.get('virtual_network', None)
        self.internal_load_balancing_mode = kwargs.get('internal_load_balancing_mode', None)
        self.multi_size = kwargs.get('multi_size', None)
        self.multi_role_count = None
        self.ipssl_address_count = kwargs.get('ipssl_address_count', None)
        self.dns_suffix = kwargs.get('dns_suffix', None)
        self.maximum_number_of_machines = None
        self.front_end_scale_factor = kwargs.get('front_end_scale_factor', None)
        self.suspended = None
        self.cluster_settings = kwargs.get('cluster_settings', None)
        self.user_whitelisted_ip_ranges = kwargs.get('user_whitelisted_ip_ranges', None)
        self.has_linux_workers = None
        self.dedicated_host_count = None


class AppserviceGithubToken(msrest.serialization.Model):
    """Github access token for Appservice CLI github integration.

    :param access_token: Github access token for Appservice CLI github integration.
    :type access_token: str
    :param scope: Scope of the github access token.
    :type scope: str
    :param token_type: token type.
    :type token_type: str
    :param got_token: True if valid github token received, False otherwise.
    :type got_token: bool
    :param error_message: Error message if unable to get token.
    :type error_message: str
    """

    _attribute_map = {
        'access_token': {'key': 'accessToken', 'type': 'str'},
        'scope': {'key': 'scope', 'type': 'str'},
        'token_type': {'key': 'tokenType', 'type': 'str'},
        'got_token': {'key': 'gotToken', 'type': 'bool'},
        'error_message': {'key': 'errorMessage', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AppserviceGithubToken, self).__init__(**kwargs)
        self.access_token = kwargs.get('access_token', None)
        self.scope = kwargs.get('scope', None)
        self.token_type = kwargs.get('token_type', None)
        self.got_token = kwargs.get('got_token', None)
        self.error_message = kwargs.get('error_message', None)


class AppserviceGithubTokenRequest(msrest.serialization.Model):
    """Appservice Github token request content.

    All required parameters must be populated in order to send to Azure.

    :param code: Required. Code string to exchange for Github Access token.
    :type code: str
    :param state: Required. State string used for verification.
    :type state: str
    """

    _validation = {
        'code': {'required': True},
        'state': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AppserviceGithubTokenRequest, self).__init__(**kwargs)
        self.code = kwargs['code']
        self.state = kwargs['state']


class AppServicePlan(Resource):
    """App Service plan.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :param location: Required. Resource Location.
    :type location: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: Description of a SKU for a scalable resource.
    :type sku: ~azure.mgmt.web.v2021_01_01.models.SkuDescription
    :param extended_location: Extended Location.
    :type extended_location: ~azure.mgmt.web.v2021_01_01.models.ExtendedLocation
    :param worker_tier_name: Target worker tier assigned to the App Service plan.
    :type worker_tier_name: str
    :ivar status: App Service plan status. Possible values include: "Ready", "Pending", "Creating".
    :vartype status: str or ~azure.mgmt.web.v2021_01_01.models.StatusOptions
    :ivar subscription: App Service plan subscription.
    :vartype subscription: str
    :param hosting_environment_profile: Specification for the App Service Environment to use for
     the App Service plan.
    :type hosting_environment_profile: ~azure.mgmt.web.v2021_01_01.models.HostingEnvironmentProfile
    :ivar maximum_number_of_workers: Maximum number of instances that can be assigned to this App
     Service plan.
    :vartype maximum_number_of_workers: int
    :ivar geo_region: Geographical location for the App Service plan.
    :vartype geo_region: str
    :param per_site_scaling: If :code:`<code>true</code>`, apps assigned to this App Service plan
     can be scaled independently.
     If :code:`<code>false</code>`, apps assigned to this App Service plan will scale to all
     instances of the plan.
    :type per_site_scaling: bool
    :param maximum_elastic_worker_count: Maximum number of total workers allowed for this
     ElasticScaleEnabled App Service Plan.
    :type maximum_elastic_worker_count: int
    :ivar number_of_sites: Number of apps assigned to this App Service plan.
    :vartype number_of_sites: int
    :param is_spot: If :code:`<code>true</code>`, this App Service Plan owns spot instances.
    :type is_spot: bool
    :param spot_expiration_time: The time when the server farm expires. Valid only if it is a spot
     server farm.
    :type spot_expiration_time: ~datetime.datetime
    :param free_offer_expiration_time: The time when the server farm free offer expires.
    :type free_offer_expiration_time: ~datetime.datetime
    :ivar resource_group: Resource group of the App Service plan.
    :vartype resource_group: str
    :param reserved: If Linux app service plan :code:`<code>true</code>`,
     :code:`<code>false</code>` otherwise.
    :type reserved: bool
    :param is_xenon: Obsolete: If Hyper-V container app service plan :code:`<code>true</code>`,
     :code:`<code>false</code>` otherwise.
    :type is_xenon: bool
    :param hyper_v: If Hyper-V container app service plan :code:`<code>true</code>`,
     :code:`<code>false</code>` otherwise.
    :type hyper_v: bool
    :param target_worker_count: Scaling worker count.
    :type target_worker_count: int
    :param target_worker_size_id: Scaling worker size ID.
    :type target_worker_size_id: int
    :ivar provisioning_state: Provisioning state of the App Service Plan. Possible values include:
     "Succeeded", "Failed", "Canceled", "InProgress", "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2021_01_01.models.ProvisioningState
    :param kube_environment_profile: Specification for the Kubernetes Environment to use for the
     App Service plan.
    :type kube_environment_profile: ~azure.mgmt.web.v2021_01_01.models.KubeEnvironmentProfile
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'location': {'required': True},
        'type': {'readonly': True},
        'status': {'readonly': True},
        'subscription': {'readonly': True},
        'maximum_number_of_workers': {'readonly': True},
        'geo_region': {'readonly': True},
        'number_of_sites': {'readonly': True},
        'resource_group': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'SkuDescription'},
        'extended_location': {'key': 'extendedLocation', 'type': 'ExtendedLocation'},
        'worker_tier_name': {'key': 'properties.workerTierName', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'subscription': {'key': 'properties.subscription', 'type': 'str'},
        'hosting_environment_profile': {'key': 'properties.hostingEnvironmentProfile', 'type': 'HostingEnvironmentProfile'},
        'maximum_number_of_workers': {'key': 'properties.maximumNumberOfWorkers', 'type': 'int'},
        'geo_region': {'key': 'properties.geoRegion', 'type': 'str'},
        'per_site_scaling': {'key': 'properties.perSiteScaling', 'type': 'bool'},
        'maximum_elastic_worker_count': {'key': 'properties.maximumElasticWorkerCount', 'type': 'int'},
        'number_of_sites': {'key': 'properties.numberOfSites', 'type': 'int'},
        'is_spot': {'key': 'properties.isSpot', 'type': 'bool'},
        'spot_expiration_time': {'key': 'properties.spotExpirationTime', 'type': 'iso-8601'},
        'free_offer_expiration_time': {'key': 'properties.freeOfferExpirationTime', 'type': 'iso-8601'},
        'resource_group': {'key': 'properties.resourceGroup', 'type': 'str'},
        'reserved': {'key': 'properties.reserved', 'type': 'bool'},
        'is_xenon': {'key': 'properties.isXenon', 'type': 'bool'},
        'hyper_v': {'key': 'properties.hyperV', 'type': 'bool'},
        'target_worker_count': {'key': 'properties.targetWorkerCount', 'type': 'int'},
        'target_worker_size_id': {'key': 'properties.targetWorkerSizeId', 'type': 'int'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'kube_environment_profile': {'key': 'properties.kubeEnvironmentProfile', 'type': 'KubeEnvironmentProfile'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AppServicePlan, self).__init__(**kwargs)
        self.sku = kwargs.get('sku', None)
        self.extended_location = kwargs.get('extended_location', None)
        self.worker_tier_name = kwargs.get('worker_tier_name', None)
        self.status = None
        self.subscription = None
        self.hosting_environment_profile = kwargs.get('hosting_environment_profile', None)
        self.maximum_number_of_workers = None
        self.geo_region = None
        self.per_site_scaling = kwargs.get('per_site_scaling', False)
        self.maximum_elastic_worker_count = kwargs.get('maximum_elastic_worker_count', None)
        self.number_of_sites = None
        self.is_spot = kwargs.get('is_spot', None)
        self.spot_expiration_time = kwargs.get('spot_expiration_time', None)
        self.free_offer_expiration_time = kwargs.get('free_offer_expiration_time', None)
        self.resource_group = None
        self.reserved = kwargs.get('reserved', False)
        self.is_xenon = kwargs.get('is_xenon', False)
        self.hyper_v = kwargs.get('hyper_v', False)
        self.target_worker_count = kwargs.get('target_worker_count', None)
        self.target_worker_size_id = kwargs.get('target_worker_size_id', None)
        self.provisioning_state = None
        self.kube_environment_profile = kwargs.get('kube_environment_profile', None)


class AppServicePlanCollection(msrest.serialization.Model):
    """Collection of App Service plans.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2021_01_01.models.AppServicePlan]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AppServicePlan]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AppServicePlanCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class AppServicePlanPatchResource(ProxyOnlyResource):
    """ARM resource for a app service plan.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param worker_tier_name: Target worker tier assigned to the App Service plan.
    :type worker_tier_name: str
    :ivar status: App Service plan status. Possible values include: "Ready", "Pending", "Creating".
    :vartype status: str or ~azure.mgmt.web.v2021_01_01.models.StatusOptions
    :ivar subscription: App Service plan subscription.
    :vartype subscription: str
    :param hosting_environment_profile: Specification for the App Service Environment to use for
     the App Service plan.
    :type hosting_environment_profile: ~azure.mgmt.web.v2021_01_01.models.HostingEnvironmentProfile
    :ivar maximum_number_of_workers: Maximum number of instances that can be assigned to this App
     Service plan.
    :vartype maximum_number_of_workers: int
    :ivar geo_region: Geographical location for the App Service plan.
    :vartype geo_region: str
    :param per_site_scaling: If :code:`<code>true</code>`, apps assigned to this App Service plan
     can be scaled independently.
     If :code:`<code>false</code>`, apps assigned to this App Service plan will scale to all
     instances of the plan.
    :type per_site_scaling: bool
    :param elastic_scale_enabled: ServerFarm supports ElasticScale. Apps in this plan will scale as
     if the ServerFarm was ElasticPremium sku.
    :type elastic_scale_enabled: bool
    :param maximum_elastic_worker_count: Maximum number of total workers allowed for this
     ElasticScaleEnabled App Service Plan.
    :type maximum_elastic_worker_count: int
    :ivar number_of_sites: Number of apps assigned to this App Service plan.
    :vartype number_of_sites: int
    :param is_spot: If :code:`<code>true</code>`, this App Service Plan owns spot instances.
    :type is_spot: bool
    :param spot_expiration_time: The time when the server farm expires. Valid only if it is a spot
     server farm.
    :type spot_expiration_time: ~datetime.datetime
    :param free_offer_expiration_time: The time when the server farm free offer expires.
    :type free_offer_expiration_time: ~datetime.datetime
    :ivar resource_group: Resource group of the App Service plan.
    :vartype resource_group: str
    :param reserved: If Linux app service plan :code:`<code>true</code>`,
     :code:`<code>false</code>` otherwise.
    :type reserved: bool
    :param is_xenon: Obsolete: If Hyper-V container app service plan :code:`<code>true</code>`,
     :code:`<code>false</code>` otherwise.
    :type is_xenon: bool
    :param hyper_v: If Hyper-V container app service plan :code:`<code>true</code>`,
     :code:`<code>false</code>` otherwise.
    :type hyper_v: bool
    :param target_worker_count: Scaling worker count.
    :type target_worker_count: int
    :param target_worker_size_id: Scaling worker size ID.
    :type target_worker_size_id: int
    :ivar provisioning_state: Provisioning state of the App Service Plan. Possible values include:
     "Succeeded", "Failed", "Canceled", "InProgress", "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2021_01_01.models.ProvisioningState
    :param kube_environment_profile: Specification for the Kubernetes Environment to use for the
     App Service plan.
    :type kube_environment_profile: ~azure.mgmt.web.v2021_01_01.models.KubeEnvironmentProfile
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'status': {'readonly': True},
        'subscription': {'readonly': True},
        'maximum_number_of_workers': {'readonly': True},
        'geo_region': {'readonly': True},
        'number_of_sites': {'readonly': True},
        'resource_group': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'worker_tier_name': {'key': 'properties.workerTierName', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'subscription': {'key': 'properties.subscription', 'type': 'str'},
        'hosting_environment_profile': {'key': 'properties.hostingEnvironmentProfile', 'type': 'HostingEnvironmentProfile'},
        'maximum_number_of_workers': {'key': 'properties.maximumNumberOfWorkers', 'type': 'int'},
        'geo_region': {'key': 'properties.geoRegion', 'type': 'str'},
        'per_site_scaling': {'key': 'properties.perSiteScaling', 'type': 'bool'},
        'elastic_scale_enabled': {'key': 'properties.elasticScaleEnabled', 'type': 'bool'},
        'maximum_elastic_worker_count': {'key': 'properties.maximumElasticWorkerCount', 'type': 'int'},
        'number_of_sites': {'key': 'properties.numberOfSites', 'type': 'int'},
        'is_spot': {'key': 'properties.isSpot', 'type': 'bool'},
        'spot_expiration_time': {'key': 'properties.spotExpirationTime', 'type': 'iso-8601'},
        'free_offer_expiration_time': {'key': 'properties.freeOfferExpirationTime', 'type': 'iso-8601'},
        'resource_group': {'key': 'properties.resourceGroup', 'type': 'str'},
        'reserved': {'key': 'properties.reserved', 'type': 'bool'},
        'is_xenon': {'key': 'properties.isXenon', 'type': 'bool'},
        'hyper_v': {'key': 'properties.hyperV', 'type': 'bool'},
        'target_worker_count': {'key': 'properties.targetWorkerCount', 'type': 'int'},
        'target_worker_size_id': {'key': 'properties.targetWorkerSizeId', 'type': 'int'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'kube_environment_profile': {'key': 'properties.kubeEnvironmentProfile', 'type': 'KubeEnvironmentProfile'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AppServicePlanPatchResource, self).__init__(**kwargs)
        self.worker_tier_name = kwargs.get('worker_tier_name', None)
        self.status = None
        self.subscription = None
        self.hosting_environment_profile = kwargs.get('hosting_environment_profile', None)
        self.maximum_number_of_workers = None
        self.geo_region = None
        self.per_site_scaling = kwargs.get('per_site_scaling', False)
        self.elastic_scale_enabled = kwargs.get('elastic_scale_enabled', None)
        self.maximum_elastic_worker_count = kwargs.get('maximum_elastic_worker_count', None)
        self.number_of_sites = None
        self.is_spot = kwargs.get('is_spot', None)
        self.spot_expiration_time = kwargs.get('spot_expiration_time', None)
        self.free_offer_expiration_time = kwargs.get('free_offer_expiration_time', None)
        self.resource_group = None
        self.reserved = kwargs.get('reserved', False)
        self.is_xenon = kwargs.get('is_xenon', False)
        self.hyper_v = kwargs.get('hyper_v', False)
        self.target_worker_count = kwargs.get('target_worker_count', None)
        self.target_worker_size_id = kwargs.get('target_worker_size_id', None)
        self.provisioning_state = None
        self.kube_environment_profile = kwargs.get('kube_environment_profile', None)


class ArcConfiguration(msrest.serialization.Model):
    """ArcConfiguration.

    :param artifacts_storage_type:  Possible values include: "LocalNode", "NetworkFileSystem".
    :type artifacts_storage_type: str or ~azure.mgmt.web.v2021_01_01.models.StorageType
    :param artifact_storage_class_name:
    :type artifact_storage_class_name: str
    :param artifact_storage_mount_path:
    :type artifact_storage_mount_path: str
    :param artifact_storage_node_name:
    :type artifact_storage_node_name: str
    :param artifact_storage_access_mode:
    :type artifact_storage_access_mode: str
    :param front_end_service_configuration:
    :type front_end_service_configuration: ~azure.mgmt.web.v2021_01_01.models.FrontEndConfiguration
    :param kube_config:
    :type kube_config: str
    """

    _attribute_map = {
        'artifacts_storage_type': {'key': 'artifactsStorageType', 'type': 'str'},
        'artifact_storage_class_name': {'key': 'artifactStorageClassName', 'type': 'str'},
        'artifact_storage_mount_path': {'key': 'artifactStorageMountPath', 'type': 'str'},
        'artifact_storage_node_name': {'key': 'artifactStorageNodeName', 'type': 'str'},
        'artifact_storage_access_mode': {'key': 'artifactStorageAccessMode', 'type': 'str'},
        'front_end_service_configuration': {'key': 'frontEndServiceConfiguration', 'type': 'FrontEndConfiguration'},
        'kube_config': {'key': 'kubeConfig', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ArcConfiguration, self).__init__(**kwargs)
        self.artifacts_storage_type = kwargs.get('artifacts_storage_type', None)
        self.artifact_storage_class_name = kwargs.get('artifact_storage_class_name', None)
        self.artifact_storage_mount_path = kwargs.get('artifact_storage_mount_path', None)
        self.artifact_storage_node_name = kwargs.get('artifact_storage_node_name', None)
        self.artifact_storage_access_mode = kwargs.get('artifact_storage_access_mode', None)
        self.front_end_service_configuration = kwargs.get('front_end_service_configuration', None)
        self.kube_config = kwargs.get('kube_config', None)


class ArmIdWrapper(msrest.serialization.Model):
    """A wrapper for an ARM resource id.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id:
    :vartype id: str
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ArmIdWrapper, self).__init__(**kwargs)
        self.id = None


class ArmPlan(msrest.serialization.Model):
    """The plan object in Azure Resource Manager, represents a marketplace plan.

    :param name: The name.
    :type name: str
    :param publisher: The publisher.
    :type publisher: str
    :param product: The product.
    :type product: str
    :param promotion_code: The promotion code.
    :type promotion_code: str
    :param version: Version of product.
    :type version: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'publisher': {'key': 'publisher', 'type': 'str'},
        'product': {'key': 'product', 'type': 'str'},
        'promotion_code': {'key': 'promotionCode', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ArmPlan, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.publisher = kwargs.get('publisher', None)
        self.product = kwargs.get('product', None)
        self.promotion_code = kwargs.get('promotion_code', None)
        self.version = kwargs.get('version', None)


class AseV3NetworkingConfiguration(ProxyOnlyResource):
    """Full view of networking configuration for an ASE.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar windows_outbound_ip_addresses:
    :vartype windows_outbound_ip_addresses: list[str]
    :ivar linux_outbound_ip_addresses:
    :vartype linux_outbound_ip_addresses: list[str]
    :param allow_new_private_endpoint_connections: Property to enable and disable new private
     endpoint connection creation on ASE.
    :type allow_new_private_endpoint_connections: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'windows_outbound_ip_addresses': {'readonly': True},
        'linux_outbound_ip_addresses': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'windows_outbound_ip_addresses': {'key': 'properties.windowsOutboundIpAddresses', 'type': '[str]'},
        'linux_outbound_ip_addresses': {'key': 'properties.linuxOutboundIpAddresses', 'type': '[str]'},
        'allow_new_private_endpoint_connections': {'key': 'properties.allowNewPrivateEndpointConnections', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AseV3NetworkingConfiguration, self).__init__(**kwargs)
        self.windows_outbound_ip_addresses = None
        self.linux_outbound_ip_addresses = None
        self.allow_new_private_endpoint_connections = kwargs.get('allow_new_private_endpoint_connections', None)


class AuthPlatform(msrest.serialization.Model):
    """The configuration settings of the platform of App Service Authentication/Authorization.

    :param enabled: :code:`<code>true</code>` if the Authentication / Authorization feature is
     enabled for the current app; otherwise, :code:`<code>false</code>`.
    :type enabled: bool
    :param runtime_version: The RuntimeVersion of the Authentication / Authorization feature in use
     for the current app.
     The setting in this value can control the behavior of certain features in the Authentication /
     Authorization module.
    :type runtime_version: str
    :param config_file_path: The path of the config file containing auth settings if they come from
     a file.
     If the path is relative, base will the site's root directory.
    :type config_file_path: str
    """

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'runtime_version': {'key': 'runtimeVersion', 'type': 'str'},
        'config_file_path': {'key': 'configFilePath', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AuthPlatform, self).__init__(**kwargs)
        self.enabled = kwargs.get('enabled', None)
        self.runtime_version = kwargs.get('runtime_version', None)
        self.config_file_path = kwargs.get('config_file_path', None)


class AutoHealActions(msrest.serialization.Model):
    """Actions which to take by the auto-heal module when a rule is triggered.

    :param action_type: Predefined action to be taken. Possible values include: "Recycle",
     "LogEvent", "CustomAction".
    :type action_type: str or ~azure.mgmt.web.v2021_01_01.models.AutoHealActionType
    :param custom_action: Custom action to be taken.
    :type custom_action: ~azure.mgmt.web.v2021_01_01.models.AutoHealCustomAction
    :param min_process_execution_time: Minimum time the process must execute
     before taking the action.
    :type min_process_execution_time: str
    """

    _attribute_map = {
        'action_type': {'key': 'actionType', 'type': 'str'},
        'custom_action': {'key': 'customAction', 'type': 'AutoHealCustomAction'},
        'min_process_execution_time': {'key': 'minProcessExecutionTime', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AutoHealActions, self).__init__(**kwargs)
        self.action_type = kwargs.get('action_type', None)
        self.custom_action = kwargs.get('custom_action', None)
        self.min_process_execution_time = kwargs.get('min_process_execution_time', None)


class AutoHealCustomAction(msrest.serialization.Model):
    """Custom action to be executed
when an auto heal rule is triggered.

    :param exe: Executable to be run.
    :type exe: str
    :param parameters: Parameters for the executable.
    :type parameters: str
    """

    _attribute_map = {
        'exe': {'key': 'exe', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AutoHealCustomAction, self).__init__(**kwargs)
        self.exe = kwargs.get('exe', None)
        self.parameters = kwargs.get('parameters', None)


class AutoHealRules(msrest.serialization.Model):
    """Rules that can be defined for auto-heal.

    :param triggers: Conditions that describe when to execute the auto-heal actions.
    :type triggers: ~azure.mgmt.web.v2021_01_01.models.AutoHealTriggers
    :param actions: Actions to be executed when a rule is triggered.
    :type actions: ~azure.mgmt.web.v2021_01_01.models.AutoHealActions
    """

    _attribute_map = {
        'triggers': {'key': 'triggers', 'type': 'AutoHealTriggers'},
        'actions': {'key': 'actions', 'type': 'AutoHealActions'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AutoHealRules, self).__init__(**kwargs)
        self.triggers = kwargs.get('triggers', None)
        self.actions = kwargs.get('actions', None)


class AutoHealTriggers(msrest.serialization.Model):
    """Triggers for auto-heal.

    :param requests: A rule based on total requests.
    :type requests: ~azure.mgmt.web.v2021_01_01.models.RequestsBasedTrigger
    :param private_bytes_in_kb: A rule based on private bytes.
    :type private_bytes_in_kb: int
    :param status_codes: A rule based on status codes.
    :type status_codes: list[~azure.mgmt.web.v2021_01_01.models.StatusCodesBasedTrigger]
    :param slow_requests: A rule based on request execution time.
    :type slow_requests: ~azure.mgmt.web.v2021_01_01.models.SlowRequestsBasedTrigger
    :param slow_requests_with_path: A rule based on multiple Slow Requests Rule with path.
    :type slow_requests_with_path:
     list[~azure.mgmt.web.v2021_01_01.models.SlowRequestsBasedTrigger]
    :param status_codes_range: A rule based on status codes ranges.
    :type status_codes_range: list[~azure.mgmt.web.v2021_01_01.models.StatusCodesRangeBasedTrigger]
    """

    _attribute_map = {
        'requests': {'key': 'requests', 'type': 'RequestsBasedTrigger'},
        'private_bytes_in_kb': {'key': 'privateBytesInKB', 'type': 'int'},
        'status_codes': {'key': 'statusCodes', 'type': '[StatusCodesBasedTrigger]'},
        'slow_requests': {'key': 'slowRequests', 'type': 'SlowRequestsBasedTrigger'},
        'slow_requests_with_path': {'key': 'slowRequestsWithPath', 'type': '[SlowRequestsBasedTrigger]'},
        'status_codes_range': {'key': 'statusCodesRange', 'type': '[StatusCodesRangeBasedTrigger]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AutoHealTriggers, self).__init__(**kwargs)
        self.requests = kwargs.get('requests', None)
        self.private_bytes_in_kb = kwargs.get('private_bytes_in_kb', None)
        self.status_codes = kwargs.get('status_codes', None)
        self.slow_requests = kwargs.get('slow_requests', None)
        self.slow_requests_with_path = kwargs.get('slow_requests_with_path', None)
        self.status_codes_range = kwargs.get('status_codes_range', None)


class AzureActiveDirectory(msrest.serialization.Model):
    """The configuration settings of the Azure Active directory provider.

    :param enabled: :code:`<code>false</code>` if the Azure Active Directory provider should not be
     enabled despite the set registration; otherwise, :code:`<code>true</code>`.
    :type enabled: bool
    :param registration: The configuration settings of the Azure Active Directory app registration.
    :type registration: ~azure.mgmt.web.v2021_01_01.models.AzureActiveDirectoryRegistration
    :param login: The configuration settings of the Azure Active Directory login flow.
    :type login: ~azure.mgmt.web.v2021_01_01.models.AzureActiveDirectoryLogin
    :param validation: The configuration settings of the Azure Active Directory token validation
     flow.
    :type validation: ~azure.mgmt.web.v2021_01_01.models.AzureActiveDirectoryValidation
    :param is_auto_provisioned: Gets a value indicating whether the Azure AD configuration was
     auto-provisioned using 1st party tooling.
     This is an internal flag primarily intended to support the Azure Management Portal. Users
     should not
     read or write to this property.
    :type is_auto_provisioned: bool
    """

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'registration': {'key': 'registration', 'type': 'AzureActiveDirectoryRegistration'},
        'login': {'key': 'login', 'type': 'AzureActiveDirectoryLogin'},
        'validation': {'key': 'validation', 'type': 'AzureActiveDirectoryValidation'},
        'is_auto_provisioned': {'key': 'isAutoProvisioned', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureActiveDirectory, self).__init__(**kwargs)
        self.enabled = kwargs.get('enabled', None)
        self.registration = kwargs.get('registration', None)
        self.login = kwargs.get('login', None)
        self.validation = kwargs.get('validation', None)
        self.is_auto_provisioned = kwargs.get('is_auto_provisioned', None)


class AzureActiveDirectoryLogin(msrest.serialization.Model):
    """The configuration settings of the Azure Active Directory login flow.

    :param login_parameters: Login parameters to send to the OpenID Connect authorization endpoint
     when
     a user logs in. Each parameter must be in the form "key=value".
    :type login_parameters: list[str]
    :param disable_www_authenticate: :code:`<code>true</code>` if the www-authenticate provider
     should be omitted from the request; otherwise, :code:`<code>false</code>`.
    :type disable_www_authenticate: bool
    """

    _attribute_map = {
        'login_parameters': {'key': 'loginParameters', 'type': '[str]'},
        'disable_www_authenticate': {'key': 'disableWWWAuthenticate', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureActiveDirectoryLogin, self).__init__(**kwargs)
        self.login_parameters = kwargs.get('login_parameters', None)
        self.disable_www_authenticate = kwargs.get('disable_www_authenticate', None)


class AzureActiveDirectoryRegistration(msrest.serialization.Model):
    """The configuration settings of the Azure Active Directory app registration.

    :param open_id_issuer: The OpenID Connect Issuer URI that represents the entity which issues
     access tokens for this application.
     When using Azure Active Directory, this value is the URI of the directory tenant, e.g.
     https://login.microsoftonline.com/v2.0/{tenant-guid}/.
     This URI is a case-sensitive identifier for the token issuer.
     More information on OpenID Connect Discovery:
     http://openid.net/specs/openid-connect-discovery-1_0.html.
    :type open_id_issuer: str
    :param client_id: The Client ID of this relying party application, known as the client_id.
     This setting is required for enabling OpenID Connection authentication with Azure Active
     Directory or
     other 3rd party OpenID Connect providers.
     More information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html.
    :type client_id: str
    :param client_secret_setting_name: The app setting name that contains the client secret of the
     relying party application.
    :type client_secret_setting_name: str
    :param client_secret_certificate_thumbprint: An alternative to the client secret, that is the
     thumbprint of a certificate used for signing purposes. This property acts as
     a replacement for the Client Secret. It is also optional.
    :type client_secret_certificate_thumbprint: str
    :param client_secret_certificate_subject_alternative_name: An alternative to the client secret
     thumbprint, that is the subject alternative name of a certificate used for signing purposes.
     This property acts as
     a replacement for the Client Secret Certificate Thumbprint. It is also optional.
    :type client_secret_certificate_subject_alternative_name: str
    :param client_secret_certificate_issuer: An alternative to the client secret thumbprint, that
     is the issuer of a certificate used for signing purposes. This property acts as
     a replacement for the Client Secret Certificate Thumbprint. It is also optional.
    :type client_secret_certificate_issuer: str
    """

    _attribute_map = {
        'open_id_issuer': {'key': 'openIdIssuer', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
        'client_secret_setting_name': {'key': 'clientSecretSettingName', 'type': 'str'},
        'client_secret_certificate_thumbprint': {'key': 'clientSecretCertificateThumbprint', 'type': 'str'},
        'client_secret_certificate_subject_alternative_name': {'key': 'clientSecretCertificateSubjectAlternativeName', 'type': 'str'},
        'client_secret_certificate_issuer': {'key': 'clientSecretCertificateIssuer', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureActiveDirectoryRegistration, self).__init__(**kwargs)
        self.open_id_issuer = kwargs.get('open_id_issuer', None)
        self.client_id = kwargs.get('client_id', None)
        self.client_secret_setting_name = kwargs.get('client_secret_setting_name', None)
        self.client_secret_certificate_thumbprint = kwargs.get('client_secret_certificate_thumbprint', None)
        self.client_secret_certificate_subject_alternative_name = kwargs.get('client_secret_certificate_subject_alternative_name', None)
        self.client_secret_certificate_issuer = kwargs.get('client_secret_certificate_issuer', None)


class AzureActiveDirectoryValidation(msrest.serialization.Model):
    """The configuration settings of the Azure Active Directory token validation flow.

    :param jwt_claim_checks: The configuration settings of the checks that should be made while
     validating the JWT Claims.
    :type jwt_claim_checks: ~azure.mgmt.web.v2021_01_01.models.JwtClaimChecks
    :param allowed_audiences: The list of audiences that can make successful
     authentication/authorization requests.
    :type allowed_audiences: list[str]
    """

    _attribute_map = {
        'jwt_claim_checks': {'key': 'jwtClaimChecks', 'type': 'JwtClaimChecks'},
        'allowed_audiences': {'key': 'allowedAudiences', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureActiveDirectoryValidation, self).__init__(**kwargs)
        self.jwt_claim_checks = kwargs.get('jwt_claim_checks', None)
        self.allowed_audiences = kwargs.get('allowed_audiences', None)


class AzureBlobStorageApplicationLogsConfig(msrest.serialization.Model):
    """Application logs azure blob storage configuration.

    :param level: Log level. Possible values include: "Off", "Verbose", "Information", "Warning",
     "Error".
    :type level: str or ~azure.mgmt.web.v2021_01_01.models.LogLevel
    :param sas_url: SAS url to a azure blob container with read/write/list/delete permissions.
    :type sas_url: str
    :param retention_in_days: Retention in days.
     Remove blobs older than X days.
     0 or lower means no retention.
    :type retention_in_days: int
    """

    _attribute_map = {
        'level': {'key': 'level', 'type': 'str'},
        'sas_url': {'key': 'sasUrl', 'type': 'str'},
        'retention_in_days': {'key': 'retentionInDays', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureBlobStorageApplicationLogsConfig, self).__init__(**kwargs)
        self.level = kwargs.get('level', None)
        self.sas_url = kwargs.get('sas_url', None)
        self.retention_in_days = kwargs.get('retention_in_days', None)


class AzureBlobStorageHttpLogsConfig(msrest.serialization.Model):
    """Http logs to azure blob storage configuration.

    :param sas_url: SAS url to a azure blob container with read/write/list/delete permissions.
    :type sas_url: str
    :param retention_in_days: Retention in days.
     Remove blobs older than X days.
     0 or lower means no retention.
    :type retention_in_days: int
    :param enabled: True if configuration is enabled, false if it is disabled and null if
     configuration is not set.
    :type enabled: bool
    """

    _attribute_map = {
        'sas_url': {'key': 'sasUrl', 'type': 'str'},
        'retention_in_days': {'key': 'retentionInDays', 'type': 'int'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureBlobStorageHttpLogsConfig, self).__init__(**kwargs)
        self.sas_url = kwargs.get('sas_url', None)
        self.retention_in_days = kwargs.get('retention_in_days', None)
        self.enabled = kwargs.get('enabled', None)


class AzureStaticWebApps(msrest.serialization.Model):
    """The configuration settings of the Azure Static Web Apps provider.

    :param enabled: :code:`<code>false</code>` if the Azure Static Web Apps provider should not be
     enabled despite the set registration; otherwise, :code:`<code>true</code>`.
    :type enabled: bool
    :param registration: The configuration settings of the Azure Static Web Apps registration.
    :type registration: ~azure.mgmt.web.v2021_01_01.models.AzureStaticWebAppsRegistration
    """

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'registration': {'key': 'registration', 'type': 'AzureStaticWebAppsRegistration'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureStaticWebApps, self).__init__(**kwargs)
        self.enabled = kwargs.get('enabled', None)
        self.registration = kwargs.get('registration', None)


class AzureStaticWebAppsRegistration(msrest.serialization.Model):
    """The configuration settings of the registration for the Azure Static Web Apps provider.

    :param client_id: The Client ID of the app used for login.
    :type client_id: str
    """

    _attribute_map = {
        'client_id': {'key': 'clientId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureStaticWebAppsRegistration, self).__init__(**kwargs)
        self.client_id = kwargs.get('client_id', None)


class AzureStorageInfoValue(msrest.serialization.Model):
    """Azure Files or Blob Storage access information value for dictionary storage.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param type: Type of storage. Possible values include: "AzureFiles", "AzureBlob".
    :type type: str or ~azure.mgmt.web.v2021_01_01.models.AzureStorageType
    :param account_name: Name of the storage account.
    :type account_name: str
    :param share_name: Name of the file share (container name, for Blob storage).
    :type share_name: str
    :param access_key: Access key for the storage account.
    :type access_key: str
    :param mount_path: Path to mount the storage within the site's runtime environment.
    :type mount_path: str
    :ivar state: State of the storage account. Possible values include: "Ok", "InvalidCredentials",
     "InvalidShare", "NotValidated".
    :vartype state: str or ~azure.mgmt.web.v2021_01_01.models.AzureStorageState
    """

    _validation = {
        'state': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'account_name': {'key': 'accountName', 'type': 'str'},
        'share_name': {'key': 'shareName', 'type': 'str'},
        'access_key': {'key': 'accessKey', 'type': 'str'},
        'mount_path': {'key': 'mountPath', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureStorageInfoValue, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)
        self.account_name = kwargs.get('account_name', None)
        self.share_name = kwargs.get('share_name', None)
        self.access_key = kwargs.get('access_key', None)
        self.mount_path = kwargs.get('mount_path', None)
        self.state = None


class AzureStoragePropertyDictionaryResource(ProxyOnlyResource):
    """AzureStorageInfo dictionary resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param properties: Azure storage accounts.
    :type properties: dict[str, ~azure.mgmt.web.v2021_01_01.models.AzureStorageInfoValue]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{AzureStorageInfoValue}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureStoragePropertyDictionaryResource, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)


class AzureTableStorageApplicationLogsConfig(msrest.serialization.Model):
    """Application logs to Azure table storage configuration.

    All required parameters must be populated in order to send to Azure.

    :param level: Log level. Possible values include: "Off", "Verbose", "Information", "Warning",
     "Error".
    :type level: str or ~azure.mgmt.web.v2021_01_01.models.LogLevel
    :param sas_url: Required. SAS URL to an Azure table with add/query/delete permissions.
    :type sas_url: str
    """

    _validation = {
        'sas_url': {'required': True},
    }

    _attribute_map = {
        'level': {'key': 'level', 'type': 'str'},
        'sas_url': {'key': 'sasUrl', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureTableStorageApplicationLogsConfig, self).__init__(**kwargs)
        self.level = kwargs.get('level', None)
        self.sas_url = kwargs['sas_url']


class BackupItem(ProxyOnlyResource):
    """Backup description.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar backup_id: Id of the backup.
    :vartype backup_id: int
    :ivar storage_account_url: SAS URL for the storage account container which contains this
     backup.
    :vartype storage_account_url: str
    :ivar blob_name: Name of the blob which contains data for this backup.
    :vartype blob_name: str
    :ivar name_properties_name: Name of this backup.
    :vartype name_properties_name: str
    :ivar status: Backup status. Possible values include: "InProgress", "Failed", "Succeeded",
     "TimedOut", "Created", "Skipped", "PartiallySucceeded", "DeleteInProgress", "DeleteFailed",
     "Deleted".
    :vartype status: str or ~azure.mgmt.web.v2021_01_01.models.BackupItemStatus
    :ivar size_in_bytes: Size of the backup in bytes.
    :vartype size_in_bytes: long
    :ivar created: Timestamp of the backup creation.
    :vartype created: ~datetime.datetime
    :ivar log: Details regarding this backup. Might contain an error message.
    :vartype log: str
    :ivar databases: List of databases included in the backup.
    :vartype databases: list[~azure.mgmt.web.v2021_01_01.models.DatabaseBackupSetting]
    :ivar scheduled: True if this backup has been created due to a schedule being triggered.
    :vartype scheduled: bool
    :ivar last_restore_time_stamp: Timestamp of a last restore operation which used this backup.
    :vartype last_restore_time_stamp: ~datetime.datetime
    :ivar finished_time_stamp: Timestamp when this backup finished.
    :vartype finished_time_stamp: ~datetime.datetime
    :ivar correlation_id: Unique correlation identifier. Please use this along with the timestamp
     while communicating with Azure support.
    :vartype correlation_id: str
    :ivar website_size_in_bytes: Size of the original web app which has been backed up.
    :vartype website_size_in_bytes: long
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'backup_id': {'readonly': True},
        'storage_account_url': {'readonly': True},
        'blob_name': {'readonly': True},
        'name_properties_name': {'readonly': True},
        'status': {'readonly': True},
        'size_in_bytes': {'readonly': True},
        'created': {'readonly': True},
        'log': {'readonly': True},
        'databases': {'readonly': True},
        'scheduled': {'readonly': True},
        'last_restore_time_stamp': {'readonly': True},
        'finished_time_stamp': {'readonly': True},
        'correlation_id': {'readonly': True},
        'website_size_in_bytes': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'backup_id': {'key': 'properties.id', 'type': 'int'},
        'storage_account_url': {'key': 'properties.storageAccountUrl', 'type': 'str'},
        'blob_name': {'key': 'properties.blobName', 'type': 'str'},
        'name_properties_name': {'key': 'properties.name', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'size_in_bytes': {'key': 'properties.sizeInBytes', 'type': 'long'},
        'created': {'key': 'properties.created', 'type': 'iso-8601'},
        'log': {'key': 'properties.log', 'type': 'str'},
        'databases': {'key': 'properties.databases', 'type': '[DatabaseBackupSetting]'},
        'scheduled': {'key': 'properties.scheduled', 'type': 'bool'},
        'last_restore_time_stamp': {'key': 'properties.lastRestoreTimeStamp', 'type': 'iso-8601'},
        'finished_time_stamp': {'key': 'properties.finishedTimeStamp', 'type': 'iso-8601'},
        'correlation_id': {'key': 'properties.correlationId', 'type': 'str'},
        'website_size_in_bytes': {'key': 'properties.websiteSizeInBytes', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BackupItem, self).__init__(**kwargs)
        self.backup_id = None
        self.storage_account_url = None
        self.blob_name = None
        self.name_properties_name = None
        self.status = None
        self.size_in_bytes = None
        self.created = None
        self.log = None
        self.databases = None
        self.scheduled = None
        self.last_restore_time_stamp = None
        self.finished_time_stamp = None
        self.correlation_id = None
        self.website_size_in_bytes = None


class BackupItemCollection(msrest.serialization.Model):
    """Collection of backup items.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2021_01_01.models.BackupItem]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[BackupItem]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BackupItemCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class BackupRequest(ProxyOnlyResource):
    """Description of a backup which will be performed.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param backup_name: Name of the backup.
    :type backup_name: str
    :param enabled: True if the backup schedule is enabled (must be included in that case), false
     if the backup schedule should be disabled.
    :type enabled: bool
    :param storage_account_url: SAS URL to the container.
    :type storage_account_url: str
    :param backup_schedule: Schedule for the backup if it is executed periodically.
    :type backup_schedule: ~azure.mgmt.web.v2021_01_01.models.BackupSchedule
    :param databases: Databases included in the backup.
    :type databases: list[~azure.mgmt.web.v2021_01_01.models.DatabaseBackupSetting]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'backup_name': {'key': 'properties.backupName', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'storage_account_url': {'key': 'properties.storageAccountUrl', 'type': 'str'},
        'backup_schedule': {'key': 'properties.backupSchedule', 'type': 'BackupSchedule'},
        'databases': {'key': 'properties.databases', 'type': '[DatabaseBackupSetting]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BackupRequest, self).__init__(**kwargs)
        self.backup_name = kwargs.get('backup_name', None)
        self.enabled = kwargs.get('enabled', None)
        self.storage_account_url = kwargs.get('storage_account_url', None)
        self.backup_schedule = kwargs.get('backup_schedule', None)
        self.databases = kwargs.get('databases', None)


class BackupSchedule(msrest.serialization.Model):
    """Description of a backup schedule. Describes how often should be the backup performed and what should be the retention policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param frequency_interval: Required. How often the backup should be executed (e.g. for weekly
     backup, this should be set to 7 and FrequencyUnit should be set to Day).
    :type frequency_interval: int
    :param frequency_unit: Required. The unit of time for how often the backup should be executed
     (e.g. for weekly backup, this should be set to Day and FrequencyInterval should be set to 7).
     Possible values include: "Day", "Hour". Default value: "Day".
    :type frequency_unit: str or ~azure.mgmt.web.v2021_01_01.models.FrequencyUnit
    :param keep_at_least_one_backup: Required. True if the retention policy should always keep at
     least one backup in the storage account, regardless how old it is; false otherwise.
    :type keep_at_least_one_backup: bool
    :param retention_period_in_days: Required. After how many days backups should be deleted.
    :type retention_period_in_days: int
    :param start_time: When the schedule should start working.
    :type start_time: ~datetime.datetime
    :ivar last_execution_time: Last time when this schedule was triggered.
    :vartype last_execution_time: ~datetime.datetime
    """

    _validation = {
        'frequency_interval': {'required': True},
        'frequency_unit': {'required': True},
        'keep_at_least_one_backup': {'required': True},
        'retention_period_in_days': {'required': True},
        'last_execution_time': {'readonly': True},
    }

    _attribute_map = {
        'frequency_interval': {'key': 'frequencyInterval', 'type': 'int'},
        'frequency_unit': {'key': 'frequencyUnit', 'type': 'str'},
        'keep_at_least_one_backup': {'key': 'keepAtLeastOneBackup', 'type': 'bool'},
        'retention_period_in_days': {'key': 'retentionPeriodInDays', 'type': 'int'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'last_execution_time': {'key': 'lastExecutionTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BackupSchedule, self).__init__(**kwargs)
        self.frequency_interval = kwargs.get('frequency_interval', 7)
        self.frequency_unit = kwargs.get('frequency_unit', "Day")
        self.keep_at_least_one_backup = kwargs.get('keep_at_least_one_backup', True)
        self.retention_period_in_days = kwargs.get('retention_period_in_days', 30)
        self.start_time = kwargs.get('start_time', None)
        self.last_execution_time = None


class BillingMeter(ProxyOnlyResource):
    """App Service billing entity that contains information about meter which the Azure billing system utilizes to charge users for services.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param meter_id: Meter GUID onboarded in Commerce.
    :type meter_id: str
    :param billing_location: Azure Location of billable resource.
    :type billing_location: str
    :param short_name: Short Name from App Service Azure pricing Page.
    :type short_name: str
    :param friendly_name: Friendly name of the meter.
    :type friendly_name: str
    :param resource_type: App Service ResourceType meter used for.
    :type resource_type: str
    :param os_type: App Service OS type meter used for.
    :type os_type: str
    :param multiplier: Meter Multiplier.
    :type multiplier: float
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'meter_id': {'key': 'properties.meterId', 'type': 'str'},
        'billing_location': {'key': 'properties.billingLocation', 'type': 'str'},
        'short_name': {'key': 'properties.shortName', 'type': 'str'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'resource_type': {'key': 'properties.resourceType', 'type': 'str'},
        'os_type': {'key': 'properties.osType', 'type': 'str'},
        'multiplier': {'key': 'properties.multiplier', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BillingMeter, self).__init__(**kwargs)
        self.meter_id = kwargs.get('meter_id', None)
        self.billing_location = kwargs.get('billing_location', None)
        self.short_name = kwargs.get('short_name', None)
        self.friendly_name = kwargs.get('friendly_name', None)
        self.resource_type = kwargs.get('resource_type', None)
        self.os_type = kwargs.get('os_type', None)
        self.multiplier = kwargs.get('multiplier', None)


class BillingMeterCollection(msrest.serialization.Model):
    """Collection of Billing Meters.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2021_01_01.models.BillingMeter]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[BillingMeter]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BillingMeterCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class BlobStorageTokenStore(msrest.serialization.Model):
    """The configuration settings of the storage of the tokens if blob storage is used.

    :param sas_url_setting_name: The name of the app setting containing the SAS URL of the blob
     storage containing the tokens.
    :type sas_url_setting_name: str
    """

    _attribute_map = {
        'sas_url_setting_name': {'key': 'sasUrlSettingName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BlobStorageTokenStore, self).__init__(**kwargs)
        self.sas_url_setting_name = kwargs.get('sas_url_setting_name', None)


class Capability(msrest.serialization.Model):
    """Describes the capabilities/features allowed for a specific SKU.

    :param name: Name of the SKU capability.
    :type name: str
    :param value: Value of the SKU capability.
    :type value: str
    :param reason: Reason of the SKU capability.
    :type reason: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Capability, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.value = kwargs.get('value', None)
        self.reason = kwargs.get('reason', None)


class Certificate(Resource):
    """SSL certificate for an app.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :param location: Required. Resource Location.
    :type location: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param password: Certificate password.
    :type password: str
    :ivar friendly_name: Friendly name of the certificate.
    :vartype friendly_name: str
    :ivar subject_name: Subject name of the certificate.
    :vartype subject_name: str
    :param host_names: Host names the certificate applies to.
    :type host_names: list[str]
    :param pfx_blob: Pfx blob.
    :type pfx_blob: bytearray
    :ivar site_name: App name.
    :vartype site_name: str
    :ivar self_link: Self link.
    :vartype self_link: str
    :ivar issuer: Certificate issuer.
    :vartype issuer: str
    :ivar issue_date: Certificate issue Date.
    :vartype issue_date: ~datetime.datetime
    :ivar expiration_date: Certificate expiration date.
    :vartype expiration_date: ~datetime.datetime
    :ivar thumbprint: Certificate thumbprint.
    :vartype thumbprint: str
    :ivar valid: Is the certificate valid?.
    :vartype valid: bool
    :ivar cer_blob: Raw bytes of .cer file.
    :vartype cer_blob: bytearray
    :ivar public_key_hash: Public key hash.
    :vartype public_key_hash: str
    :ivar hosting_environment_profile: Specification for the App Service Environment to use for the
     certificate.
    :vartype hosting_environment_profile:
     ~azure.mgmt.web.v2021_01_01.models.HostingEnvironmentProfile
    :param key_vault_id: Key Vault Csm resource Id.
    :type key_vault_id: str
    :param key_vault_secret_name: Key Vault secret name.
    :type key_vault_secret_name: str
    :ivar key_vault_secret_status: Status of the Key Vault secret. Possible values include:
     "Initialized", "WaitingOnCertificateOrder", "Succeeded", "CertificateOrderFailed",
     "OperationNotPermittedOnKeyVault", "AzureServiceUnauthorizedToAccessKeyVault",
     "KeyVaultDoesNotExist", "KeyVaultSecretDoesNotExist", "UnknownError", "ExternalPrivateKey",
     "Unknown".
    :vartype key_vault_secret_status: str or
     ~azure.mgmt.web.v2021_01_01.models.KeyVaultSecretStatus
    :param server_farm_id: Resource ID of the associated App Service plan, formatted as:
     "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
    :type server_farm_id: str
    :param canonical_name: CNAME of the certificate to be issued via free certificate.
    :type canonical_name: str
    :param domain_validation_method: Method of domain validation for free cert.
    :type domain_validation_method: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'location': {'required': True},
        'type': {'readonly': True},
        'friendly_name': {'readonly': True},
        'subject_name': {'readonly': True},
        'site_name': {'readonly': True},
        'self_link': {'readonly': True},
        'issuer': {'readonly': True},
        'issue_date': {'readonly': True},
        'expiration_date': {'readonly': True},
        'thumbprint': {'readonly': True},
        'valid': {'readonly': True},
        'cer_blob': {'readonly': True},
        'public_key_hash': {'readonly': True},
        'hosting_environment_profile': {'readonly': True},
        'key_vault_secret_status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'password': {'key': 'properties.password', 'type': 'str'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'subject_name': {'key': 'properties.subjectName', 'type': 'str'},
        'host_names': {'key': 'properties.hostNames', 'type': '[str]'},
        'pfx_blob': {'key': 'properties.pfxBlob', 'type': 'bytearray'},
        'site_name': {'key': 'properties.siteName', 'type': 'str'},
        'self_link': {'key': 'properties.selfLink', 'type': 'str'},
        'issuer': {'key': 'properties.issuer', 'type': 'str'},
        'issue_date': {'key': 'properties.issueDate', 'type': 'iso-8601'},
        'expiration_date': {'key': 'properties.expirationDate', 'type': 'iso-8601'},
        'thumbprint': {'key': 'properties.thumbprint', 'type': 'str'},
        'valid': {'key': 'properties.valid', 'type': 'bool'},
        'cer_blob': {'key': 'properties.cerBlob', 'type': 'bytearray'},
        'public_key_hash': {'key': 'properties.publicKeyHash', 'type': 'str'},
        'hosting_environment_profile': {'key': 'properties.hostingEnvironmentProfile', 'type': 'HostingEnvironmentProfile'},
        'key_vault_id': {'key': 'properties.keyVaultId', 'type': 'str'},
        'key_vault_secret_name': {'key': 'properties.keyVaultSecretName', 'type': 'str'},
        'key_vault_secret_status': {'key': 'properties.keyVaultSecretStatus', 'type': 'str'},
        'server_farm_id': {'key': 'properties.serverFarmId', 'type': 'str'},
        'canonical_name': {'key': 'properties.canonicalName', 'type': 'str'},
        'domain_validation_method': {'key': 'properties.domainValidationMethod', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Certificate, self).__init__(**kwargs)
        self.password = kwargs.get('password', None)
        self.friendly_name = None
        self.subject_name = None
        self.host_names = kwargs.get('host_names', None)
        self.pfx_blob = kwargs.get('pfx_blob', None)
        self.site_name = None
        self.self_link = None
        self.issuer = None
        self.issue_date = None
        self.expiration_date = None
        self.thumbprint = None
        self.valid = None
        self.cer_blob = None
        self.public_key_hash = None
        self.hosting_environment_profile = None
        self.key_vault_id = kwargs.get('key_vault_id', None)
        self.key_vault_secret_name = kwargs.get('key_vault_secret_name', None)
        self.key_vault_secret_status = None
        self.server_farm_id = kwargs.get('server_farm_id', None)
        self.canonical_name = kwargs.get('canonical_name', None)
        self.domain_validation_method = kwargs.get('domain_validation_method', None)


class CertificateCollection(msrest.serialization.Model):
    """Collection of certificates.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2021_01_01.models.Certificate]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Certificate]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CertificateCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class CertificateDetails(msrest.serialization.Model):
    """SSL certificate details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar version: Certificate Version.
    :vartype version: int
    :ivar serial_number: Certificate Serial Number.
    :vartype serial_number: str
    :ivar thumbprint: Certificate Thumbprint.
    :vartype thumbprint: str
    :ivar subject: Certificate Subject.
    :vartype subject: str
    :ivar not_before: Date Certificate is valid from.
    :vartype not_before: ~datetime.datetime
    :ivar not_after: Date Certificate is valid to.
    :vartype not_after: ~datetime.datetime
    :ivar signature_algorithm: Certificate Signature algorithm.
    :vartype signature_algorithm: str
    :ivar issuer: Certificate Issuer.
    :vartype issuer: str
    :ivar raw_data: Raw certificate data.
    :vartype raw_data: str
    """

    _validation = {
        'version': {'readonly': True},
        'serial_number': {'readonly': True},
        'thumbprint': {'readonly': True},
        'subject': {'readonly': True},
        'not_before': {'readonly': True},
        'not_after': {'readonly': True},
        'signature_algorithm': {'readonly': True},
        'issuer': {'readonly': True},
        'raw_data': {'readonly': True},
    }

    _attribute_map = {
        'version': {'key': 'version', 'type': 'int'},
        'serial_number': {'key': 'serialNumber', 'type': 'str'},
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
        'subject': {'key': 'subject', 'type': 'str'},
        'not_before': {'key': 'notBefore', 'type': 'iso-8601'},
        'not_after': {'key': 'notAfter', 'type': 'iso-8601'},
        'signature_algorithm': {'key': 'signatureAlgorithm', 'type': 'str'},
        'issuer': {'key': 'issuer', 'type': 'str'},
        'raw_data': {'key': 'rawData', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CertificateDetails, self).__init__(**kwargs)
        self.version = None
        self.serial_number = None
        self.thumbprint = None
        self.subject = None
        self.not_before = None
        self.not_after = None
        self.signature_algorithm = None
        self.issuer = None
        self.raw_data = None


class CertificateEmail(ProxyOnlyResource):
    """SSL certificate email.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param email_id: Email id.
    :type email_id: str
    :param time_stamp: Time stamp.
    :type time_stamp: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'email_id': {'key': 'properties.emailId', 'type': 'str'},
        'time_stamp': {'key': 'properties.timeStamp', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CertificateEmail, self).__init__(**kwargs)
        self.email_id = kwargs.get('email_id', None)
        self.time_stamp = kwargs.get('time_stamp', None)


class CertificateOrderAction(ProxyOnlyResource):
    """Certificate order action.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar action_type: Action type. Possible values include: "CertificateIssued",
     "CertificateOrderCanceled", "CertificateOrderCreated", "CertificateRevoked",
     "DomainValidationComplete", "FraudDetected", "OrgNameChange", "OrgValidationComplete",
     "SanDrop", "FraudCleared", "CertificateExpired", "CertificateExpirationWarning",
     "FraudDocumentationRequired", "Unknown".
    :vartype action_type: str or ~azure.mgmt.web.v2021_01_01.models.CertificateOrderActionType
    :ivar created_at: Time at which the certificate action was performed.
    :vartype created_at: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'action_type': {'readonly': True},
        'created_at': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'action_type': {'key': 'properties.actionType', 'type': 'str'},
        'created_at': {'key': 'properties.createdAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CertificateOrderAction, self).__init__(**kwargs)
        self.action_type = None
        self.created_at = None


class CertificateOrderContact(msrest.serialization.Model):
    """CertificateOrderContact.

    :param email:
    :type email: str
    :param name_first:
    :type name_first: str
    :param name_last:
    :type name_last: str
    :param phone:
    :type phone: str
    """

    _attribute_map = {
        'email': {'key': 'email', 'type': 'str'},
        'name_first': {'key': 'nameFirst', 'type': 'str'},
        'name_last': {'key': 'nameLast', 'type': 'str'},
        'phone': {'key': 'phone', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CertificateOrderContact, self).__init__(**kwargs)
        self.email = kwargs.get('email', None)
        self.name_first = kwargs.get('name_first', None)
        self.name_last = kwargs.get('name_last', None)
        self.phone = kwargs.get('phone', None)


class CertificatePatchResource(ProxyOnlyResource):
    """ARM resource for a certificate.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param password: Certificate password.
    :type password: str
    :ivar friendly_name: Friendly name of the certificate.
    :vartype friendly_name: str
    :ivar subject_name: Subject name of the certificate.
    :vartype subject_name: str
    :param host_names: Host names the certificate applies to.
    :type host_names: list[str]
    :param pfx_blob: Pfx blob.
    :type pfx_blob: bytearray
    :ivar site_name: App name.
    :vartype site_name: str
    :ivar self_link: Self link.
    :vartype self_link: str
    :ivar issuer: Certificate issuer.
    :vartype issuer: str
    :ivar issue_date: Certificate issue Date.
    :vartype issue_date: ~datetime.datetime
    :ivar expiration_date: Certificate expiration date.
    :vartype expiration_date: ~datetime.datetime
    :ivar thumbprint: Certificate thumbprint.
    :vartype thumbprint: str
    :ivar valid: Is the certificate valid?.
    :vartype valid: bool
    :ivar cer_blob: Raw bytes of .cer file.
    :vartype cer_blob: bytearray
    :ivar public_key_hash: Public key hash.
    :vartype public_key_hash: str
    :ivar hosting_environment_profile: Specification for the App Service Environment to use for the
     certificate.
    :vartype hosting_environment_profile:
     ~azure.mgmt.web.v2021_01_01.models.HostingEnvironmentProfile
    :param key_vault_id: Key Vault Csm resource Id.
    :type key_vault_id: str
    :param key_vault_secret_name: Key Vault secret name.
    :type key_vault_secret_name: str
    :ivar key_vault_secret_status: Status of the Key Vault secret. Possible values include:
     "Initialized", "WaitingOnCertificateOrder", "Succeeded", "CertificateOrderFailed",
     "OperationNotPermittedOnKeyVault", "AzureServiceUnauthorizedToAccessKeyVault",
     "KeyVaultDoesNotExist", "KeyVaultSecretDoesNotExist", "UnknownError", "ExternalPrivateKey",
     "Unknown".
    :vartype key_vault_secret_status: str or
     ~azure.mgmt.web.v2021_01_01.models.KeyVaultSecretStatus
    :param server_farm_id: Resource ID of the associated App Service plan, formatted as:
     "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
    :type server_farm_id: str
    :param canonical_name: CNAME of the certificate to be issued via free certificate.
    :type canonical_name: str
    :param domain_validation_method: Method of domain validation for free cert.
    :type domain_validation_method: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'friendly_name': {'readonly': True},
        'subject_name': {'readonly': True},
        'site_name': {'readonly': True},
        'self_link': {'readonly': True},
        'issuer': {'readonly': True},
        'issue_date': {'readonly': True},
        'expiration_date': {'readonly': True},
        'thumbprint': {'readonly': True},
        'valid': {'readonly': True},
        'cer_blob': {'readonly': True},
        'public_key_hash': {'readonly': True},
        'hosting_environment_profile': {'readonly': True},
        'key_vault_secret_status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'password': {'key': 'properties.password', 'type': 'str'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'subject_name': {'key': 'properties.subjectName', 'type': 'str'},
        'host_names': {'key': 'properties.hostNames', 'type': '[str]'},
        'pfx_blob': {'key': 'properties.pfxBlob', 'type': 'bytearray'},
        'site_name': {'key': 'properties.siteName', 'type': 'str'},
        'self_link': {'key': 'properties.selfLink', 'type': 'str'},
        'issuer': {'key': 'properties.issuer', 'type': 'str'},
        'issue_date': {'key': 'properties.issueDate', 'type': 'iso-8601'},
        'expiration_date': {'key': 'properties.expirationDate', 'type': 'iso-8601'},
        'thumbprint': {'key': 'properties.thumbprint', 'type': 'str'},
        'valid': {'key': 'properties.valid', 'type': 'bool'},
        'cer_blob': {'key': 'properties.cerBlob', 'type': 'bytearray'},
        'public_key_hash': {'key': 'properties.publicKeyHash', 'type': 'str'},
        'hosting_environment_profile': {'key': 'properties.hostingEnvironmentProfile', 'type': 'HostingEnvironmentProfile'},
        'key_vault_id': {'key': 'properties.keyVaultId', 'type': 'str'},
        'key_vault_secret_name': {'key': 'properties.keyVaultSecretName', 'type': 'str'},
        'key_vault_secret_status': {'key': 'properties.keyVaultSecretStatus', 'type': 'str'},
        'server_farm_id': {'key': 'properties.serverFarmId', 'type': 'str'},
        'canonical_name': {'key': 'properties.canonicalName', 'type': 'str'},
        'domain_validation_method': {'key': 'properties.domainValidationMethod', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CertificatePatchResource, self).__init__(**kwargs)
        self.password = kwargs.get('password', None)
        self.friendly_name = None
        self.subject_name = None
        self.host_names = kwargs.get('host_names', None)
        self.pfx_blob = kwargs.get('pfx_blob', None)
        self.site_name = None
        self.self_link = None
        self.issuer = None
        self.issue_date = None
        self.expiration_date = None
        self.thumbprint = None
        self.valid = None
        self.cer_blob = None
        self.public_key_hash = None
        self.hosting_environment_profile = None
        self.key_vault_id = kwargs.get('key_vault_id', None)
        self.key_vault_secret_name = kwargs.get('key_vault_secret_name', None)
        self.key_vault_secret_status = None
        self.server_farm_id = kwargs.get('server_farm_id', None)
        self.canonical_name = kwargs.get('canonical_name', None)
        self.domain_validation_method = kwargs.get('domain_validation_method', None)


class ClientRegistration(msrest.serialization.Model):
    """The configuration settings of the app registration for providers that have client ids and client secrets.

    :param client_id: The Client ID of the app used for login.
    :type client_id: str
    :param client_secret_setting_name: The app setting name that contains the client secret.
    :type client_secret_setting_name: str
    """

    _attribute_map = {
        'client_id': {'key': 'clientId', 'type': 'str'},
        'client_secret_setting_name': {'key': 'clientSecretSettingName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ClientRegistration, self).__init__(**kwargs)
        self.client_id = kwargs.get('client_id', None)
        self.client_secret_setting_name = kwargs.get('client_secret_setting_name', None)


class CloningInfo(msrest.serialization.Model):
    """Information needed for cloning operation.

    All required parameters must be populated in order to send to Azure.

    :param correlation_id: Correlation ID of cloning operation. This ID ties multiple cloning
     operations
     together to use the same snapshot.
    :type correlation_id: str
    :param overwrite: :code:`<code>true</code>` to overwrite destination app; otherwise,
     :code:`<code>false</code>`.
    :type overwrite: bool
    :param clone_custom_host_names: :code:`<code>true</code>` to clone custom hostnames from source
     app; otherwise, :code:`<code>false</code>`.
    :type clone_custom_host_names: bool
    :param clone_source_control: :code:`<code>true</code>` to clone source control from source app;
     otherwise, :code:`<code>false</code>`.
    :type clone_source_control: bool
    :param source_web_app_id: Required. ARM resource ID of the source app. App resource ID is of
     the form
    /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}
     for production slots and
    /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slotName}
     for other slots.
    :type source_web_app_id: str
    :param source_web_app_location: Location of source app ex: West US or North Europe.
    :type source_web_app_location: str
    :param hosting_environment: App Service Environment.
    :type hosting_environment: str
    :param app_settings_overrides: Application setting overrides for cloned app. If specified,
     these settings override the settings cloned
     from source app. Otherwise, application settings from source app are retained.
    :type app_settings_overrides: dict[str, str]
    :param configure_load_balancing: :code:`<code>true</code>` to configure load balancing for
     source and destination app.
    :type configure_load_balancing: bool
    :param traffic_manager_profile_id: ARM resource ID of the Traffic Manager profile to use, if it
     exists. Traffic Manager resource ID is of the form
    /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{profileName}.
    :type traffic_manager_profile_id: str
    :param traffic_manager_profile_name: Name of Traffic Manager profile to create. This is only
     needed if Traffic Manager profile does not already exist.
    :type traffic_manager_profile_name: str
    """

    _validation = {
        'source_web_app_id': {'required': True},
    }

    _attribute_map = {
        'correlation_id': {'key': 'correlationId', 'type': 'str'},
        'overwrite': {'key': 'overwrite', 'type': 'bool'},
        'clone_custom_host_names': {'key': 'cloneCustomHostNames', 'type': 'bool'},
        'clone_source_control': {'key': 'cloneSourceControl', 'type': 'bool'},
        'source_web_app_id': {'key': 'sourceWebAppId', 'type': 'str'},
        'source_web_app_location': {'key': 'sourceWebAppLocation', 'type': 'str'},
        'hosting_environment': {'key': 'hostingEnvironment', 'type': 'str'},
        'app_settings_overrides': {'key': 'appSettingsOverrides', 'type': '{str}'},
        'configure_load_balancing': {'key': 'configureLoadBalancing', 'type': 'bool'},
        'traffic_manager_profile_id': {'key': 'trafficManagerProfileId', 'type': 'str'},
        'traffic_manager_profile_name': {'key': 'trafficManagerProfileName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CloningInfo, self).__init__(**kwargs)
        self.correlation_id = kwargs.get('correlation_id', None)
        self.overwrite = kwargs.get('overwrite', None)
        self.clone_custom_host_names = kwargs.get('clone_custom_host_names', None)
        self.clone_source_control = kwargs.get('clone_source_control', None)
        self.source_web_app_id = kwargs['source_web_app_id']
        self.source_web_app_location = kwargs.get('source_web_app_location', None)
        self.hosting_environment = kwargs.get('hosting_environment', None)
        self.app_settings_overrides = kwargs.get('app_settings_overrides', None)
        self.configure_load_balancing = kwargs.get('configure_load_balancing', None)
        self.traffic_manager_profile_id = kwargs.get('traffic_manager_profile_id', None)
        self.traffic_manager_profile_name = kwargs.get('traffic_manager_profile_name', None)


class Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties(msrest.serialization.Model):
    """Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: Principal Id of user assigned identity.
    :vartype principal_id: str
    :ivar client_id: Client Id of user assigned identity.
    :vartype client_id: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'client_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties, self).__init__(**kwargs)
        self.principal_id = None
        self.client_id = None


class ConnectionStringDictionary(ProxyOnlyResource):
    """String dictionary resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param properties: Connection strings.
    :type properties: dict[str, ~azure.mgmt.web.v2021_01_01.models.ConnStringValueTypePair]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{ConnStringValueTypePair}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnectionStringDictionary, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)


class ConnStringInfo(msrest.serialization.Model):
    """Database connection string information.

    :param name: Name of connection string.
    :type name: str
    :param connection_string: Connection string value.
    :type connection_string: str
    :param type: Type of database. Possible values include: "MySql", "SQLServer", "SQLAzure",
     "Custom", "NotificationHub", "ServiceBus", "EventHub", "ApiHub", "DocDb", "RedisCache",
     "PostgreSQL".
    :type type: str or ~azure.mgmt.web.v2021_01_01.models.ConnectionStringType
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'connection_string': {'key': 'connectionString', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnStringInfo, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.connection_string = kwargs.get('connection_string', None)
        self.type = kwargs.get('type', None)


class ConnStringValueTypePair(msrest.serialization.Model):
    """Database connection string value to type pair.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Value of pair.
    :type value: str
    :param type: Required. Type of database. Possible values include: "MySql", "SQLServer",
     "SQLAzure", "Custom", "NotificationHub", "ServiceBus", "EventHub", "ApiHub", "DocDb",
     "RedisCache", "PostgreSQL".
    :type type: str or ~azure.mgmt.web.v2021_01_01.models.ConnectionStringType
    """

    _validation = {
        'value': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnStringValueTypePair, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.type = kwargs['type']


class Contact(msrest.serialization.Model):
    """Contact information for domain registration. If 'Domain Privacy' option is not selected then the contact information is made publicly available through the Whois 
directories as per ICANN requirements.

    All required parameters must be populated in order to send to Azure.

    :param address_mailing: Mailing address.
    :type address_mailing: ~azure.mgmt.web.v2021_01_01.models.Address
    :param email: Required. Email address.
    :type email: str
    :param fax: Fax number.
    :type fax: str
    :param job_title: Job title.
    :type job_title: str
    :param name_first: Required. First name.
    :type name_first: str
    :param name_last: Required. Last name.
    :type name_last: str
    :param name_middle: Middle name.
    :type name_middle: str
    :param organization: Organization contact belongs to.
    :type organization: str
    :param phone: Required. Phone number.
    :type phone: str
    """

    _validation = {
        'email': {'required': True},
        'name_first': {'required': True},
        'name_last': {'required': True},
        'phone': {'required': True},
    }

    _attribute_map = {
        'address_mailing': {'key': 'addressMailing', 'type': 'Address'},
        'email': {'key': 'email', 'type': 'str'},
        'fax': {'key': 'fax', 'type': 'str'},
        'job_title': {'key': 'jobTitle', 'type': 'str'},
        'name_first': {'key': 'nameFirst', 'type': 'str'},
        'name_last': {'key': 'nameLast', 'type': 'str'},
        'name_middle': {'key': 'nameMiddle', 'type': 'str'},
        'organization': {'key': 'organization', 'type': 'str'},
        'phone': {'key': 'phone', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Contact, self).__init__(**kwargs)
        self.address_mailing = kwargs.get('address_mailing', None)
        self.email = kwargs['email']
        self.fax = kwargs.get('fax', None)
        self.job_title = kwargs.get('job_title', None)
        self.name_first = kwargs['name_first']
        self.name_last = kwargs['name_last']
        self.name_middle = kwargs.get('name_middle', None)
        self.organization = kwargs.get('organization', None)
        self.phone = kwargs['phone']


class ContainerCpuStatistics(msrest.serialization.Model):
    """ContainerCpuStatistics.

    :param cpu_usage:
    :type cpu_usage: ~azure.mgmt.web.v2021_01_01.models.ContainerCpuUsage
    :param system_cpu_usage:
    :type system_cpu_usage: long
    :param online_cpu_count:
    :type online_cpu_count: int
    :param throttling_data:
    :type throttling_data: ~azure.mgmt.web.v2021_01_01.models.ContainerThrottlingData
    """

    _attribute_map = {
        'cpu_usage': {'key': 'cpuUsage', 'type': 'ContainerCpuUsage'},
        'system_cpu_usage': {'key': 'systemCpuUsage', 'type': 'long'},
        'online_cpu_count': {'key': 'onlineCpuCount', 'type': 'int'},
        'throttling_data': {'key': 'throttlingData', 'type': 'ContainerThrottlingData'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ContainerCpuStatistics, self).__init__(**kwargs)
        self.cpu_usage = kwargs.get('cpu_usage', None)
        self.system_cpu_usage = kwargs.get('system_cpu_usage', None)
        self.online_cpu_count = kwargs.get('online_cpu_count', None)
        self.throttling_data = kwargs.get('throttling_data', None)


class ContainerCpuUsage(msrest.serialization.Model):
    """ContainerCpuUsage.

    :param total_usage:
    :type total_usage: long
    :param per_cpu_usage:
    :type per_cpu_usage: list[long]
    :param kernel_mode_usage:
    :type kernel_mode_usage: long
    :param user_mode_usage:
    :type user_mode_usage: long
    """

    _attribute_map = {
        'total_usage': {'key': 'totalUsage', 'type': 'long'},
        'per_cpu_usage': {'key': 'perCpuUsage', 'type': '[long]'},
        'kernel_mode_usage': {'key': 'kernelModeUsage', 'type': 'long'},
        'user_mode_usage': {'key': 'userModeUsage', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ContainerCpuUsage, self).__init__(**kwargs)
        self.total_usage = kwargs.get('total_usage', None)
        self.per_cpu_usage = kwargs.get('per_cpu_usage', None)
        self.kernel_mode_usage = kwargs.get('kernel_mode_usage', None)
        self.user_mode_usage = kwargs.get('user_mode_usage', None)


class ContainerInfo(msrest.serialization.Model):
    """ContainerInfo.

    :param current_time_stamp:
    :type current_time_stamp: ~datetime.datetime
    :param previous_time_stamp:
    :type previous_time_stamp: ~datetime.datetime
    :param current_cpu_stats:
    :type current_cpu_stats: ~azure.mgmt.web.v2021_01_01.models.ContainerCpuStatistics
    :param previous_cpu_stats:
    :type previous_cpu_stats: ~azure.mgmt.web.v2021_01_01.models.ContainerCpuStatistics
    :param memory_stats:
    :type memory_stats: ~azure.mgmt.web.v2021_01_01.models.ContainerMemoryStatistics
    :param name:
    :type name: str
    :param id:
    :type id: str
    :param eth0:
    :type eth0: ~azure.mgmt.web.v2021_01_01.models.ContainerNetworkInterfaceStatistics
    """

    _attribute_map = {
        'current_time_stamp': {'key': 'currentTimeStamp', 'type': 'iso-8601'},
        'previous_time_stamp': {'key': 'previousTimeStamp', 'type': 'iso-8601'},
        'current_cpu_stats': {'key': 'currentCpuStats', 'type': 'ContainerCpuStatistics'},
        'previous_cpu_stats': {'key': 'previousCpuStats', 'type': 'ContainerCpuStatistics'},
        'memory_stats': {'key': 'memoryStats', 'type': 'ContainerMemoryStatistics'},
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'eth0': {'key': 'eth0', 'type': 'ContainerNetworkInterfaceStatistics'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ContainerInfo, self).__init__(**kwargs)
        self.current_time_stamp = kwargs.get('current_time_stamp', None)
        self.previous_time_stamp = kwargs.get('previous_time_stamp', None)
        self.current_cpu_stats = kwargs.get('current_cpu_stats', None)
        self.previous_cpu_stats = kwargs.get('previous_cpu_stats', None)
        self.memory_stats = kwargs.get('memory_stats', None)
        self.name = kwargs.get('name', None)
        self.id = kwargs.get('id', None)
        self.eth0 = kwargs.get('eth0', None)


class ContainerMemoryStatistics(msrest.serialization.Model):
    """ContainerMemoryStatistics.

    :param usage:
    :type usage: long
    :param max_usage:
    :type max_usage: long
    :param limit:
    :type limit: long
    """

    _attribute_map = {
        'usage': {'key': 'usage', 'type': 'long'},
        'max_usage': {'key': 'maxUsage', 'type': 'long'},
        'limit': {'key': 'limit', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ContainerMemoryStatistics, self).__init__(**kwargs)
        self.usage = kwargs.get('usage', None)
        self.max_usage = kwargs.get('max_usage', None)
        self.limit = kwargs.get('limit', None)


class ContainerNetworkInterfaceStatistics(msrest.serialization.Model):
    """ContainerNetworkInterfaceStatistics.

    :param rx_bytes:
    :type rx_bytes: long
    :param rx_packets:
    :type rx_packets: long
    :param rx_errors:
    :type rx_errors: long
    :param rx_dropped:
    :type rx_dropped: long
    :param tx_bytes:
    :type tx_bytes: long
    :param tx_packets:
    :type tx_packets: long
    :param tx_errors:
    :type tx_errors: long
    :param tx_dropped:
    :type tx_dropped: long
    """

    _attribute_map = {
        'rx_bytes': {'key': 'rxBytes', 'type': 'long'},
        'rx_packets': {'key': 'rxPackets', 'type': 'long'},
        'rx_errors': {'key': 'rxErrors', 'type': 'long'},
        'rx_dropped': {'key': 'rxDropped', 'type': 'long'},
        'tx_bytes': {'key': 'txBytes', 'type': 'long'},
        'tx_packets': {'key': 'txPackets', 'type': 'long'},
        'tx_errors': {'key': 'txErrors', 'type': 'long'},
        'tx_dropped': {'key': 'txDropped', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ContainerNetworkInterfaceStatistics, self).__init__(**kwargs)
        self.rx_bytes = kwargs.get('rx_bytes', None)
        self.rx_packets = kwargs.get('rx_packets', None)
        self.rx_errors = kwargs.get('rx_errors', None)
        self.rx_dropped = kwargs.get('rx_dropped', None)
        self.tx_bytes = kwargs.get('tx_bytes', None)
        self.tx_packets = kwargs.get('tx_packets', None)
        self.tx_errors = kwargs.get('tx_errors', None)
        self.tx_dropped = kwargs.get('tx_dropped', None)


class ContainerThrottlingData(msrest.serialization.Model):
    """ContainerThrottlingData.

    :param periods:
    :type periods: int
    :param throttled_periods:
    :type throttled_periods: int
    :param throttled_time:
    :type throttled_time: int
    """

    _attribute_map = {
        'periods': {'key': 'periods', 'type': 'int'},
        'throttled_periods': {'key': 'throttledPeriods', 'type': 'int'},
        'throttled_time': {'key': 'throttledTime', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ContainerThrottlingData, self).__init__(**kwargs)
        self.periods = kwargs.get('periods', None)
        self.throttled_periods = kwargs.get('throttled_periods', None)
        self.throttled_time = kwargs.get('throttled_time', None)


class ContinuousWebJob(ProxyOnlyResource):
    """Continuous Web Job Information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param status: Job status. Possible values include: "Initializing", "Starting", "Running",
     "PendingRestart", "Stopped".
    :type status: str or ~azure.mgmt.web.v2021_01_01.models.ContinuousWebJobStatus
    :param detailed_status: Detailed status.
    :type detailed_status: str
    :param log_url: Log URL.
    :type log_url: str
    :param run_command: Run command.
    :type run_command: str
    :param url: Job URL.
    :type url: str
    :param extra_info_url: Extra Info URL.
    :type extra_info_url: str
    :param web_job_type: Job type. Possible values include: "Continuous", "Triggered".
    :type web_job_type: str or ~azure.mgmt.web.v2021_01_01.models.WebJobType
    :param error: Error information.
    :type error: str
    :param using_sdk: Using SDK?.
    :type using_sdk: bool
    :param settings: Job settings.
    :type settings: dict[str, any]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'detailed_status': {'key': 'properties.detailed_status', 'type': 'str'},
        'log_url': {'key': 'properties.log_url', 'type': 'str'},
        'run_command': {'key': 'properties.run_command', 'type': 'str'},
        'url': {'key': 'properties.url', 'type': 'str'},
        'extra_info_url': {'key': 'properties.extra_info_url', 'type': 'str'},
        'web_job_type': {'key': 'properties.web_job_type', 'type': 'str'},
        'error': {'key': 'properties.error', 'type': 'str'},
        'using_sdk': {'key': 'properties.using_sdk', 'type': 'bool'},
        'settings': {'key': 'properties.settings', 'type': '{object}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ContinuousWebJob, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.detailed_status = kwargs.get('detailed_status', None)
        self.log_url = kwargs.get('log_url', None)
        self.run_command = kwargs.get('run_command', None)
        self.url = kwargs.get('url', None)
        self.extra_info_url = kwargs.get('extra_info_url', None)
        self.web_job_type = kwargs.get('web_job_type', None)
        self.error = kwargs.get('error', None)
        self.using_sdk = kwargs.get('using_sdk', None)
        self.settings = kwargs.get('settings', None)


class ContinuousWebJobCollection(msrest.serialization.Model):
    """Collection of Kudu continuous web job information elements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2021_01_01.models.ContinuousWebJob]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ContinuousWebJob]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ContinuousWebJobCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class CookieExpiration(msrest.serialization.Model):
    """The configuration settings of the session cookie's expiration.

    :param convention: The convention used when determining the session cookie's expiration.
     Possible values include: "FixedTime", "IdentityProviderDerived".
    :type convention: str or ~azure.mgmt.web.v2021_01_01.models.CookieExpirationConvention
    :param time_to_expiration: The time after the request is made when the session cookie should
     expire.
    :type time_to_expiration: str
    """

    _attribute_map = {
        'convention': {'key': 'convention', 'type': 'str'},
        'time_to_expiration': {'key': 'timeToExpiration', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CookieExpiration, self).__init__(**kwargs)
        self.convention = kwargs.get('convention', None)
        self.time_to_expiration = kwargs.get('time_to_expiration', None)


class CorsSettings(msrest.serialization.Model):
    """Cross-Origin Resource Sharing (CORS) settings for the app.

    :param allowed_origins: Gets or sets the list of origins that should be allowed to make
     cross-origin
     calls (for example: http://example.com:12345). Use "*" to allow all.
    :type allowed_origins: list[str]
    :param support_credentials: Gets or sets whether CORS requests with credentials are allowed.
     See
     https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS#Requests_with_credentials
     for more details.
    :type support_credentials: bool
    """

    _attribute_map = {
        'allowed_origins': {'key': 'allowedOrigins', 'type': '[str]'},
        'support_credentials': {'key': 'supportCredentials', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CorsSettings, self).__init__(**kwargs)
        self.allowed_origins = kwargs.get('allowed_origins', None)
        self.support_credentials = kwargs.get('support_credentials', None)


class CsmMoveResourceEnvelope(msrest.serialization.Model):
    """Object with a list of the resources that need to be moved and the resource group they should be moved to.

    :param target_resource_group:
    :type target_resource_group: str
    :param resources:
    :type resources: list[str]
    """

    _validation = {
        'target_resource_group': {'max_length': 90, 'min_length': 1, 'pattern': r' ^[-\w\._\(\)]+[^\.]$'},
    }

    _attribute_map = {
        'target_resource_group': {'key': 'targetResourceGroup', 'type': 'str'},
        'resources': {'key': 'resources', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CsmMoveResourceEnvelope, self).__init__(**kwargs)
        self.target_resource_group = kwargs.get('target_resource_group', None)
        self.resources = kwargs.get('resources', None)


class CsmOperationCollection(msrest.serialization.Model):
    """Collection of Azure resource manager operation metadata.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2021_01_01.models.CsmOperationDescription]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[CsmOperationDescription]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CsmOperationCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class CsmOperationDescription(msrest.serialization.Model):
    """Description of an operation available for Microsoft.Web resource provider.

    :param name:
    :type name: str
    :param is_data_action:
    :type is_data_action: bool
    :param display: Meta data about operation used for display in portal.
    :type display: ~azure.mgmt.web.v2021_01_01.models.CsmOperationDisplay
    :param origin:
    :type origin: str
    :param properties: Properties available for a Microsoft.Web resource provider operation.
    :type properties: ~azure.mgmt.web.v2021_01_01.models.CsmOperationDescriptionProperties
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'is_data_action': {'key': 'isDataAction', 'type': 'bool'},
        'display': {'key': 'display', 'type': 'CsmOperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'CsmOperationDescriptionProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CsmOperationDescription, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.is_data_action = kwargs.get('is_data_action', None)
        self.display = kwargs.get('display', None)
        self.origin = kwargs.get('origin', None)
        self.properties = kwargs.get('properties', None)


class CsmOperationDescriptionProperties(msrest.serialization.Model):
    """Properties available for a Microsoft.Web resource provider operation.

    :param service_specification: Resource metrics service provided by Microsoft.Insights resource
     provider.
    :type service_specification: ~azure.mgmt.web.v2021_01_01.models.ServiceSpecification
    """

    _attribute_map = {
        'service_specification': {'key': 'serviceSpecification', 'type': 'ServiceSpecification'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CsmOperationDescriptionProperties, self).__init__(**kwargs)
        self.service_specification = kwargs.get('service_specification', None)


class CsmOperationDisplay(msrest.serialization.Model):
    """Meta data about operation used for display in portal.

    :param provider:
    :type provider: str
    :param resource:
    :type resource: str
    :param operation:
    :type operation: str
    :param description:
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CsmOperationDisplay, self).__init__(**kwargs)
        self.provider = kwargs.get('provider', None)
        self.resource = kwargs.get('resource', None)
        self.operation = kwargs.get('operation', None)
        self.description = kwargs.get('description', None)


class CsmPublishingCredentialsPoliciesCollection(ProxyOnlyResource):
    """Publishing Credentials Policies collection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param ftp: Whether FTP is allowed.
    :type ftp: ~azure.mgmt.web.v2021_01_01.models.CsmPublishingCredentialsPoliciesEntity
    :param scm: Whether Scm Basic Auth is allowed.
    :type scm: ~azure.mgmt.web.v2021_01_01.models.CsmPublishingCredentialsPoliciesEntity
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'ftp': {'key': 'properties.ftp', 'type': 'CsmPublishingCredentialsPoliciesEntity'},
        'scm': {'key': 'properties.scm', 'type': 'CsmPublishingCredentialsPoliciesEntity'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CsmPublishingCredentialsPoliciesCollection, self).__init__(**kwargs)
        self.ftp = kwargs.get('ftp', None)
        self.scm = kwargs.get('scm', None)


class CsmPublishingCredentialsPoliciesEntity(ProxyOnlyResource):
    """Publishing Credentials Policies parameters.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param allow: :code:`<code>true</code>` to allow access to a publishing method; otherwise,
     :code:`<code>false</code>`.
    :type allow: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'allow': {'key': 'properties.allow', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CsmPublishingCredentialsPoliciesEntity, self).__init__(**kwargs)
        self.allow = kwargs.get('allow', None)


class CsmPublishingProfileOptions(msrest.serialization.Model):
    """Publishing options for requested profile.

    :param format: Name of the format. Valid values are:
     FileZilla3
     WebDeploy -- default
     Ftp. Possible values include: "FileZilla3", "WebDeploy", "Ftp".
    :type format: str or ~azure.mgmt.web.v2021_01_01.models.PublishingProfileFormat
    :param include_disaster_recovery_endpoints: Include the DisasterRecover endpoint if true.
    :type include_disaster_recovery_endpoints: bool
    """

    _attribute_map = {
        'format': {'key': 'format', 'type': 'str'},
        'include_disaster_recovery_endpoints': {'key': 'includeDisasterRecoveryEndpoints', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CsmPublishingProfileOptions, self).__init__(**kwargs)
        self.format = kwargs.get('format', None)
        self.include_disaster_recovery_endpoints = kwargs.get('include_disaster_recovery_endpoints', None)


class CsmSlotEntity(msrest.serialization.Model):
    """Deployment slot parameters.

    All required parameters must be populated in order to send to Azure.

    :param target_slot: Required. Destination deployment slot during swap operation.
    :type target_slot: str
    :param preserve_vnet: Required. :code:`<code>true</code>` to preserve Virtual Network to the
     slot during swap; otherwise, :code:`<code>false</code>`.
    :type preserve_vnet: bool
    """

    _validation = {
        'target_slot': {'required': True},
        'preserve_vnet': {'required': True},
    }

    _attribute_map = {
        'target_slot': {'key': 'targetSlot', 'type': 'str'},
        'preserve_vnet': {'key': 'preserveVnet', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CsmSlotEntity, self).__init__(**kwargs)
        self.target_slot = kwargs['target_slot']
        self.preserve_vnet = kwargs['preserve_vnet']


class CsmUsageQuota(msrest.serialization.Model):
    """Usage of the quota resource.

    :param unit: Units of measurement for the quota resource.
    :type unit: str
    :param next_reset_time: Next reset time for the resource counter.
    :type next_reset_time: ~datetime.datetime
    :param current_value: The current value of the resource counter.
    :type current_value: long
    :param limit: The resource limit.
    :type limit: long
    :param name: Quota name.
    :type name: ~azure.mgmt.web.v2021_01_01.models.LocalizableString
    """

    _attribute_map = {
        'unit': {'key': 'unit', 'type': 'str'},
        'next_reset_time': {'key': 'nextResetTime', 'type': 'iso-8601'},
        'current_value': {'key': 'currentValue', 'type': 'long'},
        'limit': {'key': 'limit', 'type': 'long'},
        'name': {'key': 'name', 'type': 'LocalizableString'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CsmUsageQuota, self).__init__(**kwargs)
        self.unit = kwargs.get('unit', None)
        self.next_reset_time = kwargs.get('next_reset_time', None)
        self.current_value = kwargs.get('current_value', None)
        self.limit = kwargs.get('limit', None)
        self.name = kwargs.get('name', None)


class CsmUsageQuotaCollection(msrest.serialization.Model):
    """Collection of CSM usage quotas.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2021_01_01.models.CsmUsageQuota]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[CsmUsageQuota]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CsmUsageQuotaCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class CustomHostnameAnalysisResult(ProxyOnlyResource):
    """Custom domain analysis.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar is_hostname_already_verified: :code:`<code>true</code>` if hostname is already verified;
     otherwise, :code:`<code>false</code>`.
    :vartype is_hostname_already_verified: bool
    :ivar custom_domain_verification_test: DNS verification test result. Possible values include:
     "Passed", "Failed", "Skipped".
    :vartype custom_domain_verification_test: str or
     ~azure.mgmt.web.v2021_01_01.models.DnsVerificationTestResult
    :ivar custom_domain_verification_failure_info: Raw failure information if DNS verification
     fails.
    :vartype custom_domain_verification_failure_info:
     ~azure.mgmt.web.v2021_01_01.models.ErrorEntity
    :ivar has_conflict_on_scale_unit: :code:`<code>true</code>` if there is a conflict on a scale
     unit; otherwise, :code:`<code>false</code>`.
    :vartype has_conflict_on_scale_unit: bool
    :ivar has_conflict_across_subscription: :code:`<code>true</code>` if there is a conflict across
     subscriptions; otherwise, :code:`<code>false</code>`.
    :vartype has_conflict_across_subscription: bool
    :ivar conflicting_app_resource_id: Name of the conflicting app on scale unit if it's within the
     same subscription.
    :vartype conflicting_app_resource_id: str
    :param c_name_records: CName records controller can see for this hostname.
    :type c_name_records: list[str]
    :param txt_records: TXT records controller can see for this hostname.
    :type txt_records: list[str]
    :param a_records: A records controller can see for this hostname.
    :type a_records: list[str]
    :param alternate_c_name_records: Alternate CName records controller can see for this hostname.
    :type alternate_c_name_records: list[str]
    :param alternate_txt_records: Alternate TXT records controller can see for this hostname.
    :type alternate_txt_records: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'is_hostname_already_verified': {'readonly': True},
        'custom_domain_verification_test': {'readonly': True},
        'custom_domain_verification_failure_info': {'readonly': True},
        'has_conflict_on_scale_unit': {'readonly': True},
        'has_conflict_across_subscription': {'readonly': True},
        'conflicting_app_resource_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'is_hostname_already_verified': {'key': 'properties.isHostnameAlreadyVerified', 'type': 'bool'},
        'custom_domain_verification_test': {'key': 'properties.customDomainVerificationTest', 'type': 'str'},
        'custom_domain_verification_failure_info': {'key': 'properties.customDomainVerificationFailureInfo', 'type': 'ErrorEntity'},
        'has_conflict_on_scale_unit': {'key': 'properties.hasConflictOnScaleUnit', 'type': 'bool'},
        'has_conflict_across_subscription': {'key': 'properties.hasConflictAcrossSubscription', 'type': 'bool'},
        'conflicting_app_resource_id': {'key': 'properties.conflictingAppResourceId', 'type': 'str'},
        'c_name_records': {'key': 'properties.cNameRecords', 'type': '[str]'},
        'txt_records': {'key': 'properties.txtRecords', 'type': '[str]'},
        'a_records': {'key': 'properties.aRecords', 'type': '[str]'},
        'alternate_c_name_records': {'key': 'properties.alternateCNameRecords', 'type': '[str]'},
        'alternate_txt_records': {'key': 'properties.alternateTxtRecords', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CustomHostnameAnalysisResult, self).__init__(**kwargs)
        self.is_hostname_already_verified = None
        self.custom_domain_verification_test = None
        self.custom_domain_verification_failure_info = None
        self.has_conflict_on_scale_unit = None
        self.has_conflict_across_subscription = None
        self.conflicting_app_resource_id = None
        self.c_name_records = kwargs.get('c_name_records', None)
        self.txt_records = kwargs.get('txt_records', None)
        self.a_records = kwargs.get('a_records', None)
        self.alternate_c_name_records = kwargs.get('alternate_c_name_records', None)
        self.alternate_txt_records = kwargs.get('alternate_txt_records', None)


class CustomOpenIdConnectProvider(msrest.serialization.Model):
    """The configuration settings of the custom Open ID Connect provider.

    :param enabled: :code:`<code>false</code>` if the custom Open ID provider provider should not
     be enabled; otherwise, :code:`<code>true</code>`.
    :type enabled: bool
    :param registration: The configuration settings of the app registration for the custom Open ID
     Connect provider.
    :type registration: ~azure.mgmt.web.v2021_01_01.models.OpenIdConnectRegistration
    :param login: The configuration settings of the login flow of the custom Open ID Connect
     provider.
    :type login: ~azure.mgmt.web.v2021_01_01.models.OpenIdConnectLogin
    """

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'registration': {'key': 'registration', 'type': 'OpenIdConnectRegistration'},
        'login': {'key': 'login', 'type': 'OpenIdConnectLogin'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CustomOpenIdConnectProvider, self).__init__(**kwargs)
        self.enabled = kwargs.get('enabled', None)
        self.registration = kwargs.get('registration', None)
        self.login = kwargs.get('login', None)


class DatabaseBackupSetting(msrest.serialization.Model):
    """Database backup settings.

    All required parameters must be populated in order to send to Azure.

    :param database_type: Required. Database type (e.g. SqlAzure / MySql). Possible values include:
     "SqlAzure", "MySql", "LocalMySql", "PostgreSql".
    :type database_type: str or ~azure.mgmt.web.v2021_01_01.models.DatabaseType
    :param name:
    :type name: str
    :param connection_string_name: Contains a connection string name that is linked to the
     SiteConfig.ConnectionStrings.
     This is used during restore with overwrite connection strings options.
    :type connection_string_name: str
    :param connection_string: Contains a connection string to a database which is being backed up
     or restored. If the restore should happen to a new database, the database name inside is the
     new one.
    :type connection_string: str
    """

    _validation = {
        'database_type': {'required': True},
    }

    _attribute_map = {
        'database_type': {'key': 'databaseType', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'connection_string_name': {'key': 'connectionStringName', 'type': 'str'},
        'connection_string': {'key': 'connectionString', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DatabaseBackupSetting, self).__init__(**kwargs)
        self.database_type = kwargs['database_type']
        self.name = kwargs.get('name', None)
        self.connection_string_name = kwargs.get('connection_string_name', None)
        self.connection_string = kwargs.get('connection_string', None)


class DataProviderMetadata(msrest.serialization.Model):
    """Additional configuration for a data providers.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param provider_name:
    :type provider_name: str
    :ivar property_bag: Settings for the data provider.
    :vartype property_bag: list[~azure.mgmt.web.v2021_01_01.models.KeyValuePairStringObject]
    """

    _validation = {
        'property_bag': {'readonly': True},
    }

    _attribute_map = {
        'provider_name': {'key': 'providerName', 'type': 'str'},
        'property_bag': {'key': 'propertyBag', 'type': '[KeyValuePairStringObject]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataProviderMetadata, self).__init__(**kwargs)
        self.provider_name = kwargs.get('provider_name', None)
        self.property_bag = None


class DataSource(msrest.serialization.Model):
    """Class representing data source used by the detectors.

    :param instructions: Instructions if any for the data source.
    :type instructions: list[str]
    :param data_source_uri: Datasource Uri Links.
    :type data_source_uri: list[~azure.mgmt.web.v2021_01_01.models.NameValuePair]
    """

    _attribute_map = {
        'instructions': {'key': 'instructions', 'type': '[str]'},
        'data_source_uri': {'key': 'dataSourceUri', 'type': '[NameValuePair]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataSource, self).__init__(**kwargs)
        self.instructions = kwargs.get('instructions', None)
        self.data_source_uri = kwargs.get('data_source_uri', None)


class DataTableResponseColumn(msrest.serialization.Model):
    """Column definition.

    :param column_name: Name of the column.
    :type column_name: str
    :param data_type: Data type which looks like 'String' or 'Int32'.
    :type data_type: str
    :param column_type: Column Type.
    :type column_type: str
    """

    _attribute_map = {
        'column_name': {'key': 'columnName', 'type': 'str'},
        'data_type': {'key': 'dataType', 'type': 'str'},
        'column_type': {'key': 'columnType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataTableResponseColumn, self).__init__(**kwargs)
        self.column_name = kwargs.get('column_name', None)
        self.data_type = kwargs.get('data_type', None)
        self.column_type = kwargs.get('column_type', None)


class DataTableResponseObject(msrest.serialization.Model):
    """Data Table which defines columns and raw row values.

    :param table_name: Name of the table.
    :type table_name: str
    :param columns: List of columns with data types.
    :type columns: list[~azure.mgmt.web.v2021_01_01.models.DataTableResponseColumn]
    :param rows: Raw row values.
    :type rows: list[list[str]]
    """

    _attribute_map = {
        'table_name': {'key': 'tableName', 'type': 'str'},
        'columns': {'key': 'columns', 'type': '[DataTableResponseColumn]'},
        'rows': {'key': 'rows', 'type': '[[str]]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataTableResponseObject, self).__init__(**kwargs)
        self.table_name = kwargs.get('table_name', None)
        self.columns = kwargs.get('columns', None)
        self.rows = kwargs.get('rows', None)


class DefaultErrorResponse(msrest.serialization.Model):
    """App Service error response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar error: Error model.
    :vartype error: ~azure.mgmt.web.v2021_01_01.models.DefaultErrorResponseError
    """

    _validation = {
        'error': {'readonly': True},
    }

    _attribute_map = {
        'error': {'key': 'error', 'type': 'DefaultErrorResponseError'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DefaultErrorResponse, self).__init__(**kwargs)
        self.error = None


class DefaultErrorResponseError(msrest.serialization.Model):
    """Error model.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Standardized string to programmatically identify the error.
    :vartype code: str
    :ivar message: Detailed error description and debugging information.
    :vartype message: str
    :ivar target: Detailed error description and debugging information.
    :vartype target: str
    :param details:
    :type details: list[~azure.mgmt.web.v2021_01_01.models.DefaultErrorResponseErrorDetailsItem]
    :ivar innererror: More information to debug error.
    :vartype innererror: str
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'innererror': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[DefaultErrorResponseErrorDetailsItem]'},
        'innererror': {'key': 'innererror', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DefaultErrorResponseError, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = kwargs.get('details', None)
        self.innererror = None


class DefaultErrorResponseErrorDetailsItem(msrest.serialization.Model):
    """Detailed errors.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Standardized string to programmatically identify the error.
    :vartype code: str
    :ivar message: Detailed error description and debugging information.
    :vartype message: str
    :ivar target: Detailed error description and debugging information.
    :vartype target: str
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DefaultErrorResponseErrorDetailsItem, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None


class DeletedAppRestoreRequest(ProxyOnlyResource):
    """Details about restoring a deleted app.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param deleted_site_id: ARM resource ID of the deleted app. Example:
     /subscriptions/{subId}/providers/Microsoft.Web/deletedSites/{deletedSiteId}.
    :type deleted_site_id: str
    :param recover_configuration: If true, deleted site configuration, in addition to content, will
     be restored.
    :type recover_configuration: bool
    :param snapshot_time: Point in time to restore the deleted app from, formatted as a DateTime
     string.
     If unspecified, default value is the time that the app was deleted.
    :type snapshot_time: str
    :param use_dr_secondary: If true, the snapshot is retrieved from DRSecondary endpoint.
    :type use_dr_secondary: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'deleted_site_id': {'key': 'properties.deletedSiteId', 'type': 'str'},
        'recover_configuration': {'key': 'properties.recoverConfiguration', 'type': 'bool'},
        'snapshot_time': {'key': 'properties.snapshotTime', 'type': 'str'},
        'use_dr_secondary': {'key': 'properties.useDRSecondary', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DeletedAppRestoreRequest, self).__init__(**kwargs)
        self.deleted_site_id = kwargs.get('deleted_site_id', None)
        self.recover_configuration = kwargs.get('recover_configuration', None)
        self.snapshot_time = kwargs.get('snapshot_time', None)
        self.use_dr_secondary = kwargs.get('use_dr_secondary', None)


class DeletedSite(ProxyOnlyResource):
    """A deleted app.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar deleted_site_id: Numeric id for the deleted site.
    :vartype deleted_site_id: int
    :ivar deleted_timestamp: Time in UTC when the app was deleted.
    :vartype deleted_timestamp: str
    :ivar subscription: Subscription containing the deleted site.
    :vartype subscription: str
    :ivar resource_group: ResourceGroup that contained the deleted site.
    :vartype resource_group: str
    :ivar deleted_site_name: Name of the deleted site.
    :vartype deleted_site_name: str
    :ivar slot: Slot of the deleted site.
    :vartype slot: str
    :ivar kind_properties_kind: Kind of site that was deleted.
    :vartype kind_properties_kind: str
    :ivar geo_region_name: Geo Region of the deleted site.
    :vartype geo_region_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'deleted_site_id': {'readonly': True},
        'deleted_timestamp': {'readonly': True},
        'subscription': {'readonly': True},
        'resource_group': {'readonly': True},
        'deleted_site_name': {'readonly': True},
        'slot': {'readonly': True},
        'kind_properties_kind': {'readonly': True},
        'geo_region_name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'deleted_site_id': {'key': 'properties.deletedSiteId', 'type': 'int'},
        'deleted_timestamp': {'key': 'properties.deletedTimestamp', 'type': 'str'},
        'subscription': {'key': 'properties.subscription', 'type': 'str'},
        'resource_group': {'key': 'properties.resourceGroup', 'type': 'str'},
        'deleted_site_name': {'key': 'properties.deletedSiteName', 'type': 'str'},
        'slot': {'key': 'properties.slot', 'type': 'str'},
        'kind_properties_kind': {'key': 'properties.kind', 'type': 'str'},
        'geo_region_name': {'key': 'properties.geoRegionName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DeletedSite, self).__init__(**kwargs)
        self.deleted_site_id = None
        self.deleted_timestamp = None
        self.subscription = None
        self.resource_group = None
        self.deleted_site_name = None
        self.slot = None
        self.kind_properties_kind = None
        self.geo_region_name = None


class DeletedWebAppCollection(msrest.serialization.Model):
    """Collection of deleted apps.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2021_01_01.models.DeletedSite]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DeletedSite]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DeletedWebAppCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class Deployment(ProxyOnlyResource):
    """User credentials used for publishing activity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param status: Deployment status.
    :type status: int
    :param message: Details about deployment status.
    :type message: str
    :param author: Who authored the deployment.
    :type author: str
    :param deployer: Who performed the deployment.
    :type deployer: str
    :param author_email: Author email.
    :type author_email: str
    :param start_time: Start time.
    :type start_time: ~datetime.datetime
    :param end_time: End time.
    :type end_time: ~datetime.datetime
    :param active: True if deployment is currently active, false if completed and null if not
     started.
    :type active: bool
    :param details: Details on deployment.
    :type details: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'int'},
        'message': {'key': 'properties.message', 'type': 'str'},
        'author': {'key': 'properties.author', 'type': 'str'},
        'deployer': {'key': 'properties.deployer', 'type': 'str'},
        'author_email': {'key': 'properties.author_email', 'type': 'str'},
        'start_time': {'key': 'properties.start_time', 'type': 'iso-8601'},
        'end_time': {'key': 'properties.end_time', 'type': 'iso-8601'},
        'active': {'key': 'properties.active', 'type': 'bool'},
        'details': {'key': 'properties.details', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Deployment, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.message = kwargs.get('message', None)
        self.author = kwargs.get('author', None)
        self.deployer = kwargs.get('deployer', None)
        self.author_email = kwargs.get('author_email', None)
        self.start_time = kwargs.get('start_time', None)
        self.end_time = kwargs.get('end_time', None)
        self.active = kwargs.get('active', None)
        self.details = kwargs.get('details', None)


class DeploymentCollection(msrest.serialization.Model):
    """Collection of app deployments.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2021_01_01.models.Deployment]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Deployment]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DeploymentCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class DeploymentLocations(msrest.serialization.Model):
    """List of available locations (regions or App Service Environments) for
deployment of App Service resources.

    :param locations: Available regions.
    :type locations: list[~azure.mgmt.web.v2021_01_01.models.GeoRegion]
    :param hosting_environments: Available App Service Environments with full descriptions of the
     environments.
    :type hosting_environments: list[~azure.mgmt.web.v2021_01_01.models.AppServiceEnvironment]
    :param hosting_environment_deployment_infos: Available App Service Environments with basic
     information.
    :type hosting_environment_deployment_infos:
     list[~azure.mgmt.web.v2021_01_01.models.HostingEnvironmentDeploymentInfo]
    """

    _attribute_map = {
        'locations': {'key': 'locations', 'type': '[GeoRegion]'},
        'hosting_environments': {'key': 'hostingEnvironments', 'type': '[AppServiceEnvironment]'},
        'hosting_environment_deployment_infos': {'key': 'hostingEnvironmentDeploymentInfos', 'type': '[HostingEnvironmentDeploymentInfo]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DeploymentLocations, self).__init__(**kwargs)
        self.locations = kwargs.get('locations', None)
        self.hosting_environments = kwargs.get('hosting_environments', None)
        self.hosting_environment_deployment_infos = kwargs.get('hosting_environment_deployment_infos', None)


class DetectorAbnormalTimePeriod(msrest.serialization.Model):
    """Class representing Abnormal Time Period detected.

    :param start_time: Start time of the correlated event.
    :type start_time: ~datetime.datetime
    :param end_time: End time of the correlated event.
    :type end_time: ~datetime.datetime
    :param message: Message describing the event.
    :type message: str
    :param source: Represents the name of the Detector.
    :type source: str
    :param priority: Represents the rank of the Detector.
    :type priority: float
    :param meta_data: Downtime metadata.
    :type meta_data: list[list[~azure.mgmt.web.v2021_01_01.models.NameValuePair]]
    :param type: Represents the type of the Detector. Possible values include: "ServiceIncident",
     "AppDeployment", "AppCrash", "RuntimeIssueDetected", "AseDeployment", "UserIssue",
     "PlatformIssue", "Other".
    :type type: str or ~azure.mgmt.web.v2021_01_01.models.IssueType
    :param solutions: List of proposed solutions.
    :type solutions: list[~azure.mgmt.web.v2021_01_01.models.Solution]
    """

    _attribute_map = {
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'message': {'key': 'message', 'type': 'str'},
        'source': {'key': 'source', 'type': 'str'},
        'priority': {'key': 'priority', 'type': 'float'},
        'meta_data': {'key': 'metaData', 'type': '[[NameValuePair]]'},
        'type': {'key': 'type', 'type': 'str'},
        'solutions': {'key': 'solutions', 'type': '[Solution]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DetectorAbnormalTimePeriod, self).__init__(**kwargs)
        self.start_time = kwargs.get('start_time', None)
        self.end_time = kwargs.get('end_time', None)
        self.message = kwargs.get('message', None)
        self.source = kwargs.get('source', None)
        self.priority = kwargs.get('priority', None)
        self.meta_data = kwargs.get('meta_data', None)
        self.type = kwargs.get('type', None)
        self.solutions = kwargs.get('solutions', None)


class DetectorDefinition(ProxyOnlyResource):
    """Class representing detector definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar display_name: Display name of the detector.
    :vartype display_name: str
    :ivar description: Description of the detector.
    :vartype description: str
    :ivar rank: Detector Rank.
    :vartype rank: float
    :ivar is_enabled: Flag representing whether detector is enabled or not.
    :vartype is_enabled: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'display_name': {'readonly': True},
        'description': {'readonly': True},
        'rank': {'readonly': True},
        'is_enabled': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'rank': {'key': 'properties.rank', 'type': 'float'},
        'is_enabled': {'key': 'properties.isEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DetectorDefinition, self).__init__(**kwargs)
        self.display_name = None
        self.description = None
        self.rank = None
        self.is_enabled = None


class DetectorInfo(msrest.serialization.Model):
    """Definition of Detector.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Id of detector.
    :vartype id: str
    :ivar name: Name of detector.
    :vartype name: str
    :ivar description: Short description of the detector and its purpose.
    :vartype description: str
    :ivar author: Author of the detector.
    :vartype author: str
    :ivar category: Problem category. This serves for organizing group for detectors.
    :vartype category: str
    :ivar support_topic_list: List of Support Topics for which this detector is enabled.
    :vartype support_topic_list: list[~azure.mgmt.web.v2021_01_01.models.SupportTopic]
    :ivar analysis_type: Analysis Types for which this detector should apply to.
    :vartype analysis_type: list[str]
    :ivar type: Whether this detector is an Analysis Detector or not. Possible values include:
     "Detector", "Analysis", "CategoryOverview".
    :vartype type: str or ~azure.mgmt.web.v2021_01_01.models.DetectorType
    :ivar score: Defines score of a detector to power ML based matching.
    :vartype score: float
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'description': {'readonly': True},
        'author': {'readonly': True},
        'category': {'readonly': True},
        'support_topic_list': {'readonly': True},
        'analysis_type': {'readonly': True},
        'type': {'readonly': True},
        'score': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'author': {'key': 'author', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
        'support_topic_list': {'key': 'supportTopicList', 'type': '[SupportTopic]'},
        'analysis_type': {'key': 'analysisType', 'type': '[str]'},
        'type': {'key': 'type', 'type': 'str'},
        'score': {'key': 'score', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DetectorInfo, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.description = None
        self.author = None
        self.category = None
        self.support_topic_list = None
        self.analysis_type = None
        self.type = None
        self.score = None


class DetectorResponse(ProxyOnlyResource):
    """Class representing Response from Detector.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param metadata: metadata for the detector.
    :type metadata: ~azure.mgmt.web.v2021_01_01.models.DetectorInfo
    :param dataset: Data Set.
    :type dataset: list[~azure.mgmt.web.v2021_01_01.models.DiagnosticData]
    :param status: Indicates status of the most severe insight.
    :type status: ~azure.mgmt.web.v2021_01_01.models.Status
    :param data_providers_metadata: Additional configuration for different data providers to be
     used by the UI.
    :type data_providers_metadata: list[~azure.mgmt.web.v2021_01_01.models.DataProviderMetadata]
    :param suggested_utterances: Suggested utterances where the detector can be applicable.
    :type suggested_utterances: ~azure.mgmt.web.v2021_01_01.models.QueryUtterancesResults
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'metadata': {'key': 'properties.metadata', 'type': 'DetectorInfo'},
        'dataset': {'key': 'properties.dataset', 'type': '[DiagnosticData]'},
        'status': {'key': 'properties.status', 'type': 'Status'},
        'data_providers_metadata': {'key': 'properties.dataProvidersMetadata', 'type': '[DataProviderMetadata]'},
        'suggested_utterances': {'key': 'properties.suggestedUtterances', 'type': 'QueryUtterancesResults'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DetectorResponse, self).__init__(**kwargs)
        self.metadata = kwargs.get('metadata', None)
        self.dataset = kwargs.get('dataset', None)
        self.status = kwargs.get('status', None)
        self.data_providers_metadata = kwargs.get('data_providers_metadata', None)
        self.suggested_utterances = kwargs.get('suggested_utterances', None)


class DetectorResponseCollection(msrest.serialization.Model):
    """Collection of detector responses.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2021_01_01.models.DetectorResponse]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DetectorResponse]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DetectorResponseCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class DiagnosticAnalysis(ProxyOnlyResource):
    """Class representing a diagnostic analysis done on an application.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param start_time: Start time of the period.
    :type start_time: ~datetime.datetime
    :param end_time: End time of the period.
    :type end_time: ~datetime.datetime
    :param abnormal_time_periods: List of time periods.
    :type abnormal_time_periods: list[~azure.mgmt.web.v2021_01_01.models.AbnormalTimePeriod]
    :param payload: Data by each detector.
    :type payload: list[~azure.mgmt.web.v2021_01_01.models.AnalysisData]
    :param non_correlated_detectors: Data by each detector for detectors that did not corelate.
    :type non_correlated_detectors: list[~azure.mgmt.web.v2021_01_01.models.DetectorDefinition]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'properties.endTime', 'type': 'iso-8601'},
        'abnormal_time_periods': {'key': 'properties.abnormalTimePeriods', 'type': '[AbnormalTimePeriod]'},
        'payload': {'key': 'properties.payload', 'type': '[AnalysisData]'},
        'non_correlated_detectors': {'key': 'properties.nonCorrelatedDetectors', 'type': '[DetectorDefinition]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DiagnosticAnalysis, self).__init__(**kwargs)
        self.start_time = kwargs.get('start_time', None)
        self.end_time = kwargs.get('end_time', None)
        self.abnormal_time_periods = kwargs.get('abnormal_time_periods', None)
        self.payload = kwargs.get('payload', None)
        self.non_correlated_detectors = kwargs.get('non_correlated_detectors', None)


class DiagnosticAnalysisCollection(msrest.serialization.Model):
    """Collection of Diagnostic Analyses.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2021_01_01.models.AnalysisDefinition]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AnalysisDefinition]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DiagnosticAnalysisCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class DiagnosticCategory(ProxyOnlyResource):
    """Class representing detector definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar description: Description of the diagnostic category.
    :vartype description: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'description': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DiagnosticCategory, self).__init__(**kwargs)
        self.description = None


class DiagnosticCategoryCollection(msrest.serialization.Model):
    """Collection of Diagnostic Categories.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2021_01_01.models.DiagnosticCategory]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DiagnosticCategory]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DiagnosticCategoryCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class DiagnosticData(msrest.serialization.Model):
    """Set of data with rendering instructions.

    :param table: Data in table form.
    :type table: ~azure.mgmt.web.v2021_01_01.models.DataTableResponseObject
    :param rendering_properties: Properties that describe how the table should be rendered.
    :type rendering_properties: ~azure.mgmt.web.v2021_01_01.models.Rendering
    """

    _attribute_map = {
        'table': {'key': 'table', 'type': 'DataTableResponseObject'},
        'rendering_properties': {'key': 'renderingProperties', 'type': 'Rendering'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DiagnosticData, self).__init__(**kwargs)
        self.table = kwargs.get('table', None)
        self.rendering_properties = kwargs.get('rendering_properties', None)


class DiagnosticDetectorCollection(msrest.serialization.Model):
    """Collection of Diagnostic Detectors.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2021_01_01.models.DetectorDefinition]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DetectorDefinition]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DiagnosticDetectorCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class DiagnosticDetectorResponse(ProxyOnlyResource):
    """Class representing Response from Diagnostic Detectors.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param start_time: Start time of the period.
    :type start_time: ~datetime.datetime
    :param end_time: End time of the period.
    :type end_time: ~datetime.datetime
    :param issue_detected: Flag representing Issue was detected.
    :type issue_detected: bool
    :param detector_definition: Detector's definition.
    :type detector_definition: ~azure.mgmt.web.v2021_01_01.models.DetectorDefinition
    :param metrics: Metrics provided by the detector.
    :type metrics: list[~azure.mgmt.web.v2021_01_01.models.DiagnosticMetricSet]
    :param abnormal_time_periods: List of Correlated events found by the detector.
    :type abnormal_time_periods:
     list[~azure.mgmt.web.v2021_01_01.models.DetectorAbnormalTimePeriod]
    :param data: Additional Data that detector wants to send.
    :type data: list[list[~azure.mgmt.web.v2021_01_01.models.NameValuePair]]
    :param response_meta_data: Meta Data.
    :type response_meta_data: ~azure.mgmt.web.v2021_01_01.models.ResponseMetaData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'properties.endTime', 'type': 'iso-8601'},
        'issue_detected': {'key': 'properties.issueDetected', 'type': 'bool'},
        'detector_definition': {'key': 'properties.detectorDefinition', 'type': 'DetectorDefinition'},
        'metrics': {'key': 'properties.metrics', 'type': '[DiagnosticMetricSet]'},
        'abnormal_time_periods': {'key': 'properties.abnormalTimePeriods', 'type': '[DetectorAbnormalTimePeriod]'},
        'data': {'key': 'properties.data', 'type': '[[NameValuePair]]'},
        'response_meta_data': {'key': 'properties.responseMetaData', 'type': 'ResponseMetaData'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DiagnosticDetectorResponse, self).__init__(**kwargs)
        self.start_time = kwargs.get('start_time', None)
        self.end_time = kwargs.get('end_time', None)
        self.issue_detected = kwargs.get('issue_detected', None)
        self.detector_definition = kwargs.get('detector_definition', None)
        self.metrics = kwargs.get('metrics', None)
        self.abnormal_time_periods = kwargs.get('abnormal_time_periods', None)
        self.data = kwargs.get('data', None)
        self.response_meta_data = kwargs.get('response_meta_data', None)


class DiagnosticMetricSample(msrest.serialization.Model):
    """Class representing Diagnostic Metric.

    :param timestamp: Time at which metric is measured.
    :type timestamp: ~datetime.datetime
    :param role_instance: Role Instance. Null if this counter is not per instance
     This is returned and should be whichever instance name we desire to be returned
     i.e. CPU and Memory return RDWORKERNAME (LargeDed..._IN_0)
     where RDWORKERNAME is Machine name below and RoleInstance name in parenthesis.
    :type role_instance: str
    :param total: Total value of the metric. If multiple measurements are made this will have sum
     of all.
    :type total: float
    :param maximum: Maximum of the metric sampled during the time period.
    :type maximum: float
    :param minimum: Minimum of the metric sampled during the time period.
    :type minimum: float
    :param is_aggregated: Whether the values are aggregates across all workers or not.
    :type is_aggregated: bool
    """

    _attribute_map = {
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'role_instance': {'key': 'roleInstance', 'type': 'str'},
        'total': {'key': 'total', 'type': 'float'},
        'maximum': {'key': 'maximum', 'type': 'float'},
        'minimum': {'key': 'minimum', 'type': 'float'},
        'is_aggregated': {'key': 'isAggregated', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DiagnosticMetricSample, self).__init__(**kwargs)
        self.timestamp = kwargs.get('timestamp', None)
        self.role_instance = kwargs.get('role_instance', None)
        self.total = kwargs.get('total', None)
        self.maximum = kwargs.get('maximum', None)
        self.minimum = kwargs.get('minimum', None)
        self.is_aggregated = kwargs.get('is_aggregated', None)


class DiagnosticMetricSet(msrest.serialization.Model):
    """Class representing Diagnostic Metric information.

    :param name: Name of the metric.
    :type name: str
    :param unit: Metric's unit.
    :type unit: str
    :param start_time: Start time of the period.
    :type start_time: ~datetime.datetime
    :param end_time: End time of the period.
    :type end_time: ~datetime.datetime
    :param time_grain: Presented time grain. Supported grains at the moment are PT1M, PT1H, P1D.
    :type time_grain: str
    :param values: Collection of metric values for the selected period based on the
     {Microsoft.Web.Hosting.Administration.DiagnosticMetricSet.TimeGrain}.
    :type values: list[~azure.mgmt.web.v2021_01_01.models.DiagnosticMetricSample]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'time_grain': {'key': 'timeGrain', 'type': 'str'},
        'values': {'key': 'values', 'type': '[DiagnosticMetricSample]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DiagnosticMetricSet, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.unit = kwargs.get('unit', None)
        self.start_time = kwargs.get('start_time', None)
        self.end_time = kwargs.get('end_time', None)
        self.time_grain = kwargs.get('time_grain', None)
        self.values = kwargs.get('values', None)


class Dimension(msrest.serialization.Model):
    """Dimension of a resource metric. For e.g. instance specific HTTP requests for a web app, 
where instance name is dimension of the metric HTTP request.

    :param name:
    :type name: str
    :param display_name:
    :type display_name: str
    :param internal_name:
    :type internal_name: str
    :param to_be_exported_for_shoebox:
    :type to_be_exported_for_shoebox: bool
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'internal_name': {'key': 'internalName', 'type': 'str'},
        'to_be_exported_for_shoebox': {'key': 'toBeExportedForShoebox', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Dimension, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display_name = kwargs.get('display_name', None)
        self.internal_name = kwargs.get('internal_name', None)
        self.to_be_exported_for_shoebox = kwargs.get('to_be_exported_for_shoebox', None)


class Domain(Resource):
    """Information about a domain.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :param location: Required. Resource Location.
    :type location: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param contact_admin: Administrative contact.
    :type contact_admin: ~azure.mgmt.web.v2021_01_01.models.Contact
    :param contact_billing: Billing contact.
    :type contact_billing: ~azure.mgmt.web.v2021_01_01.models.Contact
    :param contact_registrant: Registrant contact.
    :type contact_registrant: ~azure.mgmt.web.v2021_01_01.models.Contact
    :param contact_tech: Technical contact.
    :type contact_tech: ~azure.mgmt.web.v2021_01_01.models.Contact
    :ivar registration_status: Domain registration status. Possible values include: "Active",
     "Awaiting", "Cancelled", "Confiscated", "Disabled", "Excluded", "Expired", "Failed", "Held",
     "Locked", "Parked", "Pending", "Reserved", "Reverted", "Suspended", "Transferred", "Unknown",
     "Unlocked", "Unparked", "Updated", "JsonConverterFailed".
    :vartype registration_status: str or ~azure.mgmt.web.v2021_01_01.models.DomainStatus
    :ivar provisioning_state: Domain provisioning state. Possible values include: "Succeeded",
     "Failed", "Canceled", "InProgress", "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2021_01_01.models.ProvisioningState
    :ivar name_servers: Name servers.
    :vartype name_servers: list[str]
    :param privacy: :code:`<code>true</code>` if domain privacy is enabled for this domain;
     otherwise, :code:`<code>false</code>`.
    :type privacy: bool
    :ivar created_time: Domain creation timestamp.
    :vartype created_time: ~datetime.datetime
    :ivar expiration_time: Domain expiration timestamp.
    :vartype expiration_time: ~datetime.datetime
    :ivar last_renewed_time: Timestamp when the domain was renewed last time.
    :vartype last_renewed_time: ~datetime.datetime
    :param auto_renew: :code:`<code>true</code>` if the domain should be automatically renewed;
     otherwise, :code:`<code>false</code>`.
    :type auto_renew: bool
    :ivar ready_for_dns_record_management: :code:`<code>true</code>` if Azure can assign this
     domain to App Service apps; otherwise, :code:`<code>false</code>`. This value will be
     :code:`<code>true</code>` if domain registration status is active and
      it is hosted on name servers Azure has programmatic access to.
    :vartype ready_for_dns_record_management: bool
    :ivar managed_host_names: All hostnames derived from the domain and assigned to Azure
     resources.
    :vartype managed_host_names: list[~azure.mgmt.web.v2021_01_01.models.HostName]
    :param consent: Legal agreement consent.
    :type consent: ~azure.mgmt.web.v2021_01_01.models.DomainPurchaseConsent
    :ivar domain_not_renewable_reasons: Reasons why domain is not renewable.
    :vartype domain_not_renewable_reasons: list[str or
     ~azure.mgmt.web.v2021_01_01.models.DomainPropertiesDomainNotRenewableReasonsItem]
    :param dns_type: Current DNS type. Possible values include: "AzureDns",
     "DefaultDomainRegistrarDns".
    :type dns_type: str or ~azure.mgmt.web.v2021_01_01.models.DnsType
    :param dns_zone_id: Azure DNS Zone to use.
    :type dns_zone_id: str
    :param target_dns_type: Target DNS type (would be used for migration). Possible values include:
     "AzureDns", "DefaultDomainRegistrarDns".
    :type target_dns_type: str or ~azure.mgmt.web.v2021_01_01.models.DnsType
    :param auth_code:
    :type auth_code: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'location': {'required': True},
        'type': {'readonly': True},
        'registration_status': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'name_servers': {'readonly': True},
        'created_time': {'readonly': True},
        'expiration_time': {'readonly': True},
        'last_renewed_time': {'readonly': True},
        'ready_for_dns_record_management': {'readonly': True},
        'managed_host_names': {'readonly': True},
        'domain_not_renewable_reasons': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'contact_admin': {'key': 'properties.contactAdmin', 'type': 'Contact'},
        'contact_billing': {'key': 'properties.contactBilling', 'type': 'Contact'},
        'contact_registrant': {'key': 'properties.contactRegistrant', 'type': 'Contact'},
        'contact_tech': {'key': 'properties.contactTech', 'type': 'Contact'},
        'registration_status': {'key': 'properties.registrationStatus', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name_servers': {'key': 'properties.nameServers', 'type': '[str]'},
        'privacy': {'key': 'properties.privacy', 'type': 'bool'},
        'created_time': {'key': 'properties.createdTime', 'type': 'iso-8601'},
        'expiration_time': {'key': 'properties.expirationTime', 'type': 'iso-8601'},
        'last_renewed_time': {'key': 'properties.lastRenewedTime', 'type': 'iso-8601'},
        'auto_renew': {'key': 'properties.autoRenew', 'type': 'bool'},
        'ready_for_dns_record_management': {'key': 'properties.readyForDnsRecordManagement', 'type': 'bool'},
        'managed_host_names': {'key': 'properties.managedHostNames', 'type': '[HostName]'},
        'consent': {'key': 'properties.consent', 'type': 'DomainPurchaseConsent'},
        'domain_not_renewable_reasons': {'key': 'properties.domainNotRenewableReasons', 'type': '[str]'},
        'dns_type': {'key': 'properties.dnsType', 'type': 'str'},
        'dns_zone_id': {'key': 'properties.dnsZoneId', 'type': 'str'},
        'target_dns_type': {'key': 'properties.targetDnsType', 'type': 'str'},
        'auth_code': {'key': 'properties.authCode', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Domain, self).__init__(**kwargs)
        self.contact_admin = kwargs.get('contact_admin', None)
        self.contact_billing = kwargs.get('contact_billing', None)
        self.contact_registrant = kwargs.get('contact_registrant', None)
        self.contact_tech = kwargs.get('contact_tech', None)
        self.registration_status = None
        self.provisioning_state = None
        self.name_servers = None
        self.privacy = kwargs.get('privacy', None)
        self.created_time = None
        self.expiration_time = None
        self.last_renewed_time = None
        self.auto_renew = kwargs.get('auto_renew', True)
        self.ready_for_dns_record_management = None
        self.managed_host_names = None
        self.consent = kwargs.get('consent', None)
        self.domain_not_renewable_reasons = None
        self.dns_type = kwargs.get('dns_type', None)
        self.dns_zone_id = kwargs.get('dns_zone_id', None)
        self.target_dns_type = kwargs.get('target_dns_type', None)
        self.auth_code = kwargs.get('auth_code', None)


class DomainAvailabilityCheckResult(msrest.serialization.Model):
    """Domain availability check result.

    :param name: Name of the domain.
    :type name: str
    :param available: :code:`<code>true</code>` if domain can be purchased using CreateDomain API;
     otherwise, :code:`<code>false</code>`.
    :type available: bool
    :param domain_type: Valid values are Regular domain: Azure will charge the full price of domain
     registration, SoftDeleted: Purchasing this domain will simply restore it and this operation
     will not cost anything. Possible values include: "Regular", "SoftDeleted".
    :type domain_type: str or ~azure.mgmt.web.v2021_01_01.models.DomainType
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'available': {'key': 'available', 'type': 'bool'},
        'domain_type': {'key': 'domainType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DomainAvailabilityCheckResult, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.available = kwargs.get('available', None)
        self.domain_type = kwargs.get('domain_type', None)


class DomainCollection(msrest.serialization.Model):
    """Collection of domains.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2021_01_01.models.Domain]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Domain]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DomainCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class DomainControlCenterSsoRequest(msrest.serialization.Model):
    """Single sign-on request information for domain management.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar url: URL where the single sign-on request is to be made.
    :vartype url: str
    :ivar post_parameter_key: Post parameter key.
    :vartype post_parameter_key: str
    :ivar post_parameter_value: Post parameter value. Client should use
     'application/x-www-form-urlencoded' encoding for this value.
    :vartype post_parameter_value: str
    """

    _validation = {
        'url': {'readonly': True},
        'post_parameter_key': {'readonly': True},
        'post_parameter_value': {'readonly': True},
    }

    _attribute_map = {
        'url': {'key': 'url', 'type': 'str'},
        'post_parameter_key': {'key': 'postParameterKey', 'type': 'str'},
        'post_parameter_value': {'key': 'postParameterValue', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DomainControlCenterSsoRequest, self).__init__(**kwargs)
        self.url = None
        self.post_parameter_key = None
        self.post_parameter_value = None


class DomainOwnershipIdentifier(ProxyOnlyResource):
    """Domain ownership Identifier.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param ownership_id: Ownership Id.
    :type ownership_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'ownership_id': {'key': 'properties.ownershipId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DomainOwnershipIdentifier, self).__init__(**kwargs)
        self.ownership_id = kwargs.get('ownership_id', None)


class DomainOwnershipIdentifierCollection(msrest.serialization.Model):
    """Collection of domain ownership identifiers.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2021_01_01.models.DomainOwnershipIdentifier]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DomainOwnershipIdentifier]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DomainOwnershipIdentifierCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class DomainPatchResource(ProxyOnlyResource):
    """ARM resource for a domain.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param contact_admin: Administrative contact.
    :type contact_admin: ~azure.mgmt.web.v2021_01_01.models.Contact
    :param contact_billing: Billing contact.
    :type contact_billing: ~azure.mgmt.web.v2021_01_01.models.Contact
    :param contact_registrant: Registrant contact.
    :type contact_registrant: ~azure.mgmt.web.v2021_01_01.models.Contact
    :param contact_tech: Technical contact.
    :type contact_tech: ~azure.mgmt.web.v2021_01_01.models.Contact
    :ivar registration_status: Domain registration status. Possible values include: "Active",
     "Awaiting", "Cancelled", "Confiscated", "Disabled", "Excluded", "Expired", "Failed", "Held",
     "Locked", "Parked", "Pending", "Reserved", "Reverted", "Suspended", "Transferred", "Unknown",
     "Unlocked", "Unparked", "Updated", "JsonConverterFailed".
    :vartype registration_status: str or ~azure.mgmt.web.v2021_01_01.models.DomainStatus
    :ivar provisioning_state: Domain provisioning state. Possible values include: "Succeeded",
     "Failed", "Canceled", "InProgress", "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2021_01_01.models.ProvisioningState
    :ivar name_servers: Name servers.
    :vartype name_servers: list[str]
    :param privacy: :code:`<code>true</code>` if domain privacy is enabled for this domain;
     otherwise, :code:`<code>false</code>`.
    :type privacy: bool
    :ivar created_time: Domain creation timestamp.
    :vartype created_time: ~datetime.datetime
    :ivar expiration_time: Domain expiration timestamp.
    :vartype expiration_time: ~datetime.datetime
    :ivar last_renewed_time: Timestamp when the domain was renewed last time.
    :vartype last_renewed_time: ~datetime.datetime
    :param auto_renew: :code:`<code>true</code>` if the domain should be automatically renewed;
     otherwise, :code:`<code>false</code>`.
    :type auto_renew: bool
    :ivar ready_for_dns_record_management: :code:`<code>true</code>` if Azure can assign this
     domain to App Service apps; otherwise, :code:`<code>false</code>`. This value will be
     :code:`<code>true</code>` if domain registration status is active and
      it is hosted on name servers Azure has programmatic access to.
    :vartype ready_for_dns_record_management: bool
    :ivar managed_host_names: All hostnames derived from the domain and assigned to Azure
     resources.
    :vartype managed_host_names: list[~azure.mgmt.web.v2021_01_01.models.HostName]
    :param consent: Legal agreement consent.
    :type consent: ~azure.mgmt.web.v2021_01_01.models.DomainPurchaseConsent
    :ivar domain_not_renewable_reasons: Reasons why domain is not renewable.
    :vartype domain_not_renewable_reasons: list[str or
     ~azure.mgmt.web.v2021_01_01.models.DomainPatchResourcePropertiesDomainNotRenewableReasonsItem]
    :param dns_type: Current DNS type. Possible values include: "AzureDns",
     "DefaultDomainRegistrarDns".
    :type dns_type: str or ~azure.mgmt.web.v2021_01_01.models.DnsType
    :param dns_zone_id: Azure DNS Zone to use.
    :type dns_zone_id: str
    :param target_dns_type: Target DNS type (would be used for migration). Possible values include:
     "AzureDns", "DefaultDomainRegistrarDns".
    :type target_dns_type: str or ~azure.mgmt.web.v2021_01_01.models.DnsType
    :param auth_code:
    :type auth_code: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'registration_status': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'name_servers': {'readonly': True},
        'created_time': {'readonly': True},
        'expiration_time': {'readonly': True},
        'last_renewed_time': {'readonly': True},
        'ready_for_dns_record_management': {'readonly': True},
        'managed_host_names': {'readonly': True},
        'domain_not_renewable_reasons': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'contact_admin': {'key': 'properties.contactAdmin', 'type': 'Contact'},
        'contact_billing': {'key': 'properties.contactBilling', 'type': 'Contact'},
        'contact_registrant': {'key': 'properties.contactRegistrant', 'type': 'Contact'},
        'contact_tech': {'key': 'properties.contactTech', 'type': 'Contact'},
        'registration_status': {'key': 'properties.registrationStatus', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name_servers': {'key': 'properties.nameServers', 'type': '[str]'},
        'privacy': {'key': 'properties.privacy', 'type': 'bool'},
        'created_time': {'key': 'properties.createdTime', 'type': 'iso-8601'},
        'expiration_time': {'key': 'properties.expirationTime', 'type': 'iso-8601'},
        'last_renewed_time': {'key': 'properties.lastRenewedTime', 'type': 'iso-8601'},
        'auto_renew': {'key': 'properties.autoRenew', 'type': 'bool'},
        'ready_for_dns_record_management': {'key': 'properties.readyForDnsRecordManagement', 'type': 'bool'},
        'managed_host_names': {'key': 'properties.managedHostNames', 'type': '[HostName]'},
        'consent': {'key': 'properties.consent', 'type': 'DomainPurchaseConsent'},
        'domain_not_renewable_reasons': {'key': 'properties.domainNotRenewableReasons', 'type': '[str]'},
        'dns_type': {'key': 'properties.dnsType', 'type': 'str'},
        'dns_zone_id': {'key': 'properties.dnsZoneId', 'type': 'str'},
        'target_dns_type': {'key': 'properties.targetDnsType', 'type': 'str'},
        'auth_code': {'key': 'properties.authCode', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DomainPatchResource, self).__init__(**kwargs)
        self.contact_admin = kwargs.get('contact_admin', None)
        self.contact_billing = kwargs.get('contact_billing', None)
        self.contact_registrant = kwargs.get('contact_registrant', None)
        self.contact_tech = kwargs.get('contact_tech', None)
        self.registration_status = None
        self.provisioning_state = None
        self.name_servers = None
        self.privacy = kwargs.get('privacy', None)
        self.created_time = None
        self.expiration_time = None
        self.last_renewed_time = None
        self.auto_renew = kwargs.get('auto_renew', True)
        self.ready_for_dns_record_management = None
        self.managed_host_names = None
        self.consent = kwargs.get('consent', None)
        self.domain_not_renewable_reasons = None
        self.dns_type = kwargs.get('dns_type', None)
        self.dns_zone_id = kwargs.get('dns_zone_id', None)
        self.target_dns_type = kwargs.get('target_dns_type', None)
        self.auth_code = kwargs.get('auth_code', None)


class DomainPurchaseConsent(msrest.serialization.Model):
    """Domain purchase consent object, representing acceptance of applicable legal agreements.

    :param agreement_keys: List of applicable legal agreement keys. This list can be retrieved
     using ListLegalAgreements API under :code:`<code>TopLevelDomain</code>` resource.
    :type agreement_keys: list[str]
    :param agreed_by: Client IP address.
    :type agreed_by: str
    :param agreed_at: Timestamp when the agreements were accepted.
    :type agreed_at: ~datetime.datetime
    """

    _attribute_map = {
        'agreement_keys': {'key': 'agreementKeys', 'type': '[str]'},
        'agreed_by': {'key': 'agreedBy', 'type': 'str'},
        'agreed_at': {'key': 'agreedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DomainPurchaseConsent, self).__init__(**kwargs)
        self.agreement_keys = kwargs.get('agreement_keys', None)
        self.agreed_by = kwargs.get('agreed_by', None)
        self.agreed_at = kwargs.get('agreed_at', None)


class DomainRecommendationSearchParameters(msrest.serialization.Model):
    """Domain recommendation search parameters.

    :param keywords: Keywords to be used for generating domain recommendations.
    :type keywords: str
    :param max_domain_recommendations: Maximum number of recommendations.
    :type max_domain_recommendations: int
    """

    _attribute_map = {
        'keywords': {'key': 'keywords', 'type': 'str'},
        'max_domain_recommendations': {'key': 'maxDomainRecommendations', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DomainRecommendationSearchParameters, self).__init__(**kwargs)
        self.keywords = kwargs.get('keywords', None)
        self.max_domain_recommendations = kwargs.get('max_domain_recommendations', None)


class EnabledConfig(msrest.serialization.Model):
    """Enabled configuration.

    :param enabled: True if configuration is enabled, false if it is disabled and null if
     configuration is not set.
    :type enabled: bool
    """

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EnabledConfig, self).__init__(**kwargs)
        self.enabled = kwargs.get('enabled', None)


class EndpointDependency(msrest.serialization.Model):
    """A domain name that a service is reached at, including details of the current connection status.

    :param domain_name: The domain name of the dependency.
    :type domain_name: str
    :param endpoint_details: The IP Addresses and Ports used when connecting to DomainName.
    :type endpoint_details: list[~azure.mgmt.web.v2021_01_01.models.EndpointDetail]
    """

    _attribute_map = {
        'domain_name': {'key': 'domainName', 'type': 'str'},
        'endpoint_details': {'key': 'endpointDetails', 'type': '[EndpointDetail]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EndpointDependency, self).__init__(**kwargs)
        self.domain_name = kwargs.get('domain_name', None)
        self.endpoint_details = kwargs.get('endpoint_details', None)


class EndpointDetail(msrest.serialization.Model):
    """Current TCP connectivity information from the App Service Environment to a single endpoint.

    :param ip_address: An IP Address that Domain Name currently resolves to.
    :type ip_address: str
    :param port: The port an endpoint is connected to.
    :type port: int
    :param latency: The time in milliseconds it takes for a TCP connection to be created from the
     App Service Environment to this IpAddress at this Port.
    :type latency: float
    :param is_accessible: Whether it is possible to create a TCP connection from the App Service
     Environment to this IpAddress at this Port.
    :type is_accessible: bool
    """

    _attribute_map = {
        'ip_address': {'key': 'ipAddress', 'type': 'str'},
        'port': {'key': 'port', 'type': 'int'},
        'latency': {'key': 'latency', 'type': 'float'},
        'is_accessible': {'key': 'isAccessible', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EndpointDetail, self).__init__(**kwargs)
        self.ip_address = kwargs.get('ip_address', None)
        self.port = kwargs.get('port', None)
        self.latency = kwargs.get('latency', None)
        self.is_accessible = kwargs.get('is_accessible', None)


class ErrorEntity(msrest.serialization.Model):
    """Body of the error response returned from the API.

    :param extended_code: Type of error.
    :type extended_code: str
    :param message_template: Message template.
    :type message_template: str
    :param parameters: Parameters for the template.
    :type parameters: list[str]
    :param inner_errors: Inner errors.
    :type inner_errors: list[~azure.mgmt.web.v2021_01_01.models.ErrorEntity]
    :param code: Basic error code.
    :type code: str
    :param message: Any details of the error.
    :type message: str
    """

    _attribute_map = {
        'extended_code': {'key': 'extendedCode', 'type': 'str'},
        'message_template': {'key': 'messageTemplate', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '[str]'},
        'inner_errors': {'key': 'innerErrors', 'type': '[ErrorEntity]'},
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorEntity, self).__init__(**kwargs)
        self.extended_code = kwargs.get('extended_code', None)
        self.message_template = kwargs.get('message_template', None)
        self.parameters = kwargs.get('parameters', None)
        self.inner_errors = kwargs.get('inner_errors', None)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)


class Experiments(msrest.serialization.Model):
    """Routing rules in production experiments.

    :param ramp_up_rules: List of ramp-up rules.
    :type ramp_up_rules: list[~azure.mgmt.web.v2021_01_01.models.RampUpRule]
    """

    _attribute_map = {
        'ramp_up_rules': {'key': 'rampUpRules', 'type': '[RampUpRule]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Experiments, self).__init__(**kwargs)
        self.ramp_up_rules = kwargs.get('ramp_up_rules', None)


class ExtendedLocation(msrest.serialization.Model):
    """Extended Location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param name: Name of extended location.
    :type name: str
    :ivar type: Type of extended location.
    :vartype type: str
    """

    _validation = {
        'type': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExtendedLocation, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.type = None


class Facebook(msrest.serialization.Model):
    """The configuration settings of the Facebook provider.

    :param enabled: :code:`<code>false</code>` if the Facebook provider should not be enabled
     despite the set registration; otherwise, :code:`<code>true</code>`.
    :type enabled: bool
    :param registration: The configuration settings of the app registration for the Facebook
     provider.
    :type registration: ~azure.mgmt.web.v2021_01_01.models.AppRegistration
    :param graph_api_version: The version of the Facebook api to be used while logging in.
    :type graph_api_version: str
    :param login: The configuration settings of the login flow.
    :type login: ~azure.mgmt.web.v2021_01_01.models.LoginScopes
    """

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'registration': {'key': 'registration', 'type': 'AppRegistration'},
        'graph_api_version': {'key': 'graphApiVersion', 'type': 'str'},
        'login': {'key': 'login', 'type': 'LoginScopes'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Facebook, self).__init__(**kwargs)
        self.enabled = kwargs.get('enabled', None)
        self.registration = kwargs.get('registration', None)
        self.graph_api_version = kwargs.get('graph_api_version', None)
        self.login = kwargs.get('login', None)


class FileSystemApplicationLogsConfig(msrest.serialization.Model):
    """Application logs to file system configuration.

    :param level: Log level. Possible values include: "Off", "Verbose", "Information", "Warning",
     "Error".
    :type level: str or ~azure.mgmt.web.v2021_01_01.models.LogLevel
    """

    _attribute_map = {
        'level': {'key': 'level', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FileSystemApplicationLogsConfig, self).__init__(**kwargs)
        self.level = kwargs.get('level', None)


class FileSystemHttpLogsConfig(msrest.serialization.Model):
    """Http logs to file system configuration.

    :param retention_in_mb: Maximum size in megabytes that http log files can use.
     When reached old log files will be removed to make space for new ones.
     Value can range between 25 and 100.
    :type retention_in_mb: int
    :param retention_in_days: Retention in days.
     Remove files older than X days.
     0 or lower means no retention.
    :type retention_in_days: int
    :param enabled: True if configuration is enabled, false if it is disabled and null if
     configuration is not set.
    :type enabled: bool
    """

    _validation = {
        'retention_in_mb': {'maximum': 100, 'minimum': 25},
    }

    _attribute_map = {
        'retention_in_mb': {'key': 'retentionInMb', 'type': 'int'},
        'retention_in_days': {'key': 'retentionInDays', 'type': 'int'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FileSystemHttpLogsConfig, self).__init__(**kwargs)
        self.retention_in_mb = kwargs.get('retention_in_mb', None)
        self.retention_in_days = kwargs.get('retention_in_days', None)
        self.enabled = kwargs.get('enabled', None)


class FileSystemTokenStore(msrest.serialization.Model):
    """The configuration settings of the storage of the tokens if a file system is used.

    :param directory: The directory in which the tokens will be stored.
    :type directory: str
    """

    _attribute_map = {
        'directory': {'key': 'directory', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FileSystemTokenStore, self).__init__(**kwargs)
        self.directory = kwargs.get('directory', None)


class ForwardProxy(msrest.serialization.Model):
    """The configuration settings of a forward proxy used to make the requests.

    :param convention: The convention used to determine the url of the request made. Possible
     values include: "NoProxy", "Standard", "Custom".
    :type convention: str or ~azure.mgmt.web.v2021_01_01.models.ForwardProxyConvention
    :param custom_host_header_name: The name of the header containing the host of the request.
    :type custom_host_header_name: str
    :param custom_proto_header_name: The name of the header containing the scheme of the request.
    :type custom_proto_header_name: str
    """

    _attribute_map = {
        'convention': {'key': 'convention', 'type': 'str'},
        'custom_host_header_name': {'key': 'customHostHeaderName', 'type': 'str'},
        'custom_proto_header_name': {'key': 'customProtoHeaderName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ForwardProxy, self).__init__(**kwargs)
        self.convention = kwargs.get('convention', None)
        self.custom_host_header_name = kwargs.get('custom_host_header_name', None)
        self.custom_proto_header_name = kwargs.get('custom_proto_header_name', None)


class FrontEndConfiguration(msrest.serialization.Model):
    """FrontEndConfiguration.

    :param kind:  Possible values include: "NodePort", "LoadBalancer".
    :type kind: str or ~azure.mgmt.web.v2021_01_01.models.FrontEndServiceType
    """

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FrontEndConfiguration, self).__init__(**kwargs)
        self.kind = kwargs.get('kind', None)


class FunctionAppMajorVersion(msrest.serialization.Model):
    """Function App stack major version.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar display_text: Function App stack major version (display only).
    :vartype display_text: str
    :ivar value: Function App stack major version name.
    :vartype value: str
    :ivar minor_versions: Minor versions associated with the major version.
    :vartype minor_versions: list[~azure.mgmt.web.v2021_01_01.models.FunctionAppMinorVersion]
    """

    _validation = {
        'display_text': {'readonly': True},
        'value': {'readonly': True},
        'minor_versions': {'readonly': True},
    }

    _attribute_map = {
        'display_text': {'key': 'displayText', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'minor_versions': {'key': 'minorVersions', 'type': '[FunctionAppMinorVersion]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FunctionAppMajorVersion, self).__init__(**kwargs)
        self.display_text = None
        self.value = None
        self.minor_versions = None


class FunctionAppMinorVersion(msrest.serialization.Model):
    """Function App stack minor version.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar display_text: Function App stack (display only).
    :vartype display_text: str
    :ivar value: Function App stack name.
    :vartype value: str
    :ivar stack_settings: Settings associated with the minor version.
    :vartype stack_settings: ~azure.mgmt.web.v2021_01_01.models.FunctionAppRuntimes
    """

    _validation = {
        'display_text': {'readonly': True},
        'value': {'readonly': True},
        'stack_settings': {'readonly': True},
    }

    _attribute_map = {
        'display_text': {'key': 'displayText', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'stack_settings': {'key': 'stackSettings', 'type': 'FunctionAppRuntimes'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FunctionAppMinorVersion, self).__init__(**kwargs)
        self.display_text = None
        self.value = None
        self.stack_settings = None


class FunctionAppRuntimes(msrest.serialization.Model):
    """Function App stack runtimes.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar linux_runtime_settings: Linux-specific settings associated with the minor version.
    :vartype linux_runtime_settings: ~azure.mgmt.web.v2021_01_01.models.FunctionAppRuntimeSettings
    :ivar windows_runtime_settings: Windows-specific settings associated with the minor version.
    :vartype windows_runtime_settings:
     ~azure.mgmt.web.v2021_01_01.models.FunctionAppRuntimeSettings
    """

    _validation = {
        'linux_runtime_settings': {'readonly': True},
        'windows_runtime_settings': {'readonly': True},
    }

    _attribute_map = {
        'linux_runtime_settings': {'key': 'linuxRuntimeSettings', 'type': 'FunctionAppRuntimeSettings'},
        'windows_runtime_settings': {'key': 'windowsRuntimeSettings', 'type': 'FunctionAppRuntimeSettings'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FunctionAppRuntimes, self).__init__(**kwargs)
        self.linux_runtime_settings = None
        self.windows_runtime_settings = None


class FunctionAppRuntimeSettings(msrest.serialization.Model):
    """Function App runtime settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar runtime_version: Function App stack minor version (runtime only).
    :vartype runtime_version: str
    :ivar remote_debugging_supported: :code:`<code>true</code>` if remote debugging is supported
     for the stack; otherwise, :code:`<code>false</code>`.
    :vartype remote_debugging_supported: bool
    :ivar app_insights_settings: Application Insights settings associated with the minor version.
    :vartype app_insights_settings:
     ~azure.mgmt.web.v2021_01_01.models.AppInsightsWebAppStackSettings
    :ivar git_hub_action_settings: GitHub Actions settings associated with the minor version.
    :vartype git_hub_action_settings:
     ~azure.mgmt.web.v2021_01_01.models.GitHubActionWebAppStackSettings
    :ivar app_settings_dictionary: Application settings associated with the minor version.
    :vartype app_settings_dictionary: dict[str, str]
    :ivar site_config_properties_dictionary: Configuration settings associated with the minor
     version.
    :vartype site_config_properties_dictionary:
     ~azure.mgmt.web.v2021_01_01.models.SiteConfigPropertiesDictionary
    :ivar supported_functions_extension_versions: List of supported Functions extension versions.
    :vartype supported_functions_extension_versions: list[str]
    :ivar is_preview: :code:`<code>true</code>` if the stack is in preview; otherwise,
     :code:`<code>false</code>`.
    :vartype is_preview: bool
    :ivar is_deprecated: :code:`<code>true</code>` if the stack is deprecated; otherwise,
     :code:`<code>false</code>`.
    :vartype is_deprecated: bool
    :ivar is_hidden: :code:`<code>true</code>` if the stack should be hidden; otherwise,
     :code:`<code>false</code>`.
    :vartype is_hidden: bool
    :ivar end_of_life_date: End-of-life date for the minor version.
    :vartype end_of_life_date: ~datetime.datetime
    :ivar is_auto_update: :code:`<code>true</code>` if the stack version is auto-updated;
     otherwise, :code:`<code>false</code>`.
    :vartype is_auto_update: bool
    :ivar is_early_access: :code:`<code>true</code>` if the minor version is early-access;
     otherwise, :code:`<code>false</code>`.
    :vartype is_early_access: bool
    :ivar is_default: :code:`<code>true</code>` if the minor version the default; otherwise,
     :code:`<code>false</code>`.
    :vartype is_default: bool
    """

    _validation = {
        'runtime_version': {'readonly': True},
        'remote_debugging_supported': {'readonly': True},
        'app_insights_settings': {'readonly': True},
        'git_hub_action_settings': {'readonly': True},
        'app_settings_dictionary': {'readonly': True},
        'site_config_properties_dictionary': {'readonly': True},
        'supported_functions_extension_versions': {'readonly': True},
        'is_preview': {'readonly': True},
        'is_deprecated': {'readonly': True},
        'is_hidden': {'readonly': True},
        'end_of_life_date': {'readonly': True},
        'is_auto_update': {'readonly': True},
        'is_early_access': {'readonly': True},
        'is_default': {'readonly': True},
    }

    _attribute_map = {
        'runtime_version': {'key': 'runtimeVersion', 'type': 'str'},
        'remote_debugging_supported': {'key': 'remoteDebuggingSupported', 'type': 'bool'},
        'app_insights_settings': {'key': 'appInsightsSettings', 'type': 'AppInsightsWebAppStackSettings'},
        'git_hub_action_settings': {'key': 'gitHubActionSettings', 'type': 'GitHubActionWebAppStackSettings'},
        'app_settings_dictionary': {'key': 'appSettingsDictionary', 'type': '{str}'},
        'site_config_properties_dictionary': {'key': 'siteConfigPropertiesDictionary', 'type': 'SiteConfigPropertiesDictionary'},
        'supported_functions_extension_versions': {'key': 'supportedFunctionsExtensionVersions', 'type': '[str]'},
        'is_preview': {'key': 'isPreview', 'type': 'bool'},
        'is_deprecated': {'key': 'isDeprecated', 'type': 'bool'},
        'is_hidden': {'key': 'isHidden', 'type': 'bool'},
        'end_of_life_date': {'key': 'endOfLifeDate', 'type': 'iso-8601'},
        'is_auto_update': {'key': 'isAutoUpdate', 'type': 'bool'},
        'is_early_access': {'key': 'isEarlyAccess', 'type': 'bool'},
        'is_default': {'key': 'isDefault', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FunctionAppRuntimeSettings, self).__init__(**kwargs)
        self.runtime_version = None
        self.remote_debugging_supported = None
        self.app_insights_settings = None
        self.git_hub_action_settings = None
        self.app_settings_dictionary = None
        self.site_config_properties_dictionary = None
        self.supported_functions_extension_versions = None
        self.is_preview = None
        self.is_deprecated = None
        self.is_hidden = None
        self.end_of_life_date = None
        self.is_auto_update = None
        self.is_early_access = None
        self.is_default = None


class FunctionAppStack(ProxyOnlyResource):
    """Function App Stack.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Function App stack location.
    :vartype location: str
    :ivar display_text: Function App stack (display only).
    :vartype display_text: str
    :ivar value: Function App stack name.
    :vartype value: str
    :ivar major_versions: List of major versions available.
    :vartype major_versions: list[~azure.mgmt.web.v2021_01_01.models.FunctionAppMajorVersion]
    :ivar preferred_os: Function App stack preferred OS. Possible values include: "Windows",
     "Linux".
    :vartype preferred_os: str or ~azure.mgmt.web.v2021_01_01.models.StackPreferredOs
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
        'display_text': {'readonly': True},
        'value': {'readonly': True},
        'major_versions': {'readonly': True},
        'preferred_os': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'display_text': {'key': 'properties.displayText', 'type': 'str'},
        'value': {'key': 'properties.value', 'type': 'str'},
        'major_versions': {'key': 'properties.majorVersions', 'type': '[FunctionAppMajorVersion]'},
        'preferred_os': {'key': 'properties.preferredOs', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FunctionAppStack, self).__init__(**kwargs)
        self.location = None
        self.display_text = None
        self.value = None
        self.major_versions = None
        self.preferred_os = None


class FunctionAppStackCollection(msrest.serialization.Model):
    """Collection of Function app Stacks.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2021_01_01.models.FunctionAppStack]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[FunctionAppStack]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FunctionAppStackCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class FunctionEnvelope(ProxyOnlyResource):
    """Function information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param function_app_id: Function App ID.
    :type function_app_id: str
    :param script_root_path_href: Script root path URI.
    :type script_root_path_href: str
    :param script_href: Script URI.
    :type script_href: str
    :param config_href: Config URI.
    :type config_href: str
    :param test_data_href: Test data URI.
    :type test_data_href: str
    :param secrets_file_href: Secrets file URI.
    :type secrets_file_href: str
    :param href: Function URI.
    :type href: str
    :param config: Config information.
    :type config: any
    :param files: File list.
    :type files: dict[str, str]
    :param test_data: Test data used when testing via the Azure Portal.
    :type test_data: str
    :param invoke_url_template: The invocation URL.
    :type invoke_url_template: str
    :param language: The function language.
    :type language: str
    :param is_disabled: Gets or sets a value indicating whether the function is disabled.
    :type is_disabled: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'function_app_id': {'key': 'properties.function_app_id', 'type': 'str'},
        'script_root_path_href': {'key': 'properties.script_root_path_href', 'type': 'str'},
        'script_href': {'key': 'properties.script_href', 'type': 'str'},
        'config_href': {'key': 'properties.config_href', 'type': 'str'},
        'test_data_href': {'key': 'properties.test_data_href', 'type': 'str'},
        'secrets_file_href': {'key': 'properties.secrets_file_href', 'type': 'str'},
        'href': {'key': 'properties.href', 'type': 'str'},
        'config': {'key': 'properties.config', 'type': 'object'},
        'files': {'key': 'properties.files', 'type': '{str}'},
        'test_data': {'key': 'properties.test_data', 'type': 'str'},
        'invoke_url_template': {'key': 'properties.invoke_url_template', 'type': 'str'},
        'language': {'key': 'properties.language', 'type': 'str'},
        'is_disabled': {'key': 'properties.isDisabled', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FunctionEnvelope, self).__init__(**kwargs)
        self.function_app_id = kwargs.get('function_app_id', None)
        self.script_root_path_href = kwargs.get('script_root_path_href', None)
        self.script_href = kwargs.get('script_href', None)
        self.config_href = kwargs.get('config_href', None)
        self.test_data_href = kwargs.get('test_data_href', None)
        self.secrets_file_href = kwargs.get('secrets_file_href', None)
        self.href = kwargs.get('href', None)
        self.config = kwargs.get('config', None)
        self.files = kwargs.get('files', None)
        self.test_data = kwargs.get('test_data', None)
        self.invoke_url_template = kwargs.get('invoke_url_template', None)
        self.language = kwargs.get('language', None)
        self.is_disabled = kwargs.get('is_disabled', None)


class FunctionEnvelopeCollection(msrest.serialization.Model):
    """Collection of Kudu function information elements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2021_01_01.models.FunctionEnvelope]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[FunctionEnvelope]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FunctionEnvelopeCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class FunctionSecrets(msrest.serialization.Model):
    """Function secrets.

    :param key: Secret key.
    :type key: str
    :param trigger_url: Trigger URL.
    :type trigger_url: str
    """

    _attribute_map = {
        'key': {'key': 'key', 'type': 'str'},
        'trigger_url': {'key': 'trigger_url', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FunctionSecrets, self).__init__(**kwargs)
        self.key = kwargs.get('key', None)
        self.trigger_url = kwargs.get('trigger_url', None)


class GeoRegion(ProxyOnlyResource):
    """Geographical region.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar description: Region description.
    :vartype description: str
    :ivar display_name: Display name for region.
    :vartype display_name: str
    :ivar org_domain: Display name for region.
    :vartype org_domain: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'description': {'readonly': True},
        'display_name': {'readonly': True},
        'org_domain': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'org_domain': {'key': 'properties.orgDomain', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GeoRegion, self).__init__(**kwargs)
        self.description = None
        self.display_name = None
        self.org_domain = None


class GeoRegionCollection(msrest.serialization.Model):
    """Collection of geographical regions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2021_01_01.models.GeoRegion]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[GeoRegion]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GeoRegionCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class GitHub(msrest.serialization.Model):
    """The configuration settings of the GitHub provider.

    :param enabled: :code:`<code>false</code>` if the GitHub provider should not be enabled despite
     the set registration; otherwise, :code:`<code>true</code>`.
    :type enabled: bool
    :param registration: The configuration settings of the app registration for the GitHub
     provider.
    :type registration: ~azure.mgmt.web.v2021_01_01.models.ClientRegistration
    :param login: The configuration settings of the login flow.
    :type login: ~azure.mgmt.web.v2021_01_01.models.LoginScopes
    """

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'registration': {'key': 'registration', 'type': 'ClientRegistration'},
        'login': {'key': 'login', 'type': 'LoginScopes'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GitHub, self).__init__(**kwargs)
        self.enabled = kwargs.get('enabled', None)
        self.registration = kwargs.get('registration', None)
        self.login = kwargs.get('login', None)


class GitHubActionCodeConfiguration(msrest.serialization.Model):
    """The GitHub action code configuration.

    :param runtime_stack: Runtime stack is used to determine the workflow file content for code
     base apps.
    :type runtime_stack: str
    :param runtime_version: Runtime version is used to determine what build version to set in the
     workflow file.
    :type runtime_version: str
    """

    _attribute_map = {
        'runtime_stack': {'key': 'runtimeStack', 'type': 'str'},
        'runtime_version': {'key': 'runtimeVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GitHubActionCodeConfiguration, self).__init__(**kwargs)
        self.runtime_stack = kwargs.get('runtime_stack', None)
        self.runtime_version = kwargs.get('runtime_version', None)


class GitHubActionConfiguration(msrest.serialization.Model):
    """The GitHub action configuration.

    :param code_configuration: GitHub Action code configuration.
    :type code_configuration: ~azure.mgmt.web.v2021_01_01.models.GitHubActionCodeConfiguration
    :param container_configuration: GitHub Action container configuration.
    :type container_configuration:
     ~azure.mgmt.web.v2021_01_01.models.GitHubActionContainerConfiguration
    :param is_linux: This will help determine the workflow configuration to select.
    :type is_linux: bool
    :param generate_workflow_file: Workflow option to determine whether the workflow file should be
     generated and written to the repository.
    :type generate_workflow_file: bool
    """

    _attribute_map = {
        'code_configuration': {'key': 'codeConfiguration', 'type': 'GitHubActionCodeConfiguration'},
        'container_configuration': {'key': 'containerConfiguration', 'type': 'GitHubActionContainerConfiguration'},
        'is_linux': {'key': 'isLinux', 'type': 'bool'},
        'generate_workflow_file': {'key': 'generateWorkflowFile', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GitHubActionConfiguration, self).__init__(**kwargs)
        self.code_configuration = kwargs.get('code_configuration', None)
        self.container_configuration = kwargs.get('container_configuration', None)
        self.is_linux = kwargs.get('is_linux', None)
        self.generate_workflow_file = kwargs.get('generate_workflow_file', None)


class GitHubActionContainerConfiguration(msrest.serialization.Model):
    """The GitHub action container configuration.

    :param server_url: The server URL for the container registry where the build will be hosted.
    :type server_url: str
    :param image_name: The image name for the build.
    :type image_name: str
    :param username: The username used to upload the image to the container registry.
    :type username: str
    :param password: The password used to upload the image to the container registry.
    :type password: str
    """

    _attribute_map = {
        'server_url': {'key': 'serverUrl', 'type': 'str'},
        'image_name': {'key': 'imageName', 'type': 'str'},
        'username': {'key': 'username', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GitHubActionContainerConfiguration, self).__init__(**kwargs)
        self.server_url = kwargs.get('server_url', None)
        self.image_name = kwargs.get('image_name', None)
        self.username = kwargs.get('username', None)
        self.password = kwargs.get('password', None)


class GitHubActionWebAppStackSettings(msrest.serialization.Model):
    """GitHub Actions Web App stack settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar is_supported: :code:`<code>true</code>` if GitHub Actions is supported for the stack;
     otherwise, :code:`<code>false</code>`.
    :vartype is_supported: bool
    :ivar supported_version: The minor version that is supported for GitHub Actions.
    :vartype supported_version: str
    """

    _validation = {
        'is_supported': {'readonly': True},
        'supported_version': {'readonly': True},
    }

    _attribute_map = {
        'is_supported': {'key': 'isSupported', 'type': 'bool'},
        'supported_version': {'key': 'supportedVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GitHubActionWebAppStackSettings, self).__init__(**kwargs)
        self.is_supported = None
        self.supported_version = None


class GlobalCsmSkuDescription(msrest.serialization.Model):
    """A Global SKU Description.

    :param name: Name of the resource SKU.
    :type name: str
    :param tier: Service Tier of the resource SKU.
    :type tier: str
    :param size: Size specifier of the resource SKU.
    :type size: str
    :param family: Family code of the resource SKU.
    :type family: str
    :param capacity: Min, max, and default scale values of the SKU.
    :type capacity: ~azure.mgmt.web.v2021_01_01.models.SkuCapacity
    :param locations: Locations of the SKU.
    :type locations: list[str]
    :param capabilities: Capabilities of the SKU, e.g., is traffic manager enabled?.
    :type capabilities: list[~azure.mgmt.web.v2021_01_01.models.Capability]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'size': {'key': 'size', 'type': 'str'},
        'family': {'key': 'family', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'SkuCapacity'},
        'locations': {'key': 'locations', 'type': '[str]'},
        'capabilities': {'key': 'capabilities', 'type': '[Capability]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GlobalCsmSkuDescription, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.tier = kwargs.get('tier', None)
        self.size = kwargs.get('size', None)
        self.family = kwargs.get('family', None)
        self.capacity = kwargs.get('capacity', None)
        self.locations = kwargs.get('locations', None)
        self.capabilities = kwargs.get('capabilities', None)


class GlobalValidation(msrest.serialization.Model):
    """The configuration settings that determines the validation flow of users using App Service Authentication/Authorization.

    :param require_authentication: :code:`<code>true</code>` if the authentication flow is required
     any request is made; otherwise, :code:`<code>false</code>`.
    :type require_authentication: bool
    :param unauthenticated_client_action: The action to take when an unauthenticated client
     attempts to access the app. Possible values include: "RedirectToLoginPage", "AllowAnonymous",
     "Return401", "Return403".
    :type unauthenticated_client_action: str or
     ~azure.mgmt.web.v2021_01_01.models.UnauthenticatedClientActionV2
    :param redirect_to_provider: The default authentication provider to use when multiple providers
     are configured.
     This setting is only needed if multiple providers are configured and the unauthenticated
     client
     action is set to "RedirectToLoginPage".
    :type redirect_to_provider: str
    :param excluded_paths: The paths for which unauthenticated flow would not be redirected to the
     login page.
    :type excluded_paths: list[str]
    """

    _attribute_map = {
        'require_authentication': {'key': 'requireAuthentication', 'type': 'bool'},
        'unauthenticated_client_action': {'key': 'unauthenticatedClientAction', 'type': 'str'},
        'redirect_to_provider': {'key': 'redirectToProvider', 'type': 'str'},
        'excluded_paths': {'key': 'excludedPaths', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GlobalValidation, self).__init__(**kwargs)
        self.require_authentication = kwargs.get('require_authentication', None)
        self.unauthenticated_client_action = kwargs.get('unauthenticated_client_action', None)
        self.redirect_to_provider = kwargs.get('redirect_to_provider', None)
        self.excluded_paths = kwargs.get('excluded_paths', None)


class Google(msrest.serialization.Model):
    """The configuration settings of the Google provider.

    :param enabled: :code:`<code>false</code>` if the Google provider should not be enabled despite
     the set registration; otherwise, :code:`<code>true</code>`.
    :type enabled: bool
    :param registration: The configuration settings of the app registration for the Google
     provider.
    :type registration: ~azure.mgmt.web.v2021_01_01.models.ClientRegistration
    :param login: The configuration settings of the login flow.
    :type login: ~azure.mgmt.web.v2021_01_01.models.LoginScopes
    :param validation: The configuration settings of the Azure Active Directory token validation
     flow.
    :type validation: ~azure.mgmt.web.v2021_01_01.models.AllowedAudiencesValidation
    """

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'registration': {'key': 'registration', 'type': 'ClientRegistration'},
        'login': {'key': 'login', 'type': 'LoginScopes'},
        'validation': {'key': 'validation', 'type': 'AllowedAudiencesValidation'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Google, self).__init__(**kwargs)
        self.enabled = kwargs.get('enabled', None)
        self.registration = kwargs.get('registration', None)
        self.login = kwargs.get('login', None)
        self.validation = kwargs.get('validation', None)


class HandlerMapping(msrest.serialization.Model):
    """The IIS handler mappings used to define which handler processes HTTP requests with certain extension. 
For example, it is used to configure php-cgi.exe process to handle all HTTP requests with *.php extension.

    :param extension: Requests with this extension will be handled using the specified FastCGI
     application.
    :type extension: str
    :param script_processor: The absolute path to the FastCGI application.
    :type script_processor: str
    :param arguments: Command-line arguments to be passed to the script processor.
    :type arguments: str
    """

    _attribute_map = {
        'extension': {'key': 'extension', 'type': 'str'},
        'script_processor': {'key': 'scriptProcessor', 'type': 'str'},
        'arguments': {'key': 'arguments', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HandlerMapping, self).__init__(**kwargs)
        self.extension = kwargs.get('extension', None)
        self.script_processor = kwargs.get('script_processor', None)
        self.arguments = kwargs.get('arguments', None)


class HostingEnvironmentDeploymentInfo(msrest.serialization.Model):
    """Information needed to create resources on an App Service Environment.

    :param name: Name of the App Service Environment.
    :type name: str
    :param location: Location of the App Service Environment.
    :type location: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HostingEnvironmentDeploymentInfo, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.location = kwargs.get('location', None)


class HostingEnvironmentDiagnostics(msrest.serialization.Model):
    """Diagnostics for an App Service Environment.

    :param name: Name/identifier of the diagnostics.
    :type name: str
    :param diagnostics_output: Diagnostics output.
    :type diagnostics_output: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'diagnostics_output': {'key': 'diagnosticsOutput', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HostingEnvironmentDiagnostics, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.diagnostics_output = kwargs.get('diagnostics_output', None)


class HostingEnvironmentProfile(msrest.serialization.Model):
    """Specification for an App Service Environment to use for this resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID of the App Service Environment.
    :type id: str
    :ivar name: Name of the App Service Environment.
    :vartype name: str
    :ivar type: Resource type of the App Service Environment.
    :vartype type: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HostingEnvironmentProfile, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = None
        self.type = None


class HostKeys(msrest.serialization.Model):
    """Functions host level keys.

    :param master_key: Secret key.
    :type master_key: str
    :param function_keys: Host level function keys.
    :type function_keys: dict[str, str]
    :param system_keys: System keys.
    :type system_keys: dict[str, str]
    """

    _attribute_map = {
        'master_key': {'key': 'masterKey', 'type': 'str'},
        'function_keys': {'key': 'functionKeys', 'type': '{str}'},
        'system_keys': {'key': 'systemKeys', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HostKeys, self).__init__(**kwargs)
        self.master_key = kwargs.get('master_key', None)
        self.function_keys = kwargs.get('function_keys', None)
        self.system_keys = kwargs.get('system_keys', None)


class HostName(msrest.serialization.Model):
    """Details of a hostname derived from a domain.

    :param name: Name of the hostname.
    :type name: str
    :param site_names: List of apps the hostname is assigned to. This list will have more than one
     app only if the hostname is pointing to a Traffic Manager.
    :type site_names: list[str]
    :param azure_resource_name: Name of the Azure resource the hostname is assigned to. If it is
     assigned to a Traffic Manager then it will be the Traffic Manager name otherwise it will be the
     app name.
    :type azure_resource_name: str
    :param azure_resource_type: Type of the Azure resource the hostname is assigned to. Possible
     values include: "Website", "TrafficManager".
    :type azure_resource_type: str or ~azure.mgmt.web.v2021_01_01.models.AzureResourceType
    :param custom_host_name_dns_record_type: Type of the DNS record. Possible values include:
     "CName", "A".
    :type custom_host_name_dns_record_type: str or
     ~azure.mgmt.web.v2021_01_01.models.CustomHostNameDnsRecordType
    :param host_name_type: Type of the hostname. Possible values include: "Verified", "Managed".
    :type host_name_type: str or ~azure.mgmt.web.v2021_01_01.models.HostNameType
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'site_names': {'key': 'siteNames', 'type': '[str]'},
        'azure_resource_name': {'key': 'azureResourceName', 'type': 'str'},
        'azure_resource_type': {'key': 'azureResourceType', 'type': 'str'},
        'custom_host_name_dns_record_type': {'key': 'customHostNameDnsRecordType', 'type': 'str'},
        'host_name_type': {'key': 'hostNameType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HostName, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.site_names = kwargs.get('site_names', None)
        self.azure_resource_name = kwargs.get('azure_resource_name', None)
        self.azure_resource_type = kwargs.get('azure_resource_type', None)
        self.custom_host_name_dns_record_type = kwargs.get('custom_host_name_dns_record_type', None)
        self.host_name_type = kwargs.get('host_name_type', None)


class HostNameBinding(ProxyOnlyResource):
    """A hostname binding object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param site_name: App Service app name.
    :type site_name: str
    :param domain_id: Fully qualified ARM domain resource URI.
    :type domain_id: str
    :param azure_resource_name: Azure resource name.
    :type azure_resource_name: str
    :param azure_resource_type: Azure resource type. Possible values include: "Website",
     "TrafficManager".
    :type azure_resource_type: str or ~azure.mgmt.web.v2021_01_01.models.AzureResourceType
    :param custom_host_name_dns_record_type: Custom DNS record type. Possible values include:
     "CName", "A".
    :type custom_host_name_dns_record_type: str or
     ~azure.mgmt.web.v2021_01_01.models.CustomHostNameDnsRecordType
    :param host_name_type: Hostname type. Possible values include: "Verified", "Managed".
    :type host_name_type: str or ~azure.mgmt.web.v2021_01_01.models.HostNameType
    :param ssl_state: SSL type. Possible values include: "Disabled", "SniEnabled",
     "IpBasedEnabled".
    :type ssl_state: str or ~azure.mgmt.web.v2021_01_01.models.SslState
    :param thumbprint: SSL certificate thumbprint.
    :type thumbprint: str
    :ivar virtual_ip: Virtual IP address assigned to the hostname if IP based SSL is enabled.
    :vartype virtual_ip: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'virtual_ip': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'site_name': {'key': 'properties.siteName', 'type': 'str'},
        'domain_id': {'key': 'properties.domainId', 'type': 'str'},
        'azure_resource_name': {'key': 'properties.azureResourceName', 'type': 'str'},
        'azure_resource_type': {'key': 'properties.azureResourceType', 'type': 'str'},
        'custom_host_name_dns_record_type': {'key': 'properties.customHostNameDnsRecordType', 'type': 'str'},
        'host_name_type': {'key': 'properties.hostNameType', 'type': 'str'},
        'ssl_state': {'key': 'properties.sslState', 'type': 'str'},
        'thumbprint': {'key': 'properties.thumbprint', 'type': 'str'},
        'virtual_ip': {'key': 'properties.virtualIP', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HostNameBinding, self).__init__(**kwargs)
        self.site_name = kwargs.get('site_name', None)
        self.domain_id = kwargs.get('domain_id', None)
        self.azure_resource_name = kwargs.get('azure_resource_name', None)
        self.azure_resource_type = kwargs.get('azure_resource_type', None)
        self.custom_host_name_dns_record_type = kwargs.get('custom_host_name_dns_record_type', None)
        self.host_name_type = kwargs.get('host_name_type', None)
        self.ssl_state = kwargs.get('ssl_state', None)
        self.thumbprint = kwargs.get('thumbprint', None)
        self.virtual_ip = None


class HostNameBindingCollection(msrest.serialization.Model):
    """Collection of hostname bindings.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2021_01_01.models.HostNameBinding]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[HostNameBinding]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HostNameBindingCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class HostNameSslState(msrest.serialization.Model):
    """SSL-enabled hostname.

    :param name: Hostname.
    :type name: str
    :param ssl_state: SSL type. Possible values include: "Disabled", "SniEnabled",
     "IpBasedEnabled".
    :type ssl_state: str or ~azure.mgmt.web.v2021_01_01.models.SslState
    :param virtual_ip: Virtual IP address assigned to the hostname if IP based SSL is enabled.
    :type virtual_ip: str
    :param thumbprint: SSL certificate thumbprint.
    :type thumbprint: str
    :param to_update: Set to :code:`<code>true</code>` to update existing hostname.
    :type to_update: bool
    :param host_type: Indicates whether the hostname is a standard or repository hostname. Possible
     values include: "Standard", "Repository".
    :type host_type: str or ~azure.mgmt.web.v2021_01_01.models.HostType
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'ssl_state': {'key': 'sslState', 'type': 'str'},
        'virtual_ip': {'key': 'virtualIP', 'type': 'str'},
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
        'to_update': {'key': 'toUpdate', 'type': 'bool'},
        'host_type': {'key': 'hostType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HostNameSslState, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.ssl_state = kwargs.get('ssl_state', None)
        self.virtual_ip = kwargs.get('virtual_ip', None)
        self.thumbprint = kwargs.get('thumbprint', None)
        self.to_update = kwargs.get('to_update', None)
        self.host_type = kwargs.get('host_type', None)


class HttpLogsConfig(msrest.serialization.Model):
    """Http logs configuration.

    :param file_system: Http logs to file system configuration.
    :type file_system: ~azure.mgmt.web.v2021_01_01.models.FileSystemHttpLogsConfig
    :param azure_blob_storage: Http logs to azure blob storage configuration.
    :type azure_blob_storage: ~azure.mgmt.web.v2021_01_01.models.AzureBlobStorageHttpLogsConfig
    """

    _attribute_map = {
        'file_system': {'key': 'fileSystem', 'type': 'FileSystemHttpLogsConfig'},
        'azure_blob_storage': {'key': 'azureBlobStorage', 'type': 'AzureBlobStorageHttpLogsConfig'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HttpLogsConfig, self).__init__(**kwargs)
        self.file_system = kwargs.get('file_system', None)
        self.azure_blob_storage = kwargs.get('azure_blob_storage', None)


class HttpSettings(msrest.serialization.Model):
    """The configuration settings of the HTTP requests for authentication and authorization requests made against App Service Authentication/Authorization.

    :param require_https: :code:`<code>false</code>` if the authentication/authorization responses
     not having the HTTPS scheme are permissible; otherwise, :code:`<code>true</code>`.
    :type require_https: bool
    :param routes: The configuration settings of the paths HTTP requests.
    :type routes: ~azure.mgmt.web.v2021_01_01.models.HttpSettingsRoutes
    :param forward_proxy: The configuration settings of a forward proxy used to make the requests.
    :type forward_proxy: ~azure.mgmt.web.v2021_01_01.models.ForwardProxy
    """

    _attribute_map = {
        'require_https': {'key': 'requireHttps', 'type': 'bool'},
        'routes': {'key': 'routes', 'type': 'HttpSettingsRoutes'},
        'forward_proxy': {'key': 'forwardProxy', 'type': 'ForwardProxy'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HttpSettings, self).__init__(**kwargs)
        self.require_https = kwargs.get('require_https', None)
        self.routes = kwargs.get('routes', None)
        self.forward_proxy = kwargs.get('forward_proxy', None)


class HttpSettingsRoutes(msrest.serialization.Model):
    """The configuration settings of the paths HTTP requests.

    :param api_prefix: The prefix that should precede all the authentication/authorization paths.
    :type api_prefix: str
    """

    _attribute_map = {
        'api_prefix': {'key': 'apiPrefix', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HttpSettingsRoutes, self).__init__(**kwargs)
        self.api_prefix = kwargs.get('api_prefix', None)


class HybridConnection(ProxyOnlyResource):
    """Hybrid Connection contract. This is used to configure a Hybrid Connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param service_bus_namespace: The name of the Service Bus namespace.
    :type service_bus_namespace: str
    :param relay_name: The name of the Service Bus relay.
    :type relay_name: str
    :param relay_arm_uri: The ARM URI to the Service Bus relay.
    :type relay_arm_uri: str
    :param hostname: The hostname of the endpoint.
    :type hostname: str
    :param port: The port of the endpoint.
    :type port: int
    :param send_key_name: The name of the Service Bus key which has Send permissions. This is used
     to authenticate to Service Bus.
    :type send_key_name: str
    :param send_key_value: The value of the Service Bus key. This is used to authenticate to
     Service Bus. In ARM this key will not be returned
     normally, use the POST /listKeys API instead.
    :type send_key_value: str
    :param service_bus_suffix: The suffix for the service bus endpoint. By default this is
     .servicebus.windows.net.
    :type service_bus_suffix: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'service_bus_namespace': {'key': 'properties.serviceBusNamespace', 'type': 'str'},
        'relay_name': {'key': 'properties.relayName', 'type': 'str'},
        'relay_arm_uri': {'key': 'properties.relayArmUri', 'type': 'str'},
        'hostname': {'key': 'properties.hostname', 'type': 'str'},
        'port': {'key': 'properties.port', 'type': 'int'},
        'send_key_name': {'key': 'properties.sendKeyName', 'type': 'str'},
        'send_key_value': {'key': 'properties.sendKeyValue', 'type': 'str'},
        'service_bus_suffix': {'key': 'properties.serviceBusSuffix', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HybridConnection, self).__init__(**kwargs)
        self.service_bus_namespace = kwargs.get('service_bus_namespace', None)
        self.relay_name = kwargs.get('relay_name', None)
        self.relay_arm_uri = kwargs.get('relay_arm_uri', None)
        self.hostname = kwargs.get('hostname', None)
        self.port = kwargs.get('port', None)
        self.send_key_name = kwargs.get('send_key_name', None)
        self.send_key_value = kwargs.get('send_key_value', None)
        self.service_bus_suffix = kwargs.get('service_bus_suffix', None)


class HybridConnectionCollection(msrest.serialization.Model):
    """Collection of hostname bindings.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2021_01_01.models.HybridConnection]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[HybridConnection]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HybridConnectionCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class HybridConnectionKey(ProxyOnlyResource):
    """Hybrid Connection key contract. This has the send key name and value for a Hybrid Connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar send_key_name: The name of the send key.
    :vartype send_key_name: str
    :ivar send_key_value: The value of the send key.
    :vartype send_key_value: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'send_key_name': {'readonly': True},
        'send_key_value': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'send_key_name': {'key': 'properties.sendKeyName', 'type': 'str'},
        'send_key_value': {'key': 'properties.sendKeyValue', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HybridConnectionKey, self).__init__(**kwargs)
        self.send_key_name = None
        self.send_key_value = None


class HybridConnectionLimits(ProxyOnlyResource):
    """Hybrid Connection limits contract. This is used to return the plan limits of Hybrid Connections.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar current: The current number of Hybrid Connections.
    :vartype current: int
    :ivar maximum: The maximum number of Hybrid Connections allowed.
    :vartype maximum: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'current': {'readonly': True},
        'maximum': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'current': {'key': 'properties.current', 'type': 'int'},
        'maximum': {'key': 'properties.maximum', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HybridConnectionLimits, self).__init__(**kwargs)
        self.current = None
        self.maximum = None


class Identifier(ProxyOnlyResource):
    """A domain specific resource identifier.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param value: String representation of the identity.
    :type value: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'value': {'key': 'properties.id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Identifier, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class IdentifierCollection(msrest.serialization.Model):
    """Collection of identifiers.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2021_01_01.models.Identifier]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Identifier]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IdentifierCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class IdentityProviders(msrest.serialization.Model):
    """The configuration settings of each of the identity providers used to configure App Service Authentication/Authorization.

    :param azure_active_directory: The configuration settings of the Azure Active directory
     provider.
    :type azure_active_directory: ~azure.mgmt.web.v2021_01_01.models.AzureActiveDirectory
    :param facebook: The configuration settings of the Facebook provider.
    :type facebook: ~azure.mgmt.web.v2021_01_01.models.Facebook
    :param git_hub: The configuration settings of the GitHub provider.
    :type git_hub: ~azure.mgmt.web.v2021_01_01.models.GitHub
    :param google: The configuration settings of the Google provider.
    :type google: ~azure.mgmt.web.v2021_01_01.models.Google
    :param legacy_microsoft_account: The configuration settings of the legacy Microsoft Account
     provider.
    :type legacy_microsoft_account: ~azure.mgmt.web.v2021_01_01.models.LegacyMicrosoftAccount
    :param twitter: The configuration settings of the Twitter provider.
    :type twitter: ~azure.mgmt.web.v2021_01_01.models.Twitter
    :param apple: The configuration settings of the Apple provider.
    :type apple: ~azure.mgmt.web.v2021_01_01.models.Apple
    :param azure_static_web_apps: The configuration settings of the Azure Static Web Apps provider.
    :type azure_static_web_apps: ~azure.mgmt.web.v2021_01_01.models.AzureStaticWebApps
    :param custom_open_id_connect_providers: The map of the name of the alias of each custom Open
     ID Connect provider to the
     configuration settings of the custom Open ID Connect provider.
    :type custom_open_id_connect_providers: dict[str,
     ~azure.mgmt.web.v2021_01_01.models.CustomOpenIdConnectProvider]
    """

    _attribute_map = {
        'azure_active_directory': {'key': 'azureActiveDirectory', 'type': 'AzureActiveDirectory'},
        'facebook': {'key': 'facebook', 'type': 'Facebook'},
        'git_hub': {'key': 'gitHub', 'type': 'GitHub'},
        'google': {'key': 'google', 'type': 'Google'},
        'legacy_microsoft_account': {'key': 'legacyMicrosoftAccount', 'type': 'LegacyMicrosoftAccount'},
        'twitter': {'key': 'twitter', 'type': 'Twitter'},
        'apple': {'key': 'apple', 'type': 'Apple'},
        'azure_static_web_apps': {'key': 'azureStaticWebApps', 'type': 'AzureStaticWebApps'},
        'custom_open_id_connect_providers': {'key': 'customOpenIdConnectProviders', 'type': '{CustomOpenIdConnectProvider}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IdentityProviders, self).__init__(**kwargs)
        self.azure_active_directory = kwargs.get('azure_active_directory', None)
        self.facebook = kwargs.get('facebook', None)
        self.git_hub = kwargs.get('git_hub', None)
        self.google = kwargs.get('google', None)
        self.legacy_microsoft_account = kwargs.get('legacy_microsoft_account', None)
        self.twitter = kwargs.get('twitter', None)
        self.apple = kwargs.get('apple', None)
        self.azure_static_web_apps = kwargs.get('azure_static_web_apps', None)
        self.custom_open_id_connect_providers = kwargs.get('custom_open_id_connect_providers', None)


class InboundEnvironmentEndpoint(msrest.serialization.Model):
    """The IP Addresses and Ports that require inbound network access to and within the subnet of the App Service Environment.

    :param description: Short text describing the purpose of the network traffic.
    :type description: str
    :param endpoints: The IP addresses that network traffic will originate from in cidr notation.
    :type endpoints: list[str]
    :param ports: The ports that network traffic will arrive to the App Service Environment at.
    :type ports: list[str]
    """

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'endpoints': {'key': 'endpoints', 'type': '[str]'},
        'ports': {'key': 'ports', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(InboundEnvironmentEndpoint, self).__init__(**kwargs)
        self.description = kwargs.get('description', None)
        self.endpoints = kwargs.get('endpoints', None)
        self.ports = kwargs.get('ports', None)


class InboundEnvironmentEndpointCollection(msrest.serialization.Model):
    """Collection of Inbound Environment Endpoints.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2021_01_01.models.InboundEnvironmentEndpoint]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[InboundEnvironmentEndpoint]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(InboundEnvironmentEndpointCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class IpSecurityRestriction(msrest.serialization.Model):
    """IP security restriction on an app.

    :param ip_address: IP address the security restriction is valid for.
     It can be in form of pure ipv4 address (required SubnetMask property) or
     CIDR notation such as ipv4/mask (leading bit match). For CIDR,
     SubnetMask property must not be specified.
    :type ip_address: str
    :param subnet_mask: Subnet mask for the range of IP addresses the restriction is valid for.
    :type subnet_mask: str
    :param vnet_subnet_resource_id: Virtual network resource id.
    :type vnet_subnet_resource_id: str
    :param vnet_traffic_tag: (internal) Vnet traffic tag.
    :type vnet_traffic_tag: int
    :param subnet_traffic_tag: (internal) Subnet traffic tag.
    :type subnet_traffic_tag: int
    :param action: Allow or Deny access for this IP range.
    :type action: str
    :param tag: Defines what this IP filter will be used for. This is to support IP filtering on
     proxies. Possible values include: "Default", "XffProxy", "ServiceTag".
    :type tag: str or ~azure.mgmt.web.v2021_01_01.models.IpFilterTag
    :param priority: Priority of IP restriction rule.
    :type priority: int
    :param name: IP restriction rule name.
    :type name: str
    :param description: IP restriction rule description.
    :type description: str
    :param headers: IP restriction rule headers.
     X-Forwarded-Host
     (https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Forwarded-Host#Examples).
     The matching logic is ..
    
    
     * If the property is null or empty (default), all hosts(or lack of) are allowed.
     * A value is compared using ordinal-ignore-case (excluding port number).
     * Subdomain wildcards are permitted but don't match the root domain. For example,
     *.contoso.com matches the subdomain foo.contoso.com
       but not the root domain contoso.com or multi-level foo.bar.contoso.com
     * Unicode host names are allowed but are converted to Punycode for matching.
    
     X-Forwarded-For
     (https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Forwarded-For#Examples).
     The matching logic is ..
    
    
     * If the property is null or empty (default), any forwarded-for chains (or lack of) are
     allowed.
     * If any address (excluding port number) in the chain (comma separated) matches the CIDR
     defined by the property.
    
     X-Azure-FDID and X-FD-HealthProbe.
     The matching logic is exact match.
    :type headers: dict[str, list[str]]
    """

    _attribute_map = {
        'ip_address': {'key': 'ipAddress', 'type': 'str'},
        'subnet_mask': {'key': 'subnetMask', 'type': 'str'},
        'vnet_subnet_resource_id': {'key': 'vnetSubnetResourceId', 'type': 'str'},
        'vnet_traffic_tag': {'key': 'vnetTrafficTag', 'type': 'int'},
        'subnet_traffic_tag': {'key': 'subnetTrafficTag', 'type': 'int'},
        'action': {'key': 'action', 'type': 'str'},
        'tag': {'key': 'tag', 'type': 'str'},
        'priority': {'key': 'priority', 'type': 'int'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'headers': {'key': 'headers', 'type': '{[str]}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IpSecurityRestriction, self).__init__(**kwargs)
        self.ip_address = kwargs.get('ip_address', None)
        self.subnet_mask = kwargs.get('subnet_mask', None)
        self.vnet_subnet_resource_id = kwargs.get('vnet_subnet_resource_id', None)
        self.vnet_traffic_tag = kwargs.get('vnet_traffic_tag', None)
        self.subnet_traffic_tag = kwargs.get('subnet_traffic_tag', None)
        self.action = kwargs.get('action', None)
        self.tag = kwargs.get('tag', None)
        self.priority = kwargs.get('priority', None)
        self.name = kwargs.get('name', None)
        self.description = kwargs.get('description', None)
        self.headers = kwargs.get('headers', None)


class JwtClaimChecks(msrest.serialization.Model):
    """The configuration settings of the checks that should be made while validating the JWT Claims.

    :param allowed_groups: The list of the allowed groups.
    :type allowed_groups: list[str]
    :param allowed_client_applications: The list of the allowed client applications.
    :type allowed_client_applications: list[str]
    """

    _attribute_map = {
        'allowed_groups': {'key': 'allowedGroups', 'type': '[str]'},
        'allowed_client_applications': {'key': 'allowedClientApplications', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(JwtClaimChecks, self).__init__(**kwargs)
        self.allowed_groups = kwargs.get('allowed_groups', None)
        self.allowed_client_applications = kwargs.get('allowed_client_applications', None)


class KeyInfo(msrest.serialization.Model):
    """Function key info.

    :param name: Key name.
    :type name: str
    :param value: Key value.
    :type value: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(KeyInfo, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.value = kwargs.get('value', None)


class KeyValuePairStringObject(msrest.serialization.Model):
    """KeyValuePairStringObject.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar key:
    :vartype key: str
    :ivar value: Any object.
    :vartype value: any
    """

    _validation = {
        'key': {'readonly': True},
        'value': {'readonly': True},
    }

    _attribute_map = {
        'key': {'key': 'key', 'type': 'str'},
        'value': {'key': 'value', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(KeyValuePairStringObject, self).__init__(**kwargs)
        self.key = None
        self.value = None


class KubeEnvironment(Resource):
    """A Kubernetes cluster specialized for web workloads by Azure App Service.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :param location: Required. Resource Location.
    :type location: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param extended_location: Extended Location.
    :type extended_location: ~azure.mgmt.web.v2021_01_01.models.ExtendedLocation
    :ivar provisioning_state: Provisioning state of the Kubernetes Environment. Possible values
     include: "Succeeded", "Failed", "Canceled", "Waiting", "InitializationInProgress",
     "InfrastructureSetupInProgress", "InfrastructureSetupComplete", "ScheduledForDelete",
     "UpgradeRequested", "UpgradeFailed".
    :vartype provisioning_state: str or
     ~azure.mgmt.web.v2021_01_01.models.KubeEnvironmentProvisioningState
    :ivar deployment_errors: Any errors that occurred during deployment or deployment validation.
    :vartype deployment_errors: str
    :param internal_load_balancer_enabled: Only visible within Vnet/Subnet.
    :type internal_load_balancer_enabled: bool
    :ivar default_domain: Default Domain Name for the cluster.
    :vartype default_domain: str
    :param static_ip: Static IP of the KubeEnvironment.
    :type static_ip: str
    :param arc_configuration: Cluster configuration which determines the ARC cluster
     components types. Eg: Choosing between BuildService kind,
     FrontEnd Service ArtifactsStorageType etc.
    :type arc_configuration: ~azure.mgmt.web.v2021_01_01.models.ArcConfiguration
    :param app_logs_configuration: Cluster configuration which enables the log daemon to export
     app logs to a destination. Currently only "log-analytics" is
     supported.
    :type app_logs_configuration: ~azure.mgmt.web.v2021_01_01.models.AppLogsConfiguration
    :param aks_resource_id:
    :type aks_resource_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'location': {'required': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'deployment_errors': {'readonly': True},
        'default_domain': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'extended_location': {'key': 'extendedLocation', 'type': 'ExtendedLocation'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'deployment_errors': {'key': 'properties.deploymentErrors', 'type': 'str'},
        'internal_load_balancer_enabled': {'key': 'properties.internalLoadBalancerEnabled', 'type': 'bool'},
        'default_domain': {'key': 'properties.defaultDomain', 'type': 'str'},
        'static_ip': {'key': 'properties.staticIp', 'type': 'str'},
        'arc_configuration': {'key': 'properties.arcConfiguration', 'type': 'ArcConfiguration'},
        'app_logs_configuration': {'key': 'properties.appLogsConfiguration', 'type': 'AppLogsConfiguration'},
        'aks_resource_id': {'key': 'properties.aksResourceID', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(KubeEnvironment, self).__init__(**kwargs)
        self.extended_location = kwargs.get('extended_location', None)
        self.provisioning_state = None
        self.deployment_errors = None
        self.internal_load_balancer_enabled = kwargs.get('internal_load_balancer_enabled', None)
        self.default_domain = None
        self.static_ip = kwargs.get('static_ip', None)
        self.arc_configuration = kwargs.get('arc_configuration', None)
        self.app_logs_configuration = kwargs.get('app_logs_configuration', None)
        self.aks_resource_id = kwargs.get('aks_resource_id', None)


class KubeEnvironmentCollection(msrest.serialization.Model):
    """Collection of Kubernetes Environments.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2021_01_01.models.KubeEnvironment]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[KubeEnvironment]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(KubeEnvironmentCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class KubeEnvironmentPatchResource(ProxyOnlyResource):
    """ARM resource for a KubeEnvironment when patching.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar provisioning_state: Provisioning state of the Kubernetes Environment. Possible values
     include: "Succeeded", "Failed", "Canceled", "Waiting", "InitializationInProgress",
     "InfrastructureSetupInProgress", "InfrastructureSetupComplete", "ScheduledForDelete",
     "UpgradeRequested", "UpgradeFailed".
    :vartype provisioning_state: str or
     ~azure.mgmt.web.v2021_01_01.models.KubeEnvironmentProvisioningState
    :ivar deployment_errors: Any errors that occurred during deployment or deployment validation.
    :vartype deployment_errors: str
    :param internal_load_balancer_enabled: Only visible within Vnet/Subnet.
    :type internal_load_balancer_enabled: bool
    :ivar default_domain: Default Domain Name for the cluster.
    :vartype default_domain: str
    :param static_ip: Static IP of the KubeEnvironment.
    :type static_ip: str
    :param arc_configuration: Cluster configuration which determines the ARC cluster
     components types. Eg: Choosing between BuildService kind,
     FrontEnd Service ArtifactsStorageType etc.
    :type arc_configuration: ~azure.mgmt.web.v2021_01_01.models.ArcConfiguration
    :param app_logs_configuration: Cluster configuration which enables the log daemon to export
     app logs to a destination. Currently only "log-analytics" is
     supported.
    :type app_logs_configuration: ~azure.mgmt.web.v2021_01_01.models.AppLogsConfiguration
    :param aks_resource_id:
    :type aks_resource_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'deployment_errors': {'readonly': True},
        'default_domain': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'deployment_errors': {'key': 'properties.deploymentErrors', 'type': 'str'},
        'internal_load_balancer_enabled': {'key': 'properties.internalLoadBalancerEnabled', 'type': 'bool'},
        'default_domain': {'key': 'properties.defaultDomain', 'type': 'str'},
        'static_ip': {'key': 'properties.staticIp', 'type': 'str'},
        'arc_configuration': {'key': 'properties.arcConfiguration', 'type': 'ArcConfiguration'},
        'app_logs_configuration': {'key': 'properties.appLogsConfiguration', 'type': 'AppLogsConfiguration'},
        'aks_resource_id': {'key': 'properties.aksResourceID', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(KubeEnvironmentPatchResource, self).__init__(**kwargs)
        self.provisioning_state = None
        self.deployment_errors = None
        self.internal_load_balancer_enabled = kwargs.get('internal_load_balancer_enabled', None)
        self.default_domain = None
        self.static_ip = kwargs.get('static_ip', None)
        self.arc_configuration = kwargs.get('arc_configuration', None)
        self.app_logs_configuration = kwargs.get('app_logs_configuration', None)
        self.aks_resource_id = kwargs.get('aks_resource_id', None)


class KubeEnvironmentProfile(msrest.serialization.Model):
    """Specification for a Kubernetes Environment to use for this resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource ID of the Kubernetes Environment.
    :type id: str
    :ivar name: Name of the Kubernetes Environment.
    :vartype name: str
    :ivar type: Resource type of the Kubernetes Environment.
    :vartype type: str
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(KubeEnvironmentProfile, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = None
        self.type = None


class LegacyMicrosoftAccount(msrest.serialization.Model):
    """The configuration settings of the legacy Microsoft Account provider.

    :param enabled: :code:`<code>false</code>` if the legacy Microsoft Account provider should not
     be enabled despite the set registration; otherwise, :code:`<code>true</code>`.
    :type enabled: bool
    :param registration: The configuration settings of the app registration for the legacy
     Microsoft Account provider.
    :type registration: ~azure.mgmt.web.v2021_01_01.models.ClientRegistration
    :param login: The configuration settings of the login flow.
    :type login: ~azure.mgmt.web.v2021_01_01.models.LoginScopes
    :param validation: The configuration settings of the legacy Microsoft Account provider token
     validation flow.
    :type validation: ~azure.mgmt.web.v2021_01_01.models.AllowedAudiencesValidation
    """

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'registration': {'key': 'registration', 'type': 'ClientRegistration'},
        'login': {'key': 'login', 'type': 'LoginScopes'},
        'validation': {'key': 'validation', 'type': 'AllowedAudiencesValidation'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LegacyMicrosoftAccount, self).__init__(**kwargs)
        self.enabled = kwargs.get('enabled', None)
        self.registration = kwargs.get('registration', None)
        self.login = kwargs.get('login', None)
        self.validation = kwargs.get('validation', None)


class LinuxJavaContainerSettings(msrest.serialization.Model):
    """Linux Java Container settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar java11_runtime: Java 11 version (runtime only).
    :vartype java11_runtime: str
    :ivar java8_runtime: Java 8 version (runtime only).
    :vartype java8_runtime: str
    :ivar is_preview: :code:`<code>true</code>` if the stack is in preview; otherwise,
     :code:`<code>false</code>`.
    :vartype is_preview: bool
    :ivar is_deprecated: :code:`<code>true</code>` if the stack is deprecated; otherwise,
     :code:`<code>false</code>`.
    :vartype is_deprecated: bool
    :ivar is_hidden: :code:`<code>true</code>` if the stack should be hidden; otherwise,
     :code:`<code>false</code>`.
    :vartype is_hidden: bool
    :ivar end_of_life_date: End-of-life date for the minor version.
    :vartype end_of_life_date: ~datetime.datetime
    :ivar is_auto_update: :code:`<code>true</code>` if the stack version is auto-updated;
     otherwise, :code:`<code>false</code>`.
    :vartype is_auto_update: bool
    :ivar is_early_access: :code:`<code>true</code>` if the minor version is early-access;
     otherwise, :code:`<code>false</code>`.
    :vartype is_early_access: bool
    """

    _validation = {
        'java11_runtime': {'readonly': True},
        'java8_runtime': {'readonly': True},
        'is_preview': {'readonly': True},
        'is_deprecated': {'readonly': True},
        'is_hidden': {'readonly': True},
        'end_of_life_date': {'readonly': True},
        'is_auto_update': {'readonly': True},
        'is_early_access': {'readonly': True},
    }

    _attribute_map = {
        'java11_runtime': {'key': 'java11Runtime', 'type': 'str'},
        'java8_runtime': {'key': 'java8Runtime', 'type': 'str'},
        'is_preview': {'key': 'isPreview', 'type': 'bool'},
        'is_deprecated': {'key': 'isDeprecated', 'type': 'bool'},
        'is_hidden': {'key': 'isHidden', 'type': 'bool'},
        'end_of_life_date': {'key': 'endOfLifeDate', 'type': 'iso-8601'},
        'is_auto_update': {'key': 'isAutoUpdate', 'type': 'bool'},
        'is_early_access': {'key': 'isEarlyAccess', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LinuxJavaContainerSettings, self).__init__(**kwargs)
        self.java11_runtime = None
        self.java8_runtime = None
        self.is_preview = None
        self.is_deprecated = None
        self.is_hidden = None
        self.end_of_life_date = None
        self.is_auto_update = None
        self.is_early_access = None


class LocalizableString(msrest.serialization.Model):
    """Localizable string object containing the name and a localized value.

    :param value: Non-localized name.
    :type value: str
    :param localized_value: Localized name.
    :type localized_value: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LocalizableString, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.localized_value = kwargs.get('localized_value', None)


class LogAnalyticsConfiguration(msrest.serialization.Model):
    """LogAnalyticsConfiguration.

    :param customer_id:
    :type customer_id: str
    :param shared_key:
    :type shared_key: str
    """

    _attribute_map = {
        'customer_id': {'key': 'customerId', 'type': 'str'},
        'shared_key': {'key': 'sharedKey', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LogAnalyticsConfiguration, self).__init__(**kwargs)
        self.customer_id = kwargs.get('customer_id', None)
        self.shared_key = kwargs.get('shared_key', None)


class Login(msrest.serialization.Model):
    """The configuration settings of the login flow of users using App Service Authentication/Authorization.

    :param routes: The routes that specify the endpoints used for login and logout requests.
    :type routes: ~azure.mgmt.web.v2021_01_01.models.LoginRoutes
    :param token_store: The configuration settings of the token store.
    :type token_store: ~azure.mgmt.web.v2021_01_01.models.TokenStore
    :param preserve_url_fragments_for_logins: :code:`<code>true</code>` if the fragments from the
     request are preserved after the login request is made; otherwise, :code:`<code>false</code>`.
    :type preserve_url_fragments_for_logins: bool
    :param allowed_external_redirect_urls: External URLs that can be redirected to as part of
     logging in or logging out of the app. Note that the query string part of the URL is ignored.
     This is an advanced setting typically only needed by Windows Store application backends.
     Note that URLs within the current domain are always implicitly allowed.
    :type allowed_external_redirect_urls: list[str]
    :param cookie_expiration: The configuration settings of the session cookie's expiration.
    :type cookie_expiration: ~azure.mgmt.web.v2021_01_01.models.CookieExpiration
    :param nonce: The configuration settings of the nonce used in the login flow.
    :type nonce: ~azure.mgmt.web.v2021_01_01.models.Nonce
    """

    _attribute_map = {
        'routes': {'key': 'routes', 'type': 'LoginRoutes'},
        'token_store': {'key': 'tokenStore', 'type': 'TokenStore'},
        'preserve_url_fragments_for_logins': {'key': 'preserveUrlFragmentsForLogins', 'type': 'bool'},
        'allowed_external_redirect_urls': {'key': 'allowedExternalRedirectUrls', 'type': '[str]'},
        'cookie_expiration': {'key': 'cookieExpiration', 'type': 'CookieExpiration'},
        'nonce': {'key': 'nonce', 'type': 'Nonce'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Login, self).__init__(**kwargs)
        self.routes = kwargs.get('routes', None)
        self.token_store = kwargs.get('token_store', None)
        self.preserve_url_fragments_for_logins = kwargs.get('preserve_url_fragments_for_logins', None)
        self.allowed_external_redirect_urls = kwargs.get('allowed_external_redirect_urls', None)
        self.cookie_expiration = kwargs.get('cookie_expiration', None)
        self.nonce = kwargs.get('nonce', None)


class LoginRoutes(msrest.serialization.Model):
    """The routes that specify the endpoints used for login and logout requests.

    :param logout_endpoint: The endpoint at which a logout request should be made.
    :type logout_endpoint: str
    """

    _attribute_map = {
        'logout_endpoint': {'key': 'logoutEndpoint', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LoginRoutes, self).__init__(**kwargs)
        self.logout_endpoint = kwargs.get('logout_endpoint', None)


class LoginScopes(msrest.serialization.Model):
    """The configuration settings of the login flow, including the scopes that should be requested.

    :param scopes: A list of the scopes that should be requested while authenticating.
    :type scopes: list[str]
    """

    _attribute_map = {
        'scopes': {'key': 'scopes', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LoginScopes, self).__init__(**kwargs)
        self.scopes = kwargs.get('scopes', None)


class LogSpecification(msrest.serialization.Model):
    """Log Definition of a single resource metric.

    :param name:
    :type name: str
    :param display_name:
    :type display_name: str
    :param blob_duration:
    :type blob_duration: str
    :param log_filter_pattern:
    :type log_filter_pattern: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'blob_duration': {'key': 'blobDuration', 'type': 'str'},
        'log_filter_pattern': {'key': 'logFilterPattern', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LogSpecification, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display_name = kwargs.get('display_name', None)
        self.blob_duration = kwargs.get('blob_duration', None)
        self.log_filter_pattern = kwargs.get('log_filter_pattern', None)


class ManagedServiceIdentity(msrest.serialization.Model):
    """Managed service identity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param type: Type of managed service identity. Possible values include: "SystemAssigned",
     "UserAssigned", "SystemAssigned, UserAssigned", "None".
    :type type: str or ~azure.mgmt.web.v2021_01_01.models.ManagedServiceIdentityType
    :ivar tenant_id: Tenant of managed service identity.
    :vartype tenant_id: str
    :ivar principal_id: Principal Id of managed service identity.
    :vartype principal_id: str
    :param user_assigned_identities: The list of user assigned identities associated with the
     resource. The user identity dictionary key references will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
    :type user_assigned_identities: dict[str,
     ~azure.mgmt.web.v2021_01_01.models.Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties]
    """

    _validation = {
        'tenant_id': {'readonly': True},
        'principal_id': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'user_assigned_identities': {'key': 'userAssignedIdentities', 'type': '{Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedServiceIdentity, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)
        self.tenant_id = None
        self.principal_id = None
        self.user_assigned_identities = kwargs.get('user_assigned_identities', None)


class MetricAvailability(msrest.serialization.Model):
    """Retention policy of a resource metric.

    :param time_grain:
    :type time_grain: str
    :param blob_duration:
    :type blob_duration: str
    """

    _attribute_map = {
        'time_grain': {'key': 'timeGrain', 'type': 'str'},
        'blob_duration': {'key': 'blobDuration', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MetricAvailability, self).__init__(**kwargs)
        self.time_grain = kwargs.get('time_grain', None)
        self.blob_duration = kwargs.get('blob_duration', None)


class MetricSpecification(msrest.serialization.Model):
    """Definition of a single resource metric.

    :param name:
    :type name: str
    :param display_name:
    :type display_name: str
    :param display_description:
    :type display_description: str
    :param unit:
    :type unit: str
    :param aggregation_type:
    :type aggregation_type: str
    :param supports_instance_level_aggregation:
    :type supports_instance_level_aggregation: bool
    :param enable_regional_mdm_account:
    :type enable_regional_mdm_account: bool
    :param source_mdm_account:
    :type source_mdm_account: str
    :param source_mdm_namespace:
    :type source_mdm_namespace: str
    :param metric_filter_pattern:
    :type metric_filter_pattern: str
    :param fill_gap_with_zero:
    :type fill_gap_with_zero: bool
    :param is_internal:
    :type is_internal: bool
    :param dimensions:
    :type dimensions: list[~azure.mgmt.web.v2021_01_01.models.Dimension]
    :param category:
    :type category: str
    :param availabilities:
    :type availabilities: list[~azure.mgmt.web.v2021_01_01.models.MetricAvailability]
    :param supported_time_grain_types:
    :type supported_time_grain_types: list[str]
    :param supported_aggregation_types:
    :type supported_aggregation_types: list[str]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'display_description': {'key': 'displayDescription', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'aggregation_type': {'key': 'aggregationType', 'type': 'str'},
        'supports_instance_level_aggregation': {'key': 'supportsInstanceLevelAggregation', 'type': 'bool'},
        'enable_regional_mdm_account': {'key': 'enableRegionalMdmAccount', 'type': 'bool'},
        'source_mdm_account': {'key': 'sourceMdmAccount', 'type': 'str'},
        'source_mdm_namespace': {'key': 'sourceMdmNamespace', 'type': 'str'},
        'metric_filter_pattern': {'key': 'metricFilterPattern', 'type': 'str'},
        'fill_gap_with_zero': {'key': 'fillGapWithZero', 'type': 'bool'},
        'is_internal': {'key': 'isInternal', 'type': 'bool'},
        'dimensions': {'key': 'dimensions', 'type': '[Dimension]'},
        'category': {'key': 'category', 'type': 'str'},
        'availabilities': {'key': 'availabilities', 'type': '[MetricAvailability]'},
        'supported_time_grain_types': {'key': 'supportedTimeGrainTypes', 'type': '[str]'},
        'supported_aggregation_types': {'key': 'supportedAggregationTypes', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MetricSpecification, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display_name = kwargs.get('display_name', None)
        self.display_description = kwargs.get('display_description', None)
        self.unit = kwargs.get('unit', None)
        self.aggregation_type = kwargs.get('aggregation_type', None)
        self.supports_instance_level_aggregation = kwargs.get('supports_instance_level_aggregation', None)
        self.enable_regional_mdm_account = kwargs.get('enable_regional_mdm_account', None)
        self.source_mdm_account = kwargs.get('source_mdm_account', None)
        self.source_mdm_namespace = kwargs.get('source_mdm_namespace', None)
        self.metric_filter_pattern = kwargs.get('metric_filter_pattern', None)
        self.fill_gap_with_zero = kwargs.get('fill_gap_with_zero', None)
        self.is_internal = kwargs.get('is_internal', None)
        self.dimensions = kwargs.get('dimensions', None)
        self.category = kwargs.get('category', None)
        self.availabilities = kwargs.get('availabilities', None)
        self.supported_time_grain_types = kwargs.get('supported_time_grain_types', None)
        self.supported_aggregation_types = kwargs.get('supported_aggregation_types', None)


class MigrateMySqlRequest(ProxyOnlyResource):
    """MySQL migration request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param connection_string: Connection string to the remote MySQL database.
    :type connection_string: str
    :param migration_type: The type of migration operation to be done. Possible values include:
     "LocalToRemote", "RemoteToLocal".
    :type migration_type: str or ~azure.mgmt.web.v2021_01_01.models.MySqlMigrationType
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'connection_string': {'key': 'properties.connectionString', 'type': 'str'},
        'migration_type': {'key': 'properties.migrationType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MigrateMySqlRequest, self).__init__(**kwargs)
        self.connection_string = kwargs.get('connection_string', None)
        self.migration_type = kwargs.get('migration_type', None)


class MigrateMySqlStatus(ProxyOnlyResource):
    """MySQL migration status.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar migration_operation_status: Status of the migration task. Possible values include:
     "InProgress", "Failed", "Succeeded", "TimedOut", "Created".
    :vartype migration_operation_status: str or ~azure.mgmt.web.v2021_01_01.models.OperationStatus
    :ivar operation_id: Operation ID for the migration task.
    :vartype operation_id: str
    :ivar local_my_sql_enabled: True if the web app has in app MySql enabled.
    :vartype local_my_sql_enabled: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'migration_operation_status': {'readonly': True},
        'operation_id': {'readonly': True},
        'local_my_sql_enabled': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'migration_operation_status': {'key': 'properties.migrationOperationStatus', 'type': 'str'},
        'operation_id': {'key': 'properties.operationId', 'type': 'str'},
        'local_my_sql_enabled': {'key': 'properties.localMySqlEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MigrateMySqlStatus, self).__init__(**kwargs)
        self.migration_operation_status = None
        self.operation_id = None
        self.local_my_sql_enabled = None


class MSDeploy(ProxyOnlyResource):
    """MSDeploy ARM PUT information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param package_uri: Package URI.
    :type package_uri: str
    :param connection_string: SQL Connection String.
    :type connection_string: str
    :param db_type: Database Type.
    :type db_type: str
    :param set_parameters_xml_file_uri: URI of MSDeploy Parameters file. Must not be set if
     SetParameters is used.
    :type set_parameters_xml_file_uri: str
    :param set_parameters: MSDeploy Parameters. Must not be set if SetParametersXmlFileUri is used.
    :type set_parameters: dict[str, str]
    :param skip_app_data: Controls whether the MSDeploy operation skips the App_Data directory.
     If set to :code:`<code>true</code>`, the existing App_Data directory on the destination
     will not be deleted, and any App_Data directory in the source will be ignored.
     Setting is :code:`<code>false</code>` by default.
    :type skip_app_data: bool
    :param app_offline: Sets the AppOffline rule while the MSDeploy operation executes.
     Setting is :code:`<code>false</code>` by default.
    :type app_offline: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'package_uri': {'key': 'properties.packageUri', 'type': 'str'},
        'connection_string': {'key': 'properties.connectionString', 'type': 'str'},
        'db_type': {'key': 'properties.dbType', 'type': 'str'},
        'set_parameters_xml_file_uri': {'key': 'properties.setParametersXmlFileUri', 'type': 'str'},
        'set_parameters': {'key': 'properties.setParameters', 'type': '{str}'},
        'skip_app_data': {'key': 'properties.skipAppData', 'type': 'bool'},
        'app_offline': {'key': 'properties.appOffline', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MSDeploy, self).__init__(**kwargs)
        self.package_uri = kwargs.get('package_uri', None)
        self.connection_string = kwargs.get('connection_string', None)
        self.db_type = kwargs.get('db_type', None)
        self.set_parameters_xml_file_uri = kwargs.get('set_parameters_xml_file_uri', None)
        self.set_parameters = kwargs.get('set_parameters', None)
        self.skip_app_data = kwargs.get('skip_app_data', None)
        self.app_offline = kwargs.get('app_offline', None)


class MSDeployLog(ProxyOnlyResource):
    """MSDeploy log.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar entries: List of log entry messages.
    :vartype entries: list[~azure.mgmt.web.v2021_01_01.models.MSDeployLogEntry]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'entries': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'entries': {'key': 'properties.entries', 'type': '[MSDeployLogEntry]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MSDeployLog, self).__init__(**kwargs)
        self.entries = None


class MSDeployLogEntry(msrest.serialization.Model):
    """MSDeploy log entry.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar time: Timestamp of log entry.
    :vartype time: ~datetime.datetime
    :ivar type: Log entry type. Possible values include: "Message", "Warning", "Error".
    :vartype type: str or ~azure.mgmt.web.v2021_01_01.models.MSDeployLogEntryType
    :ivar message: Log entry message.
    :vartype message: str
    """

    _validation = {
        'time': {'readonly': True},
        'type': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'time': {'key': 'time', 'type': 'iso-8601'},
        'type': {'key': 'type', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MSDeployLogEntry, self).__init__(**kwargs)
        self.time = None
        self.type = None
        self.message = None


class MSDeployStatus(ProxyOnlyResource):
    """MSDeploy ARM response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar deployer: Username of deployer.
    :vartype deployer: str
    :ivar provisioning_state: Provisioning state. Possible values include: "accepted", "running",
     "succeeded", "failed", "canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.web.v2021_01_01.models.MSDeployProvisioningState
    :ivar start_time: Start time of deploy operation.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time of deploy operation.
    :vartype end_time: ~datetime.datetime
    :ivar complete: Whether the deployment operation has completed.
    :vartype complete: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'deployer': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
        'complete': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'deployer': {'key': 'properties.deployer', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'properties.endTime', 'type': 'iso-8601'},
        'complete': {'key': 'properties.complete', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MSDeployStatus, self).__init__(**kwargs)
        self.deployer = None
        self.provisioning_state = None
        self.start_time = None
        self.end_time = None
        self.complete = None


class NameIdentifier(msrest.serialization.Model):
    """Identifies an object.

    :param name: Name of the object.
    :type name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NameIdentifier, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)


class NameIdentifierCollection(msrest.serialization.Model):
    """Collection of domain name identifiers.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2021_01_01.models.NameIdentifier]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[NameIdentifier]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NameIdentifierCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class NameValuePair(msrest.serialization.Model):
    """Name value pair.

    :param name: Pair name.
    :type name: str
    :param value: Pair value.
    :type value: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NameValuePair, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.value = kwargs.get('value', None)


class NetworkFeatures(ProxyOnlyResource):
    """Full view of network features for an app (presently VNET integration and Hybrid Connections).

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar virtual_network_name: The Virtual Network name.
    :vartype virtual_network_name: str
    :ivar virtual_network_connection: The Virtual Network summary view.
    :vartype virtual_network_connection: ~azure.mgmt.web.v2021_01_01.models.VnetInfo
    :ivar hybrid_connections: The Hybrid Connections summary view.
    :vartype hybrid_connections:
     list[~azure.mgmt.web.v2021_01_01.models.RelayServiceConnectionEntity]
    :ivar hybrid_connections_v2: The Hybrid Connection V2 (Service Bus) view.
    :vartype hybrid_connections_v2: list[~azure.mgmt.web.v2021_01_01.models.HybridConnection]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'virtual_network_name': {'readonly': True},
        'virtual_network_connection': {'readonly': True},
        'hybrid_connections': {'readonly': True},
        'hybrid_connections_v2': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'virtual_network_name': {'key': 'properties.virtualNetworkName', 'type': 'str'},
        'virtual_network_connection': {'key': 'properties.virtualNetworkConnection', 'type': 'VnetInfo'},
        'hybrid_connections': {'key': 'properties.hybridConnections', 'type': '[RelayServiceConnectionEntity]'},
        'hybrid_connections_v2': {'key': 'properties.hybridConnectionsV2', 'type': '[HybridConnection]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetworkFeatures, self).__init__(**kwargs)
        self.virtual_network_name = None
        self.virtual_network_connection = None
        self.hybrid_connections = None
        self.hybrid_connections_v2 = None


class NetworkTrace(msrest.serialization.Model):
    """Network trace.

    :param path: Local file path for the captured network trace file.
    :type path: str
    :param status: Current status of the network trace operation, same as Operation.Status
     (InProgress/Succeeded/Failed).
    :type status: str
    :param message: Detailed message of a network trace operation, e.g. error message in case of
     failure.
    :type message: str
    """

    _attribute_map = {
        'path': {'key': 'path', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetworkTrace, self).__init__(**kwargs)
        self.path = kwargs.get('path', None)
        self.status = kwargs.get('status', None)
        self.message = kwargs.get('message', None)


class Nonce(msrest.serialization.Model):
    """The configuration settings of the nonce used in the login flow.

    :param validate_nonce: :code:`<code>false</code>` if the nonce should not be validated while
     completing the login flow; otherwise, :code:`<code>true</code>`.
    :type validate_nonce: bool
    :param nonce_expiration_interval: The time after the request is made when the nonce should
     expire.
    :type nonce_expiration_interval: str
    """

    _attribute_map = {
        'validate_nonce': {'key': 'validateNonce', 'type': 'bool'},
        'nonce_expiration_interval': {'key': 'nonceExpirationInterval', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Nonce, self).__init__(**kwargs)
        self.validate_nonce = kwargs.get('validate_nonce', None)
        self.nonce_expiration_interval = kwargs.get('nonce_expiration_interval', None)


class OpenIdConnectClientCredential(msrest.serialization.Model):
    """The authentication client credentials of the custom Open ID Connect provider.

    :param method: The method that should be used to authenticate the user. The only acceptable
     values to pass in are None and "ClientSecretPost". The default value is None.
    :type method: str
    :param client_secret_setting_name: The app setting that contains the client secret for the
     custom Open ID Connect provider.
    :type client_secret_setting_name: str
    """

    _attribute_map = {
        'method': {'key': 'method', 'type': 'str'},
        'client_secret_setting_name': {'key': 'clientSecretSettingName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OpenIdConnectClientCredential, self).__init__(**kwargs)
        self.method = kwargs.get('method', None)
        self.client_secret_setting_name = kwargs.get('client_secret_setting_name', None)


class OpenIdConnectConfig(msrest.serialization.Model):
    """The configuration settings of the endpoints used for the custom Open ID Connect provider.

    :param authorization_endpoint: The endpoint to be used to make an authorization request.
    :type authorization_endpoint: str
    :param token_endpoint: The endpoint to be used to request a token.
    :type token_endpoint: str
    :param issuer: The endpoint that issues the token.
    :type issuer: str
    :param certification_uri: The endpoint that provides the keys necessary to validate the token.
    :type certification_uri: str
    :param well_known_open_id_configuration: The endpoint that contains all the configuration
     endpoints for the provider.
    :type well_known_open_id_configuration: str
    """

    _attribute_map = {
        'authorization_endpoint': {'key': 'authorizationEndpoint', 'type': 'str'},
        'token_endpoint': {'key': 'tokenEndpoint', 'type': 'str'},
        'issuer': {'key': 'issuer', 'type': 'str'},
        'certification_uri': {'key': 'certificationUri', 'type': 'str'},
        'well_known_open_id_configuration': {'key': 'wellKnownOpenIdConfiguration', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OpenIdConnectConfig, self).__init__(**kwargs)
        self.authorization_endpoint = kwargs.get('authorization_endpoint', None)
        self.token_endpoint = kwargs.get('token_endpoint', None)
        self.issuer = kwargs.get('issuer', None)
        self.certification_uri = kwargs.get('certification_uri', None)
        self.well_known_open_id_configuration = kwargs.get('well_known_open_id_configuration', None)


class OpenIdConnectLogin(msrest.serialization.Model):
    """The configuration settings of the login flow of the custom Open ID Connect provider.

    :param name_claim_type: The name of the claim that contains the users name.
    :type name_claim_type: str
    :param scopes: A list of the scopes that should be requested while authenticating.
    :type scopes: list[str]
    """

    _attribute_map = {
        'name_claim_type': {'key': 'nameClaimType', 'type': 'str'},
        'scopes': {'key': 'scopes', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OpenIdConnectLogin, self).__init__(**kwargs)
        self.name_claim_type = kwargs.get('name_claim_type', None)
        self.scopes = kwargs.get('scopes', None)


class OpenIdConnectRegistration(msrest.serialization.Model):
    """The configuration settings of the app registration for the custom Open ID Connect provider.

    :param client_id: The client id of the custom Open ID Connect provider.
    :type client_id: str
    :param client_credential: The authentication credentials of the custom Open ID Connect
     provider.
    :type client_credential: ~azure.mgmt.web.v2021_01_01.models.OpenIdConnectClientCredential
    :param open_id_connect_configuration: The configuration settings of the endpoints used for the
     custom Open ID Connect provider.
    :type open_id_connect_configuration: ~azure.mgmt.web.v2021_01_01.models.OpenIdConnectConfig
    """

    _attribute_map = {
        'client_id': {'key': 'clientId', 'type': 'str'},
        'client_credential': {'key': 'clientCredential', 'type': 'OpenIdConnectClientCredential'},
        'open_id_connect_configuration': {'key': 'openIdConnectConfiguration', 'type': 'OpenIdConnectConfig'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OpenIdConnectRegistration, self).__init__(**kwargs)
        self.client_id = kwargs.get('client_id', None)
        self.client_credential = kwargs.get('client_credential', None)
        self.open_id_connect_configuration = kwargs.get('open_id_connect_configuration', None)


class Operation(msrest.serialization.Model):
    """An operation on a resource.

    :param id: Operation ID.
    :type id: str
    :param name: Operation name.
    :type name: str
    :param status: The current status of the operation. Possible values include: "InProgress",
     "Failed", "Succeeded", "TimedOut", "Created".
    :type status: str or ~azure.mgmt.web.v2021_01_01.models.OperationStatus
    :param errors: Any errors associate with the operation.
    :type errors: list[~azure.mgmt.web.v2021_01_01.models.ErrorEntity]
    :param created_time: Time when operation has started.
    :type created_time: ~datetime.datetime
    :param modified_time: Time when operation has been updated.
    :type modified_time: ~datetime.datetime
    :param expiration_time: Time when operation will expire.
    :type expiration_time: ~datetime.datetime
    :param geo_master_operation_id: Applicable only for stamp operation ids.
    :type geo_master_operation_id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[ErrorEntity]'},
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'modified_time': {'key': 'modifiedTime', 'type': 'iso-8601'},
        'expiration_time': {'key': 'expirationTime', 'type': 'iso-8601'},
        'geo_master_operation_id': {'key': 'geoMasterOperationId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = kwargs.get('name', None)
        self.status = kwargs.get('status', None)
        self.errors = kwargs.get('errors', None)
        self.created_time = kwargs.get('created_time', None)
        self.modified_time = kwargs.get('modified_time', None)
        self.expiration_time = kwargs.get('expiration_time', None)
        self.geo_master_operation_id = kwargs.get('geo_master_operation_id', None)


class OutboundEnvironmentEndpoint(msrest.serialization.Model):
    """Endpoints accessed for a common purpose that the App Service Environment requires outbound network access to.

    :param category: The type of service accessed by the App Service Environment, e.g., Azure
     Storage, Azure SQL Database, and Azure Active Directory.
    :type category: str
    :param endpoints: The endpoints that the App Service Environment reaches the service at.
    :type endpoints: list[~azure.mgmt.web.v2021_01_01.models.EndpointDependency]
    """

    _attribute_map = {
        'category': {'key': 'category', 'type': 'str'},
        'endpoints': {'key': 'endpoints', 'type': '[EndpointDependency]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OutboundEnvironmentEndpoint, self).__init__(**kwargs)
        self.category = kwargs.get('category', None)
        self.endpoints = kwargs.get('endpoints', None)


class OutboundEnvironmentEndpointCollection(msrest.serialization.Model):
    """Collection of Outbound Environment Endpoints.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2021_01_01.models.OutboundEnvironmentEndpoint]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[OutboundEnvironmentEndpoint]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OutboundEnvironmentEndpointCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class PerfMonCounterCollection(msrest.serialization.Model):
    """Collection of performance monitor counters.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2021_01_01.models.PerfMonResponse]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PerfMonResponse]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PerfMonCounterCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class PerfMonResponse(msrest.serialization.Model):
    """Performance monitor API response.

    :param code: The response code.
    :type code: str
    :param message: The message.
    :type message: str
    :param data: The performance monitor counters.
    :type data: ~azure.mgmt.web.v2021_01_01.models.PerfMonSet
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'data': {'key': 'data', 'type': 'PerfMonSet'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PerfMonResponse, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.data = kwargs.get('data', None)


class PerfMonSample(msrest.serialization.Model):
    """Performance monitor sample in a set.

    :param time: Point in time for which counter was measured.
    :type time: ~datetime.datetime
    :param instance_name: Name of the server on which the measurement is made.
    :type instance_name: str
    :param value: Value of counter at a certain time.
    :type value: float
    """

    _attribute_map = {
        'time': {'key': 'time', 'type': 'iso-8601'},
        'instance_name': {'key': 'instanceName', 'type': 'str'},
        'value': {'key': 'value', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PerfMonSample, self).__init__(**kwargs)
        self.time = kwargs.get('time', None)
        self.instance_name = kwargs.get('instance_name', None)
        self.value = kwargs.get('value', None)


class PerfMonSet(msrest.serialization.Model):
    """Metric information.

    :param name: Unique key name of the counter.
    :type name: str
    :param start_time: Start time of the period.
    :type start_time: ~datetime.datetime
    :param end_time: End time of the period.
    :type end_time: ~datetime.datetime
    :param time_grain: Presented time grain.
    :type time_grain: str
    :param values: Collection of workers that are active during this time.
    :type values: list[~azure.mgmt.web.v2021_01_01.models.PerfMonSample]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'time_grain': {'key': 'timeGrain', 'type': 'str'},
        'values': {'key': 'values', 'type': '[PerfMonSample]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PerfMonSet, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.start_time = kwargs.get('start_time', None)
        self.end_time = kwargs.get('end_time', None)
        self.time_grain = kwargs.get('time_grain', None)
        self.values = kwargs.get('values', None)


class PremierAddOn(Resource):
    """Premier add-on.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :param location: Required. Resource Location.
    :type location: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: Premier add on SKU.
    :type sku: str
    :param product: Premier add on Product.
    :type product: str
    :param vendor: Premier add on Vendor.
    :type vendor: str
    :param marketplace_publisher: Premier add on Marketplace publisher.
    :type marketplace_publisher: str
    :param marketplace_offer: Premier add on Marketplace offer.
    :type marketplace_offer: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'location': {'required': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'properties.sku', 'type': 'str'},
        'product': {'key': 'properties.product', 'type': 'str'},
        'vendor': {'key': 'properties.vendor', 'type': 'str'},
        'marketplace_publisher': {'key': 'properties.marketplacePublisher', 'type': 'str'},
        'marketplace_offer': {'key': 'properties.marketplaceOffer', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PremierAddOn, self).__init__(**kwargs)
        self.sku = kwargs.get('sku', None)
        self.product = kwargs.get('product', None)
        self.vendor = kwargs.get('vendor', None)
        self.marketplace_publisher = kwargs.get('marketplace_publisher', None)
        self.marketplace_offer = kwargs.get('marketplace_offer', None)


class PremierAddOnOffer(ProxyOnlyResource):
    """Premier add-on offer.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param sku: Premier add on SKU.
    :type sku: str
    :param product: Premier add on offer Product.
    :type product: str
    :param vendor: Premier add on offer Vendor.
    :type vendor: str
    :param promo_code_required: :code:`<code>true</code>` if promotion code is required; otherwise,
     :code:`<code>false</code>`.
    :type promo_code_required: bool
    :param quota: Premier add on offer Quota.
    :type quota: int
    :param web_hosting_plan_restrictions: App Service plans this offer is restricted to. Possible
     values include: "None", "Free", "Shared", "Basic", "Standard", "Premium".
    :type web_hosting_plan_restrictions: str or
     ~azure.mgmt.web.v2021_01_01.models.AppServicePlanRestrictions
    :param privacy_policy_url: Privacy policy URL.
    :type privacy_policy_url: str
    :param legal_terms_url: Legal terms URL.
    :type legal_terms_url: str
    :param marketplace_publisher: Marketplace publisher.
    :type marketplace_publisher: str
    :param marketplace_offer: Marketplace offer.
    :type marketplace_offer: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'sku': {'key': 'properties.sku', 'type': 'str'},
        'product': {'key': 'properties.product', 'type': 'str'},
        'vendor': {'key': 'properties.vendor', 'type': 'str'},
        'promo_code_required': {'key': 'properties.promoCodeRequired', 'type': 'bool'},
        'quota': {'key': 'properties.quota', 'type': 'int'},
        'web_hosting_plan_restrictions': {'key': 'properties.webHostingPlanRestrictions', 'type': 'str'},
        'privacy_policy_url': {'key': 'properties.privacyPolicyUrl', 'type': 'str'},
        'legal_terms_url': {'key': 'properties.legalTermsUrl', 'type': 'str'},
        'marketplace_publisher': {'key': 'properties.marketplacePublisher', 'type': 'str'},
        'marketplace_offer': {'key': 'properties.marketplaceOffer', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PremierAddOnOffer, self).__init__(**kwargs)
        self.sku = kwargs.get('sku', None)
        self.product = kwargs.get('product', None)
        self.vendor = kwargs.get('vendor', None)
        self.promo_code_required = kwargs.get('promo_code_required', None)
        self.quota = kwargs.get('quota', None)
        self.web_hosting_plan_restrictions = kwargs.get('web_hosting_plan_restrictions', None)
        self.privacy_policy_url = kwargs.get('privacy_policy_url', None)
        self.legal_terms_url = kwargs.get('legal_terms_url', None)
        self.marketplace_publisher = kwargs.get('marketplace_publisher', None)
        self.marketplace_offer = kwargs.get('marketplace_offer', None)


class PremierAddOnOfferCollection(msrest.serialization.Model):
    """Collection of premier add-on offers.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2021_01_01.models.PremierAddOnOffer]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PremierAddOnOffer]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PremierAddOnOfferCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class PremierAddOnPatchResource(ProxyOnlyResource):
    """ARM resource for a PremierAddOn.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param sku: Premier add on SKU.
    :type sku: str
    :param product: Premier add on Product.
    :type product: str
    :param vendor: Premier add on Vendor.
    :type vendor: str
    :param marketplace_publisher: Premier add on Marketplace publisher.
    :type marketplace_publisher: str
    :param marketplace_offer: Premier add on Marketplace offer.
    :type marketplace_offer: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'sku': {'key': 'properties.sku', 'type': 'str'},
        'product': {'key': 'properties.product', 'type': 'str'},
        'vendor': {'key': 'properties.vendor', 'type': 'str'},
        'marketplace_publisher': {'key': 'properties.marketplacePublisher', 'type': 'str'},
        'marketplace_offer': {'key': 'properties.marketplaceOffer', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PremierAddOnPatchResource, self).__init__(**kwargs)
        self.sku = kwargs.get('sku', None)
        self.product = kwargs.get('product', None)
        self.vendor = kwargs.get('vendor', None)
        self.marketplace_publisher = kwargs.get('marketplace_publisher', None)
        self.marketplace_offer = kwargs.get('marketplace_offer', None)


class PrivateAccess(ProxyOnlyResource):
    """Description of the parameters of Private Access for a Web Site.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param enabled: Whether private access is enabled or not.
    :type enabled: bool
    :param virtual_networks: The Virtual Networks (and subnets) allowed to access the site
     privately.
    :type virtual_networks: list[~azure.mgmt.web.v2021_01_01.models.PrivateAccessVirtualNetwork]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'virtual_networks': {'key': 'properties.virtualNetworks', 'type': '[PrivateAccessVirtualNetwork]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateAccess, self).__init__(**kwargs)
        self.enabled = kwargs.get('enabled', None)
        self.virtual_networks = kwargs.get('virtual_networks', None)


class PrivateAccessSubnet(msrest.serialization.Model):
    """Description of a Virtual Network subnet that is useable for private site access.

    :param name: The name of the subnet.
    :type name: str
    :param key: The key (ID) of the subnet.
    :type key: int
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'key': {'key': 'key', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateAccessSubnet, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.key = kwargs.get('key', None)


class PrivateAccessVirtualNetwork(msrest.serialization.Model):
    """Description of a Virtual Network that is useable for private site access.

    :param name: The name of the Virtual Network.
    :type name: str
    :param key: The key (ID) of the Virtual Network.
    :type key: int
    :param resource_id: The ARM uri of the Virtual Network.
    :type resource_id: str
    :param subnets: A List of subnets that access is allowed to on this Virtual Network. An empty
     array (but not null) is interpreted to mean that all subnets are allowed within this Virtual
     Network.
    :type subnets: list[~azure.mgmt.web.v2021_01_01.models.PrivateAccessSubnet]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'key': {'key': 'key', 'type': 'int'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'subnets': {'key': 'subnets', 'type': '[PrivateAccessSubnet]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateAccessVirtualNetwork, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.key = kwargs.get('key', None)
        self.resource_id = kwargs.get('resource_id', None)
        self.subnets = kwargs.get('subnets', None)


class PrivateEndpointConnectionCollection(msrest.serialization.Model):
    """PrivateEndpointConnectionCollection.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value:
     list[~azure.mgmt.web.v2021_01_01.models.RemotePrivateEndpointConnectionARMResource]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RemotePrivateEndpointConnectionARMResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateEndpointConnectionCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class PrivateLinkConnectionApprovalRequestResource(ProxyOnlyResource):
    """Private Endpoint Connection Approval ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param private_link_service_connection_state: The state of a private link connection.
    :type private_link_service_connection_state:
     ~azure.mgmt.web.v2021_01_01.models.PrivateLinkConnectionState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'private_link_service_connection_state': {'key': 'properties.privateLinkServiceConnectionState', 'type': 'PrivateLinkConnectionState'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkConnectionApprovalRequestResource, self).__init__(**kwargs)
        self.private_link_service_connection_state = kwargs.get('private_link_service_connection_state', None)


class PrivateLinkConnectionState(msrest.serialization.Model):
    """The state of a private link connection.

    :param status: Status of a private link connection.
    :type status: str
    :param description: Description of a private link connection.
    :type description: str
    :param actions_required: ActionsRequired for a private link connection.
    :type actions_required: str
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'actions_required': {'key': 'actionsRequired', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkConnectionState, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.description = kwargs.get('description', None)
        self.actions_required = kwargs.get('actions_required', None)


class PrivateLinkResource(msrest.serialization.Model):
    """A private link resource.

    All required parameters must be populated in order to send to Azure.

    :param id: Required.
    :type id: str
    :param name: Required. Name of a private link resource.
    :type name: str
    :param type: Required.
    :type type: str
    :param properties: Required. Properties of a private link resource.
    :type properties: ~azure.mgmt.web.v2021_01_01.models.PrivateLinkResourceProperties
    """

    _validation = {
        'id': {'required': True},
        'name': {'required': True},
        'type': {'required': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'PrivateLinkResourceProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkResource, self).__init__(**kwargs)
        self.id = kwargs['id']
        self.name = kwargs['name']
        self.type = kwargs['type']
        self.properties = kwargs['properties']


class PrivateLinkResourceProperties(msrest.serialization.Model):
    """Properties of a private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar group_id: GroupId of a private link resource.
    :vartype group_id: str
    :ivar required_members: RequiredMembers of a private link resource.
    :vartype required_members: list[str]
    :ivar required_zone_names: RequiredZoneNames of a private link resource.
    :vartype required_zone_names: list[str]
    """

    _validation = {
        'group_id': {'readonly': True},
        'required_members': {'readonly': True},
        'required_zone_names': {'readonly': True},
    }

    _attribute_map = {
        'group_id': {'key': 'groupId', 'type': 'str'},
        'required_members': {'key': 'requiredMembers', 'type': '[str]'},
        'required_zone_names': {'key': 'requiredZoneNames', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkResourceProperties, self).__init__(**kwargs)
        self.group_id = None
        self.required_members = None
        self.required_zone_names = None


class PrivateLinkResourcesWrapper(msrest.serialization.Model):
    """Wrapper for a collection of private link resources.

    All required parameters must be populated in order to send to Azure.

    :param value: Required.
    :type value: list[~azure.mgmt.web.v2021_01_01.models.PrivateLinkResource]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateLinkResource]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkResourcesWrapper, self).__init__(**kwargs)
        self.value = kwargs['value']


class ProcessInfo(ProxyOnlyResource):
    """Process Information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar identifier: ARM Identifier for deployment.
    :vartype identifier: int
    :param deployment_name: Deployment name.
    :type deployment_name: str
    :param href: HRef URI.
    :type href: str
    :param minidump: Minidump URI.
    :type minidump: str
    :param is_profile_running: Is profile running?.
    :type is_profile_running: bool
    :param is_iis_profile_running: Is the IIS Profile running?.
    :type is_iis_profile_running: bool
    :param iis_profile_timeout_in_seconds: IIS Profile timeout (seconds).
    :type iis_profile_timeout_in_seconds: float
    :param parent: Parent process.
    :type parent: str
    :param children: Child process list.
    :type children: list[str]
    :param threads: Thread list.
    :type threads: list[~azure.mgmt.web.v2021_01_01.models.ProcessThreadInfo]
    :param open_file_handles: List of open files.
    :type open_file_handles: list[str]
    :param modules: List of modules.
    :type modules: list[~azure.mgmt.web.v2021_01_01.models.ProcessModuleInfo]
    :param file_name: File name of this process.
    :type file_name: str
    :param command_line: Command line.
    :type command_line: str
    :param user_name: User name.
    :type user_name: str
    :param handle_count: Handle count.
    :type handle_count: int
    :param module_count: Module count.
    :type module_count: int
    :param thread_count: Thread count.
    :type thread_count: int
    :param start_time: Start time.
    :type start_time: ~datetime.datetime
    :param total_cpu_time: Total CPU time.
    :type total_cpu_time: str
    :param user_cpu_time: User CPU time.
    :type user_cpu_time: str
    :param privileged_cpu_time: Privileged CPU time.
    :type privileged_cpu_time: str
    :param working_set: Working set.
    :type working_set: long
    :param peak_working_set: Peak working set.
    :type peak_working_set: long
    :param private_memory: Private memory size.
    :type private_memory: long
    :param virtual_memory: Virtual memory size.
    :type virtual_memory: long
    :param peak_virtual_memory: Peak virtual memory usage.
    :type peak_virtual_memory: long
    :param paged_system_memory: Paged system memory.
    :type paged_system_memory: long
    :param non_paged_system_memory: Non-paged system memory.
    :type non_paged_system_memory: long
    :param paged_memory: Paged memory.
    :type paged_memory: long
    :param peak_paged_memory: Peak paged memory.
    :type peak_paged_memory: long
    :param time_stamp: Time stamp.
    :type time_stamp: ~datetime.datetime
    :param environment_variables: List of environment variables.
    :type environment_variables: dict[str, str]
    :param is_scm_site: Is this the SCM site?.
    :type is_scm_site: bool
    :param is_webjob: Is this a Web Job?.
    :type is_webjob: bool
    :param description: Description of process.
    :type description: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'identifier': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'identifier': {'key': 'properties.identifier', 'type': 'int'},
        'deployment_name': {'key': 'properties.deployment_name', 'type': 'str'},
        'href': {'key': 'properties.href', 'type': 'str'},
        'minidump': {'key': 'properties.minidump', 'type': 'str'},
        'is_profile_running': {'key': 'properties.is_profile_running', 'type': 'bool'},
        'is_iis_profile_running': {'key': 'properties.is_iis_profile_running', 'type': 'bool'},
        'iis_profile_timeout_in_seconds': {'key': 'properties.iis_profile_timeout_in_seconds', 'type': 'float'},
        'parent': {'key': 'properties.parent', 'type': 'str'},
        'children': {'key': 'properties.children', 'type': '[str]'},
        'threads': {'key': 'properties.threads', 'type': '[ProcessThreadInfo]'},
        'open_file_handles': {'key': 'properties.open_file_handles', 'type': '[str]'},
        'modules': {'key': 'properties.modules', 'type': '[ProcessModuleInfo]'},
        'file_name': {'key': 'properties.file_name', 'type': 'str'},
        'command_line': {'key': 'properties.command_line', 'type': 'str'},
        'user_name': {'key': 'properties.user_name', 'type': 'str'},
        'handle_count': {'key': 'properties.handle_count', 'type': 'int'},
        'module_count': {'key': 'properties.module_count', 'type': 'int'},
        'thread_count': {'key': 'properties.thread_count', 'type': 'int'},
        'start_time': {'key': 'properties.start_time', 'type': 'iso-8601'},
        'total_cpu_time': {'key': 'properties.total_cpu_time', 'type': 'str'},
        'user_cpu_time': {'key': 'properties.user_cpu_time', 'type': 'str'},
        'privileged_cpu_time': {'key': 'properties.privileged_cpu_time', 'type': 'str'},
        'working_set': {'key': 'properties.working_set', 'type': 'long'},
        'peak_working_set': {'key': 'properties.peak_working_set', 'type': 'long'},
        'private_memory': {'key': 'properties.private_memory', 'type': 'long'},
        'virtual_memory': {'key': 'properties.virtual_memory', 'type': 'long'},
        'peak_virtual_memory': {'key': 'properties.peak_virtual_memory', 'type': 'long'},
        'paged_system_memory': {'key': 'properties.paged_system_memory', 'type': 'long'},
        'non_paged_system_memory': {'key': 'properties.non_paged_system_memory', 'type': 'long'},
        'paged_memory': {'key': 'properties.paged_memory', 'type': 'long'},
        'peak_paged_memory': {'key': 'properties.peak_paged_memory', 'type': 'long'},
        'time_stamp': {'key': 'properties.time_stamp', 'type': 'iso-8601'},
        'environment_variables': {'key': 'properties.environment_variables', 'type': '{str}'},
        'is_scm_site': {'key': 'properties.is_scm_site', 'type': 'bool'},
        'is_webjob': {'key': 'properties.is_webjob', 'type': 'bool'},
        'description': {'key': 'properties.description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProcessInfo, self).__init__(**kwargs)
        self.identifier = None
        self.deployment_name = kwargs.get('deployment_name', None)
        self.href = kwargs.get('href', None)
        self.minidump = kwargs.get('minidump', None)
        self.is_profile_running = kwargs.get('is_profile_running', None)
        self.is_iis_profile_running = kwargs.get('is_iis_profile_running', None)
        self.iis_profile_timeout_in_seconds = kwargs.get('iis_profile_timeout_in_seconds', None)
        self.parent = kwargs.get('parent', None)
        self.children = kwargs.get('children', None)
        self.threads = kwargs.get('threads', None)
        self.open_file_handles = kwargs.get('open_file_handles', None)
        self.modules = kwargs.get('modules', None)
        self.file_name = kwargs.get('file_name', None)
        self.command_line = kwargs.get('command_line', None)
        self.user_name = kwargs.get('user_name', None)
        self.handle_count = kwargs.get('handle_count', None)
        self.module_count = kwargs.get('module_count', None)
        self.thread_count = kwargs.get('thread_count', None)
        self.start_time = kwargs.get('start_time', None)
        self.total_cpu_time = kwargs.get('total_cpu_time', None)
        self.user_cpu_time = kwargs.get('user_cpu_time', None)
        self.privileged_cpu_time = kwargs.get('privileged_cpu_time', None)
        self.working_set = kwargs.get('working_set', None)
        self.peak_working_set = kwargs.get('peak_working_set', None)
        self.private_memory = kwargs.get('private_memory', None)
        self.virtual_memory = kwargs.get('virtual_memory', None)
        self.peak_virtual_memory = kwargs.get('peak_virtual_memory', None)
        self.paged_system_memory = kwargs.get('paged_system_memory', None)
        self.non_paged_system_memory = kwargs.get('non_paged_system_memory', None)
        self.paged_memory = kwargs.get('paged_memory', None)
        self.peak_paged_memory = kwargs.get('peak_paged_memory', None)
        self.time_stamp = kwargs.get('time_stamp', None)
        self.environment_variables = kwargs.get('environment_variables', None)
        self.is_scm_site = kwargs.get('is_scm_site', None)
        self.is_webjob = kwargs.get('is_webjob', None)
        self.description = kwargs.get('description', None)


class ProcessInfoCollection(msrest.serialization.Model):
    """Collection of Kudu process information elements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2021_01_01.models.ProcessInfo]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ProcessInfo]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProcessInfoCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class ProcessModuleInfo(ProxyOnlyResource):
    """Process Module Information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param base_address: Base address. Used as module identifier in ARM resource URI.
    :type base_address: str
    :param file_name: File name.
    :type file_name: str
    :param href: HRef URI.
    :type href: str
    :param file_path: File path.
    :type file_path: str
    :param module_memory_size: Module memory size.
    :type module_memory_size: int
    :param file_version: File version.
    :type file_version: str
    :param file_description: File description.
    :type file_description: str
    :param product: Product name.
    :type product: str
    :param product_version: Product version.
    :type product_version: str
    :param is_debug: Is debug?.
    :type is_debug: bool
    :param language: Module language (locale).
    :type language: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'base_address': {'key': 'properties.base_address', 'type': 'str'},
        'file_name': {'key': 'properties.file_name', 'type': 'str'},
        'href': {'key': 'properties.href', 'type': 'str'},
        'file_path': {'key': 'properties.file_path', 'type': 'str'},
        'module_memory_size': {'key': 'properties.module_memory_size', 'type': 'int'},
        'file_version': {'key': 'properties.file_version', 'type': 'str'},
        'file_description': {'key': 'properties.file_description', 'type': 'str'},
        'product': {'key': 'properties.product', 'type': 'str'},
        'product_version': {'key': 'properties.product_version', 'type': 'str'},
        'is_debug': {'key': 'properties.is_debug', 'type': 'bool'},
        'language': {'key': 'properties.language', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProcessModuleInfo, self).__init__(**kwargs)
        self.base_address = kwargs.get('base_address', None)
        self.file_name = kwargs.get('file_name', None)
        self.href = kwargs.get('href', None)
        self.file_path = kwargs.get('file_path', None)
        self.module_memory_size = kwargs.get('module_memory_size', None)
        self.file_version = kwargs.get('file_version', None)
        self.file_description = kwargs.get('file_description', None)
        self.product = kwargs.get('product', None)
        self.product_version = kwargs.get('product_version', None)
        self.is_debug = kwargs.get('is_debug', None)
        self.language = kwargs.get('language', None)


class ProcessModuleInfoCollection(msrest.serialization.Model):
    """Collection of Kudu thread information elements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2021_01_01.models.ProcessModuleInfo]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ProcessModuleInfo]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProcessModuleInfoCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class ProcessThreadInfo(ProxyOnlyResource):
    """Process Thread Information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar identifier: Site extension ID.
    :vartype identifier: int
    :param href: HRef URI.
    :type href: str
    :param process: Process URI.
    :type process: str
    :param start_address: Start address.
    :type start_address: str
    :param current_priority: Current thread priority.
    :type current_priority: int
    :param priority_level: Thread priority level.
    :type priority_level: str
    :param base_priority: Base priority.
    :type base_priority: int
    :param start_time: Start time.
    :type start_time: ~datetime.datetime
    :param total_processor_time: Total processor time.
    :type total_processor_time: str
    :param user_processor_time: User processor time.
    :type user_processor_time: str
    :param state: Thread state.
    :type state: str
    :param wait_reason: Wait reason.
    :type wait_reason: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'identifier': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'identifier': {'key': 'properties.identifier', 'type': 'int'},
        'href': {'key': 'properties.href', 'type': 'str'},
        'process': {'key': 'properties.process', 'type': 'str'},
        'start_address': {'key': 'properties.start_address', 'type': 'str'},
        'current_priority': {'key': 'properties.current_priority', 'type': 'int'},
        'priority_level': {'key': 'properties.priority_level', 'type': 'str'},
        'base_priority': {'key': 'properties.base_priority', 'type': 'int'},
        'start_time': {'key': 'properties.start_time', 'type': 'iso-8601'},
        'total_processor_time': {'key': 'properties.total_processor_time', 'type': 'str'},
        'user_processor_time': {'key': 'properties.user_processor_time', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'wait_reason': {'key': 'properties.wait_reason', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProcessThreadInfo, self).__init__(**kwargs)
        self.identifier = None
        self.href = kwargs.get('href', None)
        self.process = kwargs.get('process', None)
        self.start_address = kwargs.get('start_address', None)
        self.current_priority = kwargs.get('current_priority', None)
        self.priority_level = kwargs.get('priority_level', None)
        self.base_priority = kwargs.get('base_priority', None)
        self.start_time = kwargs.get('start_time', None)
        self.total_processor_time = kwargs.get('total_processor_time', None)
        self.user_processor_time = kwargs.get('user_processor_time', None)
        self.state = kwargs.get('state', None)
        self.wait_reason = kwargs.get('wait_reason', None)


class ProcessThreadInfoCollection(msrest.serialization.Model):
    """Collection of Kudu thread information elements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2021_01_01.models.ProcessThreadInfo]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ProcessThreadInfo]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProcessThreadInfoCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class PublicCertificate(ProxyOnlyResource):
    """Public certificate object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param blob: Public Certificate byte array.
    :type blob: bytearray
    :param public_certificate_location: Public Certificate Location. Possible values include:
     "CurrentUserMy", "LocalMachineMy", "Unknown".
    :type public_certificate_location: str or
     ~azure.mgmt.web.v2021_01_01.models.PublicCertificateLocation
    :ivar thumbprint: Certificate Thumbprint.
    :vartype thumbprint: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'thumbprint': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'blob': {'key': 'properties.blob', 'type': 'bytearray'},
        'public_certificate_location': {'key': 'properties.publicCertificateLocation', 'type': 'str'},
        'thumbprint': {'key': 'properties.thumbprint', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PublicCertificate, self).__init__(**kwargs)
        self.blob = kwargs.get('blob', None)
        self.public_certificate_location = kwargs.get('public_certificate_location', None)
        self.thumbprint = None


class PublicCertificateCollection(msrest.serialization.Model):
    """Collection of public certificates.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2021_01_01.models.PublicCertificate]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PublicCertificate]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PublicCertificateCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class PushSettings(ProxyOnlyResource):
    """Push settings for the App.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param is_push_enabled: Gets or sets a flag indicating whether the Push endpoint is enabled.
    :type is_push_enabled: bool
    :param tag_whitelist_json: Gets or sets a JSON string containing a list of tags that are
     whitelisted for use by the push registration endpoint.
    :type tag_whitelist_json: str
    :param tags_requiring_auth: Gets or sets a JSON string containing a list of tags that require
     user authentication to be used in the push registration endpoint.
     Tags can consist of alphanumeric characters and the following:
     '_', '@', '#', '.', ':', '-'.
     Validation should be performed at the PushRequestHandler.
    :type tags_requiring_auth: str
    :param dynamic_tags_json: Gets or sets a JSON string containing a list of dynamic tags that
     will be evaluated from user claims in the push registration endpoint.
    :type dynamic_tags_json: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'is_push_enabled': {'key': 'properties.isPushEnabled', 'type': 'bool'},
        'tag_whitelist_json': {'key': 'properties.tagWhitelistJson', 'type': 'str'},
        'tags_requiring_auth': {'key': 'properties.tagsRequiringAuth', 'type': 'str'},
        'dynamic_tags_json': {'key': 'properties.dynamicTagsJson', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PushSettings, self).__init__(**kwargs)
        self.is_push_enabled = kwargs.get('is_push_enabled', None)
        self.tag_whitelist_json = kwargs.get('tag_whitelist_json', None)
        self.tags_requiring_auth = kwargs.get('tags_requiring_auth', None)
        self.dynamic_tags_json = kwargs.get('dynamic_tags_json', None)


class QueryUtterancesResult(msrest.serialization.Model):
    """Result for utterances query.

    :param sample_utterance: A sample utterance.
    :type sample_utterance: ~azure.mgmt.web.v2021_01_01.models.SampleUtterance
    :param score: Score of a sample utterance.
    :type score: float
    """

    _attribute_map = {
        'sample_utterance': {'key': 'sampleUtterance', 'type': 'SampleUtterance'},
        'score': {'key': 'score', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(QueryUtterancesResult, self).__init__(**kwargs)
        self.sample_utterance = kwargs.get('sample_utterance', None)
        self.score = kwargs.get('score', None)


class QueryUtterancesResults(msrest.serialization.Model):
    """Suggested utterances where the detector can be applicable.

    :param query: Search Query.
    :type query: str
    :param results: Array of utterance results for search query.
    :type results: list[~azure.mgmt.web.v2021_01_01.models.QueryUtterancesResult]
    """

    _attribute_map = {
        'query': {'key': 'query', 'type': 'str'},
        'results': {'key': 'results', 'type': '[QueryUtterancesResult]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(QueryUtterancesResults, self).__init__(**kwargs)
        self.query = kwargs.get('query', None)
        self.results = kwargs.get('results', None)


class RampUpRule(msrest.serialization.Model):
    """Routing rules for ramp up testing. This rule allows to redirect static traffic % to a slot or to gradually change routing % based on performance.

    :param action_host_name: Hostname of a slot to which the traffic will be redirected if decided
     to. E.g. myapp-stage.azurewebsites.net.
    :type action_host_name: str
    :param reroute_percentage: Percentage of the traffic which will be redirected to
     :code:`<code>ActionHostName</code>`.
    :type reroute_percentage: float
    :param change_step: In auto ramp up scenario this is the step to add/remove from
     :code:`<code>ReroutePercentage</code>` until it reaches
     \n:code:`<code>MinReroutePercentage</code>` or
     :code:`<code>MaxReroutePercentage</code>`. Site metrics are checked every N minutes specified
     in :code:`<code>ChangeIntervalInMinutes</code>`.\nCustom decision algorithm
     can be provided in TiPCallback site extension which URL can be specified in
     :code:`<code>ChangeDecisionCallbackUrl</code>`.
    :type change_step: float
    :param change_interval_in_minutes: Specifies interval in minutes to reevaluate
     ReroutePercentage.
    :type change_interval_in_minutes: int
    :param min_reroute_percentage: Specifies lower boundary above which ReroutePercentage will
     stay.
    :type min_reroute_percentage: float
    :param max_reroute_percentage: Specifies upper boundary below which ReroutePercentage will
     stay.
    :type max_reroute_percentage: float
    :param change_decision_callback_url: Custom decision algorithm can be provided in TiPCallback
     site extension which URL can be specified. See TiPCallback site extension for the scaffold and
     contracts.
     https://www.siteextensions.net/packages/TiPCallback/.
    :type change_decision_callback_url: str
    :param name: Name of the routing rule. The recommended name would be to point to the slot which
     will receive the traffic in the experiment.
    :type name: str
    """

    _attribute_map = {
        'action_host_name': {'key': 'actionHostName', 'type': 'str'},
        'reroute_percentage': {'key': 'reroutePercentage', 'type': 'float'},
        'change_step': {'key': 'changeStep', 'type': 'float'},
        'change_interval_in_minutes': {'key': 'changeIntervalInMinutes', 'type': 'int'},
        'min_reroute_percentage': {'key': 'minReroutePercentage', 'type': 'float'},
        'max_reroute_percentage': {'key': 'maxReroutePercentage', 'type': 'float'},
        'change_decision_callback_url': {'key': 'changeDecisionCallbackUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RampUpRule, self).__init__(**kwargs)
        self.action_host_name = kwargs.get('action_host_name', None)
        self.reroute_percentage = kwargs.get('reroute_percentage', None)
        self.change_step = kwargs.get('change_step', None)
        self.change_interval_in_minutes = kwargs.get('change_interval_in_minutes', None)
        self.min_reroute_percentage = kwargs.get('min_reroute_percentage', None)
        self.max_reroute_percentage = kwargs.get('max_reroute_percentage', None)
        self.change_decision_callback_url = kwargs.get('change_decision_callback_url', None)
        self.name = kwargs.get('name', None)


class Recommendation(ProxyOnlyResource):
    """Represents a recommendation result generated by the recommendation engine.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param creation_time: Timestamp when this instance was created.
    :type creation_time: ~datetime.datetime
    :param recommendation_id: A GUID value that each recommendation object is associated with.
    :type recommendation_id: str
    :param resource_id: Full ARM resource ID string that this recommendation object is associated
     with.
    :type resource_id: str
    :param resource_scope: Name of a resource type this recommendation applies, e.g. Subscription,
     ServerFarm, Site. Possible values include: "ServerFarm", "Subscription", "WebSite".
    :type resource_scope: str or ~azure.mgmt.web.v2021_01_01.models.ResourceScopeType
    :param rule_name: Unique name of the rule.
    :type rule_name: str
    :param display_name: UI friendly name of the rule (may not be unique).
    :type display_name: str
    :param message: Recommendation text.
    :type message: str
    :param level: Level indicating how critical this recommendation can impact. Possible values
     include: "Critical", "Warning", "Information", "NonUrgentSuggestion".
    :type level: str or ~azure.mgmt.web.v2021_01_01.models.NotificationLevel
    :param channels: List of channels that this recommendation can apply. Possible values include:
     "Notification", "Api", "Email", "Webhook", "All".
    :type channels: str or ~azure.mgmt.web.v2021_01_01.models.Channels
    :ivar category_tags: The list of category tags that this recommendation belongs to.
    :vartype category_tags: list[str]
    :param action_name: Name of action recommended by this object.
    :type action_name: str
    :param enabled: True if this recommendation is still valid (i.e. "actionable"). False if it is
     invalid.
    :type enabled: int
    :param states: The list of states of this recommendation. If it's null then it should be
     considered "Active".
    :type states: list[str]
    :param start_time: The beginning time in UTC of a range that the recommendation refers to.
    :type start_time: ~datetime.datetime
    :param end_time: The end time in UTC of a range that the recommendation refers to.
    :type end_time: ~datetime.datetime
    :param next_notification_time: When to notify this recommendation next in UTC. Null means that
     this will never be notified anymore.
    :type next_notification_time: ~datetime.datetime
    :param notification_expiration_time: Date and time in UTC when this notification expires.
    :type notification_expiration_time: ~datetime.datetime
    :param notified_time: Last timestamp in UTC this instance was actually notified. Null means
     that this recommendation hasn't been notified yet.
    :type notified_time: ~datetime.datetime
    :param score: A metric value measured by the rule.
    :type score: float
    :param is_dynamic: True if this is associated with a dynamically added rule.
    :type is_dynamic: bool
    :param extension_name: Extension name of the portal if exists.
    :type extension_name: str
    :param blade_name: Deep link to a blade on the portal.
    :type blade_name: str
    :param forward_link: Forward link to an external document associated with the rule.
    :type forward_link: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'category_tags': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'iso-8601'},
        'recommendation_id': {'key': 'properties.recommendationId', 'type': 'str'},
        'resource_id': {'key': 'properties.resourceId', 'type': 'str'},
        'resource_scope': {'key': 'properties.resourceScope', 'type': 'str'},
        'rule_name': {'key': 'properties.ruleName', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'message': {'key': 'properties.message', 'type': 'str'},
        'level': {'key': 'properties.level', 'type': 'str'},
        'channels': {'key': 'properties.channels', 'type': 'str'},
        'category_tags': {'key': 'properties.categoryTags', 'type': '[str]'},
        'action_name': {'key': 'properties.actionName', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'int'},
        'states': {'key': 'properties.states', 'type': '[str]'},
        'start_time': {'key': 'properties.startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'properties.endTime', 'type': 'iso-8601'},
        'next_notification_time': {'key': 'properties.nextNotificationTime', 'type': 'iso-8601'},
        'notification_expiration_time': {'key': 'properties.notificationExpirationTime', 'type': 'iso-8601'},
        'notified_time': {'key': 'properties.notifiedTime', 'type': 'iso-8601'},
        'score': {'key': 'properties.score', 'type': 'float'},
        'is_dynamic': {'key': 'properties.isDynamic', 'type': 'bool'},
        'extension_name': {'key': 'properties.extensionName', 'type': 'str'},
        'blade_name': {'key': 'properties.bladeName', 'type': 'str'},
        'forward_link': {'key': 'properties.forwardLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Recommendation, self).__init__(**kwargs)
        self.creation_time = kwargs.get('creation_time', None)
        self.recommendation_id = kwargs.get('recommendation_id', None)
        self.resource_id = kwargs.get('resource_id', None)
        self.resource_scope = kwargs.get('resource_scope', None)
        self.rule_name = kwargs.get('rule_name', None)
        self.display_name = kwargs.get('display_name', None)
        self.message = kwargs.get('message', None)
        self.level = kwargs.get('level', None)
        self.channels = kwargs.get('channels', None)
        self.category_tags = None
        self.action_name = kwargs.get('action_name', None)
        self.enabled = kwargs.get('enabled', None)
        self.states = kwargs.get('states', None)
        self.start_time = kwargs.get('start_time', None)
        self.end_time = kwargs.get('end_time', None)
        self.next_notification_time = kwargs.get('next_notification_time', None)
        self.notification_expiration_time = kwargs.get('notification_expiration_time', None)
        self.notified_time = kwargs.get('notified_time', None)
        self.score = kwargs.get('score', None)
        self.is_dynamic = kwargs.get('is_dynamic', None)
        self.extension_name = kwargs.get('extension_name', None)
        self.blade_name = kwargs.get('blade_name', None)
        self.forward_link = kwargs.get('forward_link', None)


class RecommendationCollection(msrest.serialization.Model):
    """Collection of recommendations.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2021_01_01.models.Recommendation]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Recommendation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RecommendationCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class RecommendationRule(ProxyOnlyResource):
    """Represents a recommendation rule that the recommendation engine can perform.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param recommendation_name: Unique name of the rule.
    :type recommendation_name: str
    :param display_name: UI friendly name of the rule.
    :type display_name: str
    :param message: Localized name of the rule (Good for UI).
    :type message: str
    :param recommendation_id: Recommendation ID of an associated recommendation object tied to the
     rule, if exists.
     If such an object doesn't exist, it is set to null.
    :type recommendation_id: str
    :param description: Localized detailed description of the rule.
    :type description: str
    :param action_name: Name of action that is recommended by this rule in string.
    :type action_name: str
    :param level: Level of impact indicating how critical this rule is. Possible values include:
     "Critical", "Warning", "Information", "NonUrgentSuggestion".
    :type level: str or ~azure.mgmt.web.v2021_01_01.models.NotificationLevel
    :param channels: List of available channels that this rule applies. Possible values include:
     "Notification", "Api", "Email", "Webhook", "All".
    :type channels: str or ~azure.mgmt.web.v2021_01_01.models.Channels
    :ivar category_tags: The list of category tags that this recommendation rule belongs to.
    :vartype category_tags: list[str]
    :param is_dynamic: True if this is associated with a dynamically added rule.
    :type is_dynamic: bool
    :param extension_name: Extension name of the portal if exists. Applicable to dynamic rule only.
    :type extension_name: str
    :param blade_name: Deep link to a blade on the portal. Applicable to dynamic rule only.
    :type blade_name: str
    :param forward_link: Forward link to an external document associated with the rule. Applicable
     to dynamic rule only.
    :type forward_link: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'category_tags': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'recommendation_name': {'key': 'properties.recommendationName', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'message': {'key': 'properties.message', 'type': 'str'},
        'recommendation_id': {'key': 'properties.recommendationId', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'action_name': {'key': 'properties.actionName', 'type': 'str'},
        'level': {'key': 'properties.level', 'type': 'str'},
        'channels': {'key': 'properties.channels', 'type': 'str'},
        'category_tags': {'key': 'properties.categoryTags', 'type': '[str]'},
        'is_dynamic': {'key': 'properties.isDynamic', 'type': 'bool'},
        'extension_name': {'key': 'properties.extensionName', 'type': 'str'},
        'blade_name': {'key': 'properties.bladeName', 'type': 'str'},
        'forward_link': {'key': 'properties.forwardLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RecommendationRule, self).__init__(**kwargs)
        self.recommendation_name = kwargs.get('recommendation_name', None)
        self.display_name = kwargs.get('display_name', None)
        self.message = kwargs.get('message', None)
        self.recommendation_id = kwargs.get('recommendation_id', None)
        self.description = kwargs.get('description', None)
        self.action_name = kwargs.get('action_name', None)
        self.level = kwargs.get('level', None)
        self.channels = kwargs.get('channels', None)
        self.category_tags = None
        self.is_dynamic = kwargs.get('is_dynamic', None)
        self.extension_name = kwargs.get('extension_name', None)
        self.blade_name = kwargs.get('blade_name', None)
        self.forward_link = kwargs.get('forward_link', None)


class ReissueCertificateOrderRequest(ProxyOnlyResource):
    """Class representing certificate reissue request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param key_size: Certificate Key Size.
    :type key_size: int
    :param delay_existing_revoke_in_hours: Delay in hours to revoke existing certificate after the
     new certificate is issued.
    :type delay_existing_revoke_in_hours: int
    :param csr: Csr to be used for re-key operation.
    :type csr: str
    :param is_private_key_external: Should we change the ASC type (from managed private key to
     external private key and vice versa).
    :type is_private_key_external: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'key_size': {'key': 'properties.keySize', 'type': 'int'},
        'delay_existing_revoke_in_hours': {'key': 'properties.delayExistingRevokeInHours', 'type': 'int'},
        'csr': {'key': 'properties.csr', 'type': 'str'},
        'is_private_key_external': {'key': 'properties.isPrivateKeyExternal', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReissueCertificateOrderRequest, self).__init__(**kwargs)
        self.key_size = kwargs.get('key_size', None)
        self.delay_existing_revoke_in_hours = kwargs.get('delay_existing_revoke_in_hours', None)
        self.csr = kwargs.get('csr', None)
        self.is_private_key_external = kwargs.get('is_private_key_external', None)


class RelayServiceConnectionEntity(ProxyOnlyResource):
    """Hybrid Connection for an App Service app.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param entity_name:
    :type entity_name: str
    :param entity_connection_string:
    :type entity_connection_string: str
    :param resource_type:
    :type resource_type: str
    :param resource_connection_string:
    :type resource_connection_string: str
    :param hostname:
    :type hostname: str
    :param port:
    :type port: int
    :param biztalk_uri:
    :type biztalk_uri: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'entity_name': {'key': 'properties.entityName', 'type': 'str'},
        'entity_connection_string': {'key': 'properties.entityConnectionString', 'type': 'str'},
        'resource_type': {'key': 'properties.resourceType', 'type': 'str'},
        'resource_connection_string': {'key': 'properties.resourceConnectionString', 'type': 'str'},
        'hostname': {'key': 'properties.hostname', 'type': 'str'},
        'port': {'key': 'properties.port', 'type': 'int'},
        'biztalk_uri': {'key': 'properties.biztalkUri', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RelayServiceConnectionEntity, self).__init__(**kwargs)
        self.entity_name = kwargs.get('entity_name', None)
        self.entity_connection_string = kwargs.get('entity_connection_string', None)
        self.resource_type = kwargs.get('resource_type', None)
        self.resource_connection_string = kwargs.get('resource_connection_string', None)
        self.hostname = kwargs.get('hostname', None)
        self.port = kwargs.get('port', None)
        self.biztalk_uri = kwargs.get('biztalk_uri', None)


class RemotePrivateEndpointConnection(ProxyOnlyResource):
    """A remote private endpoint connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar provisioning_state:
    :vartype provisioning_state: str
    :param private_endpoint: PrivateEndpoint of a remote private endpoint connection.
    :type private_endpoint: ~azure.mgmt.web.v2021_01_01.models.ArmIdWrapper
    :param private_link_service_connection_state: The state of a private link connection.
    :type private_link_service_connection_state:
     ~azure.mgmt.web.v2021_01_01.models.PrivateLinkConnectionState
    :param ip_addresses: Private IPAddresses mapped to the remote private endpoint.
    :type ip_addresses: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'private_endpoint': {'key': 'properties.privateEndpoint', 'type': 'ArmIdWrapper'},
        'private_link_service_connection_state': {'key': 'properties.privateLinkServiceConnectionState', 'type': 'PrivateLinkConnectionState'},
        'ip_addresses': {'key': 'properties.ipAddresses', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RemotePrivateEndpointConnection, self).__init__(**kwargs)
        self.provisioning_state = None
        self.private_endpoint = kwargs.get('private_endpoint', None)
        self.private_link_service_connection_state = kwargs.get('private_link_service_connection_state', None)
        self.ip_addresses = kwargs.get('ip_addresses', None)


class RemotePrivateEndpointConnectionARMResource(ProxyOnlyResource):
    """Remote Private Endpoint Connection ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar provisioning_state:
    :vartype provisioning_state: str
    :param private_endpoint: PrivateEndpoint of a remote private endpoint connection.
    :type private_endpoint: ~azure.mgmt.web.v2021_01_01.models.ArmIdWrapper
    :param private_link_service_connection_state: The state of a private link connection.
    :type private_link_service_connection_state:
     ~azure.mgmt.web.v2021_01_01.models.PrivateLinkConnectionState
    :param ip_addresses: Private IPAddresses mapped to the remote private endpoint.
    :type ip_addresses: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'private_endpoint': {'key': 'properties.privateEndpoint', 'type': 'ArmIdWrapper'},
        'private_link_service_connection_state': {'key': 'properties.privateLinkServiceConnectionState', 'type': 'PrivateLinkConnectionState'},
        'ip_addresses': {'key': 'properties.ipAddresses', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RemotePrivateEndpointConnectionARMResource, self).__init__(**kwargs)
        self.provisioning_state = None
        self.private_endpoint = kwargs.get('private_endpoint', None)
        self.private_link_service_connection_state = kwargs.get('private_link_service_connection_state', None)
        self.ip_addresses = kwargs.get('ip_addresses', None)


class Rendering(msrest.serialization.Model):
    """Instructions for rendering the data.

    :param type: Rendering Type. Possible values include: "NoGraph", "Table", "TimeSeries",
     "TimeSeriesPerInstance", "PieChart", "DataSummary", "Email", "Insights", "DynamicInsight",
     "Markdown", "Detector", "DropDown", "Card", "Solution", "Guage", "Form", "ChangeSets",
     "ChangeAnalysisOnboarding", "ChangesView", "AppInsight", "DependencyGraph", "DownTime",
     "SummaryCard", "SearchComponent", "AppInsightEnablement".
    :type type: str or ~azure.mgmt.web.v2021_01_01.models.RenderingType
    :param title: Title of data.
    :type title: str
    :param description: Description of the data that will help it be interpreted.
    :type description: str
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'title': {'key': 'title', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Rendering, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)
        self.title = kwargs.get('title', None)
        self.description = kwargs.get('description', None)


class RenewCertificateOrderRequest(ProxyOnlyResource):
    """Class representing certificate renew request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param key_size: Certificate Key Size.
    :type key_size: int
    :param csr: Csr to be used for re-key operation.
    :type csr: str
    :param is_private_key_external: Should we change the ASC type (from managed private key to
     external private key and vice versa).
    :type is_private_key_external: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'key_size': {'key': 'properties.keySize', 'type': 'int'},
        'csr': {'key': 'properties.csr', 'type': 'str'},
        'is_private_key_external': {'key': 'properties.isPrivateKeyExternal', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RenewCertificateOrderRequest, self).__init__(**kwargs)
        self.key_size = kwargs.get('key_size', None)
        self.csr = kwargs.get('csr', None)
        self.is_private_key_external = kwargs.get('is_private_key_external', None)


class RequestsBasedTrigger(msrest.serialization.Model):
    """Trigger based on total requests.

    :param count: Request Count.
    :type count: int
    :param time_interval: Time interval.
    :type time_interval: str
    """

    _attribute_map = {
        'count': {'key': 'count', 'type': 'int'},
        'time_interval': {'key': 'timeInterval', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RequestsBasedTrigger, self).__init__(**kwargs)
        self.count = kwargs.get('count', None)
        self.time_interval = kwargs.get('time_interval', None)


class ResourceCollection(msrest.serialization.Model):
    """Collection of resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[str]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[str]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class ResourceHealthMetadata(ProxyOnlyResource):
    """Used for getting ResourceHealthCheck settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param category: The category that the resource matches in the RHC Policy File.
    :type category: str
    :param signal_availability: Is there a health signal for the resource.
    :type signal_availability: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'category': {'key': 'properties.category', 'type': 'str'},
        'signal_availability': {'key': 'properties.signalAvailability', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceHealthMetadata, self).__init__(**kwargs)
        self.category = kwargs.get('category', None)
        self.signal_availability = kwargs.get('signal_availability', None)


class ResourceHealthMetadataCollection(msrest.serialization.Model):
    """Collection of resource health metadata.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2021_01_01.models.ResourceHealthMetadata]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ResourceHealthMetadata]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceHealthMetadataCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class ResourceMetricAvailability(msrest.serialization.Model):
    """Metrics availability and retention.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar time_grain: Time grain .
    :vartype time_grain: str
    :ivar retention: Retention period for the current time grain.
    :vartype retention: str
    """

    _validation = {
        'time_grain': {'readonly': True},
        'retention': {'readonly': True},
    }

    _attribute_map = {
        'time_grain': {'key': 'timeGrain', 'type': 'str'},
        'retention': {'key': 'retention', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceMetricAvailability, self).__init__(**kwargs)
        self.time_grain = None
        self.retention = None


class ResourceMetricDefinition(ProxyOnlyResource):
    """Metadata for the metrics.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar unit: Unit of the metric.
    :vartype unit: str
    :ivar primary_aggregation_type: Primary aggregation type.
    :vartype primary_aggregation_type: str
    :ivar metric_availabilities: List of time grains supported for the metric together with
     retention period.
    :vartype metric_availabilities:
     list[~azure.mgmt.web.v2021_01_01.models.ResourceMetricAvailability]
    :ivar resource_uri: Resource URI.
    :vartype resource_uri: str
    :ivar properties: Resource metric definition properties.
    :vartype properties: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'unit': {'readonly': True},
        'primary_aggregation_type': {'readonly': True},
        'metric_availabilities': {'readonly': True},
        'resource_uri': {'readonly': True},
        'properties': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'unit': {'key': 'properties.unit', 'type': 'str'},
        'primary_aggregation_type': {'key': 'properties.primaryAggregationType', 'type': 'str'},
        'metric_availabilities': {'key': 'properties.metricAvailabilities', 'type': '[ResourceMetricAvailability]'},
        'resource_uri': {'key': 'properties.resourceUri', 'type': 'str'},
        'properties': {'key': 'properties.properties', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceMetricDefinition, self).__init__(**kwargs)
        self.unit = None
        self.primary_aggregation_type = None
        self.metric_availabilities = None
        self.resource_uri = None
        self.properties = None


class ResourceMetricDefinitionCollection(msrest.serialization.Model):
    """Collection of metric definitions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2021_01_01.models.ResourceMetricDefinition]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ResourceMetricDefinition]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceMetricDefinitionCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class ResourceNameAvailability(msrest.serialization.Model):
    """Information regarding availability of a resource name.

    :param name_available: :code:`<code>true</code>` indicates name is valid and available.
     :code:`<code>false</code>` indicates the name is invalid, unavailable, or both.
    :type name_available: bool
    :param reason: :code:`<code>Invalid</code>` indicates the name provided does not match Azure
     App Service naming requirements. :code:`<code>AlreadyExists</code>` indicates that the name is
     already in use and is therefore unavailable. Possible values include: "Invalid",
     "AlreadyExists".
    :type reason: str or ~azure.mgmt.web.v2021_01_01.models.InAvailabilityReasonType
    :param message: If reason == invalid, provide the user with the reason why the given name is
     invalid, and provide the resource naming requirements so that the user can select a valid name.
     If reason == AlreadyExists, explain that resource name is already in use, and direct them to
     select a different name.
    :type message: str
    """

    _attribute_map = {
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceNameAvailability, self).__init__(**kwargs)
        self.name_available = kwargs.get('name_available', None)
        self.reason = kwargs.get('reason', None)
        self.message = kwargs.get('message', None)


class ResourceNameAvailabilityRequest(msrest.serialization.Model):
    """Resource name availability request content.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Resource name to verify.
    :type name: str
    :param type: Required. Resource type used for verification. Possible values include: "Site",
     "Slot", "HostingEnvironment", "PublishingUser", "Microsoft.Web/sites",
     "Microsoft.Web/sites/slots", "Microsoft.Web/hostingEnvironments",
     "Microsoft.Web/publishingUsers".
    :type type: str or ~azure.mgmt.web.v2021_01_01.models.CheckNameResourceTypes
    :param is_fqdn: Is fully qualified domain name.
    :type is_fqdn: bool
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'is_fqdn': {'key': 'isFqdn', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceNameAvailabilityRequest, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.type = kwargs['type']
        self.is_fqdn = kwargs.get('is_fqdn', None)


class ResponseMessageEnvelopeRemotePrivateEndpointConnection(msrest.serialization.Model):
    """Message envelope that contains the common Azure resource manager properties and the resource provider specific content.

    :param id: Resource Id. Typically ID is populated only for responses to GET requests. Caller is
     responsible for passing in this
     value for GET requests only.
     For example:
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupId}/providers/Microsoft.Web/sites/{sitename}.
    :type id: str
    :param name: Name of resource.
    :type name: str
    :param type: Type of resource e.g "Microsoft.Web/sites".
    :type type: str
    :param location: Geographical region resource belongs to e.g. SouthCentralUS, SouthEastAsia.
    :type location: str
    :param tags: A set of tags. Tags associated with resource.
    :type tags: dict[str, str]
    :param plan: Azure resource manager plan.
    :type plan: ~azure.mgmt.web.v2021_01_01.models.ArmPlan
    :param properties: Resource specific properties.
    :type properties: ~azure.mgmt.web.v2021_01_01.models.RemotePrivateEndpointConnection
    :param sku: SKU description of the resource.
    :type sku: ~azure.mgmt.web.v2021_01_01.models.SkuDescription
    :param status: Azure-AsyncOperation Status info.
    :type status: str
    :param error: Azure-AsyncOperation Error info.
    :type error: ~azure.mgmt.web.v2021_01_01.models.ErrorEntity
    :param identity: MSI resource.
    :type identity: ~azure.mgmt.web.v2021_01_01.models.ManagedServiceIdentity
    :param zones: Logical Availability Zones the service is hosted in.
    :type zones: list[str]
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'plan': {'key': 'plan', 'type': 'ArmPlan'},
        'properties': {'key': 'properties', 'type': 'RemotePrivateEndpointConnection'},
        'sku': {'key': 'sku', 'type': 'SkuDescription'},
        'status': {'key': 'status', 'type': 'str'},
        'error': {'key': 'error', 'type': 'ErrorEntity'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'zones': {'key': 'zones', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResponseMessageEnvelopeRemotePrivateEndpointConnection, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = kwargs.get('name', None)
        self.type = kwargs.get('type', None)
        self.location = kwargs.get('location', None)
        self.tags = kwargs.get('tags', None)
        self.plan = kwargs.get('plan', None)
        self.properties = kwargs.get('properties', None)
        self.sku = kwargs.get('sku', None)
        self.status = kwargs.get('status', None)
        self.error = kwargs.get('error', None)
        self.identity = kwargs.get('identity', None)
        self.zones = kwargs.get('zones', None)


class ResponseMetaData(msrest.serialization.Model):
    """ResponseMetaData.

    :param data_source: Source of the Data.
    :type data_source: ~azure.mgmt.web.v2021_01_01.models.DataSource
    """

    _attribute_map = {
        'data_source': {'key': 'dataSource', 'type': 'DataSource'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResponseMetaData, self).__init__(**kwargs)
        self.data_source = kwargs.get('data_source', None)


class RestoreRequest(ProxyOnlyResource):
    """Description of a restore request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param storage_account_url: SAS URL to the container.
    :type storage_account_url: str
    :param blob_name: Name of a blob which contains the backup.
    :type blob_name: str
    :param overwrite: :code:`<code>true</code>` if the restore operation can overwrite target app;
     otherwise, :code:`<code>false</code>`. :code:`<code>true</code>` is needed if trying to restore
     over an existing app.
    :type overwrite: bool
    :param site_name: Name of an app.
    :type site_name: str
    :param databases: Collection of databases which should be restored. This list has to match the
     list of databases included in the backup.
    :type databases: list[~azure.mgmt.web.v2021_01_01.models.DatabaseBackupSetting]
    :param ignore_conflicting_host_names: Changes a logic when restoring an app with custom
     domains. :code:`<code>true</code>` to remove custom domains automatically. If
     :code:`<code>false</code>`, custom domains are added to
     the app's object when it is being restored, but that might fail due to conflicts during the
     operation.
    :type ignore_conflicting_host_names: bool
    :param ignore_databases: Ignore the databases and only restore the site content.
    :type ignore_databases: bool
    :param app_service_plan: Specify app service plan that will own restored site.
    :type app_service_plan: str
    :param operation_type: Operation type. Possible values include: "Default", "Clone",
     "Relocation", "Snapshot", "CloudFS". Default value: "Default".
    :type operation_type: str or ~azure.mgmt.web.v2021_01_01.models.BackupRestoreOperationType
    :param adjust_connection_strings: :code:`<code>true</code>` if SiteConfig.ConnectionStrings
     should be set in new app; otherwise, :code:`<code>false</code>`.
    :type adjust_connection_strings: bool
    :param hosting_environment: App Service Environment name, if needed (only when restoring an app
     to an App Service Environment).
    :type hosting_environment: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'storage_account_url': {'key': 'properties.storageAccountUrl', 'type': 'str'},
        'blob_name': {'key': 'properties.blobName', 'type': 'str'},
        'overwrite': {'key': 'properties.overwrite', 'type': 'bool'},
        'site_name': {'key': 'properties.siteName', 'type': 'str'},
        'databases': {'key': 'properties.databases', 'type': '[DatabaseBackupSetting]'},
        'ignore_conflicting_host_names': {'key': 'properties.ignoreConflictingHostNames', 'type': 'bool'},
        'ignore_databases': {'key': 'properties.ignoreDatabases', 'type': 'bool'},
        'app_service_plan': {'key': 'properties.appServicePlan', 'type': 'str'},
        'operation_type': {'key': 'properties.operationType', 'type': 'str'},
        'adjust_connection_strings': {'key': 'properties.adjustConnectionStrings', 'type': 'bool'},
        'hosting_environment': {'key': 'properties.hostingEnvironment', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RestoreRequest, self).__init__(**kwargs)
        self.storage_account_url = kwargs.get('storage_account_url', None)
        self.blob_name = kwargs.get('blob_name', None)
        self.overwrite = kwargs.get('overwrite', None)
        self.site_name = kwargs.get('site_name', None)
        self.databases = kwargs.get('databases', None)
        self.ignore_conflicting_host_names = kwargs.get('ignore_conflicting_host_names', False)
        self.ignore_databases = kwargs.get('ignore_databases', False)
        self.app_service_plan = kwargs.get('app_service_plan', None)
        self.operation_type = kwargs.get('operation_type', "Default")
        self.adjust_connection_strings = kwargs.get('adjust_connection_strings', None)
        self.hosting_environment = kwargs.get('hosting_environment', None)


class SampleUtterance(msrest.serialization.Model):
    """Sample utterance.

    :param text: Text attribute of sample utterance.
    :type text: str
    :param links: Links attribute of sample utterance.
    :type links: list[str]
    :param qid: Question id of sample utterance (for stackoverflow questions titles).
    :type qid: str
    """

    _attribute_map = {
        'text': {'key': 'text', 'type': 'str'},
        'links': {'key': 'links', 'type': '[str]'},
        'qid': {'key': 'qid', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SampleUtterance, self).__init__(**kwargs)
        self.text = kwargs.get('text', None)
        self.links = kwargs.get('links', None)
        self.qid = kwargs.get('qid', None)


class ServiceSpecification(msrest.serialization.Model):
    """Resource metrics service provided by Microsoft.Insights resource provider.

    :param metric_specifications:
    :type metric_specifications: list[~azure.mgmt.web.v2021_01_01.models.MetricSpecification]
    :param log_specifications:
    :type log_specifications: list[~azure.mgmt.web.v2021_01_01.models.LogSpecification]
    """

    _attribute_map = {
        'metric_specifications': {'key': 'metricSpecifications', 'type': '[MetricSpecification]'},
        'log_specifications': {'key': 'logSpecifications', 'type': '[LogSpecification]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServiceSpecification, self).__init__(**kwargs)
        self.metric_specifications = kwargs.get('metric_specifications', None)
        self.log_specifications = kwargs.get('log_specifications', None)


class Site(Resource):
    """A web app, a mobile app backend, or an API app.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :param location: Required. Resource Location.
    :type location: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param identity: Managed service identity.
    :type identity: ~azure.mgmt.web.v2021_01_01.models.ManagedServiceIdentity
    :param extended_location: Extended Location.
    :type extended_location: ~azure.mgmt.web.v2021_01_01.models.ExtendedLocation
    :ivar state: Current state of the app.
    :vartype state: str
    :ivar host_names: Hostnames associated with the app.
    :vartype host_names: list[str]
    :ivar repository_site_name: Name of the repository site.
    :vartype repository_site_name: str
    :ivar usage_state: State indicating whether the app has exceeded its quota usage. Read-only.
     Possible values include: "Normal", "Exceeded".
    :vartype usage_state: str or ~azure.mgmt.web.v2021_01_01.models.UsageState
    :param enabled: :code:`<code>true</code>` if the app is enabled; otherwise,
     :code:`<code>false</code>`. Setting this value to false disables the app (takes the app
     offline).
    :type enabled: bool
    :ivar enabled_host_names: Enabled hostnames for the app.Hostnames need to be assigned (see
     HostNames) AND enabled. Otherwise,
     the app is not served on those hostnames.
    :vartype enabled_host_names: list[str]
    :ivar availability_state: Management information availability state for the app. Possible
     values include: "Normal", "Limited", "DisasterRecoveryMode".
    :vartype availability_state: str or ~azure.mgmt.web.v2021_01_01.models.SiteAvailabilityState
    :param host_name_ssl_states: Hostname SSL states are used to manage the SSL bindings for app's
     hostnames.
    :type host_name_ssl_states: list[~azure.mgmt.web.v2021_01_01.models.HostNameSslState]
    :param server_farm_id: Resource ID of the associated App Service plan, formatted as:
     "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
    :type server_farm_id: str
    :param reserved: :code:`<code>true</code>` if reserved; otherwise, :code:`<code>false</code>`.
    :type reserved: bool
    :param is_xenon: Obsolete: Hyper-V sandbox.
    :type is_xenon: bool
    :param hyper_v: Hyper-V sandbox.
    :type hyper_v: bool
    :ivar last_modified_time_utc: Last time the app was modified, in UTC. Read-only.
    :vartype last_modified_time_utc: ~datetime.datetime
    :param site_config: Configuration of the app.
    :type site_config: ~azure.mgmt.web.v2021_01_01.models.SiteConfig
    :ivar traffic_manager_host_names: Azure Traffic Manager hostnames associated with the app.
     Read-only.
    :vartype traffic_manager_host_names: list[str]
    :param scm_site_also_stopped: :code:`<code>true</code>` to stop SCM (KUDU) site when the app is
     stopped; otherwise, :code:`<code>false</code>`. The default is :code:`<code>false</code>`.
    :type scm_site_also_stopped: bool
    :ivar target_swap_slot: Specifies which deployment slot this app will swap into. Read-only.
    :vartype target_swap_slot: str
    :param hosting_environment_profile: App Service Environment to use for the app.
    :type hosting_environment_profile: ~azure.mgmt.web.v2021_01_01.models.HostingEnvironmentProfile
    :param client_affinity_enabled: :code:`<code>true</code>` to enable client affinity;
     :code:`<code>false</code>` to stop sending session affinity cookies, which route client
     requests in the same session to the same instance. Default is :code:`<code>true</code>`.
    :type client_affinity_enabled: bool
    :param client_cert_enabled: :code:`<code>true</code>` to enable client certificate
     authentication (TLS mutual authentication); otherwise, :code:`<code>false</code>`. Default is
     :code:`<code>false</code>`.
    :type client_cert_enabled: bool
    :param client_cert_mode: This composes with ClientCertEnabled setting.
    
    
     * ClientCertEnabled: false means ClientCert is ignored.
     * ClientCertEnabled: true and ClientCertMode: Required means ClientCert is required.
     * ClientCertEnabled: true and ClientCertMode: Optional means ClientCert is optional or
     accepted. Possible values include: "Required", "Optional", "OptionalInteractiveUser".
    :type client_cert_mode: str or ~azure.mgmt.web.v2021_01_01.models.ClientCertMode
    :param client_cert_exclusion_paths: client certificate authentication comma-separated exclusion
     paths.
    :type client_cert_exclusion_paths: str
    :param host_names_disabled: :code:`<code>true</code>` to disable the public hostnames of the
     app; otherwise, :code:`<code>false</code>`.
      If :code:`<code>true</code>`, the app is only accessible via API management process.
    :type host_names_disabled: bool
    :param custom_domain_verification_id: Unique identifier that verifies the custom domains
     assigned to the app. Customer will add this id to a txt record for verification.
    :type custom_domain_verification_id: str
    :ivar outbound_ip_addresses: List of IP addresses that the app uses for outbound connections
     (e.g. database access). Includes VIPs from tenants that site can be hosted with current
     settings. Read-only.
    :vartype outbound_ip_addresses: str
    :ivar possible_outbound_ip_addresses: List of IP addresses that the app uses for outbound
     connections (e.g. database access). Includes VIPs from all tenants except dataComponent.
     Read-only.
    :vartype possible_outbound_ip_addresses: str
    :param container_size: Size of the function container.
    :type container_size: int
    :param daily_memory_time_quota: Maximum allowed daily memory-time quota (applicable on dynamic
     apps only).
    :type daily_memory_time_quota: int
    :ivar suspended_till: App suspended till in case memory-time quota is exceeded.
    :vartype suspended_till: ~datetime.datetime
    :ivar max_number_of_workers: Maximum number of workers.
     This only applies to Functions container.
    :vartype max_number_of_workers: int
    :param cloning_info: If specified during app creation, the app is cloned from a source app.
    :type cloning_info: ~azure.mgmt.web.v2021_01_01.models.CloningInfo
    :ivar resource_group: Name of the resource group the app belongs to. Read-only.
    :vartype resource_group: str
    :ivar is_default_container: :code:`<code>true</code>` if the app is a default container;
     otherwise, :code:`<code>false</code>`.
    :vartype is_default_container: bool
    :ivar default_host_name: Default hostname of the app. Read-only.
    :vartype default_host_name: str
    :ivar slot_swap_status: Status of the last deployment slot swap operation.
    :vartype slot_swap_status: ~azure.mgmt.web.v2021_01_01.models.SlotSwapStatus
    :param https_only: HttpsOnly: configures a web site to accept only https requests. Issues
     redirect for
     http requests.
    :type https_only: bool
    :param redundancy_mode: Site redundancy mode. Possible values include: "None", "Manual",
     "Failover", "ActiveActive", "GeoRedundant".
    :type redundancy_mode: str or ~azure.mgmt.web.v2021_01_01.models.RedundancyMode
    :ivar in_progress_operation_id: Specifies an operation id if this site has a pending operation.
    :vartype in_progress_operation_id: str
    :param storage_account_required: Checks if Customer provided storage account is required.
    :type storage_account_required: bool
    :param key_vault_reference_identity: Identity to use for Key Vault Reference authentication.
    :type key_vault_reference_identity: str
    :param virtual_network_subnet_id: Azure Resource Manager ID of the Virtual network and subnet
     to be joined by Regional VNET Integration.
     This must be of the form
     /subscriptions/{subscriptionName}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
    :type virtual_network_subnet_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'location': {'required': True},
        'type': {'readonly': True},
        'state': {'readonly': True},
        'host_names': {'readonly': True},
        'repository_site_name': {'readonly': True},
        'usage_state': {'readonly': True},
        'enabled_host_names': {'readonly': True},
        'availability_state': {'readonly': True},
        'last_modified_time_utc': {'readonly': True},
        'traffic_manager_host_names': {'readonly': True},
        'target_swap_slot': {'readonly': True},
        'outbound_ip_addresses': {'readonly': True},
        'possible_outbound_ip_addresses': {'readonly': True},
        'suspended_till': {'readonly': True},
        'max_number_of_workers': {'readonly': True},
        'resource_group': {'readonly': True},
        'is_default_container': {'readonly': True},
        'default_host_name': {'readonly': True},
        'slot_swap_status': {'readonly': True},
        'in_progress_operation_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'extended_location': {'key': 'extendedLocation', 'type': 'ExtendedLocation'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'host_names': {'key': 'properties.hostNames', 'type': '[str]'},
        'repository_site_name': {'key': 'properties.repositorySiteName', 'type': 'str'},
        'usage_state': {'key': 'properties.usageState', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'enabled_host_names': {'key': 'properties.enabledHostNames', 'type': '[str]'},
        'availability_state': {'key': 'properties.availabilityState', 'type': 'str'},
        'host_name_ssl_states': {'key': 'properties.hostNameSslStates', 'type': '[HostNameSslState]'},
        'server_farm_id': {'key': 'properties.serverFarmId', 'type': 'str'},
        'reserved': {'key': 'properties.reserved', 'type': 'bool'},
        'is_xenon': {'key': 'properties.isXenon', 'type': 'bool'},
        'hyper_v': {'key': 'properties.hyperV', 'type': 'bool'},
        'last_modified_time_utc': {'key': 'properties.lastModifiedTimeUtc', 'type': 'iso-8601'},
        'site_config': {'key': 'properties.siteConfig', 'type': 'SiteConfig'},
        'traffic_manager_host_names': {'key': 'properties.trafficManagerHostNames', 'type': '[str]'},
        'scm_site_also_stopped': {'key': 'properties.scmSiteAlsoStopped', 'type': 'bool'},
        'target_swap_slot': {'key': 'properties.targetSwapSlot', 'type': 'str'},
        'hosting_environment_profile': {'key': 'properties.hostingEnvironmentProfile', 'type': 'HostingEnvironmentProfile'},
        'client_affinity_enabled': {'key': 'properties.clientAffinityEnabled', 'type': 'bool'},
        'client_cert_enabled': {'key': 'properties.clientCertEnabled', 'type': 'bool'},
        'client_cert_mode': {'key': 'properties.clientCertMode', 'type': 'str'},
        'client_cert_exclusion_paths': {'key': 'properties.clientCertExclusionPaths', 'type': 'str'},
        'host_names_disabled': {'key': 'properties.hostNamesDisabled', 'type': 'bool'},
        'custom_domain_verification_id': {'key': 'properties.customDomainVerificationId', 'type': 'str'},
        'outbound_ip_addresses': {'key': 'properties.outboundIpAddresses', 'type': 'str'},
        'possible_outbound_ip_addresses': {'key': 'properties.possibleOutboundIpAddresses', 'type': 'str'},
        'container_size': {'key': 'properties.containerSize', 'type': 'int'},
        'daily_memory_time_quota': {'key': 'properties.dailyMemoryTimeQuota', 'type': 'int'},
        'suspended_till': {'key': 'properties.suspendedTill', 'type': 'iso-8601'},
        'max_number_of_workers': {'key': 'properties.maxNumberOfWorkers', 'type': 'int'},
        'cloning_info': {'key': 'properties.cloningInfo', 'type': 'CloningInfo'},
        'resource_group': {'key': 'properties.resourceGroup', 'type': 'str'},
        'is_default_container': {'key': 'properties.isDefaultContainer', 'type': 'bool'},
        'default_host_name': {'key': 'properties.defaultHostName', 'type': 'str'},
        'slot_swap_status': {'key': 'properties.slotSwapStatus', 'type': 'SlotSwapStatus'},
        'https_only': {'key': 'properties.httpsOnly', 'type': 'bool'},
        'redundancy_mode': {'key': 'properties.redundancyMode', 'type': 'str'},
        'in_progress_operation_id': {'key': 'properties.inProgressOperationId', 'type': 'str'},
        'storage_account_required': {'key': 'properties.storageAccountRequired', 'type': 'bool'},
        'key_vault_reference_identity': {'key': 'properties.keyVaultReferenceIdentity', 'type': 'str'},
        'virtual_network_subnet_id': {'key': 'properties.virtualNetworkSubnetId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Site, self).__init__(**kwargs)
        self.identity = kwargs.get('identity', None)
        self.extended_location = kwargs.get('extended_location', None)
        self.state = None
        self.host_names = None
        self.repository_site_name = None
        self.usage_state = None
        self.enabled = kwargs.get('enabled', None)
        self.enabled_host_names = None
        self.availability_state = None
        self.host_name_ssl_states = kwargs.get('host_name_ssl_states', None)
        self.server_farm_id = kwargs.get('server_farm_id', None)
        self.reserved = kwargs.get('reserved', False)
        self.is_xenon = kwargs.get('is_xenon', False)
        self.hyper_v = kwargs.get('hyper_v', False)
        self.last_modified_time_utc = None
        self.site_config = kwargs.get('site_config', None)
        self.traffic_manager_host_names = None
        self.scm_site_also_stopped = kwargs.get('scm_site_also_stopped', False)
        self.target_swap_slot = None
        self.hosting_environment_profile = kwargs.get('hosting_environment_profile', None)
        self.client_affinity_enabled = kwargs.get('client_affinity_enabled', None)
        self.client_cert_enabled = kwargs.get('client_cert_enabled', None)
        self.client_cert_mode = kwargs.get('client_cert_mode', None)
        self.client_cert_exclusion_paths = kwargs.get('client_cert_exclusion_paths', None)
        self.host_names_disabled = kwargs.get('host_names_disabled', None)
        self.custom_domain_verification_id = kwargs.get('custom_domain_verification_id', None)
        self.outbound_ip_addresses = None
        self.possible_outbound_ip_addresses = None
        self.container_size = kwargs.get('container_size', None)
        self.daily_memory_time_quota = kwargs.get('daily_memory_time_quota', None)
        self.suspended_till = None
        self.max_number_of_workers = None
        self.cloning_info = kwargs.get('cloning_info', None)
        self.resource_group = None
        self.is_default_container = None
        self.default_host_name = None
        self.slot_swap_status = None
        self.https_only = kwargs.get('https_only', None)
        self.redundancy_mode = kwargs.get('redundancy_mode', None)
        self.in_progress_operation_id = None
        self.storage_account_required = kwargs.get('storage_account_required', None)
        self.key_vault_reference_identity = kwargs.get('key_vault_reference_identity', None)
        self.virtual_network_subnet_id = kwargs.get('virtual_network_subnet_id', None)


class SiteAuthSettings(ProxyOnlyResource):
    """Configuration settings for the Azure App Service Authentication / Authorization feature.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param enabled: :code:`<code>true</code>` if the Authentication / Authorization feature is
     enabled for the current app; otherwise, :code:`<code>false</code>`.
    :type enabled: bool
    :param runtime_version: The RuntimeVersion of the Authentication / Authorization feature in use
     for the current app.
     The setting in this value can control the behavior of certain features in the Authentication /
     Authorization module.
    :type runtime_version: str
    :param unauthenticated_client_action: The action to take when an unauthenticated client
     attempts to access the app. Possible values include: "RedirectToLoginPage", "AllowAnonymous".
    :type unauthenticated_client_action: str or
     ~azure.mgmt.web.v2021_01_01.models.UnauthenticatedClientAction
    :param token_store_enabled: :code:`<code>true</code>` to durably store platform-specific
     security tokens that are obtained during login flows; otherwise, :code:`<code>false</code>`.
      The default is :code:`<code>false</code>`.
    :type token_store_enabled: bool
    :param allowed_external_redirect_urls: External URLs that can be redirected to as part of
     logging in or logging out of the app. Note that the query string part of the URL is ignored.
     This is an advanced setting typically only needed by Windows Store application backends.
     Note that URLs within the current domain are always implicitly allowed.
    :type allowed_external_redirect_urls: list[str]
    :param default_provider: The default authentication provider to use when multiple providers are
     configured.
     This setting is only needed if multiple providers are configured and the unauthenticated
     client
     action is set to "RedirectToLoginPage". Possible values include: "AzureActiveDirectory",
     "Facebook", "Google", "MicrosoftAccount", "Twitter", "Github".
    :type default_provider: str or ~azure.mgmt.web.v2021_01_01.models.BuiltInAuthenticationProvider
    :param token_refresh_extension_hours: The number of hours after session token expiration that a
     session token can be used to
     call the token refresh API. The default is 72 hours.
    :type token_refresh_extension_hours: float
    :param client_id: The Client ID of this relying party application, known as the client_id.
     This setting is required for enabling OpenID Connection authentication with Azure Active
     Directory or
     other 3rd party OpenID Connect providers.
     More information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html.
    :type client_id: str
    :param client_secret: The Client Secret of this relying party application (in Azure Active
     Directory, this is also referred to as the Key).
     This setting is optional. If no client secret is configured, the OpenID Connect implicit auth
     flow is used to authenticate end users.
     Otherwise, the OpenID Connect Authorization Code Flow is used to authenticate end users.
     More information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html.
    :type client_secret: str
    :param client_secret_setting_name: The app setting name that contains the client secret of the
     relying party application.
    :type client_secret_setting_name: str
    :param client_secret_certificate_thumbprint: An alternative to the client secret, that is the
     thumbprint of a certificate used for signing purposes. This property acts as
     a replacement for the Client Secret. It is also optional.
    :type client_secret_certificate_thumbprint: str
    :param issuer: The OpenID Connect Issuer URI that represents the entity which issues access
     tokens for this application.
     When using Azure Active Directory, this value is the URI of the directory tenant, e.g.
     https://sts.windows.net/{tenant-guid}/.
     This URI is a case-sensitive identifier for the token issuer.
     More information on OpenID Connect Discovery:
     http://openid.net/specs/openid-connect-discovery-1_0.html.
    :type issuer: str
    :param validate_issuer: Gets a value indicating whether the issuer should be a valid HTTPS url
     and be validated as such.
    :type validate_issuer: bool
    :param allowed_audiences: Allowed audience values to consider when validating JWTs issued by
     Azure Active Directory. Note that the :code:`<code>ClientID</code>` value is always considered
     an
     allowed audience, regardless of this setting.
    :type allowed_audiences: list[str]
    :param additional_login_params: Login parameters to send to the OpenID Connect authorization
     endpoint when
     a user logs in. Each parameter must be in the form "key=value".
    :type additional_login_params: list[str]
    :param aad_claims_authorization: Gets a JSON string containing the Azure AD Acl settings.
    :type aad_claims_authorization: str
    :param google_client_id: The OpenID Connect Client ID for the Google web application.
     This setting is required for enabling Google Sign-In.
     Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/.
    :type google_client_id: str
    :param google_client_secret: The client secret associated with the Google web application.
     This setting is required for enabling Google Sign-In.
     Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/.
    :type google_client_secret: str
    :param google_client_secret_setting_name: The app setting name that contains the client secret
     associated with
     the Google web application.
    :type google_client_secret_setting_name: str
    :param google_o_auth_scopes: The OAuth 2.0 scopes that will be requested as part of Google
     Sign-In authentication.
     This setting is optional. If not specified, "openid", "profile", and "email" are used as
     default scopes.
     Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/.
    :type google_o_auth_scopes: list[str]
    :param facebook_app_id: The App ID of the Facebook app used for login.
     This setting is required for enabling Facebook Login.
     Facebook Login documentation: https://developers.facebook.com/docs/facebook-login.
    :type facebook_app_id: str
    :param facebook_app_secret: The App Secret of the Facebook app used for Facebook Login.
     This setting is required for enabling Facebook Login.
     Facebook Login documentation: https://developers.facebook.com/docs/facebook-login.
    :type facebook_app_secret: str
    :param facebook_app_secret_setting_name: The app setting name that contains the app secret used
     for Facebook Login.
    :type facebook_app_secret_setting_name: str
    :param facebook_o_auth_scopes: The OAuth 2.0 scopes that will be requested as part of Facebook
     Login authentication.
     This setting is optional.
     Facebook Login documentation: https://developers.facebook.com/docs/facebook-login.
    :type facebook_o_auth_scopes: list[str]
    :param git_hub_client_id: The Client Id of the GitHub app used for login.
     This setting is required for enabling Github login.
    :type git_hub_client_id: str
    :param git_hub_client_secret: The Client Secret of the GitHub app used for Github Login.
     This setting is required for enabling Github login.
    :type git_hub_client_secret: str
    :param git_hub_client_secret_setting_name: The app setting name that contains the client secret
     of the Github
     app used for GitHub Login.
    :type git_hub_client_secret_setting_name: str
    :param git_hub_o_auth_scopes: The OAuth 2.0 scopes that will be requested as part of GitHub
     Login authentication.
     This setting is optional.
    :type git_hub_o_auth_scopes: list[str]
    :param twitter_consumer_key: The OAuth 1.0a consumer key of the Twitter application used for
     sign-in.
     This setting is required for enabling Twitter Sign-In.
     Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in.
    :type twitter_consumer_key: str
    :param twitter_consumer_secret: The OAuth 1.0a consumer secret of the Twitter application used
     for sign-in.
     This setting is required for enabling Twitter Sign-In.
     Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in.
    :type twitter_consumer_secret: str
    :param twitter_consumer_secret_setting_name: The app setting name that contains the OAuth 1.0a
     consumer secret of the Twitter
     application used for sign-in.
    :type twitter_consumer_secret_setting_name: str
    :param microsoft_account_client_id: The OAuth 2.0 client ID that was created for the app used
     for authentication.
     This setting is required for enabling Microsoft Account authentication.
     Microsoft Account OAuth documentation: https://dev.onedrive.com/auth/msa_oauth.htm.
    :type microsoft_account_client_id: str
    :param microsoft_account_client_secret: The OAuth 2.0 client secret that was created for the
     app used for authentication.
     This setting is required for enabling Microsoft Account authentication.
     Microsoft Account OAuth documentation: https://dev.onedrive.com/auth/msa_oauth.htm.
    :type microsoft_account_client_secret: str
    :param microsoft_account_client_secret_setting_name: The app setting name containing the OAuth
     2.0 client secret that was created for the
     app used for authentication.
    :type microsoft_account_client_secret_setting_name: str
    :param microsoft_account_o_auth_scopes: The OAuth 2.0 scopes that will be requested as part of
     Microsoft Account authentication.
     This setting is optional. If not specified, "wl.basic" is used as the default scope.
     Microsoft Account Scopes and permissions documentation:
     https://msdn.microsoft.com/en-us/library/dn631845.aspx.
    :type microsoft_account_o_auth_scopes: list[str]
    :param is_auth_from_file: "true" if the auth config settings should be read from a file,
     "false" otherwise.
    :type is_auth_from_file: str
    :param auth_file_path: The path of the config file containing auth settings.
     If the path is relative, base will the site's root directory.
    :type auth_file_path: str
    :param config_version: The ConfigVersion of the Authentication / Authorization feature in use
     for the current app.
     The setting in this value can control the behavior of the control plane for Authentication /
     Authorization.
    :type config_version: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'runtime_version': {'key': 'properties.runtimeVersion', 'type': 'str'},
        'unauthenticated_client_action': {'key': 'properties.unauthenticatedClientAction', 'type': 'str'},
        'token_store_enabled': {'key': 'properties.tokenStoreEnabled', 'type': 'bool'},
        'allowed_external_redirect_urls': {'key': 'properties.allowedExternalRedirectUrls', 'type': '[str]'},
        'default_provider': {'key': 'properties.defaultProvider', 'type': 'str'},
        'token_refresh_extension_hours': {'key': 'properties.tokenRefreshExtensionHours', 'type': 'float'},
        'client_id': {'key': 'properties.clientId', 'type': 'str'},
        'client_secret': {'key': 'properties.clientSecret', 'type': 'str'},
        'client_secret_setting_name': {'key': 'properties.clientSecretSettingName', 'type': 'str'},
        'client_secret_certificate_thumbprint': {'key': 'properties.clientSecretCertificateThumbprint', 'type': 'str'},
        'issuer': {'key': 'properties.issuer', 'type': 'str'},
        'validate_issuer': {'key': 'properties.validateIssuer', 'type': 'bool'},
        'allowed_audiences': {'key': 'properties.allowedAudiences', 'type': '[str]'},
        'additional_login_params': {'key': 'properties.additionalLoginParams', 'type': '[str]'},
        'aad_claims_authorization': {'key': 'properties.aadClaimsAuthorization', 'type': 'str'},
        'google_client_id': {'key': 'properties.googleClientId', 'type': 'str'},
        'google_client_secret': {'key': 'properties.googleClientSecret', 'type': 'str'},
        'google_client_secret_setting_name': {'key': 'properties.googleClientSecretSettingName', 'type': 'str'},
        'google_o_auth_scopes': {'key': 'properties.googleOAuthScopes', 'type': '[str]'},
        'facebook_app_id': {'key': 'properties.facebookAppId', 'type': 'str'},
        'facebook_app_secret': {'key': 'properties.facebookAppSecret', 'type': 'str'},
        'facebook_app_secret_setting_name': {'key': 'properties.facebookAppSecretSettingName', 'type': 'str'},
        'facebook_o_auth_scopes': {'key': 'properties.facebookOAuthScopes', 'type': '[str]'},
        'git_hub_client_id': {'key': 'properties.gitHubClientId', 'type': 'str'},
        'git_hub_client_secret': {'key': 'properties.gitHubClientSecret', 'type': 'str'},
        'git_hub_client_secret_setting_name': {'key': 'properties.gitHubClientSecretSettingName', 'type': 'str'},
        'git_hub_o_auth_scopes': {'key': 'properties.gitHubOAuthScopes', 'type': '[str]'},
        'twitter_consumer_key': {'key': 'properties.twitterConsumerKey', 'type': 'str'},
        'twitter_consumer_secret': {'key': 'properties.twitterConsumerSecret', 'type': 'str'},
        'twitter_consumer_secret_setting_name': {'key': 'properties.twitterConsumerSecretSettingName', 'type': 'str'},
        'microsoft_account_client_id': {'key': 'properties.microsoftAccountClientId', 'type': 'str'},
        'microsoft_account_client_secret': {'key': 'properties.microsoftAccountClientSecret', 'type': 'str'},
        'microsoft_account_client_secret_setting_name': {'key': 'properties.microsoftAccountClientSecretSettingName', 'type': 'str'},
        'microsoft_account_o_auth_scopes': {'key': 'properties.microsoftAccountOAuthScopes', 'type': '[str]'},
        'is_auth_from_file': {'key': 'properties.isAuthFromFile', 'type': 'str'},
        'auth_file_path': {'key': 'properties.authFilePath', 'type': 'str'},
        'config_version': {'key': 'properties.configVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SiteAuthSettings, self).__init__(**kwargs)
        self.enabled = kwargs.get('enabled', None)
        self.runtime_version = kwargs.get('runtime_version', None)
        self.unauthenticated_client_action = kwargs.get('unauthenticated_client_action', None)
        self.token_store_enabled = kwargs.get('token_store_enabled', None)
        self.allowed_external_redirect_urls = kwargs.get('allowed_external_redirect_urls', None)
        self.default_provider = kwargs.get('default_provider', None)
        self.token_refresh_extension_hours = kwargs.get('token_refresh_extension_hours', None)
        self.client_id = kwargs.get('client_id', None)
        self.client_secret = kwargs.get('client_secret', None)
        self.client_secret_setting_name = kwargs.get('client_secret_setting_name', None)
        self.client_secret_certificate_thumbprint = kwargs.get('client_secret_certificate_thumbprint', None)
        self.issuer = kwargs.get('issuer', None)
        self.validate_issuer = kwargs.get('validate_issuer', None)
        self.allowed_audiences = kwargs.get('allowed_audiences', None)
        self.additional_login_params = kwargs.get('additional_login_params', None)
        self.aad_claims_authorization = kwargs.get('aad_claims_authorization', None)
        self.google_client_id = kwargs.get('google_client_id', None)
        self.google_client_secret = kwargs.get('google_client_secret', None)
        self.google_client_secret_setting_name = kwargs.get('google_client_secret_setting_name', None)
        self.google_o_auth_scopes = kwargs.get('google_o_auth_scopes', None)
        self.facebook_app_id = kwargs.get('facebook_app_id', None)
        self.facebook_app_secret = kwargs.get('facebook_app_secret', None)
        self.facebook_app_secret_setting_name = kwargs.get('facebook_app_secret_setting_name', None)
        self.facebook_o_auth_scopes = kwargs.get('facebook_o_auth_scopes', None)
        self.git_hub_client_id = kwargs.get('git_hub_client_id', None)
        self.git_hub_client_secret = kwargs.get('git_hub_client_secret', None)
        self.git_hub_client_secret_setting_name = kwargs.get('git_hub_client_secret_setting_name', None)
        self.git_hub_o_auth_scopes = kwargs.get('git_hub_o_auth_scopes', None)
        self.twitter_consumer_key = kwargs.get('twitter_consumer_key', None)
        self.twitter_consumer_secret = kwargs.get('twitter_consumer_secret', None)
        self.twitter_consumer_secret_setting_name = kwargs.get('twitter_consumer_secret_setting_name', None)
        self.microsoft_account_client_id = kwargs.get('microsoft_account_client_id', None)
        self.microsoft_account_client_secret = kwargs.get('microsoft_account_client_secret', None)
        self.microsoft_account_client_secret_setting_name = kwargs.get('microsoft_account_client_secret_setting_name', None)
        self.microsoft_account_o_auth_scopes = kwargs.get('microsoft_account_o_auth_scopes', None)
        self.is_auth_from_file = kwargs.get('is_auth_from_file', None)
        self.auth_file_path = kwargs.get('auth_file_path', None)
        self.config_version = kwargs.get('config_version', None)


class SiteAuthSettingsV2(ProxyOnlyResource):
    """Configuration settings for the Azure App Service Authentication / Authorization V2 feature.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param platform: The configuration settings of the platform of App Service
     Authentication/Authorization.
    :type platform: ~azure.mgmt.web.v2021_01_01.models.AuthPlatform
    :param global_validation: The configuration settings that determines the validation flow of
     users using App Service Authentication/Authorization.
    :type global_validation: ~azure.mgmt.web.v2021_01_01.models.GlobalValidation
    :param identity_providers: The configuration settings of each of the identity providers used to
     configure App Service Authentication/Authorization.
    :type identity_providers: ~azure.mgmt.web.v2021_01_01.models.IdentityProviders
    :param login: The configuration settings of the login flow of users using App Service
     Authentication/Authorization.
    :type login: ~azure.mgmt.web.v2021_01_01.models.Login
    :param http_settings: The configuration settings of the HTTP requests for authentication and
     authorization requests made against App Service Authentication/Authorization.
    :type http_settings: ~azure.mgmt.web.v2021_01_01.models.HttpSettings
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'platform': {'key': 'properties.platform', 'type': 'AuthPlatform'},
        'global_validation': {'key': 'properties.globalValidation', 'type': 'GlobalValidation'},
        'identity_providers': {'key': 'properties.identityProviders', 'type': 'IdentityProviders'},
        'login': {'key': 'properties.login', 'type': 'Login'},
        'http_settings': {'key': 'properties.httpSettings', 'type': 'HttpSettings'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SiteAuthSettingsV2, self).__init__(**kwargs)
        self.platform = kwargs.get('platform', None)
        self.global_validation = kwargs.get('global_validation', None)
        self.identity_providers = kwargs.get('identity_providers', None)
        self.login = kwargs.get('login', None)
        self.http_settings = kwargs.get('http_settings', None)


class SiteCloneability(msrest.serialization.Model):
    """Represents whether or not an app is cloneable.

    :param result: Name of app. Possible values include: "Cloneable", "PartiallyCloneable",
     "NotCloneable".
    :type result: str or ~azure.mgmt.web.v2021_01_01.models.CloneAbilityResult
    :param blocking_features: List of features enabled on app that prevent cloning.
    :type blocking_features: list[~azure.mgmt.web.v2021_01_01.models.SiteCloneabilityCriterion]
    :param unsupported_features: List of features enabled on app that are non-blocking but cannot
     be cloned. The app can still be cloned
     but the features in this list will not be set up on cloned app.
    :type unsupported_features: list[~azure.mgmt.web.v2021_01_01.models.SiteCloneabilityCriterion]
    :param blocking_characteristics: List of blocking application characteristics.
    :type blocking_characteristics:
     list[~azure.mgmt.web.v2021_01_01.models.SiteCloneabilityCriterion]
    """

    _attribute_map = {
        'result': {'key': 'result', 'type': 'str'},
        'blocking_features': {'key': 'blockingFeatures', 'type': '[SiteCloneabilityCriterion]'},
        'unsupported_features': {'key': 'unsupportedFeatures', 'type': '[SiteCloneabilityCriterion]'},
        'blocking_characteristics': {'key': 'blockingCharacteristics', 'type': '[SiteCloneabilityCriterion]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SiteCloneability, self).__init__(**kwargs)
        self.result = kwargs.get('result', None)
        self.blocking_features = kwargs.get('blocking_features', None)
        self.unsupported_features = kwargs.get('unsupported_features', None)
        self.blocking_characteristics = kwargs.get('blocking_characteristics', None)


class SiteCloneabilityCriterion(msrest.serialization.Model):
    """An app cloneability criterion.

    :param name: Name of criterion.
    :type name: str
    :param description: Description of criterion.
    :type description: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SiteCloneabilityCriterion, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.description = kwargs.get('description', None)


class SiteConfig(msrest.serialization.Model):
    """Configuration of an App Service app.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param number_of_workers: Number of workers.
    :type number_of_workers: int
    :param default_documents: Default documents.
    :type default_documents: list[str]
    :param net_framework_version: .NET Framework version.
    :type net_framework_version: str
    :param php_version: Version of PHP.
    :type php_version: str
    :param python_version: Version of Python.
    :type python_version: str
    :param node_version: Version of Node.js.
    :type node_version: str
    :param power_shell_version: Version of PowerShell.
    :type power_shell_version: str
    :param linux_fx_version: Linux App Framework and version.
    :type linux_fx_version: str
    :param windows_fx_version: Xenon App Framework and version.
    :type windows_fx_version: str
    :param request_tracing_enabled: :code:`<code>true</code>` if request tracing is enabled;
     otherwise, :code:`<code>false</code>`.
    :type request_tracing_enabled: bool
    :param request_tracing_expiration_time: Request tracing expiration time.
    :type request_tracing_expiration_time: ~datetime.datetime
    :param remote_debugging_enabled: :code:`<code>true</code>` if remote debugging is enabled;
     otherwise, :code:`<code>false</code>`.
    :type remote_debugging_enabled: bool
    :param remote_debugging_version: Remote debugging version.
    :type remote_debugging_version: str
    :param http_logging_enabled: :code:`<code>true</code>` if HTTP logging is enabled; otherwise,
     :code:`<code>false</code>`.
    :type http_logging_enabled: bool
    :param acr_use_managed_identity_creds: Flag to use Managed Identity Creds for ACR pull.
    :type acr_use_managed_identity_creds: bool
    :param acr_user_managed_identity_id: If using user managed identity, the user managed identity
     ClientId.
    :type acr_user_managed_identity_id: str
    :param logs_directory_size_limit: HTTP logs directory size limit.
    :type logs_directory_size_limit: int
    :param detailed_error_logging_enabled: :code:`<code>true</code>` if detailed error logging is
     enabled; otherwise, :code:`<code>false</code>`.
    :type detailed_error_logging_enabled: bool
    :param publishing_username: Publishing user name.
    :type publishing_username: str
    :param app_settings: Application settings.
    :type app_settings: list[~azure.mgmt.web.v2021_01_01.models.NameValuePair]
    :param connection_strings: Connection strings.
    :type connection_strings: list[~azure.mgmt.web.v2021_01_01.models.ConnStringInfo]
    :ivar machine_key: Site MachineKey.
    :vartype machine_key: ~azure.mgmt.web.v2021_01_01.models.SiteMachineKey
    :param handler_mappings: Handler mappings.
    :type handler_mappings: list[~azure.mgmt.web.v2021_01_01.models.HandlerMapping]
    :param document_root: Document root.
    :type document_root: str
    :param scm_type: SCM type. Possible values include: "None", "Dropbox", "Tfs", "LocalGit",
     "GitHub", "CodePlexGit", "CodePlexHg", "BitbucketGit", "BitbucketHg", "ExternalGit",
     "ExternalHg", "OneDrive", "VSO", "VSTSRM".
    :type scm_type: str or ~azure.mgmt.web.v2021_01_01.models.ScmType
    :param use32_bit_worker_process: :code:`<code>true</code>` to use 32-bit worker process;
     otherwise, :code:`<code>false</code>`.
    :type use32_bit_worker_process: bool
    :param web_sockets_enabled: :code:`<code>true</code>` if WebSocket is enabled; otherwise,
     :code:`<code>false</code>`.
    :type web_sockets_enabled: bool
    :param always_on: :code:`<code>true</code>` if Always On is enabled; otherwise,
     :code:`<code>false</code>`.
    :type always_on: bool
    :param java_version: Java version.
    :type java_version: str
    :param java_container: Java container.
    :type java_container: str
    :param java_container_version: Java container version.
    :type java_container_version: str
    :param app_command_line: App command line to launch.
    :type app_command_line: str
    :param managed_pipeline_mode: Managed pipeline mode. Possible values include: "Integrated",
     "Classic".
    :type managed_pipeline_mode: str or ~azure.mgmt.web.v2021_01_01.models.ManagedPipelineMode
    :param virtual_applications: Virtual applications.
    :type virtual_applications: list[~azure.mgmt.web.v2021_01_01.models.VirtualApplication]
    :param load_balancing: Site load balancing. Possible values include: "WeightedRoundRobin",
     "LeastRequests", "LeastResponseTime", "WeightedTotalTraffic", "RequestHash",
     "PerSiteRoundRobin".
    :type load_balancing: str or ~azure.mgmt.web.v2021_01_01.models.SiteLoadBalancing
    :param experiments: This is work around for polymorphic types.
    :type experiments: ~azure.mgmt.web.v2021_01_01.models.Experiments
    :param limits: Site limits.
    :type limits: ~azure.mgmt.web.v2021_01_01.models.SiteLimits
    :param auto_heal_enabled: :code:`<code>true</code>` if Auto Heal is enabled; otherwise,
     :code:`<code>false</code>`.
    :type auto_heal_enabled: bool
    :param auto_heal_rules: Auto Heal rules.
    :type auto_heal_rules: ~azure.mgmt.web.v2021_01_01.models.AutoHealRules
    :param tracing_options: Tracing options.
    :type tracing_options: str
    :param vnet_name: Virtual Network name.
    :type vnet_name: str
    :param vnet_route_all_enabled: Virtual Network Route All enabled. This causes all outbound
     traffic to have Virtual Network Security Groups and User Defined Routes applied.
    :type vnet_route_all_enabled: bool
    :param vnet_private_ports_count: The number of private ports assigned to this app. These will
     be assigned dynamically on runtime.
    :type vnet_private_ports_count: int
    :param cors: Cross-Origin Resource Sharing (CORS) settings.
    :type cors: ~azure.mgmt.web.v2021_01_01.models.CorsSettings
    :param push: Push endpoint settings.
    :type push: ~azure.mgmt.web.v2021_01_01.models.PushSettings
    :param api_definition: Information about the formal API definition for the app.
    :type api_definition: ~azure.mgmt.web.v2021_01_01.models.ApiDefinitionInfo
    :param api_management_config: Azure API management settings linked to the app.
    :type api_management_config: ~azure.mgmt.web.v2021_01_01.models.ApiManagementConfig
    :param auto_swap_slot_name: Auto-swap slot name.
    :type auto_swap_slot_name: str
    :param local_my_sql_enabled: :code:`<code>true</code>` to enable local MySQL; otherwise,
     :code:`<code>false</code>`.
    :type local_my_sql_enabled: bool
    :param managed_service_identity_id: Managed Service Identity Id.
    :type managed_service_identity_id: int
    :param x_managed_service_identity_id: Explicit Managed Service Identity Id.
    :type x_managed_service_identity_id: int
    :param key_vault_reference_identity: Identity to use for Key Vault Reference authentication.
    :type key_vault_reference_identity: str
    :param ip_security_restrictions: IP security restrictions for main.
    :type ip_security_restrictions: list[~azure.mgmt.web.v2021_01_01.models.IpSecurityRestriction]
    :param scm_ip_security_restrictions: IP security restrictions for scm.
    :type scm_ip_security_restrictions:
     list[~azure.mgmt.web.v2021_01_01.models.IpSecurityRestriction]
    :param scm_ip_security_restrictions_use_main: IP security restrictions for scm to use main.
    :type scm_ip_security_restrictions_use_main: bool
    :param http20_enabled: Http20Enabled: configures a web site to allow clients to connect over
     http2.0.
    :type http20_enabled: bool
    :param min_tls_version: MinTlsVersion: configures the minimum version of TLS required for SSL
     requests. Possible values include: "1.0", "1.1", "1.2".
    :type min_tls_version: str or ~azure.mgmt.web.v2021_01_01.models.SupportedTlsVersions
    :param scm_min_tls_version: ScmMinTlsVersion: configures the minimum version of TLS required
     for SSL requests for SCM site. Possible values include: "1.0", "1.1", "1.2".
    :type scm_min_tls_version: str or ~azure.mgmt.web.v2021_01_01.models.SupportedTlsVersions
    :param ftps_state: State of FTP / FTPS service. Possible values include: "AllAllowed",
     "FtpsOnly", "Disabled".
    :type ftps_state: str or ~azure.mgmt.web.v2021_01_01.models.FtpsState
    :param pre_warmed_instance_count: Number of preWarmed instances.
     This setting only applies to the Consumption and Elastic Plans.
    :type pre_warmed_instance_count: int
    :param function_app_scale_limit: Maximum number of workers that a site can scale out to.
     This setting only applies to the Consumption and Elastic Premium Plans.
    :type function_app_scale_limit: int
    :param health_check_path: Health check path.
    :type health_check_path: str
    :param functions_runtime_scale_monitoring_enabled: Gets or sets a value indicating whether
     functions runtime scale monitoring is enabled. When enabled,
     the ScaleController will not monitor event sources directly, but will instead call to the
     runtime to get scale status.
    :type functions_runtime_scale_monitoring_enabled: bool
    :param website_time_zone: Sets the time zone a site uses for generating timestamps. Compatible
     with Linux and Windows App Service. Setting the WEBSITE_TIME_ZONE app setting takes precedence
     over this config. For Linux, expects tz database values https://www.iana.org/time-zones (for a
     quick reference see https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). For Windows,
     expects one of the time zones listed under HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows
     NT\CurrentVersion\Time Zones.
    :type website_time_zone: str
    :param minimum_elastic_instance_count: Number of minimum instance count for a site
     This setting only applies to the Elastic Plans.
    :type minimum_elastic_instance_count: int
    :param azure_storage_accounts: List of Azure Storage Accounts.
    :type azure_storage_accounts: dict[str,
     ~azure.mgmt.web.v2021_01_01.models.AzureStorageInfoValue]
    :param public_network_access: Property to allow or block all public traffic.
    :type public_network_access: str
    """

    _validation = {
        'machine_key': {'readonly': True},
        'pre_warmed_instance_count': {'maximum': 10, 'minimum': 0},
        'function_app_scale_limit': {'minimum': 0},
        'minimum_elastic_instance_count': {'maximum': 20, 'minimum': 0},
    }

    _attribute_map = {
        'number_of_workers': {'key': 'numberOfWorkers', 'type': 'int'},
        'default_documents': {'key': 'defaultDocuments', 'type': '[str]'},
        'net_framework_version': {'key': 'netFrameworkVersion', 'type': 'str'},
        'php_version': {'key': 'phpVersion', 'type': 'str'},
        'python_version': {'key': 'pythonVersion', 'type': 'str'},
        'node_version': {'key': 'nodeVersion', 'type': 'str'},
        'power_shell_version': {'key': 'powerShellVersion', 'type': 'str'},
        'linux_fx_version': {'key': 'linuxFxVersion', 'type': 'str'},
        'windows_fx_version': {'key': 'windowsFxVersion', 'type': 'str'},
        'request_tracing_enabled': {'key': 'requestTracingEnabled', 'type': 'bool'},
        'request_tracing_expiration_time': {'key': 'requestTracingExpirationTime', 'type': 'iso-8601'},
        'remote_debugging_enabled': {'key': 'remoteDebuggingEnabled', 'type': 'bool'},
        'remote_debugging_version': {'key': 'remoteDebuggingVersion', 'type': 'str'},
        'http_logging_enabled': {'key': 'httpLoggingEnabled', 'type': 'bool'},
        'acr_use_managed_identity_creds': {'key': 'acrUseManagedIdentityCreds', 'type': 'bool'},
        'acr_user_managed_identity_id': {'key': 'acrUserManagedIdentityID', 'type': 'str'},
        'logs_directory_size_limit': {'key': 'logsDirectorySizeLimit', 'type': 'int'},
        'detailed_error_logging_enabled': {'key': 'detailedErrorLoggingEnabled', 'type': 'bool'},
        'publishing_username': {'key': 'publishingUsername', 'type': 'str'},
        'app_settings': {'key': 'appSettings', 'type': '[NameValuePair]'},
        'connection_strings': {'key': 'connectionStrings', 'type': '[ConnStringInfo]'},
        'machine_key': {'key': 'machineKey', 'type': 'SiteMachineKey'},
        'handler_mappings': {'key': 'handlerMappings', 'type': '[HandlerMapping]'},
        'document_root': {'key': 'documentRoot', 'type': 'str'},
        'scm_type': {'key': 'scmType', 'type': 'str'},
        'use32_bit_worker_process': {'key': 'use32BitWorkerProcess', 'type': 'bool'},
        'web_sockets_enabled': {'key': 'webSocketsEnabled', 'type': 'bool'},
        'always_on': {'key': 'alwaysOn', 'type': 'bool'},
        'java_version': {'key': 'javaVersion', 'type': 'str'},
        'java_container': {'key': 'javaContainer', 'type': 'str'},
        'java_container_version': {'key': 'javaContainerVersion', 'type': 'str'},
        'app_command_line': {'key': 'appCommandLine', 'type': 'str'},
        'managed_pipeline_mode': {'key': 'managedPipelineMode', 'type': 'str'},
        'virtual_applications': {'key': 'virtualApplications', 'type': '[VirtualApplication]'},
        'load_balancing': {'key': 'loadBalancing', 'type': 'str'},
        'experiments': {'key': 'experiments', 'type': 'Experiments'},
        'limits': {'key': 'limits', 'type': 'SiteLimits'},
        'auto_heal_enabled': {'key': 'autoHealEnabled', 'type': 'bool'},
        'auto_heal_rules': {'key': 'autoHealRules', 'type': 'AutoHealRules'},
        'tracing_options': {'key': 'tracingOptions', 'type': 'str'},
        'vnet_name': {'key': 'vnetName', 'type': 'str'},
        'vnet_route_all_enabled': {'key': 'vnetRouteAllEnabled', 'type': 'bool'},
        'vnet_private_ports_count': {'key': 'vnetPrivatePortsCount', 'type': 'int'},
        'cors': {'key': 'cors', 'type': 'CorsSettings'},
        'push': {'key': 'push', 'type': 'PushSettings'},
        'api_definition': {'key': 'apiDefinition', 'type': 'ApiDefinitionInfo'},
        'api_management_config': {'key': 'apiManagementConfig', 'type': 'ApiManagementConfig'},
        'auto_swap_slot_name': {'key': 'autoSwapSlotName', 'type': 'str'},
        'local_my_sql_enabled': {'key': 'localMySqlEnabled', 'type': 'bool'},
        'managed_service_identity_id': {'key': 'managedServiceIdentityId', 'type': 'int'},
        'x_managed_service_identity_id': {'key': 'xManagedServiceIdentityId', 'type': 'int'},
        'key_vault_reference_identity': {'key': 'keyVaultReferenceIdentity', 'type': 'str'},
        'ip_security_restrictions': {'key': 'ipSecurityRestrictions', 'type': '[IpSecurityRestriction]'},
        'scm_ip_security_restrictions': {'key': 'scmIpSecurityRestrictions', 'type': '[IpSecurityRestriction]'},
        'scm_ip_security_restrictions_use_main': {'key': 'scmIpSecurityRestrictionsUseMain', 'type': 'bool'},
        'http20_enabled': {'key': 'http20Enabled', 'type': 'bool'},
        'min_tls_version': {'key': 'minTlsVersion', 'type': 'str'},
        'scm_min_tls_version': {'key': 'scmMinTlsVersion', 'type': 'str'},
        'ftps_state': {'key': 'ftpsState', 'type': 'str'},
        'pre_warmed_instance_count': {'key': 'preWarmedInstanceCount', 'type': 'int'},
        'function_app_scale_limit': {'key': 'functionAppScaleLimit', 'type': 'int'},
        'health_check_path': {'key': 'healthCheckPath', 'type': 'str'},
        'functions_runtime_scale_monitoring_enabled': {'key': 'functionsRuntimeScaleMonitoringEnabled', 'type': 'bool'},
        'website_time_zone': {'key': 'websiteTimeZone', 'type': 'str'},
        'minimum_elastic_instance_count': {'key': 'minimumElasticInstanceCount', 'type': 'int'},
        'azure_storage_accounts': {'key': 'azureStorageAccounts', 'type': '{AzureStorageInfoValue}'},
        'public_network_access': {'key': 'publicNetworkAccess', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SiteConfig, self).__init__(**kwargs)
        self.number_of_workers = kwargs.get('number_of_workers', None)
        self.default_documents = kwargs.get('default_documents', None)
        self.net_framework_version = kwargs.get('net_framework_version', "v4.6")
        self.php_version = kwargs.get('php_version', None)
        self.python_version = kwargs.get('python_version', None)
        self.node_version = kwargs.get('node_version', None)
        self.power_shell_version = kwargs.get('power_shell_version', None)
        self.linux_fx_version = kwargs.get('linux_fx_version', None)
        self.windows_fx_version = kwargs.get('windows_fx_version', None)
        self.request_tracing_enabled = kwargs.get('request_tracing_enabled', None)
        self.request_tracing_expiration_time = kwargs.get('request_tracing_expiration_time', None)
        self.remote_debugging_enabled = kwargs.get('remote_debugging_enabled', None)
        self.remote_debugging_version = kwargs.get('remote_debugging_version', None)
        self.http_logging_enabled = kwargs.get('http_logging_enabled', None)
        self.acr_use_managed_identity_creds = kwargs.get('acr_use_managed_identity_creds', None)
        self.acr_user_managed_identity_id = kwargs.get('acr_user_managed_identity_id', None)
        self.logs_directory_size_limit = kwargs.get('logs_directory_size_limit', None)
        self.detailed_error_logging_enabled = kwargs.get('detailed_error_logging_enabled', None)
        self.publishing_username = kwargs.get('publishing_username', None)
        self.app_settings = kwargs.get('app_settings', None)
        self.connection_strings = kwargs.get('connection_strings', None)
        self.machine_key = None
        self.handler_mappings = kwargs.get('handler_mappings', None)
        self.document_root = kwargs.get('document_root', None)
        self.scm_type = kwargs.get('scm_type', None)
        self.use32_bit_worker_process = kwargs.get('use32_bit_worker_process', None)
        self.web_sockets_enabled = kwargs.get('web_sockets_enabled', None)
        self.always_on = kwargs.get('always_on', None)
        self.java_version = kwargs.get('java_version', None)
        self.java_container = kwargs.get('java_container', None)
        self.java_container_version = kwargs.get('java_container_version', None)
        self.app_command_line = kwargs.get('app_command_line', None)
        self.managed_pipeline_mode = kwargs.get('managed_pipeline_mode', None)
        self.virtual_applications = kwargs.get('virtual_applications', None)
        self.load_balancing = kwargs.get('load_balancing', None)
        self.experiments = kwargs.get('experiments', None)
        self.limits = kwargs.get('limits', None)
        self.auto_heal_enabled = kwargs.get('auto_heal_enabled', None)
        self.auto_heal_rules = kwargs.get('auto_heal_rules', None)
        self.tracing_options = kwargs.get('tracing_options', None)
        self.vnet_name = kwargs.get('vnet_name', None)
        self.vnet_route_all_enabled = kwargs.get('vnet_route_all_enabled', None)
        self.vnet_private_ports_count = kwargs.get('vnet_private_ports_count', None)
        self.cors = kwargs.get('cors', None)
        self.push = kwargs.get('push', None)
        self.api_definition = kwargs.get('api_definition', None)
        self.api_management_config = kwargs.get('api_management_config', None)
        self.auto_swap_slot_name = kwargs.get('auto_swap_slot_name', None)
        self.local_my_sql_enabled = kwargs.get('local_my_sql_enabled', False)
        self.managed_service_identity_id = kwargs.get('managed_service_identity_id', None)
        self.x_managed_service_identity_id = kwargs.get('x_managed_service_identity_id', None)
        self.key_vault_reference_identity = kwargs.get('key_vault_reference_identity', None)
        self.ip_security_restrictions = kwargs.get('ip_security_restrictions', None)
        self.scm_ip_security_restrictions = kwargs.get('scm_ip_security_restrictions', None)
        self.scm_ip_security_restrictions_use_main = kwargs.get('scm_ip_security_restrictions_use_main', None)
        self.http20_enabled = kwargs.get('http20_enabled', True)
        self.min_tls_version = kwargs.get('min_tls_version', None)
        self.scm_min_tls_version = kwargs.get('scm_min_tls_version', None)
        self.ftps_state = kwargs.get('ftps_state', None)
        self.pre_warmed_instance_count = kwargs.get('pre_warmed_instance_count', None)
        self.function_app_scale_limit = kwargs.get('function_app_scale_limit', None)
        self.health_check_path = kwargs.get('health_check_path', None)
        self.functions_runtime_scale_monitoring_enabled = kwargs.get('functions_runtime_scale_monitoring_enabled', None)
        self.website_time_zone = kwargs.get('website_time_zone', None)
        self.minimum_elastic_instance_count = kwargs.get('minimum_elastic_instance_count', None)
        self.azure_storage_accounts = kwargs.get('azure_storage_accounts', None)
        self.public_network_access = kwargs.get('public_network_access', None)


class SiteConfigPropertiesDictionary(msrest.serialization.Model):
    """Site config properties dictionary.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar use32_bit_worker_process: :code:`<code>true</code>` if use32BitWorkerProcess should be
     set to true for the stack; otherwise, :code:`<code>false</code>`.
    :vartype use32_bit_worker_process: bool
    :ivar linux_fx_version: LinuxFxVersion configuration setting.
    :vartype linux_fx_version: str
    :ivar java_version: JavaVersion configuration setting.
    :vartype java_version: str
    :ivar power_shell_version: PowerShellVersion configuration setting.
    :vartype power_shell_version: str
    """

    _validation = {
        'use32_bit_worker_process': {'readonly': True},
        'linux_fx_version': {'readonly': True},
        'java_version': {'readonly': True},
        'power_shell_version': {'readonly': True},
    }

    _attribute_map = {
        'use32_bit_worker_process': {'key': 'use32BitWorkerProcess', 'type': 'bool'},
        'linux_fx_version': {'key': 'linuxFxVersion', 'type': 'str'},
        'java_version': {'key': 'javaVersion', 'type': 'str'},
        'power_shell_version': {'key': 'powerShellVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SiteConfigPropertiesDictionary, self).__init__(**kwargs)
        self.use32_bit_worker_process = None
        self.linux_fx_version = None
        self.java_version = None
        self.power_shell_version = None


class SiteConfigResource(ProxyOnlyResource):
    """Web app configuration ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param number_of_workers: Number of workers.
    :type number_of_workers: int
    :param default_documents: Default documents.
    :type default_documents: list[str]
    :param net_framework_version: .NET Framework version.
    :type net_framework_version: str
    :param php_version: Version of PHP.
    :type php_version: str
    :param python_version: Version of Python.
    :type python_version: str
    :param node_version: Version of Node.js.
    :type node_version: str
    :param power_shell_version: Version of PowerShell.
    :type power_shell_version: str
    :param linux_fx_version: Linux App Framework and version.
    :type linux_fx_version: str
    :param windows_fx_version: Xenon App Framework and version.
    :type windows_fx_version: str
    :param request_tracing_enabled: :code:`<code>true</code>` if request tracing is enabled;
     otherwise, :code:`<code>false</code>`.
    :type request_tracing_enabled: bool
    :param request_tracing_expiration_time: Request tracing expiration time.
    :type request_tracing_expiration_time: ~datetime.datetime
    :param remote_debugging_enabled: :code:`<code>true</code>` if remote debugging is enabled;
     otherwise, :code:`<code>false</code>`.
    :type remote_debugging_enabled: bool
    :param remote_debugging_version: Remote debugging version.
    :type remote_debugging_version: str
    :param http_logging_enabled: :code:`<code>true</code>` if HTTP logging is enabled; otherwise,
     :code:`<code>false</code>`.
    :type http_logging_enabled: bool
    :param acr_use_managed_identity_creds: Flag to use Managed Identity Creds for ACR pull.
    :type acr_use_managed_identity_creds: bool
    :param acr_user_managed_identity_id: If using user managed identity, the user managed identity
     ClientId.
    :type acr_user_managed_identity_id: str
    :param logs_directory_size_limit: HTTP logs directory size limit.
    :type logs_directory_size_limit: int
    :param detailed_error_logging_enabled: :code:`<code>true</code>` if detailed error logging is
     enabled; otherwise, :code:`<code>false</code>`.
    :type detailed_error_logging_enabled: bool
    :param publishing_username: Publishing user name.
    :type publishing_username: str
    :param app_settings: Application settings.
    :type app_settings: list[~azure.mgmt.web.v2021_01_01.models.NameValuePair]
    :param connection_strings: Connection strings.
    :type connection_strings: list[~azure.mgmt.web.v2021_01_01.models.ConnStringInfo]
    :ivar machine_key: Site MachineKey.
    :vartype machine_key: ~azure.mgmt.web.v2021_01_01.models.SiteMachineKey
    :param handler_mappings: Handler mappings.
    :type handler_mappings: list[~azure.mgmt.web.v2021_01_01.models.HandlerMapping]
    :param document_root: Document root.
    :type document_root: str
    :param scm_type: SCM type. Possible values include: "None", "Dropbox", "Tfs", "LocalGit",
     "GitHub", "CodePlexGit", "CodePlexHg", "BitbucketGit", "BitbucketHg", "ExternalGit",
     "ExternalHg", "OneDrive", "VSO", "VSTSRM".
    :type scm_type: str or ~azure.mgmt.web.v2021_01_01.models.ScmType
    :param use32_bit_worker_process: :code:`<code>true</code>` to use 32-bit worker process;
     otherwise, :code:`<code>false</code>`.
    :type use32_bit_worker_process: bool
    :param web_sockets_enabled: :code:`<code>true</code>` if WebSocket is enabled; otherwise,
     :code:`<code>false</code>`.
    :type web_sockets_enabled: bool
    :param always_on: :code:`<code>true</code>` if Always On is enabled; otherwise,
     :code:`<code>false</code>`.
    :type always_on: bool
    :param java_version: Java version.
    :type java_version: str
    :param java_container: Java container.
    :type java_container: str
    :param java_container_version: Java container version.
    :type java_container_version: str
    :param app_command_line: App command line to launch.
    :type app_command_line: str
    :param managed_pipeline_mode: Managed pipeline mode. Possible values include: "Integrated",
     "Classic".
    :type managed_pipeline_mode: str or ~azure.mgmt.web.v2021_01_01.models.ManagedPipelineMode
    :param virtual_applications: Virtual applications.
    :type virtual_applications: list[~azure.mgmt.web.v2021_01_01.models.VirtualApplication]
    :param load_balancing: Site load balancing. Possible values include: "WeightedRoundRobin",
     "LeastRequests", "LeastResponseTime", "WeightedTotalTraffic", "RequestHash",
     "PerSiteRoundRobin".
    :type load_balancing: str or ~azure.mgmt.web.v2021_01_01.models.SiteLoadBalancing
    :param experiments: This is work around for polymorphic types.
    :type experiments: ~azure.mgmt.web.v2021_01_01.models.Experiments
    :param limits: Site limits.
    :type limits: ~azure.mgmt.web.v2021_01_01.models.SiteLimits
    :param auto_heal_enabled: :code:`<code>true</code>` if Auto Heal is enabled; otherwise,
     :code:`<code>false</code>`.
    :type auto_heal_enabled: bool
    :param auto_heal_rules: Auto Heal rules.
    :type auto_heal_rules: ~azure.mgmt.web.v2021_01_01.models.AutoHealRules
    :param tracing_options: Tracing options.
    :type tracing_options: str
    :param vnet_name: Virtual Network name.
    :type vnet_name: str
    :param vnet_route_all_enabled: Virtual Network Route All enabled. This causes all outbound
     traffic to have Virtual Network Security Groups and User Defined Routes applied.
    :type vnet_route_all_enabled: bool
    :param vnet_private_ports_count: The number of private ports assigned to this app. These will
     be assigned dynamically on runtime.
    :type vnet_private_ports_count: int
    :param cors: Cross-Origin Resource Sharing (CORS) settings.
    :type cors: ~azure.mgmt.web.v2021_01_01.models.CorsSettings
    :param push: Push endpoint settings.
    :type push: ~azure.mgmt.web.v2021_01_01.models.PushSettings
    :param api_definition: Information about the formal API definition for the app.
    :type api_definition: ~azure.mgmt.web.v2021_01_01.models.ApiDefinitionInfo
    :param api_management_config: Azure API management settings linked to the app.
    :type api_management_config: ~azure.mgmt.web.v2021_01_01.models.ApiManagementConfig
    :param auto_swap_slot_name: Auto-swap slot name.
    :type auto_swap_slot_name: str
    :param local_my_sql_enabled: :code:`<code>true</code>` to enable local MySQL; otherwise,
     :code:`<code>false</code>`.
    :type local_my_sql_enabled: bool
    :param managed_service_identity_id: Managed Service Identity Id.
    :type managed_service_identity_id: int
    :param x_managed_service_identity_id: Explicit Managed Service Identity Id.
    :type x_managed_service_identity_id: int
    :param key_vault_reference_identity: Identity to use for Key Vault Reference authentication.
    :type key_vault_reference_identity: str
    :param ip_security_restrictions: IP security restrictions for main.
    :type ip_security_restrictions: list[~azure.mgmt.web.v2021_01_01.models.IpSecurityRestriction]
    :param scm_ip_security_restrictions: IP security restrictions for scm.
    :type scm_ip_security_restrictions:
     list[~azure.mgmt.web.v2021_01_01.models.IpSecurityRestriction]
    :param scm_ip_security_restrictions_use_main: IP security restrictions for scm to use main.
    :type scm_ip_security_restrictions_use_main: bool
    :param http20_enabled: Http20Enabled: configures a web site to allow clients to connect over
     http2.0.
    :type http20_enabled: bool
    :param min_tls_version: MinTlsVersion: configures the minimum version of TLS required for SSL
     requests. Possible values include: "1.0", "1.1", "1.2".
    :type min_tls_version: str or ~azure.mgmt.web.v2021_01_01.models.SupportedTlsVersions
    :param scm_min_tls_version: ScmMinTlsVersion: configures the minimum version of TLS required
     for SSL requests for SCM site. Possible values include: "1.0", "1.1", "1.2".
    :type scm_min_tls_version: str or ~azure.mgmt.web.v2021_01_01.models.SupportedTlsVersions
    :param ftps_state: State of FTP / FTPS service. Possible values include: "AllAllowed",
     "FtpsOnly", "Disabled".
    :type ftps_state: str or ~azure.mgmt.web.v2021_01_01.models.FtpsState
    :param pre_warmed_instance_count: Number of preWarmed instances.
     This setting only applies to the Consumption and Elastic Plans.
    :type pre_warmed_instance_count: int
    :param function_app_scale_limit: Maximum number of workers that a site can scale out to.
     This setting only applies to the Consumption and Elastic Premium Plans.
    :type function_app_scale_limit: int
    :param health_check_path: Health check path.
    :type health_check_path: str
    :param functions_runtime_scale_monitoring_enabled: Gets or sets a value indicating whether
     functions runtime scale monitoring is enabled. When enabled,
     the ScaleController will not monitor event sources directly, but will instead call to the
     runtime to get scale status.
    :type functions_runtime_scale_monitoring_enabled: bool
    :param website_time_zone: Sets the time zone a site uses for generating timestamps. Compatible
     with Linux and Windows App Service. Setting the WEBSITE_TIME_ZONE app setting takes precedence
     over this config. For Linux, expects tz database values https://www.iana.org/time-zones (for a
     quick reference see https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). For Windows,
     expects one of the time zones listed under HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows
     NT\CurrentVersion\Time Zones.
    :type website_time_zone: str
    :param minimum_elastic_instance_count: Number of minimum instance count for a site
     This setting only applies to the Elastic Plans.
    :type minimum_elastic_instance_count: int
    :param azure_storage_accounts: List of Azure Storage Accounts.
    :type azure_storage_accounts: dict[str,
     ~azure.mgmt.web.v2021_01_01.models.AzureStorageInfoValue]
    :param public_network_access: Property to allow or block all public traffic.
    :type public_network_access: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'machine_key': {'readonly': True},
        'pre_warmed_instance_count': {'maximum': 10, 'minimum': 0},
        'function_app_scale_limit': {'minimum': 0},
        'minimum_elastic_instance_count': {'maximum': 20, 'minimum': 0},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'number_of_workers': {'key': 'properties.numberOfWorkers', 'type': 'int'},
        'default_documents': {'key': 'properties.defaultDocuments', 'type': '[str]'},
        'net_framework_version': {'key': 'properties.netFrameworkVersion', 'type': 'str'},
        'php_version': {'key': 'properties.phpVersion', 'type': 'str'},
        'python_version': {'key': 'properties.pythonVersion', 'type': 'str'},
        'node_version': {'key': 'properties.nodeVersion', 'type': 'str'},
        'power_shell_version': {'key': 'properties.powerShellVersion', 'type': 'str'},
        'linux_fx_version': {'key': 'properties.linuxFxVersion', 'type': 'str'},
        'windows_fx_version': {'key': 'properties.windowsFxVersion', 'type': 'str'},
        'request_tracing_enabled': {'key': 'properties.requestTracingEnabled', 'type': 'bool'},
        'request_tracing_expiration_time': {'key': 'properties.requestTracingExpirationTime', 'type': 'iso-8601'},
        'remote_debugging_enabled': {'key': 'properties.remoteDebuggingEnabled', 'type': 'bool'},
        'remote_debugging_version': {'key': 'properties.remoteDebuggingVersion', 'type': 'str'},
        'http_logging_enabled': {'key': 'properties.httpLoggingEnabled', 'type': 'bool'},
        'acr_use_managed_identity_creds': {'key': 'properties.acrUseManagedIdentityCreds', 'type': 'bool'},
        'acr_user_managed_identity_id': {'key': 'properties.acrUserManagedIdentityID', 'type': 'str'},
        'logs_directory_size_limit': {'key': 'properties.logsDirectorySizeLimit', 'type': 'int'},
        'detailed_error_logging_enabled': {'key': 'properties.detailedErrorLoggingEnabled', 'type': 'bool'},
        'publishing_username': {'key': 'properties.publishingUsername', 'type': 'str'},
        'app_settings': {'key': 'properties.appSettings', 'type': '[NameValuePair]'},
        'connection_strings': {'key': 'properties.connectionStrings', 'type': '[ConnStringInfo]'},
        'machine_key': {'key': 'properties.machineKey', 'type': 'SiteMachineKey'},
        'handler_mappings': {'key': 'properties.handlerMappings', 'type': '[HandlerMapping]'},
        'document_root': {'key': 'properties.documentRoot', 'type': 'str'},
        'scm_type': {'key': 'properties.scmType', 'type': 'str'},
        'use32_bit_worker_process': {'key': 'properties.use32BitWorkerProcess', 'type': 'bool'},
        'web_sockets_enabled': {'key': 'properties.webSocketsEnabled', 'type': 'bool'},
        'always_on': {'key': 'properties.alwaysOn', 'type': 'bool'},
        'java_version': {'key': 'properties.javaVersion', 'type': 'str'},
        'java_container': {'key': 'properties.javaContainer', 'type': 'str'},
        'java_container_version': {'key': 'properties.javaContainerVersion', 'type': 'str'},
        'app_command_line': {'key': 'properties.appCommandLine', 'type': 'str'},
        'managed_pipeline_mode': {'key': 'properties.managedPipelineMode', 'type': 'str'},
        'virtual_applications': {'key': 'properties.virtualApplications', 'type': '[VirtualApplication]'},
        'load_balancing': {'key': 'properties.loadBalancing', 'type': 'str'},
        'experiments': {'key': 'properties.experiments', 'type': 'Experiments'},
        'limits': {'key': 'properties.limits', 'type': 'SiteLimits'},
        'auto_heal_enabled': {'key': 'properties.autoHealEnabled', 'type': 'bool'},
        'auto_heal_rules': {'key': 'properties.autoHealRules', 'type': 'AutoHealRules'},
        'tracing_options': {'key': 'properties.tracingOptions', 'type': 'str'},
        'vnet_name': {'key': 'properties.vnetName', 'type': 'str'},
        'vnet_route_all_enabled': {'key': 'properties.vnetRouteAllEnabled', 'type': 'bool'},
        'vnet_private_ports_count': {'key': 'properties.vnetPrivatePortsCount', 'type': 'int'},
        'cors': {'key': 'properties.cors', 'type': 'CorsSettings'},
        'push': {'key': 'properties.push', 'type': 'PushSettings'},
        'api_definition': {'key': 'properties.apiDefinition', 'type': 'ApiDefinitionInfo'},
        'api_management_config': {'key': 'properties.apiManagementConfig', 'type': 'ApiManagementConfig'},
        'auto_swap_slot_name': {'key': 'properties.autoSwapSlotName', 'type': 'str'},
        'local_my_sql_enabled': {'key': 'properties.localMySqlEnabled', 'type': 'bool'},
        'managed_service_identity_id': {'key': 'properties.managedServiceIdentityId', 'type': 'int'},
        'x_managed_service_identity_id': {'key': 'properties.xManagedServiceIdentityId', 'type': 'int'},
        'key_vault_reference_identity': {'key': 'properties.keyVaultReferenceIdentity', 'type': 'str'},
        'ip_security_restrictions': {'key': 'properties.ipSecurityRestrictions', 'type': '[IpSecurityRestriction]'},
        'scm_ip_security_restrictions': {'key': 'properties.scmIpSecurityRestrictions', 'type': '[IpSecurityRestriction]'},
        'scm_ip_security_restrictions_use_main': {'key': 'properties.scmIpSecurityRestrictionsUseMain', 'type': 'bool'},
        'http20_enabled': {'key': 'properties.http20Enabled', 'type': 'bool'},
        'min_tls_version': {'key': 'properties.minTlsVersion', 'type': 'str'},
        'scm_min_tls_version': {'key': 'properties.scmMinTlsVersion', 'type': 'str'},
        'ftps_state': {'key': 'properties.ftpsState', 'type': 'str'},
        'pre_warmed_instance_count': {'key': 'properties.preWarmedInstanceCount', 'type': 'int'},
        'function_app_scale_limit': {'key': 'properties.functionAppScaleLimit', 'type': 'int'},
        'health_check_path': {'key': 'properties.healthCheckPath', 'type': 'str'},
        'functions_runtime_scale_monitoring_enabled': {'key': 'properties.functionsRuntimeScaleMonitoringEnabled', 'type': 'bool'},
        'website_time_zone': {'key': 'properties.websiteTimeZone', 'type': 'str'},
        'minimum_elastic_instance_count': {'key': 'properties.minimumElasticInstanceCount', 'type': 'int'},
        'azure_storage_accounts': {'key': 'properties.azureStorageAccounts', 'type': '{AzureStorageInfoValue}'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SiteConfigResource, self).__init__(**kwargs)
        self.number_of_workers = kwargs.get('number_of_workers', None)
        self.default_documents = kwargs.get('default_documents', None)
        self.net_framework_version = kwargs.get('net_framework_version', "v4.6")
        self.php_version = kwargs.get('php_version', None)
        self.python_version = kwargs.get('python_version', None)
        self.node_version = kwargs.get('node_version', None)
        self.power_shell_version = kwargs.get('power_shell_version', None)
        self.linux_fx_version = kwargs.get('linux_fx_version', None)
        self.windows_fx_version = kwargs.get('windows_fx_version', None)
        self.request_tracing_enabled = kwargs.get('request_tracing_enabled', None)
        self.request_tracing_expiration_time = kwargs.get('request_tracing_expiration_time', None)
        self.remote_debugging_enabled = kwargs.get('remote_debugging_enabled', None)
        self.remote_debugging_version = kwargs.get('remote_debugging_version', None)
        self.http_logging_enabled = kwargs.get('http_logging_enabled', None)
        self.acr_use_managed_identity_creds = kwargs.get('acr_use_managed_identity_creds', None)
        self.acr_user_managed_identity_id = kwargs.get('acr_user_managed_identity_id', None)
        self.logs_directory_size_limit = kwargs.get('logs_directory_size_limit', None)
        self.detailed_error_logging_enabled = kwargs.get('detailed_error_logging_enabled', None)
        self.publishing_username = kwargs.get('publishing_username', None)
        self.app_settings = kwargs.get('app_settings', None)
        self.connection_strings = kwargs.get('connection_strings', None)
        self.machine_key = None
        self.handler_mappings = kwargs.get('handler_mappings', None)
        self.document_root = kwargs.get('document_root', None)
        self.scm_type = kwargs.get('scm_type', None)
        self.use32_bit_worker_process = kwargs.get('use32_bit_worker_process', None)
        self.web_sockets_enabled = kwargs.get('web_sockets_enabled', None)
        self.always_on = kwargs.get('always_on', None)
        self.java_version = kwargs.get('java_version', None)
        self.java_container = kwargs.get('java_container', None)
        self.java_container_version = kwargs.get('java_container_version', None)
        self.app_command_line = kwargs.get('app_command_line', None)
        self.managed_pipeline_mode = kwargs.get('managed_pipeline_mode', None)
        self.virtual_applications = kwargs.get('virtual_applications', None)
        self.load_balancing = kwargs.get('load_balancing', None)
        self.experiments = kwargs.get('experiments', None)
        self.limits = kwargs.get('limits', None)
        self.auto_heal_enabled = kwargs.get('auto_heal_enabled', None)
        self.auto_heal_rules = kwargs.get('auto_heal_rules', None)
        self.tracing_options = kwargs.get('tracing_options', None)
        self.vnet_name = kwargs.get('vnet_name', None)
        self.vnet_route_all_enabled = kwargs.get('vnet_route_all_enabled', None)
        self.vnet_private_ports_count = kwargs.get('vnet_private_ports_count', None)
        self.cors = kwargs.get('cors', None)
        self.push = kwargs.get('push', None)
        self.api_definition = kwargs.get('api_definition', None)
        self.api_management_config = kwargs.get('api_management_config', None)
        self.auto_swap_slot_name = kwargs.get('auto_swap_slot_name', None)
        self.local_my_sql_enabled = kwargs.get('local_my_sql_enabled', False)
        self.managed_service_identity_id = kwargs.get('managed_service_identity_id', None)
        self.x_managed_service_identity_id = kwargs.get('x_managed_service_identity_id', None)
        self.key_vault_reference_identity = kwargs.get('key_vault_reference_identity', None)
        self.ip_security_restrictions = kwargs.get('ip_security_restrictions', None)
        self.scm_ip_security_restrictions = kwargs.get('scm_ip_security_restrictions', None)
        self.scm_ip_security_restrictions_use_main = kwargs.get('scm_ip_security_restrictions_use_main', None)
        self.http20_enabled = kwargs.get('http20_enabled', True)
        self.min_tls_version = kwargs.get('min_tls_version', None)
        self.scm_min_tls_version = kwargs.get('scm_min_tls_version', None)
        self.ftps_state = kwargs.get('ftps_state', None)
        self.pre_warmed_instance_count = kwargs.get('pre_warmed_instance_count', None)
        self.function_app_scale_limit = kwargs.get('function_app_scale_limit', None)
        self.health_check_path = kwargs.get('health_check_path', None)
        self.functions_runtime_scale_monitoring_enabled = kwargs.get('functions_runtime_scale_monitoring_enabled', None)
        self.website_time_zone = kwargs.get('website_time_zone', None)
        self.minimum_elastic_instance_count = kwargs.get('minimum_elastic_instance_count', None)
        self.azure_storage_accounts = kwargs.get('azure_storage_accounts', None)
        self.public_network_access = kwargs.get('public_network_access', None)


class SiteConfigResourceCollection(msrest.serialization.Model):
    """Collection of site configurations.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2021_01_01.models.SiteConfigResource]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SiteConfigResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SiteConfigResourceCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class SiteConfigurationSnapshotInfo(ProxyOnlyResource):
    """A snapshot of a web app configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar time: The time the snapshot was taken.
    :vartype time: ~datetime.datetime
    :ivar snapshot_id: The id of the snapshot.
    :vartype snapshot_id: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'time': {'readonly': True},
        'snapshot_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'time': {'key': 'properties.time', 'type': 'iso-8601'},
        'snapshot_id': {'key': 'properties.snapshotId', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SiteConfigurationSnapshotInfo, self).__init__(**kwargs)
        self.time = None
        self.snapshot_id = None


class SiteConfigurationSnapshotInfoCollection(msrest.serialization.Model):
    """Collection of metadata for the app configuration snapshots that can be restored.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2021_01_01.models.SiteConfigurationSnapshotInfo]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SiteConfigurationSnapshotInfo]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SiteConfigurationSnapshotInfoCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class SiteExtensionInfo(ProxyOnlyResource):
    """Site Extension Information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param extension_id: Site extension ID.
    :type extension_id: str
    :param title:
    :type title: str
    :param extension_type: Site extension type. Possible values include: "Gallery", "WebRoot".
    :type extension_type: str or ~azure.mgmt.web.v2021_01_01.models.SiteExtensionType
    :param summary: Summary description.
    :type summary: str
    :param description: Detailed description.
    :type description: str
    :param version: Version information.
    :type version: str
    :param extension_url: Extension URL.
    :type extension_url: str
    :param project_url: Project URL.
    :type project_url: str
    :param icon_url: Icon URL.
    :type icon_url: str
    :param license_url: License URL.
    :type license_url: str
    :param feed_url: Feed URL.
    :type feed_url: str
    :param authors: List of authors.
    :type authors: list[str]
    :param installer_command_line_params: Installer command line parameters.
    :type installer_command_line_params: str
    :param published_date_time: Published timestamp.
    :type published_date_time: ~datetime.datetime
    :param download_count: Count of downloads.
    :type download_count: int
    :param local_is_latest_version: :code:`<code>true</code>` if the local version is the latest
     version; :code:`<code>false</code>` otherwise.
    :type local_is_latest_version: bool
    :param local_path: Local path.
    :type local_path: str
    :param installed_date_time: Installed timestamp.
    :type installed_date_time: ~datetime.datetime
    :param provisioning_state: Provisioning state.
    :type provisioning_state: str
    :param comment: Site Extension comment.
    :type comment: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'extension_id': {'key': 'properties.extension_id', 'type': 'str'},
        'title': {'key': 'properties.title', 'type': 'str'},
        'extension_type': {'key': 'properties.extension_type', 'type': 'str'},
        'summary': {'key': 'properties.summary', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'extension_url': {'key': 'properties.extension_url', 'type': 'str'},
        'project_url': {'key': 'properties.project_url', 'type': 'str'},
        'icon_url': {'key': 'properties.icon_url', 'type': 'str'},
        'license_url': {'key': 'properties.license_url', 'type': 'str'},
        'feed_url': {'key': 'properties.feed_url', 'type': 'str'},
        'authors': {'key': 'properties.authors', 'type': '[str]'},
        'installer_command_line_params': {'key': 'properties.installer_command_line_params', 'type': 'str'},
        'published_date_time': {'key': 'properties.published_date_time', 'type': 'iso-8601'},
        'download_count': {'key': 'properties.download_count', 'type': 'int'},
        'local_is_latest_version': {'key': 'properties.local_is_latest_version', 'type': 'bool'},
        'local_path': {'key': 'properties.local_path', 'type': 'str'},
        'installed_date_time': {'key': 'properties.installed_date_time', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'comment': {'key': 'properties.comment', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SiteExtensionInfo, self).__init__(**kwargs)
        self.extension_id = kwargs.get('extension_id', None)
        self.title = kwargs.get('title', None)
        self.extension_type = kwargs.get('extension_type', None)
        self.summary = kwargs.get('summary', None)
        self.description = kwargs.get('description', None)
        self.version = kwargs.get('version', None)
        self.extension_url = kwargs.get('extension_url', None)
        self.project_url = kwargs.get('project_url', None)
        self.icon_url = kwargs.get('icon_url', None)
        self.license_url = kwargs.get('license_url', None)
        self.feed_url = kwargs.get('feed_url', None)
        self.authors = kwargs.get('authors', None)
        self.installer_command_line_params = kwargs.get('installer_command_line_params', None)
        self.published_date_time = kwargs.get('published_date_time', None)
        self.download_count = kwargs.get('download_count', None)
        self.local_is_latest_version = kwargs.get('local_is_latest_version', None)
        self.local_path = kwargs.get('local_path', None)
        self.installed_date_time = kwargs.get('installed_date_time', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.comment = kwargs.get('comment', None)


class SiteExtensionInfoCollection(msrest.serialization.Model):
    """Collection of Kudu site extension information elements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2021_01_01.models.SiteExtensionInfo]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SiteExtensionInfo]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SiteExtensionInfoCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class SiteLimits(msrest.serialization.Model):
    """Metric limits set on an app.

    :param max_percentage_cpu: Maximum allowed CPU usage percentage.
    :type max_percentage_cpu: float
    :param max_memory_in_mb: Maximum allowed memory usage in MB.
    :type max_memory_in_mb: long
    :param max_disk_size_in_mb: Maximum allowed disk size usage in MB.
    :type max_disk_size_in_mb: long
    """

    _attribute_map = {
        'max_percentage_cpu': {'key': 'maxPercentageCpu', 'type': 'float'},
        'max_memory_in_mb': {'key': 'maxMemoryInMb', 'type': 'long'},
        'max_disk_size_in_mb': {'key': 'maxDiskSizeInMb', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SiteLimits, self).__init__(**kwargs)
        self.max_percentage_cpu = kwargs.get('max_percentage_cpu', None)
        self.max_memory_in_mb = kwargs.get('max_memory_in_mb', None)
        self.max_disk_size_in_mb = kwargs.get('max_disk_size_in_mb', None)


class SiteLogsConfig(ProxyOnlyResource):
    """Configuration of App Service site logs.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param application_logs: Application logs configuration.
    :type application_logs: ~azure.mgmt.web.v2021_01_01.models.ApplicationLogsConfig
    :param http_logs: HTTP logs configuration.
    :type http_logs: ~azure.mgmt.web.v2021_01_01.models.HttpLogsConfig
    :param failed_requests_tracing: Failed requests tracing configuration.
    :type failed_requests_tracing: ~azure.mgmt.web.v2021_01_01.models.EnabledConfig
    :param detailed_error_messages: Detailed error messages configuration.
    :type detailed_error_messages: ~azure.mgmt.web.v2021_01_01.models.EnabledConfig
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'application_logs': {'key': 'properties.applicationLogs', 'type': 'ApplicationLogsConfig'},
        'http_logs': {'key': 'properties.httpLogs', 'type': 'HttpLogsConfig'},
        'failed_requests_tracing': {'key': 'properties.failedRequestsTracing', 'type': 'EnabledConfig'},
        'detailed_error_messages': {'key': 'properties.detailedErrorMessages', 'type': 'EnabledConfig'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SiteLogsConfig, self).__init__(**kwargs)
        self.application_logs = kwargs.get('application_logs', None)
        self.http_logs = kwargs.get('http_logs', None)
        self.failed_requests_tracing = kwargs.get('failed_requests_tracing', None)
        self.detailed_error_messages = kwargs.get('detailed_error_messages', None)


class SiteMachineKey(msrest.serialization.Model):
    """MachineKey of an app.

    :param validation: MachineKey validation.
    :type validation: str
    :param validation_key: Validation key.
    :type validation_key: str
    :param decryption: Algorithm used for decryption.
    :type decryption: str
    :param decryption_key: Decryption key.
    :type decryption_key: str
    """

    _attribute_map = {
        'validation': {'key': 'validation', 'type': 'str'},
        'validation_key': {'key': 'validationKey', 'type': 'str'},
        'decryption': {'key': 'decryption', 'type': 'str'},
        'decryption_key': {'key': 'decryptionKey', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SiteMachineKey, self).__init__(**kwargs)
        self.validation = kwargs.get('validation', None)
        self.validation_key = kwargs.get('validation_key', None)
        self.decryption = kwargs.get('decryption', None)
        self.decryption_key = kwargs.get('decryption_key', None)


class SitePatchResource(ProxyOnlyResource):
    """ARM resource for a site.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param identity: Managed service identity.
    :type identity: ~azure.mgmt.web.v2021_01_01.models.ManagedServiceIdentity
    :ivar state: Current state of the app.
    :vartype state: str
    :ivar host_names: Hostnames associated with the app.
    :vartype host_names: list[str]
    :ivar repository_site_name: Name of the repository site.
    :vartype repository_site_name: str
    :ivar usage_state: State indicating whether the app has exceeded its quota usage. Read-only.
     Possible values include: "Normal", "Exceeded".
    :vartype usage_state: str or ~azure.mgmt.web.v2021_01_01.models.UsageState
    :param enabled: :code:`<code>true</code>` if the app is enabled; otherwise,
     :code:`<code>false</code>`. Setting this value to false disables the app (takes the app
     offline).
    :type enabled: bool
    :ivar enabled_host_names: Enabled hostnames for the app.Hostnames need to be assigned (see
     HostNames) AND enabled. Otherwise,
     the app is not served on those hostnames.
    :vartype enabled_host_names: list[str]
    :ivar availability_state: Management information availability state for the app. Possible
     values include: "Normal", "Limited", "DisasterRecoveryMode".
    :vartype availability_state: str or ~azure.mgmt.web.v2021_01_01.models.SiteAvailabilityState
    :param host_name_ssl_states: Hostname SSL states are used to manage the SSL bindings for app's
     hostnames.
    :type host_name_ssl_states: list[~azure.mgmt.web.v2021_01_01.models.HostNameSslState]
    :param server_farm_id: Resource ID of the associated App Service plan, formatted as:
     "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
    :type server_farm_id: str
    :param reserved: :code:`<code>true</code>` if reserved; otherwise, :code:`<code>false</code>`.
    :type reserved: bool
    :param is_xenon: Obsolete: Hyper-V sandbox.
    :type is_xenon: bool
    :param hyper_v: Hyper-V sandbox.
    :type hyper_v: bool
    :ivar last_modified_time_utc: Last time the app was modified, in UTC. Read-only.
    :vartype last_modified_time_utc: ~datetime.datetime
    :param site_config: Configuration of the app.
    :type site_config: ~azure.mgmt.web.v2021_01_01.models.SiteConfig
    :ivar traffic_manager_host_names: Azure Traffic Manager hostnames associated with the app.
     Read-only.
    :vartype traffic_manager_host_names: list[str]
    :param scm_site_also_stopped: :code:`<code>true</code>` to stop SCM (KUDU) site when the app is
     stopped; otherwise, :code:`<code>false</code>`. The default is :code:`<code>false</code>`.
    :type scm_site_also_stopped: bool
    :ivar target_swap_slot: Specifies which deployment slot this app will swap into. Read-only.
    :vartype target_swap_slot: str
    :param hosting_environment_profile: App Service Environment to use for the app.
    :type hosting_environment_profile: ~azure.mgmt.web.v2021_01_01.models.HostingEnvironmentProfile
    :param client_affinity_enabled: :code:`<code>true</code>` to enable client affinity;
     :code:`<code>false</code>` to stop sending session affinity cookies, which route client
     requests in the same session to the same instance. Default is :code:`<code>true</code>`.
    :type client_affinity_enabled: bool
    :param client_cert_enabled: :code:`<code>true</code>` to enable client certificate
     authentication (TLS mutual authentication); otherwise, :code:`<code>false</code>`. Default is
     :code:`<code>false</code>`.
    :type client_cert_enabled: bool
    :param client_cert_mode: This composes with ClientCertEnabled setting.
    
    
     * ClientCertEnabled: false means ClientCert is ignored.
     * ClientCertEnabled: true and ClientCertMode: Required means ClientCert is required.
     * ClientCertEnabled: true and ClientCertMode: Optional means ClientCert is optional or
     accepted. Possible values include: "Required", "Optional", "OptionalInteractiveUser".
    :type client_cert_mode: str or ~azure.mgmt.web.v2021_01_01.models.ClientCertMode
    :param client_cert_exclusion_paths: client certificate authentication comma-separated exclusion
     paths.
    :type client_cert_exclusion_paths: str
    :param host_names_disabled: :code:`<code>true</code>` to disable the public hostnames of the
     app; otherwise, :code:`<code>false</code>`.
      If :code:`<code>true</code>`, the app is only accessible via API management process.
    :type host_names_disabled: bool
    :param custom_domain_verification_id: Unique identifier that verifies the custom domains
     assigned to the app. Customer will add this id to a txt record for verification.
    :type custom_domain_verification_id: str
    :ivar outbound_ip_addresses: List of IP addresses that the app uses for outbound connections
     (e.g. database access). Includes VIPs from tenants that site can be hosted with current
     settings. Read-only.
    :vartype outbound_ip_addresses: str
    :ivar possible_outbound_ip_addresses: List of IP addresses that the app uses for outbound
     connections (e.g. database access). Includes VIPs from all tenants except dataComponent.
     Read-only.
    :vartype possible_outbound_ip_addresses: str
    :param container_size: Size of the function container.
    :type container_size: int
    :param daily_memory_time_quota: Maximum allowed daily memory-time quota (applicable on dynamic
     apps only).
    :type daily_memory_time_quota: int
    :ivar suspended_till: App suspended till in case memory-time quota is exceeded.
    :vartype suspended_till: ~datetime.datetime
    :ivar max_number_of_workers: Maximum number of workers.
     This only applies to Functions container.
    :vartype max_number_of_workers: int
    :param cloning_info: If specified during app creation, the app is cloned from a source app.
    :type cloning_info: ~azure.mgmt.web.v2021_01_01.models.CloningInfo
    :ivar resource_group: Name of the resource group the app belongs to. Read-only.
    :vartype resource_group: str
    :ivar is_default_container: :code:`<code>true</code>` if the app is a default container;
     otherwise, :code:`<code>false</code>`.
    :vartype is_default_container: bool
    :ivar default_host_name: Default hostname of the app. Read-only.
    :vartype default_host_name: str
    :ivar slot_swap_status: Status of the last deployment slot swap operation.
    :vartype slot_swap_status: ~azure.mgmt.web.v2021_01_01.models.SlotSwapStatus
    :param https_only: HttpsOnly: configures a web site to accept only https requests. Issues
     redirect for
     http requests.
    :type https_only: bool
    :param redundancy_mode: Site redundancy mode. Possible values include: "None", "Manual",
     "Failover", "ActiveActive", "GeoRedundant".
    :type redundancy_mode: str or ~azure.mgmt.web.v2021_01_01.models.RedundancyMode
    :ivar in_progress_operation_id: Specifies an operation id if this site has a pending operation.
    :vartype in_progress_operation_id: str
    :param storage_account_required: Checks if Customer provided storage account is required.
    :type storage_account_required: bool
    :param key_vault_reference_identity: Identity to use for Key Vault Reference authentication.
    :type key_vault_reference_identity: str
    :param virtual_network_subnet_id: Azure Resource Manager ID of the Virtual network and subnet
     to be joined by Regional VNET Integration.
     This must be of the form
     /subscriptions/{subscriptionName}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
    :type virtual_network_subnet_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'state': {'readonly': True},
        'host_names': {'readonly': True},
        'repository_site_name': {'readonly': True},
        'usage_state': {'readonly': True},
        'enabled_host_names': {'readonly': True},
        'availability_state': {'readonly': True},
        'last_modified_time_utc': {'readonly': True},
        'traffic_manager_host_names': {'readonly': True},
        'target_swap_slot': {'readonly': True},
        'outbound_ip_addresses': {'readonly': True},
        'possible_outbound_ip_addresses': {'readonly': True},
        'suspended_till': {'readonly': True},
        'max_number_of_workers': {'readonly': True},
        'resource_group': {'readonly': True},
        'is_default_container': {'readonly': True},
        'default_host_name': {'readonly': True},
        'slot_swap_status': {'readonly': True},
        'in_progress_operation_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'host_names': {'key': 'properties.hostNames', 'type': '[str]'},
        'repository_site_name': {'key': 'properties.repositorySiteName', 'type': 'str'},
        'usage_state': {'key': 'properties.usageState', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'enabled_host_names': {'key': 'properties.enabledHostNames', 'type': '[str]'},
        'availability_state': {'key': 'properties.availabilityState', 'type': 'str'},
        'host_name_ssl_states': {'key': 'properties.hostNameSslStates', 'type': '[HostNameSslState]'},
        'server_farm_id': {'key': 'properties.serverFarmId', 'type': 'str'},
        'reserved': {'key': 'properties.reserved', 'type': 'bool'},
        'is_xenon': {'key': 'properties.isXenon', 'type': 'bool'},
        'hyper_v': {'key': 'properties.hyperV', 'type': 'bool'},
        'last_modified_time_utc': {'key': 'properties.lastModifiedTimeUtc', 'type': 'iso-8601'},
        'site_config': {'key': 'properties.siteConfig', 'type': 'SiteConfig'},
        'traffic_manager_host_names': {'key': 'properties.trafficManagerHostNames', 'type': '[str]'},
        'scm_site_also_stopped': {'key': 'properties.scmSiteAlsoStopped', 'type': 'bool'},
        'target_swap_slot': {'key': 'properties.targetSwapSlot', 'type': 'str'},
        'hosting_environment_profile': {'key': 'properties.hostingEnvironmentProfile', 'type': 'HostingEnvironmentProfile'},
        'client_affinity_enabled': {'key': 'properties.clientAffinityEnabled', 'type': 'bool'},
        'client_cert_enabled': {'key': 'properties.clientCertEnabled', 'type': 'bool'},
        'client_cert_mode': {'key': 'properties.clientCertMode', 'type': 'str'},
        'client_cert_exclusion_paths': {'key': 'properties.clientCertExclusionPaths', 'type': 'str'},
        'host_names_disabled': {'key': 'properties.hostNamesDisabled', 'type': 'bool'},
        'custom_domain_verification_id': {'key': 'properties.customDomainVerificationId', 'type': 'str'},
        'outbound_ip_addresses': {'key': 'properties.outboundIpAddresses', 'type': 'str'},
        'possible_outbound_ip_addresses': {'key': 'properties.possibleOutboundIpAddresses', 'type': 'str'},
        'container_size': {'key': 'properties.containerSize', 'type': 'int'},
        'daily_memory_time_quota': {'key': 'properties.dailyMemoryTimeQuota', 'type': 'int'},
        'suspended_till': {'key': 'properties.suspendedTill', 'type': 'iso-8601'},
        'max_number_of_workers': {'key': 'properties.maxNumberOfWorkers', 'type': 'int'},
        'cloning_info': {'key': 'properties.cloningInfo', 'type': 'CloningInfo'},
        'resource_group': {'key': 'properties.resourceGroup', 'type': 'str'},
        'is_default_container': {'key': 'properties.isDefaultContainer', 'type': 'bool'},
        'default_host_name': {'key': 'properties.defaultHostName', 'type': 'str'},
        'slot_swap_status': {'key': 'properties.slotSwapStatus', 'type': 'SlotSwapStatus'},
        'https_only': {'key': 'properties.httpsOnly', 'type': 'bool'},
        'redundancy_mode': {'key': 'properties.redundancyMode', 'type': 'str'},
        'in_progress_operation_id': {'key': 'properties.inProgressOperationId', 'type': 'str'},
        'storage_account_required': {'key': 'properties.storageAccountRequired', 'type': 'bool'},
        'key_vault_reference_identity': {'key': 'properties.keyVaultReferenceIdentity', 'type': 'str'},
        'virtual_network_subnet_id': {'key': 'properties.virtualNetworkSubnetId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SitePatchResource, self).__init__(**kwargs)
        self.identity = kwargs.get('identity', None)
        self.state = None
        self.host_names = None
        self.repository_site_name = None
        self.usage_state = None
        self.enabled = kwargs.get('enabled', None)
        self.enabled_host_names = None
        self.availability_state = None
        self.host_name_ssl_states = kwargs.get('host_name_ssl_states', None)
        self.server_farm_id = kwargs.get('server_farm_id', None)
        self.reserved = kwargs.get('reserved', False)
        self.is_xenon = kwargs.get('is_xenon', False)
        self.hyper_v = kwargs.get('hyper_v', False)
        self.last_modified_time_utc = None
        self.site_config = kwargs.get('site_config', None)
        self.traffic_manager_host_names = None
        self.scm_site_also_stopped = kwargs.get('scm_site_also_stopped', False)
        self.target_swap_slot = None
        self.hosting_environment_profile = kwargs.get('hosting_environment_profile', None)
        self.client_affinity_enabled = kwargs.get('client_affinity_enabled', None)
        self.client_cert_enabled = kwargs.get('client_cert_enabled', None)
        self.client_cert_mode = kwargs.get('client_cert_mode', None)
        self.client_cert_exclusion_paths = kwargs.get('client_cert_exclusion_paths', None)
        self.host_names_disabled = kwargs.get('host_names_disabled', None)
        self.custom_domain_verification_id = kwargs.get('custom_domain_verification_id', None)
        self.outbound_ip_addresses = None
        self.possible_outbound_ip_addresses = None
        self.container_size = kwargs.get('container_size', None)
        self.daily_memory_time_quota = kwargs.get('daily_memory_time_quota', None)
        self.suspended_till = None
        self.max_number_of_workers = None
        self.cloning_info = kwargs.get('cloning_info', None)
        self.resource_group = None
        self.is_default_container = None
        self.default_host_name = None
        self.slot_swap_status = None
        self.https_only = kwargs.get('https_only', None)
        self.redundancy_mode = kwargs.get('redundancy_mode', None)
        self.in_progress_operation_id = None
        self.storage_account_required = kwargs.get('storage_account_required', None)
        self.key_vault_reference_identity = kwargs.get('key_vault_reference_identity', None)
        self.virtual_network_subnet_id = kwargs.get('virtual_network_subnet_id', None)


class SitePhpErrorLogFlag(ProxyOnlyResource):
    """Used for getting PHP error logging flag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param local_log_errors: Local log_errors setting.
    :type local_log_errors: str
    :param master_log_errors: Master log_errors setting.
    :type master_log_errors: str
    :param local_log_errors_max_length: Local log_errors_max_len setting.
    :type local_log_errors_max_length: str
    :param master_log_errors_max_length: Master log_errors_max_len setting.
    :type master_log_errors_max_length: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'local_log_errors': {'key': 'properties.localLogErrors', 'type': 'str'},
        'master_log_errors': {'key': 'properties.masterLogErrors', 'type': 'str'},
        'local_log_errors_max_length': {'key': 'properties.localLogErrorsMaxLength', 'type': 'str'},
        'master_log_errors_max_length': {'key': 'properties.masterLogErrorsMaxLength', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SitePhpErrorLogFlag, self).__init__(**kwargs)
        self.local_log_errors = kwargs.get('local_log_errors', None)
        self.master_log_errors = kwargs.get('master_log_errors', None)
        self.local_log_errors_max_length = kwargs.get('local_log_errors_max_length', None)
        self.master_log_errors_max_length = kwargs.get('master_log_errors_max_length', None)


class SiteSeal(msrest.serialization.Model):
    """Site seal.

    All required parameters must be populated in order to send to Azure.

    :param html: Required. HTML snippet.
    :type html: str
    """

    _validation = {
        'html': {'required': True},
    }

    _attribute_map = {
        'html': {'key': 'html', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SiteSeal, self).__init__(**kwargs)
        self.html = kwargs['html']


class SiteSealRequest(msrest.serialization.Model):
    """Site seal request.

    :param light_theme: If :code:`<code>true</code>` use the light color theme for site seal;
     otherwise, use the default color theme.
    :type light_theme: bool
    :param locale: Locale of site seal.
    :type locale: str
    """

    _attribute_map = {
        'light_theme': {'key': 'lightTheme', 'type': 'bool'},
        'locale': {'key': 'locale', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SiteSealRequest, self).__init__(**kwargs)
        self.light_theme = kwargs.get('light_theme', None)
        self.locale = kwargs.get('locale', None)


class SiteSourceControl(ProxyOnlyResource):
    """Source control configuration for an app.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param repo_url: Repository or source control URL.
    :type repo_url: str
    :param branch: Name of branch to use for deployment.
    :type branch: str
    :param is_manual_integration: :code:`<code>true</code>` to limit to manual integration;
     :code:`<code>false</code>` to enable continuous integration (which configures webhooks into
     online repos like GitHub).
    :type is_manual_integration: bool
    :param is_git_hub_action: :code:`<code>true</code>` if this is deployed via GitHub action.
    :type is_git_hub_action: bool
    :param deployment_rollback_enabled: :code:`<code>true</code>` to enable deployment rollback;
     otherwise, :code:`<code>false</code>`.
    :type deployment_rollback_enabled: bool
    :param is_mercurial: :code:`<code>true</code>` for a Mercurial repository;
     :code:`<code>false</code>` for a Git repository.
    :type is_mercurial: bool
    :param git_hub_action_configuration: If GitHub Action is selected, than the associated
     configuration.
    :type git_hub_action_configuration:
     ~azure.mgmt.web.v2021_01_01.models.GitHubActionConfiguration
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'repo_url': {'key': 'properties.repoUrl', 'type': 'str'},
        'branch': {'key': 'properties.branch', 'type': 'str'},
        'is_manual_integration': {'key': 'properties.isManualIntegration', 'type': 'bool'},
        'is_git_hub_action': {'key': 'properties.isGitHubAction', 'type': 'bool'},
        'deployment_rollback_enabled': {'key': 'properties.deploymentRollbackEnabled', 'type': 'bool'},
        'is_mercurial': {'key': 'properties.isMercurial', 'type': 'bool'},
        'git_hub_action_configuration': {'key': 'properties.gitHubActionConfiguration', 'type': 'GitHubActionConfiguration'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SiteSourceControl, self).__init__(**kwargs)
        self.repo_url = kwargs.get('repo_url', None)
        self.branch = kwargs.get('branch', None)
        self.is_manual_integration = kwargs.get('is_manual_integration', None)
        self.is_git_hub_action = kwargs.get('is_git_hub_action', None)
        self.deployment_rollback_enabled = kwargs.get('deployment_rollback_enabled', None)
        self.is_mercurial = kwargs.get('is_mercurial', None)
        self.git_hub_action_configuration = kwargs.get('git_hub_action_configuration', None)


class SkuCapacity(msrest.serialization.Model):
    """Description of the App Service plan scale options.

    :param minimum: Minimum number of workers for this App Service plan SKU.
    :type minimum: int
    :param maximum: Maximum number of workers for this App Service plan SKU.
    :type maximum: int
    :param elastic_maximum: Maximum number of Elastic workers for this App Service plan SKU.
    :type elastic_maximum: int
    :param default: Default number of workers for this App Service plan SKU.
    :type default: int
    :param scale_type: Available scale configurations for an App Service plan.
    :type scale_type: str
    """

    _attribute_map = {
        'minimum': {'key': 'minimum', 'type': 'int'},
        'maximum': {'key': 'maximum', 'type': 'int'},
        'elastic_maximum': {'key': 'elasticMaximum', 'type': 'int'},
        'default': {'key': 'default', 'type': 'int'},
        'scale_type': {'key': 'scaleType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SkuCapacity, self).__init__(**kwargs)
        self.minimum = kwargs.get('minimum', None)
        self.maximum = kwargs.get('maximum', None)
        self.elastic_maximum = kwargs.get('elastic_maximum', None)
        self.default = kwargs.get('default', None)
        self.scale_type = kwargs.get('scale_type', None)


class SkuDescription(msrest.serialization.Model):
    """Description of a SKU for a scalable resource.

    :param name: Name of the resource SKU.
    :type name: str
    :param tier: Service tier of the resource SKU.
    :type tier: str
    :param size: Size specifier of the resource SKU.
    :type size: str
    :param family: Family code of the resource SKU.
    :type family: str
    :param capacity: Current number of instances assigned to the resource.
    :type capacity: int
    :param sku_capacity: Min, max, and default scale values of the SKU.
    :type sku_capacity: ~azure.mgmt.web.v2021_01_01.models.SkuCapacity
    :param locations: Locations of the SKU.
    :type locations: list[str]
    :param capabilities: Capabilities of the SKU, e.g., is traffic manager enabled?.
    :type capabilities: list[~azure.mgmt.web.v2021_01_01.models.Capability]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'size': {'key': 'size', 'type': 'str'},
        'family': {'key': 'family', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'int'},
        'sku_capacity': {'key': 'skuCapacity', 'type': 'SkuCapacity'},
        'locations': {'key': 'locations', 'type': '[str]'},
        'capabilities': {'key': 'capabilities', 'type': '[Capability]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SkuDescription, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.tier = kwargs.get('tier', None)
        self.size = kwargs.get('size', None)
        self.family = kwargs.get('family', None)
        self.capacity = kwargs.get('capacity', None)
        self.sku_capacity = kwargs.get('sku_capacity', None)
        self.locations = kwargs.get('locations', None)
        self.capabilities = kwargs.get('capabilities', None)


class SkuInfo(msrest.serialization.Model):
    """SKU discovery information.

    :param resource_type: Resource type that this SKU applies to.
    :type resource_type: str
    :param sku: Name and tier of the SKU.
    :type sku: ~azure.mgmt.web.v2021_01_01.models.SkuDescription
    :param capacity: Min, max, and default scale values of the SKU.
    :type capacity: ~azure.mgmt.web.v2021_01_01.models.SkuCapacity
    """

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'SkuDescription'},
        'capacity': {'key': 'capacity', 'type': 'SkuCapacity'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SkuInfo, self).__init__(**kwargs)
        self.resource_type = kwargs.get('resource_type', None)
        self.sku = kwargs.get('sku', None)
        self.capacity = kwargs.get('capacity', None)


class SkuInfoCollection(msrest.serialization.Model):
    """Collection of SKU information.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2021_01_01.models.SkuInfo]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SkuInfo]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SkuInfoCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class SkuInfos(msrest.serialization.Model):
    """Collection of SKU information.

    :param resource_type: Resource type that this SKU applies to.
    :type resource_type: str
    :param skus: List of SKUs the subscription is able to use.
    :type skus: list[~azure.mgmt.web.v2021_01_01.models.GlobalCsmSkuDescription]
    """

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'skus': {'key': 'skus', 'type': '[GlobalCsmSkuDescription]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SkuInfos, self).__init__(**kwargs)
        self.resource_type = kwargs.get('resource_type', None)
        self.skus = kwargs.get('skus', None)


class SlotConfigNamesResource(ProxyOnlyResource):
    """Slot Config names azure resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param connection_string_names: List of connection string names.
    :type connection_string_names: list[str]
    :param app_setting_names: List of application settings names.
    :type app_setting_names: list[str]
    :param azure_storage_config_names: List of external Azure storage account identifiers.
    :type azure_storage_config_names: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'connection_string_names': {'key': 'properties.connectionStringNames', 'type': '[str]'},
        'app_setting_names': {'key': 'properties.appSettingNames', 'type': '[str]'},
        'azure_storage_config_names': {'key': 'properties.azureStorageConfigNames', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SlotConfigNamesResource, self).__init__(**kwargs)
        self.connection_string_names = kwargs.get('connection_string_names', None)
        self.app_setting_names = kwargs.get('app_setting_names', None)
        self.azure_storage_config_names = kwargs.get('azure_storage_config_names', None)


class SlotDifference(ProxyOnlyResource):
    """A setting difference between two deployment slots of an app.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar level: Level of the difference: Information, Warning or Error.
    :vartype level: str
    :ivar setting_type: The type of the setting: General, AppSetting or ConnectionString.
    :vartype setting_type: str
    :ivar diff_rule: Rule that describes how to process the setting difference during a slot swap.
    :vartype diff_rule: str
    :ivar setting_name: Name of the setting.
    :vartype setting_name: str
    :ivar value_in_current_slot: Value of the setting in the current slot.
    :vartype value_in_current_slot: str
    :ivar value_in_target_slot: Value of the setting in the target slot.
    :vartype value_in_target_slot: str
    :ivar description: Description of the setting difference.
    :vartype description: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'level': {'readonly': True},
        'setting_type': {'readonly': True},
        'diff_rule': {'readonly': True},
        'setting_name': {'readonly': True},
        'value_in_current_slot': {'readonly': True},
        'value_in_target_slot': {'readonly': True},
        'description': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'level': {'key': 'properties.level', 'type': 'str'},
        'setting_type': {'key': 'properties.settingType', 'type': 'str'},
        'diff_rule': {'key': 'properties.diffRule', 'type': 'str'},
        'setting_name': {'key': 'properties.settingName', 'type': 'str'},
        'value_in_current_slot': {'key': 'properties.valueInCurrentSlot', 'type': 'str'},
        'value_in_target_slot': {'key': 'properties.valueInTargetSlot', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SlotDifference, self).__init__(**kwargs)
        self.level = None
        self.setting_type = None
        self.diff_rule = None
        self.setting_name = None
        self.value_in_current_slot = None
        self.value_in_target_slot = None
        self.description = None


class SlotDifferenceCollection(msrest.serialization.Model):
    """Collection of slot differences.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2021_01_01.models.SlotDifference]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SlotDifference]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SlotDifferenceCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class SlotSwapStatus(msrest.serialization.Model):
    """The status of the last successful slot swap operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar timestamp_utc: The time the last successful slot swap completed.
    :vartype timestamp_utc: ~datetime.datetime
    :ivar source_slot_name: The source slot of the last swap operation.
    :vartype source_slot_name: str
    :ivar destination_slot_name: The destination slot of the last swap operation.
    :vartype destination_slot_name: str
    """

    _validation = {
        'timestamp_utc': {'readonly': True},
        'source_slot_name': {'readonly': True},
        'destination_slot_name': {'readonly': True},
    }

    _attribute_map = {
        'timestamp_utc': {'key': 'timestampUtc', 'type': 'iso-8601'},
        'source_slot_name': {'key': 'sourceSlotName', 'type': 'str'},
        'destination_slot_name': {'key': 'destinationSlotName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SlotSwapStatus, self).__init__(**kwargs)
        self.timestamp_utc = None
        self.source_slot_name = None
        self.destination_slot_name = None


class SlowRequestsBasedTrigger(msrest.serialization.Model):
    """Trigger based on request execution time.

    :param time_taken: Time taken.
    :type time_taken: str
    :param path: Request Path.
    :type path: str
    :param count: Request Count.
    :type count: int
    :param time_interval: Time interval.
    :type time_interval: str
    """

    _attribute_map = {
        'time_taken': {'key': 'timeTaken', 'type': 'str'},
        'path': {'key': 'path', 'type': 'str'},
        'count': {'key': 'count', 'type': 'int'},
        'time_interval': {'key': 'timeInterval', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SlowRequestsBasedTrigger, self).__init__(**kwargs)
        self.time_taken = kwargs.get('time_taken', None)
        self.path = kwargs.get('path', None)
        self.count = kwargs.get('count', None)
        self.time_interval = kwargs.get('time_interval', None)


class Snapshot(ProxyOnlyResource):
    """A snapshot of an app.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar time: The time the snapshot was taken.
    :vartype time: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'time': {'key': 'properties.time', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Snapshot, self).__init__(**kwargs)
        self.time = None


class SnapshotCollection(msrest.serialization.Model):
    """Collection of snapshots which can be used to revert an app to a previous time.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2021_01_01.models.Snapshot]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Snapshot]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SnapshotCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class SnapshotRecoverySource(msrest.serialization.Model):
    """Specifies the web app that snapshot contents will be retrieved from.

    :param location: Geographical location of the source web app, e.g. SouthEastAsia,
     SouthCentralUS.
    :type location: str
    :param id: ARM resource ID of the source app.
    /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}
     for production slots and
    /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slotName}
     for other slots.
    :type id: str
    """

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SnapshotRecoverySource, self).__init__(**kwargs)
        self.location = kwargs.get('location', None)
        self.id = kwargs.get('id', None)


class SnapshotRestoreRequest(ProxyOnlyResource):
    """Details about app recovery operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param snapshot_time: Point in time in which the app restore should be done, formatted as a
     DateTime string.
    :type snapshot_time: str
    :param recovery_source: Optional. Specifies the web app that snapshot contents will be
     retrieved from.
     If empty, the targeted web app will be used as the source.
    :type recovery_source: ~azure.mgmt.web.v2021_01_01.models.SnapshotRecoverySource
    :param overwrite: If :code:`<code>true</code>` the restore operation can overwrite source app;
     otherwise, :code:`<code>false</code>`.
    :type overwrite: bool
    :param recover_configuration: If true, site configuration, in addition to content, will be
     reverted.
    :type recover_configuration: bool
    :param ignore_conflicting_host_names: If true, custom hostname conflicts will be ignored when
     recovering to a target web app.
     This setting is only necessary when RecoverConfiguration is enabled.
    :type ignore_conflicting_host_names: bool
    :param use_dr_secondary: If true, the snapshot is retrieved from DRSecondary endpoint.
    :type use_dr_secondary: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'snapshot_time': {'key': 'properties.snapshotTime', 'type': 'str'},
        'recovery_source': {'key': 'properties.recoverySource', 'type': 'SnapshotRecoverySource'},
        'overwrite': {'key': 'properties.overwrite', 'type': 'bool'},
        'recover_configuration': {'key': 'properties.recoverConfiguration', 'type': 'bool'},
        'ignore_conflicting_host_names': {'key': 'properties.ignoreConflictingHostNames', 'type': 'bool'},
        'use_dr_secondary': {'key': 'properties.useDRSecondary', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SnapshotRestoreRequest, self).__init__(**kwargs)
        self.snapshot_time = kwargs.get('snapshot_time', None)
        self.recovery_source = kwargs.get('recovery_source', None)
        self.overwrite = kwargs.get('overwrite', None)
        self.recover_configuration = kwargs.get('recover_configuration', None)
        self.ignore_conflicting_host_names = kwargs.get('ignore_conflicting_host_names', None)
        self.use_dr_secondary = kwargs.get('use_dr_secondary', None)


class Solution(msrest.serialization.Model):
    """Class Representing Solution for problems detected.

    :param id: Solution Id.
    :type id: float
    :param display_name: Display Name of the solution.
    :type display_name: str
    :param order: Order of the solution.
    :type order: float
    :param description: Description of the solution.
    :type description: str
    :param type: Type of Solution. Possible values include: "QuickSolution", "DeepInvestigation",
     "BestPractices".
    :type type: str or ~azure.mgmt.web.v2021_01_01.models.SolutionType
    :param data: Solution Data.
    :type data: list[list[~azure.mgmt.web.v2021_01_01.models.NameValuePair]]
    :param metadata: Solution Metadata.
    :type metadata: list[list[~azure.mgmt.web.v2021_01_01.models.NameValuePair]]
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'float'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'order': {'key': 'order', 'type': 'float'},
        'description': {'key': 'description', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'data': {'key': 'data', 'type': '[[NameValuePair]]'},
        'metadata': {'key': 'metadata', 'type': '[[NameValuePair]]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Solution, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.display_name = kwargs.get('display_name', None)
        self.order = kwargs.get('order', None)
        self.description = kwargs.get('description', None)
        self.type = kwargs.get('type', None)
        self.data = kwargs.get('data', None)
        self.metadata = kwargs.get('metadata', None)


class SourceControl(ProxyOnlyResource):
    """The source control OAuth token.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param token: OAuth access token.
    :type token: str
    :param token_secret: OAuth access token secret.
    :type token_secret: str
    :param refresh_token: OAuth refresh token.
    :type refresh_token: str
    :param expiration_time: OAuth token expiration.
    :type expiration_time: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'token': {'key': 'properties.token', 'type': 'str'},
        'token_secret': {'key': 'properties.tokenSecret', 'type': 'str'},
        'refresh_token': {'key': 'properties.refreshToken', 'type': 'str'},
        'expiration_time': {'key': 'properties.expirationTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SourceControl, self).__init__(**kwargs)
        self.token = kwargs.get('token', None)
        self.token_secret = kwargs.get('token_secret', None)
        self.refresh_token = kwargs.get('refresh_token', None)
        self.expiration_time = kwargs.get('expiration_time', None)


class SourceControlCollection(msrest.serialization.Model):
    """Collection of source controls.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2021_01_01.models.SourceControl]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SourceControl]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SourceControlCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class StackMajorVersion(msrest.serialization.Model):
    """Application stack major version.

    :param display_version: Application stack major version (display only).
    :type display_version: str
    :param runtime_version: Application stack major version (runtime only).
    :type runtime_version: str
    :param is_default: :code:`<code>true</code>` if this is the default major version; otherwise,
     :code:`<code>false</code>`.
    :type is_default: bool
    :param minor_versions: Minor versions associated with the major version.
    :type minor_versions: list[~azure.mgmt.web.v2021_01_01.models.StackMinorVersion]
    :param application_insights: :code:`<code>true</code>` if this supports Application Insights;
     otherwise, :code:`<code>false</code>`.
    :type application_insights: bool
    :param is_preview: :code:`<code>true</code>` if this stack is in Preview, otherwise
     :code:`<code>false</code>`.
    :type is_preview: bool
    :param is_deprecated: :code:`<code>true</code>` if this stack has been deprecated, otherwise
     :code:`<code>false</code>`.
    :type is_deprecated: bool
    :param is_hidden: :code:`<code>true</code>` if this stack should be hidden for new customers on
     portal, otherwise :code:`<code>false</code>`.
    :type is_hidden: bool
    :param app_settings_dictionary: :code:`<appSettings>
      <appSetting name="FUNCTIONS_WORKER_RUNTIME" value="dotnet" />
     </appSettings>`
      Example: All the function apps need AppSetting: "FUNCTIONS_WORKER_RUNTIME" to be set stack
     name.
    :type app_settings_dictionary: dict[str, any]
    :param site_config_properties_dictionary: :code:`<siteConfigProperties>
      <siteConfigProperty name="Use32BitWorkerProcess" value="false" />
     </siteConfigProperties>`
      Example: All Linux Function Apps, need Use32BitWorkerProcess to be set to 0.
    :type site_config_properties_dictionary: dict[str, any]
    """

    _attribute_map = {
        'display_version': {'key': 'displayVersion', 'type': 'str'},
        'runtime_version': {'key': 'runtimeVersion', 'type': 'str'},
        'is_default': {'key': 'isDefault', 'type': 'bool'},
        'minor_versions': {'key': 'minorVersions', 'type': '[StackMinorVersion]'},
        'application_insights': {'key': 'applicationInsights', 'type': 'bool'},
        'is_preview': {'key': 'isPreview', 'type': 'bool'},
        'is_deprecated': {'key': 'isDeprecated', 'type': 'bool'},
        'is_hidden': {'key': 'isHidden', 'type': 'bool'},
        'app_settings_dictionary': {'key': 'appSettingsDictionary', 'type': '{object}'},
        'site_config_properties_dictionary': {'key': 'siteConfigPropertiesDictionary', 'type': '{object}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StackMajorVersion, self).__init__(**kwargs)
        self.display_version = kwargs.get('display_version', None)
        self.runtime_version = kwargs.get('runtime_version', None)
        self.is_default = kwargs.get('is_default', None)
        self.minor_versions = kwargs.get('minor_versions', None)
        self.application_insights = kwargs.get('application_insights', None)
        self.is_preview = kwargs.get('is_preview', None)
        self.is_deprecated = kwargs.get('is_deprecated', None)
        self.is_hidden = kwargs.get('is_hidden', None)
        self.app_settings_dictionary = kwargs.get('app_settings_dictionary', None)
        self.site_config_properties_dictionary = kwargs.get('site_config_properties_dictionary', None)


class StackMinorVersion(msrest.serialization.Model):
    """Application stack minor version.

    :param display_version: Application stack minor version (display only).
    :type display_version: str
    :param runtime_version: Application stack minor version (runtime only).
    :type runtime_version: str
    :param is_default: :code:`<code>true</code>` if this is the default minor version; otherwise,
     :code:`<code>false</code>`.
    :type is_default: bool
    :param is_remote_debugging_enabled: :code:`<code>true</code>` if this supports Remote
     Debugging, otherwise :code:`<code>false</code>`.
    :type is_remote_debugging_enabled: bool
    """

    _attribute_map = {
        'display_version': {'key': 'displayVersion', 'type': 'str'},
        'runtime_version': {'key': 'runtimeVersion', 'type': 'str'},
        'is_default': {'key': 'isDefault', 'type': 'bool'},
        'is_remote_debugging_enabled': {'key': 'isRemoteDebuggingEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StackMinorVersion, self).__init__(**kwargs)
        self.display_version = kwargs.get('display_version', None)
        self.runtime_version = kwargs.get('runtime_version', None)
        self.is_default = kwargs.get('is_default', None)
        self.is_remote_debugging_enabled = kwargs.get('is_remote_debugging_enabled', None)


class StampCapacity(msrest.serialization.Model):
    """Stamp capacity information.

    :param name: Name of the stamp.
    :type name: str
    :param available_capacity: Available capacity (# of machines, bytes of storage etc...).
    :type available_capacity: long
    :param total_capacity: Total capacity (# of machines, bytes of storage etc...).
    :type total_capacity: long
    :param unit: Name of the unit.
    :type unit: str
    :param compute_mode: Shared/dedicated workers. Possible values include: "Shared", "Dedicated",
     "Dynamic".
    :type compute_mode: str or ~azure.mgmt.web.v2021_01_01.models.ComputeModeOptions
    :param worker_size: Size of the machines. Possible values include: "Small", "Medium", "Large",
     "D1", "D2", "D3", "SmallV3", "MediumV3", "LargeV3", "NestedSmall", "NestedSmallLinux",
     "Default".
    :type worker_size: str or ~azure.mgmt.web.v2021_01_01.models.WorkerSizeOptions
    :param worker_size_id: Size ID of machines:
     0 - Small
     1 - Medium
     2 - Large.
    :type worker_size_id: int
    :param exclude_from_capacity_allocation: If :code:`<code>true</code>`, it includes basic apps.
     Basic apps are not used for capacity allocation.
    :type exclude_from_capacity_allocation: bool
    :param is_applicable_for_all_compute_modes: :code:`<code>true</code>` if capacity is applicable
     for all apps; otherwise, :code:`<code>false</code>`.
    :type is_applicable_for_all_compute_modes: bool
    :param site_mode: Shared or Dedicated.
    :type site_mode: str
    :param is_linux: Is this a linux stamp capacity.
    :type is_linux: bool
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'available_capacity': {'key': 'availableCapacity', 'type': 'long'},
        'total_capacity': {'key': 'totalCapacity', 'type': 'long'},
        'unit': {'key': 'unit', 'type': 'str'},
        'compute_mode': {'key': 'computeMode', 'type': 'str'},
        'worker_size': {'key': 'workerSize', 'type': 'str'},
        'worker_size_id': {'key': 'workerSizeId', 'type': 'int'},
        'exclude_from_capacity_allocation': {'key': 'excludeFromCapacityAllocation', 'type': 'bool'},
        'is_applicable_for_all_compute_modes': {'key': 'isApplicableForAllComputeModes', 'type': 'bool'},
        'site_mode': {'key': 'siteMode', 'type': 'str'},
        'is_linux': {'key': 'isLinux', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StampCapacity, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.available_capacity = kwargs.get('available_capacity', None)
        self.total_capacity = kwargs.get('total_capacity', None)
        self.unit = kwargs.get('unit', None)
        self.compute_mode = kwargs.get('compute_mode', None)
        self.worker_size = kwargs.get('worker_size', None)
        self.worker_size_id = kwargs.get('worker_size_id', None)
        self.exclude_from_capacity_allocation = kwargs.get('exclude_from_capacity_allocation', None)
        self.is_applicable_for_all_compute_modes = kwargs.get('is_applicable_for_all_compute_modes', None)
        self.site_mode = kwargs.get('site_mode', None)
        self.is_linux = kwargs.get('is_linux', None)


class StampCapacityCollection(msrest.serialization.Model):
    """Collection of stamp capacities.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2021_01_01.models.StampCapacity]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[StampCapacity]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StampCapacityCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class StaticSiteARMResource(Resource):
    """Static Site ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :param location: Required. Resource Location.
    :type location: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: Description of a SKU for a scalable resource.
    :type sku: ~azure.mgmt.web.v2021_01_01.models.SkuDescription
    :param identity: Managed service identity.
    :type identity: ~azure.mgmt.web.v2021_01_01.models.ManagedServiceIdentity
    :ivar default_hostname: The default autogenerated hostname for the static site.
    :vartype default_hostname: str
    :param repository_url: URL for the repository of the static site.
    :type repository_url: str
    :param branch: The target branch in the repository.
    :type branch: str
    :ivar custom_domains: The custom domains associated with this static site.
    :vartype custom_domains: list[str]
    :param repository_token: A user's github repository token. This is used to setup the Github
     Actions workflow file and API secrets.
    :type repository_token: str
    :param build_properties: Build properties to configure on the repository.
    :type build_properties: ~azure.mgmt.web.v2021_01_01.models.StaticSiteBuildProperties
    :ivar private_endpoint_connections: Private endpoint connections.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.web.v2021_01_01.models.ResponseMessageEnvelopeRemotePrivateEndpointConnection]
    :param staging_environment_policy: State indicating whether staging environments are allowed or
     not allowed for a static web app. Possible values include: "Enabled", "Disabled".
    :type staging_environment_policy: str or
     ~azure.mgmt.web.v2021_01_01.models.StagingEnvironmentPolicy
    :param allow_config_file_updates: :code:`<code>false</code>` if config file is locked for this
     static web app; otherwise, :code:`<code>true</code>`.
    :type allow_config_file_updates: bool
    :param template_properties: Template options for generating a new repository.
    :type template_properties: ~azure.mgmt.web.v2021_01_01.models.StaticSiteTemplateOptions
    :ivar content_distribution_endpoint: The content distribution endpoint for the static site.
    :vartype content_distribution_endpoint: str
    :ivar key_vault_reference_identity: Identity to use for Key Vault Reference authentication.
    :vartype key_vault_reference_identity: str
    :ivar user_provided_function_apps: User provided function apps registered with the static site.
    :vartype user_provided_function_apps:
     list[~azure.mgmt.web.v2021_01_01.models.StaticSiteUserProvidedFunctionApp]
    :ivar provider: The provider that submitted the last deployment to the primary environment of
     the static site.
    :vartype provider: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'location': {'required': True},
        'type': {'readonly': True},
        'default_hostname': {'readonly': True},
        'custom_domains': {'readonly': True},
        'private_endpoint_connections': {'readonly': True},
        'content_distribution_endpoint': {'readonly': True},
        'key_vault_reference_identity': {'readonly': True},
        'user_provided_function_apps': {'readonly': True},
        'provider': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'SkuDescription'},
        'identity': {'key': 'identity', 'type': 'ManagedServiceIdentity'},
        'default_hostname': {'key': 'properties.defaultHostname', 'type': 'str'},
        'repository_url': {'key': 'properties.repositoryUrl', 'type': 'str'},
        'branch': {'key': 'properties.branch', 'type': 'str'},
        'custom_domains': {'key': 'properties.customDomains', 'type': '[str]'},
        'repository_token': {'key': 'properties.repositoryToken', 'type': 'str'},
        'build_properties': {'key': 'properties.buildProperties', 'type': 'StaticSiteBuildProperties'},
        'private_endpoint_connections': {'key': 'properties.privateEndpointConnections', 'type': '[ResponseMessageEnvelopeRemotePrivateEndpointConnection]'},
        'staging_environment_policy': {'key': 'properties.stagingEnvironmentPolicy', 'type': 'str'},
        'allow_config_file_updates': {'key': 'properties.allowConfigFileUpdates', 'type': 'bool'},
        'template_properties': {'key': 'properties.templateProperties', 'type': 'StaticSiteTemplateOptions'},
        'content_distribution_endpoint': {'key': 'properties.contentDistributionEndpoint', 'type': 'str'},
        'key_vault_reference_identity': {'key': 'properties.keyVaultReferenceIdentity', 'type': 'str'},
        'user_provided_function_apps': {'key': 'properties.userProvidedFunctionApps', 'type': '[StaticSiteUserProvidedFunctionApp]'},
        'provider': {'key': 'properties.provider', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StaticSiteARMResource, self).__init__(**kwargs)
        self.sku = kwargs.get('sku', None)
        self.identity = kwargs.get('identity', None)
        self.default_hostname = None
        self.repository_url = kwargs.get('repository_url', None)
        self.branch = kwargs.get('branch', None)
        self.custom_domains = None
        self.repository_token = kwargs.get('repository_token', None)
        self.build_properties = kwargs.get('build_properties', None)
        self.private_endpoint_connections = None
        self.staging_environment_policy = kwargs.get('staging_environment_policy', None)
        self.allow_config_file_updates = kwargs.get('allow_config_file_updates', None)
        self.template_properties = kwargs.get('template_properties', None)
        self.content_distribution_endpoint = None
        self.key_vault_reference_identity = None
        self.user_provided_function_apps = None
        self.provider = None


class StaticSiteBuildARMResource(ProxyOnlyResource):
    """Static Site Build ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar build_id: An identifier for the static site build.
    :vartype build_id: str
    :ivar source_branch: The source branch.
    :vartype source_branch: str
    :ivar pull_request_title: The title of a pull request that a static site build is related to.
    :vartype pull_request_title: str
    :ivar hostname: The hostname for a static site build.
    :vartype hostname: str
    :ivar created_time_utc: When this build was created.
    :vartype created_time_utc: ~datetime.datetime
    :ivar last_updated_on: When this build was updated.
    :vartype last_updated_on: ~datetime.datetime
    :ivar status: The status of the static site build. Possible values include:
     "WaitingForDeployment", "Uploading", "Deploying", "Ready", "Failed", "Deleting", "Detached".
    :vartype status: str or ~azure.mgmt.web.v2021_01_01.models.BuildStatus
    :ivar user_provided_function_apps: User provided function apps registered with the static site
     build.
    :vartype user_provided_function_apps:
     list[~azure.mgmt.web.v2021_01_01.models.StaticSiteUserProvidedFunctionApp]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'build_id': {'readonly': True},
        'source_branch': {'readonly': True},
        'pull_request_title': {'readonly': True},
        'hostname': {'readonly': True},
        'created_time_utc': {'readonly': True},
        'last_updated_on': {'readonly': True},
        'status': {'readonly': True},
        'user_provided_function_apps': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'build_id': {'key': 'properties.buildId', 'type': 'str'},
        'source_branch': {'key': 'properties.sourceBranch', 'type': 'str'},
        'pull_request_title': {'key': 'properties.pullRequestTitle', 'type': 'str'},
        'hostname': {'key': 'properties.hostname', 'type': 'str'},
        'created_time_utc': {'key': 'properties.createdTimeUtc', 'type': 'iso-8601'},
        'last_updated_on': {'key': 'properties.lastUpdatedOn', 'type': 'iso-8601'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'user_provided_function_apps': {'key': 'properties.userProvidedFunctionApps', 'type': '[StaticSiteUserProvidedFunctionApp]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StaticSiteBuildARMResource, self).__init__(**kwargs)
        self.build_id = None
        self.source_branch = None
        self.pull_request_title = None
        self.hostname = None
        self.created_time_utc = None
        self.last_updated_on = None
        self.status = None
        self.user_provided_function_apps = None


class StaticSiteBuildCollection(msrest.serialization.Model):
    """Collection of static site builds.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2021_01_01.models.StaticSiteBuildARMResource]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[StaticSiteBuildARMResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StaticSiteBuildCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class StaticSiteBuildProperties(msrest.serialization.Model):
    """Build properties for the static site.

    :param app_location: The path to the app code within the repository.
    :type app_location: str
    :param api_location: The path to the api code within the repository.
    :type api_location: str
    :param app_artifact_location: Deprecated: The path of the app artifacts after building
     (deprecated in favor of OutputLocation).
    :type app_artifact_location: str
    :param output_location: The output path of the app after building.
    :type output_location: str
    :param app_build_command: A custom command to run during deployment of the static content
     application.
    :type app_build_command: str
    :param api_build_command: A custom command to run during deployment of the Azure Functions API
     application.
    :type api_build_command: str
    :param skip_github_action_workflow_generation: Skip Github Action workflow generation.
    :type skip_github_action_workflow_generation: bool
    :param github_action_secret_name_override: Github Action secret name override.
    :type github_action_secret_name_override: str
    """

    _attribute_map = {
        'app_location': {'key': 'appLocation', 'type': 'str'},
        'api_location': {'key': 'apiLocation', 'type': 'str'},
        'app_artifact_location': {'key': 'appArtifactLocation', 'type': 'str'},
        'output_location': {'key': 'outputLocation', 'type': 'str'},
        'app_build_command': {'key': 'appBuildCommand', 'type': 'str'},
        'api_build_command': {'key': 'apiBuildCommand', 'type': 'str'},
        'skip_github_action_workflow_generation': {'key': 'skipGithubActionWorkflowGeneration', 'type': 'bool'},
        'github_action_secret_name_override': {'key': 'githubActionSecretNameOverride', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StaticSiteBuildProperties, self).__init__(**kwargs)
        self.app_location = kwargs.get('app_location', None)
        self.api_location = kwargs.get('api_location', None)
        self.app_artifact_location = kwargs.get('app_artifact_location', None)
        self.output_location = kwargs.get('output_location', None)
        self.app_build_command = kwargs.get('app_build_command', None)
        self.api_build_command = kwargs.get('api_build_command', None)
        self.skip_github_action_workflow_generation = kwargs.get('skip_github_action_workflow_generation', None)
        self.github_action_secret_name_override = kwargs.get('github_action_secret_name_override', None)


class StaticSiteCollection(msrest.serialization.Model):
    """Collection of static sites.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2021_01_01.models.StaticSiteARMResource]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[StaticSiteARMResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StaticSiteCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class StaticSiteCustomDomainOverviewARMResource(ProxyOnlyResource):
    """Static Site Custom Domain Overview ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar domain_name: The domain name for the static site custom domain.
    :vartype domain_name: str
    :ivar created_on: The date and time on which the custom domain was created for the static site.
    :vartype created_on: ~datetime.datetime
    :ivar status: The status of the custom domain. Possible values include:
     "RetrievingValidationToken", "Validating", "Adding", "Ready", "Failed", "Deleting".
    :vartype status: str or ~azure.mgmt.web.v2021_01_01.models.CustomDomainStatus
    :ivar validation_token: The TXT record validation token.
    :vartype validation_token: str
    :ivar error_message:
    :vartype error_message: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'domain_name': {'readonly': True},
        'created_on': {'readonly': True},
        'status': {'readonly': True},
        'validation_token': {'readonly': True},
        'error_message': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'domain_name': {'key': 'properties.domainName', 'type': 'str'},
        'created_on': {'key': 'properties.createdOn', 'type': 'iso-8601'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'validation_token': {'key': 'properties.validationToken', 'type': 'str'},
        'error_message': {'key': 'properties.errorMessage', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StaticSiteCustomDomainOverviewARMResource, self).__init__(**kwargs)
        self.domain_name = None
        self.created_on = None
        self.status = None
        self.validation_token = None
        self.error_message = None


class StaticSiteCustomDomainOverviewCollection(msrest.serialization.Model):
    """Collection of static site custom domains.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2021_01_01.models.StaticSiteCustomDomainOverviewARMResource]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[StaticSiteCustomDomainOverviewARMResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StaticSiteCustomDomainOverviewCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class StaticSiteCustomDomainRequestPropertiesARMResource(ProxyOnlyResource):
    """Static Site Custom Domain Request Properties ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param validation_method: Validation method for adding a custom domain.
    :type validation_method: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'validation_method': {'key': 'properties.validationMethod', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StaticSiteCustomDomainRequestPropertiesARMResource, self).__init__(**kwargs)
        self.validation_method = kwargs.get('validation_method', "cname-delegation")


class StaticSiteFunctionOverviewARMResource(ProxyOnlyResource):
    """Static Site Function Overview ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar function_name: The name for the function.
    :vartype function_name: str
    :ivar trigger_type: The trigger type of the function. Possible values include: "HttpTrigger",
     "Unknown".
    :vartype trigger_type: str or ~azure.mgmt.web.v2021_01_01.models.TriggerTypes
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'function_name': {'readonly': True},
        'trigger_type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'function_name': {'key': 'properties.functionName', 'type': 'str'},
        'trigger_type': {'key': 'properties.triggerType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StaticSiteFunctionOverviewARMResource, self).__init__(**kwargs)
        self.function_name = None
        self.trigger_type = None


class StaticSiteFunctionOverviewCollection(msrest.serialization.Model):
    """Collection of static site functions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2021_01_01.models.StaticSiteFunctionOverviewARMResource]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[StaticSiteFunctionOverviewARMResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StaticSiteFunctionOverviewCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class StaticSitePatchResource(ProxyOnlyResource):
    """ARM resource for a static site when patching.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar default_hostname: The default autogenerated hostname for the static site.
    :vartype default_hostname: str
    :param repository_url: URL for the repository of the static site.
    :type repository_url: str
    :param branch: The target branch in the repository.
    :type branch: str
    :ivar custom_domains: The custom domains associated with this static site.
    :vartype custom_domains: list[str]
    :param repository_token: A user's github repository token. This is used to setup the Github
     Actions workflow file and API secrets.
    :type repository_token: str
    :param build_properties: Build properties to configure on the repository.
    :type build_properties: ~azure.mgmt.web.v2021_01_01.models.StaticSiteBuildProperties
    :ivar private_endpoint_connections: Private endpoint connections.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.web.v2021_01_01.models.ResponseMessageEnvelopeRemotePrivateEndpointConnection]
    :param staging_environment_policy: State indicating whether staging environments are allowed or
     not allowed for a static web app. Possible values include: "Enabled", "Disabled".
    :type staging_environment_policy: str or
     ~azure.mgmt.web.v2021_01_01.models.StagingEnvironmentPolicy
    :param allow_config_file_updates: :code:`<code>false</code>` if config file is locked for this
     static web app; otherwise, :code:`<code>true</code>`.
    :type allow_config_file_updates: bool
    :param template_properties: Template options for generating a new repository.
    :type template_properties: ~azure.mgmt.web.v2021_01_01.models.StaticSiteTemplateOptions
    :ivar content_distribution_endpoint: The content distribution endpoint for the static site.
    :vartype content_distribution_endpoint: str
    :ivar key_vault_reference_identity: Identity to use for Key Vault Reference authentication.
    :vartype key_vault_reference_identity: str
    :ivar user_provided_function_apps: User provided function apps registered with the static site.
    :vartype user_provided_function_apps:
     list[~azure.mgmt.web.v2021_01_01.models.StaticSiteUserProvidedFunctionApp]
    :ivar provider: The provider that submitted the last deployment to the primary environment of
     the static site.
    :vartype provider: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'default_hostname': {'readonly': True},
        'custom_domains': {'readonly': True},
        'private_endpoint_connections': {'readonly': True},
        'content_distribution_endpoint': {'readonly': True},
        'key_vault_reference_identity': {'readonly': True},
        'user_provided_function_apps': {'readonly': True},
        'provider': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'default_hostname': {'key': 'properties.defaultHostname', 'type': 'str'},
        'repository_url': {'key': 'properties.repositoryUrl', 'type': 'str'},
        'branch': {'key': 'properties.branch', 'type': 'str'},
        'custom_domains': {'key': 'properties.customDomains', 'type': '[str]'},
        'repository_token': {'key': 'properties.repositoryToken', 'type': 'str'},
        'build_properties': {'key': 'properties.buildProperties', 'type': 'StaticSiteBuildProperties'},
        'private_endpoint_connections': {'key': 'properties.privateEndpointConnections', 'type': '[ResponseMessageEnvelopeRemotePrivateEndpointConnection]'},
        'staging_environment_policy': {'key': 'properties.stagingEnvironmentPolicy', 'type': 'str'},
        'allow_config_file_updates': {'key': 'properties.allowConfigFileUpdates', 'type': 'bool'},
        'template_properties': {'key': 'properties.templateProperties', 'type': 'StaticSiteTemplateOptions'},
        'content_distribution_endpoint': {'key': 'properties.contentDistributionEndpoint', 'type': 'str'},
        'key_vault_reference_identity': {'key': 'properties.keyVaultReferenceIdentity', 'type': 'str'},
        'user_provided_function_apps': {'key': 'properties.userProvidedFunctionApps', 'type': '[StaticSiteUserProvidedFunctionApp]'},
        'provider': {'key': 'properties.provider', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StaticSitePatchResource, self).__init__(**kwargs)
        self.default_hostname = None
        self.repository_url = kwargs.get('repository_url', None)
        self.branch = kwargs.get('branch', None)
        self.custom_domains = None
        self.repository_token = kwargs.get('repository_token', None)
        self.build_properties = kwargs.get('build_properties', None)
        self.private_endpoint_connections = None
        self.staging_environment_policy = kwargs.get('staging_environment_policy', None)
        self.allow_config_file_updates = kwargs.get('allow_config_file_updates', None)
        self.template_properties = kwargs.get('template_properties', None)
        self.content_distribution_endpoint = None
        self.key_vault_reference_identity = None
        self.user_provided_function_apps = None
        self.provider = None


class StaticSiteResetPropertiesARMResource(ProxyOnlyResource):
    """Static Site Reset Properties ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param repository_token: The token which proves admin privileges to the repository.
    :type repository_token: str
    :param should_update_repository: Determines whether the repository should be updated with the
     new properties.
    :type should_update_repository: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'repository_token': {'key': 'properties.repositoryToken', 'type': 'str'},
        'should_update_repository': {'key': 'properties.shouldUpdateRepository', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StaticSiteResetPropertiesARMResource, self).__init__(**kwargs)
        self.repository_token = kwargs.get('repository_token', None)
        self.should_update_repository = kwargs.get('should_update_repository', None)


class StaticSitesWorkflowPreview(ProxyOnlyResource):
    """Preview for the Static Site Workflow to be generated.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar path: The path for the workflow file to be generated.
    :vartype path: str
    :ivar contents: The contents for the workflow file to be generated.
    :vartype contents: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'path': {'readonly': True},
        'contents': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'path': {'key': 'properties.path', 'type': 'str'},
        'contents': {'key': 'properties.contents', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StaticSitesWorkflowPreview, self).__init__(**kwargs)
        self.path = None
        self.contents = None


class StaticSitesWorkflowPreviewRequest(ProxyOnlyResource):
    """Request entity for previewing the Static Site workflow.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param repository_url: URL for the repository of the static site.
    :type repository_url: str
    :param branch: The target branch in the repository.
    :type branch: str
    :param build_properties: Build properties to configure on the repository.
    :type build_properties: ~azure.mgmt.web.v2021_01_01.models.StaticSiteBuildProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'repository_url': {'key': 'properties.repositoryUrl', 'type': 'str'},
        'branch': {'key': 'properties.branch', 'type': 'str'},
        'build_properties': {'key': 'properties.buildProperties', 'type': 'StaticSiteBuildProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StaticSitesWorkflowPreviewRequest, self).__init__(**kwargs)
        self.repository_url = kwargs.get('repository_url', None)
        self.branch = kwargs.get('branch', None)
        self.build_properties = kwargs.get('build_properties', None)


class StaticSiteTemplateOptions(msrest.serialization.Model):
    """Template Options for the static site.

    :param template_repository_url: URL of the template repository. The newly generated repository
     will be based on this one.
    :type template_repository_url: str
    :param owner: Owner of the newly generated repository.
    :type owner: str
    :param repository_name: Name of the newly generated repository.
    :type repository_name: str
    :param description: Description of the newly generated repository.
    :type description: str
    :param is_private: Whether or not the newly generated repository is a private repository.
     Defaults to false (i.e. public).
    :type is_private: bool
    """

    _attribute_map = {
        'template_repository_url': {'key': 'templateRepositoryUrl', 'type': 'str'},
        'owner': {'key': 'owner', 'type': 'str'},
        'repository_name': {'key': 'repositoryName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'is_private': {'key': 'isPrivate', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StaticSiteTemplateOptions, self).__init__(**kwargs)
        self.template_repository_url = kwargs.get('template_repository_url', None)
        self.owner = kwargs.get('owner', None)
        self.repository_name = kwargs.get('repository_name', None)
        self.description = kwargs.get('description', None)
        self.is_private = kwargs.get('is_private', None)


class StaticSiteUserARMResource(ProxyOnlyResource):
    """Static Site User ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar provider: The identity provider for the static site user.
    :vartype provider: str
    :ivar user_id: The user id for the static site user.
    :vartype user_id: str
    :ivar display_name: The display name for the static site user.
    :vartype display_name: str
    :param roles: The roles for the static site user, in free-form string format.
    :type roles: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provider': {'readonly': True},
        'user_id': {'readonly': True},
        'display_name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'provider': {'key': 'properties.provider', 'type': 'str'},
        'user_id': {'key': 'properties.userId', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'roles': {'key': 'properties.roles', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StaticSiteUserARMResource, self).__init__(**kwargs)
        self.provider = None
        self.user_id = None
        self.display_name = None
        self.roles = kwargs.get('roles', None)


class StaticSiteUserCollection(msrest.serialization.Model):
    """Collection of static site custom users.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2021_01_01.models.StaticSiteUserARMResource]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[StaticSiteUserARMResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StaticSiteUserCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class StaticSiteUserInvitationRequestResource(ProxyOnlyResource):
    """Static sites user roles invitation resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param domain: The domain name for the static site custom domain.
    :type domain: str
    :param provider: The identity provider for the static site user.
    :type provider: str
    :param user_details: The user id for the static site user.
    :type user_details: str
    :param roles: The roles for the static site user, in free-form string format.
    :type roles: str
    :param num_hours_to_expiration: The number of hours the sas token stays valid.
    :type num_hours_to_expiration: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'domain': {'key': 'properties.domain', 'type': 'str'},
        'provider': {'key': 'properties.provider', 'type': 'str'},
        'user_details': {'key': 'properties.userDetails', 'type': 'str'},
        'roles': {'key': 'properties.roles', 'type': 'str'},
        'num_hours_to_expiration': {'key': 'properties.numHoursToExpiration', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StaticSiteUserInvitationRequestResource, self).__init__(**kwargs)
        self.domain = kwargs.get('domain', None)
        self.provider = kwargs.get('provider', None)
        self.user_details = kwargs.get('user_details', None)
        self.roles = kwargs.get('roles', None)
        self.num_hours_to_expiration = kwargs.get('num_hours_to_expiration', None)


class StaticSiteUserInvitationResponseResource(ProxyOnlyResource):
    """Static sites user roles invitation link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar expires_on: The expiration time of the invitation.
    :vartype expires_on: ~datetime.datetime
    :ivar invitation_url: The url for the invitation link.
    :vartype invitation_url: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'expires_on': {'readonly': True},
        'invitation_url': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'expires_on': {'key': 'properties.expiresOn', 'type': 'iso-8601'},
        'invitation_url': {'key': 'properties.invitationUrl', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StaticSiteUserInvitationResponseResource, self).__init__(**kwargs)
        self.expires_on = None
        self.invitation_url = None


class StaticSiteUserProvidedFunctionApp(ProxyOnlyResource):
    """A static site user provided function.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param function_app_resource_id: The resource id of the function app registered with the static
     site.
    :type function_app_resource_id: str
    :param function_app_region: The region of the function app registered with the static site.
    :type function_app_region: str
    :ivar created_on: The date and time on which the function app was registered with the static
     site.
    :vartype created_on: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'created_on': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'function_app_resource_id': {'key': 'properties.functionAppResourceId', 'type': 'str'},
        'function_app_region': {'key': 'properties.functionAppRegion', 'type': 'str'},
        'created_on': {'key': 'properties.createdOn', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StaticSiteUserProvidedFunctionApp, self).__init__(**kwargs)
        self.function_app_resource_id = kwargs.get('function_app_resource_id', None)
        self.function_app_region = kwargs.get('function_app_region', None)
        self.created_on = None


class StaticSiteUserProvidedFunctionAppARMResource(ProxyOnlyResource):
    """Static Site User Provided Function App ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param function_app_resource_id: The resource id of the function app registered with the static
     site.
    :type function_app_resource_id: str
    :param function_app_region: The region of the function app registered with the static site.
    :type function_app_region: str
    :ivar created_on: The date and time on which the function app was registered with the static
     site.
    :vartype created_on: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'created_on': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'function_app_resource_id': {'key': 'properties.functionAppResourceId', 'type': 'str'},
        'function_app_region': {'key': 'properties.functionAppRegion', 'type': 'str'},
        'created_on': {'key': 'properties.createdOn', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StaticSiteUserProvidedFunctionAppARMResource, self).__init__(**kwargs)
        self.function_app_resource_id = kwargs.get('function_app_resource_id', None)
        self.function_app_region = kwargs.get('function_app_region', None)
        self.created_on = None


class StaticSiteUserProvidedFunctionAppsCollection(msrest.serialization.Model):
    """Collection of static site user provided function apps.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value:
     list[~azure.mgmt.web.v2021_01_01.models.StaticSiteUserProvidedFunctionAppARMResource]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[StaticSiteUserProvidedFunctionAppARMResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StaticSiteUserProvidedFunctionAppsCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class StaticSiteZipDeploymentARMResource(ProxyOnlyResource):
    """Static site zip deployment ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param app_zip_url: URL for the zipped app content.
    :type app_zip_url: str
    :param api_zip_url: URL for the zipped api content.
    :type api_zip_url: str
    :param deployment_title: A title to label the deployment.
    :type deployment_title: str
    :param provider: The provider submitting this deployment.
    :type provider: str
    :param function_language: The language of the api content, if it exists.
    :type function_language: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'app_zip_url': {'key': 'properties.appZipUrl', 'type': 'str'},
        'api_zip_url': {'key': 'properties.apiZipUrl', 'type': 'str'},
        'deployment_title': {'key': 'properties.deploymentTitle', 'type': 'str'},
        'provider': {'key': 'properties.provider', 'type': 'str'},
        'function_language': {'key': 'properties.functionLanguage', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StaticSiteZipDeploymentARMResource, self).__init__(**kwargs)
        self.app_zip_url = kwargs.get('app_zip_url', None)
        self.api_zip_url = kwargs.get('api_zip_url', None)
        self.deployment_title = kwargs.get('deployment_title', None)
        self.provider = kwargs.get('provider', None)
        self.function_language = kwargs.get('function_language', None)


class Status(msrest.serialization.Model):
    """Identify the status of the most severe insight generated by the detector.

    :param message: Descriptive message.
    :type message: str
    :param status_id: Level of the most severe insight generated by the detector. Possible values
     include: "Critical", "Warning", "Info", "Success", "None".
    :type status_id: str or ~azure.mgmt.web.v2021_01_01.models.InsightStatus
    """

    _attribute_map = {
        'message': {'key': 'message', 'type': 'str'},
        'status_id': {'key': 'statusId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Status, self).__init__(**kwargs)
        self.message = kwargs.get('message', None)
        self.status_id = kwargs.get('status_id', None)


class StatusCodesBasedTrigger(msrest.serialization.Model):
    """Trigger based on status code.

    :param status: HTTP status code.
    :type status: int
    :param sub_status: Request Sub Status.
    :type sub_status: int
    :param win32_status: Win32 error code.
    :type win32_status: int
    :param count: Request Count.
    :type count: int
    :param time_interval: Time interval.
    :type time_interval: str
    :param path: Request Path.
    :type path: str
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'int'},
        'sub_status': {'key': 'subStatus', 'type': 'int'},
        'win32_status': {'key': 'win32Status', 'type': 'int'},
        'count': {'key': 'count', 'type': 'int'},
        'time_interval': {'key': 'timeInterval', 'type': 'str'},
        'path': {'key': 'path', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StatusCodesBasedTrigger, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.sub_status = kwargs.get('sub_status', None)
        self.win32_status = kwargs.get('win32_status', None)
        self.count = kwargs.get('count', None)
        self.time_interval = kwargs.get('time_interval', None)
        self.path = kwargs.get('path', None)


class StatusCodesRangeBasedTrigger(msrest.serialization.Model):
    """Trigger based on range of status codes.

    :param status_codes: HTTP status code.
    :type status_codes: str
    :param path:
    :type path: str
    :param count: Request Count.
    :type count: int
    :param time_interval: Time interval.
    :type time_interval: str
    """

    _attribute_map = {
        'status_codes': {'key': 'statusCodes', 'type': 'str'},
        'path': {'key': 'path', 'type': 'str'},
        'count': {'key': 'count', 'type': 'int'},
        'time_interval': {'key': 'timeInterval', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StatusCodesRangeBasedTrigger, self).__init__(**kwargs)
        self.status_codes = kwargs.get('status_codes', None)
        self.path = kwargs.get('path', None)
        self.count = kwargs.get('count', None)
        self.time_interval = kwargs.get('time_interval', None)


class StorageMigrationOptions(ProxyOnlyResource):
    """Options for app content migration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param azurefiles_connection_string: AzureFiles connection string.
    :type azurefiles_connection_string: str
    :param azurefiles_share: AzureFiles share.
    :type azurefiles_share: str
    :param switch_site_after_migration: :code:`<code>true</code>`if the app should be switched
     over; otherwise, :code:`<code>false</code>`.
    :type switch_site_after_migration: bool
    :param block_write_access_to_site: :code:`<code>true</code>` if the app should be read only
     during copy operation; otherwise, :code:`<code>false</code>`.
    :type block_write_access_to_site: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'azurefiles_connection_string': {'key': 'properties.azurefilesConnectionString', 'type': 'str'},
        'azurefiles_share': {'key': 'properties.azurefilesShare', 'type': 'str'},
        'switch_site_after_migration': {'key': 'properties.switchSiteAfterMigration', 'type': 'bool'},
        'block_write_access_to_site': {'key': 'properties.blockWriteAccessToSite', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StorageMigrationOptions, self).__init__(**kwargs)
        self.azurefiles_connection_string = kwargs.get('azurefiles_connection_string', None)
        self.azurefiles_share = kwargs.get('azurefiles_share', None)
        self.switch_site_after_migration = kwargs.get('switch_site_after_migration', False)
        self.block_write_access_to_site = kwargs.get('block_write_access_to_site', False)


class StorageMigrationResponse(ProxyOnlyResource):
    """Response for a migration of app content request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar operation_id: When server starts the migration process, it will return an operation ID
     identifying that particular migration operation.
    :vartype operation_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'operation_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'operation_id': {'key': 'properties.operationId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StorageMigrationResponse, self).__init__(**kwargs)
        self.operation_id = None


class StringDictionary(ProxyOnlyResource):
    """String dictionary resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param properties: Settings.
    :type properties: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StringDictionary, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)


class StringList(ProxyOnlyResource):
    """String list resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param properties: List of string resources.
    :type properties: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StringList, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)


class SupportTopic(msrest.serialization.Model):
    """Defines a unique Support Topic.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Support Topic Id.
    :vartype id: str
    :ivar pes_id: Unique resource Id.
    :vartype pes_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'pes_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'pes_id': {'key': 'pesId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SupportTopic, self).__init__(**kwargs)
        self.id = None
        self.pes_id = None


class SwiftVirtualNetwork(ProxyOnlyResource):
    """Swift Virtual Network Contract. This is used to enable the new Swift way of doing virtual network integration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param subnet_resource_id: The Virtual Network subnet's resource ID. This is the subnet that
     this Web App will join. This subnet must have a delegation to Microsoft.Web/serverFarms defined
     first.
    :type subnet_resource_id: str
    :param swift_supported: A flag that specifies if the scale unit this Web App is on supports
     Swift integration.
    :type swift_supported: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'subnet_resource_id': {'key': 'properties.subnetResourceId', 'type': 'str'},
        'swift_supported': {'key': 'properties.swiftSupported', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SwiftVirtualNetwork, self).__init__(**kwargs)
        self.subnet_resource_id = kwargs.get('subnet_resource_id', None)
        self.swift_supported = kwargs.get('swift_supported', None)


class TldLegalAgreement(msrest.serialization.Model):
    """Legal agreement for a top level domain.

    All required parameters must be populated in order to send to Azure.

    :param agreement_key: Required. Unique identifier for the agreement.
    :type agreement_key: str
    :param title: Required. Agreement title.
    :type title: str
    :param content: Required. Agreement details.
    :type content: str
    :param url: URL where a copy of the agreement details is hosted.
    :type url: str
    """

    _validation = {
        'agreement_key': {'required': True},
        'title': {'required': True},
        'content': {'required': True},
    }

    _attribute_map = {
        'agreement_key': {'key': 'agreementKey', 'type': 'str'},
        'title': {'key': 'title', 'type': 'str'},
        'content': {'key': 'content', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TldLegalAgreement, self).__init__(**kwargs)
        self.agreement_key = kwargs['agreement_key']
        self.title = kwargs['title']
        self.content = kwargs['content']
        self.url = kwargs.get('url', None)


class TldLegalAgreementCollection(msrest.serialization.Model):
    """Collection of top-level domain legal agreements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2021_01_01.models.TldLegalAgreement]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[TldLegalAgreement]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TldLegalAgreementCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class TokenStore(msrest.serialization.Model):
    """The configuration settings of the token store.

    :param enabled: :code:`<code>true</code>` to durably store platform-specific security tokens
     that are obtained during login flows; otherwise, :code:`<code>false</code>`.
      The default is :code:`<code>false</code>`.
    :type enabled: bool
    :param token_refresh_extension_hours: The number of hours after session token expiration that a
     session token can be used to
     call the token refresh API. The default is 72 hours.
    :type token_refresh_extension_hours: float
    :param file_system: The configuration settings of the storage of the tokens if a file system is
     used.
    :type file_system: ~azure.mgmt.web.v2021_01_01.models.FileSystemTokenStore
    :param azure_blob_storage: The configuration settings of the storage of the tokens if blob
     storage is used.
    :type azure_blob_storage: ~azure.mgmt.web.v2021_01_01.models.BlobStorageTokenStore
    """

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'token_refresh_extension_hours': {'key': 'tokenRefreshExtensionHours', 'type': 'float'},
        'file_system': {'key': 'fileSystem', 'type': 'FileSystemTokenStore'},
        'azure_blob_storage': {'key': 'azureBlobStorage', 'type': 'BlobStorageTokenStore'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TokenStore, self).__init__(**kwargs)
        self.enabled = kwargs.get('enabled', None)
        self.token_refresh_extension_hours = kwargs.get('token_refresh_extension_hours', None)
        self.file_system = kwargs.get('file_system', None)
        self.azure_blob_storage = kwargs.get('azure_blob_storage', None)


class TopLevelDomain(ProxyOnlyResource):
    """A top level domain object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param privacy: If :code:`<code>true</code>`, then the top level domain supports domain
     privacy; otherwise, :code:`<code>false</code>`.
    :type privacy: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'privacy': {'key': 'properties.privacy', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TopLevelDomain, self).__init__(**kwargs)
        self.privacy = kwargs.get('privacy', None)


class TopLevelDomainAgreementOption(msrest.serialization.Model):
    """Options for retrieving the list of top level domain legal agreements.

    :param include_privacy: If :code:`<code>true</code>`, then the list of agreements will include
     agreements for domain privacy as well; otherwise, :code:`<code>false</code>`.
    :type include_privacy: bool
    :param for_transfer: If :code:`<code>true</code>`, then the list of agreements will include
     agreements for domain transfer as well; otherwise, :code:`<code>false</code>`.
    :type for_transfer: bool
    """

    _attribute_map = {
        'include_privacy': {'key': 'includePrivacy', 'type': 'bool'},
        'for_transfer': {'key': 'forTransfer', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TopLevelDomainAgreementOption, self).__init__(**kwargs)
        self.include_privacy = kwargs.get('include_privacy', None)
        self.for_transfer = kwargs.get('for_transfer', None)


class TopLevelDomainCollection(msrest.serialization.Model):
    """Collection of Top-level domains.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2021_01_01.models.TopLevelDomain]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[TopLevelDomain]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TopLevelDomainCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class TriggeredJobHistory(ProxyOnlyResource):
    """Triggered Web Job History. List of Triggered Web Job Run Information elements.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param runs: List of triggered web job runs.
    :type runs: list[~azure.mgmt.web.v2021_01_01.models.TriggeredJobRun]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'runs': {'key': 'properties.runs', 'type': '[TriggeredJobRun]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TriggeredJobHistory, self).__init__(**kwargs)
        self.runs = kwargs.get('runs', None)


class TriggeredJobHistoryCollection(msrest.serialization.Model):
    """Collection of Kudu continuous web job information elements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2021_01_01.models.TriggeredJobHistory]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[TriggeredJobHistory]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TriggeredJobHistoryCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class TriggeredJobRun(ProxyOnlyResource):
    """Triggered Web Job Run Information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param web_job_id: Job ID.
    :type web_job_id: str
    :param web_job_name: Job name.
    :type web_job_name: str
    :param status: Job status. Possible values include: "Success", "Failed", "Error".
    :type status: str or ~azure.mgmt.web.v2021_01_01.models.TriggeredWebJobStatus
    :param start_time: Start time.
    :type start_time: ~datetime.datetime
    :param end_time: End time.
    :type end_time: ~datetime.datetime
    :param duration: Job duration.
    :type duration: str
    :param output_url: Output URL.
    :type output_url: str
    :param error_url: Error URL.
    :type error_url: str
    :param url: Job URL.
    :type url: str
    :param job_name: Job name.
    :type job_name: str
    :param trigger: Job trigger.
    :type trigger: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'web_job_id': {'key': 'properties.web_job_id', 'type': 'str'},
        'web_job_name': {'key': 'properties.web_job_name', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'start_time': {'key': 'properties.start_time', 'type': 'iso-8601'},
        'end_time': {'key': 'properties.end_time', 'type': 'iso-8601'},
        'duration': {'key': 'properties.duration', 'type': 'str'},
        'output_url': {'key': 'properties.output_url', 'type': 'str'},
        'error_url': {'key': 'properties.error_url', 'type': 'str'},
        'url': {'key': 'properties.url', 'type': 'str'},
        'job_name': {'key': 'properties.job_name', 'type': 'str'},
        'trigger': {'key': 'properties.trigger', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TriggeredJobRun, self).__init__(**kwargs)
        self.web_job_id = kwargs.get('web_job_id', None)
        self.web_job_name = kwargs.get('web_job_name', None)
        self.status = kwargs.get('status', None)
        self.start_time = kwargs.get('start_time', None)
        self.end_time = kwargs.get('end_time', None)
        self.duration = kwargs.get('duration', None)
        self.output_url = kwargs.get('output_url', None)
        self.error_url = kwargs.get('error_url', None)
        self.url = kwargs.get('url', None)
        self.job_name = kwargs.get('job_name', None)
        self.trigger = kwargs.get('trigger', None)


class TriggeredWebJob(ProxyOnlyResource):
    """Triggered Web Job Information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param latest_run: Latest job run information.
    :type latest_run: ~azure.mgmt.web.v2021_01_01.models.TriggeredJobRun
    :param history_url: History URL.
    :type history_url: str
    :param scheduler_logs_url: Scheduler Logs URL.
    :type scheduler_logs_url: str
    :param run_command: Run command.
    :type run_command: str
    :param url: Job URL.
    :type url: str
    :param extra_info_url: Extra Info URL.
    :type extra_info_url: str
    :param web_job_type: Job type. Possible values include: "Continuous", "Triggered".
    :type web_job_type: str or ~azure.mgmt.web.v2021_01_01.models.WebJobType
    :param error: Error information.
    :type error: str
    :param using_sdk: Using SDK?.
    :type using_sdk: bool
    :param settings: Job settings.
    :type settings: dict[str, any]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'latest_run': {'key': 'properties.latest_run', 'type': 'TriggeredJobRun'},
        'history_url': {'key': 'properties.history_url', 'type': 'str'},
        'scheduler_logs_url': {'key': 'properties.scheduler_logs_url', 'type': 'str'},
        'run_command': {'key': 'properties.run_command', 'type': 'str'},
        'url': {'key': 'properties.url', 'type': 'str'},
        'extra_info_url': {'key': 'properties.extra_info_url', 'type': 'str'},
        'web_job_type': {'key': 'properties.web_job_type', 'type': 'str'},
        'error': {'key': 'properties.error', 'type': 'str'},
        'using_sdk': {'key': 'properties.using_sdk', 'type': 'bool'},
        'settings': {'key': 'properties.settings', 'type': '{object}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TriggeredWebJob, self).__init__(**kwargs)
        self.latest_run = kwargs.get('latest_run', None)
        self.history_url = kwargs.get('history_url', None)
        self.scheduler_logs_url = kwargs.get('scheduler_logs_url', None)
        self.run_command = kwargs.get('run_command', None)
        self.url = kwargs.get('url', None)
        self.extra_info_url = kwargs.get('extra_info_url', None)
        self.web_job_type = kwargs.get('web_job_type', None)
        self.error = kwargs.get('error', None)
        self.using_sdk = kwargs.get('using_sdk', None)
        self.settings = kwargs.get('settings', None)


class TriggeredWebJobCollection(msrest.serialization.Model):
    """Collection of Kudu continuous web job information elements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2021_01_01.models.TriggeredWebJob]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[TriggeredWebJob]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TriggeredWebJobCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class Twitter(msrest.serialization.Model):
    """The configuration settings of the Twitter provider.

    :param enabled: :code:`<code>false</code>` if the Twitter provider should not be enabled
     despite the set registration; otherwise, :code:`<code>true</code>`.
    :type enabled: bool
    :param registration: The configuration settings of the app registration for the Twitter
     provider.
    :type registration: ~azure.mgmt.web.v2021_01_01.models.TwitterRegistration
    """

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'registration': {'key': 'registration', 'type': 'TwitterRegistration'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Twitter, self).__init__(**kwargs)
        self.enabled = kwargs.get('enabled', None)
        self.registration = kwargs.get('registration', None)


class TwitterRegistration(msrest.serialization.Model):
    """The configuration settings of the app registration for the Twitter provider.

    :param consumer_key: The OAuth 1.0a consumer key of the Twitter application used for sign-in.
     This setting is required for enabling Twitter Sign-In.
     Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in.
    :type consumer_key: str
    :param consumer_secret_setting_name: The app setting name that contains the OAuth 1.0a consumer
     secret of the Twitter
     application used for sign-in.
    :type consumer_secret_setting_name: str
    """

    _attribute_map = {
        'consumer_key': {'key': 'consumerKey', 'type': 'str'},
        'consumer_secret_setting_name': {'key': 'consumerSecretSettingName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TwitterRegistration, self).__init__(**kwargs)
        self.consumer_key = kwargs.get('consumer_key', None)
        self.consumer_secret_setting_name = kwargs.get('consumer_secret_setting_name', None)


class Usage(ProxyOnlyResource):
    """Usage of the quota resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar display_name: Friendly name shown in the UI.
    :vartype display_name: str
    :ivar resource_name: Name of the quota resource.
    :vartype resource_name: str
    :ivar unit: Units of measurement for the quota resource.
    :vartype unit: str
    :ivar current_value: The current value of the resource counter.
    :vartype current_value: long
    :ivar limit: The resource limit.
    :vartype limit: long
    :ivar next_reset_time: Next reset time for the resource counter.
    :vartype next_reset_time: ~datetime.datetime
    :ivar compute_mode: Compute mode used for this usage. Possible values include: "Shared",
     "Dedicated", "Dynamic".
    :vartype compute_mode: str or ~azure.mgmt.web.v2021_01_01.models.ComputeModeOptions
    :ivar site_mode: Site mode used for this usage.
    :vartype site_mode: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'display_name': {'readonly': True},
        'resource_name': {'readonly': True},
        'unit': {'readonly': True},
        'current_value': {'readonly': True},
        'limit': {'readonly': True},
        'next_reset_time': {'readonly': True},
        'compute_mode': {'readonly': True},
        'site_mode': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'resource_name': {'key': 'properties.resourceName', 'type': 'str'},
        'unit': {'key': 'properties.unit', 'type': 'str'},
        'current_value': {'key': 'properties.currentValue', 'type': 'long'},
        'limit': {'key': 'properties.limit', 'type': 'long'},
        'next_reset_time': {'key': 'properties.nextResetTime', 'type': 'iso-8601'},
        'compute_mode': {'key': 'properties.computeMode', 'type': 'str'},
        'site_mode': {'key': 'properties.siteMode', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Usage, self).__init__(**kwargs)
        self.display_name = None
        self.resource_name = None
        self.unit = None
        self.current_value = None
        self.limit = None
        self.next_reset_time = None
        self.compute_mode = None
        self.site_mode = None


class UsageCollection(msrest.serialization.Model):
    """Collection of usages.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2021_01_01.models.Usage]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Usage]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UsageCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class User(ProxyOnlyResource):
    """User credentials used for publishing activity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param publishing_user_name: Username used for publishing.
    :type publishing_user_name: str
    :param publishing_password: Password used for publishing.
    :type publishing_password: str
    :param publishing_password_hash: Password hash used for publishing.
    :type publishing_password_hash: str
    :param publishing_password_hash_salt: Password hash salt used for publishing.
    :type publishing_password_hash_salt: str
    :param scm_uri: Url of SCM site.
    :type scm_uri: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'publishing_user_name': {'key': 'properties.publishingUserName', 'type': 'str'},
        'publishing_password': {'key': 'properties.publishingPassword', 'type': 'str'},
        'publishing_password_hash': {'key': 'properties.publishingPasswordHash', 'type': 'str'},
        'publishing_password_hash_salt': {'key': 'properties.publishingPasswordHashSalt', 'type': 'str'},
        'scm_uri': {'key': 'properties.scmUri', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(User, self).__init__(**kwargs)
        self.publishing_user_name = kwargs.get('publishing_user_name', None)
        self.publishing_password = kwargs.get('publishing_password', None)
        self.publishing_password_hash = kwargs.get('publishing_password_hash', None)
        self.publishing_password_hash_salt = kwargs.get('publishing_password_hash_salt', None)
        self.scm_uri = kwargs.get('scm_uri', None)


class ValidateRequest(msrest.serialization.Model):
    """Resource validation request content.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Resource name to verify.
    :type name: str
    :param type: Required. Resource type used for verification. Possible values include:
     "ServerFarm", "Site", "Microsoft.Web/hostingEnvironments".
    :type type: str or ~azure.mgmt.web.v2021_01_01.models.ValidateResourceTypes
    :param location: Required. Expected location of the resource.
    :type location: str
    :param server_farm_id: ARM resource ID of an App Service plan that would host the app.
    :type server_farm_id: str
    :param sku_name: Name of the target SKU for the App Service plan.
    :type sku_name: str
    :param need_linux_workers: :code:`<code>true</code>` if App Service plan is for Linux workers;
     otherwise, :code:`<code>false</code>`.
    :type need_linux_workers: bool
    :param is_spot: :code:`<code>true</code>` if App Service plan is for Spot instances; otherwise,
     :code:`<code>false</code>`.
    :type is_spot: bool
    :param capacity: Target capacity of the App Service plan (number of VMs).
    :type capacity: int
    :param hosting_environment: Name of App Service Environment where app or App Service plan
     should be created.
    :type hosting_environment: str
    :param is_xenon: :code:`<code>true</code>` if App Service plan is running as a windows
     container.
    :type is_xenon: bool
    :param container_registry_base_url: Base URL of the container registry.
    :type container_registry_base_url: str
    :param container_registry_username: Username for to access the container registry.
    :type container_registry_username: str
    :param container_registry_password: Password for to access the container registry.
    :type container_registry_password: str
    :param container_image_repository: Repository name (image name).
    :type container_image_repository: str
    :param container_image_tag: Image tag.
    :type container_image_tag: str
    :param container_image_platform: Platform (windows or linux).
    :type container_image_platform: str
    :param app_service_environment: App Service Environment Properties.
    :type app_service_environment: ~azure.mgmt.web.v2021_01_01.models.AppServiceEnvironment
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'location': {'required': True},
        'capacity': {'minimum': 1},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'server_farm_id': {'key': 'properties.serverFarmId', 'type': 'str'},
        'sku_name': {'key': 'properties.skuName', 'type': 'str'},
        'need_linux_workers': {'key': 'properties.needLinuxWorkers', 'type': 'bool'},
        'is_spot': {'key': 'properties.isSpot', 'type': 'bool'},
        'capacity': {'key': 'properties.capacity', 'type': 'int'},
        'hosting_environment': {'key': 'properties.hostingEnvironment', 'type': 'str'},
        'is_xenon': {'key': 'properties.isXenon', 'type': 'bool'},
        'container_registry_base_url': {'key': 'properties.containerRegistryBaseUrl', 'type': 'str'},
        'container_registry_username': {'key': 'properties.containerRegistryUsername', 'type': 'str'},
        'container_registry_password': {'key': 'properties.containerRegistryPassword', 'type': 'str'},
        'container_image_repository': {'key': 'properties.containerImageRepository', 'type': 'str'},
        'container_image_tag': {'key': 'properties.containerImageTag', 'type': 'str'},
        'container_image_platform': {'key': 'properties.containerImagePlatform', 'type': 'str'},
        'app_service_environment': {'key': 'properties.appServiceEnvironment', 'type': 'AppServiceEnvironment'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ValidateRequest, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.type = kwargs['type']
        self.location = kwargs['location']
        self.server_farm_id = kwargs.get('server_farm_id', None)
        self.sku_name = kwargs.get('sku_name', None)
        self.need_linux_workers = kwargs.get('need_linux_workers', None)
        self.is_spot = kwargs.get('is_spot', None)
        self.capacity = kwargs.get('capacity', None)
        self.hosting_environment = kwargs.get('hosting_environment', None)
        self.is_xenon = kwargs.get('is_xenon', None)
        self.container_registry_base_url = kwargs.get('container_registry_base_url', None)
        self.container_registry_username = kwargs.get('container_registry_username', None)
        self.container_registry_password = kwargs.get('container_registry_password', None)
        self.container_image_repository = kwargs.get('container_image_repository', None)
        self.container_image_tag = kwargs.get('container_image_tag', None)
        self.container_image_platform = kwargs.get('container_image_platform', None)
        self.app_service_environment = kwargs.get('app_service_environment', None)


class ValidateResponse(msrest.serialization.Model):
    """Describes the result of resource validation.

    :param status: Result of validation.
    :type status: str
    :param error: Error details for the case when validation fails.
    :type error: ~azure.mgmt.web.v2021_01_01.models.ValidateResponseError
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'error': {'key': 'error', 'type': 'ValidateResponseError'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ValidateResponse, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.error = kwargs.get('error', None)


class ValidateResponseError(msrest.serialization.Model):
    """Error details for when validation fails.

    :param code: Validation error code.
    :type code: str
    :param message: Validation error message.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ValidateResponseError, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)


class VirtualApplication(msrest.serialization.Model):
    """Virtual application in an app.

    :param virtual_path: Virtual path.
    :type virtual_path: str
    :param physical_path: Physical path.
    :type physical_path: str
    :param preload_enabled: :code:`<code>true</code>` if preloading is enabled; otherwise,
     :code:`<code>false</code>`.
    :type preload_enabled: bool
    :param virtual_directories: Virtual directories for virtual application.
    :type virtual_directories: list[~azure.mgmt.web.v2021_01_01.models.VirtualDirectory]
    """

    _attribute_map = {
        'virtual_path': {'key': 'virtualPath', 'type': 'str'},
        'physical_path': {'key': 'physicalPath', 'type': 'str'},
        'preload_enabled': {'key': 'preloadEnabled', 'type': 'bool'},
        'virtual_directories': {'key': 'virtualDirectories', 'type': '[VirtualDirectory]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualApplication, self).__init__(**kwargs)
        self.virtual_path = kwargs.get('virtual_path', None)
        self.physical_path = kwargs.get('physical_path', None)
        self.preload_enabled = kwargs.get('preload_enabled', None)
        self.virtual_directories = kwargs.get('virtual_directories', None)


class VirtualDirectory(msrest.serialization.Model):
    """Directory for virtual application.

    :param virtual_path: Path to virtual application.
    :type virtual_path: str
    :param physical_path: Physical path.
    :type physical_path: str
    """

    _attribute_map = {
        'virtual_path': {'key': 'virtualPath', 'type': 'str'},
        'physical_path': {'key': 'physicalPath', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualDirectory, self).__init__(**kwargs)
        self.virtual_path = kwargs.get('virtual_path', None)
        self.physical_path = kwargs.get('physical_path', None)


class VirtualIPMapping(msrest.serialization.Model):
    """Virtual IP mapping.

    :param virtual_ip: Virtual IP address.
    :type virtual_ip: str
    :param internal_http_port: Internal HTTP port.
    :type internal_http_port: int
    :param internal_https_port: Internal HTTPS port.
    :type internal_https_port: int
    :param in_use: Is virtual IP mapping in use.
    :type in_use: bool
    :param service_name: name of the service that virtual IP is assigned to.
    :type service_name: str
    """

    _attribute_map = {
        'virtual_ip': {'key': 'virtualIP', 'type': 'str'},
        'internal_http_port': {'key': 'internalHttpPort', 'type': 'int'},
        'internal_https_port': {'key': 'internalHttpsPort', 'type': 'int'},
        'in_use': {'key': 'inUse', 'type': 'bool'},
        'service_name': {'key': 'serviceName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualIPMapping, self).__init__(**kwargs)
        self.virtual_ip = kwargs.get('virtual_ip', None)
        self.internal_http_port = kwargs.get('internal_http_port', None)
        self.internal_https_port = kwargs.get('internal_https_port', None)
        self.in_use = kwargs.get('in_use', None)
        self.service_name = kwargs.get('service_name', None)


class VirtualNetworkProfile(msrest.serialization.Model):
    """Specification for using a Virtual Network.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Resource id of the Virtual Network.
    :type id: str
    :ivar name: Name of the Virtual Network (read-only).
    :vartype name: str
    :ivar type: Resource type of the Virtual Network (read-only).
    :vartype type: str
    :param subnet: Subnet within the Virtual Network.
    :type subnet: str
    """

    _validation = {
        'id': {'required': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'subnet': {'key': 'subnet', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualNetworkProfile, self).__init__(**kwargs)
        self.id = kwargs['id']
        self.name = None
        self.type = None
        self.subnet = kwargs.get('subnet', None)


class VnetGateway(ProxyOnlyResource):
    """The Virtual Network gateway contract. This is used to give the Virtual Network gateway access to the VPN package.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param vnet_name: The Virtual Network name.
    :type vnet_name: str
    :param vpn_package_uri: The URI where the VPN package can be downloaded.
    :type vpn_package_uri: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'vnet_name': {'key': 'properties.vnetName', 'type': 'str'},
        'vpn_package_uri': {'key': 'properties.vpnPackageUri', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VnetGateway, self).__init__(**kwargs)
        self.vnet_name = kwargs.get('vnet_name', None)
        self.vpn_package_uri = kwargs.get('vpn_package_uri', None)


class VnetInfo(ProxyOnlyResource):
    """Virtual Network information contract.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param vnet_resource_id: The Virtual Network's resource ID.
    :type vnet_resource_id: str
    :ivar cert_thumbprint: The client certificate thumbprint.
    :vartype cert_thumbprint: str
    :param cert_blob: A certificate file (.cer) blob containing the public key of the private key
     used to authenticate a
     Point-To-Site VPN connection.
    :type cert_blob: str
    :ivar routes: The routes that this Virtual Network connection uses.
    :vartype routes: list[~azure.mgmt.web.v2021_01_01.models.VnetRoute]
    :ivar resync_required: :code:`<code>true</code>` if a resync is required; otherwise,
     :code:`<code>false</code>`.
    :vartype resync_required: bool
    :param dns_servers: DNS servers to be used by this Virtual Network. This should be a
     comma-separated list of IP addresses.
    :type dns_servers: str
    :param is_swift: Flag that is used to denote if this is VNET injection.
    :type is_swift: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'cert_thumbprint': {'readonly': True},
        'routes': {'readonly': True},
        'resync_required': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'vnet_resource_id': {'key': 'properties.vnetResourceId', 'type': 'str'},
        'cert_thumbprint': {'key': 'properties.certThumbprint', 'type': 'str'},
        'cert_blob': {'key': 'properties.certBlob', 'type': 'str'},
        'routes': {'key': 'properties.routes', 'type': '[VnetRoute]'},
        'resync_required': {'key': 'properties.resyncRequired', 'type': 'bool'},
        'dns_servers': {'key': 'properties.dnsServers', 'type': 'str'},
        'is_swift': {'key': 'properties.isSwift', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VnetInfo, self).__init__(**kwargs)
        self.vnet_resource_id = kwargs.get('vnet_resource_id', None)
        self.cert_thumbprint = None
        self.cert_blob = kwargs.get('cert_blob', None)
        self.routes = None
        self.resync_required = None
        self.dns_servers = kwargs.get('dns_servers', None)
        self.is_swift = kwargs.get('is_swift', None)


class VnetParameters(ProxyOnlyResource):
    """The required set of inputs to validate a VNET.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param vnet_resource_group: The Resource Group of the VNET to be validated.
    :type vnet_resource_group: str
    :param vnet_name: The name of the VNET to be validated.
    :type vnet_name: str
    :param vnet_subnet_name: The subnet name to be validated.
    :type vnet_subnet_name: str
    :param subnet_resource_id: The ARM Resource ID of the subnet to validate.
    :type subnet_resource_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'vnet_resource_group': {'key': 'properties.vnetResourceGroup', 'type': 'str'},
        'vnet_name': {'key': 'properties.vnetName', 'type': 'str'},
        'vnet_subnet_name': {'key': 'properties.vnetSubnetName', 'type': 'str'},
        'subnet_resource_id': {'key': 'properties.subnetResourceId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VnetParameters, self).__init__(**kwargs)
        self.vnet_resource_group = kwargs.get('vnet_resource_group', None)
        self.vnet_name = kwargs.get('vnet_name', None)
        self.vnet_subnet_name = kwargs.get('vnet_subnet_name', None)
        self.subnet_resource_id = kwargs.get('subnet_resource_id', None)


class VnetRoute(ProxyOnlyResource):
    """Virtual Network route contract used to pass routing information for a Virtual Network.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param start_address: The starting address for this route. This may also include a CIDR
     notation, in which case the end address must not be specified.
    :type start_address: str
    :param end_address: The ending address for this route. If the start address is specified in
     CIDR notation, this must be omitted.
    :type end_address: str
    :param route_type: The type of route this is:
     DEFAULT - By default, every app has routes to the local address ranges specified by RFC1918
     INHERITED - Routes inherited from the real Virtual Network routes
     STATIC - Static route set on the app only
    
     These values will be used for syncing an app's routes with those from a Virtual Network.
     Possible values include: "DEFAULT", "INHERITED", "STATIC".
    :type route_type: str or ~azure.mgmt.web.v2021_01_01.models.RouteType
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'start_address': {'key': 'properties.startAddress', 'type': 'str'},
        'end_address': {'key': 'properties.endAddress', 'type': 'str'},
        'route_type': {'key': 'properties.routeType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VnetRoute, self).__init__(**kwargs)
        self.start_address = kwargs.get('start_address', None)
        self.end_address = kwargs.get('end_address', None)
        self.route_type = kwargs.get('route_type', None)


class VnetValidationFailureDetails(ProxyOnlyResource):
    """A class that describes the reason for a validation failure.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param message: Text describing the validation outcome.
    :type message: str
    :param failed: A flag describing whether or not validation failed.
    :type failed: bool
    :param failed_tests: A list of tests that failed in the validation.
    :type failed_tests: list[~azure.mgmt.web.v2021_01_01.models.VnetValidationTestFailure]
    :param warnings: A list of warnings generated during validation.
    :type warnings: list[~azure.mgmt.web.v2021_01_01.models.VnetValidationTestFailure]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'message': {'key': 'properties.message', 'type': 'str'},
        'failed': {'key': 'properties.failed', 'type': 'bool'},
        'failed_tests': {'key': 'properties.failedTests', 'type': '[VnetValidationTestFailure]'},
        'warnings': {'key': 'properties.warnings', 'type': '[VnetValidationTestFailure]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VnetValidationFailureDetails, self).__init__(**kwargs)
        self.message = kwargs.get('message', None)
        self.failed = kwargs.get('failed', None)
        self.failed_tests = kwargs.get('failed_tests', None)
        self.warnings = kwargs.get('warnings', None)


class VnetValidationTestFailure(ProxyOnlyResource):
    """A class that describes a test that failed during NSG and UDR validation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param test_name: The name of the test that failed.
    :type test_name: str
    :param details: The details of what caused the failure, e.g. the blocking rule name, etc.
    :type details: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'test_name': {'key': 'properties.testName', 'type': 'str'},
        'details': {'key': 'properties.details', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VnetValidationTestFailure, self).__init__(**kwargs)
        self.test_name = kwargs.get('test_name', None)
        self.details = kwargs.get('details', None)


class WebAppCollection(msrest.serialization.Model):
    """Collection of App Service apps.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2021_01_01.models.Site]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Site]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WebAppCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class WebAppInstanceStatusCollection(msrest.serialization.Model):
    """Collection of app instances.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2021_01_01.models.WebSiteInstanceStatus]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[WebSiteInstanceStatus]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WebAppInstanceStatusCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class WebAppMajorVersion(msrest.serialization.Model):
    """Web App stack major version.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar display_text: Web App stack major version (display only).
    :vartype display_text: str
    :ivar value: Web App stack major version name.
    :vartype value: str
    :ivar minor_versions: Minor versions associated with the major version.
    :vartype minor_versions: list[~azure.mgmt.web.v2021_01_01.models.WebAppMinorVersion]
    """

    _validation = {
        'display_text': {'readonly': True},
        'value': {'readonly': True},
        'minor_versions': {'readonly': True},
    }

    _attribute_map = {
        'display_text': {'key': 'displayText', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'minor_versions': {'key': 'minorVersions', 'type': '[WebAppMinorVersion]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WebAppMajorVersion, self).__init__(**kwargs)
        self.display_text = None
        self.value = None
        self.minor_versions = None


class WebAppMinorVersion(msrest.serialization.Model):
    """Web App stack minor version.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar display_text: Web App stack minor version (display only).
    :vartype display_text: str
    :ivar value: Web App stack major version name.
    :vartype value: str
    :ivar stack_settings: Settings associated with the minor version.
    :vartype stack_settings: ~azure.mgmt.web.v2021_01_01.models.WebAppRuntimes
    """

    _validation = {
        'display_text': {'readonly': True},
        'value': {'readonly': True},
        'stack_settings': {'readonly': True},
    }

    _attribute_map = {
        'display_text': {'key': 'displayText', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'stack_settings': {'key': 'stackSettings', 'type': 'WebAppRuntimes'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WebAppMinorVersion, self).__init__(**kwargs)
        self.display_text = None
        self.value = None
        self.stack_settings = None


class WebAppRuntimes(msrest.serialization.Model):
    """Web App stack runtimes.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar linux_runtime_settings: Linux-specific settings associated with the minor version.
    :vartype linux_runtime_settings: ~azure.mgmt.web.v2021_01_01.models.WebAppRuntimeSettings
    :ivar windows_runtime_settings: Windows-specific settings associated with the minor version.
    :vartype windows_runtime_settings: ~azure.mgmt.web.v2021_01_01.models.WebAppRuntimeSettings
    :ivar linux_container_settings: Linux-specific settings associated with the Java container
     minor version.
    :vartype linux_container_settings:
     ~azure.mgmt.web.v2021_01_01.models.LinuxJavaContainerSettings
    :ivar windows_container_settings: Windows-specific settings associated with the Java container
     minor version.
    :vartype windows_container_settings:
     ~azure.mgmt.web.v2021_01_01.models.WindowsJavaContainerSettings
    """

    _validation = {
        'linux_runtime_settings': {'readonly': True},
        'windows_runtime_settings': {'readonly': True},
        'linux_container_settings': {'readonly': True},
        'windows_container_settings': {'readonly': True},
    }

    _attribute_map = {
        'linux_runtime_settings': {'key': 'linuxRuntimeSettings', 'type': 'WebAppRuntimeSettings'},
        'windows_runtime_settings': {'key': 'windowsRuntimeSettings', 'type': 'WebAppRuntimeSettings'},
        'linux_container_settings': {'key': 'linuxContainerSettings', 'type': 'LinuxJavaContainerSettings'},
        'windows_container_settings': {'key': 'windowsContainerSettings', 'type': 'WindowsJavaContainerSettings'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WebAppRuntimes, self).__init__(**kwargs)
        self.linux_runtime_settings = None
        self.windows_runtime_settings = None
        self.linux_container_settings = None
        self.windows_container_settings = None


class WebAppRuntimeSettings(msrest.serialization.Model):
    """Web App runtime settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar runtime_version: Web App stack minor version (runtime only).
    :vartype runtime_version: str
    :ivar remote_debugging_supported: :code:`<code>true</code>` if remote debugging is supported
     for the stack; otherwise, :code:`<code>false</code>`.
    :vartype remote_debugging_supported: bool
    :ivar app_insights_settings: Application Insights settings associated with the minor version.
    :vartype app_insights_settings:
     ~azure.mgmt.web.v2021_01_01.models.AppInsightsWebAppStackSettings
    :ivar git_hub_action_settings: GitHub Actions settings associated with the minor version.
    :vartype git_hub_action_settings:
     ~azure.mgmt.web.v2021_01_01.models.GitHubActionWebAppStackSettings
    :ivar is_preview: :code:`<code>true</code>` if the stack is in preview; otherwise,
     :code:`<code>false</code>`.
    :vartype is_preview: bool
    :ivar is_deprecated: :code:`<code>true</code>` if the stack is deprecated; otherwise,
     :code:`<code>false</code>`.
    :vartype is_deprecated: bool
    :ivar is_hidden: :code:`<code>true</code>` if the stack should be hidden; otherwise,
     :code:`<code>false</code>`.
    :vartype is_hidden: bool
    :ivar end_of_life_date: End-of-life date for the minor version.
    :vartype end_of_life_date: ~datetime.datetime
    :ivar is_auto_update: :code:`<code>true</code>` if the stack version is auto-updated;
     otherwise, :code:`<code>false</code>`.
    :vartype is_auto_update: bool
    :ivar is_early_access: :code:`<code>true</code>` if the minor version is early-access;
     otherwise, :code:`<code>false</code>`.
    :vartype is_early_access: bool
    """

    _validation = {
        'runtime_version': {'readonly': True},
        'remote_debugging_supported': {'readonly': True},
        'app_insights_settings': {'readonly': True},
        'git_hub_action_settings': {'readonly': True},
        'is_preview': {'readonly': True},
        'is_deprecated': {'readonly': True},
        'is_hidden': {'readonly': True},
        'end_of_life_date': {'readonly': True},
        'is_auto_update': {'readonly': True},
        'is_early_access': {'readonly': True},
    }

    _attribute_map = {
        'runtime_version': {'key': 'runtimeVersion', 'type': 'str'},
        'remote_debugging_supported': {'key': 'remoteDebuggingSupported', 'type': 'bool'},
        'app_insights_settings': {'key': 'appInsightsSettings', 'type': 'AppInsightsWebAppStackSettings'},
        'git_hub_action_settings': {'key': 'gitHubActionSettings', 'type': 'GitHubActionWebAppStackSettings'},
        'is_preview': {'key': 'isPreview', 'type': 'bool'},
        'is_deprecated': {'key': 'isDeprecated', 'type': 'bool'},
        'is_hidden': {'key': 'isHidden', 'type': 'bool'},
        'end_of_life_date': {'key': 'endOfLifeDate', 'type': 'iso-8601'},
        'is_auto_update': {'key': 'isAutoUpdate', 'type': 'bool'},
        'is_early_access': {'key': 'isEarlyAccess', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WebAppRuntimeSettings, self).__init__(**kwargs)
        self.runtime_version = None
        self.remote_debugging_supported = None
        self.app_insights_settings = None
        self.git_hub_action_settings = None
        self.is_preview = None
        self.is_deprecated = None
        self.is_hidden = None
        self.end_of_life_date = None
        self.is_auto_update = None
        self.is_early_access = None


class WebAppStack(ProxyOnlyResource):
    """Web App stack.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Web App stack location.
    :vartype location: str
    :ivar display_text: Web App stack (display only).
    :vartype display_text: str
    :ivar value: Web App stack name.
    :vartype value: str
    :ivar major_versions: List of major versions available.
    :vartype major_versions: list[~azure.mgmt.web.v2021_01_01.models.WebAppMajorVersion]
    :ivar preferred_os: Web App stack preferred OS. Possible values include: "Windows", "Linux".
    :vartype preferred_os: str or ~azure.mgmt.web.v2021_01_01.models.StackPreferredOs
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
        'display_text': {'readonly': True},
        'value': {'readonly': True},
        'major_versions': {'readonly': True},
        'preferred_os': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'display_text': {'key': 'properties.displayText', 'type': 'str'},
        'value': {'key': 'properties.value', 'type': 'str'},
        'major_versions': {'key': 'properties.majorVersions', 'type': '[WebAppMajorVersion]'},
        'preferred_os': {'key': 'properties.preferredOs', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WebAppStack, self).__init__(**kwargs)
        self.location = None
        self.display_text = None
        self.value = None
        self.major_versions = None
        self.preferred_os = None


class WebAppStackCollection(msrest.serialization.Model):
    """Collection of Web app Stacks.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2021_01_01.models.WebAppStack]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[WebAppStack]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WebAppStackCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class WebJob(ProxyOnlyResource):
    """Web Job Information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param run_command: Run command.
    :type run_command: str
    :param url: Job URL.
    :type url: str
    :param extra_info_url: Extra Info URL.
    :type extra_info_url: str
    :param web_job_type: Job type. Possible values include: "Continuous", "Triggered".
    :type web_job_type: str or ~azure.mgmt.web.v2021_01_01.models.WebJobType
    :param error: Error information.
    :type error: str
    :param using_sdk: Using SDK?.
    :type using_sdk: bool
    :param settings: Job settings.
    :type settings: dict[str, any]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'run_command': {'key': 'properties.run_command', 'type': 'str'},
        'url': {'key': 'properties.url', 'type': 'str'},
        'extra_info_url': {'key': 'properties.extra_info_url', 'type': 'str'},
        'web_job_type': {'key': 'properties.web_job_type', 'type': 'str'},
        'error': {'key': 'properties.error', 'type': 'str'},
        'using_sdk': {'key': 'properties.using_sdk', 'type': 'bool'},
        'settings': {'key': 'properties.settings', 'type': '{object}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WebJob, self).__init__(**kwargs)
        self.run_command = kwargs.get('run_command', None)
        self.url = kwargs.get('url', None)
        self.extra_info_url = kwargs.get('extra_info_url', None)
        self.web_job_type = kwargs.get('web_job_type', None)
        self.error = kwargs.get('error', None)
        self.using_sdk = kwargs.get('using_sdk', None)
        self.settings = kwargs.get('settings', None)


class WebJobCollection(msrest.serialization.Model):
    """Collection of Kudu web job information elements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2021_01_01.models.WebJob]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[WebJob]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WebJobCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class WebSiteInstanceStatus(ProxyOnlyResource):
    """WebSiteInstanceStatus.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param state:  Possible values include: "READY", "STOPPED", "UNKNOWN".
    :type state: str or ~azure.mgmt.web.v2021_01_01.models.SiteRuntimeState
    :param status_url: Link to the GetStatusApi in Kudu.
    :type status_url: str
    :param detector_url: Link to the Diagnose and Solve Portal.
    :type detector_url: str
    :param console_url: Link to the console to web app instance.
    :type console_url: str
    :param health_check_url: Link to the console to web app instance.
    :type health_check_url: str
    :param containers: Dictionary of :code:`<ContainerInfo>`.
    :type containers: dict[str, ~azure.mgmt.web.v2021_01_01.models.ContainerInfo]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'status_url': {'key': 'properties.statusUrl', 'type': 'str'},
        'detector_url': {'key': 'properties.detectorUrl', 'type': 'str'},
        'console_url': {'key': 'properties.consoleUrl', 'type': 'str'},
        'health_check_url': {'key': 'properties.healthCheckUrl', 'type': 'str'},
        'containers': {'key': 'properties.containers', 'type': '{ContainerInfo}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WebSiteInstanceStatus, self).__init__(**kwargs)
        self.state = kwargs.get('state', None)
        self.status_url = kwargs.get('status_url', None)
        self.detector_url = kwargs.get('detector_url', None)
        self.console_url = kwargs.get('console_url', None)
        self.health_check_url = kwargs.get('health_check_url', None)
        self.containers = kwargs.get('containers', None)


class WindowsJavaContainerSettings(msrest.serialization.Model):
    """Windows Java Container settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar java_container: Java container (runtime only).
    :vartype java_container: str
    :ivar java_container_version: Java container version (runtime only).
    :vartype java_container_version: str
    :ivar is_preview: :code:`<code>true</code>` if the stack is in preview; otherwise,
     :code:`<code>false</code>`.
    :vartype is_preview: bool
    :ivar is_deprecated: :code:`<code>true</code>` if the stack is deprecated; otherwise,
     :code:`<code>false</code>`.
    :vartype is_deprecated: bool
    :ivar is_hidden: :code:`<code>true</code>` if the stack should be hidden; otherwise,
     :code:`<code>false</code>`.
    :vartype is_hidden: bool
    :ivar end_of_life_date: End-of-life date for the minor version.
    :vartype end_of_life_date: ~datetime.datetime
    :ivar is_auto_update: :code:`<code>true</code>` if the stack version is auto-updated;
     otherwise, :code:`<code>false</code>`.
    :vartype is_auto_update: bool
    :ivar is_early_access: :code:`<code>true</code>` if the minor version is early-access;
     otherwise, :code:`<code>false</code>`.
    :vartype is_early_access: bool
    """

    _validation = {
        'java_container': {'readonly': True},
        'java_container_version': {'readonly': True},
        'is_preview': {'readonly': True},
        'is_deprecated': {'readonly': True},
        'is_hidden': {'readonly': True},
        'end_of_life_date': {'readonly': True},
        'is_auto_update': {'readonly': True},
        'is_early_access': {'readonly': True},
    }

    _attribute_map = {
        'java_container': {'key': 'javaContainer', 'type': 'str'},
        'java_container_version': {'key': 'javaContainerVersion', 'type': 'str'},
        'is_preview': {'key': 'isPreview', 'type': 'bool'},
        'is_deprecated': {'key': 'isDeprecated', 'type': 'bool'},
        'is_hidden': {'key': 'isHidden', 'type': 'bool'},
        'end_of_life_date': {'key': 'endOfLifeDate', 'type': 'iso-8601'},
        'is_auto_update': {'key': 'isAutoUpdate', 'type': 'bool'},
        'is_early_access': {'key': 'isEarlyAccess', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WindowsJavaContainerSettings, self).__init__(**kwargs)
        self.java_container = None
        self.java_container_version = None
        self.is_preview = None
        self.is_deprecated = None
        self.is_hidden = None
        self.end_of_life_date = None
        self.is_auto_update = None
        self.is_early_access = None


class WorkerPoolCollection(msrest.serialization.Model):
    """Collection of worker pools.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. Collection of resources.
    :type value: list[~azure.mgmt.web.v2021_01_01.models.WorkerPoolResource]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[WorkerPoolResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WorkerPoolCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = None


class WorkerPoolResource(ProxyOnlyResource):
    """Worker pool of an App Service Environment ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param sku: Description of a SKU for a scalable resource.
    :type sku: ~azure.mgmt.web.v2021_01_01.models.SkuDescription
    :param worker_size_id: Worker size ID for referencing this worker pool.
    :type worker_size_id: int
    :param compute_mode: Shared or dedicated app hosting. Possible values include: "Shared",
     "Dedicated", "Dynamic".
    :type compute_mode: str or ~azure.mgmt.web.v2021_01_01.models.ComputeModeOptions
    :param worker_size: VM size of the worker pool instances.
    :type worker_size: str
    :param worker_count: Number of instances in the worker pool.
    :type worker_count: int
    :ivar instance_names: Names of all instances in the worker pool (read only).
    :vartype instance_names: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'instance_names': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'SkuDescription'},
        'worker_size_id': {'key': 'properties.workerSizeId', 'type': 'int'},
        'compute_mode': {'key': 'properties.computeMode', 'type': 'str'},
        'worker_size': {'key': 'properties.workerSize', 'type': 'str'},
        'worker_count': {'key': 'properties.workerCount', 'type': 'int'},
        'instance_names': {'key': 'properties.instanceNames', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WorkerPoolResource, self).__init__(**kwargs)
        self.sku = kwargs.get('sku', None)
        self.worker_size_id = kwargs.get('worker_size_id', None)
        self.compute_mode = kwargs.get('compute_mode', None)
        self.worker_size = kwargs.get('worker_size', None)
        self.worker_count = kwargs.get('worker_count', None)
        self.instance_names = None
