# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum, EnumMeta
from six import with_metaclass

class _CaseInsensitiveEnumMeta(EnumMeta):
    def __getitem__(self, name):
        return super().__getitem__(name.upper())

    def __getattr__(cls, name):
        """Return the enum member matching `name`
        We use __getattr__ instead of descriptors or inserting into the enum
        class' __dict__ in order to support `name` and `value` being both
        properties for enum members (which live in the class' __dict__) and
        enum members themselves.
        """
        try:
            return cls._member_map_[name.upper()]
        except KeyError:
            raise AttributeError(name)


class A2ARecoveryAvailabilityType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The recovery availability type of the virtual machine.
    """

    SINGLE = "Single"
    AVAILABILITY_SET = "AvailabilitySet"
    AVAILABILITY_ZONE = "AvailabilityZone"

class A2ARpRecoveryPointType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The recovery point type.
    """

    LATEST = "Latest"
    LATEST_APPLICATION_CONSISTENT = "LatestApplicationConsistent"
    LATEST_CRASH_CONSISTENT = "LatestCrashConsistent"
    LATEST_PROCESSED = "LatestProcessed"

class AgentAutoUpdateStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """A value indicating whether the auto update is enabled.
    """

    DISABLED = "Disabled"
    ENABLED = "Enabled"

class AgentUpgradeBlockedReason(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    ALREADY_ON_LATEST_VERSION = "AlreadyOnLatestVersion"
    REBOOT_REQUIRED = "RebootRequired"
    AGENT_NO_HEARTBEAT = "AgentNoHeartbeat"
    RCM_PROXY_NO_HEARTBEAT = "RcmProxyNoHeartbeat"
    PROCESS_SERVER_NO_HEARTBEAT = "ProcessServerNoHeartbeat"
    INCOMPATIBLE_APPLIANCE_VERSION = "IncompatibleApplianceVersion"
    NOT_PROTECTED = "NotProtected"
    UNSUPPORTED_PROTECTION_SCENARIO = "UnsupportedProtectionScenario"
    DISTRO_IS_NOT_REPORTED = "DistroIsNotReported"
    DISTRO_NOT_SUPPORTED_FOR_UPGRADE = "DistroNotSupportedForUpgrade"
    MISSING_UPGRADE_PATH = "MissingUpgradePath"
    INVALID_AGENT_VERSION = "InvalidAgentVersion"
    INVALID_DRIVER_VERSION = "InvalidDriverVersion"
    UNKNOWN = "Unknown"

class AgentVersionStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """A value indicating whether security update required.
    """

    SUPPORTED = "Supported"
    NOT_SUPPORTED = "NotSupported"
    DEPRECATED = "Deprecated"
    UPDATE_REQUIRED = "UpdateRequired"
    SECURITY_UPDATE_REQUIRED = "SecurityUpdateRequired"

class AlternateLocationRecoveryOption(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The ALR option.
    """

    CREATE_VM_IF_NOT_FOUND = "CreateVmIfNotFound"
    NO_ACTION = "NoAction"

class AutoProtectionOfDataDisk(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """A value indicating whether the auto protection is enabled.
    """

    DISABLED = "Disabled"
    ENABLED = "Enabled"

class DataSyncStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The data sync option.
    """

    FOR_DOWN_TIME = "ForDownTime"
    FOR_SYNCHRONIZATION = "ForSynchronization"

class DisableProtectionReason(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Disable protection reason. It can have values NotSpecified/MigrationComplete.
    """

    NOT_SPECIFIED = "NotSpecified"
    MIGRATION_COMPLETE = "MigrationComplete"

class DiskAccountType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The DiskType.
    """

    STANDARD_LRS = "Standard_LRS"
    PREMIUM_LRS = "Premium_LRS"
    STANDARD_SSD_LRS = "StandardSSD_LRS"

class DiskReplicationProgressHealth(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The progress health.
    """

    NONE = "None"
    IN_PROGRESS = "InProgress"
    SLOW_PROGRESS = "SlowProgress"
    NO_PROGRESS = "NoProgress"
    QUEUED = "Queued"

class EthernetAddressType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The source IP address type.
    """

    DYNAMIC = "Dynamic"
    STATIC = "Static"

class ExportJobOutputSerializationType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The output type of the jobs.
    """

    JSON = "Json"
    XML = "Xml"
    EXCEL = "Excel"

class FailoverDeploymentModel(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The failover deployment model.
    """

    NOT_APPLICABLE = "NotApplicable"
    CLASSIC = "Classic"
    RESOURCE_MANAGER = "ResourceManager"

class HealthErrorCategory(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The category of the health error.
    """

    NONE = "None"
    REPLICATION = "Replication"
    TEST_FAILOVER = "TestFailover"
    CONFIGURATION = "Configuration"
    FABRIC_INFRASTRUCTURE = "FabricInfrastructure"
    VERSION_EXPIRY = "VersionExpiry"
    AGENT_AUTO_UPDATE_INFRA = "AgentAutoUpdateInfra"
    AGENT_AUTO_UPDATE_ARTIFACT_DELETED = "AgentAutoUpdateArtifactDeleted"
    AGENT_AUTO_UPDATE_RUN_AS_ACCOUNT = "AgentAutoUpdateRunAsAccount"
    AGENT_AUTO_UPDATE_RUN_AS_ACCOUNT_EXPIRY = "AgentAutoUpdateRunAsAccountExpiry"
    AGENT_AUTO_UPDATE_RUN_AS_ACCOUNT_EXPIRED = "AgentAutoUpdateRunAsAccountExpired"

class HealthErrorCustomerResolvability(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Value indicating whether the health error is customer resolvable.
    """

    ALLOWED = "Allowed"
    NOT_ALLOWED = "NotAllowed"

class HyperVReplicaAzureRpRecoveryPointType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The recovery point type.
    """

    LATEST = "Latest"
    LATEST_APPLICATION_CONSISTENT = "LatestApplicationConsistent"
    LATEST_PROCESSED = "LatestProcessed"

class InMageRcmFailbackRecoveryPointType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The recovery point type.
    """

    APPLICATION_CONSISTENT = "ApplicationConsistent"
    CRASH_CONSISTENT = "CrashConsistent"

class InMageV2RpRecoveryPointType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The recovery point type.
    """

    LATEST = "Latest"
    LATEST_APPLICATION_CONSISTENT = "LatestApplicationConsistent"
    LATEST_CRASH_CONSISTENT = "LatestCrashConsistent"
    LATEST_PROCESSED = "LatestProcessed"

class LicenseType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """License type.
    """

    NOT_SPECIFIED = "NotSpecified"
    NO_LICENSE_TYPE = "NoLicenseType"
    WINDOWS_SERVER = "WindowsServer"

class MigrationItemOperation(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    DISABLE_MIGRATION = "DisableMigration"
    TEST_MIGRATE = "TestMigrate"
    TEST_MIGRATE_CLEANUP = "TestMigrateCleanup"
    MIGRATE = "Migrate"
    START_RESYNC = "StartResync"

class MigrationRecoveryPointType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The recovery point type.
    """

    NOT_SPECIFIED = "NotSpecified"
    APPLICATION_CONSISTENT = "ApplicationConsistent"
    CRASH_CONSISTENT = "CrashConsistent"

class MigrationState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The migration status.
    """

    NONE = "None"
    ENABLE_MIGRATION_IN_PROGRESS = "EnableMigrationInProgress"
    ENABLE_MIGRATION_FAILED = "EnableMigrationFailed"
    DISABLE_MIGRATION_IN_PROGRESS = "DisableMigrationInProgress"
    DISABLE_MIGRATION_FAILED = "DisableMigrationFailed"
    INITIAL_SEEDING_IN_PROGRESS = "InitialSeedingInProgress"
    INITIAL_SEEDING_FAILED = "InitialSeedingFailed"
    REPLICATING = "Replicating"
    MIGRATION_IN_PROGRESS = "MigrationInProgress"
    MIGRATION_SUCCEEDED = "MigrationSucceeded"
    MIGRATION_FAILED = "MigrationFailed"

class MobilityAgentUpgradeState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The agent auto upgrade state.
    """

    NONE = "None"
    STARTED = "Started"
    COMPLETED = "Completed"
    COMMIT = "Commit"

class MultiVmGroupCreateOption(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Whether Multi VM group is auto created or specified by user.
    """

    AUTO_CREATED = "AutoCreated"
    USER_SPECIFIED = "UserSpecified"

class MultiVmSyncPointOption(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """A value indicating whether multi VM sync enabled VMs should use multi VM sync points for
    failover.
    """

    USE_MULTI_VM_SYNC_RECOVERY_POINT = "UseMultiVmSyncRecoveryPoint"
    USE_PER_VM_RECOVERY_POINT = "UsePerVmRecoveryPoint"

class PlannedFailoverStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The last planned failover status.
    """

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELLED = "Cancelled"
    UNKNOWN = "Unknown"

class PossibleOperationsDirections(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    PRIMARY_TO_RECOVERY = "PrimaryToRecovery"
    RECOVERY_TO_PRIMARY = "RecoveryToPrimary"

class PresenceStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """A value indicating whether the VM has a physical disk attached. String value of
    SrsDataContract.PresenceStatus enum.
    """

    UNKNOWN = "Unknown"
    PRESENT = "Present"
    NOT_PRESENT = "NotPresent"

class ProtectionHealth(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The health.
    """

    NONE = "None"
    NORMAL = "Normal"
    WARNING = "Warning"
    CRITICAL = "Critical"

class RcmComponentStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The throughput status.
    """

    HEALTHY = "Healthy"
    WARNING = "Warning"
    CRITICAL = "Critical"
    UNKNOWN = "Unknown"

class RecoveryPlanActionLocation(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The fabric location.
    """

    PRIMARY = "Primary"
    RECOVERY = "Recovery"

class RecoveryPlanGroupType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The group type.
    """

    SHUTDOWN = "Shutdown"
    BOOT = "Boot"
    FAILOVER = "Failover"

class RecoveryPlanPointType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The recovery point type.
    """

    LATEST = "Latest"
    LATEST_APPLICATION_CONSISTENT = "LatestApplicationConsistent"
    LATEST_CRASH_CONSISTENT = "LatestCrashConsistent"
    LATEST_PROCESSED = "LatestProcessed"

class RecoveryPointSyncType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """A value indicating whether the recovery point is multi VM consistent.
    """

    MULTI_VM_SYNC_RECOVERY_POINT = "MultiVmSyncRecoveryPoint"
    PER_VM_RECOVERY_POINT = "PerVmRecoveryPoint"

class RecoveryPointType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The recovery point type. Values from LatestTime, LatestTag or Custom. In the case of custom,
    the recovery point provided by RecoveryPointId will be used. In the other two cases, recovery
    point id will be ignored.
    """

    LATEST_TIME = "LatestTime"
    LATEST_TAG = "LatestTag"
    CUSTOM = "Custom"

class ReplicationProtectedItemOperation(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    REVERSE_REPLICATE = "ReverseReplicate"
    COMMIT = "Commit"
    PLANNED_FAILOVER = "PlannedFailover"
    UNPLANNED_FAILOVER = "UnplannedFailover"
    DISABLE_PROTECTION = "DisableProtection"
    TEST_FAILOVER = "TestFailover"
    TEST_FAILOVER_CLEANUP = "TestFailoverCleanup"
    FAILBACK = "Failback"
    FINALIZE_FAILBACK = "FinalizeFailback"
    CANCEL_FAILOVER = "CancelFailover"
    CHANGE_PIT = "ChangePit"
    REPAIR_REPLICATION = "RepairReplication"
    SWITCH_PROTECTION = "SwitchProtection"
    COMPLETE_MIGRATION = "CompleteMigration"

class ResyncState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The resync state.
    """

    NONE = "None"
    PREPARED_FOR_RESYNCHRONIZATION = "PreparedForResynchronization"
    STARTED_RESYNCHRONIZATION = "StartedResynchronization"

class RpInMageRecoveryPointType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The recovery point type.
    """

    LATEST_TIME = "LatestTime"
    LATEST_TAG = "LatestTag"
    CUSTOM = "Custom"

class SetMultiVmSyncStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """A value indicating whether multi-VM sync has to be enabled. Value should be 'Enabled' or
    'Disabled'.
    """

    ENABLE = "Enable"
    DISABLE = "Disable"

class Severity(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Severity of error.
    """

    NONE = "NONE"
    WARNING = "Warning"
    ERROR = "Error"
    INFO = "Info"

class SourceSiteOperations(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """A value indicating whether source site operations are required.
    """

    REQUIRED = "Required"
    NOT_REQUIRED = "NotRequired"

class SqlServerLicenseType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The SQL Server license type.
    """

    NOT_SPECIFIED = "NotSpecified"
    NO_LICENSE_TYPE = "NoLicenseType"
    PAYG = "PAYG"
    AHUB = "AHUB"

class TestMigrationState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The test migrate state.
    """

    NONE = "None"
    TEST_MIGRATION_IN_PROGRESS = "TestMigrationInProgress"
    TEST_MIGRATION_SUCCEEDED = "TestMigrationSucceeded"
    TEST_MIGRATION_FAILED = "TestMigrationFailed"
    TEST_MIGRATION_CLEANUP_IN_PROGRESS = "TestMigrationCleanupInProgress"

class VmEncryptionType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The encryption type of the VM.
    """

    NOT_ENCRYPTED = "NotEncrypted"
    ONE_PASS_ENCRYPTED = "OnePassEncrypted"
    TWO_PASS_ENCRYPTED = "TwoPassEncrypted"

class VmReplicationProgressHealth(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The initial replication progress health.
    """

    NONE = "None"
    IN_PROGRESS = "InProgress"
    SLOW_PROGRESS = "SlowProgress"
    NO_PROGRESS = "NoProgress"
