# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential
from azure.mgmt.appcomplianceautomation import AppComplianceAutomationToolForMicrosoft365

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-appcomplianceautomation
# USAGE
    python report_create_or_update.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = AppComplianceAutomationToolForMicrosoft365(
        credential=DefaultAzureCredential(),
    )

    response = client.report.begin_create_or_update(
        report_name="testReportName",
        parameters={
            "properties": {
                "offerGuid": "0000",
                "resources": [
                    {
                        "resourceId": "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/Microsoft.Network/privateEndpoints/myPrivateEndpoint",
                        "tags": {"key1": "value1"},
                    }
                ],
                "timeZone": "GMT Standard Time",
                "triggerTime": "2022-03-04T05:11:56.197Z",
            }
        },
    ).result()
    print(response)


# x-ms-original-file: specification/appcomplianceautomation/resource-manager/Microsoft.AppComplianceAutomation/preview/2022-11-16-preview/examples/Report_CreateOrUpdate.json
if __name__ == "__main__":
    main()
