# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class Address(_serialization.Model):
    """The shipping address of the customer.

    All required parameters must be populated in order to send to Azure.

    :ivar address_line1: The address line1. Required.
    :vartype address_line1: str
    :ivar address_line2: The address line2.
    :vartype address_line2: str
    :ivar address_line3: The address line3.
    :vartype address_line3: str
    :ivar postal_code: The postal code. Required.
    :vartype postal_code: str
    :ivar city: The city name. Required.
    :vartype city: str
    :ivar state: The state name. Required.
    :vartype state: str
    :ivar country: The country name. Required.
    :vartype country: str
    """

    _validation = {
        "address_line1": {"required": True},
        "postal_code": {"required": True},
        "city": {"required": True},
        "state": {"required": True},
        "country": {"required": True},
    }

    _attribute_map = {
        "address_line1": {"key": "addressLine1", "type": "str"},
        "address_line2": {"key": "addressLine2", "type": "str"},
        "address_line3": {"key": "addressLine3", "type": "str"},
        "postal_code": {"key": "postalCode", "type": "str"},
        "city": {"key": "city", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "country": {"key": "country", "type": "str"},
    }

    def __init__(
        self,
        *,
        address_line1: str,
        postal_code: str,
        city: str,
        state: str,
        country: str,
        address_line2: Optional[str] = None,
        address_line3: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword address_line1: The address line1. Required.
        :paramtype address_line1: str
        :keyword address_line2: The address line2.
        :paramtype address_line2: str
        :keyword address_line3: The address line3.
        :paramtype address_line3: str
        :keyword postal_code: The postal code. Required.
        :paramtype postal_code: str
        :keyword city: The city name. Required.
        :paramtype city: str
        :keyword state: The state name. Required.
        :paramtype state: str
        :keyword country: The country name. Required.
        :paramtype country: str
        """
        super().__init__(**kwargs)
        self.address_line1 = address_line1
        self.address_line2 = address_line2
        self.address_line3 = address_line3
        self.postal_code = postal_code
        self.city = city
        self.state = state
        self.country = country


class ARMBaseModel(_serialization.Model):
    """Represents the base class for all object models.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class Alert(ARMBaseModel):
    """Alert on the data box edge/gateway device.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :ivar title: Alert title.
    :vartype title: str
    :ivar alert_type: Alert type.
    :vartype alert_type: str
    :ivar appeared_at_date_time: UTC time when the alert appeared.
    :vartype appeared_at_date_time: ~datetime.datetime
    :ivar recommendation: Alert recommendation.
    :vartype recommendation: str
    :ivar severity: Severity of the alert. Known values are: "Informational", "Warning", and
     "Critical".
    :vartype severity: str or ~azure.mgmt.databoxedge.v2019_03_01.models.AlertSeverity
    :ivar error_details: Error details of the alert.
    :vartype error_details: ~azure.mgmt.databoxedge.v2019_03_01.models.AlertErrorDetails
    :ivar detailed_information: Alert details.
    :vartype detailed_information: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "title": {"readonly": True},
        "alert_type": {"readonly": True},
        "appeared_at_date_time": {"readonly": True},
        "recommendation": {"readonly": True},
        "severity": {"readonly": True},
        "error_details": {"readonly": True},
        "detailed_information": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "title": {"key": "properties.title", "type": "str"},
        "alert_type": {"key": "properties.alertType", "type": "str"},
        "appeared_at_date_time": {"key": "properties.appearedAtDateTime", "type": "iso-8601"},
        "recommendation": {"key": "properties.recommendation", "type": "str"},
        "severity": {"key": "properties.severity", "type": "str"},
        "error_details": {"key": "properties.errorDetails", "type": "AlertErrorDetails"},
        "detailed_information": {"key": "properties.detailedInformation", "type": "{str}"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.title = None
        self.alert_type = None
        self.appeared_at_date_time = None
        self.recommendation = None
        self.severity = None
        self.error_details = None
        self.detailed_information = None


class AlertErrorDetails(_serialization.Model):
    """Error details for the alert.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar error_code: Error code.
    :vartype error_code: str
    :ivar error_message: Error Message.
    :vartype error_message: str
    :ivar occurrences: Number of occurrences.
    :vartype occurrences: int
    """

    _validation = {
        "error_code": {"readonly": True},
        "error_message": {"readonly": True},
        "occurrences": {"readonly": True},
    }

    _attribute_map = {
        "error_code": {"key": "errorCode", "type": "str"},
        "error_message": {"key": "errorMessage", "type": "str"},
        "occurrences": {"key": "occurrences", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.error_code = None
        self.error_message = None
        self.occurrences = None


class AlertList(_serialization.Model):
    """Collection of alerts.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The value.
    :vartype value: list[~azure.mgmt.databoxedge.v2019_03_01.models.Alert]
    :ivar next_link: Link to the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Alert]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class AsymmetricEncryptedSecret(_serialization.Model):
    """Represent the secrets intended for encryption with asymmetric key pair.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The value of the secret. Required.
    :vartype value: str
    :ivar encryption_cert_thumbprint: Thumbprint certificate used to encrypt \"Value\". If the
     value is unencrypted, it will be null.
    :vartype encryption_cert_thumbprint: str
    :ivar encryption_algorithm: The algorithm used to encrypt "Value". Required. Known values are:
     "None", "AES256", and "RSAES_PKCS1_v_1_5".
    :vartype encryption_algorithm: str or
     ~azure.mgmt.databoxedge.v2019_03_01.models.EncryptionAlgorithm
    """

    _validation = {
        "value": {"required": True},
        "encryption_algorithm": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "encryption_cert_thumbprint": {"key": "encryptionCertThumbprint", "type": "str"},
        "encryption_algorithm": {"key": "encryptionAlgorithm", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: str,
        encryption_algorithm: Union[str, "_models.EncryptionAlgorithm"],
        encryption_cert_thumbprint: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The value of the secret. Required.
        :paramtype value: str
        :keyword encryption_cert_thumbprint: Thumbprint certificate used to encrypt \"Value\". If the
         value is unencrypted, it will be null.
        :paramtype encryption_cert_thumbprint: str
        :keyword encryption_algorithm: The algorithm used to encrypt "Value". Required. Known values
         are: "None", "AES256", and "RSAES_PKCS1_v_1_5".
        :paramtype encryption_algorithm: str or
         ~azure.mgmt.databoxedge.v2019_03_01.models.EncryptionAlgorithm
        """
        super().__init__(**kwargs)
        self.value = value
        self.encryption_cert_thumbprint = encryption_cert_thumbprint
        self.encryption_algorithm = encryption_algorithm


class Authentication(_serialization.Model):
    """Authentication mechanism for IoT devices.

    :ivar symmetric_key: Symmetric key for authentication.
    :vartype symmetric_key: ~azure.mgmt.databoxedge.v2019_03_01.models.SymmetricKey
    """

    _attribute_map = {
        "symmetric_key": {"key": "symmetricKey", "type": "SymmetricKey"},
    }

    def __init__(self, *, symmetric_key: Optional["_models.SymmetricKey"] = None, **kwargs: Any) -> None:
        """
        :keyword symmetric_key: Symmetric key for authentication.
        :paramtype symmetric_key: ~azure.mgmt.databoxedge.v2019_03_01.models.SymmetricKey
        """
        super().__init__(**kwargs)
        self.symmetric_key = symmetric_key


class AzureContainerInfo(_serialization.Model):
    """Azure container mapping of the endpoint.

    All required parameters must be populated in order to send to Azure.

    :ivar storage_account_credential_id: ID of the storage account credential used to access
     storage. Required.
    :vartype storage_account_credential_id: str
    :ivar container_name: Container name (Based on the data format specified, this represents the
     name of Azure Files/Page blob/Block blob). Required.
    :vartype container_name: str
    :ivar data_format: Storage format used for the file represented by the share. Required. Known
     values are: "BlockBlob", "PageBlob", and "AzureFile".
    :vartype data_format: str or
     ~azure.mgmt.databoxedge.v2019_03_01.models.AzureContainerDataFormat
    """

    _validation = {
        "storage_account_credential_id": {"required": True},
        "container_name": {"required": True},
        "data_format": {"required": True},
    }

    _attribute_map = {
        "storage_account_credential_id": {"key": "storageAccountCredentialId", "type": "str"},
        "container_name": {"key": "containerName", "type": "str"},
        "data_format": {"key": "dataFormat", "type": "str"},
    }

    def __init__(
        self,
        *,
        storage_account_credential_id: str,
        container_name: str,
        data_format: Union[str, "_models.AzureContainerDataFormat"],
        **kwargs: Any
    ) -> None:
        """
        :keyword storage_account_credential_id: ID of the storage account credential used to access
         storage. Required.
        :paramtype storage_account_credential_id: str
        :keyword container_name: Container name (Based on the data format specified, this represents
         the name of Azure Files/Page blob/Block blob). Required.
        :paramtype container_name: str
        :keyword data_format: Storage format used for the file represented by the share. Required.
         Known values are: "BlockBlob", "PageBlob", and "AzureFile".
        :paramtype data_format: str or
         ~azure.mgmt.databoxedge.v2019_03_01.models.AzureContainerDataFormat
        """
        super().__init__(**kwargs)
        self.storage_account_credential_id = storage_account_credential_id
        self.container_name = container_name
        self.data_format = data_format


class BandwidthSchedule(ARMBaseModel):
    """The bandwidth schedule details.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :ivar start: The start time of the schedule in UTC. Required.
    :vartype start: str
    :ivar stop: The stop time of the schedule in UTC. Required.
    :vartype stop: str
    :ivar rate_in_mbps: The bandwidth rate in Mbps. Required.
    :vartype rate_in_mbps: int
    :ivar days: The days of the week when this schedule is applicable. Required.
    :vartype days: list[str or ~azure.mgmt.databoxedge.v2019_03_01.models.DayOfWeek]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "start": {"required": True},
        "stop": {"required": True},
        "rate_in_mbps": {"required": True},
        "days": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "start": {"key": "properties.start", "type": "str"},
        "stop": {"key": "properties.stop", "type": "str"},
        "rate_in_mbps": {"key": "properties.rateInMbps", "type": "int"},
        "days": {"key": "properties.days", "type": "[str]"},
    }

    def __init__(
        self, *, start: str, stop: str, rate_in_mbps: int, days: List[Union[str, "_models.DayOfWeek"]], **kwargs: Any
    ) -> None:
        """
        :keyword start: The start time of the schedule in UTC. Required.
        :paramtype start: str
        :keyword stop: The stop time of the schedule in UTC. Required.
        :paramtype stop: str
        :keyword rate_in_mbps: The bandwidth rate in Mbps. Required.
        :paramtype rate_in_mbps: int
        :keyword days: The days of the week when this schedule is applicable. Required.
        :paramtype days: list[str or ~azure.mgmt.databoxedge.v2019_03_01.models.DayOfWeek]
        """
        super().__init__(**kwargs)
        self.start = start
        self.stop = stop
        self.rate_in_mbps = rate_in_mbps
        self.days = days


class BandwidthSchedulesList(_serialization.Model):
    """The collection of bandwidth schedules.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of bandwidth schedules.
    :vartype value: list[~azure.mgmt.databoxedge.v2019_03_01.models.BandwidthSchedule]
    :ivar next_link: Link to the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[BandwidthSchedule]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class ClientAccessRight(_serialization.Model):
    """The mapping between a particular client IP and the type of access client has on the NFS share.

    All required parameters must be populated in order to send to Azure.

    :ivar client: IP of the client. Required.
    :vartype client: str
    :ivar access_permission: Type of access to be allowed for the client. Required. Known values
     are: "NoAccess", "ReadOnly", and "ReadWrite".
    :vartype access_permission: str or
     ~azure.mgmt.databoxedge.v2019_03_01.models.ClientPermissionType
    """

    _validation = {
        "client": {"required": True},
        "access_permission": {"required": True},
    }

    _attribute_map = {
        "client": {"key": "client", "type": "str"},
        "access_permission": {"key": "accessPermission", "type": "str"},
    }

    def __init__(
        self, *, client: str, access_permission: Union[str, "_models.ClientPermissionType"], **kwargs: Any
    ) -> None:
        """
        :keyword client: IP of the client. Required.
        :paramtype client: str
        :keyword access_permission: Type of access to be allowed for the client. Required. Known values
         are: "NoAccess", "ReadOnly", and "ReadWrite".
        :paramtype access_permission: str or
         ~azure.mgmt.databoxedge.v2019_03_01.models.ClientPermissionType
        """
        super().__init__(**kwargs)
        self.client = client
        self.access_permission = access_permission


class CloudErrorBody(_serialization.Model):
    """An error response from the service.

    :ivar code: An identifier for the error. Codes are invariant and are intended to be consumed
     programmatically.
    :vartype code: str
    :ivar message: A message describing the error, intended to be suitable for display in a user
     interface.
    :vartype message: str
    :ivar details: A list of additional details about the error.
    :vartype details: list[~azure.mgmt.databoxedge.v2019_03_01.models.CloudErrorBody]
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "details": {"key": "details", "type": "[CloudErrorBody]"},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        details: Optional[List["_models.CloudErrorBody"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword code: An identifier for the error. Codes are invariant and are intended to be consumed
         programmatically.
        :paramtype code: str
        :keyword message: A message describing the error, intended to be suitable for display in a user
         interface.
        :paramtype message: str
        :keyword details: A list of additional details about the error.
        :paramtype details: list[~azure.mgmt.databoxedge.v2019_03_01.models.CloudErrorBody]
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.details = details


class ContactDetails(_serialization.Model):
    """Contains all the contact details of the customer.

    All required parameters must be populated in order to send to Azure.

    :ivar contact_person: The contact person name. Required.
    :vartype contact_person: str
    :ivar company_name: The name of the company. Required.
    :vartype company_name: str
    :ivar phone: The phone number. Required.
    :vartype phone: str
    :ivar email_list: The email list. Required.
    :vartype email_list: list[str]
    """

    _validation = {
        "contact_person": {"required": True},
        "company_name": {"required": True},
        "phone": {"required": True},
        "email_list": {"required": True},
    }

    _attribute_map = {
        "contact_person": {"key": "contactPerson", "type": "str"},
        "company_name": {"key": "companyName", "type": "str"},
        "phone": {"key": "phone", "type": "str"},
        "email_list": {"key": "emailList", "type": "[str]"},
    }

    def __init__(
        self, *, contact_person: str, company_name: str, phone: str, email_list: List[str], **kwargs: Any
    ) -> None:
        """
        :keyword contact_person: The contact person name. Required.
        :paramtype contact_person: str
        :keyword company_name: The name of the company. Required.
        :paramtype company_name: str
        :keyword phone: The phone number. Required.
        :paramtype phone: str
        :keyword email_list: The email list. Required.
        :paramtype email_list: list[str]
        """
        super().__init__(**kwargs)
        self.contact_person = contact_person
        self.company_name = company_name
        self.phone = phone
        self.email_list = email_list


class DataBoxEdgeDevice(ARMBaseModel):  # pylint: disable=too-many-instance-attributes
    """The Data Box Edge/Gateway device.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :ivar location: The location of the device. This is a supported and registered Azure
     geographical region (for example, West US, East US, or Southeast Asia). The geographical region
     of a device cannot be changed once it is created, but if an identical geographical region is
     specified on update, the request will succeed. Required.
    :vartype location: str
    :ivar tags: The list of tags that describe the device. These tags can be used to view and group
     this device (across resource groups).
    :vartype tags: dict[str, str]
    :ivar sku: The SKU type.
    :vartype sku: ~azure.mgmt.databoxedge.v2019_03_01.models.Sku
    :ivar etag: The etag for the devices.
    :vartype etag: str
    :ivar data_box_edge_device_status: The status of the Data Box Edge/Gateway device. Known values
     are: "ReadyToSetup", "Online", "Offline", "NeedsAttention", "Disconnected", and
     "PartiallyDisconnected".
    :vartype data_box_edge_device_status: str or
     ~azure.mgmt.databoxedge.v2019_03_01.models.DataBoxEdgeDeviceStatus
    :ivar serial_number: The Serial Number of Data Box Edge/Gateway device.
    :vartype serial_number: str
    :ivar description: The Description of the Data Box Edge/Gateway device.
    :vartype description: str
    :ivar model_description: The description of the Data Box Edge/Gateway device model.
    :vartype model_description: str
    :ivar device_type: The type of the Data Box Edge/Gateway device. "DataBoxEdgeDevice"
    :vartype device_type: str or ~azure.mgmt.databoxedge.v2019_03_01.models.DeviceType
    :ivar friendly_name: The Data Box Edge/Gateway device name.
    :vartype friendly_name: str
    :ivar culture: The Data Box Edge/Gateway device culture.
    :vartype culture: str
    :ivar device_model: The Data Box Edge/Gateway device model.
    :vartype device_model: str
    :ivar device_software_version: The Data Box Edge/Gateway device software version.
    :vartype device_software_version: str
    :ivar device_local_capacity: The Data Box Edge/Gateway device local capacity in MB.
    :vartype device_local_capacity: int
    :ivar time_zone: The Data Box Edge/Gateway device timezone.
    :vartype time_zone: str
    :ivar device_hcs_version: The device software version number of the device (eg: 1.2.18105.6).
    :vartype device_hcs_version: str
    :ivar configured_role_types: Type of compute roles configured.
    :vartype configured_role_types: list[str or
     ~azure.mgmt.databoxedge.v2019_03_01.models.RoleTypes]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "serial_number": {"readonly": True},
        "device_type": {"readonly": True},
        "culture": {"readonly": True},
        "device_model": {"readonly": True},
        "device_software_version": {"readonly": True},
        "device_local_capacity": {"readonly": True},
        "time_zone": {"readonly": True},
        "device_hcs_version": {"readonly": True},
        "configured_role_types": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "Sku"},
        "etag": {"key": "etag", "type": "str"},
        "data_box_edge_device_status": {"key": "properties.dataBoxEdgeDeviceStatus", "type": "str"},
        "serial_number": {"key": "properties.serialNumber", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "model_description": {"key": "properties.modelDescription", "type": "str"},
        "device_type": {"key": "properties.deviceType", "type": "str"},
        "friendly_name": {"key": "properties.friendlyName", "type": "str"},
        "culture": {"key": "properties.culture", "type": "str"},
        "device_model": {"key": "properties.deviceModel", "type": "str"},
        "device_software_version": {"key": "properties.deviceSoftwareVersion", "type": "str"},
        "device_local_capacity": {"key": "properties.deviceLocalCapacity", "type": "int"},
        "time_zone": {"key": "properties.timeZone", "type": "str"},
        "device_hcs_version": {"key": "properties.deviceHcsVersion", "type": "str"},
        "configured_role_types": {"key": "properties.configuredRoleTypes", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.Sku"] = None,
        etag: Optional[str] = None,
        data_box_edge_device_status: Optional[Union[str, "_models.DataBoxEdgeDeviceStatus"]] = None,
        description: Optional[str] = None,
        model_description: Optional[str] = None,
        friendly_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the device. This is a supported and registered Azure
         geographical region (for example, West US, East US, or Southeast Asia). The geographical region
         of a device cannot be changed once it is created, but if an identical geographical region is
         specified on update, the request will succeed. Required.
        :paramtype location: str
        :keyword tags: The list of tags that describe the device. These tags can be used to view and
         group this device (across resource groups).
        :paramtype tags: dict[str, str]
        :keyword sku: The SKU type.
        :paramtype sku: ~azure.mgmt.databoxedge.v2019_03_01.models.Sku
        :keyword etag: The etag for the devices.
        :paramtype etag: str
        :keyword data_box_edge_device_status: The status of the Data Box Edge/Gateway device. Known
         values are: "ReadyToSetup", "Online", "Offline", "NeedsAttention", "Disconnected", and
         "PartiallyDisconnected".
        :paramtype data_box_edge_device_status: str or
         ~azure.mgmt.databoxedge.v2019_03_01.models.DataBoxEdgeDeviceStatus
        :keyword description: The Description of the Data Box Edge/Gateway device.
        :paramtype description: str
        :keyword model_description: The description of the Data Box Edge/Gateway device model.
        :paramtype model_description: str
        :keyword friendly_name: The Data Box Edge/Gateway device name.
        :paramtype friendly_name: str
        """
        super().__init__(**kwargs)
        self.location = location
        self.tags = tags
        self.sku = sku
        self.etag = etag
        self.data_box_edge_device_status = data_box_edge_device_status
        self.serial_number = None
        self.description = description
        self.model_description = model_description
        self.device_type = None
        self.friendly_name = friendly_name
        self.culture = None
        self.device_model = None
        self.device_software_version = None
        self.device_local_capacity = None
        self.time_zone = None
        self.device_hcs_version = None
        self.configured_role_types = None


class DataBoxEdgeDeviceExtendedInfo(ARMBaseModel):
    """The extended Info of the Data Box Edge/Gateway device.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :ivar encryption_key_thumbprint: The digital signature of encrypted certificate.
    :vartype encryption_key_thumbprint: str
    :ivar encryption_key: The public part of the encryption certificate. Client uses this to
     encrypt any secret.
    :vartype encryption_key: str
    :ivar resource_key: The Resource ID of the Resource.
    :vartype resource_key: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "resource_key": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "encryption_key_thumbprint": {"key": "properties.encryptionKeyThumbprint", "type": "str"},
        "encryption_key": {"key": "properties.encryptionKey", "type": "str"},
        "resource_key": {"key": "properties.resourceKey", "type": "str"},
    }

    def __init__(
        self, *, encryption_key_thumbprint: Optional[str] = None, encryption_key: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword encryption_key_thumbprint: The digital signature of encrypted certificate.
        :paramtype encryption_key_thumbprint: str
        :keyword encryption_key: The public part of the encryption certificate. Client uses this to
         encrypt any secret.
        :paramtype encryption_key: str
        """
        super().__init__(**kwargs)
        self.encryption_key_thumbprint = encryption_key_thumbprint
        self.encryption_key = encryption_key
        self.resource_key = None


class DataBoxEdgeDeviceList(_serialization.Model):
    """The collection of Data Box Edge/Gateway devices.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of Data Box Edge/Gateway devices.
    :vartype value: list[~azure.mgmt.databoxedge.v2019_03_01.models.DataBoxEdgeDevice]
    :ivar next_link: Link to the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DataBoxEdgeDevice]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class DataBoxEdgeDevicePatch(_serialization.Model):
    """The Data Box Edge/Gateway device patch.

    :ivar tags: The tags attached to the Data Box Edge/Gateway resource.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: The tags attached to the Data Box Edge/Gateway resource.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class Trigger(ARMBaseModel):
    """Trigger details.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    FileEventTrigger, PeriodicTimerEventTrigger

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :ivar kind: Trigger Kind. Required. Known values are: "FileEvent" and "PeriodicTimerEvent".
    :vartype kind: str or ~azure.mgmt.databoxedge.v2019_03_01.models.TriggerEventType
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "kind": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
    }

    _subtype_map = {"kind": {"FileEvent": "FileEventTrigger", "PeriodicTimerEvent": "PeriodicTimerEventTrigger"}}

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.kind: Optional[str] = None


class FileEventTrigger(Trigger):
    """Trigger details.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :ivar kind: Trigger Kind. Required. Known values are: "FileEvent" and "PeriodicTimerEvent".
    :vartype kind: str or ~azure.mgmt.databoxedge.v2019_03_01.models.TriggerEventType
    :ivar source_info: File event source details. Required.
    :vartype source_info: ~azure.mgmt.databoxedge.v2019_03_01.models.FileSourceInfo
    :ivar sink_info: Role sink info. Required.
    :vartype sink_info: ~azure.mgmt.databoxedge.v2019_03_01.models.RoleSinkInfo
    :ivar custom_context_tag: A custom context tag typically used to correlate the trigger against
     its usage. For example, if a periodic timer trigger is intended for certain specific IoT
     modules in the device, the tag can be the name or the image URL of the module.
    :vartype custom_context_tag: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "kind": {"required": True},
        "source_info": {"required": True},
        "sink_info": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "source_info": {"key": "properties.sourceInfo", "type": "FileSourceInfo"},
        "sink_info": {"key": "properties.sinkInfo", "type": "RoleSinkInfo"},
        "custom_context_tag": {"key": "properties.customContextTag", "type": "str"},
    }

    def __init__(
        self,
        *,
        source_info: "_models.FileSourceInfo",
        sink_info: "_models.RoleSinkInfo",
        custom_context_tag: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword source_info: File event source details. Required.
        :paramtype source_info: ~azure.mgmt.databoxedge.v2019_03_01.models.FileSourceInfo
        :keyword sink_info: Role sink info. Required.
        :paramtype sink_info: ~azure.mgmt.databoxedge.v2019_03_01.models.RoleSinkInfo
        :keyword custom_context_tag: A custom context tag typically used to correlate the trigger
         against its usage. For example, if a periodic timer trigger is intended for certain specific
         IoT modules in the device, the tag can be the name or the image URL of the module.
        :paramtype custom_context_tag: str
        """
        super().__init__(**kwargs)
        self.kind: str = "FileEvent"
        self.source_info = source_info
        self.sink_info = sink_info
        self.custom_context_tag = custom_context_tag


class FileSourceInfo(_serialization.Model):
    """File source details.

    All required parameters must be populated in order to send to Azure.

    :ivar share_id: File share ID. Required.
    :vartype share_id: str
    """

    _validation = {
        "share_id": {"required": True},
    }

    _attribute_map = {
        "share_id": {"key": "shareId", "type": "str"},
    }

    def __init__(self, *, share_id: str, **kwargs: Any) -> None:
        """
        :keyword share_id: File share ID. Required.
        :paramtype share_id: str
        """
        super().__init__(**kwargs)
        self.share_id = share_id


class IoTDeviceInfo(_serialization.Model):
    """Metadata of IoT device/IoT Edge device to be configured.

    All required parameters must be populated in order to send to Azure.

    :ivar device_id: ID of the IoT device/edge device. Required.
    :vartype device_id: str
    :ivar io_t_host_hub: Host name for the IoT hub associated to the device. Required.
    :vartype io_t_host_hub: str
    :ivar authentication: IoT device authentication info.
    :vartype authentication: ~azure.mgmt.databoxedge.v2019_03_01.models.Authentication
    """

    _validation = {
        "device_id": {"required": True},
        "io_t_host_hub": {"required": True},
    }

    _attribute_map = {
        "device_id": {"key": "deviceId", "type": "str"},
        "io_t_host_hub": {"key": "ioTHostHub", "type": "str"},
        "authentication": {"key": "authentication", "type": "Authentication"},
    }

    def __init__(
        self,
        *,
        device_id: str,
        io_t_host_hub: str,
        authentication: Optional["_models.Authentication"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword device_id: ID of the IoT device/edge device. Required.
        :paramtype device_id: str
        :keyword io_t_host_hub: Host name for the IoT hub associated to the device. Required.
        :paramtype io_t_host_hub: str
        :keyword authentication: IoT device authentication info.
        :paramtype authentication: ~azure.mgmt.databoxedge.v2019_03_01.models.Authentication
        """
        super().__init__(**kwargs)
        self.device_id = device_id
        self.io_t_host_hub = io_t_host_hub
        self.authentication = authentication


class Role(ARMBaseModel):
    """Compute role.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    IoTRole

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :ivar kind: Role type. Required. Known values are: "IOT", "ASA", "Functions", and "Cognitive".
    :vartype kind: str or ~azure.mgmt.databoxedge.v2019_03_01.models.RoleTypes
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "kind": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
    }

    _subtype_map = {"kind": {"IOT": "IoTRole"}}

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.kind: Optional[str] = None


class IoTRole(Role):
    """Compute role.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :ivar kind: Role type. Required. Known values are: "IOT", "ASA", "Functions", and "Cognitive".
    :vartype kind: str or ~azure.mgmt.databoxedge.v2019_03_01.models.RoleTypes
    :ivar host_platform: Host OS supported by the IoT role. Known values are: "Windows" and
     "Linux".
    :vartype host_platform: str or ~azure.mgmt.databoxedge.v2019_03_01.models.PlatformType
    :ivar io_t_device_details: IoT device metadata to which data box edge device needs to be
     connected.
    :vartype io_t_device_details: ~azure.mgmt.databoxedge.v2019_03_01.models.IoTDeviceInfo
    :ivar io_t_edge_device_details: IoT edge device to which the IoT role needs to be configured.
    :vartype io_t_edge_device_details: ~azure.mgmt.databoxedge.v2019_03_01.models.IoTDeviceInfo
    :ivar share_mappings: Mount points of shares in role(s).
    :vartype share_mappings: list[~azure.mgmt.databoxedge.v2019_03_01.models.MountPointMap]
    :ivar role_status: Role status. Known values are: "Enabled" and "Disabled".
    :vartype role_status: str or ~azure.mgmt.databoxedge.v2019_03_01.models.RoleStatus
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "kind": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "host_platform": {"key": "properties.hostPlatform", "type": "str"},
        "io_t_device_details": {"key": "properties.ioTDeviceDetails", "type": "IoTDeviceInfo"},
        "io_t_edge_device_details": {"key": "properties.ioTEdgeDeviceDetails", "type": "IoTDeviceInfo"},
        "share_mappings": {"key": "properties.shareMappings", "type": "[MountPointMap]"},
        "role_status": {"key": "properties.roleStatus", "type": "str"},
    }

    def __init__(
        self,
        *,
        host_platform: Optional[Union[str, "_models.PlatformType"]] = None,
        io_t_device_details: Optional["_models.IoTDeviceInfo"] = None,
        io_t_edge_device_details: Optional["_models.IoTDeviceInfo"] = None,
        share_mappings: Optional[List["_models.MountPointMap"]] = None,
        role_status: Optional[Union[str, "_models.RoleStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword host_platform: Host OS supported by the IoT role. Known values are: "Windows" and
         "Linux".
        :paramtype host_platform: str or ~azure.mgmt.databoxedge.v2019_03_01.models.PlatformType
        :keyword io_t_device_details: IoT device metadata to which data box edge device needs to be
         connected.
        :paramtype io_t_device_details: ~azure.mgmt.databoxedge.v2019_03_01.models.IoTDeviceInfo
        :keyword io_t_edge_device_details: IoT edge device to which the IoT role needs to be
         configured.
        :paramtype io_t_edge_device_details: ~azure.mgmt.databoxedge.v2019_03_01.models.IoTDeviceInfo
        :keyword share_mappings: Mount points of shares in role(s).
        :paramtype share_mappings: list[~azure.mgmt.databoxedge.v2019_03_01.models.MountPointMap]
        :keyword role_status: Role status. Known values are: "Enabled" and "Disabled".
        :paramtype role_status: str or ~azure.mgmt.databoxedge.v2019_03_01.models.RoleStatus
        """
        super().__init__(**kwargs)
        self.kind: str = "IOT"
        self.host_platform = host_platform
        self.io_t_device_details = io_t_device_details
        self.io_t_edge_device_details = io_t_edge_device_details
        self.share_mappings = share_mappings
        self.role_status = role_status


class Ipv4Config(_serialization.Model):
    """Details related to the IPv4 address configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar ip_address: The IPv4 address of the network adapter.
    :vartype ip_address: str
    :ivar subnet: The IPv4 subnet of the network adapter.
    :vartype subnet: str
    :ivar gateway: The IPv4 gateway of the network adapter.
    :vartype gateway: str
    """

    _validation = {
        "ip_address": {"readonly": True},
        "subnet": {"readonly": True},
        "gateway": {"readonly": True},
    }

    _attribute_map = {
        "ip_address": {"key": "ipAddress", "type": "str"},
        "subnet": {"key": "subnet", "type": "str"},
        "gateway": {"key": "gateway", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.ip_address = None
        self.subnet = None
        self.gateway = None


class Ipv6Config(_serialization.Model):
    """Details related to the IPv6 address configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar ip_address: The IPv6 address of the network adapter.
    :vartype ip_address: str
    :ivar prefix_length: The IPv6 prefix of the network adapter.
    :vartype prefix_length: int
    :ivar gateway: The IPv6 gateway of the network adapter.
    :vartype gateway: str
    """

    _validation = {
        "ip_address": {"readonly": True},
        "prefix_length": {"readonly": True},
        "gateway": {"readonly": True},
    }

    _attribute_map = {
        "ip_address": {"key": "ipAddress", "type": "str"},
        "prefix_length": {"key": "prefixLength", "type": "int"},
        "gateway": {"key": "gateway", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.ip_address = None
        self.prefix_length = None
        self.gateway = None


class Job(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """A device job.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The name of the object.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :ivar status: The current status of the job. Known values are: "Invalid", "Running",
     "Succeeded", "Failed", "Canceled", "Paused", and "Scheduled".
    :vartype status: str or ~azure.mgmt.databoxedge.v2019_03_01.models.JobStatus
    :ivar start_time: The UTC date and time at which the job started.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The UTC date and time at which the job completed.
    :vartype end_time: ~datetime.datetime
    :ivar percent_complete: The percentage of the job that is complete.
    :vartype percent_complete: int
    :ivar error: The error details.
    :vartype error: ~azure.mgmt.databoxedge.v2019_03_01.models.JobErrorDetails
    :ivar job_type: The type of the job. Known values are: "Invalid", "ScanForUpdates",
     "DownloadUpdates", "InstallUpdates", and "RefreshShare".
    :vartype job_type: str or ~azure.mgmt.databoxedge.v2019_03_01.models.JobType
    :ivar current_stage: Current stage of the update operation. Known values are: "Unknown",
     "Initial", "ScanStarted", "ScanComplete", "ScanFailed", "DownloadStarted", "DownloadComplete",
     "DownloadFailed", "InstallStarted", "InstallComplete", "InstallFailed", "RebootInitiated",
     "Success", "Failure", "RescanStarted", "RescanComplete", and "RescanFailed".
    :vartype current_stage: str or ~azure.mgmt.databoxedge.v2019_03_01.models.UpdateOperationStage
    :ivar download_progress: The download progress.
    :vartype download_progress: ~azure.mgmt.databoxedge.v2019_03_01.models.UpdateDownloadProgress
    :ivar install_progress: The install progress.
    :vartype install_progress: ~azure.mgmt.databoxedge.v2019_03_01.models.UpdateInstallProgress
    :ivar total_refresh_errors: Total number of errors encountered during the refresh process.
    :vartype total_refresh_errors: int
    :ivar error_manifest_file: Local share/remote container relative path to the error manifest
     file of the refresh.
    :vartype error_manifest_file: str
    :ivar share_id: ARM ID of the share that was refreshed.
    :vartype share_id: str
    :ivar folder: If only subfolders need to be refreshed, then the subfolder path inside the
     share. (The path is empty if there are no subfolders.).
    :vartype folder: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "status": {"readonly": True},
        "start_time": {"readonly": True},
        "end_time": {"readonly": True},
        "percent_complete": {"readonly": True},
        "error": {"readonly": True},
        "job_type": {"readonly": True},
        "current_stage": {"readonly": True},
        "download_progress": {"readonly": True},
        "install_progress": {"readonly": True},
        "total_refresh_errors": {"readonly": True},
        "error_manifest_file": {"readonly": True},
        "share_id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "percent_complete": {"key": "percentComplete", "type": "int"},
        "error": {"key": "error", "type": "JobErrorDetails"},
        "job_type": {"key": "properties.jobType", "type": "str"},
        "current_stage": {"key": "properties.currentStage", "type": "str"},
        "download_progress": {"key": "properties.downloadProgress", "type": "UpdateDownloadProgress"},
        "install_progress": {"key": "properties.installProgress", "type": "UpdateInstallProgress"},
        "total_refresh_errors": {"key": "properties.totalRefreshErrors", "type": "int"},
        "error_manifest_file": {"key": "properties.errorManifestFile", "type": "str"},
        "share_id": {"key": "properties.shareId", "type": "str"},
        "folder": {"key": "properties.folder", "type": "str"},
    }

    def __init__(self, *, folder: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword folder: If only subfolders need to be refreshed, then the subfolder path inside the
         share. (The path is empty if there are no subfolders.).
        :paramtype folder: str
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.status = None
        self.start_time = None
        self.end_time = None
        self.percent_complete = None
        self.error = None
        self.job_type = None
        self.current_stage = None
        self.download_progress = None
        self.install_progress = None
        self.total_refresh_errors = None
        self.error_manifest_file = None
        self.share_id = None
        self.folder = folder


class JobErrorDetails(_serialization.Model):
    """The job error information containing the list of job errors.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar error_details: The error details.
    :vartype error_details: list[~azure.mgmt.databoxedge.v2019_03_01.models.JobErrorItem]
    :ivar code: The code intended for programmatic access.
    :vartype code: str
    :ivar message: The message that describes the error in detail.
    :vartype message: str
    """

    _validation = {
        "error_details": {"readonly": True},
        "code": {"readonly": True},
        "message": {"readonly": True},
    }

    _attribute_map = {
        "error_details": {"key": "errorDetails", "type": "[JobErrorItem]"},
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.error_details = None
        self.code = None
        self.message = None


class JobErrorItem(_serialization.Model):
    """The job error items.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar recommendations: The recommended actions.
    :vartype recommendations: list[str]
    :ivar code: The code intended for programmatic access.
    :vartype code: str
    :ivar message: The message that describes the error in detail.
    :vartype message: str
    """

    _validation = {
        "recommendations": {"readonly": True},
        "code": {"readonly": True},
        "message": {"readonly": True},
    }

    _attribute_map = {
        "recommendations": {"key": "recommendations", "type": "[str]"},
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.recommendations = None
        self.code = None
        self.message = None


class MetricDimensionV1(_serialization.Model):
    """Metric Dimension v1.

    :ivar name: Name of the metrics dimension.
    :vartype name: str
    :ivar display_name: Display name of the metrics dimension.
    :vartype display_name: str
    :ivar to_be_exported_for_shoebox: To be exported to shoe box.
    :vartype to_be_exported_for_shoebox: bool
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "to_be_exported_for_shoebox": {"key": "toBeExportedForShoebox", "type": "bool"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        to_be_exported_for_shoebox: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the metrics dimension.
        :paramtype name: str
        :keyword display_name: Display name of the metrics dimension.
        :paramtype display_name: str
        :keyword to_be_exported_for_shoebox: To be exported to shoe box.
        :paramtype to_be_exported_for_shoebox: bool
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.to_be_exported_for_shoebox = to_be_exported_for_shoebox


class MetricSpecificationV1(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Metric specification version 1.

    :ivar name: Name of the metric.
    :vartype name: str
    :ivar display_name: Display name of the metric.
    :vartype display_name: str
    :ivar display_description: Description of the metric to be displayed.
    :vartype display_description: str
    :ivar unit: Metric units. Known values are: "NotSpecified", "Percent", "Count", "Seconds",
     "Milliseconds", "Bytes", "BytesPerSecond", and "CountPerSecond".
    :vartype unit: str or ~azure.mgmt.databoxedge.v2019_03_01.models.MetricUnit
    :ivar aggregation_type: Metric aggregation type. Known values are: "NotSpecified", "None",
     "Average", "Minimum", "Maximum", "Total", and "Count".
    :vartype aggregation_type: str or
     ~azure.mgmt.databoxedge.v2019_03_01.models.MetricAggregationType
    :ivar dimensions: Metric dimensions, other than default dimension which is resource.
    :vartype dimensions: list[~azure.mgmt.databoxedge.v2019_03_01.models.MetricDimensionV1]
    :ivar fill_gap_with_zero: Set true to fill the gaps with zero.
    :vartype fill_gap_with_zero: bool
    :ivar category: Metric category. Known values are: "Capacity" and "Transaction".
    :vartype category: str or ~azure.mgmt.databoxedge.v2019_03_01.models.MetricCategory
    :ivar resource_id_dimension_name_override: Resource name override.
    :vartype resource_id_dimension_name_override: str
    :ivar supported_time_grain_types: Support granularity of metrics.
    :vartype supported_time_grain_types: list[str or
     ~azure.mgmt.databoxedge.v2019_03_01.models.TimeGrain]
    :ivar supported_aggregation_types: Support metric aggregation type.
    :vartype supported_aggregation_types: list[str or
     ~azure.mgmt.databoxedge.v2019_03_01.models.MetricAggregationType]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "display_description": {"key": "displayDescription", "type": "str"},
        "unit": {"key": "unit", "type": "str"},
        "aggregation_type": {"key": "aggregationType", "type": "str"},
        "dimensions": {"key": "dimensions", "type": "[MetricDimensionV1]"},
        "fill_gap_with_zero": {"key": "fillGapWithZero", "type": "bool"},
        "category": {"key": "category", "type": "str"},
        "resource_id_dimension_name_override": {"key": "resourceIdDimensionNameOverride", "type": "str"},
        "supported_time_grain_types": {"key": "supportedTimeGrainTypes", "type": "[str]"},
        "supported_aggregation_types": {"key": "supportedAggregationTypes", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        display_description: Optional[str] = None,
        unit: Optional[Union[str, "_models.MetricUnit"]] = None,
        aggregation_type: Optional[Union[str, "_models.MetricAggregationType"]] = None,
        dimensions: Optional[List["_models.MetricDimensionV1"]] = None,
        fill_gap_with_zero: Optional[bool] = None,
        category: Optional[Union[str, "_models.MetricCategory"]] = None,
        resource_id_dimension_name_override: Optional[str] = None,
        supported_time_grain_types: Optional[List[Union[str, "_models.TimeGrain"]]] = None,
        supported_aggregation_types: Optional[List[Union[str, "_models.MetricAggregationType"]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the metric.
        :paramtype name: str
        :keyword display_name: Display name of the metric.
        :paramtype display_name: str
        :keyword display_description: Description of the metric to be displayed.
        :paramtype display_description: str
        :keyword unit: Metric units. Known values are: "NotSpecified", "Percent", "Count", "Seconds",
         "Milliseconds", "Bytes", "BytesPerSecond", and "CountPerSecond".
        :paramtype unit: str or ~azure.mgmt.databoxedge.v2019_03_01.models.MetricUnit
        :keyword aggregation_type: Metric aggregation type. Known values are: "NotSpecified", "None",
         "Average", "Minimum", "Maximum", "Total", and "Count".
        :paramtype aggregation_type: str or
         ~azure.mgmt.databoxedge.v2019_03_01.models.MetricAggregationType
        :keyword dimensions: Metric dimensions, other than default dimension which is resource.
        :paramtype dimensions: list[~azure.mgmt.databoxedge.v2019_03_01.models.MetricDimensionV1]
        :keyword fill_gap_with_zero: Set true to fill the gaps with zero.
        :paramtype fill_gap_with_zero: bool
        :keyword category: Metric category. Known values are: "Capacity" and "Transaction".
        :paramtype category: str or ~azure.mgmt.databoxedge.v2019_03_01.models.MetricCategory
        :keyword resource_id_dimension_name_override: Resource name override.
        :paramtype resource_id_dimension_name_override: str
        :keyword supported_time_grain_types: Support granularity of metrics.
        :paramtype supported_time_grain_types: list[str or
         ~azure.mgmt.databoxedge.v2019_03_01.models.TimeGrain]
        :keyword supported_aggregation_types: Support metric aggregation type.
        :paramtype supported_aggregation_types: list[str or
         ~azure.mgmt.databoxedge.v2019_03_01.models.MetricAggregationType]
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.display_description = display_description
        self.unit = unit
        self.aggregation_type = aggregation_type
        self.dimensions = dimensions
        self.fill_gap_with_zero = fill_gap_with_zero
        self.category = category
        self.resource_id_dimension_name_override = resource_id_dimension_name_override
        self.supported_time_grain_types = supported_time_grain_types
        self.supported_aggregation_types = supported_aggregation_types


class MountPointMap(_serialization.Model):
    """The share mount point.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar share_id: ID of the share mounted to the role VM. Required.
    :vartype share_id: str
    :ivar role_id: ID of the role to which share is mounted.
    :vartype role_id: str
    :ivar mount_point: Mount point for the share.
    :vartype mount_point: str
    :ivar role_type: Role type. Known values are: "IOT", "ASA", "Functions", and "Cognitive".
    :vartype role_type: str or ~azure.mgmt.databoxedge.v2019_03_01.models.RoleTypes
    """

    _validation = {
        "share_id": {"required": True},
        "role_id": {"readonly": True},
        "mount_point": {"readonly": True},
        "role_type": {"readonly": True},
    }

    _attribute_map = {
        "share_id": {"key": "shareId", "type": "str"},
        "role_id": {"key": "roleId", "type": "str"},
        "mount_point": {"key": "mountPoint", "type": "str"},
        "role_type": {"key": "roleType", "type": "str"},
    }

    def __init__(self, *, share_id: str, **kwargs: Any) -> None:
        """
        :keyword share_id: ID of the share mounted to the role VM. Required.
        :paramtype share_id: str
        """
        super().__init__(**kwargs)
        self.share_id = share_id
        self.role_id = None
        self.mount_point = None
        self.role_type = None


class NetworkAdapter(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Represents the networkAdapter on a device.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar adapter_id: Instance ID of network adapter.
    :vartype adapter_id: str
    :ivar adapter_position: Hardware position of network adapter.
    :vartype adapter_position: ~azure.mgmt.databoxedge.v2019_03_01.models.NetworkAdapterPosition
    :ivar index: Logical index of the adapter.
    :vartype index: int
    :ivar node_id: Node ID of the network adapter.
    :vartype node_id: str
    :ivar network_adapter_name: Network adapter name.
    :vartype network_adapter_name: str
    :ivar label: Hardware label for the adapter.
    :vartype label: str
    :ivar mac_address: MAC address.
    :vartype mac_address: str
    :ivar link_speed: Link speed.
    :vartype link_speed: int
    :ivar status: Value indicating whether this adapter is valid. Known values are: "Inactive" and
     "Active".
    :vartype status: str or ~azure.mgmt.databoxedge.v2019_03_01.models.NetworkAdapterStatus
    :ivar rdma_status: Value indicating whether this adapter is RDMA capable. Known values are:
     "Incapable" and "Capable".
    :vartype rdma_status: str or
     ~azure.mgmt.databoxedge.v2019_03_01.models.NetworkAdapterRDMAStatus
    :ivar dhcp_status: Value indicating whether this adapter has DHCP enabled. Known values are:
     "Disabled" and "Enabled".
    :vartype dhcp_status: str or
     ~azure.mgmt.databoxedge.v2019_03_01.models.NetworkAdapterDHCPStatus
    :ivar ipv4_configuration: The IPv4 configuration of the network adapter.
    :vartype ipv4_configuration: ~azure.mgmt.databoxedge.v2019_03_01.models.Ipv4Config
    :ivar ipv6_configuration: The IPv6 configuration of the network adapter.
    :vartype ipv6_configuration: ~azure.mgmt.databoxedge.v2019_03_01.models.Ipv6Config
    :ivar ipv6_link_local_address: The IPv6 local address.
    :vartype ipv6_link_local_address: str
    :ivar dns_servers: The list of DNS Servers of the device.
    :vartype dns_servers: list[str]
    """

    _validation = {
        "adapter_id": {"readonly": True},
        "adapter_position": {"readonly": True},
        "index": {"readonly": True},
        "node_id": {"readonly": True},
        "network_adapter_name": {"readonly": True},
        "label": {"readonly": True},
        "mac_address": {"readonly": True},
        "link_speed": {"readonly": True},
        "status": {"readonly": True},
        "ipv4_configuration": {"readonly": True},
        "ipv6_configuration": {"readonly": True},
        "ipv6_link_local_address": {"readonly": True},
        "dns_servers": {"readonly": True},
    }

    _attribute_map = {
        "adapter_id": {"key": "adapterId", "type": "str"},
        "adapter_position": {"key": "adapterPosition", "type": "NetworkAdapterPosition"},
        "index": {"key": "index", "type": "int"},
        "node_id": {"key": "nodeId", "type": "str"},
        "network_adapter_name": {"key": "networkAdapterName", "type": "str"},
        "label": {"key": "label", "type": "str"},
        "mac_address": {"key": "macAddress", "type": "str"},
        "link_speed": {"key": "linkSpeed", "type": "int"},
        "status": {"key": "status", "type": "str"},
        "rdma_status": {"key": "rdmaStatus", "type": "str"},
        "dhcp_status": {"key": "dhcpStatus", "type": "str"},
        "ipv4_configuration": {"key": "ipv4Configuration", "type": "Ipv4Config"},
        "ipv6_configuration": {"key": "ipv6Configuration", "type": "Ipv6Config"},
        "ipv6_link_local_address": {"key": "ipv6LinkLocalAddress", "type": "str"},
        "dns_servers": {"key": "dnsServers", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        rdma_status: Optional[Union[str, "_models.NetworkAdapterRDMAStatus"]] = None,
        dhcp_status: Optional[Union[str, "_models.NetworkAdapterDHCPStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword rdma_status: Value indicating whether this adapter is RDMA capable. Known values are:
         "Incapable" and "Capable".
        :paramtype rdma_status: str or
         ~azure.mgmt.databoxedge.v2019_03_01.models.NetworkAdapterRDMAStatus
        :keyword dhcp_status: Value indicating whether this adapter has DHCP enabled. Known values are:
         "Disabled" and "Enabled".
        :paramtype dhcp_status: str or
         ~azure.mgmt.databoxedge.v2019_03_01.models.NetworkAdapterDHCPStatus
        """
        super().__init__(**kwargs)
        self.adapter_id = None
        self.adapter_position = None
        self.index = None
        self.node_id = None
        self.network_adapter_name = None
        self.label = None
        self.mac_address = None
        self.link_speed = None
        self.status = None
        self.rdma_status = rdma_status
        self.dhcp_status = dhcp_status
        self.ipv4_configuration = None
        self.ipv6_configuration = None
        self.ipv6_link_local_address = None
        self.dns_servers = None


class NetworkAdapterPosition(_serialization.Model):
    """The network adapter position.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar network_group: The network group. Known values are: "None", "NonRDMA", and "RDMA".
    :vartype network_group: str or ~azure.mgmt.databoxedge.v2019_03_01.models.NetworkGroup
    :ivar port: The port.
    :vartype port: int
    """

    _validation = {
        "network_group": {"readonly": True},
        "port": {"readonly": True},
    }

    _attribute_map = {
        "network_group": {"key": "networkGroup", "type": "str"},
        "port": {"key": "port", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.network_group = None
        self.port = None


class NetworkSettings(ARMBaseModel):
    """The network settings of a device.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :ivar network_adapters: The network adapter list on the device.
    :vartype network_adapters: list[~azure.mgmt.databoxedge.v2019_03_01.models.NetworkAdapter]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "network_adapters": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "network_adapters": {"key": "properties.networkAdapters", "type": "[NetworkAdapter]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.network_adapters = None


class Operation(_serialization.Model):
    """Operations.

    :ivar name: Name of the operation.
    :vartype name: str
    :ivar display: Properties displayed for the operation.
    :vartype display: ~azure.mgmt.databoxedge.v2019_03_01.models.OperationDisplay
    :ivar origin: Origin of the operation.
    :vartype origin: str
    :ivar service_specification: Service specification.
    :vartype service_specification: ~azure.mgmt.databoxedge.v2019_03_01.models.ServiceSpecification
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "service_specification": {"key": "properties.serviceSpecification", "type": "ServiceSpecification"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["_models.OperationDisplay"] = None,
        origin: Optional[str] = None,
        service_specification: Optional["_models.ServiceSpecification"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the operation.
        :paramtype name: str
        :keyword display: Properties displayed for the operation.
        :paramtype display: ~azure.mgmt.databoxedge.v2019_03_01.models.OperationDisplay
        :keyword origin: Origin of the operation.
        :paramtype origin: str
        :keyword service_specification: Service specification.
        :paramtype service_specification:
         ~azure.mgmt.databoxedge.v2019_03_01.models.ServiceSpecification
        """
        super().__init__(**kwargs)
        self.name = name
        self.display = display
        self.origin = origin
        self.service_specification = service_specification


class OperationDisplay(_serialization.Model):
    """Operation display properties.

    :ivar provider: Provider name.
    :vartype provider: str
    :ivar resource: The type of resource in which the operation is performed.
    :vartype resource: str
    :ivar operation: Operation to be performed on the resource.
    :vartype operation: str
    :ivar description: Description of the operation to be performed.
    :vartype description: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provider: Provider name.
        :paramtype provider: str
        :keyword resource: The type of resource in which the operation is performed.
        :paramtype resource: str
        :keyword operation: Operation to be performed on the resource.
        :paramtype operation: str
        :keyword description: Description of the operation to be performed.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationsList(_serialization.Model):
    """The list of operations used for the discovery of available provider operations.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The value. Required.
    :vartype value: list[~azure.mgmt.databoxedge.v2019_03_01.models.Operation]
    :ivar next_link: Link to the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Operation"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The value. Required.
        :paramtype value: list[~azure.mgmt.databoxedge.v2019_03_01.models.Operation]
        :keyword next_link: Link to the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Order(ARMBaseModel):
    """The order details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :ivar contact_information: The contact details.
    :vartype contact_information: ~azure.mgmt.databoxedge.v2019_03_01.models.ContactDetails
    :ivar shipping_address: The shipping address.
    :vartype shipping_address: ~azure.mgmt.databoxedge.v2019_03_01.models.Address
    :ivar current_status: Current status of the order.
    :vartype current_status: ~azure.mgmt.databoxedge.v2019_03_01.models.OrderStatus
    :ivar order_history: List of status changes in the order.
    :vartype order_history: list[~azure.mgmt.databoxedge.v2019_03_01.models.OrderStatus]
    :ivar serial_number: Serial number of the device.
    :vartype serial_number: str
    :ivar delivery_tracking_info: Tracking information for the package delivered to the customer
     whether it has an original or a replacement device.
    :vartype delivery_tracking_info: list[~azure.mgmt.databoxedge.v2019_03_01.models.TrackingInfo]
    :ivar return_tracking_info: Tracking information for the package returned from the customer
     whether it has an original or a replacement device.
    :vartype return_tracking_info: list[~azure.mgmt.databoxedge.v2019_03_01.models.TrackingInfo]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "order_history": {"readonly": True},
        "serial_number": {"readonly": True},
        "delivery_tracking_info": {"readonly": True},
        "return_tracking_info": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "contact_information": {"key": "properties.contactInformation", "type": "ContactDetails"},
        "shipping_address": {"key": "properties.shippingAddress", "type": "Address"},
        "current_status": {"key": "properties.currentStatus", "type": "OrderStatus"},
        "order_history": {"key": "properties.orderHistory", "type": "[OrderStatus]"},
        "serial_number": {"key": "properties.serialNumber", "type": "str"},
        "delivery_tracking_info": {"key": "properties.deliveryTrackingInfo", "type": "[TrackingInfo]"},
        "return_tracking_info": {"key": "properties.returnTrackingInfo", "type": "[TrackingInfo]"},
    }

    def __init__(
        self,
        *,
        contact_information: Optional["_models.ContactDetails"] = None,
        shipping_address: Optional["_models.Address"] = None,
        current_status: Optional["_models.OrderStatus"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword contact_information: The contact details.
        :paramtype contact_information: ~azure.mgmt.databoxedge.v2019_03_01.models.ContactDetails
        :keyword shipping_address: The shipping address.
        :paramtype shipping_address: ~azure.mgmt.databoxedge.v2019_03_01.models.Address
        :keyword current_status: Current status of the order.
        :paramtype current_status: ~azure.mgmt.databoxedge.v2019_03_01.models.OrderStatus
        """
        super().__init__(**kwargs)
        self.contact_information = contact_information
        self.shipping_address = shipping_address
        self.current_status = current_status
        self.order_history = None
        self.serial_number = None
        self.delivery_tracking_info = None
        self.return_tracking_info = None


class OrderList(_serialization.Model):
    """List of order entities.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of orders.
    :vartype value: list[~azure.mgmt.databoxedge.v2019_03_01.models.Order]
    :ivar next_link: Link to the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Order]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class OrderStatus(_serialization.Model):
    """Represents a single status change.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar status: Status of the order as per the allowed status types. Required. Known values are:
     "Untracked", "AwaitingFulfilment", "AwaitingPreparation", "AwaitingShipment", "Shipped",
     "Arriving", "Delivered", "ReplacementRequested", "LostDevice", "Declined", "ReturnInitiated",
     "AwaitingReturnShipment", "ShippedBack", and "CollectedAtMicrosoft".
    :vartype status: str or ~azure.mgmt.databoxedge.v2019_03_01.models.OrderState
    :ivar update_date_time: Time of status update.
    :vartype update_date_time: ~datetime.datetime
    :ivar comments: Comments related to this status change.
    :vartype comments: str
    """

    _validation = {
        "status": {"required": True},
        "update_date_time": {"readonly": True},
    }

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "update_date_time": {"key": "updateDateTime", "type": "iso-8601"},
        "comments": {"key": "comments", "type": "str"},
    }

    def __init__(
        self, *, status: Union[str, "_models.OrderState"], comments: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword status: Status of the order as per the allowed status types. Required. Known values
         are: "Untracked", "AwaitingFulfilment", "AwaitingPreparation", "AwaitingShipment", "Shipped",
         "Arriving", "Delivered", "ReplacementRequested", "LostDevice", "Declined", "ReturnInitiated",
         "AwaitingReturnShipment", "ShippedBack", and "CollectedAtMicrosoft".
        :paramtype status: str or ~azure.mgmt.databoxedge.v2019_03_01.models.OrderState
        :keyword comments: Comments related to this status change.
        :paramtype comments: str
        """
        super().__init__(**kwargs)
        self.status = status
        self.update_date_time = None
        self.comments = comments


class PeriodicTimerEventTrigger(Trigger):
    """Trigger details.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :ivar kind: Trigger Kind. Required. Known values are: "FileEvent" and "PeriodicTimerEvent".
    :vartype kind: str or ~azure.mgmt.databoxedge.v2019_03_01.models.TriggerEventType
    :ivar source_info: Periodic timer details. Required.
    :vartype source_info: ~azure.mgmt.databoxedge.v2019_03_01.models.PeriodicTimerSourceInfo
    :ivar sink_info: Role Sink information. Required.
    :vartype sink_info: ~azure.mgmt.databoxedge.v2019_03_01.models.RoleSinkInfo
    :ivar custom_context_tag: A custom context tag typically used to correlate the trigger against
     its usage. For example, if a periodic timer trigger is intended for certain specific IoT
     modules in the device, the tag can be the name or the image URL of the module.
    :vartype custom_context_tag: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "kind": {"required": True},
        "source_info": {"required": True},
        "sink_info": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "source_info": {"key": "properties.sourceInfo", "type": "PeriodicTimerSourceInfo"},
        "sink_info": {"key": "properties.sinkInfo", "type": "RoleSinkInfo"},
        "custom_context_tag": {"key": "properties.customContextTag", "type": "str"},
    }

    def __init__(
        self,
        *,
        source_info: "_models.PeriodicTimerSourceInfo",
        sink_info: "_models.RoleSinkInfo",
        custom_context_tag: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword source_info: Periodic timer details. Required.
        :paramtype source_info: ~azure.mgmt.databoxedge.v2019_03_01.models.PeriodicTimerSourceInfo
        :keyword sink_info: Role Sink information. Required.
        :paramtype sink_info: ~azure.mgmt.databoxedge.v2019_03_01.models.RoleSinkInfo
        :keyword custom_context_tag: A custom context tag typically used to correlate the trigger
         against its usage. For example, if a periodic timer trigger is intended for certain specific
         IoT modules in the device, the tag can be the name or the image URL of the module.
        :paramtype custom_context_tag: str
        """
        super().__init__(**kwargs)
        self.kind: str = "PeriodicTimerEvent"
        self.source_info = source_info
        self.sink_info = sink_info
        self.custom_context_tag = custom_context_tag


class PeriodicTimerSourceInfo(_serialization.Model):
    """Periodic timer event source.

    All required parameters must be populated in order to send to Azure.

    :ivar start_time: The time of the day that results in a valid trigger. Schedule is computed
     with reference to the time specified up to seconds. If timezone is not specified the time will
     considered to be in device timezone. The value will always be returned as UTC time. Required.
    :vartype start_time: ~datetime.datetime
    :ivar schedule: Periodic frequency at which timer event needs to be raised. Supports daily,
     hourly, minutes, and seconds. Required.
    :vartype schedule: str
    :ivar topic: Topic where periodic events are published to IoT device.
    :vartype topic: str
    """

    _validation = {
        "start_time": {"required": True},
        "schedule": {"required": True},
    }

    _attribute_map = {
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "schedule": {"key": "schedule", "type": "str"},
        "topic": {"key": "topic", "type": "str"},
    }

    def __init__(
        self, *, start_time: datetime.datetime, schedule: str, topic: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword start_time: The time of the day that results in a valid trigger. Schedule is computed
         with reference to the time specified up to seconds. If timezone is not specified the time will
         considered to be in device timezone. The value will always be returned as UTC time. Required.
        :paramtype start_time: ~datetime.datetime
        :keyword schedule: Periodic frequency at which timer event needs to be raised. Supports daily,
         hourly, minutes, and seconds. Required.
        :paramtype schedule: str
        :keyword topic: Topic where periodic events are published to IoT device.
        :paramtype topic: str
        """
        super().__init__(**kwargs)
        self.start_time = start_time
        self.schedule = schedule
        self.topic = topic


class RefreshDetails(_serialization.Model):
    """Fields for tracking refresh job on the share.

    :ivar in_progress_refresh_job_id: If a refresh share job is currently in progress on this
     share, this field indicates the ARM resource ID of that job. The field is empty if no job is in
     progress.
    :vartype in_progress_refresh_job_id: str
    :ivar last_completed_refresh_job_time_in_utc: Indicates the completed time for the last refresh
     job on this particular share, if any.This could be a failed job or a successful job.
    :vartype last_completed_refresh_job_time_in_utc: ~datetime.datetime
    :ivar error_manifest_file: Indicates the relative path of the error xml for the last refresh
     job on this particular share, if any. This could be a failed job or a successful job.
    :vartype error_manifest_file: str
    :ivar last_job: Indicates the id of the last refresh job on this particular share,if any. This
     could be a failed job or a successful job.
    :vartype last_job: str
    """

    _attribute_map = {
        "in_progress_refresh_job_id": {"key": "inProgressRefreshJobId", "type": "str"},
        "last_completed_refresh_job_time_in_utc": {"key": "lastCompletedRefreshJobTimeInUTC", "type": "iso-8601"},
        "error_manifest_file": {"key": "errorManifestFile", "type": "str"},
        "last_job": {"key": "lastJob", "type": "str"},
    }

    def __init__(
        self,
        *,
        in_progress_refresh_job_id: Optional[str] = None,
        last_completed_refresh_job_time_in_utc: Optional[datetime.datetime] = None,
        error_manifest_file: Optional[str] = None,
        last_job: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword in_progress_refresh_job_id: If a refresh share job is currently in progress on this
         share, this field indicates the ARM resource ID of that job. The field is empty if no job is in
         progress.
        :paramtype in_progress_refresh_job_id: str
        :keyword last_completed_refresh_job_time_in_utc: Indicates the completed time for the last
         refresh job on this particular share, if any.This could be a failed job or a successful job.
        :paramtype last_completed_refresh_job_time_in_utc: ~datetime.datetime
        :keyword error_manifest_file: Indicates the relative path of the error xml for the last refresh
         job on this particular share, if any. This could be a failed job or a successful job.
        :paramtype error_manifest_file: str
        :keyword last_job: Indicates the id of the last refresh job on this particular share,if any.
         This could be a failed job or a successful job.
        :paramtype last_job: str
        """
        super().__init__(**kwargs)
        self.in_progress_refresh_job_id = in_progress_refresh_job_id
        self.last_completed_refresh_job_time_in_utc = last_completed_refresh_job_time_in_utc
        self.error_manifest_file = error_manifest_file
        self.last_job = last_job


class RoleList(_serialization.Model):
    """Collection of all the roles on the Data Box Edge device.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The Value.
    :vartype value: list[~azure.mgmt.databoxedge.v2019_03_01.models.Role]
    :ivar next_link: Link to the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Role]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class RoleSinkInfo(_serialization.Model):
    """Compute role against which events will be raised.

    All required parameters must be populated in order to send to Azure.

    :ivar role_id: Compute role ID. Required.
    :vartype role_id: str
    """

    _validation = {
        "role_id": {"required": True},
    }

    _attribute_map = {
        "role_id": {"key": "roleId", "type": "str"},
    }

    def __init__(self, *, role_id: str, **kwargs: Any) -> None:
        """
        :keyword role_id: Compute role ID. Required.
        :paramtype role_id: str
        """
        super().__init__(**kwargs)
        self.role_id = role_id


class SecuritySettings(ARMBaseModel):
    """The security settings of a device.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :ivar device_admin_password: Device administrator password as an encrypted string (encrypted
     using RSA PKCS #1) is used to sign into the  local web UI of the device. The Actual password
     should have at least 8 characters that are a combination of  uppercase, lowercase, numeric, and
     special characters. Required.
    :vartype device_admin_password:
     ~azure.mgmt.databoxedge.v2019_03_01.models.AsymmetricEncryptedSecret
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "device_admin_password": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "device_admin_password": {"key": "properties.deviceAdminPassword", "type": "AsymmetricEncryptedSecret"},
    }

    def __init__(self, *, device_admin_password: "_models.AsymmetricEncryptedSecret", **kwargs: Any) -> None:
        """
        :keyword device_admin_password: Device administrator password as an encrypted string (encrypted
         using RSA PKCS #1) is used to sign into the  local web UI of the device. The Actual password
         should have at least 8 characters that are a combination of  uppercase, lowercase, numeric, and
         special characters. Required.
        :paramtype device_admin_password:
         ~azure.mgmt.databoxedge.v2019_03_01.models.AsymmetricEncryptedSecret
        """
        super().__init__(**kwargs)
        self.device_admin_password = device_admin_password


class ServiceSpecification(_serialization.Model):
    """Service specification.

    :ivar metric_specifications: Metric specification as defined by shoebox.
    :vartype metric_specifications:
     list[~azure.mgmt.databoxedge.v2019_03_01.models.MetricSpecificationV1]
    """

    _attribute_map = {
        "metric_specifications": {"key": "metricSpecifications", "type": "[MetricSpecificationV1]"},
    }

    def __init__(
        self, *, metric_specifications: Optional[List["_models.MetricSpecificationV1"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword metric_specifications: Metric specification as defined by shoebox.
        :paramtype metric_specifications:
         list[~azure.mgmt.databoxedge.v2019_03_01.models.MetricSpecificationV1]
        """
        super().__init__(**kwargs)
        self.metric_specifications = metric_specifications


class Share(ARMBaseModel):  # pylint: disable=too-many-instance-attributes
    """Represents a share on the  Data Box Edge/Gateway device.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :ivar description: Description for the share.
    :vartype description: str
    :ivar share_status: Current status of the share. Required. Known values are: "Online" and
     "Offline".
    :vartype share_status: str or ~azure.mgmt.databoxedge.v2019_03_01.models.ShareStatus
    :ivar monitoring_status: Current monitoring status of the share. Required. Known values are:
     "Enabled" and "Disabled".
    :vartype monitoring_status: str or ~azure.mgmt.databoxedge.v2019_03_01.models.MonitoringStatus
    :ivar azure_container_info: Azure container mapping for the share.
    :vartype azure_container_info: ~azure.mgmt.databoxedge.v2019_03_01.models.AzureContainerInfo
    :ivar access_protocol: Access protocol to be used by the share. Required. Known values are:
     "SMB" and "NFS".
    :vartype access_protocol: str or ~azure.mgmt.databoxedge.v2019_03_01.models.ShareAccessProtocol
    :ivar user_access_rights: Mapping of users and corresponding access rights on the share
     (required for SMB protocol).
    :vartype user_access_rights: list[~azure.mgmt.databoxedge.v2019_03_01.models.UserAccessRight]
    :ivar client_access_rights: List of IP addresses and corresponding access rights on the
     share(required for NFS protocol).
    :vartype client_access_rights:
     list[~azure.mgmt.databoxedge.v2019_03_01.models.ClientAccessRight]
    :ivar refresh_details: Details of the refresh job on this share.
    :vartype refresh_details: ~azure.mgmt.databoxedge.v2019_03_01.models.RefreshDetails
    :ivar share_mappings: Share mount point to the role.
    :vartype share_mappings: list[~azure.mgmt.databoxedge.v2019_03_01.models.MountPointMap]
    :ivar data_policy: Data policy of the share. Known values are: "Cloud" and "Local".
    :vartype data_policy: str or ~azure.mgmt.databoxedge.v2019_03_01.models.DataPolicy
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "share_status": {"required": True},
        "monitoring_status": {"required": True},
        "access_protocol": {"required": True},
        "share_mappings": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "share_status": {"key": "properties.shareStatus", "type": "str"},
        "monitoring_status": {"key": "properties.monitoringStatus", "type": "str"},
        "azure_container_info": {"key": "properties.azureContainerInfo", "type": "AzureContainerInfo"},
        "access_protocol": {"key": "properties.accessProtocol", "type": "str"},
        "user_access_rights": {"key": "properties.userAccessRights", "type": "[UserAccessRight]"},
        "client_access_rights": {"key": "properties.clientAccessRights", "type": "[ClientAccessRight]"},
        "refresh_details": {"key": "properties.refreshDetails", "type": "RefreshDetails"},
        "share_mappings": {"key": "properties.shareMappings", "type": "[MountPointMap]"},
        "data_policy": {"key": "properties.dataPolicy", "type": "str"},
    }

    def __init__(
        self,
        *,
        share_status: Union[str, "_models.ShareStatus"],
        monitoring_status: Union[str, "_models.MonitoringStatus"],
        access_protocol: Union[str, "_models.ShareAccessProtocol"],
        description: Optional[str] = None,
        azure_container_info: Optional["_models.AzureContainerInfo"] = None,
        user_access_rights: Optional[List["_models.UserAccessRight"]] = None,
        client_access_rights: Optional[List["_models.ClientAccessRight"]] = None,
        refresh_details: Optional["_models.RefreshDetails"] = None,
        data_policy: Optional[Union[str, "_models.DataPolicy"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: Description for the share.
        :paramtype description: str
        :keyword share_status: Current status of the share. Required. Known values are: "Online" and
         "Offline".
        :paramtype share_status: str or ~azure.mgmt.databoxedge.v2019_03_01.models.ShareStatus
        :keyword monitoring_status: Current monitoring status of the share. Required. Known values are:
         "Enabled" and "Disabled".
        :paramtype monitoring_status: str or
         ~azure.mgmt.databoxedge.v2019_03_01.models.MonitoringStatus
        :keyword azure_container_info: Azure container mapping for the share.
        :paramtype azure_container_info: ~azure.mgmt.databoxedge.v2019_03_01.models.AzureContainerInfo
        :keyword access_protocol: Access protocol to be used by the share. Required. Known values are:
         "SMB" and "NFS".
        :paramtype access_protocol: str or
         ~azure.mgmt.databoxedge.v2019_03_01.models.ShareAccessProtocol
        :keyword user_access_rights: Mapping of users and corresponding access rights on the share
         (required for SMB protocol).
        :paramtype user_access_rights: list[~azure.mgmt.databoxedge.v2019_03_01.models.UserAccessRight]
        :keyword client_access_rights: List of IP addresses and corresponding access rights on the
         share(required for NFS protocol).
        :paramtype client_access_rights:
         list[~azure.mgmt.databoxedge.v2019_03_01.models.ClientAccessRight]
        :keyword refresh_details: Details of the refresh job on this share.
        :paramtype refresh_details: ~azure.mgmt.databoxedge.v2019_03_01.models.RefreshDetails
        :keyword data_policy: Data policy of the share. Known values are: "Cloud" and "Local".
        :paramtype data_policy: str or ~azure.mgmt.databoxedge.v2019_03_01.models.DataPolicy
        """
        super().__init__(**kwargs)
        self.description = description
        self.share_status = share_status
        self.monitoring_status = monitoring_status
        self.azure_container_info = azure_container_info
        self.access_protocol = access_protocol
        self.user_access_rights = user_access_rights
        self.client_access_rights = client_access_rights
        self.refresh_details = refresh_details
        self.share_mappings = None
        self.data_policy = data_policy


class ShareAccessRight(_serialization.Model):
    """Specifies the mapping between this particular user and the type of access he has on shares on
    this device.

    All required parameters must be populated in order to send to Azure.

    :ivar share_id: The share ID. Required.
    :vartype share_id: str
    :ivar access_type: Type of access to be allowed on the share for this user. Required. Known
     values are: "Change", "Read", and "Custom".
    :vartype access_type: str or ~azure.mgmt.databoxedge.v2019_03_01.models.ShareAccessType
    """

    _validation = {
        "share_id": {"required": True},
        "access_type": {"required": True},
    }

    _attribute_map = {
        "share_id": {"key": "shareId", "type": "str"},
        "access_type": {"key": "accessType", "type": "str"},
    }

    def __init__(self, *, share_id: str, access_type: Union[str, "_models.ShareAccessType"], **kwargs: Any) -> None:
        """
        :keyword share_id: The share ID. Required.
        :paramtype share_id: str
        :keyword access_type: Type of access to be allowed on the share for this user. Required. Known
         values are: "Change", "Read", and "Custom".
        :paramtype access_type: str or ~azure.mgmt.databoxedge.v2019_03_01.models.ShareAccessType
        """
        super().__init__(**kwargs)
        self.share_id = share_id
        self.access_type = access_type


class ShareList(_serialization.Model):
    """Collection of all the shares on the Data Box Edge/Gateway device.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of shares.
    :vartype value: list[~azure.mgmt.databoxedge.v2019_03_01.models.Share]
    :ivar next_link: Link to the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Share]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class Sku(_serialization.Model):
    """The SKU type.

    :ivar name: SKU name. Known values are: "Gateway" and "Edge".
    :vartype name: str or ~azure.mgmt.databoxedge.v2019_03_01.models.SkuName
    :ivar tier: The SKU tier. This is based on the SKU name. "Standard"
    :vartype tier: str or ~azure.mgmt.databoxedge.v2019_03_01.models.SkuTier
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[Union[str, "_models.SkuName"]] = None,
        tier: Optional[Union[str, "_models.SkuTier"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: SKU name. Known values are: "Gateway" and "Edge".
        :paramtype name: str or ~azure.mgmt.databoxedge.v2019_03_01.models.SkuName
        :keyword tier: The SKU tier. This is based on the SKU name. "Standard"
        :paramtype tier: str or ~azure.mgmt.databoxedge.v2019_03_01.models.SkuTier
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = tier


class StorageAccountCredential(ARMBaseModel):
    """The storage account credential.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :ivar alias: Alias for the storage account. Required.
    :vartype alias: str
    :ivar user_name: Username for the storage account.
    :vartype user_name: str
    :ivar account_key: Encrypted storage key.
    :vartype account_key: ~azure.mgmt.databoxedge.v2019_03_01.models.AsymmetricEncryptedSecret
    :ivar connection_string: Connection string for the storage account. Use this string if username
     and account key are not specified.
    :vartype connection_string: str
    :ivar ssl_status: Signifies whether SSL needs to be enabled or not. Required. Known values are:
     "Enabled" and "Disabled".
    :vartype ssl_status: str or ~azure.mgmt.databoxedge.v2019_03_01.models.SSLStatus
    :ivar blob_domain_name: Blob end point for private clouds.
    :vartype blob_domain_name: str
    :ivar account_type: Type of storage accessed on the storage account. Required. Known values
     are: "GeneralPurposeStorage" and "BlobStorage".
    :vartype account_type: str or ~azure.mgmt.databoxedge.v2019_03_01.models.AccountType
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "alias": {"required": True},
        "ssl_status": {"required": True},
        "account_type": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "alias": {"key": "properties.alias", "type": "str"},
        "user_name": {"key": "properties.userName", "type": "str"},
        "account_key": {"key": "properties.accountKey", "type": "AsymmetricEncryptedSecret"},
        "connection_string": {"key": "properties.connectionString", "type": "str"},
        "ssl_status": {"key": "properties.sslStatus", "type": "str"},
        "blob_domain_name": {"key": "properties.blobDomainName", "type": "str"},
        "account_type": {"key": "properties.accountType", "type": "str"},
    }

    def __init__(
        self,
        *,
        alias: str,
        ssl_status: Union[str, "_models.SSLStatus"],
        account_type: Union[str, "_models.AccountType"],
        user_name: Optional[str] = None,
        account_key: Optional["_models.AsymmetricEncryptedSecret"] = None,
        connection_string: Optional[str] = None,
        blob_domain_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword alias: Alias for the storage account. Required.
        :paramtype alias: str
        :keyword user_name: Username for the storage account.
        :paramtype user_name: str
        :keyword account_key: Encrypted storage key.
        :paramtype account_key: ~azure.mgmt.databoxedge.v2019_03_01.models.AsymmetricEncryptedSecret
        :keyword connection_string: Connection string for the storage account. Use this string if
         username and account key are not specified.
        :paramtype connection_string: str
        :keyword ssl_status: Signifies whether SSL needs to be enabled or not. Required. Known values
         are: "Enabled" and "Disabled".
        :paramtype ssl_status: str or ~azure.mgmt.databoxedge.v2019_03_01.models.SSLStatus
        :keyword blob_domain_name: Blob end point for private clouds.
        :paramtype blob_domain_name: str
        :keyword account_type: Type of storage accessed on the storage account. Required. Known values
         are: "GeneralPurposeStorage" and "BlobStorage".
        :paramtype account_type: str or ~azure.mgmt.databoxedge.v2019_03_01.models.AccountType
        """
        super().__init__(**kwargs)
        self.alias = alias
        self.user_name = user_name
        self.account_key = account_key
        self.connection_string = connection_string
        self.ssl_status = ssl_status
        self.blob_domain_name = blob_domain_name
        self.account_type = account_type


class StorageAccountCredentialList(_serialization.Model):
    """The collection of storage account credentials.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The value.
    :vartype value: list[~azure.mgmt.databoxedge.v2019_03_01.models.StorageAccountCredential]
    :ivar next_link: Link to the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[StorageAccountCredential]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class SymmetricKey(_serialization.Model):
    """Symmetric key for authentication.

    :ivar connection_string: Connection string based on the symmetric key.
    :vartype connection_string:
     ~azure.mgmt.databoxedge.v2019_03_01.models.AsymmetricEncryptedSecret
    """

    _attribute_map = {
        "connection_string": {"key": "connectionString", "type": "AsymmetricEncryptedSecret"},
    }

    def __init__(
        self, *, connection_string: Optional["_models.AsymmetricEncryptedSecret"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword connection_string: Connection string based on the symmetric key.
        :paramtype connection_string:
         ~azure.mgmt.databoxedge.v2019_03_01.models.AsymmetricEncryptedSecret
        """
        super().__init__(**kwargs)
        self.connection_string = connection_string


class TrackingInfo(_serialization.Model):
    """Tracking courier information.

    :ivar serial_number: Serial number of the device being tracked.
    :vartype serial_number: str
    :ivar carrier_name: Name of the carrier used in the delivery.
    :vartype carrier_name: str
    :ivar tracking_id: Tracking ID of the shipment.
    :vartype tracking_id: str
    :ivar tracking_url: Tracking URL of the shipment.
    :vartype tracking_url: str
    """

    _attribute_map = {
        "serial_number": {"key": "serialNumber", "type": "str"},
        "carrier_name": {"key": "carrierName", "type": "str"},
        "tracking_id": {"key": "trackingId", "type": "str"},
        "tracking_url": {"key": "trackingUrl", "type": "str"},
    }

    def __init__(
        self,
        *,
        serial_number: Optional[str] = None,
        carrier_name: Optional[str] = None,
        tracking_id: Optional[str] = None,
        tracking_url: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword serial_number: Serial number of the device being tracked.
        :paramtype serial_number: str
        :keyword carrier_name: Name of the carrier used in the delivery.
        :paramtype carrier_name: str
        :keyword tracking_id: Tracking ID of the shipment.
        :paramtype tracking_id: str
        :keyword tracking_url: Tracking URL of the shipment.
        :paramtype tracking_url: str
        """
        super().__init__(**kwargs)
        self.serial_number = serial_number
        self.carrier_name = carrier_name
        self.tracking_id = tracking_id
        self.tracking_url = tracking_url


class TriggerList(_serialization.Model):
    """Collection of all trigger on the data box edge device.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of triggers.
    :vartype value: list[~azure.mgmt.databoxedge.v2019_03_01.models.Trigger]
    :ivar next_link: Link to the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Trigger]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class UpdateDownloadProgress(_serialization.Model):
    """Details about the download progress of update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar download_phase: The download phase. Known values are: "Unknown", "Initializing",
     "Downloading", and "Verifying".
    :vartype download_phase: str or ~azure.mgmt.databoxedge.v2019_03_01.models.DownloadPhase
    :ivar percent_complete: Percentage of completion.
    :vartype percent_complete: int
    :ivar total_bytes_to_download: Total bytes to download.
    :vartype total_bytes_to_download: float
    :ivar total_bytes_downloaded: Total bytes downloaded.
    :vartype total_bytes_downloaded: float
    :ivar number_of_updates_to_download: Number of updates to download.
    :vartype number_of_updates_to_download: int
    :ivar number_of_updates_downloaded: Number of updates downloaded.
    :vartype number_of_updates_downloaded: int
    """

    _validation = {
        "download_phase": {"readonly": True},
        "percent_complete": {"readonly": True},
        "total_bytes_to_download": {"readonly": True},
        "total_bytes_downloaded": {"readonly": True},
        "number_of_updates_to_download": {"readonly": True},
        "number_of_updates_downloaded": {"readonly": True},
    }

    _attribute_map = {
        "download_phase": {"key": "downloadPhase", "type": "str"},
        "percent_complete": {"key": "percentComplete", "type": "int"},
        "total_bytes_to_download": {"key": "totalBytesToDownload", "type": "float"},
        "total_bytes_downloaded": {"key": "totalBytesDownloaded", "type": "float"},
        "number_of_updates_to_download": {"key": "numberOfUpdatesToDownload", "type": "int"},
        "number_of_updates_downloaded": {"key": "numberOfUpdatesDownloaded", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.download_phase = None
        self.percent_complete = None
        self.total_bytes_to_download = None
        self.total_bytes_downloaded = None
        self.number_of_updates_to_download = None
        self.number_of_updates_downloaded = None


class UpdateInstallProgress(_serialization.Model):
    """Progress details during installation of updates.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar percent_complete: Percentage completed.
    :vartype percent_complete: int
    :ivar number_of_updates_to_install: Number of updates to install.
    :vartype number_of_updates_to_install: int
    :ivar number_of_updates_installed: Number of updates installed.
    :vartype number_of_updates_installed: int
    """

    _validation = {
        "percent_complete": {"readonly": True},
        "number_of_updates_to_install": {"readonly": True},
        "number_of_updates_installed": {"readonly": True},
    }

    _attribute_map = {
        "percent_complete": {"key": "percentComplete", "type": "int"},
        "number_of_updates_to_install": {"key": "numberOfUpdatesToInstall", "type": "int"},
        "number_of_updates_installed": {"key": "numberOfUpdatesInstalled", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.percent_complete = None
        self.number_of_updates_to_install = None
        self.number_of_updates_installed = None


class UpdateSummary(ARMBaseModel):  # pylint: disable=too-many-instance-attributes
    """Details about ongoing updates and availability of updates on the device.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :ivar device_version_number: The current version of the device in format: 1.2.17312.13.",.
    :vartype device_version_number: str
    :ivar friendly_device_version_name: The current version of the device in text format.
    :vartype friendly_device_version_name: str
    :ivar device_last_scanned_date_time: The last time when a scan was done on the device.
    :vartype device_last_scanned_date_time: ~datetime.datetime
    :ivar last_completed_scan_job_date_time: The time when the last scan job was completed
     (success/cancelled/failed) on the appliance.
    :vartype last_completed_scan_job_date_time: ~datetime.datetime
    :ivar last_completed_download_job_date_time: The time when the last Download job was completed
     (success/cancelled/failed) on the appliance.
    :vartype last_completed_download_job_date_time: ~datetime.datetime
    :ivar last_completed_install_job_date_time: The time when the last Install job was completed
     (success/cancelled/failed) on the appliance.
    :vartype last_completed_install_job_date_time: ~datetime.datetime
    :ivar total_number_of_updates_available: The number of updates available for the current device
     version as per the last device scan.
    :vartype total_number_of_updates_available: int
    :ivar total_number_of_updates_pending_download: The total number of items pending download.
    :vartype total_number_of_updates_pending_download: int
    :ivar total_number_of_updates_pending_install: The total number of items pending install.
    :vartype total_number_of_updates_pending_install: int
    :ivar reboot_behavior: Indicates if updates are available and at least one of the updates needs
     a reboot. Known values are: "NeverReboots", "RequiresReboot", and "RequestReboot".
    :vartype reboot_behavior: str or
     ~azure.mgmt.databoxedge.v2019_03_01.models.InstallRebootBehavior
    :ivar ongoing_update_operation: The current update operation. Known values are: "None", "Scan",
     "Download", and "Install".
    :vartype ongoing_update_operation: str or
     ~azure.mgmt.databoxedge.v2019_03_01.models.UpdateOperation
    :ivar in_progress_download_job_id: The job ID of the download job in progress.
    :vartype in_progress_download_job_id: str
    :ivar in_progress_install_job_id: The job ID of the install job in progress.
    :vartype in_progress_install_job_id: str
    :ivar in_progress_download_job_started_date_time: The time when the currently running download
     (if any) started.
    :vartype in_progress_download_job_started_date_time: ~datetime.datetime
    :ivar in_progress_install_job_started_date_time: The time when the currently running install
     (if any) started.
    :vartype in_progress_install_job_started_date_time: ~datetime.datetime
    :ivar update_titles: The list of updates available for install.
    :vartype update_titles: list[str]
    :ivar total_update_size_in_bytes: The total size of updates available for download in bytes.
    :vartype total_update_size_in_bytes: float
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "last_completed_download_job_date_time": {"readonly": True},
        "last_completed_install_job_date_time": {"readonly": True},
        "total_number_of_updates_available": {"readonly": True},
        "total_number_of_updates_pending_download": {"readonly": True},
        "total_number_of_updates_pending_install": {"readonly": True},
        "reboot_behavior": {"readonly": True},
        "ongoing_update_operation": {"readonly": True},
        "in_progress_download_job_id": {"readonly": True},
        "in_progress_install_job_id": {"readonly": True},
        "in_progress_download_job_started_date_time": {"readonly": True},
        "in_progress_install_job_started_date_time": {"readonly": True},
        "update_titles": {"readonly": True},
        "total_update_size_in_bytes": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "device_version_number": {"key": "properties.deviceVersionNumber", "type": "str"},
        "friendly_device_version_name": {"key": "properties.friendlyDeviceVersionName", "type": "str"},
        "device_last_scanned_date_time": {"key": "properties.deviceLastScannedDateTime", "type": "iso-8601"},
        "last_completed_scan_job_date_time": {"key": "properties.lastCompletedScanJobDateTime", "type": "iso-8601"},
        "last_completed_download_job_date_time": {
            "key": "properties.lastCompletedDownloadJobDateTime",
            "type": "iso-8601",
        },
        "last_completed_install_job_date_time": {
            "key": "properties.lastCompletedInstallJobDateTime",
            "type": "iso-8601",
        },
        "total_number_of_updates_available": {"key": "properties.totalNumberOfUpdatesAvailable", "type": "int"},
        "total_number_of_updates_pending_download": {
            "key": "properties.totalNumberOfUpdatesPendingDownload",
            "type": "int",
        },
        "total_number_of_updates_pending_install": {
            "key": "properties.totalNumberOfUpdatesPendingInstall",
            "type": "int",
        },
        "reboot_behavior": {"key": "properties.rebootBehavior", "type": "str"},
        "ongoing_update_operation": {"key": "properties.ongoingUpdateOperation", "type": "str"},
        "in_progress_download_job_id": {"key": "properties.inProgressDownloadJobId", "type": "str"},
        "in_progress_install_job_id": {"key": "properties.inProgressInstallJobId", "type": "str"},
        "in_progress_download_job_started_date_time": {
            "key": "properties.inProgressDownloadJobStartedDateTime",
            "type": "iso-8601",
        },
        "in_progress_install_job_started_date_time": {
            "key": "properties.inProgressInstallJobStartedDateTime",
            "type": "iso-8601",
        },
        "update_titles": {"key": "properties.updateTitles", "type": "[str]"},
        "total_update_size_in_bytes": {"key": "properties.totalUpdateSizeInBytes", "type": "float"},
    }

    def __init__(
        self,
        *,
        device_version_number: Optional[str] = None,
        friendly_device_version_name: Optional[str] = None,
        device_last_scanned_date_time: Optional[datetime.datetime] = None,
        last_completed_scan_job_date_time: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword device_version_number: The current version of the device in format: 1.2.17312.13.",.
        :paramtype device_version_number: str
        :keyword friendly_device_version_name: The current version of the device in text format.
        :paramtype friendly_device_version_name: str
        :keyword device_last_scanned_date_time: The last time when a scan was done on the device.
        :paramtype device_last_scanned_date_time: ~datetime.datetime
        :keyword last_completed_scan_job_date_time: The time when the last scan job was completed
         (success/cancelled/failed) on the appliance.
        :paramtype last_completed_scan_job_date_time: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.device_version_number = device_version_number
        self.friendly_device_version_name = friendly_device_version_name
        self.device_last_scanned_date_time = device_last_scanned_date_time
        self.last_completed_scan_job_date_time = last_completed_scan_job_date_time
        self.last_completed_download_job_date_time = None
        self.last_completed_install_job_date_time = None
        self.total_number_of_updates_available = None
        self.total_number_of_updates_pending_download = None
        self.total_number_of_updates_pending_install = None
        self.reboot_behavior = None
        self.ongoing_update_operation = None
        self.in_progress_download_job_id = None
        self.in_progress_install_job_id = None
        self.in_progress_download_job_started_date_time = None
        self.in_progress_install_job_started_date_time = None
        self.update_titles = None
        self.total_update_size_in_bytes = None


class UploadCertificateRequest(_serialization.Model):
    """The upload certificate request.

    All required parameters must be populated in order to send to Azure.

    :ivar authentication_type: The authentication type. Known values are: "Invalid" and
     "AzureActiveDirectory".
    :vartype authentication_type: str or
     ~azure.mgmt.databoxedge.v2019_03_01.models.AuthenticationType
    :ivar certificate: The base64 encoded certificate raw data. Required.
    :vartype certificate: str
    """

    _validation = {
        "certificate": {"required": True},
    }

    _attribute_map = {
        "authentication_type": {"key": "properties.authenticationType", "type": "str"},
        "certificate": {"key": "properties.certificate", "type": "str"},
    }

    def __init__(
        self,
        *,
        certificate: str,
        authentication_type: Optional[Union[str, "_models.AuthenticationType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword authentication_type: The authentication type. Known values are: "Invalid" and
         "AzureActiveDirectory".
        :paramtype authentication_type: str or
         ~azure.mgmt.databoxedge.v2019_03_01.models.AuthenticationType
        :keyword certificate: The base64 encoded certificate raw data. Required.
        :paramtype certificate: str
        """
        super().__init__(**kwargs)
        self.authentication_type = authentication_type
        self.certificate = certificate


class UploadCertificateResponse(_serialization.Model):
    """The upload registration certificate response.

    All required parameters must be populated in order to send to Azure.

    :ivar auth_type: Specifies authentication type. Known values are: "Invalid" and
     "AzureActiveDirectory".
    :vartype auth_type: str or ~azure.mgmt.databoxedge.v2019_03_01.models.AuthenticationType
    :ivar resource_id: The resource ID of the Data Box Edge/Gateway device. Required.
    :vartype resource_id: str
    :ivar aad_authority: Azure Active Directory tenant authority. Required.
    :vartype aad_authority: str
    :ivar aad_tenant_id: Azure Active Directory tenant ID. Required.
    :vartype aad_tenant_id: str
    :ivar service_principal_client_id: Azure Active Directory service principal client ID.
     Required.
    :vartype service_principal_client_id: str
    :ivar service_principal_object_id: Azure Active Directory service principal object ID.
     Required.
    :vartype service_principal_object_id: str
    :ivar azure_management_endpoint_audience: The azure management endpoint audience. Required.
    :vartype azure_management_endpoint_audience: str
    """

    _validation = {
        "resource_id": {"required": True},
        "aad_authority": {"required": True},
        "aad_tenant_id": {"required": True},
        "service_principal_client_id": {"required": True},
        "service_principal_object_id": {"required": True},
        "azure_management_endpoint_audience": {"required": True},
    }

    _attribute_map = {
        "auth_type": {"key": "authType", "type": "str"},
        "resource_id": {"key": "resourceId", "type": "str"},
        "aad_authority": {"key": "aadAuthority", "type": "str"},
        "aad_tenant_id": {"key": "aadTenantId", "type": "str"},
        "service_principal_client_id": {"key": "servicePrincipalClientId", "type": "str"},
        "service_principal_object_id": {"key": "servicePrincipalObjectId", "type": "str"},
        "azure_management_endpoint_audience": {"key": "azureManagementEndpointAudience", "type": "str"},
    }

    def __init__(
        self,
        *,
        resource_id: str,
        aad_authority: str,
        aad_tenant_id: str,
        service_principal_client_id: str,
        service_principal_object_id: str,
        azure_management_endpoint_audience: str,
        auth_type: Optional[Union[str, "_models.AuthenticationType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword auth_type: Specifies authentication type. Known values are: "Invalid" and
         "AzureActiveDirectory".
        :paramtype auth_type: str or ~azure.mgmt.databoxedge.v2019_03_01.models.AuthenticationType
        :keyword resource_id: The resource ID of the Data Box Edge/Gateway device. Required.
        :paramtype resource_id: str
        :keyword aad_authority: Azure Active Directory tenant authority. Required.
        :paramtype aad_authority: str
        :keyword aad_tenant_id: Azure Active Directory tenant ID. Required.
        :paramtype aad_tenant_id: str
        :keyword service_principal_client_id: Azure Active Directory service principal client ID.
         Required.
        :paramtype service_principal_client_id: str
        :keyword service_principal_object_id: Azure Active Directory service principal object ID.
         Required.
        :paramtype service_principal_object_id: str
        :keyword azure_management_endpoint_audience: The azure management endpoint audience. Required.
        :paramtype azure_management_endpoint_audience: str
        """
        super().__init__(**kwargs)
        self.auth_type = auth_type
        self.resource_id = resource_id
        self.aad_authority = aad_authority
        self.aad_tenant_id = aad_tenant_id
        self.service_principal_client_id = service_principal_client_id
        self.service_principal_object_id = service_principal_object_id
        self.azure_management_endpoint_audience = azure_management_endpoint_audience


class User(ARMBaseModel):
    """Represents a user who has access to one or more shares on the Data Box Edge/Gateway device.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :ivar encrypted_password: The password details.
    :vartype encrypted_password:
     ~azure.mgmt.databoxedge.v2019_03_01.models.AsymmetricEncryptedSecret
    :ivar share_access_rights: List of shares that the user has rights on. This field should not be
     specified during user creation.
    :vartype share_access_rights: list[~azure.mgmt.databoxedge.v2019_03_01.models.ShareAccessRight]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "encrypted_password": {"key": "properties.encryptedPassword", "type": "AsymmetricEncryptedSecret"},
        "share_access_rights": {"key": "properties.shareAccessRights", "type": "[ShareAccessRight]"},
    }

    def __init__(
        self,
        *,
        encrypted_password: Optional["_models.AsymmetricEncryptedSecret"] = None,
        share_access_rights: Optional[List["_models.ShareAccessRight"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword encrypted_password: The password details.
        :paramtype encrypted_password:
         ~azure.mgmt.databoxedge.v2019_03_01.models.AsymmetricEncryptedSecret
        :keyword share_access_rights: List of shares that the user has rights on. This field should not
         be specified during user creation.
        :paramtype share_access_rights:
         list[~azure.mgmt.databoxedge.v2019_03_01.models.ShareAccessRight]
        """
        super().__init__(**kwargs)
        self.encrypted_password = encrypted_password
        self.share_access_rights = share_access_rights


class UserAccessRight(_serialization.Model):
    """The mapping between a particular user and the access type on the SMB share.

    All required parameters must be populated in order to send to Azure.

    :ivar user_id: User ID (already existing in the device). Required.
    :vartype user_id: str
    :ivar access_type: Type of access to be allowed for the user. Required. Known values are:
     "Change", "Read", and "Custom".
    :vartype access_type: str or ~azure.mgmt.databoxedge.v2019_03_01.models.ShareAccessType
    """

    _validation = {
        "user_id": {"required": True},
        "access_type": {"required": True},
    }

    _attribute_map = {
        "user_id": {"key": "userId", "type": "str"},
        "access_type": {"key": "accessType", "type": "str"},
    }

    def __init__(self, *, user_id: str, access_type: Union[str, "_models.ShareAccessType"], **kwargs: Any) -> None:
        """
        :keyword user_id: User ID (already existing in the device). Required.
        :paramtype user_id: str
        :keyword access_type: Type of access to be allowed for the user. Required. Known values are:
         "Change", "Read", and "Custom".
        :paramtype access_type: str or ~azure.mgmt.databoxedge.v2019_03_01.models.ShareAccessType
        """
        super().__init__(**kwargs)
        self.user_id = user_id
        self.access_type = access_type


class UserList(_serialization.Model):
    """Collection of users.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of users.
    :vartype value: list[~azure.mgmt.databoxedge.v2019_03_01.models.User]
    :ivar next_link: Link to the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[User]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None
