# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential
from azure.mgmt.managednetworkfabric import ManagedNetworkFabricMgmtClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-managednetworkfabric
# USAGE
    python network_fabrics_create_maximum_set_gen.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = ManagedNetworkFabricMgmtClient(
        credential=DefaultAzureCredential(),
        subscription_id="subscriptionId",
    )

    response = client.network_fabrics.begin_create(
        resource_group_name="resourceGroupName",
        network_fabric_name="FabricName",
        body={
            "location": "eastuseuap",
            "properties": {
                "annotation": "annotationValue",
                "fabricASN": 29249,
                "ipv4Prefix": "10.18.0.0/19",
                "ipv6Prefix": "3FFE:FFFF:0:CD40::/59",
                "managementNetworkConfiguration": {
                    "infrastructureVpnConfiguration": {
                        "optionAProperties": {
                            "mtu": 5892,
                            "peerASN": 42666,
                            "primaryIpv4Prefix": "20.0.0.12/30",
                            "primaryIpv6Prefix": "3FFE:FFFF:0:CD30::a8/126",
                            "secondaryIpv4Prefix": "20.0.0.13/30",
                            "secondaryIpv6Prefix": "3FFE:FFFF:0:CD30::ac/126",
                            "vlanId": 2724,
                        },
                        "optionBProperties": {
                            "exportRouteTargets": ["65046:10039"],
                            "importRouteTargets": ["65046:10039"],
                        },
                        "peeringOption": "OptionA",
                    },
                    "workloadVpnConfiguration": {
                        "optionAProperties": {
                            "mtu": 5892,
                            "peerASN": 42666,
                            "primaryIpv4Prefix": "10.0.0.14/30",
                            "primaryIpv6Prefix": "2FFE:FFFF:0:CD30::a7/126",
                            "secondaryIpv4Prefix": "10.0.0.15/30",
                            "secondaryIpv6Prefix": "2FFE:FFFF:0:CD30::ac/126",
                            "vlanId": 2724,
                        },
                        "optionBProperties": {
                            "exportRouteTargets": ["65046:10050"],
                            "importRouteTargets": ["65046:10050"],
                        },
                        "peeringOption": "OptionA",
                    },
                },
                "networkFabricControllerId": "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/networkFabricControllers/fabricControllerName",
                "networkFabricSku": "M4-A400-A100-C16-aa",
                "rackCount": 4,
                "serverCountPerRack": 8,
                "terminalServerConfiguration": {
                    "password": "xxxx",
                    "primaryIpv4Prefix": "20.0.0.12/30",
                    "primaryIpv6Prefix": "3FFE:FFFF:0:CD30::a8/126",
                    "secondaryIpv4Prefix": "20.0.0.13/30",
                    "secondaryIpv6Prefix": "3FFE:FFFF:0:CD30::ac/126",
                    "serialNumber": "123456",
                    "username": "username",
                },
            },
            "tags": {"key6468": ""},
        },
    ).result()
    print(response)


# x-ms-original-file: specification/managednetworkfabric/resource-manager/Microsoft.ManagedNetworkFabric/preview/2023-02-01-preview/examples/NetworkFabrics_Create_MaximumSet_Gen.json
if __name__ == "__main__":
    main()
