# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.oracledatabase import OracleDatabaseMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestOracleDatabaseMgmtDbSystemsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(OracleDatabaseMgmtClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_db_systems_list_by_subscription(self, resource_group):
        response = self.client.db_systems.list_by_subscription()
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_db_systems_begin_create_or_update(self, resource_group):
        response = self.client.db_systems.begin_create_or_update(
            resource_group_name=resource_group.name,
            db_system_name="str",
            resource={
                "location": "str",
                "id": "str",
                "name": "str",
                "properties": {
                    "databaseEdition": "str",
                    "dbVersion": "str",
                    "hostname": "str",
                    "networkAnchorId": "str",
                    "resourceAnchorId": "str",
                    "shape": "str",
                    "source": "None",
                    "sshPublicKeys": ["str"],
                    "adminPassword": "str",
                    "clusterName": "str",
                    "computeCount": 0,
                    "computeModel": "str",
                    "dataStorageSizeInGbs": 0,
                    "dbSystemOptions": {"storageManagement": "str"},
                    "diskRedundancy": "str",
                    "displayName": "str",
                    "domain": "str",
                    "gridImageOcid": "str",
                    "initialDataStorageSizeInGb": 0,
                    "licenseModel": "str",
                    "lifecycleDetails": "str",
                    "lifecycleState": "str",
                    "listenerPort": 0,
                    "memorySizeInGbs": 0,
                    "nodeCount": 0,
                    "ociUrl": "str",
                    "ocid": "str",
                    "pdbName": "str",
                    "provisioningState": "str",
                    "scanDnsName": "str",
                    "scanIps": ["str"],
                    "storageVolumePerformanceMode": "str",
                    "timeZone": "str",
                    "version": "str",
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
                "zones": ["str"],
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_db_systems_get(self, resource_group):
        response = self.client.db_systems.get(
            resource_group_name=resource_group.name,
            db_system_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_db_systems_begin_update(self, resource_group):
        response = self.client.db_systems.begin_update(
            resource_group_name=resource_group.name,
            db_system_name="str",
            properties={"properties": {"source": "str"}, "tags": {"str": "str"}, "zones": ["str"]},
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_db_systems_begin_delete(self, resource_group):
        response = self.client.db_systems.begin_delete(
            resource_group_name=resource_group.name,
            db_system_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_db_systems_list_by_resource_group(self, resource_group):
        response = self.client.db_systems.list_by_resource_group(
            resource_group_name=resource_group.name,
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
