;;; py-ert-execute-region-test.el --- py-execute-region tests

;; Copyright (C) 2015  Andreas Roehler
;; Author: Andreas Roehler <andreas.roehler@online.de>
;; Keywords: languages, convenience

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or
;; (at your option) any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program.  If not, see <http://www.gnu.org/licenses/>.

;;; Commentary:

;; This file is generated by function from python-mode-utils.el - see in
;; directory devel. Edits here might not be persistent.

;;; Code:

(ert-deftest py-ert-execute-region-python-test ()
  (let ((buffer (py--choose-buffer-name "python")))
    (py-test-with-temp-buffer
        "
    print(\"one\")
    print(\"two\")"
      (py-execute-region-python (point-min) (point-max))
      (sit-for 0.5 t)
      (set-buffer buffer)
      (should (search-backward "two")))))

(ert-deftest py-ert-execute-region-python2-test ()
  (let ((buffer (py--choose-buffer-name "python2")))
    (py-test-with-temp-buffer
        "
    print(\"one\")
    print(\"two\")"
      (py-execute-region-python2 (point-min) (point-max))
      (sit-for 0.5 t)
      (set-buffer buffer)
      (should (search-backward "two")))))

(ert-deftest py-ert-execute-region-python3-test ()
  (let ((buffer (py--choose-buffer-name "python3")))
    (py-test-with-temp-buffer
        "
    print(\"one\")
    print(\"two\")"
      (py-execute-region-python3 (point-min) (point-max))
      (sit-for 0.5 t)
      (set-buffer buffer)
      (should (search-backward "two")))))

(ert-deftest py-ert-execute-region-ipython-test ()
  (let ((buffer (py--choose-buffer-name "ipython")))
    (py-test-with-temp-buffer
        "
    print(\"one\")
    print(\"two\")"
      (py-execute-region-ipython (point-min) (point-max))
      (sit-for 0.5 t)
      (set-buffer buffer)
      (should (search-backward "two")))))

(ert-deftest py-ert-execute-region-ipython3-test ()
  (let ((buffer (py--choose-buffer-name "ipython3")))
    (py-test-with-temp-buffer
        "
    print(\"one\")
    print(\"two\")"
      (py-execute-region-ipython3 (point-min) (point-max))
      (sit-for 0.5 t)
      (set-buffer buffer)
      (should (search-backward "two")))))

(ert-deftest py-ert-execute-region-jython-test ()
  (let ((buffer (py--choose-buffer-name "jython")))
    (py-test-with-temp-buffer
        "
    print(\"one\")
    print(\"two\")"
      (py-execute-region-jython (point-min) (point-max))
      (sit-for 0.5 t)
      (set-buffer buffer)
      (should (search-backward "two")))))



(provide 'py-ert-execute-region-test)
;;; py-ert-execute-region-test.el here
 
