# PySNMP SMI module. Autogenerated from smidump -f python INET-ADDRESS-MIB
# by libsmi2pysnmp-0.1.3 at Mon Apr  2 20:39:09 2012,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ConstraintsIntersection, ConstraintsUnion, SingleValueConstraint, ValueRangeConstraint, ValueSizeConstraint, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ConstraintsIntersection", "ConstraintsUnion", "SingleValueConstraint", "ValueRangeConstraint", "ValueSizeConstraint")
( Bits, Integer32, ModuleIdentity, MibIdentifier, TimeTicks, Unsigned32, mib_2, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Integer32", "ModuleIdentity", "MibIdentifier", "TimeTicks", "Unsigned32", "mib-2")
( TextualConvention, ) = mibBuilder.importSymbols("SNMPv2-TC", "TextualConvention")

# Types

class InetAddress(OctetString):
    subtypeSpec = OctetString.subtypeSpec+ValueSizeConstraint(0,255)
    
class InetAddressDNS(TextualConvention, OctetString):
    displayHint = "255a"
    subtypeSpec = OctetString.subtypeSpec+ValueSizeConstraint(1,255)
    
class InetAddressIPv4(TextualConvention, OctetString):
    displayHint = "1d.1d.1d.1d"
    subtypeSpec = OctetString.subtypeSpec+ValueSizeConstraint(4,4)
    fixedLength = 4
    
class InetAddressIPv4z(TextualConvention, OctetString):
    displayHint = "1d.1d.1d.1d%4d"
    subtypeSpec = OctetString.subtypeSpec+ValueSizeConstraint(8,8)
    fixedLength = 8
    
class InetAddressIPv6(TextualConvention, OctetString):
    displayHint = "2x:2x:2x:2x:2x:2x:2x:2x"
    subtypeSpec = OctetString.subtypeSpec+ValueSizeConstraint(16,16)
    fixedLength = 16
    
class InetAddressIPv6z(TextualConvention, OctetString):
    displayHint = "2x:2x:2x:2x:2x:2x:2x:2x%4d"
    subtypeSpec = OctetString.subtypeSpec+ValueSizeConstraint(20,20)
    fixedLength = 20
    
class InetAddressPrefixLength(TextualConvention, Unsigned32):
    displayHint = "d"
    subtypeSpec = Unsigned32.subtypeSpec+ValueRangeConstraint(0,2040)
    
class InetAddressType(Integer):
    subtypeSpec = Integer.subtypeSpec+SingleValueConstraint(16,1,4,0,2,3,)
    namedValues = NamedValues(("unknown", 0), ("ipv4", 1), ("dns", 16), ("ipv6", 2), ("ipv4z", 3), ("ipv6z", 4), )
    
class InetAutonomousSystemNumber(TextualConvention, Unsigned32):
    displayHint = "d"
    
class InetPortNumber(TextualConvention, Unsigned32):
    displayHint = "d"
    subtypeSpec = Unsigned32.subtypeSpec+ValueRangeConstraint(0,65535)
    
class InetScopeType(Integer):
    subtypeSpec = Integer.subtypeSpec+SingleValueConstraint(2,4,14,3,5,1,8,)
    namedValues = NamedValues(("interfaceLocal", 1), ("global", 14), ("linkLocal", 2), ("subnetLocal", 3), ("adminLocal", 4), ("siteLocal", 5), ("organizationLocal", 8), )
    
class InetVersion(Integer):
    subtypeSpec = Integer.subtypeSpec+SingleValueConstraint(0,1,2,)
    namedValues = NamedValues(("unknown", 0), ("ipv4", 1), ("ipv6", 2), )
    
class InetZoneIndex(TextualConvention, Unsigned32):
    displayHint = "d"
    

# Objects

inetAddressMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 76)).setRevisions(("2005-02-04 00:00","2002-05-09 00:00","2000-06-08 00:00",))
if mibBuilder.loadTexts: inetAddressMIB.setOrganization("IETF Operations and Management Area")
if mibBuilder.loadTexts: inetAddressMIB.setContactInfo("Juergen Schoenwaelder (Editor)\nInternational University Bremen\nP.O. Box 750 561\n28725 Bremen, Germany\n\nPhone: +49 421 200-3587\nEMail: j.schoenwaelder@iu-bremen.de\n\nSend comments to <ietfmibs@ops.ietf.org>.")
if mibBuilder.loadTexts: inetAddressMIB.setDescription("This MIB module defines textual conventions for\nrepresenting Internet addresses.  An Internet\naddress can be an IPv4 address, an IPv6 address,\nor a DNS domain name.  This module also defines\ntextual conventions for Internet port numbers,\nautonomous system numbers, and the length of an\nInternet address prefix.\n\nCopyright (C) The Internet Society (2005).  This version\nof this MIB module is part of RFC 4001, see the RFC\nitself for full legal notices.")

# Augmentions

# Exports

# Module identity
mibBuilder.exportSymbols("INET-ADDRESS-MIB", PYSNMP_MODULE_ID=inetAddressMIB)

# Types
mibBuilder.exportSymbols("INET-ADDRESS-MIB", InetAddress=InetAddress, InetAddressDNS=InetAddressDNS, InetAddressIPv4=InetAddressIPv4, InetAddressIPv4z=InetAddressIPv4z, InetAddressIPv6=InetAddressIPv6, InetAddressIPv6z=InetAddressIPv6z, InetAddressPrefixLength=InetAddressPrefixLength, InetAddressType=InetAddressType, InetAutonomousSystemNumber=InetAutonomousSystemNumber, InetPortNumber=InetPortNumber, InetScopeType=InetScopeType, InetVersion=InetVersion, InetZoneIndex=InetZoneIndex)

# Objects
mibBuilder.exportSymbols("INET-ADDRESS-MIB", inetAddressMIB=inetAddressMIB)

