# PySNMP SMI module. Autogenerated from smidump -f python T11-FC-ZONE-SERVER-MIB
# by libsmi2pysnmp-0.1.3 at Mon Apr  2 20:39:43 2012,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ConstraintsIntersection, ConstraintsUnion, SingleValueConstraint, ValueRangeConstraint, ValueSizeConstraint, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ConstraintsIntersection", "ConstraintsUnion", "SingleValueConstraint", "ValueRangeConstraint", "ValueSizeConstraint")
( FcDomainIdOrZero, FcNameIdOrZero, fcmInstanceIndex, fcmSwitchIndex, ) = mibBuilder.importSymbols("FC-MGMT-MIB", "FcDomainIdOrZero", "FcNameIdOrZero", "fcmInstanceIndex", "fcmSwitchIndex")
( ifIndex, ) = mibBuilder.importSymbols("IF-MIB", "ifIndex")
( SnmpAdminString, ) = mibBuilder.importSymbols("SNMP-FRAMEWORK-MIB", "SnmpAdminString")
( ModuleCompliance, NotificationGroup, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "NotificationGroup", "ObjectGroup")
( Bits, Counter32, Integer32, ModuleIdentity, MibIdentifier, NotificationType, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, Unsigned32, mib_2, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Integer32", "ModuleIdentity", "MibIdentifier", "NotificationType", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "Unsigned32", "mib-2")
( RowStatus, StorageType, TextualConvention, TimeStamp, TruthValue, ) = mibBuilder.importSymbols("SNMPv2-TC", "RowStatus", "StorageType", "TextualConvention", "TimeStamp", "TruthValue")
( t11FamLocalSwitchWwn, ) = mibBuilder.importSymbols("T11-FC-FABRIC-ADDR-MGR-MIB", "t11FamLocalSwitchWwn")
( T11NsGs4RejectReasonCode, ) = mibBuilder.importSymbols("T11-FC-NAME-SERVER-MIB", "T11NsGs4RejectReasonCode")
( T11FabricIndex, ) = mibBuilder.importSymbols("T11-TC-MIB", "T11FabricIndex")

# Types

class T11ZoningName(OctetString):
    subtypeSpec = OctetString.subtypeSpec+ValueSizeConstraint(1,64)
    
class T11ZsRejectReasonExplanation(Integer):
    subtypeSpec = Integer.subtypeSpec+SingleValueConstraint(11,19,31,22,24,9,2,27,29,14,13,6,25,16,3,28,30,5,7,15,18,17,10,23,1,21,26,4,12,8,20,)
    namedValues = NamedValues(("other", 1), ("deactivateZoneSetFailed", 10), ("reqNotSupported", 11), ("capabilityNotSupported", 12), ("zoneMemberIDTypeNotSupp", 13), ("invalidZoneSetDefinition", 14), ("enhancedZoningCmdsNotSupported", 15), ("zoneSetExists", 16), ("zoneExists", 17), ("aliasExists", 18), ("zoneSetUnknown", 19), ("noAdditionalExplanation", 2), ("zoneUnknown", 20), ("aliasUnknown", 21), ("zoneAliasTypeUnknown", 22), ("unableEnhancedMode", 23), ("basicZoningCmdsNotSupported", 24), ("zoneAttribObjectExists", 25), ("zoneAttribObjectUnknown", 26), ("requestInProcess", 27), ("cmitInProcess", 28), ("hardEnforcementFailed", 29), ("zonesNotSupported", 3), ("unresolvedReferences", 30), ("consistencyChecksFailed", 31), ("zoneSetNameUnknown", 4), ("noZoneSetActive", 5), ("zoneNameUnknown", 6), ("zoneStateUnknown", 7), ("incorrectPayloadLen", 8), ("tooLargeZoneSet", 9), )
    
class T11ZsZoneMemberType(TextualConvention, Unsigned32):
    displayHint = "x"
    subtypeSpec = Unsigned32.subtypeSpec+ValueRangeConstraint(0,255)
    

# Objects

t11ZoneServerMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 160)).setRevisions(("2007-06-27 00:00",))
if mibBuilder.loadTexts: t11ZoneServerMIB.setOrganization("For the initial versions, T11.\nFor later versions, the IETF's IMSS Working Group.")
if mibBuilder.loadTexts: t11ZoneServerMIB.setContactInfo("     Claudio DeSanti\nCisco Systems, Inc.\n170 West Tasman Drive\nSan Jose, CA 95134 USA\nEMail: cds@cisco.com\n\nKeith McCloghrie\nCisco Systems, Inc.\n170 West Tasman Drive\nSan Jose, CA 95134 USA\nEMail: kzm@cisco.com")
if mibBuilder.loadTexts: t11ZoneServerMIB.setDescription("The MIB module for the management of Fibre Channel Zoning\nServers, both for Basic Zoning Management and for Enhanced\n\n\nZoning Management, as defined in the FC-GS-5 specification.\n\nFC-GS-5 defines (in-band) management operations for\nmanipulating the Zone Set Database, some for use in Basic\nmode (e.g., 'Add Zone Set (AZS)', etc.), and some for use in\nEnhanced mode (e.g., Create Zone Set (CZS)', etc.).  When\nEnhanced Zoning Management is in use, FC-GS-5 requires that\nthese in-band management operations be rejected unless they\nare issued within the context of a GS-5 server session.  The\nuse of a server session ensures serialized access to the\nZoning Database since the Fabric lock for the Zone Server\nmust be obtained as a part of establishing the server\nsession to the Zone Server.\n\nThus, if and when this MIB is used for Enhanced Zoning\nManagement, SNMP SetRequests that request the modification\nof zoning definitions must be serialized with respect to\nthe GS-5 requests to modify the Zoning Database.  This is\nachieved by requiring that an SNMP management application\nmust first obtain the Fabric lock for the Zone Server\nbefore attempting to modify any zoning definitions.  The\ncompanion T11-FC-FABRIC-LOCK-MIB module is defined as a means\nof obtaining the Fabric lock for the Zone Server (or any\nother server).\n\nIn Enhanced Zoning Management, a Zone Server keeps track of\nchanges requested in the zoning definitions, but does not\nupdate its Zone Set Database unless there is (and until\nthere is) a 'commit' operation.  To model this behavior,\nthis MIB module assumes that a Zone Server (in Enhanced\nmode) takes a snapshot of its Zone Set Database as and when\nthe Fabric lock (for the Zone Server application) is\nobtained; this snapshot is used to create what is herein\ncalled the 'copy' database.  It is this 'copy' database\nthat is then updated by SNMP SetRequests (while the Fabric\nis locked).  If and when a 'commit' operation is requested\n(while the Fabric is still locked), the 'copy' database is\nthen used to overwrite the previously committed contents of\nthe Zone Set Database, and the new Zone Set Database is\ndistributed to all other switches in the Fabric.  When the\nlock is released, any changes made that were not\n'committed' are discarded.\n\nWhen this MIB is used for Basic Zoning Management, the same\nset of MIB objects as used for Enhanced mode are used to\nmake changes to the Database of a Zone Server on a\nparticular switch, but the changes take immediate effect at\nthat switch without an explicit commit.  The distribution of\n\n\n\nthose changes to Zone Servers on other switches in the\nFabric is subsequently requested through the use of a\nseparate set of MIB objects.\n\nThe management information specified in this MIB module\nincludes the Zoning Database for each of one or more Fibre\nChannel Fabrics.  A Zoning Database is a combination of the\nFabric's Zone Set Database and its Active Zone Set.  The\nActive Zone Set is the Zone Set currently enforced by the\nFabric; a Zone Set Database is a database of the Zone Sets\navailable to be activated within a Fabric.  All the MIB\nobjects representing a Zone Set Database are modifiable at\nany time (irrespective of the value of any RowStatus\nobject), whereas all objects representing the Active Zone\nSet are always read-only (except to deactivate it and/or\nactivate a different one).\n\nCopyright (C) The IETF Trust (2007).  This version\nof this MIB module is part of RFC 4936;  see the RFC\nitself for full legal notices.")
t11ZsMIBNotifications = MibIdentifier((1, 3, 6, 1, 2, 1, 160, 0))
t11ZsMIBObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 160, 1))
t11ZsConfiguration = MibIdentifier((1, 3, 6, 1, 2, 1, 160, 1, 1))
t11ZsServerTable = MibTable((1, 3, 6, 1, 2, 1, 160, 1, 1, 1))
if mibBuilder.loadTexts: t11ZsServerTable.setDescription("A table containing information about the Zone Servers\non each Fabric in one or more switches, and providing\nthe capability to perform operations on their Zone\nServer databases.")
t11ZsServerEntry = MibTableRow((1, 3, 6, 1, 2, 1, 160, 1, 1, 1, 1)).setIndexNames((0, "FC-MGMT-MIB", "fcmInstanceIndex"), (0, "FC-MGMT-MIB", "fcmSwitchIndex"), (0, "T11-FC-ZONE-SERVER-MIB", "t11ZsServerFabricIndex"))
if mibBuilder.loadTexts: t11ZsServerEntry.setDescription("Each entry contains information specific to a\nZone Server for a particular Fabric (identified by\nthe value of t11ZsServerFabricIndex) on a particular\nswitch (identified by values of fcmInstanceIndex\nand fcmSwitchIndex).\n\nThe persistence across reboots of writable values in\na row of this table is given by the instance of\nt11ZsServerDatabaseStorageType in that row.")
t11ZsServerFabricIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 1, 1, 1), T11FabricIndex()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: t11ZsServerFabricIndex.setDescription("A unique index value that uniquely identifies a\nparticular Fabric.")
t11ZsServerCapabilityObject = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 1, 1, 2), Bits().subtype(namedValues=NamedValues(("enhancedMode", 0), ("zoneSetDb", 1), ("activateDirect", 2), ("hardZoning", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: t11ZsServerCapabilityObject.setDescription("This bitmap represents the capability of the switch\non this Fabric:\n\n    'enhancedMode' - able to support enhanced Zoning\n                     mode of operation.\n\n    'zoneSetDb'    - able to support maintaining of\n                     a Zone Set Database.\n\n    'activateDirect' - able to support the Activate\n                       Direct command.\n\n    'hardZoning'   - able to support Hard Zoning.")
t11ZsServerDatabaseStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 1, 1, 3), StorageType().clone('nonVolatile')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: t11ZsServerDatabaseStorageType.setDescription("This object specifies the memory realization, on a\nparticular switch, of the Zone Set database for a\nparticular Fabric.  Specifically, each row in the\nfollowing tables:\n\n           t11ZsSetTable\n           t11ZsZoneTable\n           t11ZsSetZoneTable\n           t11ZsAliasTable\n           t11ZsZoneMemberTable\n           t11ZsAttribBlockTable\n           t11ZsAttribTable\n\nhas a StorageType as specified by the instance of\nthis object that is INDEXed by the same values of\nfcmInstanceIndex, fcmSwitchIndex, and\n\n\nt11ZsServerFabricIndex.\n\nThe value of this object is also used to indicate\nthe persistence across reboots of writable values in\nits row of the t11ZsServerTable, as well as the\ncorresponding row in the t11ZsNotifyControlTable.\n\nIf an instance of this object has the value\n'permanent(4)', the Zone Set database for the given\nFabric on the given switch is not required to be\nwriteable.")
t11ZsServerDistribute = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 1, 1, 4), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,)).subtype(namedValues=NamedValues(("noop", 1), ("zoneSetDb", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: t11ZsServerDistribute.setDescription("This object can be set only in Basic mode.  When set\nto the value 'zoneSetDb', it requests that the Zone Set\ndatabase of a particular switch for a particular Fabric\nbe distributed to every other switch in that Fabric,\ne.g., by using Stage Fabric Configuration Update (SFC)\nand Update Fabric Configuration (UFC) requests.\n\nSetting this object to 'noop' has no effect.\nWhen read, the value of this object is always 'noop'.\n\nWhen the corresponding instance of t11ZsServerOperationMode\nhas the value 'enhanced', or when the corresponding instance\nof t11ZsZoneSetResult has the value 'inProgress', it\nis inconsistent to try to set the value of this object.")
t11ZsServerCommit = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 1, 1, 5), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,)).subtype(namedValues=NamedValues(("commitZoneChanges", 1), ("noop", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: t11ZsServerCommit.setDescription("This object is only used in Enhanced mode.\n\nIn Enhanced mode, it can only be modified when the Fabric\nlock for the Zone Server on the particular Fabric has been\nobtained for use by SNMP SetRequests, and even then, only\nby the SNMP entity identified by the value of corresponding\ninstance of t11FLockInitiator.\n\nSetting the object requests an action:\n\n  commitZoneChanges - requests that the changes made\n                      within this session to the Zone\n                      Set Database be committed.\n  noop              - requests nothing.\n\nWhen read, the value is always 'noop'.")
t11ZsServerResult = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 1, 1, 6), Integer().subtype(subtypeSpec=SingleValueConstraint(1,3,4,2,5,)).subtype(namedValues=NamedValues(("none", 1), ("inProgress", 2), ("success", 3), ("rejectFailure", 4), ("otherFailure", 5), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: t11ZsServerResult.setDescription("In Basic mode, this object indicates the status/result\nof the last distribution of the Zone Set database that\nwas invoked via the corresponding instance of\nt11ZsZoneSetDistribute, e.g., the status/result of\nStage Fabric Configuration Update (SFC) request(s) used\nto implement the setting of t11ZsZoneSetDistribute.\n\nIn Enhanced mode, this object indicates the status/result\nof the last commit of changes to the Zone Set database\nthat was invoked via the corresponding instance of\nt11ZsServerCommit.\n\n  'none'          - no distribution/commit invoked\n                    via the corresponding instance of\n                    t11ZsZoneSetDistribute (Basic mode)\n\n\n                    or t11ZsServerCommit (Enhanced mode).\n  'inProgress'    - distribution/commit is still in\n                    progress.\n  'success'       - distribution/commit completed\n                    successfully.\n  'rejectFailure' - distribution/commit failed due to\n                    an SW_RJT.\n  'otherFailure'  - distribution/commit failed for some\n                    other reason.\n\nWhen the value is 'rejectFailure', the corresponding\ninstances of t11ZsServerReasonCode,\nt11ZsServerReasonCodeExp and t11ZsServerReasonVendorCode\ncontain the reason codes. ")
t11ZsServerReasonCode = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 1, 1, 7), T11NsGs4RejectReasonCode()).setMaxAccess("readonly")
if mibBuilder.loadTexts: t11ZsServerReasonCode.setDescription("When the corresponding instance of t11ZsZoneSetResult\nhas the value 'rejectFailure', this object contains\nthe rejection's reason code.\n\nWhen the corresponding instance of t11ZsServerResult\nhas a value other than 'rejectFailure', this object\nshould contain the value 'none'.")
t11ZsServerReasonCodeExp = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 1, 1, 8), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 1))).setMaxAccess("readonly")
if mibBuilder.loadTexts: t11ZsServerReasonCodeExp.setDescription("When the corresponding instance of t11ZsZoneSetResult\nhas the value 'rejectFailure', this object contains\nthe rejection's reason code explanation.\n\nWhen the corresponding instance of t11ZsServerResult\nhas a value other than 'rejectFailure', this object\n\n\n\nshould contain the zero-length string.")
t11ZsServerReasonVendorCode = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 1, 1, 9), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 1))).setMaxAccess("readonly")
if mibBuilder.loadTexts: t11ZsServerReasonVendorCode.setDescription("When the corresponding instance of t11ZsZoneSetResult\nhas the value 'rejectFailure', this object contains\nthe rejection's reason vendor-specific code.\n\nWhen the corresponding instance of t11ZsServerResult\nhas a value other than 'rejectFailure', this object\nshould contain the zero-length string.")
t11ZsServerLastChange = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 1, 1, 10), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: t11ZsServerLastChange.setDescription("The value of sysUpTime at the time of the last change\n(creation, modification, or deletion) to the Zone Set\ndatabase for the Zone Server for a particular Fabric.\nIf said Zone Set database has not changed since the\nlast re-initialization of the local network management\nsystem, then this object will contain a zero value.")
t11ZsServerHardZoning = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 1, 1, 11), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: t11ZsServerHardZoning.setDescription("This object indicates whether this switch, if and when it\nis in Basic mode, enforces Hard Zoning on this Fabric.")
t11ZsServerReadFromDatabase = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 1, 1, 12), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("committedDB", 1), ("copyDB", 2), )).clone(1)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: t11ZsServerReadFromDatabase.setDescription("In Enhanced mode, this object specifies whether\nsubsequent SNMP Responses (generated by the local SNMP\nagent) to operations that read the configuration of\nZone Sets, Zones, Members, Aliases and Attributes will\nreflect the values stored in the current (committed)\nZone Set database, or those stored in the 'copy'\ndatabase.\n\nIn Basic mode, the value of this object is always\n'committedDB' (since there is no 'copy' database in\nBasic mode).  In SNMP agents that don't support\nwrite access to the Zone Set database, this object\nis always 'committedDB' (since the copy database,\nif it were to exist, would be identical).")
t11ZsServerOperationMode = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 1, 1, 13), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,)).subtype(namedValues=NamedValues(("basic", 1), ("enhanced", 2), )).clone(1)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: t11ZsServerOperationMode.setDescription("The operational mode of the Zone Server.\n\nSetting this object to 'enhanced' is a request that the mode\nof operation of the Zone Server be Enhanced mode, which is\nonly possible if all devices in the Fibre Channel Fabric are\ncapable of working in Enhanced mode.  If not, the request\nwill fail and the corresponding value of\nt11ZsServerChangeModeResult will so indicate.\n\nSetting this object to 'basic' is a request that the mode\nof operation of the Zone Server be Basic mode.  However,\nsuch a set may fail while operating in Enhanced mode,\nsince FC-GS-5 makes no provision for changing (back)\n\n\n\nto Basic mode.\n\nNote that setting this object does not cause or require\nthat the Fabric lock for the Zone Server be obtained.\nHowever, when this object has the value 'enhanced', any SNMP\nSetRequests that attempt to modify the copy database cannot\nbe successful if the Fabric lock has not been obtained\nor has since been released.")
t11ZsServerChangeModeResult = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 1, 1, 14), Integer().subtype(subtypeSpec=SingleValueConstraint(2,3,4,1,)).subtype(namedValues=NamedValues(("success", 1), ("failure", 2), ("inProgress", 3), ("none", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: t11ZsServerChangeModeResult.setDescription("When this object has the value of 'success' or\n'failure', the value indicates the outcome of the most\nrecent request, invoked via t11ZsServerOperationMode,\nto change the mode of operation of the Zone Server.\nWhen such a request is in progress, this object has the\nvalue 'inProgress'.  Prior to the first such request,\nthe value of this object is 'none'.")
t11ZsServerDefaultZoneSetting = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 1, 1, 15), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("permit", 1), ("deny", 2), )).clone(2)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: t11ZsServerDefaultZoneSetting.setDescription("This object controls the Enhanced Zoning flag that\ngoverns the behavior of the Default Zone on this Fabric.\n\nIf this object is set to 'permit', then the members of\nthe Default Zone on this Fabric can communicate with\neach other.\n\n\n\n\nIf this object is set to 'deny', then the members of the\nDefault Zone on this Fabric cannot communicate with each\nother.")
t11ZsServerMergeControlSetting = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 1, 1, 16), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("allow", 1), ("restrict", 2), )).clone(1)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: t11ZsServerMergeControlSetting.setDescription("This object controls the Enhanced Zoning flag that\nindicates the Merge Control Setting for this Fabric:\n\n    'allow'    - a switch may join the Fabric only if\n                 its Zoning Database is able to merge\n                 with the Fabric's Zoning Database.\n    'restrict' - a switch may join the Fabric only if\n                 its Zoning Database is equal to the\n                 Fabric's Zoning Database.")
t11ZsServerDefZoneBroadcast = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 1, 1, 17), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: t11ZsServerDefZoneBroadcast.setDescription("This object controls an Enhanced Zoning capability:\nit indicates whether Broadcast Zoning is enabled on\nthe Default Zone on this Fabric.  If this object is\nset to 'true', then it is enabled.  If this object is\nset to 'false', then it is disabled.\n\nIf broadcast Zoning is enabled on a Default Zone,\nthen broadcast frames generated by a member in that\nDefault Zone will be restricted to members in that\nDefault Zone.")
t11ZsSetTable = MibTable((1, 3, 6, 1, 2, 1, 160, 1, 1, 2))
if mibBuilder.loadTexts: t11ZsSetTable.setDescription("A table containing information on every Zone\nSet in the Zone Set database of the Zone Servers\non each Fabric in one or more switches.\n\nIn Enhanced mode, changes to a database made via this\ntable are always made to the 'copy' database, but\nvalues read from this table reflect the contents of\neither the 'copy' database or the current (committed)\ndatabase as indicated by the corresponding value of\nt11ZsServerReadFromDatabase.")
t11ZsSetEntry = MibTableRow((1, 3, 6, 1, 2, 1, 160, 1, 1, 2, 1)).setIndexNames((0, "FC-MGMT-MIB", "fcmInstanceIndex"), (0, "FC-MGMT-MIB", "fcmSwitchIndex"), (0, "T11-FC-ZONE-SERVER-MIB", "t11ZsServerFabricIndex"), (0, "T11-FC-ZONE-SERVER-MIB", "t11ZsSetIndex"))
if mibBuilder.loadTexts: t11ZsSetEntry.setDescription("Each entry contains information about a Zone Set\nin the Zone Set database of a particular Fabric\n(identified by the value of t11ZsServerFabricIndex)\non a particular switch (identified by values of\nfcmInstanceIndex and fcmSwitchIndex).\n\nA Zone Set can be created in an existing Zone Set\ndatabase, and can contain zero or more existing\nZones.  As and when new Zones are created\n(as rows in the t11ZsZoneTable), they can be added\nto a Zone Set by creating an entry for each in the\nt11ZsSetZoneTable.  Deleting a row from this table\ndeletes the Zone Set from the Zone Set database\nmaintained by the Zone Server, but does not otherwise\naffect the Zone Server.\n\nThe StorageType of a row in this table is specified by\nthe instance of t11ZsServerDatabaseStorageType that is\n\n\n\nINDEXed by the same values of fcmInstanceIndex,\nfcmSwitchIndex, and t11ZsServerFabricIndex.")
t11ZsSetIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 2, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: t11ZsSetIndex.setDescription("The index of a Zone Set.  This object uniquely\nidentifies a Zone Set in the Zone Set database\nfor a particular Fabric on a particular switch.")
t11ZsSetName = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 2, 1, 2), T11ZoningName()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: t11ZsSetName.setDescription("The name of this Zone Set.  The t11ZsSetName should\nbe unique within a Fabric.\n\nThe Zone Set can be renamed at any time (i.e., even\nwhen the row in an active state) by setting this object\nto a new value.")
t11ZsSetRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 2, 1, 3), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: t11ZsSetRowStatus.setDescription("The status of this conceptual row.\n\nThis object cannot be set to 'active' unless the\ncorresponding value of t11ZsSetName is unique within\nthe Fabric's Zone Server database on this switch.")
t11ZsZoneTable = MibTable((1, 3, 6, 1, 2, 1, 160, 1, 1, 3))
if mibBuilder.loadTexts: t11ZsZoneTable.setDescription("This table gives information on all the Zones in the\nZone Set database of the Zone Servers on each Fabric\nin one or more switches.\n\nIn Enhanced mode, changes to a database made via this\ntable are always made to the 'copy' database, but\nvalues read from this table reflect the contents of\neither the 'copy' database or the current (committed)\ndatabase as indicated by the corresponding value of\nt11ZsServerReadFromDatabase.")
t11ZsZoneEntry = MibTableRow((1, 3, 6, 1, 2, 1, 160, 1, 1, 3, 1)).setIndexNames((0, "FC-MGMT-MIB", "fcmInstanceIndex"), (0, "FC-MGMT-MIB", "fcmSwitchIndex"), (0, "T11-FC-ZONE-SERVER-MIB", "t11ZsServerFabricIndex"), (0, "T11-FC-ZONE-SERVER-MIB", "t11ZsZoneIndex"))
if mibBuilder.loadTexts: t11ZsZoneEntry.setDescription("Each entry contains information about a Zone\nin the Zone Set database of a particular Fabric\n(identified by the value of t11ZsServerFabricIndex)\non a particular switch (identified by values of\nfcmInstanceIndex and fcmSwitchIndex).\n\nA Zone can be created in an existing Zone Set\ndatabase, by first creating an entry in this table,\nand then adding members to it by creating entries in the\nt11ZsZoneMemberTable.\n\nThe StorageType of a row in this table is specified by\nthe instance of t11ZsServerDatabaseStorageType that is\nINDEXed by the same values of fcmInstanceIndex,\nfcmSwitchIndex, and t11ZsServerFabricIndex.")
t11ZsZoneIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 3, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: t11ZsZoneIndex.setDescription("An index value that uniquely identifies this\nZone within a particular Fabric's Zone Set database\non a particular switch.")
t11ZsZoneName = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 3, 1, 2), T11ZoningName()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: t11ZsZoneName.setDescription("The name of this Zone.  The t11ZsZoneName should be\nunique within a Fabric.\n\nThe Zone can be renamed by setting this object\nto a new value.")
t11ZsZoneAttribBlock = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 3, 1, 3), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0, 4294967295))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: t11ZsZoneAttribBlock.setDescription("This object specifies the index value of the\nZone Attribute Block that contains the Attributes\nof this Zone.\n\nIn Enhanced mode, a value of zero indicates this\nZone has no Zone Attributes.  In Basic mode, this\nobject always has the value of zero.")
t11ZsZoneRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 3, 1, 4), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: t11ZsZoneRowStatus.setDescription("The status of this conceptual row.\n\nThis object cannot be set to 'active' unless the\n\n\n\ncorresponding value of t11ZsZoneName is unique within\nthe Fabric's Zone Server database on this switch.")
t11ZsSetZoneTable = MibTable((1, 3, 6, 1, 2, 1, 160, 1, 1, 4))
if mibBuilder.loadTexts: t11ZsSetZoneTable.setDescription("This table specifies which Zones belong to which Zone\nSets in the Zone Set database of the Zone Servers\non each Fabric in one or more switches.")
t11ZsSetZoneEntry = MibTableRow((1, 3, 6, 1, 2, 1, 160, 1, 1, 4, 1)).setIndexNames((0, "FC-MGMT-MIB", "fcmInstanceIndex"), (0, "FC-MGMT-MIB", "fcmSwitchIndex"), (0, "T11-FC-ZONE-SERVER-MIB", "t11ZsServerFabricIndex"), (0, "T11-FC-ZONE-SERVER-MIB", "t11ZsSetIndex"), (0, "T11-FC-ZONE-SERVER-MIB", "t11ZsZoneIndex"))
if mibBuilder.loadTexts: t11ZsSetZoneEntry.setDescription("Each entry specifies that a particular Zone (identified\nby the value of t11ZsZoneIndex) is one of the Zones\nthat form a particular Zone Set (identified by the\nvalue of t11ZsSetIndex) in the Zone Set database of a\nparticular Fabric (identified by the value of\nt11ZsServerFabricIndex) on a particular switch\n(identified by values of fcmInstanceIndex and\nfcmSwitchIndex).\n\nWhen a row in this table exists, it references one row in\nthe t11ZsSetTable and one row in the t11ZsZoneTable.  The\nagent must ensure that both such rows when referenced by an\nactive row in this table, do exist and have a status of\n'active', either by refusing to create new rows in this\ntable, or by automatically deleting rows in this table.\n\nAn 'active' row in this table references one row in the\nt11ZsSetTable and one in the t11ZsZoneTable.  The agent must\nensure that all such referenced rows exist with a status of\n'active', either by refusing to create new active rows in\nthis table, or by automatically deleting any rows in this\ntable that reference a deleted row.\n\nThe StorageType of a row in this table is specified by\nthe instance of t11ZsServerDatabaseStorageType that is\n\n\n\nINDEXed by the same values of fcmInstanceIndex,\nfcmSwitchIndex, and t11ZsServerFabricIndex.")
t11ZsSetZoneRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 4, 1, 1), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: t11ZsSetZoneRowStatus.setDescription("The status of this conceptual row.")
t11ZsAliasTable = MibTable((1, 3, 6, 1, 2, 1, 160, 1, 1, 5))
if mibBuilder.loadTexts: t11ZsAliasTable.setDescription("This table contains information about the Zone Aliases\nin the Zone Set database of the Zone Servers on each\nFabric in one or more switches.\n\nIn Enhanced mode, changes to a database made via this\ntable are always made to the 'copy' database, but\nvalues read from this table reflect the contents of\neither the 'copy' database or the current (committed)\ndatabase as indicated by the corresponding value of\nt11ZsServerReadFromDatabase.")
t11ZsAliasEntry = MibTableRow((1, 3, 6, 1, 2, 1, 160, 1, 1, 5, 1)).setIndexNames((0, "FC-MGMT-MIB", "fcmInstanceIndex"), (0, "FC-MGMT-MIB", "fcmSwitchIndex"), (0, "T11-FC-ZONE-SERVER-MIB", "t11ZsServerFabricIndex"), (0, "T11-FC-ZONE-SERVER-MIB", "t11ZsAliasIndex"))
if mibBuilder.loadTexts: t11ZsAliasEntry.setDescription("Each entry contains information about a Zone Alias in\nthe Zone Set database of a particular Fabric\n(identified by the value of t11ZsServerFabricIndex) on\n\n\n\na particular switch (identified by values of\nfcmInstanceIndex and fcmSwitchIndex).\n\nA Zone Member is added to a Zone Alias by creating\nan entry in the t11ZsZoneMemberTable pointing to a\nrow of this table via t11ZsAliasIndex, i.e.,:\n\n - t11ZsZoneMemberParentType = 'alias',\n - t11ZsZoneMemberParentIndex = Alias's t11ZsAliasIndex,\n - t11ZsZoneMemberFormat != '05 - Alias Name', and\n - t11ZsZoneMemberID = Member's identifier.\n\nA Zone Alias is added to a Zone by creating\nan entry in the t11ZsZoneMemberTable pointing to a\nrow of this table via t11ZsAliasName, i.e.,:\n\n - t11ZsZoneMemberParentType = 'zone',  and\n - t11ZsZoneMemberParentIndex = Zone's t11ZsZoneIndex,\n - t11ZsZoneMemberFormat = '05 - Alias Name',\n - t11ZsZoneMemberID = Alias's t11ZsAliasName.\n\nThe StorageType of a row in this table is specified by\nthe instance of t11ZsServerDatabaseStorageType that is\nINDEXed by the same values of fcmInstanceIndex,\nfcmSwitchIndex, and t11ZsServerFabricIndex.")
t11ZsAliasIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 5, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: t11ZsAliasIndex.setDescription("An index value which uniquely identifies this Zone\nAlias within the Zone Set database of a particular\nFabric on a particular switch.")
t11ZsAliasName = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 5, 1, 2), T11ZoningName()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: t11ZsAliasName.setDescription("The name of this Zone Alias.  The name of the Zone\nAlias should be unique within a Fabric.\n\nThe Zone Alias can be renamed by setting this object\nto a new value if and when it is not in a Zone, i.e.,\nif and only if the current name is not the value of\nany t11ZsZoneMemberID in the same Zone Set database.")
t11ZsAliasRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 5, 1, 3), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: t11ZsAliasRowStatus.setDescription("The status of this conceptual row.\n\nThis object cannot be set to 'active' unless the\ncorresponding value of t11ZsAliasName is unique within\nthe Fabric's Zone Server database on this switch.")
t11ZsZoneMemberTable = MibTable((1, 3, 6, 1, 2, 1, 160, 1, 1, 6))
if mibBuilder.loadTexts: t11ZsZoneMemberTable.setDescription("This table contains all members of a Zone/Zone Alias\nand information about those members in the Zone Set\ndatabase of the Zone Servers on each Fabric in one or\nmore switches.\n\nIn Enhanced mode, changes to a database made via this\ntable are always made to the 'copy' database, but\nvalues read from this table reflect the contents of\neither the 'copy' database or the current (committed)\ndatabase as indicated by the corresponding value of\nt11ZsServerReadFromDatabase.")
t11ZsZoneMemberEntry = MibTableRow((1, 3, 6, 1, 2, 1, 160, 1, 1, 6, 1)).setIndexNames((0, "FC-MGMT-MIB", "fcmInstanceIndex"), (0, "FC-MGMT-MIB", "fcmSwitchIndex"), (0, "T11-FC-ZONE-SERVER-MIB", "t11ZsServerFabricIndex"), (0, "T11-FC-ZONE-SERVER-MIB", "t11ZsZoneMemberParentType"), (0, "T11-FC-ZONE-SERVER-MIB", "t11ZsZoneMemberParentIndex"), (0, "T11-FC-ZONE-SERVER-MIB", "t11ZsZoneMemberIndex"))
if mibBuilder.loadTexts: t11ZsZoneMemberEntry.setDescription("Each entry represents the relationship between a\nmember and (one of) its 'parent(s)', i.e., a Zone\nor Zone Alias to which the member belongs, within\na particular Fabric (identified by the value of\nt11ZsServerFabricIndex) on a particular switch\n(identified by values of fcmInstanceIndex and\nfcmSwitchIndex).\n\nA Zone member (other than an alias) is added to a\nZone by creating an entry in this table having:\n\n - t11ZsZoneMemberParentType = 'zone',  and\n - t11ZsZoneMemberParentIndex = Zone's t11ZsZoneIndex,\n - t11ZsZoneMemberFormat != '05 - Alias Name',\n - t11ZsZoneMemberID = Member's identifier.\n\nAn 'active' row in this table references rows in other\ntables.  The agent must ensure that all such referenced\nrows exist with a status of 'active', either by refusing to\ncreate new active rows in this table, or by automatically\ndeleting any rows in this table that reference a deleted\nrow.\n\nThe StorageType of a row in this table is specified by\nthe instance of t11ZsServerDatabaseStorageType that is\nINDEXed by the same values of fcmInstanceIndex,\nfcmSwitchIndex, and t11ZsServerFabricIndex.")
t11ZsZoneMemberParentType = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 6, 1, 1), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("zone", 1), ("alias", 2), ))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: t11ZsZoneMemberParentType.setDescription("This object determines whether this member belongs\nto a Zone or Zone Alias.")
t11ZsZoneMemberParentIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 6, 1, 2), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: t11ZsZoneMemberParentIndex.setDescription("This object contains the index value of the Zone or\nZone Alias to which this member belongs.\n\nIf the value of the corresponding instance of\nt11ZsZoneMemberParentType is 'zone', then this object\nwill contain the value of the t11ZsZoneIndex object of\nthe Zone to which this member belongs.\n\nIf the value of the corresponding instance of\nt11ZsZoneMemberParentType is 'alias', then this object\nwill contain the value of the t11ZsAliasIndex object\nof the Zone Alias to which this member belongs.")
t11ZsZoneMemberIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 6, 1, 3), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: t11ZsZoneMemberIndex.setDescription("An index value that uniquely identifies this Zone\nMember amongst all Zone Members in the Zone Set\ndatabase of a particular Fabric on a particular switch.")
t11ZsZoneMemberFormat = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 6, 1, 4), T11ZsZoneMemberType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: t11ZsZoneMemberFormat.setDescription("This object identifies the format of the\nZone/Zone Alias member's identifier contained in\nt11ZsZoneMemberID.\n\nThis object cannot be modified while the corresponding\nvalue of t11ZsZoneMemberRowStatus object is 'active'.")
t11ZsZoneMemberID = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 6, 1, 5), OctetString().subtype(subtypeSpec=ValueSizeConstraint(1, 255))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: t11ZsZoneMemberID.setDescription("This object contains the Member Identifier of the\nZone or Alias.  The interpretation of this object\ndepends on the value of the corresponding instance\nof t11ZsZoneMemberFormat:\n\n  - if t11ZsZoneMemberFormat is 'N_Port_Name', then\n    this object contains an N_Port_Name.\n\n  - if t11ZsZoneMemberFormat is 'Domain_ID and physical\n    port', then this object contains a 4-octet value in\n    network byte order.  The first octet is zero,\n    the second octet contains the Domain_ID, and the\n    last 2 octets contain the physical port number.\n\n  - if t11ZsZoneMemberFormat is 'N_Port_ID', then this\n    object contains the 3-octet Nx_Port FC_ID.\n\n  - if t11ZsZoneMemberFormat is 'Alias Name', then\n    this object contains the value of t11ZsAliasName\n    for some Alias in the same Zone Set database.\n\n  - if t11ZsZoneMemberFormat is 'Node_Name', then\n    this object contains an 8-octet Node_Name.\n\n  - if t11ZsZoneMemberFormat is 'F_Port_Name', then\n    this object contains an 8-octet F_Port_Name.\n\n  - if t11ZsZoneMemberFormat is one of the 'Vendor\n    Specific' values, then this object contains a value\n    of 1 to 255 octets in a format defined by the relevant\n    vendor.\n\nThis object cannot be modified while the corresponding\nvalue of t11ZsZoneMemberRowStatus object is 'active'.")
t11ZsZoneMemberRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 6, 1, 6), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: t11ZsZoneMemberRowStatus.setDescription("The status of this conceptual row.\n\n\n\n\nThe corresponding instances of t11ZsZoneMemberID and\nt11ZsZoneMemberFormat objects must be set before or\nconcurrently with setting this object to 'active'.")
t11ZsAttribBlockTable = MibTable((1, 3, 6, 1, 2, 1, 160, 1, 1, 7))
if mibBuilder.loadTexts: t11ZsAttribBlockTable.setDescription("This table gives information on all the Zone\nAttributes in the Zone Set database of the Zone\nServers on each Fabric in one or more switches.\n\nIn Enhanced mode, changes to a database made via this\ntable are always made to the 'copy' database, but\nvalues read from this table reflect the contents of\neither the 'copy' database or the current (committed)\ndatabase as indicated by the corresponding value of\nt11ZsServerReadFromDatabase.")
t11ZsAttribBlockEntry = MibTableRow((1, 3, 6, 1, 2, 1, 160, 1, 1, 7, 1)).setIndexNames((0, "FC-MGMT-MIB", "fcmInstanceIndex"), (0, "FC-MGMT-MIB", "fcmSwitchIndex"), (0, "T11-FC-ZONE-SERVER-MIB", "t11ZsServerFabricIndex"), (0, "T11-FC-ZONE-SERVER-MIB", "t11ZsAttribBlockIndex"))
if mibBuilder.loadTexts: t11ZsAttribBlockEntry.setDescription("Each entry contains information about a Zone Attribute\nBlock (of Zone Attributes) in the Zone Set database\nof a particular Fabric (identified by the value of\nt11ZsServerFabricIndex) on a particular switch\n(identified by values of fcmInstanceIndex and\nfcmSwitchIndex).\n\nAn 'active' row in this table references a row in the\nt11ZsAttribBlockTable.  The agent must ensure that the\nreferenced rows exists with a status of 'active', either by\nrefusing to create new active rows in this table, or by\nautomatically deleting any rows in this table that\nreference a deleted row.\n\nThe StorageType of a row in this table is specified by\nthe instance of t11ZsServerDatabaseStorageType that is\nINDEXed by the same values of fcmInstanceIndex,\n\n\n\nfcmSwitchIndex, and t11ZsServerFabricIndex.")
t11ZsAttribBlockIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 7, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: t11ZsAttribBlockIndex.setDescription("An index value that uniquely identifies this Zone\nAttribute within the Zone Set database of a particular\nFabric on a particular switch.")
t11ZsAttribBlockName = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 7, 1, 2), T11ZoningName()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: t11ZsAttribBlockName.setDescription("The name of this Zone Attribute Block, which should\nbe unique within the Fabric.")
t11ZsAttribBlockRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 7, 1, 3), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: t11ZsAttribBlockRowStatus.setDescription("The status of this conceptual row.")
t11ZsAttribTable = MibTable((1, 3, 6, 1, 2, 1, 160, 1, 1, 8))
if mibBuilder.loadTexts: t11ZsAttribTable.setDescription("This table gives information on the Zone Attributes\nwithin the Zone Attribute Blocks in the Zone Set\ndatabase of the Zone Servers on each Fabric in one\nor more switches.\n\nIn Enhanced mode, changes to a database made via this\ntable are always made to the 'copy' database, but\nvalues read from this table reflect the contents of\neither the 'copy' database or the current (committed)\ndatabase as indicated by the corresponding value of\nt11ZsServerReadFromDatabase.")
t11ZsAttribEntry = MibTableRow((1, 3, 6, 1, 2, 1, 160, 1, 1, 8, 1)).setIndexNames((0, "FC-MGMT-MIB", "fcmInstanceIndex"), (0, "FC-MGMT-MIB", "fcmSwitchIndex"), (0, "T11-FC-ZONE-SERVER-MIB", "t11ZsServerFabricIndex"), (0, "T11-FC-ZONE-SERVER-MIB", "t11ZsAttribBlockIndex"), (0, "T11-FC-ZONE-SERVER-MIB", "t11ZsAttribIndex"))
if mibBuilder.loadTexts: t11ZsAttribEntry.setDescription("Each entry contains information about a Zone\nAttribute in a Zone Attribute Block (identified by\nt11ZsAttribBlockIndex) in the Zone Set database of\na particular Fabric (identified by the value of\nt11ZsServerFabricIndex) on a particular switch\n(identified by values of fcmInstanceIndex and\nfcmSwitchIndex).\n\nAn entry in this table cannot be created prior to\nits associated entry in the t11ZsAttribBlockTable.\n\nThe StorageType of a row in this table is specified by\nthe instance of t11ZsServerDatabaseStorageType that is\nINDEXed by the same values of fcmInstanceIndex,\nfcmSwitchIndex, and t11ZsServerFabricIndex.")
t11ZsAttribIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 8, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: t11ZsAttribIndex.setDescription("An index value that uniquely identifies this\nZone Attribute within its Zone Attribute Block in\nthe Zone Set database of a particular Fabric on a\nparticular switch.")
t11ZsAttribType = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 8, 1, 2), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: t11ZsAttribType.setDescription("The type of attribute:\n\n0001       - Protocol\n0002       - Broadcast Zone\n0003       - Hard Zone\n00E0 (hex) - Vendor Specific.")
t11ZsAttribValue = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 8, 1, 3), OctetString().subtype(subtypeSpec=ValueSizeConstraint(4, 252))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: t11ZsAttribValue.setDescription("The value of the attribute, formatted as specified\nin FC-GS-5 for the type given by the corresponding\ninstance of t11ZsAttribType.\n\nNote that FC-GS-5 requires that the length of this\nvalue is a multiple of 4 bytes.")
t11ZsAttribRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 8, 1, 4), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: t11ZsAttribRowStatus.setDescription("The status of this conceptual row.")
t11ZsActivateTable = MibTable((1, 3, 6, 1, 2, 1, 160, 1, 1, 9))
if mibBuilder.loadTexts: t11ZsActivateTable.setDescription("This table provides a mechanism to allow a Zone Set\nto be activated on a Fabric.")
t11ZsActivateEntry = MibTableRow((1, 3, 6, 1, 2, 1, 160, 1, 1, 9, 1)).setIndexNames((0, "FC-MGMT-MIB", "fcmInstanceIndex"), (0, "FC-MGMT-MIB", "fcmSwitchIndex"), (0, "T11-FC-ZONE-SERVER-MIB", "t11ZsServerFabricIndex"))
if mibBuilder.loadTexts: t11ZsActivateEntry.setDescription("Each entry reflects the state of the activation of a\nZone Set by a particular switch (identified by values\nof fcmInstanceIndex and fcmSwitchIndex) on a particular\nFabric (identified by the value of\nt11ZsServerFabricIndex).")
t11ZsActivateRequest = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 9, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0, 4294967295))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: t11ZsActivateRequest.setDescription("Setting this object to a value is a request for a\nZone Set to be activated on the Fabric that is\nrepresented by this row.  The Zone Set to be\nactivated is the one for which t11ZsSetIndex has\nthe same value.\n\nIf a Zone Set is already active on a Fabric when a\nrequest is made to activate a different one on that\nFabric, then the existing Zone Set is automatically\ndeactivated and the specified Zone Set is activated\nin its place.\n\nThe value of this object when read is always 0.")
t11ZsActivateDeactivate = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 9, 1, 2), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,)).subtype(namedValues=NamedValues(("deactivate", 1), ("noop", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: t11ZsActivateDeactivate.setDescription("Setting this object to 'deactivate' is a request\nto deactivate the currently active Zone Set on\na Fabric.\n\nNote that the deactivation of the active Zone Set\nallows all ports to communicate or no ports to\ncommunicate, depending on the current Default Zone\nbehavior.\n\nNo action is taken if this object is set to 'noop'.\nWhen read, the value of this object is always 'noop'.")
t11ZsActivateResult = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 9, 1, 3), Integer().subtype(subtypeSpec=SingleValueConstraint(6,4,2,3,1,5,)).subtype(namedValues=NamedValues(("activateSuccess", 1), ("activateFailure", 2), ("deactivateSuccess", 3), ("deactivateFailure", 4), ("inProgress", 5), ("none", 6), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: t11ZsActivateResult.setDescription("This object indicates the outcome of the most recent\nactivation/deactivation using this entry.\n\nWhen the value of this object is 'inProgress', the\nvalues of the corresponding instances of\nt11ZsActivateRequest and t11ZsActivateDeactivate\ncannot be modified.\n\nThe value 'none' indicates activation/deactivation\nhas not been attempted since the last restart of\nthe management system.")
t11ZsActivateFailCause = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 9, 1, 4), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(0, 64))).setMaxAccess("readonly")
if mibBuilder.loadTexts: t11ZsActivateFailCause.setDescription("A textual message indicating the reason for the\nmost recent failure of a Zone Set activation or\ndeactivation, or the zero-length string if no\ninformation is available (e.g., because the\ncorresponding instance of t11ZsActivateResult\nhas the value 'none').\n\nWhen the corresponding instance of\nt11ZsActivateResult is either 'activateFailure'\nor 'deactivateFailure', the value of this object\nindicates the reason for that failure.")
t11ZsActivateFailDomainId = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 9, 1, 5), FcDomainIdOrZero()).setMaxAccess("readonly")
if mibBuilder.loadTexts: t11ZsActivateFailDomainId.setDescription("If the failure cause (as indicated by\nt11ZsSetFailCause) was specific to a particular\ndevice, this object contains the Domain_ID of that\ndevice.  Otherwise, this object contains zero.")
t11ZsActiveTable = MibTable((1, 3, 6, 1, 2, 1, 160, 1, 1, 10))
if mibBuilder.loadTexts: t11ZsActiveTable.setDescription("A table containing information on the currently\nenforced/active Zone Set on each Fabric.\nAn active Zone Set cannot be modified.\nThis table will be empty when no Zone Set is\nactivated.")
t11ZsActiveEntry = MibTableRow((1, 3, 6, 1, 2, 1, 160, 1, 1, 10, 1)).setIndexNames((0, "FC-MGMT-MIB", "fcmInstanceIndex"), (0, "FC-MGMT-MIB", "fcmSwitchIndex"), (0, "T11-FC-ZONE-SERVER-MIB", "t11ZsServerFabricIndex"))
if mibBuilder.loadTexts: t11ZsActiveEntry.setDescription("Each entry represents an active Zone Set of a\nparticular Fabric (identified by the value of\nt11ZsServerFabricIndex), according to a particular\nswitch (identified by values of fcmInstanceIndex and\nfcmSwitchIndex).")
t11ZsActiveZoneSetName = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 10, 1, 1), T11ZoningName()).setMaxAccess("readonly")
if mibBuilder.loadTexts: t11ZsActiveZoneSetName.setDescription("The name of this Zone Set on this Fabric.")
t11ZsActiveActivateTime = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 10, 1, 2), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: t11ZsActiveActivateTime.setDescription("The value of sysUpTime at which this entry was most\nrecently activated.  If this row was activated prior to\nthe last re-initialization of the local network management\nsystem, then this object will contain a zero value.")
t11ZsActiveZoneTable = MibTable((1, 3, 6, 1, 2, 1, 160, 1, 1, 11))
if mibBuilder.loadTexts: t11ZsActiveZoneTable.setDescription("This table contains all the Zones that are present in\nthe active Zone Sets on all Fabrics.")
t11ZsActiveZoneEntry = MibTableRow((1, 3, 6, 1, 2, 1, 160, 1, 1, 11, 1)).setIndexNames((0, "FC-MGMT-MIB", "fcmInstanceIndex"), (0, "FC-MGMT-MIB", "fcmSwitchIndex"), (0, "T11-FC-ZONE-SERVER-MIB", "t11ZsServerFabricIndex"), (0, "T11-FC-ZONE-SERVER-MIB", "t11ZsActiveZoneIndex"))
if mibBuilder.loadTexts: t11ZsActiveZoneEntry.setDescription("Each entry represents a Zone in the active Zone Set\nof a particular Fabric (identified by the value of\nt11ZsServerFabricIndex), according to a particular\nswitch (identified by values of fcmInstanceIndex and\nfcmSwitchIndex).")
t11ZsActiveZoneIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 11, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: t11ZsActiveZoneIndex.setDescription("An index value that uniquely identifies this Zone\nwithin the active Zone Set on a particular Fabric.")
t11ZsActiveZoneName = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 11, 1, 2), T11ZoningName()).setMaxAccess("readonly")
if mibBuilder.loadTexts: t11ZsActiveZoneName.setDescription("The name of this Zone.")
t11ZsActiveZoneBroadcastZoning = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 11, 1, 3), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: t11ZsActiveZoneBroadcastZoning.setDescription("This object indicates whether broadcast Zoning is\nenabled on this Zone.  If broadcast Zoning is enabled,\nthen broadcast frames generated by a member in this\nZone will be restricted to members in this Zone.\n\nThis object is only instantiated in Enhanced mode.")
t11ZsActiveZoneHardZoning = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 11, 1, 4), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: t11ZsActiveZoneHardZoning.setDescription("This object indicates whether hard Zoning is\nenabled on this Zone.\n\nThis object is only instantiated in Enhanced mode.")
t11ZsActiveZoneMemberTable = MibTable((1, 3, 6, 1, 2, 1, 160, 1, 1, 12))
if mibBuilder.loadTexts: t11ZsActiveZoneMemberTable.setDescription("This table contains all members of all Zones\nwithin the active Zone Set on any Fabric.")
t11ZsActiveZoneMemberEntry = MibTableRow((1, 3, 6, 1, 2, 1, 160, 1, 1, 12, 1)).setIndexNames((0, "FC-MGMT-MIB", "fcmInstanceIndex"), (0, "FC-MGMT-MIB", "fcmSwitchIndex"), (0, "T11-FC-ZONE-SERVER-MIB", "t11ZsServerFabricIndex"), (0, "T11-FC-ZONE-SERVER-MIB", "t11ZsActiveZoneIndex"), (0, "T11-FC-ZONE-SERVER-MIB", "t11ZsActiveZoneMemberIndex"))
if mibBuilder.loadTexts: t11ZsActiveZoneMemberEntry.setDescription("Each entry represents a member of a Zone in the active\nZone Set of a particular Fabric (identified by the value\nt11ZsServerFabricIndex), according to a particular\nswitch (identified by values of fcmInstanceIndex and\nfcmSwitchIndex).")
t11ZsActiveZoneMemberIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 12, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: t11ZsActiveZoneMemberIndex.setDescription("An index value that uniquely identifies this\nmember amongst the members of a particular Zone\nin the active Zone Set on a particular Fabric.")
t11ZsActiveZoneMemberFormat = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 12, 1, 2), T11ZsZoneMemberType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: t11ZsActiveZoneMemberFormat.setDescription("This object identifies the identifier format of the\ncorresponding instance of t11ZsActiveZoneMemberID.")
t11ZsActiveZoneMemberID = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 12, 1, 3), OctetString().subtype(subtypeSpec=ValueSizeConstraint(1, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: t11ZsActiveZoneMemberID.setDescription("This value of this object identifies the member\nusing the format specified in the corresponding\ninstance of t11ZsActiveZoneMemberFormat.")
t11ZsActiveAttribTable = MibTable((1, 3, 6, 1, 2, 1, 160, 1, 1, 13))
if mibBuilder.loadTexts: t11ZsActiveAttribTable.setDescription("This table contains information about some of the\nAttributes of the Zones within the active Zone Set\non each Fabric.\n\nThis table contains all the types of attributes\nthat might apply zero, one, or more times to a Zone.\nAttributes that apply once and only to a Zone are\nspecified in the t11ZsActiveZoneTable.\n\nThis table will always be empty in Basic mode.\nIt will also be empty if there are no Zones in\nany active Zone Set having any of the applicable\ntypes of attributes.")
t11ZsActiveAttribEntry = MibTableRow((1, 3, 6, 1, 2, 1, 160, 1, 1, 13, 1)).setIndexNames((0, "FC-MGMT-MIB", "fcmInstanceIndex"), (0, "FC-MGMT-MIB", "fcmSwitchIndex"), (0, "T11-FC-ZONE-SERVER-MIB", "t11ZsServerFabricIndex"), (0, "T11-FC-ZONE-SERVER-MIB", "t11ZsActiveZoneIndex"), (0, "T11-FC-ZONE-SERVER-MIB", "t11ZsActiveAttribIndex"))
if mibBuilder.loadTexts: t11ZsActiveAttribEntry.setDescription("Each entry contains an Attribute of a particular\nZone in the active Zone Set of a particular Fabric\n(identified by the value of t11ZsServerFabricIndex),\naccording to a particular switch (identified by\nvalues of fcmInstanceIndex and fcmSwitchIndex).")
t11ZsActiveAttribIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 13, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: t11ZsActiveAttribIndex.setDescription("An index value that uniquely identifies this\nattribute amongst the other attributes for a\nparticular Zone in the active Zone Set on a\nparticular Fabric.")
t11ZsActiveAttribType = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 13, 1, 2), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: t11ZsActiveAttribType.setDescription("The type of attribute:\n\n0001       - Protocol\n00E0 (hex) - Vendor Specific\n\nNote that type 2 (Hard) and type 3 (Broadcast)\ndo not need to be represented here, because they\nare represented by t11ZsActiveZoneBroadcastZoning and\nt11ZsActiveZoneHardZoning.")
t11ZsActiveAttribValue = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 13, 1, 3), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 252))).setMaxAccess("readonly")
if mibBuilder.loadTexts: t11ZsActiveAttribValue.setDescription("The value of the attribute, formatted according to\nits type as indicated by the corresponding instance\nof t11ZsActiveAttribType.\n\nAs specified in FC-GS-5, the length of an attribute\nvalue is at least 4 bytes, and if necessary, the value\nis appended with zero bytes so that the length is a\nmultiple of 4.  For a Vendor-Specific attribute\nvalue, the first 8 bytes contain the T10 Vendor ID\nas described in FC-GS-5.")
t11ZsNotifyControlTable = MibTable((1, 3, 6, 1, 2, 1, 160, 1, 1, 14))
if mibBuilder.loadTexts: t11ZsNotifyControlTable.setDescription("A table of control information for notifications\ngenerated due to Zone Server events.")
t11ZsNotifyControlEntry = MibTableRow((1, 3, 6, 1, 2, 1, 160, 1, 1, 14, 1)).setIndexNames((0, "FC-MGMT-MIB", "fcmInstanceIndex"), (0, "FC-MGMT-MIB", "fcmSwitchIndex"), (0, "T11-FC-ZONE-SERVER-MIB", "t11ZsServerFabricIndex"))
if mibBuilder.loadTexts: t11ZsNotifyControlEntry.setDescription("Each entry contains notification control information\nspecific to a Zone Server for a particular Fabric\n(identified by the value of t11ZsServerFabricIndex)\non a particular switch (identified by values of\nfcmInstanceIndex and fcmSwitchIndex).\n\nThe persistence across reboots of writable values in\na row of this table is specified by the instance of\nt11ZsServerDatabaseStorageType that is INDEXed by\nthe same values of fcmInstanceIndex, fcmSwitchIndex,\nand t11ZsServerFabricIndex.")
t11ZsNotifyRequestRejectEnable = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 14, 1, 1), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: t11ZsNotifyRequestRejectEnable.setDescription("This object specifies whether t11ZsRequestRejectNotify\nnotifications should be generated by the Zone Server\nfor this Fabric.")
t11ZsNotifyMergeFailureEnable = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 14, 1, 2), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: t11ZsNotifyMergeFailureEnable.setDescription("This object specifies whether t11ZsMergeFailureNotify\nnotifications should be generated by the Zone Server\nfor this Fabric.")
t11ZsNotifyMergeSuccessEnable = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 14, 1, 3), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: t11ZsNotifyMergeSuccessEnable.setDescription("This object specifies whether t11ZsMergeSuccessNotify\nnotifications should be generated by the Zone Server\nfor this Fabric.")
t11ZsNotifyDefZoneChangeEnable = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 14, 1, 4), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: t11ZsNotifyDefZoneChangeEnable.setDescription("This object specifies whether t11ZsDefZoneChangeNotify\nnotifications should be generated by the Zone Server\n\n\n\nfor this Fabric.")
t11ZsNotifyActivateEnable = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 14, 1, 5), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: t11ZsNotifyActivateEnable.setDescription("This object specifies whether t11ZsActivateNotify\nnotifications should be generated by the Zone Server\nfor this Fabric.")
t11ZsRejectCtCommandString = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 14, 1, 6), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: t11ZsRejectCtCommandString.setDescription("The binary content of the Zone Server request,\nformatted as an octet string (in network byte order)\ncontaining the Common Transport Information Unit\n(CT_IU), as described in Table 2 of FC-GS-5 (including\nthe preamble), which was most recently rejected by the\nFabric Configuration Server for this Fabric.\n\nThis object contains the zero-length string\nif and when the CT-IU's content is unavailable.\n\nWhen the length of this object is 255 octets, it\ncontains the first 255 octets of the CT-IU (in\nnetwork byte order).")
t11ZsRejectRequestSource = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 14, 1, 7), FcNameIdOrZero()).setMaxAccess("readonly")
if mibBuilder.loadTexts: t11ZsRejectRequestSource.setDescription("The WWN that was the source of the CT_IU\ncontained in the corresponding instance of\nt11ZsRejectCtCommandString.")
t11ZsRejectReasonCode = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 14, 1, 8), T11NsGs4RejectReasonCode()).setMaxAccess("readonly")
if mibBuilder.loadTexts: t11ZsRejectReasonCode.setDescription("The reason code corresponding to the most recent\nrejection of a request by the Zone Server for\nthis Fabric.")
t11ZsRejectReasonCodeExp = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 14, 1, 9), T11ZsRejectReasonExplanation()).setMaxAccess("readonly")
if mibBuilder.loadTexts: t11ZsRejectReasonCodeExp.setDescription("When the value of t11ZsRejectReasonCode is\n'Unable to perform command request', this\nobject contains the corresponding reason code\nexplanation.")
t11ZsRejectReasonVendorCode = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 1, 14, 1, 10), OctetString().subtype(subtypeSpec=ValueSizeConstraint(1, 1)).setFixedLength(1)).setMaxAccess("readonly")
if mibBuilder.loadTexts: t11ZsRejectReasonVendorCode.setDescription("When the value of t11ZsRejectReasonCode is\n'Vendor Specific Error', this object contains\nthe corresponding vendor-specific reason code.")
t11ZsFabricIndex = MibScalar((1, 3, 6, 1, 2, 1, 160, 1, 1, 15), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0, 4096))).setMaxAccess("notifyonly")
if mibBuilder.loadTexts: t11ZsFabricIndex.setDescription("This object contains either a value of\nT11FabricIndex to identify the Fabric on which\nsome occurrence has caused a notification to be\ngenerated, or it has the value 4096 to indicate\nall applicable Fabrics.")
t11ZsStatistics = MibIdentifier((1, 3, 6, 1, 2, 1, 160, 1, 2))
t11ZsStatsTable = MibTable((1, 3, 6, 1, 2, 1, 160, 1, 2, 1))
if mibBuilder.loadTexts: t11ZsStatsTable.setDescription("A table of statistics maintained by Zone Servers.")
t11ZsStatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 160, 1, 2, 1, 1)).setIndexNames((0, "FC-MGMT-MIB", "fcmInstanceIndex"), (0, "FC-MGMT-MIB", "fcmSwitchIndex"), (0, "T11-FC-ZONE-SERVER-MIB", "t11ZsServerFabricIndex"))
if mibBuilder.loadTexts: t11ZsStatsEntry.setDescription("A set of statistics for a Zone Server on a\nparticular Fabric (identified by the value of\nt11ZsServerFabricIndex) on a particular switch\n(identified by values of fcmInstanceIndex and\nfcmSwitchIndex).")
t11ZsOutMergeRequests = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 2, 1, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: t11ZsOutMergeRequests.setDescription("The number of Merge Request Frames sent by this Zone\nServer to other Zone Servers in the same Fabric.\n\nThis counter has no discontinuities other than those\n\n\n\nthat all Counter32s have when sysUpTime=0.")
t11ZsInMergeAccepts = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 2, 1, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: t11ZsInMergeAccepts.setDescription("The number of Merge Accept Frames received by this Zone\nServer from other Zone Servers in the same Fabric.\n\nThis counter has no discontinuities other than those\nthat all Counter32s have when sysUpTime=0.")
t11ZsInMergeRequests = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 2, 1, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: t11ZsInMergeRequests.setDescription("The number of Merge Request Frames received by this Zone\nServer from other Zone Servers in the same Fabric.\n\nThis counter has no discontinuities other than those\nthat all Counter32s have when sysUpTime=0.")
t11ZsOutMergeAccepts = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 2, 1, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: t11ZsOutMergeAccepts.setDescription("The number of Merge Accept Frames sent by this Zone\nServer to other Zone Servers in the same Fabric.\n\nThis counter has no discontinuities other than those\nthat all Counter32s have when sysUpTime=0.")
t11ZsOutChangeRequests = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 2, 1, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: t11ZsOutChangeRequests.setDescription("The number of change requests sent (via the Fabric\nManagement Session Protocol) by this Zone Server to\nother Zone Servers in the same Fabric.\n\n\n\n\nThis includes Acquire Change Authorization requests, Stage\nFabric Config Update requests, Update Fabric Config requests\nand Release Change Authorization requests.  It also includes\nthe corresponding types of requests defined by the Enhanced\nCommit Service.\n\nThis counter has no discontinuities other than those\nthat all Counter32s have when sysUpTime=0.")
t11ZsInChangeAccepts = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 2, 1, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: t11ZsInChangeAccepts.setDescription("The number of SW_ACC messages received from other Zone\nServers in the same Fabric (according to the Fabric\nManagement Session Protocol) in response to change\nrequests by this Zone Server.\n\nThis includes SW_ACC messages received in response to\nAcquire Change Authorization requests, to Stage Fabric\nConfig Update requests, to Update Fabric Config requests,\nand to Release Change Authorization requests.  It also\nincludes responses to the corresponding types of requests\ndefined for the Enhanced Commit Service.\n\nThis counter has no discontinuities other than those\nthat all Counter32s have when sysUpTime=0.")
t11ZsInChangeRequests = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 2, 1, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: t11ZsInChangeRequests.setDescription("The number of change requests received (via the Fabric\nManagement Session Protocol) by this Zone Server from\nother Zone Servers in the same Fabric.\n\nThis includes Acquire Change Authorization requests, Stage\nFabric Config Update requests, Update Fabric Config requests\n\n\n\nand Release Change Authorization requests.  It also includes\nthe corresponding types of requests defined by the Enhanced\nCommit Service.\n\nThis counter has no discontinuities other than those\nthat all Counter32s have when sysUpTime=0.")
t11ZsOutChangeAccepts = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 2, 1, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: t11ZsOutChangeAccepts.setDescription("The number of SW_ACC messages sent by this Zone Server\n(according to the Fabric Management Session Protocol) in\nresponse to change requests from other Zone Servers in\nthe same Fabric.\n\nThis includes SW_ACC messages sent in response to\nAcquire Change Authorization requests, to Stage Fabric\nConfig Update requests, to Update Fabric Config requests\nand to Release Change Authorization requests.  It also\nincludes responses to the corresponding types of requests\ndefined for the Enhanced Commit Service.\n\nThis counter has no discontinuities other than those\nthat all Counter32s have when sysUpTime=0.")
t11ZsInZsRequests = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 2, 1, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: t11ZsInZsRequests.setDescription("The number of Zone Server requests received by this\nZone Server on this Fabric, both those received in\nBasic mode and in Enhanced mode.\n\nThis counter has no discontinuities other than those\nthat all Counter32s have when sysUpTime=0.")
t11ZsOutZsRejects = MibTableColumn((1, 3, 6, 1, 2, 1, 160, 1, 2, 1, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: t11ZsOutZsRejects.setDescription("The number of Zone Server requests rejected by this\nZone Server on this Fabric, both those rejected in\nBasic mode and in Enhanced mode.\n\nThis counter has no discontinuities other than those\nthat all Counter32s have when sysUpTime=0.")
t11ZsMIBConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 160, 2))
t11ZsMIBCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 160, 2, 1))
t11ZsMIBGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 160, 2, 2))

# Augmentions

# Notifications

t11ZsRequestRejectNotify = NotificationType((1, 3, 6, 1, 2, 1, 160, 0, 1)).setObjects(*(("T11-FC-ZONE-SERVER-MIB", "t11ZsRejectReasonCode"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsRejectReasonCodeExp"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsRejectCtCommandString"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsRejectRequestSource"), ("T11-FC-FABRIC-ADDR-MGR-MIB", "t11FamLocalSwitchWwn"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsRejectReasonVendorCode"), ) )
if mibBuilder.loadTexts: t11ZsRequestRejectNotify.setDescription("This notification is generated whenever a Zone Server\n(indicated by the value of t11FamLocalSwitchWwn) rejects\na request.\n\nThe value of t11ZsRejectCtCommandString indicates the\nrejected request, and the values of t11ZsRejectReasonCode,\nt11ZsRejectReasonCodeExp and t11ZsRejectReasonVendorCode\nindicate the reason for the rejection.  The value of\nt11ZsRequestClient indicates the source of the request.")
t11ZsMergeFailureNotify = NotificationType((1, 3, 6, 1, 2, 1, 160, 0, 2)).setObjects(*(("IF-MIB", "ifIndex"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsFabricIndex"), ) )
if mibBuilder.loadTexts: t11ZsMergeFailureNotify.setDescription("This notification indicates that a Zone merge\nfailure has occurred on the Fabric indicated by the\nvalue of t11ZsFabricIndex, on the interface\nindicated by the value of ifIndex.\n\nIf multiple Virtual Fabrics are configured on an\ninterface, and all have a Zone merge failure\nat the same time, then just one notification is\ngenerated and t11ZsFabricIndex has the value 4096.")
t11ZsMergeSuccessNotify = NotificationType((1, 3, 6, 1, 2, 1, 160, 0, 3)).setObjects(*(("IF-MIB", "ifIndex"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsFabricIndex"), ) )
if mibBuilder.loadTexts: t11ZsMergeSuccessNotify.setDescription("This notification indicates that a successful Zone\nmerge has occurred on the Fabric indicated by the\nvalue of t11ZsFabricIndex, on the interface\nindicated by the value of ifIndex.\n\nIf multiple Virtual Fabrics are configured on an\ninterface, and all have a successful Zone Merge\n\n\n\nat the same time, then just one notification is\ngenerated and t11ZsFabricIndex has the value 4096.")
t11ZsDefZoneChangeNotify = NotificationType((1, 3, 6, 1, 2, 1, 160, 0, 4)).setObjects(*(("T11-FC-ZONE-SERVER-MIB", "t11ZsServerDefaultZoneSetting"), ) )
if mibBuilder.loadTexts: t11ZsDefZoneChangeNotify.setDescription("This notification indicates that the\nvalue of a Default Zone Setting has changed.\nThe value of t11ZsServerDefaultZoneSetting\ncontains the value after the change.")
t11ZsActivateNotify = NotificationType((1, 3, 6, 1, 2, 1, 160, 0, 5)).setObjects(*(("T11-FC-ZONE-SERVER-MIB", "t11ZsActivateResult"), ("T11-FC-FABRIC-ADDR-MGR-MIB", "t11FamLocalSwitchWwn"), ) )
if mibBuilder.loadTexts: t11ZsActivateNotify.setDescription("This notification is generated whenever a switch\n(indicated by the value of t11FamLocalSwitchWwn)\nactivates/deactivates a Zone Set on a Fabric.\nThe t11ZsActivateResult object denotes the outcome\nof the activation/deactivation.")

# Groups

t11ZsBasicGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 160, 2, 2, 1)).setObjects(*(("T11-FC-ZONE-SERVER-MIB", "t11ZsActiveZoneSetName"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsZoneMemberID"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsActiveZoneMemberID"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsSetZoneRowStatus"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsZoneRowStatus"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsZoneName"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsServerReasonCode"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsServerDistribute"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsZoneMemberRowStatus"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsServerReasonVendorCode"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsActiveZoneName"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsZoneMemberFormat"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsServerReasonCodeExp"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsServerDatabaseStorageType"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsServerCapabilityObject"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsSetName"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsServerResult"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsServerReadFromDatabase"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsSetRowStatus"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsActiveActivateTime"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsServerHardZoning"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsServerOperationMode"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsActiveZoneMemberFormat"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsZoneAttribBlock"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsServerLastChange"), ) )
if mibBuilder.loadTexts: t11ZsBasicGroup.setDescription("A collection of objects for displaying and updating\nthe Zone configuration of a Zone Server capable of\noperating in Basic mode.")
t11ZsEnhancedModeGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 160, 2, 2, 2)).setObjects(*(("T11-FC-ZONE-SERVER-MIB", "t11ZsServerCommit"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsServerDefZoneBroadcast"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsActiveAttribValue"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsServerChangeModeResult"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsAttribType"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsAliasName"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsAttribBlockName"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsAliasRowStatus"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsAttribRowStatus"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsActiveZoneBroadcastZoning"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsServerDefaultZoneSetting"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsServerMergeControlSetting"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsAttribBlockRowStatus"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsActiveZoneHardZoning"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsActiveAttribType"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsAttribValue"), ) )
if mibBuilder.loadTexts: t11ZsEnhancedModeGroup.setDescription("A collection of additional objects for displaying\nand updating the Zone configuration of a Zone Server\ncapable of operating in Enhanced mode.")
t11ZsStatisticsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 160, 2, 2, 3)).setObjects(*(("T11-FC-ZONE-SERVER-MIB", "t11ZsInMergeRequests"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsInChangeAccepts"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsOutChangeAccepts"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsOutChangeRequests"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsOutZsRejects"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsOutMergeRequests"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsInZsRequests"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsInMergeAccepts"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsOutMergeAccepts"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsInChangeRequests"), ) )
if mibBuilder.loadTexts: t11ZsStatisticsGroup.setDescription("A collection of objects for collecting Zone Server\nstatistics information.")
t11ZsNotificationControlGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 160, 2, 2, 4)).setObjects(*(("T11-FC-ZONE-SERVER-MIB", "t11ZsNotifyRequestRejectEnable"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsRejectReasonCodeExp"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsNotifyMergeSuccessEnable"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsRejectRequestSource"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsNotifyMergeFailureEnable"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsNotifyDefZoneChangeEnable"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsRejectReasonVendorCode"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsNotifyActivateEnable"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsRejectReasonCode"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsRejectCtCommandString"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsFabricIndex"), ) )
if mibBuilder.loadTexts: t11ZsNotificationControlGroup.setDescription("A collection of notification control and\nnotification information objects for monitoring\nZone Server request rejection and Zone merge\nfailures.")
t11ZsActivateGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 160, 2, 2, 5)).setObjects(*(("T11-FC-ZONE-SERVER-MIB", "t11ZsActivateDeactivate"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsActivateFailDomainId"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsActivateRequest"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsActivateResult"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsActivateFailCause"), ) )
if mibBuilder.loadTexts: t11ZsActivateGroup.setDescription("A collection of objects that allow a Zone Set to\nbe activated via SNMP SetRequests and provide the\nstatus and result of such an activation.")
t11ZsNotificationGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 160, 2, 2, 6)).setObjects(*(("T11-FC-ZONE-SERVER-MIB", "t11ZsActivateNotify"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsRequestRejectNotify"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsMergeFailureNotify"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsMergeSuccessNotify"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsDefZoneChangeNotify"), ) )
if mibBuilder.loadTexts: t11ZsNotificationGroup.setDescription("A collection of notification(s) for monitoring\nZone Server request rejection, Zone merge\nfailures and successes, and Default Zoning\nbehavioral changes.")

# Compliances

t11ZsMIBCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 160, 2, 1, 1)).setObjects(*(("T11-FC-ZONE-SERVER-MIB", "t11ZsActivateGroup"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsNotificationGroup"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsNotificationControlGroup"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsBasicGroup"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsEnhancedModeGroup"), ("T11-FC-ZONE-SERVER-MIB", "t11ZsStatisticsGroup"), ) )
if mibBuilder.loadTexts: t11ZsMIBCompliance.setDescription("The compliance statement for entities that\nimplement the Zone Server.")

# Exports

# Module identity
mibBuilder.exportSymbols("T11-FC-ZONE-SERVER-MIB", PYSNMP_MODULE_ID=t11ZoneServerMIB)

# Types
mibBuilder.exportSymbols("T11-FC-ZONE-SERVER-MIB", T11ZoningName=T11ZoningName, T11ZsRejectReasonExplanation=T11ZsRejectReasonExplanation, T11ZsZoneMemberType=T11ZsZoneMemberType)

# Objects
mibBuilder.exportSymbols("T11-FC-ZONE-SERVER-MIB", t11ZoneServerMIB=t11ZoneServerMIB, t11ZsMIBNotifications=t11ZsMIBNotifications, t11ZsMIBObjects=t11ZsMIBObjects, t11ZsConfiguration=t11ZsConfiguration, t11ZsServerTable=t11ZsServerTable, t11ZsServerEntry=t11ZsServerEntry, t11ZsServerFabricIndex=t11ZsServerFabricIndex, t11ZsServerCapabilityObject=t11ZsServerCapabilityObject, t11ZsServerDatabaseStorageType=t11ZsServerDatabaseStorageType, t11ZsServerDistribute=t11ZsServerDistribute, t11ZsServerCommit=t11ZsServerCommit, t11ZsServerResult=t11ZsServerResult, t11ZsServerReasonCode=t11ZsServerReasonCode, t11ZsServerReasonCodeExp=t11ZsServerReasonCodeExp, t11ZsServerReasonVendorCode=t11ZsServerReasonVendorCode, t11ZsServerLastChange=t11ZsServerLastChange, t11ZsServerHardZoning=t11ZsServerHardZoning, t11ZsServerReadFromDatabase=t11ZsServerReadFromDatabase, t11ZsServerOperationMode=t11ZsServerOperationMode, t11ZsServerChangeModeResult=t11ZsServerChangeModeResult, t11ZsServerDefaultZoneSetting=t11ZsServerDefaultZoneSetting, t11ZsServerMergeControlSetting=t11ZsServerMergeControlSetting, t11ZsServerDefZoneBroadcast=t11ZsServerDefZoneBroadcast, t11ZsSetTable=t11ZsSetTable, t11ZsSetEntry=t11ZsSetEntry, t11ZsSetIndex=t11ZsSetIndex, t11ZsSetName=t11ZsSetName, t11ZsSetRowStatus=t11ZsSetRowStatus, t11ZsZoneTable=t11ZsZoneTable, t11ZsZoneEntry=t11ZsZoneEntry, t11ZsZoneIndex=t11ZsZoneIndex, t11ZsZoneName=t11ZsZoneName, t11ZsZoneAttribBlock=t11ZsZoneAttribBlock, t11ZsZoneRowStatus=t11ZsZoneRowStatus, t11ZsSetZoneTable=t11ZsSetZoneTable, t11ZsSetZoneEntry=t11ZsSetZoneEntry, t11ZsSetZoneRowStatus=t11ZsSetZoneRowStatus, t11ZsAliasTable=t11ZsAliasTable, t11ZsAliasEntry=t11ZsAliasEntry, t11ZsAliasIndex=t11ZsAliasIndex, t11ZsAliasName=t11ZsAliasName, t11ZsAliasRowStatus=t11ZsAliasRowStatus, t11ZsZoneMemberTable=t11ZsZoneMemberTable, t11ZsZoneMemberEntry=t11ZsZoneMemberEntry, t11ZsZoneMemberParentType=t11ZsZoneMemberParentType, t11ZsZoneMemberParentIndex=t11ZsZoneMemberParentIndex, t11ZsZoneMemberIndex=t11ZsZoneMemberIndex, t11ZsZoneMemberFormat=t11ZsZoneMemberFormat, t11ZsZoneMemberID=t11ZsZoneMemberID, t11ZsZoneMemberRowStatus=t11ZsZoneMemberRowStatus, t11ZsAttribBlockTable=t11ZsAttribBlockTable, t11ZsAttribBlockEntry=t11ZsAttribBlockEntry, t11ZsAttribBlockIndex=t11ZsAttribBlockIndex, t11ZsAttribBlockName=t11ZsAttribBlockName, t11ZsAttribBlockRowStatus=t11ZsAttribBlockRowStatus, t11ZsAttribTable=t11ZsAttribTable, t11ZsAttribEntry=t11ZsAttribEntry, t11ZsAttribIndex=t11ZsAttribIndex, t11ZsAttribType=t11ZsAttribType, t11ZsAttribValue=t11ZsAttribValue, t11ZsAttribRowStatus=t11ZsAttribRowStatus, t11ZsActivateTable=t11ZsActivateTable, t11ZsActivateEntry=t11ZsActivateEntry, t11ZsActivateRequest=t11ZsActivateRequest, t11ZsActivateDeactivate=t11ZsActivateDeactivate, t11ZsActivateResult=t11ZsActivateResult, t11ZsActivateFailCause=t11ZsActivateFailCause, t11ZsActivateFailDomainId=t11ZsActivateFailDomainId, t11ZsActiveTable=t11ZsActiveTable, t11ZsActiveEntry=t11ZsActiveEntry, t11ZsActiveZoneSetName=t11ZsActiveZoneSetName, t11ZsActiveActivateTime=t11ZsActiveActivateTime, t11ZsActiveZoneTable=t11ZsActiveZoneTable, t11ZsActiveZoneEntry=t11ZsActiveZoneEntry, t11ZsActiveZoneIndex=t11ZsActiveZoneIndex, t11ZsActiveZoneName=t11ZsActiveZoneName, t11ZsActiveZoneBroadcastZoning=t11ZsActiveZoneBroadcastZoning, t11ZsActiveZoneHardZoning=t11ZsActiveZoneHardZoning, t11ZsActiveZoneMemberTable=t11ZsActiveZoneMemberTable, t11ZsActiveZoneMemberEntry=t11ZsActiveZoneMemberEntry, t11ZsActiveZoneMemberIndex=t11ZsActiveZoneMemberIndex, t11ZsActiveZoneMemberFormat=t11ZsActiveZoneMemberFormat, t11ZsActiveZoneMemberID=t11ZsActiveZoneMemberID, t11ZsActiveAttribTable=t11ZsActiveAttribTable, t11ZsActiveAttribEntry=t11ZsActiveAttribEntry, t11ZsActiveAttribIndex=t11ZsActiveAttribIndex, t11ZsActiveAttribType=t11ZsActiveAttribType, t11ZsActiveAttribValue=t11ZsActiveAttribValue, t11ZsNotifyControlTable=t11ZsNotifyControlTable, t11ZsNotifyControlEntry=t11ZsNotifyControlEntry, t11ZsNotifyRequestRejectEnable=t11ZsNotifyRequestRejectEnable, t11ZsNotifyMergeFailureEnable=t11ZsNotifyMergeFailureEnable, t11ZsNotifyMergeSuccessEnable=t11ZsNotifyMergeSuccessEnable, t11ZsNotifyDefZoneChangeEnable=t11ZsNotifyDefZoneChangeEnable, t11ZsNotifyActivateEnable=t11ZsNotifyActivateEnable, t11ZsRejectCtCommandString=t11ZsRejectCtCommandString, t11ZsRejectRequestSource=t11ZsRejectRequestSource, t11ZsRejectReasonCode=t11ZsRejectReasonCode, t11ZsRejectReasonCodeExp=t11ZsRejectReasonCodeExp, t11ZsRejectReasonVendorCode=t11ZsRejectReasonVendorCode, t11ZsFabricIndex=t11ZsFabricIndex, t11ZsStatistics=t11ZsStatistics, t11ZsStatsTable=t11ZsStatsTable, t11ZsStatsEntry=t11ZsStatsEntry, t11ZsOutMergeRequests=t11ZsOutMergeRequests, t11ZsInMergeAccepts=t11ZsInMergeAccepts, t11ZsInMergeRequests=t11ZsInMergeRequests, t11ZsOutMergeAccepts=t11ZsOutMergeAccepts, t11ZsOutChangeRequests=t11ZsOutChangeRequests, t11ZsInChangeAccepts=t11ZsInChangeAccepts, t11ZsInChangeRequests=t11ZsInChangeRequests, t11ZsOutChangeAccepts=t11ZsOutChangeAccepts, t11ZsInZsRequests=t11ZsInZsRequests, t11ZsOutZsRejects=t11ZsOutZsRejects, t11ZsMIBConformance=t11ZsMIBConformance, t11ZsMIBCompliances=t11ZsMIBCompliances, t11ZsMIBGroups=t11ZsMIBGroups)

# Notifications
mibBuilder.exportSymbols("T11-FC-ZONE-SERVER-MIB", t11ZsRequestRejectNotify=t11ZsRequestRejectNotify, t11ZsMergeFailureNotify=t11ZsMergeFailureNotify, t11ZsMergeSuccessNotify=t11ZsMergeSuccessNotify, t11ZsDefZoneChangeNotify=t11ZsDefZoneChangeNotify, t11ZsActivateNotify=t11ZsActivateNotify)

# Groups
mibBuilder.exportSymbols("T11-FC-ZONE-SERVER-MIB", t11ZsBasicGroup=t11ZsBasicGroup, t11ZsEnhancedModeGroup=t11ZsEnhancedModeGroup, t11ZsStatisticsGroup=t11ZsStatisticsGroup, t11ZsNotificationControlGroup=t11ZsNotificationControlGroup, t11ZsActivateGroup=t11ZsActivateGroup, t11ZsNotificationGroup=t11ZsNotificationGroup)

# Compliances
mibBuilder.exportSymbols("T11-FC-ZONE-SERVER-MIB", t11ZsMIBCompliance=t11ZsMIBCompliance)
