#
# PySNMP MIB module SLAPM-MIB (http://pysnmp.sf.net)
# ASN.1 source http://mibs.snmplabs.com:80/asn1/SLAPM-MIB
# Produced by pysmi-0.0.7 at Sun Feb 14 00:28:23 2016
# On host bldfarm platform Linux version 4.1.13-100.fc21.x86_64 by user goose
# Using Python version 3.5.0 (default, Jan  5 2016, 17:11:52) 
#
( OctetString, ObjectIdentifier, Integer, ) = mibBuilder.importSymbols("ASN1", "OctetString", "ObjectIdentifier", "Integer")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ConstraintsUnion, ValueRangeConstraint, SingleValueConstraint, ValueSizeConstraint, ConstraintsIntersection, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ConstraintsUnion", "ValueRangeConstraint", "SingleValueConstraint", "ValueSizeConstraint", "ConstraintsIntersection")
( SnmpAdminString, ) = mibBuilder.importSymbols("SNMP-FRAMEWORK-MIB", "SnmpAdminString")
( NotificationGroup, ModuleCompliance, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "NotificationGroup", "ModuleCompliance", "ObjectGroup")
( NotificationType, Bits, TimeTicks, experimental, ObjectIdentity, IpAddress, MibIdentifier, Unsigned32, MibScalar, MibTable, MibTableRow, MibTableColumn, Gauge32, ModuleIdentity, Counter64, Integer32, iso, Counter32, ) = mibBuilder.importSymbols("SNMPv2-SMI", "NotificationType", "Bits", "TimeTicks", "experimental", "ObjectIdentity", "IpAddress", "MibIdentifier", "Unsigned32", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "Gauge32", "ModuleIdentity", "Counter64", "Integer32", "iso", "Counter32")
( TestAndIncr, DisplayString, RowStatus, DateAndTime, TextualConvention, ) = mibBuilder.importSymbols("SNMPv2-TC", "TestAndIncr", "DisplayString", "RowStatus", "DateAndTime", "TextualConvention")
slapmMIB = ModuleIdentity((1, 3, 6, 1, 3, 88)).setRevisions(("2000-01-24 00:00",))
if mibBuilder.loadTexts: slapmMIB.setLastUpdated('200001240000Z')
if mibBuilder.loadTexts: slapmMIB.setOrganization('International Business Machines Corp.')
if mibBuilder.loadTexts: slapmMIB.setContactInfo('Kenneth White\n\n          International Business Machines Corporation\n          Network Computing Software Division\n          Research Triangle Park, NC, USA\n\n          E-mail: wkenneth@us.ibm.com')
if mibBuilder.loadTexts: slapmMIB.setDescription('The Service Level Agreement Performance Monitoring MIB\n          (SLAPM-MIB) provides data collection and monitoring\n          capabilities for Service Level Agreements (SLAs)\n          policy definitions.')
class SlapmNameType(SnmpAdminString, TextualConvention):
    subtypeSpec = SnmpAdminString.subtypeSpec+ValueSizeConstraint(0,32)

class SlapmStatus(Bits, TextualConvention):
    namedValues = NamedValues(("slaMinInRateNotAchieved", 0), ("slaMaxInRateExceeded", 1), ("slaMaxDelayExceeded", 2), ("slaMinOutRateNotAchieved", 3), ("slaMaxOutRateExceeded", 4), ("monitorMinInRateNotAchieved", 5), ("monitorMaxInRateExceeded", 6), ("monitorMaxDelayExceeded", 7), ("monitorMinOutRateNotAchieved", 8), ("monitorMaxOutRateExceeded", 9),)

class SlapmPolicyRuleName(OctetString, TextualConvention):
    displayHint = '1024t'
    subtypeSpec = OctetString.subtypeSpec+ValueSizeConstraint(0,1024)

slapmNotifications = MibIdentifier((1, 3, 6, 1, 3, 88, 0))
slapmObjects = MibIdentifier((1, 3, 6, 1, 3, 88, 1))
slapmConformance = MibIdentifier((1, 3, 6, 1, 3, 88, 2))
slapmBaseObjects = MibIdentifier((1, 3, 6, 1, 3, 88, 1, 1))
slapmSpinLock = MibScalar((1, 3, 6, 1, 3, 88, 1, 1, 1), TestAndIncr()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: slapmSpinLock.setDescription('An advisory lock used to allow cooperating applications\n         to coordinate their use of the contents of this MIB.  This\n         typically occurs when an application seeks to create an\n         new entry or alter an existing entry in\n         slapmPRMonTable (or old slapmPolicyMonitorTable).  A\n         management implementation MAY utilize the slapmSpinLock to\n         serialize its changes or additions.  This usage is not\n         required.   However, slapmSpinLock MUST be supported by\n         agent implementations.')
slapmPolicyCountQueries = MibScalar((1, 3, 6, 1, 3, 88, 1, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyCountQueries.setDescription('The total number of times that a policy lookup occurred\n         with respect to a policy agent.\n         This is the number of times that a reference was made to\n         a policy definition at a system and includes the number\n         of times that a policy repository was accessed,\n         slapmPolicyCountAccesses.  The object\n         slapmPolicyCountAccesses should be less than\n         slapmPolicyCountQueries when policy definitions are\n         cached at a system.')
slapmPolicyCountAccesses = MibScalar((1, 3, 6, 1, 3, 88, 1, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyCountAccesses.setDescription('Total number of times that a policy repository was\n          accessed with respect to a policy agent.\n          The value of this object should be less than\n          slapmPolicyCountQueries, since typically policy entries\n          are cached to minimize repository accesses.')
slapmPolicyCountSuccessAccesses = MibScalar((1, 3, 6, 1, 3, 88, 1, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyCountSuccessAccesses.setDescription('Total number of successful policy repository accesses\n         with respect to a policy agent.')
slapmPolicyCountNotFounds = MibScalar((1, 3, 6, 1, 3, 88, 1, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyCountNotFounds.setDescription('Total number of policy repository accesses,\n         with respect to a policy agent, that\n         resulted in an entry not being located.')
slapmPolicyPurgeTime = MibScalar((1, 3, 6, 1, 3, 88, 1, 1, 6), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,3600)).clone(900)).setUnits('seconds').setMaxAccess("readwrite")
if mibBuilder.loadTexts: slapmPolicyPurgeTime.setDescription('The purpose of this object is to define the amount\n         of time (in seconds) to wait before removing an\n         slapmPolicyRuleStatsEntry (or old slapmPolicyStatsEntry)\n         when a system detects that the associated policy\n         definition has been deleted.  This gives any polling\n         management applications time to complete their last poll\n         before an entry is removed.  An slapmPolicyRuleStatsEntry\n         (or old slapmPolicyStatsEntry) enters the\n         deleteNeeded(3) state via slapmPolicyRuleStatsOperStatus\n         (or old slapmPolicyStatsOperStatus) when a system first\n         detects that the entry needs to be removed.\n\n         Once slapmPolicyPurgeTime has expired for an entry in\n         deleteNeeded(3) state it is removed a long with any\n         dependent slapmPRMonTable (or slapmPolicyMonitorTable)\n         entries.\n\n         A value of 0 for this option disables this function and\n         results in the automatic purging of slapmPRMonTable\n         (or slapmPolicyTable) entries upon transition into\n         deleteNeeded(3) state.\n\n         A slapmPolicyRuleDeleted (or slapmPolicyProfileDeleted)\n         notification is sent when an slapmPolicyRuleStatsEntry (or\n         slapmPolicyStatsEntry) is removed.  Dependent\n         slapmPRMonTable (or slapmPolicyMonitorTable)\n         deletion results in a slapmPolicyRuleMonDeleted (or\n         slapmPolicyMonitorDeleted) notification being sent.\n         These notifications are suppressed if the value of\n         slapmPolicyTrapEnable is disabled(2).')
slapmPolicyTrapEnable = MibScalar((1, 3, 6, 1, 3, 88, 1, 1, 7), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("enabled", 1), ("disabled", 2),)).clone('disabled')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: slapmPolicyTrapEnable.setDescription('Indicates whether slapmPolicyRuleDeleted and\n         slapmPolicyRuleMonDeleted (or slapmPolicyProfileDeleted\n         and slapmPolicyMonitorDeleted) notifications should be\n         generated by this system.')
slapmPolicyTrapFilter = MibScalar((1, 3, 6, 1, 3, 88, 1, 1, 8), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,64)).clone(3)).setUnits('intervals').setMaxAccess("readwrite")
if mibBuilder.loadTexts: slapmPolicyTrapFilter.setDescription('The purpose of this object is to suppress unnecessary\n         slapmSubcMonitorNotOkay (or\n         slapmSubcomponentMonitoredEventNotAchieved), for example,\n         notifications.  Basically, a monitored event has to\n         not meet its SLA requirement for the number of\n         consecutive intervals indicated by the value of this\n         object.')
slapmTableObjects = MibIdentifier((1, 3, 6, 1, 3, 88, 1, 2))
slapmPolicyStatsTable = MibTable((1, 3, 6, 1, 3, 88, 1, 2, 1), )
if mibBuilder.loadTexts: slapmPolicyStatsTable.setDescription('Provides statistics on all policies known at a\n          system.\n\n          This table has been deprecated and replaced with\n          the slapmPolicyRuleStatsTable.  Older implementations of\n          this MIB are expected to continue their support of this\n          table.')
slapmPolicyStatsEntry = MibTableRow((1, 3, 6, 1, 3, 88, 1, 2, 1, 1), ).setIndexNames((0, "SLAPM-MIB", "slapmPolicyStatsSystemAddress"), (0, "SLAPM-MIB", "slapmPolicyStatsPolicyName"), (0, "SLAPM-MIB", "slapmPolicyStatsTrafficProfileName"))
if mibBuilder.loadTexts: slapmPolicyStatsEntry.setDescription('Defines an entry in the slapmPolicyStatsTable.  This table\n          defines a set of statistics that is kept on a per system,\n          policy and traffic profile basis.  A policy can be\n          defined to contain multiple traffic profiles that map to\n          a single action.\n\n          Entries in this table are not created or deleted via SNMP\n          but reflect the set of policy definitions known at a system.')
slapmPolicyStatsSystemAddress = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 1, 1, 1), OctetString().subtype(subtypeSpec=ConstraintsUnion(ValueSizeConstraint(0,0),ValueSizeConstraint(4,4),ValueSizeConstraint(16,16),)))
if mibBuilder.loadTexts: slapmPolicyStatsSystemAddress.setDescription('Address of a system that an Policy definition relates to.\n         A zero length octet string must be used to indicate that\n         only a single system is being represented.\n         Otherwise, the length of the octet string must be\n         4 for an ipv4 address or 16 for an ipv6 address.')
slapmPolicyStatsPolicyName = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 1, 1, 2), SlapmNameType())
if mibBuilder.loadTexts: slapmPolicyStatsPolicyName.setDescription('Policy name that this entry relates to.')
slapmPolicyStatsTrafficProfileName = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 1, 1, 3), SlapmNameType())
if mibBuilder.loadTexts: slapmPolicyStatsTrafficProfileName.setDescription('The name of a traffic profile that is associated with\n         a policy.')
slapmPolicyStatsOperStatus = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 1, 1, 4), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3,))).clone(namedValues=NamedValues(("inactive", 1), ("active", 2), ("deleteNeeded", 3),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyStatsOperStatus.setDescription('The state of a policy entry:\n\n           inactive(1)      - An policy entry was either defined\n                              by local system definition or\n                              discovered via a directory search\n                              but has not been activated (not\n                              currently being used).\n           active(2)        - Policy entry is being used to affect\n                              traffic flows.\n           deleteNeeded(3)  - Either though local implementation\n                              dependent methods or by discovering\n                              that the directory entry corresponding\n                              to this table entry no longer\n                              exists and slapmPolicyPurgeTime needs\n                              to expire before attempting to remove\n                              the corresponding slapmPolicyStatsEntry\n                              and any dependent slapmPolicyMonitor\n                              table entries.\n         Note: a policy traffic profile in a state other than\n         active(1) is not being used to affect traffic flows.')
slapmPolicyStatsActiveConns = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 1, 1, 5), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyStatsActiveConns.setDescription('The number of active TCP connections that are\n         affected by the corresponding policy entry.')
slapmPolicyStatsTotalConns = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 1, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyStatsTotalConns.setDescription('The number of total TCP connections that are\n         affected by the corresponding policy entry.')
slapmPolicyStatsFirstActivated = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 1, 1, 7), DateAndTime().clone(hexValue="0000000000000000")).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyStatsFirstActivated.setDescription('The timestamp for when the corresponding policy entry\n         is activated.  The value of this object serves as\n         the discontinuity event indicator when polling entries\n         in this table.  The value of this object is updated on\n         transition of slapmPolicyStatsOperStatus into the active(2)\n         state.')
slapmPolicyStatsLastMapping = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 1, 1, 8), DateAndTime().clone(hexValue="0000000000000000")).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyStatsLastMapping.setDescription('The timestamp for when the last time\n         that the associated policy entry was used.')
slapmPolicyStatsInOctets = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 1, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyStatsInOctets.setDescription('The number of octets that was received by IP for an\n         entity that map to this entry.')
slapmPolicyStatsOutOctets = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 1, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyStatsOutOctets.setDescription('The number of octets that was transmitted by IP for an\n\n         entity that map to this entry.')
slapmPolicyStatsConnectionLimit = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 1, 1, 11), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyStatsConnectionLimit.setDescription('The limit for the number of active TCP connections that\n         are allowed for this policy definition.  A value of zero\n         for this object implies that a connection limit has not\n         been specified.')
slapmPolicyStatsCountAccepts = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 1, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyStatsCountAccepts.setDescription("This counter is incremented when a policy action's\n          Permission value is set to Accept and a session\n          (TCP connection) is accepted.")
slapmPolicyStatsCountDenies = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 1, 1, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyStatsCountDenies.setDescription("This counter is incremented when a policy action's\n          Permission value is set to Deny and a session is denied,\n          or when a session (TCP connection) is rejected due to a\n          policy's connection limit (slapmPolicyStatsConnectLimit)\n          being reached.")
slapmPolicyStatsInDiscards = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 1, 1, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyStatsInDiscards.setDescription('This counter counts the number of in octets discarded.\n          This occurs when an error is detected.  Examples of this\n          are buffer overflow, checksum error, or bad packet\n          format.')
slapmPolicyStatsOutDiscards = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 1, 1, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyStatsOutDiscards.setDescription('This counter counts the number of out octets discarded.\n          Examples of this are buffer overflow, checksum error, or\n          bad packet format.')
slapmPolicyStatsInPackets = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 1, 1, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyStatsInPackets.setDescription('This counter counts the number of in packets received\n          that relate to this policy entry from IP.')
slapmPolicyStatsOutPackets = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 1, 1, 17), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyStatsOutPackets.setDescription('This counter counts the number of out packets sent\n          by IP that relate to this policy entry.')
slapmPolicyStatsInProfileOctets = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 1, 1, 18), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyStatsInProfileOctets.setDescription('This counter counts the number of in octets that are\n          determined to be within profile.')
slapmPolicyStatsOutProfileOctets = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 1, 1, 19), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyStatsOutProfileOctets.setDescription('This counter counts the number of out octets that are\n          determined to be within profile.')
slapmPolicyStatsMinRate = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 1, 1, 20), Integer32()).setUnits('Kilobits per second').setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyStatsMinRate.setDescription('The minimum transfer rate defined for this entry.')
slapmPolicyStatsMaxRate = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 1, 1, 21), Integer32()).setUnits('Kilobits per second').setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyStatsMaxRate.setDescription('The maximum transfer rate defined for this entry.')
slapmPolicyStatsMaxDelay = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 1, 1, 22), Integer32()).setUnits('milliseconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyStatsMaxDelay.setDescription('The maximum delay defined for this entry.')
slapmPolicyMonitorTable = MibTable((1, 3, 6, 1, 3, 88, 1, 2, 2), )
if mibBuilder.loadTexts: slapmPolicyMonitorTable.setDescription('Provides a method of monitoring policies and their\n          effect at a system.\n\n          This table has been deprecated and replaced with\n          the slapmPRMonTable.  Older implementations of\n          this MIB are expected to continue their support\n          of this table.')
slapmPolicyMonitorEntry = MibTableRow((1, 3, 6, 1, 3, 88, 1, 2, 2, 1), ).setIndexNames((0, "SLAPM-MIB", "slapmPolicyMonitorOwnerIndex"), (0, "SLAPM-MIB", "slapmPolicyMonitorSystemAddress"), (0, "SLAPM-MIB", "slapmPolicyMonitorPolicyName"), (0, "SLAPM-MIB", "slapmPolicyMonitorTrafficProfileName"))
if mibBuilder.loadTexts: slapmPolicyMonitorEntry.setDescription('Defines an entry in the slapmPolicyMonitorTable. This\n          table defines which policies should be monitored on a\n          per policy traffic profile basis.')
slapmPolicyMonitorOwnerIndex = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 2, 1, 1), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(0,16)))
if mibBuilder.loadTexts: slapmPolicyMonitorOwnerIndex.setDescription("To facilitate the provisioning of access control by a\n         security administrator using the View-Based Access\n         Control Model (RFC 2575, VACM) for tables in which\n         multiple users may need to independently create or modify\n         entries, the initial index is used as an 'owner index'.\n         Such an initial index has a syntax of SnmpAdminString,\n         and can thus be trivially mapped to a securityName or\n         groupName as defined in VACM, in accordance with a\n\n         security policy.\n\n         All entries in that table belonging to a particular user\n         will have the same value for this initial index.  For a\n         given user's entries in a particular table, the object\n         identifiers for the information in these entries will\n         have the same subidentifiers (except for the 'column'\n         subidentifier) up to the end of the encoded owner index.\n         To configure VACM to permit access to this portion of the\n         table, one would create vacmViewTreeFamilyTable entries\n         with the value of vacmViewTreeFamilySubtree including the\n         owner index portion, and vacmViewTreeFamilyMask\n         'wildcarding' the column subidentifier.  More elaborate\n         configurations are possible.")
slapmPolicyMonitorSystemAddress = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 2, 1, 2), OctetString().subtype(subtypeSpec=ConstraintsUnion(ValueSizeConstraint(0,0),ValueSizeConstraint(4,4),ValueSizeConstraint(16,16),)))
if mibBuilder.loadTexts: slapmPolicyMonitorSystemAddress.setDescription('Address of a system that an Policy definition relates to.\n         A zero length octet string can be used to indicate that\n         only a single system is being represented.\n         Otherwise, the length of the octet string should be\n         4 for an ipv4 address and 16 for an ipv6 address.')
slapmPolicyMonitorPolicyName = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 2, 1, 3), SlapmNameType())
if mibBuilder.loadTexts: slapmPolicyMonitorPolicyName.setDescription('Policy name that this entry relates to.')
slapmPolicyMonitorTrafficProfileName = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 2, 1, 4), SlapmNameType())
if mibBuilder.loadTexts: slapmPolicyMonitorTrafficProfileName.setDescription('The corresponding Traffic Profile name.')
slapmPolicyMonitorControl = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 2, 1, 5), Bits().clone(namedValues=NamedValues(("monitorMinRate", 0), ("monitorMaxRate", 1), ("monitorMaxDelay", 2), ("enableAggregateTraps", 3), ("enableSubcomponentTraps", 4), ("monitorSubcomponents", 5),)).clone(namedValues=NamedValues(("monitorMinRate", 0), ("monitorMaxRate", 1), ("monitorMaxDelay", 2),))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: slapmPolicyMonitorControl.setDescription("The value of this object determines the type and level\n         of monitoring that is applied to a policy/profile.  The\n         value of this object can't be changed once the table\n         entry that it is a part of is activated via a\n         slapmPolicyMonitorRowStatus transition to active state.\n\n             monitorMinRate(0) - Monitor minimum transfer rate.\n             monitorMaxRate(1) - Monitor maximum transfer rate.\n             monitorMaxDelay(2) - Monitor maximum delay.\n             enableAggregateTraps(3) - The enableAggregateTraps(3)\n                   BITS setting enables notification generation\n                   when monitoring a policy traffic profile as an\n                   aggregate using the values in the corresponding\n                   slapmPolicyStatsEntry.  By default this function\n                   is not enabled.\n             enableSubcomponentTraps(4) - This BITS setting enables\n                   notification generation when monitoring all\n                   subcomponents that are mapped to an corresponding\n                   slapmPolicyStatsEntry.  By default this\n                   function is not enabled.\n             monitorSubcomponents(5) - This BITS setting enables\n                   monitoring of each subcomponent (typically a\n                   TCP connection or UDP listener) individually.")
slapmPolicyMonitorStatus = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 2, 1, 6), SlapmStatus()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyMonitorStatus.setDescription("The value of this object indicates when a monitored\n         value has not meet a threshold or isn't meeting the\n         defined service level.  The SlapmStatus TEXTUAL-CONVENTION\n         defines two levels of not meeting a threshold.  The first\n         set:\n                     slaMinInRateNotAchieved(0),\n                     slaMaxInRateExceeded(1),\n                     slaMaxDelayExceeded(2),\n\n                     slaMinOutRateNotAchieved(3),\n                     slaMaxOutRateExceeded(4)\n\n         are used to indicate when the SLA as an aggregate is\n         not meeting a threshold while the second set:\n\n                     monitorMinInRateNotAchieved(5),\n                     monitorMaxInRateExceeded(6),\n                     monitorMaxDelayExceeded(7),\n                     monitorMinOutRateNotAchieved(8),\n                     monitorMaxOutRateExceeded(9)\n\n         indicate that at least one subcomponent is not meeting\n         a threshold.")
slapmPolicyMonitorInterval = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 2, 1, 7), Integer32().subtype(subtypeSpec=ValueRangeConstraint(15,86400)).clone(20)).setUnits('seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: slapmPolicyMonitorInterval.setDescription('The number of seconds that defines the sample period.')
slapmPolicyMonitorIntTime = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 2, 1, 8), DateAndTime().clone(hexValue="0000000000000000")).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyMonitorIntTime.setDescription('The timestamp for when the last interval ended.')
slapmPolicyMonitorCurrentInRate = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 2, 1, 9), Gauge32()).setUnits('kilobits per second').setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyMonitorCurrentInRate.setDescription('Using the value of the corresponding\n         slapmPolicyMonitorInterval, slapmPolicyStatsInOctets\n         is sampled and then divided by slapmPolicyMonitorInterval\n         to determine the current in transfer rate.')
slapmPolicyMonitorCurrentOutRate = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 2, 1, 10), Gauge32()).setUnits('kilobits per second').setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyMonitorCurrentOutRate.setDescription('Using the value of the corresponding\n         slapmPolicyMonitorInterval, slapmPolicyStatsOutOctets\n         is sampled and then divided by slapmPolicyMonitorInterval\n         to determine the current out transfer rate.')
slapmPolicyMonitorMinRateLow = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 2, 1, 11), Integer32()).setUnits('kilobits per second').setMaxAccess("readcreate")
if mibBuilder.loadTexts: slapmPolicyMonitorMinRateLow.setDescription("The threshold for generating a\n         slapmMonitoredEventNotAchieved notification, signalling\n         that a monitored minimum transfer rate has not been meet.\n\n         A slapmMonitoredEventNotAchieved notification is not\n         generated again for an slapmPolicyMonitorEntry until\n         the minimum transfer rate\n         exceeds slapmPolicyMonitorMinRateHigh (a\n         slapmMonitoredEventOkay notification is then transmitted)\n         and then fails below slapmPolicyMonitorMinRateLow.  This\n         behavior reduces the slapmMonitoredEventNotAchieved\n         notifications that are transmitted.\n\n         A value of zero for this object is returned when the\n         slapmPolicyMonitorControl monitorMinRate(0) is not\n         enabled.  When enabled the default value for this object\n         is the min rate value specified in the associated\n         action definition minus 10%.  If the action definition\n         doesn't have a min rate defined then there is no\n         default for this object and a value MUST be specified\n         prior to activating this entry when monitorMinRate(0)\n         is selected.\n\n         Note: The corresponding slapmPolicyMonitorControl\n         BITS setting, enableAggregateTraps(3), MUST be selected in\n         order for any notification relating to this entry to\n         potentially be generated.")
slapmPolicyMonitorMinRateHigh = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 2, 1, 12), Integer32()).setUnits('kilobits per second').setMaxAccess("readcreate")
if mibBuilder.loadTexts: slapmPolicyMonitorMinRateHigh.setDescription("The threshold for generating a slapmMonitoredEventOkay\n         notification, signalling that a monitored minimum\n         transfer rate has increased to an acceptable level.\n\n         A value of zero for this object is returned when the\n         slapmPolicyMonitorControl monitorMinRate(0) is not\n         enabled.  When enabled the default value for this object\n         is the min rate value specified in the associated\n         action definition plus 10%.  If the action definition\n         doesn't have a min rate defined then there is no\n         default for this object and a value MUST be specified\n         prior to activating this entry when monitorMinRate(0)\n         is selected.\n\n         Note: The corresponding slapmPolicyMonitorControl\n         BITS setting, enableAggregateTraps(3), MUST be selected\n         in order for any notification relating to this entry to\n         potentially be generated.")
slapmPolicyMonitorMaxRateHigh = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 2, 1, 13), Integer32()).setUnits('kilobits per second').setMaxAccess("readcreate")
if mibBuilder.loadTexts: slapmPolicyMonitorMaxRateHigh.setDescription("The threshold for generating a\n         slapmMonitoredEventNotAchieved notification, signalling\n         that a monitored maximum transfer rate has been exceeded.\n\n         A slapmMonitoredEventNotAchieved notification is not\n         generated again for an slapmPolicyMonitorEntry until the\n         maximum transfer rate fails below\n         slapmPolicyMonitorMaxRateLow (a slapmMonitoredEventOkay\n         notification is then transmitted) and then raises above\n         slapmPolicyMonitorMaxRateHigh.  This behavior reduces the\n         slapmMonitoredEventNotAchieved notifications that are\n         transmitted.\n\n         A value of zero for this object is returned when the\n         slapmPolicyMonitorControl monitorMaxRate(1) is not\n         enabled.  When enabled the default value for this object\n         is the max rate value specified in the associated\n         action definition plus 10%.  If the action definition\n\n         doesn't have a max rate defined then there is no\n         default for this object and a value MUST be specified\n         prior to activating this entry when monitorMaxRate(1)\n         is selected.\n\n         Note: The corresponding slapmPolicyMonitorControl\n         BITS setting, enableAggregateTraps(3), MUST be selected in\n         order for any notification relating to this entry to\n         potentially be generated.")
slapmPolicyMonitorMaxRateLow = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 2, 1, 14), Integer32()).setUnits('kilobits per second').setMaxAccess("readcreate")
if mibBuilder.loadTexts: slapmPolicyMonitorMaxRateLow.setDescription("The threshold for generating a slapmMonitoredEventOkay\n         notification, signalling that a monitored maximum\n         transfer rate has fallen to an acceptable level.\n\n         A value of zero for this object is returned when the\n         slapmPolicyMonitorControl monitorMaxRate(1) is not\n         enabled.  When enabled the default value for this object\n         is the max rate value specified in the associated\n         action definition minus 10%.  If the action definition\n         doesn't have a max rate defined then there is no\n         default for this object and a value MUST be specified\n         prior to activating this entry when monitorMaxRate(1)\n         is selected.\n\n         Note: The corresponding slapmPolicyMonitorControl\n         BITS setting, enableAggregateTraps(3), MUST be selected in\n         order for any notification relating to this entry to\n         potentially be generated.")
slapmPolicyMonitorMaxDelayHigh = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 2, 1, 15), Integer32()).setUnits('milliseconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: slapmPolicyMonitorMaxDelayHigh.setDescription("The threshold for generating a\n         slapmMonitoredEventNotAchieved notification, signalling\n         that a monitored maximum delay rate has been exceeded.\n\n         A slapmMonitoredEventNotAchieved notification is not\n\n         generated again for an slapmPolicyMonitorEntry until\n         the maximum delay rate falls below\n         slapmPolicyMonitorMaxDelayLow (a slapmMonitoredEventOkay\n         notification is then transmitted) and raises above\n         slapmPolicyMonitorMaxDelayHigh.  This behavior reduces\n         the slapmMonitoredEventNotAchieved notifications that are\n         transmitted.\n\n         A value of zero for this object is returned when the\n         slapmPolicyMonitorControl monitorMaxDelay(4) is not\n         enabled.  When enabled the default value for this object\n         is the max delay value specified in the associated\n         action definition plus 10%.  If the action definition\n         doesn't have a max delay defined then there is no\n         default for this object and a value MUST be specified\n         prior to activating this entry when monitorMaxDelay(4)\n         is selected.\n\n         Note: The corresponding slapmPolicyMonitorControl\n         BITS setting, enableAggregateTraps(3), MUST be selected\n         in order for any notification relating to this entry to\n         potentially be generated.")
slapmPolicyMonitorMaxDelayLow = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 2, 1, 16), Integer32()).setUnits('milliseconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: slapmPolicyMonitorMaxDelayLow.setDescription("The threshold for generating a slapmMonitoredEventOkay\n         notification, signalling that a monitored maximum delay\n         rate has fallen to an acceptable level.\n\n         A value of zero for this object is returned when the\n         slapmPolicyMonitorControl monitorMaxDelay(4) is not\n         enabled.  When enabled the default value for this object\n         is the max delay value specified in the associated\n         action definition minus 10%.  If the action definition\n         doesn't have a max delay defined then there is no\n         default for this object and a value MUST be specified\n         prior to activating this entry when monitorMaxDelay(4)\n         is selected.\n\n         Note: The corresponding slapmPolicyMonitorControl\n         BITS setting, enableAggregateTraps(3), MUST be selected\n         in order for any notification relating to this entry to\n         potentially be generated.")
slapmPolicyMonitorMinInRateNotAchieves = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 2, 1, 17), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyMonitorMinInRateNotAchieves.setDescription('The number of times that a minimum transfer in rate\n          was not achieved.')
slapmPolicyMonitorMaxInRateExceeds = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 2, 1, 18), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyMonitorMaxInRateExceeds.setDescription('The number of times that a maximum transfer in rate\n          was exceeded.')
slapmPolicyMonitorMaxDelayExceeds = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 2, 1, 19), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyMonitorMaxDelayExceeds.setDescription('The number of times that a maximum delay in rate\n          was exceeded.')
slapmPolicyMonitorMinOutRateNotAchieves = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 2, 1, 20), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyMonitorMinOutRateNotAchieves.setDescription('The number of times that a minimum transfer out rate\n          was not achieved.')
slapmPolicyMonitorMaxOutRateExceeds = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 2, 1, 21), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyMonitorMaxOutRateExceeds.setDescription('The number of times that a maximum transfer out rate\n          was exceeded.')
slapmPolicyMonitorCurrentDelayRate = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 2, 1, 22), Gauge32()).setUnits('milliseconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyMonitorCurrentDelayRate.setDescription('The current delay rate for this entry.  This is\n          calculated by taking the average of the TCP\n          round trip times for all associating\n          slapmSubcomponentTable entries within a interval.')
slapmPolicyMonitorRowStatus = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 2, 1, 23), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: slapmPolicyMonitorRowStatus.setDescription('This object allows entries to be created and deleted\n         in the slapmPolicyMonitorTable.  An entry in this table\n         is deleted by setting this object to destroy(6).\n\n         Removal of a corresponding (same policy and traffic profile\n         names) slapmPolicyStatsEntry has the side effect of the\n         automatic deletion an entry in this table.')
slapmSubcomponentTable = MibTable((1, 3, 6, 1, 3, 88, 1, 2, 3), )
if mibBuilder.loadTexts: slapmSubcomponentTable.setDescription('Defines a table to provide information on the\n            individually components that are mapped to\n            a policy rule (or old traffic profile).\n\n            The indexing for this table is designed to support\n            the use of an SNMP GET-NEXT operation using only\n            the remote address and remote port as a way for\n            a management station to retrieve the table entries\n            relating to a particular client.')
slapmSubcomponentEntry = MibTableRow((1, 3, 6, 1, 3, 88, 1, 2, 3, 1), ).setIndexNames((0, "SLAPM-MIB", "slapmSubcomponentRemAddress"), (0, "SLAPM-MIB", "slapmSubcomponentRemPort"), (0, "SLAPM-MIB", "slapmSubcomponentLocalAddress"), (0, "SLAPM-MIB", "slapmSubcomponentLocalPort"))
if mibBuilder.loadTexts: slapmSubcomponentEntry.setDescription("Describes a particular subcomponent entry.  This\n            table does not have an OwnerIndex as\n            part of its indexing since this table's contents\n            is intended to span multiple users.")
slapmSubcomponentRemAddress = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 3, 1, 1), OctetString().subtype(subtypeSpec=ConstraintsUnion(ValueSizeConstraint(0,0),ValueSizeConstraint(4,4),ValueSizeConstraint(16,16),)))
if mibBuilder.loadTexts: slapmSubcomponentRemAddress.setDescription('Indicate the remote address of a subcomponent.\n         A remote address can be either an ipv4 address in which\n         case 4 octets are required or as an ipv6 address that\n\n         requires 16 octets.  The value of this subidentifier\n         is a zero length octet string when this entry relates\n         to a UDP listener.')
slapmSubcomponentRemPort = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 3, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,65535)))
if mibBuilder.loadTexts: slapmSubcomponentRemPort.setDescription('Indicate the remote port of a subcomponent.\n         The value of this subidentifier\n         is 0 when this entry relates to a UDP listener.')
slapmSubcomponentLocalAddress = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 3, 1, 3), OctetString().subtype(subtypeSpec=ConstraintsUnion(ValueSizeConstraint(4,4),ValueSizeConstraint(16,16),)))
if mibBuilder.loadTexts: slapmSubcomponentLocalAddress.setDescription('Indicate the local address of a subcomponent.\n         A local address can be either an ipv4 address in which\n         case 4 octets are required or as an ipv6 address that\n         requires 16 octets.')
slapmSubcomponentLocalPort = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 3, 1, 4), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,65535)))
if mibBuilder.loadTexts: slapmSubcomponentLocalPort.setDescription('Indicate the local port of a subcomponent.')
slapmSubcomponentProtocol = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 3, 1, 5), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("udpListener", 1), ("tcpConnection", 2),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmSubcomponentProtocol.setDescription('Indicate the protocol in use that identifies the\n         type of subcomponent.')
slapmSubcomponentSystemAddress = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 3, 1, 6), OctetString().subtype(subtypeSpec=ConstraintsUnion(ValueSizeConstraint(0,0),ValueSizeConstraint(4,4),ValueSizeConstraint(16,16),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmSubcomponentSystemAddress.setDescription('Address of a system that an Policy definition relates to.\n         A zero length octet string can be used to indicate that\n         only a single system is being represented.\n         Otherwise, the length of the octet string should be\n         4 for an ipv4 address and 16 for an ipv6 address.')
slapmSubcomponentPolicyName = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 3, 1, 7), SlapmNameType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmSubcomponentPolicyName.setDescription('Policy name that this entry relates to.\n\n         This object, along with slapmSubcomponentTrafficProfileName,\n         have been replaced with the use of an unsigned integer\n         index that is mapped to an slapmPolicyNameEntry to actually\n         identify policy naming.')
slapmSubcomponentTrafficProfileName = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 3, 1, 8), SlapmNameType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmSubcomponentTrafficProfileName.setDescription('The corresponding traffic profile name.\n\n         This object, along with slapmSubcomponentProfileName,\n         have been replaced with the use of an unsigned integer\n         index that is mapped to an slapmPolicyNameEntry to\n         actually identify policy naming.')
slapmSubcomponentLastActivity = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 3, 1, 9), DateAndTime().clone(hexValue="0000000000000000")).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmSubcomponentLastActivity.setDescription('The date and timestamp of when this entry was last used.')
slapmSubcomponentInOctets = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 3, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmSubcomponentInOctets.setDescription('The number of octets received from IP for this\n           connection.')
slapmSubcomponentOutOctets = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 3, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmSubcomponentOutOctets.setDescription('The number of octets sent to IP for this connection.')
slapmSubcomponentTcpOutBufferedOctets = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 3, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmSubcomponentTcpOutBufferedOctets.setDescription('Number of outgoing octets buffered.  The value\n           of this object is zero when the entry is not\n           for a TCP connection.')
slapmSubcomponentTcpInBufferedOctets = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 3, 1, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmSubcomponentTcpInBufferedOctets.setDescription('Number of incoming octets buffered.  The value\n           of this object is zero when the entry is not\n           for a TCP connection.')
slapmSubcomponentTcpReXmts = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 3, 1, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmSubcomponentTcpReXmts.setDescription('Number of retransmissions.  The value\n           of this object is zero when the entry is not\n           for a TCP connection.')
slapmSubcomponentTcpRoundTripTime = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 3, 1, 15), Integer32()).setUnits('milliseconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmSubcomponentTcpRoundTripTime.setDescription('The amount of time that has elapsed, measured in\n           milliseconds, from when the last TCP segment was\n           transmitted by the TCP Stack until the ACK was\n           received.\n\n           The value of this object is zero when the entry is not\n           for a TCP connection.')
slapmSubcomponentTcpRoundTripVariance = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 3, 1, 16), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmSubcomponentTcpRoundTripVariance.setDescription('Round trip time variance.\n\n           The value of this object is zero when the entry is not\n           for a TCP connection.')
slapmSubcomponentInPdus = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 3, 1, 17), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmSubcomponentInPdus.setDescription('The number of protocol related data units transferred\n           inbound:\n\n             slapmSubcomponentProtocol    PDU Type\n\n                  udpListener(1)          UDP datagrams\n                  tcpConnection(2)        TCP segments')
slapmSubcomponentOutPdus = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 3, 1, 18), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmSubcomponentOutPdus.setDescription('The number of protocol related data units transferred\n           outbound:\n\n             slapmSubcomponentProtocol    PDU Type\n\n                  udpListener(1)          UDP datagrams\n\n                  tcpConnection(2)        TCP segments')
slapmSubcomponentApplName = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 3, 1, 19), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(0,32))).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmSubcomponentApplName.setDescription('The application name associated with this entry if known,\n           otherwise a zero-length octet string is returned as the\n           value of this object.')
slapmSubcomponentMonitorStatus = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 3, 1, 20), SlapmStatus()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmSubcomponentMonitorStatus.setDescription("The value of this object indicates when a monitored\n         value has exceeded a threshold or isn't meeting the\n         defined service level.  Only the following SlapmStatus\n         BITS setting can be reported here:\n\n                     monitorMinInRateNotAchieved(5),\n                     monitorMaxInRateExceeded(6),\n                     monitorMaxDelayExceeded(7),\n                     monitorMinOutRateNotAchieved(8),\n                     monitorMaxOutRateExceeded(9)\n\n         This object only has meaning when an corresponding\n         slapmPolicyMonitorEntry exists with the\n         slapmPolicyMonitorControl BITS setting\n         monitorSubcomponents(5) enabled.")
slapmSubcomponentMonitorIntTime = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 3, 1, 21), DateAndTime().clone(hexValue="0000000000000000")).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmSubcomponentMonitorIntTime.setDescription('The timestamp for when the last interval ended.\n\n         This object only has meaning when an corresponding\n         slapmPRMonEntry (or old slapmPolicyMonitorEntry)\n         exists with the slapmPRMonControl (or\n         slapmPolicyMonitorControl) BITS setting\n         monitorSubcomponents(5) enabled.  All of the\n         octets returned when monitoring is not in effect\n\n         must be zero.')
slapmSubcomponentMonitorCurrentInRate = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 3, 1, 22), Gauge32()).setUnits('kilobits per second').setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmSubcomponentMonitorCurrentInRate.setDescription('Using the value of the corresponding\n         slapmPRMonInterval (or slapmPolicyMonitorInterval),\n         slapmSubcomponentStatsInOctets\n         is divided by slapmSubcomponentMonitorInterval to determine\n         the current in transfer rate.\n\n         This object only has meaning when an corresponding\n         slapmPRMonEntry (or slapmPolicyMonitorEntry)\n         exists with the slapmPRMonControl (or\n         slapmPolicyMonitorControl) BITS setting\n         monitorSubcomponents(5) enabled.  The value of this\n         object is zero when monitoring is not in effect.')
slapmSubcomponentMonitorCurrentOutRate = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 3, 1, 23), Gauge32()).setUnits('kilobits per second').setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmSubcomponentMonitorCurrentOutRate.setDescription('Using the value of the corresponding slapmPRMonInterval (or\n         slapmPolicyMonitorInterva)l, slapmSubcomponentStatsOutOctets\n         is divided by slapmPRMonInterval (or\n         slapmPolicyMonitorInterval) to determine the\n         current out transfer rate.\n\n         This object only has meaning when an corresponding\n         slapmPRMonEntry (or slapmPolicyMonitorEntry) exists with\n         the slapmPRMonControl (or slapmPolicyMonitorControl)\n         BITS setting monitorSubcomponents(5) enabled.  The value\n         of this object is zero when monitoring is not in effect.')
slapmSubcomponentPolicyRuleIndex = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 3, 1, 24), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,4294967295))).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmSubcomponentPolicyRuleIndex.setDescription('Points to an slapmPolicyNameEntry when combined with\n        slapmSubcomponentSystemAddress to indicate the\n        policy naming that relates to this entry.\n\n        A value of 0 for this object MUST be returned when\n        the corresponding slapmSubcomponentEntry has no\n        policy rule associated with it.')
slapmPolicyNameTable = MibTable((1, 3, 6, 1, 3, 88, 1, 2, 4), )
if mibBuilder.loadTexts: slapmPolicyNameTable.setDescription('Provides the mapping between a policy index as a\n          unsigned 32 bit integer and the unique name associated\n          with a policy rule.')
slapmPolicyNameEntry = MibTableRow((1, 3, 6, 1, 3, 88, 1, 2, 4, 1), ).setIndexNames((0, "SLAPM-MIB", "slapmPolicyNameSystemAddress"), (0, "SLAPM-MIB", "slapmPolicyNameIndex"))
if mibBuilder.loadTexts: slapmPolicyNameEntry.setDescription('Defines an entry in the slapmPolicyNameTable.')
slapmPolicyNameSystemAddress = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 4, 1, 1), OctetString().subtype(subtypeSpec=ConstraintsUnion(ValueSizeConstraint(0,0),ValueSizeConstraint(4,4),ValueSizeConstraint(16,16),)))
if mibBuilder.loadTexts: slapmPolicyNameSystemAddress.setDescription('Address of a system that an Policy rule definition relates\n         to.  A zero length octet string must be used to indicate\n\n         that only a single system is being represented.\n         Otherwise, the length of the octet string must be\n         4 for an ipv4 address or 16 for an ipv6 address.')
slapmPolicyNameIndex = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 4, 1, 2), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,4294967295)))
if mibBuilder.loadTexts: slapmPolicyNameIndex.setDescription('A locally arbitrary, but unique identifier associated\n          with this table entry.  This value is not expected to\n          remain constant across reIPLs.')
slapmPolicyNameOfRule = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 4, 1, 3), SlapmPolicyRuleName()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyNameOfRule.setDescription('The unique name that identifies a policy rule definition.')
slapmPolicyRuleStatsTable = MibTable((1, 3, 6, 1, 3, 88, 1, 2, 5), )
if mibBuilder.loadTexts: slapmPolicyRuleStatsTable.setDescription('Provides statistics on a per system and a per policy\n          rule basis.')
slapmPolicyRuleStatsEntry = MibTableRow((1, 3, 6, 1, 3, 88, 1, 2, 5, 1), ).setIndexNames((0, "SLAPM-MIB", "slapmPolicyNameSystemAddress"), (0, "SLAPM-MIB", "slapmPolicyNameIndex"))
if mibBuilder.loadTexts: slapmPolicyRuleStatsEntry.setDescription('Defines an entry in the slapmPolicyRuleStatsTable.\n          This table defines a set of statistics that is kept\n          on a per system and per policy rule basis.\n\n          Entries in this table are not created or deleted via SNMP\n          but reflect the set of policy rule definitions known\n          at a system.')
slapmPolicyRuleStatsOperStatus = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 5, 1, 1), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3,))).clone(namedValues=NamedValues(("inactive", 1), ("active", 2), ("deleteNeeded", 3),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyRuleStatsOperStatus.setDescription('The state of a policy entry:\n\n           inactive(1)      - An policy entry was either defined\n                              by local system definition or\n                              discovered via\n                              a directory search but has not been\n                              activated (not currently being used).\n           active(2)        - Policy entry is being used to affect\n                              traffic flows.\n           deleteNeeded(3)  - Either though local implementation\n\n                              dependent methods or by discovering\n                              that the directory entry corresponding\n                              to this table entry no longer\n                              exists and slapmPolicyPurgeTime needs\n                              to expire before attempting to remove\n                              the corresponding slapmPolicyStatsEntry\n                              and any dependent slapmPolicyMonitor\n                              table entries.\n         Note: a policy rule in a state other than\n         active(2) is not being used to affect traffic flows.')
slapmPolicyRuleStatsActiveConns = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 5, 1, 2), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyRuleStatsActiveConns.setDescription('The number of active TCP connections that are\n         affected by the corresponding policy entry.')
slapmPolicyRuleStatsTotalConns = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 5, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyRuleStatsTotalConns.setDescription('The number of total TCP connections that are\n         affected by the corresponding policy entry.')
slapmPolicyRuleStatsLActivated = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 5, 1, 4), DateAndTime().clone(hexValue="0000000000000000")).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyRuleStatsLActivated.setDescription('The timestamp for when the corresponding policy entry\n         was last activated.  The value of this object serves as\n         the discontinuity event indicator when polling entries\n         in this table.  The value of this object is updated on\n         transition of slapmPolicyRuleStatsOperStatus into the\n         active(2) state.')
slapmPolicyRuleStatsLastMapping = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 5, 1, 5), DateAndTime().clone(hexValue="0000000000000000")).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyRuleStatsLastMapping.setDescription('The timestamp for when the last time\n         that the associated policy entry was used.')
slapmPolicyRuleStatsInOctets = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 5, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyRuleStatsInOctets.setDescription('The number of octets that was received by IP for an\n         entity that map to this entry.')
slapmPolicyRuleStatsOutOctets = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 5, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyRuleStatsOutOctets.setDescription('The number of octets that was transmitted by IP for an\n         entity that map to this entry.')
slapmPolicyRuleStatsConnLimit = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 5, 1, 8), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyRuleStatsConnLimit.setDescription('The limit for the number of active TCP connections that\n         are allowed for this policy definition.  A value of zero\n         for this object implies that a connection limit has not\n         been specified.')
slapmPolicyRuleStatsCountAccepts = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 5, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyRuleStatsCountAccepts.setDescription("This counter is incremented when a policy action's\n          Permission value is set to Accept and a session\n          (TCP connection) is accepted.")
slapmPolicyRuleStatsCountDenies = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 5, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyRuleStatsCountDenies.setDescription("This counter is incremented when a policy action's\n          Permission value is set to Deny and a session is denied,\n          or when a session (TCP connection) is rejected due to a\n          policy's connection limit (slapmPolicyRuleStatsConnectLimit)\n          being reached.")
slapmPolicyRuleStatsInDiscards = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 5, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyRuleStatsInDiscards.setDescription('This counter counts the number of in octets discarded.\n          This occurs when an error is detected.  Examples of this\n          are buffer overflow, checksum error, or bad packet\n          format.')
slapmPolicyRuleStatsOutDiscards = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 5, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyRuleStatsOutDiscards.setDescription('This counter counts the number of out octets discarded.\n          Examples of this are buffer overflow, checksum error, or\n          bad packet format.')
slapmPolicyRuleStatsInPackets = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 5, 1, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyRuleStatsInPackets.setDescription('This counter counts the number of in packets received\n          that relate to this policy entry from IP.')
slapmPolicyRuleStatsOutPackets = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 5, 1, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyRuleStatsOutPackets.setDescription('This counter counts the number of out packets sent\n          by IP that relate to this policy entry.')
slapmPolicyRuleStatsInProOctets = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 5, 1, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyRuleStatsInProOctets.setDescription('This counter counts the number of in octets that are\n          determined to be within profile.')
slapmPolicyRuleStatsOutProOctets = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 5, 1, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyRuleStatsOutProOctets.setDescription('This counter counts the number of out octets that are\n          determined to be within profile.')
slapmPolicyRuleStatsMinRate = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 5, 1, 17), Unsigned32()).setUnits('Kilobits per second').setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyRuleStatsMinRate.setDescription('The minimum transfer rate defined for this entry.')
slapmPolicyRuleStatsMaxRate = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 5, 1, 18), Unsigned32()).setUnits('Kilobits per second').setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyRuleStatsMaxRate.setDescription('The maximum transfer rate defined for this entry.')
slapmPolicyRuleStatsMaxDelay = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 5, 1, 19), Unsigned32()).setUnits('milliseconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyRuleStatsMaxDelay.setDescription('The maximum delay defined for this entry.')
slapmPolicyRuleStatsTotalRsvpFlows = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 5, 1, 20), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyRuleStatsTotalRsvpFlows.setDescription('Total number of RSVP flows that have be activated.')
slapmPolicyRuleStatsActRsvpFlows = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 5, 1, 21), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPolicyRuleStatsActRsvpFlows.setDescription('Current number of active RSVP flows.')
slapmPRMonTable = MibTable((1, 3, 6, 1, 3, 88, 1, 2, 6), )
if mibBuilder.loadTexts: slapmPRMonTable.setDescription('Provides a method of monitoring policies and their\n          effect at a system.')
slapmPRMonEntry = MibTableRow((1, 3, 6, 1, 3, 88, 1, 2, 6, 1), ).setIndexNames((0, "SLAPM-MIB", "slapmPRMonOwnerIndex"), (0, "SLAPM-MIB", "slapmPRMonSystemAddress"), (0, "SLAPM-MIB", "slapmPRMonIndex"))
if mibBuilder.loadTexts: slapmPRMonEntry.setDescription('Defines an entry in the slapmPRMonTable. This\n          table defines which policies should be monitored on a\n          per policy rule basis.\n\n          An attempt to set any read-create object defined within an\n          slapmPRMonEntry while the value of slapmPRMonRowStatus is\n          active(1) will result in an inconsistentValue error.')
slapmPRMonOwnerIndex = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 6, 1, 1), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(0,16)))
if mibBuilder.loadTexts: slapmPRMonOwnerIndex.setDescription("To facilitate the provisioning of access control by a\n         security administrator using the View-Based Access\n         Control Model (RFC 2575, VACM) for tables in which\n         multiple users may need to independently create or modify\n         entries, the initial index is used as an 'owner index'.\n         Such an initial index has a syntax of SnmpAdminString,\n         and can thus be trivially mapped to a securityName or\n         groupName as defined in VACM, in accordance with a\n         security policy.\n\n         All entries in that table belonging to a particular user\n         will have the same value for this initial index.  For a\n         given user's entries in a particular table, the object\n         identifiers for the information in these entries will\n         have the same subidentifiers (except for the 'column'\n         subidentifier) up to the end of the encoded owner index.\n         To configure VACM to permit access to this portion of the\n         table, one would create vacmViewTreeFamilyTable entries\n         with the value of vacmViewTreeFamilySubtree including the\n         owner index portion, and vacmViewTreeFamilyMask\n         'wildcarding' the column subidentifier.  More elaborate\n         configurations are possible.")
slapmPRMonSystemAddress = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 6, 1, 2), OctetString().subtype(subtypeSpec=ConstraintsUnion(ValueSizeConstraint(0,0),ValueSizeConstraint(4,4),ValueSizeConstraint(16,16),)))
if mibBuilder.loadTexts: slapmPRMonSystemAddress.setDescription('Address of a system that an Policy definition relates to.\n         A zero length octet string can be used to indicate that\n         only a single system is being represented.\n         Otherwise, the length of the octet string should be\n         4 for an ipv4 address and 16 for an ipv6 address.')
slapmPRMonIndex = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 6, 1, 3), Unsigned32())
if mibBuilder.loadTexts: slapmPRMonIndex.setDescription('An slapmPolicyNameTable index, slapmPolicyNameIndex,\n         that points to the unique name associated with a\n         policy rule definition.')
slapmPRMonControl = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 6, 1, 4), Bits().clone(namedValues=NamedValues(("monitorMinRate", 0), ("monitorMaxRate", 1), ("monitorMaxDelay", 2), ("enableAggregateTraps", 3), ("enableSubcomponentTraps", 4), ("monitorSubcomponents", 5),)).clone(namedValues=NamedValues(("monitorMinRate", 0), ("monitorMaxRate", 1), ("monitorMaxDelay", 2),))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: slapmPRMonControl.setDescription("The value of this object determines the type and level\n         of monitoring that is applied to a policy rule.  The\n         value of this object can't be changed once the table\n         entry that it is a part of is activated via a\n         slapmPRMonRowStatus transition to active state.\n\n             monitorMinRate(0) - Monitor minimum transfer rate.\n             monitorMaxRate(1) - Monitor maximum transfer rate.\n             monitorMaxDelay(2) - Monitor maximum delay.\n             enableAggregateTraps(3) - The enableAggregateTraps(3)\n                   BITS setting enables notification generation\n                   when monitoring a policy rule as an\n\n                   aggregate using the values in the corresponding\n                   slapmPRMonStatsEntry.  By default this function\n                   is not enabled.\n             enableSubcomponentTraps(4) - This BITS setting enables\n                   notification generation when monitoring all\n                   subcomponents that are mapped to an corresponding\n                   slapmPRMonStatsEntry.  By default this\n                   function is not enabled.\n             monitorSubcomponents(5) - This BITS setting enables\n                   monitoring of each subcomponent (typically a\n                   TCP connection or UDP listener) individually.")
slapmPRMonStatus = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 6, 1, 5), SlapmStatus()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPRMonStatus.setDescription("The value of this object indicates when a monitored\n         value has not meet a threshold or isn't meeting the\n         defined service level.  The SlapmStatus TEXTUAL-CONVENTION\n         defines two levels of not meeting a threshold.  The first\n         set:\n                     slaMinInRateNotAchieved(0),\n                     slaMaxInRateExceeded(1),\n                     slaMaxDelayExceeded(2),\n                     slaMinOutRateNotAchieved(3),\n                     slaMaxOutRateExceeded(4)\n\n         are used to indicate when the SLA as an aggregate is\n         not meeting a threshold while the second set:\n\n                     monitorMinInRateNotAchieved(5),\n                     monitorMaxInRateExceeded(6),\n                     monitorMaxDelayExceeded(7),\n                     monitorMinOutRateNotAchieved(8),\n                     monitorMaxOutRateExceeded(9)\n\n         indicate that at least one subcomponent is not meeting\n         a threshold.")
slapmPRMonInterval = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 6, 1, 6), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(15,86400)).clone(20)).setUnits('seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: slapmPRMonInterval.setDescription('The number of seconds that defines the sample period.')
slapmPRMonIntTime = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 6, 1, 7), DateAndTime().clone(hexValue="0000000000000000")).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPRMonIntTime.setDescription('The timestamp for when the last interval ended.')
slapmPRMonCurrentInRate = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 6, 1, 8), Gauge32()).setUnits('kilobits per second').setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPRMonCurrentInRate.setDescription('Using the value of the corresponding\n         slapmPRMonInterval, slapmPolicyRuleStatsInOctets\n         is sampled and then divided by slapmPRMonInterval\n         to determine the current in transfer rate.')
slapmPRMonCurrentOutRate = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 6, 1, 9), Gauge32()).setUnits('kilobits per second').setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPRMonCurrentOutRate.setDescription('Using the value of the corresponding\n         slapmPolicyMonInterval, slapmPolicyRuleStatsOutOctets\n         is sampled and then divided by slapmPRMonInterval\n         to determine the current out transfer rate.')
slapmPRMonMinRateLow = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 6, 1, 10), Unsigned32()).setUnits('kilobits per second').setMaxAccess("readcreate")
if mibBuilder.loadTexts: slapmPRMonMinRateLow.setDescription("The threshold for generating a\n         slapmPolicyRuleMonNotOkay notification, signalling\n         that a monitored minimum transfer rate has not been meet.\n\n         A slapmPolicyRuleMonNotOkay notification is not\n         generated again for an slapmPRMonEntry until\n         the minimum transfer rate\n         exceeds slapmPRMonMinRateHigh (a\n         slapmPolicyRuleMonOkay notification is then transmitted)\n         and then fails below slapmPRMonMinRateLow.  This\n         behavior reduces the slapmPolicyRuleMonNotOkay\n         notifications that are transmitted.\n\n         A value of zero for this object is returned when the\n         slapmPRMonControl monitorMinRate(0) is not\n         enabled.  When enabled the default value for this object\n         is the min rate value specified in the associated\n         action definition minus 10%.  If the action definition\n         doesn't have a min rate defined then there is no\n         default for this object and a value MUST be specified\n         prior to activating this entry when monitorMinRate(0)\n         is selected.\n\n         Note: The corresponding slapmPRMonControl\n         BITS setting, enableAggregateTraps(3), MUST be selected in\n         order for any notification relating to this entry to\n         potentially be generated.")
slapmPRMonMinRateHigh = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 6, 1, 11), Unsigned32()).setUnits('kilobits per second').setMaxAccess("readcreate")
if mibBuilder.loadTexts: slapmPRMonMinRateHigh.setDescription("The threshold for generating a slapmPolicyRuleMonOkay\n         notification, signalling that a monitored minimum\n         transfer rate has increased to an acceptable level.\n\n         A value of zero for this object is returned when the\n         slapmPRMonControl monitorMinRate(0) is not\n         enabled.  When enabled the default value for this object\n         is the min rate value specified in the associated\n         action definition plus 10%.  If the action definition\n         doesn't have a min rate defined then there is no\n         default for this object and a value MUST be specified\n         prior to activating this entry when monitorMinRate(0)\n         is selected.\n\n         Note: The corresponding slapmPRMonControl\n         BITS setting, enableAggregateTraps(3), MUST be selected\n         in order for any notification relating to this entry to\n\n         potentially be generated.")
slapmPRMonMaxRateHigh = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 6, 1, 12), Unsigned32()).setUnits('kilobits per second').setMaxAccess("readcreate")
if mibBuilder.loadTexts: slapmPRMonMaxRateHigh.setDescription("The threshold for generating a\n         slapmPolicyRuleMonNotOkay notification, signalling\n         that a monitored maximum transfer rate has been exceeded.\n\n         A slapmPolicyRuleNotOkay notification is not\n         generated again for an slapmPRMonEntry until the\n         maximum transfer rate fails below\n         slapmPRMonMaxRateLow (a slapmPolicyRuleMonOkay\n         notification is then transmitted) and then raises above\n         slapmPRMonMaxRateHigh.  This behavior reduces the\n         slapmPolicyRuleMonNotOkay notifications that are\n         transmitted.\n\n         A value of zero for this object is returned when the\n         slapmPRMonControl monitorMaxRate(1) is not\n         enabled.  When enabled the default value for this object\n         is the max rate value specified in the associated\n         action definition plus 10%.  If the action definition\n         doesn't have a max rate defined then there is no\n         default for this object and a value MUST be specified\n         prior to activating this entry when monitorMaxRate(1)\n         is selected.\n\n         Note: The corresponding slapmPRMonControl\n         BITS setting, enableAggregateTraps(3), MUST be selected in\n         order for any notification relating to this entry to\n         potentially be generated.")
slapmPRMonMaxRateLow = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 6, 1, 13), Unsigned32()).setUnits('kilobits per second').setMaxAccess("readcreate")
if mibBuilder.loadTexts: slapmPRMonMaxRateLow.setDescription("The threshold for generating a slapmPolicyRuleMonOkay\n         notification, signalling that a monitored maximum\n         transfer rate has fallen to an acceptable level.\n\n\n         A value of zero for this object is returned when the\n         slapmPRMonControl monitorMaxRate(1) is not\n         enabled.  When enabled the default value for this object\n         is the max rate value specified in the associated\n         action definition minus 10%.  If the action definition\n         doesn't have a max rate defined then there is no\n         default for this object and a value MUST be specified\n         prior to activating this entry when monitorMaxRate(1)\n         is selected.\n\n         Note: The corresponding slapmPRMonControl\n         BITS setting, enableAggregateTraps(3), MUST be selected in\n         order for any notification relating to this entry to\n         potentially be generated.")
slapmPRMonMaxDelayHigh = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 6, 1, 14), Unsigned32()).setUnits('milliseconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: slapmPRMonMaxDelayHigh.setDescription("The threshold for generating a\n         slapmPolicyRuleMonNotOkay notification, signalling\n         that a monitored maximum delay rate has been exceeded.\n\n         A slapmPolicyRuleMonNotOkay notification is not\n         generated again for an slapmPRMonEntry until\n         the maximum delay rate falls below\n         slapmPRMonMaxDelayLow (a slapmPolicyRuleMonOkay\n         notification is then transmitted) and raises above\n         slapmPRMonMaxDelayHigh.  This behavior reduces\n         the slapmPolicyRuleMonNotOkay notifications that are\n         transmitted.\n\n         A value of zero for this object is returned when the\n         slapmPRMonControl monitorMaxDelay(4) is not\n         enabled.  When enabled the default value for this object\n         is the max delay value specified in the associated\n         action definition plus 10%.  If the action definition\n         doesn't have a max delay defined then there is no\n         default for this object and a value MUST be specified\n         prior to activating this entry when monitorMaxDelay(4)\n         is selected.\n\n         Note: The corresponding slapmPRMonControl\n         BITS setting, enableAggregateTraps(3), MUST be selected\n         in order for any notification relating to this entry to\n\n         potentially be generated.")
slapmPRMonMaxDelayLow = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 6, 1, 15), Unsigned32()).setUnits('milliseconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: slapmPRMonMaxDelayLow.setDescription("The threshold for generating a slapmPolicyRuleMonOkay\n         notification, signalling that a monitored maximum delay\n         rate has fallen to an acceptable level.\n\n         A value of zero for this object is returned when the\n         slapmPRMonControl monitorMaxDelay(4) is not\n         enabled.  When enabled the default value for this object\n         is the max delay value specified in the associated\n         action definition minus 10%.  If the action definition\n         doesn't have a max delay defined then there is no\n         default for this object and a value MUST be specified\n         prior to activating this entry when monitorMaxDelay(4)\n         is selected.\n\n         Note: The corresponding slapmPRMonControl\n         BITS setting, enableAggregateTraps(3), MUST be selected\n         in order for any notification relating to this entry to\n         potentially be generated.")
slapmPRMonMinInRateNotAchieves = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 6, 1, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPRMonMinInRateNotAchieves.setDescription('The number of times that a minimum transfer in rate\n          was not achieved.')
slapmPRMonMaxInRateExceeds = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 6, 1, 17), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPRMonMaxInRateExceeds.setDescription('The number of times that a maximum transfer in rate\n          was exceeded.')
slapmPRMonMaxDelayExceeds = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 6, 1, 18), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPRMonMaxDelayExceeds.setDescription('The number of times that a maximum delay in rate\n          was exceeded.')
slapmPRMonMinOutRateNotAchieves = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 6, 1, 19), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPRMonMinOutRateNotAchieves.setDescription('The number of times that a minimum transfer out rate\n          was not achieved.')
slapmPRMonMaxOutRateExceeds = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 6, 1, 20), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPRMonMaxOutRateExceeds.setDescription('The number of times that a maximum transfer out rate\n          was exceeded.')
slapmPRMonCurrentDelayRate = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 6, 1, 21), Gauge32()).setUnits('milliseconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: slapmPRMonCurrentDelayRate.setDescription('The current delay rate for this entry.  This is\n          calculated by taking the average of the TCP\n          round trip times for all associating\n          slapmSubcomponentTable entries within a interval.')
slapmPRMonRowStatus = MibTableColumn((1, 3, 6, 1, 3, 88, 1, 2, 6, 1, 22), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: slapmPRMonRowStatus.setDescription('This object allows entries to be created and deleted\n         in the slapmPRMonTable.  An entry in this table\n         is deleted by setting this object to destroy(6).\n\n         Removal of an corresponding (same policy index)\n\n         slapmPolicyRuleStatsEntry has the side effect of the\n         automatic deletion an entry in this table.\n\n         Note that an attempt to set any read-create object\n         defined within an slapmPRMonEntry while the value\n         of slapmPRMonRowStatus is active(1) will result in\n         an inconsistentValue error.')
slapmMonitoredEventNotAchieved = NotificationType((1, 3, 6, 1, 3, 88, 0, 1)).setObjects(*(("SLAPM-MIB", "slapmPolicyMonitorIntTime"), ("SLAPM-MIB", "slapmPolicyMonitorControl"), ("SLAPM-MIB", "slapmPolicyMonitorStatus"), ("SLAPM-MIB", "slapmPolicyMonitorStatus"), ("SLAPM-MIB", "slapmPolicyMonitorCurrentInRate"), ("SLAPM-MIB", "slapmPolicyMonitorCurrentOutRate"), ("SLAPM-MIB", "slapmPolicyMonitorCurrentDelayRate"),))
if mibBuilder.loadTexts: slapmMonitoredEventNotAchieved.setDescription('This notification is generated when an monitored event\n         is not achieved with respect to threshold.  This\n         applies only towards monitoring a policy traffic\n         profile as an aggregate via an associating\n         slapmPolicyStatsEntry.  The value\n         of slapmPolicyMonitorControl can be examined to\n         determine what is being monitored.  The first\n         slapmPolicyMonitorStatus value supplies the current\n         monitor status while the 2nd value supplies the\n         previous status.\n\n         Note: The corresponding slapmPolicyMonitorControl\n         BITS setting, enableAggregateTraps(3), MUST be\n         selected in order for this notification to\n         potentially be generated.')
slapmMonitoredEventOkay = NotificationType((1, 3, 6, 1, 3, 88, 0, 2)).setObjects(*(("SLAPM-MIB", "slapmPolicyMonitorIntTime"), ("SLAPM-MIB", "slapmPolicyMonitorControl"), ("SLAPM-MIB", "slapmPolicyMonitorStatus"), ("SLAPM-MIB", "slapmPolicyMonitorStatus"), ("SLAPM-MIB", "slapmPolicyMonitorCurrentInRate"), ("SLAPM-MIB", "slapmPolicyMonitorCurrentOutRate"), ("SLAPM-MIB", "slapmPolicyMonitorCurrentDelayRate"),))
if mibBuilder.loadTexts: slapmMonitoredEventOkay.setDescription('This notification is generated when a monitored\n         event has improved to an acceptable level.  This\n         applies only towards monitoring a policy traffic\n         profile as an aggregate via an associating\n         slapmPolicyStatsEntry.  The value\n         of slapmPolicyMonitorControl can be examined to\n         determine what is being monitored.  The first\n         slapmPolicyMonitorStatus value supplies the current\n         monitor status while the 2nd value supplies the\n         previous status.\n\n         Note: The corresponding slapmPolicyMonitorControl\n         BITS setting, enableAggregateTraps(3), MUST be\n         selected in order for this notification to\n         potentially be generated.')
slapmPolicyProfileDeleted = NotificationType((1, 3, 6, 1, 3, 88, 0, 3)).setObjects(*(("SLAPM-MIB", "slapmPolicyStatsActiveConns"), ("SLAPM-MIB", "slapmPolicyStatsTotalConns"), ("SLAPM-MIB", "slapmPolicyStatsFirstActivated"), ("SLAPM-MIB", "slapmPolicyStatsLastMapping"), ("SLAPM-MIB", "slapmPolicyStatsInOctets"), ("SLAPM-MIB", "slapmPolicyStatsOutOctets"), ("SLAPM-MIB", "slapmPolicyStatsConnectionLimit"), ("SLAPM-MIB", "slapmPolicyStatsCountAccepts"), ("SLAPM-MIB", "slapmPolicyStatsCountDenies"), ("SLAPM-MIB", "slapmPolicyStatsInDiscards"), ("SLAPM-MIB", "slapmPolicyStatsOutDiscards"), ("SLAPM-MIB", "slapmPolicyStatsInPackets"), ("SLAPM-MIB", "slapmPolicyStatsOutPackets"), ("SLAPM-MIB", "slapmPolicyStatsInProfileOctets"), ("SLAPM-MIB", "slapmPolicyStatsOutProfileOctets"), ("SLAPM-MIB", "slapmPolicyStatsMinRate"), ("SLAPM-MIB", "slapmPolicyStatsMaxRate"), ("SLAPM-MIB", "slapmPolicyStatsMaxDelay"),))
if mibBuilder.loadTexts: slapmPolicyProfileDeleted.setDescription('A slapmPolicyDeleted notification is sent when a\n         slapmPolicyStatsEntry is deleted if the value of\n         slapmPolicyTrapEnable is enabled(1).')
slapmPolicyMonitorDeleted = NotificationType((1, 3, 6, 1, 3, 88, 0, 4)).setObjects(*(("SLAPM-MIB", "slapmPolicyMonitorStatus"), ("SLAPM-MIB", "slapmPolicyMonitorInterval"), ("SLAPM-MIB", "slapmPolicyMonitorIntTime"), ("SLAPM-MIB", "slapmPolicyMonitorCurrentInRate"), ("SLAPM-MIB", "slapmPolicyMonitorCurrentOutRate"), ("SLAPM-MIB", "slapmPolicyMonitorCurrentDelayRate"), ("SLAPM-MIB", "slapmPolicyMonitorMinRateLow"), ("SLAPM-MIB", "slapmPolicyMonitorMinRateHigh"), ("SLAPM-MIB", "slapmPolicyMonitorMaxRateHigh"), ("SLAPM-MIB", "slapmPolicyMonitorMaxRateLow"), ("SLAPM-MIB", "slapmPolicyMonitorMaxDelayHigh"), ("SLAPM-MIB", "slapmPolicyMonitorMaxDelayLow"), ("SLAPM-MIB", "slapmPolicyMonitorMinInRateNotAchieves"), ("SLAPM-MIB", "slapmPolicyMonitorMaxInRateExceeds"), ("SLAPM-MIB", "slapmPolicyMonitorMaxDelayExceeds"), ("SLAPM-MIB", "slapmPolicyMonitorMinOutRateNotAchieves"), ("SLAPM-MIB", "slapmPolicyMonitorMaxOutRateExceeds"),))
if mibBuilder.loadTexts: slapmPolicyMonitorDeleted.setDescription('A slapmPolicyMonitorDeleted notification is sent when a\n         slapmPolicyMonitorEntry is deleted if the value of\n         slapmPolicyTrapEnable is enabled(1).')
slapmSubcomponentMonitoredEventNotAchieved = NotificationType((1, 3, 6, 1, 3, 88, 0, 5)).setObjects(*(("SLAPM-MIB", "slapmSubcomponentSystemAddress"), ("SLAPM-MIB", "slapmSubcomponentPolicyName"), ("SLAPM-MIB", "slapmSubcomponentTrafficProfileName"), ("SLAPM-MIB", "slapmSubcomponentMonitorStatus"), ("SLAPM-MIB", "slapmSubcomponentMonitorStatus"), ("SLAPM-MIB", "slapmSubcomponentMonitorIntTime"), ("SLAPM-MIB", "slapmSubcomponentMonitorCurrentInRate"), ("SLAPM-MIB", "slapmSubcomponentMonitorCurrentOutRate"), ("SLAPM-MIB", "slapmSubcomponentTcpRoundTripTime"),))
if mibBuilder.loadTexts: slapmSubcomponentMonitoredEventNotAchieved.setDescription('This notification is generated when a monitored value\n         does not achieved a threshold specification.  This\n         applies only towards monitoring the individual components\n         of a policy traffic profile.  The value of the\n         corresponding slapmPolicyMonitorControl can be examined\n         to determine what is being monitored.  The first\n         slapmSubcomponentMonitorStatus value supplies the current\n\n         monitor status while the 2nd value supplies the\n         previous status.\n\n         Note: The corresponding slapmPolicyMonitorControl\n         BITS setting, enableSubcomponentTraps(4), MUST be selected\n         in order for this notification to potentially be generated.')
slapmSubcomponentMonitoredEventOkay = NotificationType((1, 3, 6, 1, 3, 88, 0, 6)).setObjects(*(("SLAPM-MIB", "slapmSubcomponentSystemAddress"), ("SLAPM-MIB", "slapmSubcomponentPolicyName"), ("SLAPM-MIB", "slapmSubcomponentTrafficProfileName"), ("SLAPM-MIB", "slapmSubcomponentMonitorStatus"), ("SLAPM-MIB", "slapmSubcomponentMonitorStatus"), ("SLAPM-MIB", "slapmSubcomponentMonitorIntTime"), ("SLAPM-MIB", "slapmSubcomponentMonitorCurrentInRate"), ("SLAPM-MIB", "slapmSubcomponentMonitorCurrentOutRate"), ("SLAPM-MIB", "slapmSubcomponentTcpRoundTripTime"),))
if mibBuilder.loadTexts: slapmSubcomponentMonitoredEventOkay.setDescription('This notification is generated when a monitored value\n         has reached an acceptable level.\n\n         Note: The corresponding slapmPolicyMonitorControl\n         BITS setting, enableSubcomponentTraps(3), MUST be\n         selected in order for this notification to potentially\n         be generated.')
slapmPolicyRuleMonNotOkay = NotificationType((1, 3, 6, 1, 3, 88, 0, 7)).setObjects(*(("SLAPM-MIB", "slapmPRMonIntTime"), ("SLAPM-MIB", "slapmPRMonControl"), ("SLAPM-MIB", "slapmPRMonStatus"), ("SLAPM-MIB", "slapmPRMonStatus"), ("SLAPM-MIB", "slapmPRMonCurrentInRate"), ("SLAPM-MIB", "slapmPRMonCurrentOutRate"), ("SLAPM-MIB", "slapmPRMonCurrentDelayRate"),))
if mibBuilder.loadTexts: slapmPolicyRuleMonNotOkay.setDescription('This notification is generated when an monitored event\n         is not achieved with respect to a threshold.  This\n         applies only towards monitoring a policy rule\n         as an aggregate via an associating\n         slapmPolicyRuleStatsEntry.  The value\n\n         of slapmPRMonControl can be examined to\n         determine what is being monitored.  The first\n         slapmPRMonStatus value supplies the current\n         monitor status while the 2nd value supplies the\n         previous status.\n\n         Note: The corresponding slapmPRMonControl\n         BITS setting, enableAggregateTraps(3), MUST be\n         selected in order for this notification to\n         potentially be generated.')
slapmPolicyRuleMonOkay = NotificationType((1, 3, 6, 1, 3, 88, 0, 8)).setObjects(*(("SLAPM-MIB", "slapmPRMonIntTime"), ("SLAPM-MIB", "slapmPRMonControl"), ("SLAPM-MIB", "slapmPRMonStatus"), ("SLAPM-MIB", "slapmPRMonStatus"), ("SLAPM-MIB", "slapmPRMonCurrentInRate"), ("SLAPM-MIB", "slapmPRMonCurrentOutRate"), ("SLAPM-MIB", "slapmPRMonCurrentDelayRate"),))
if mibBuilder.loadTexts: slapmPolicyRuleMonOkay.setDescription('This notification is generated when a monitored\n         event has improved to an acceptable level.  This\n         applies only towards monitoring a policy rule\n         as an aggregate via an associating\n         slapmPolicyRuleStatsEntry.  The value\n         of slapmPRMonControl can be examined to\n         determine what is being monitored.  The first\n         slapmPRMonStatus value supplies the current\n         monitor status while the 2nd value supplies the\n         previous status.\n\n         Note: The corresponding slapmPRMonControl\n         BITS setting, enableAggregateTraps(3), MUST be\n         selected in order for this notification to\n         potentially be generated.')
slapmPolicyRuleDeleted = NotificationType((1, 3, 6, 1, 3, 88, 0, 9)).setObjects(*(("SLAPM-MIB", "slapmPolicyRuleStatsActiveConns"), ("SLAPM-MIB", "slapmPolicyRuleStatsTotalConns"), ("SLAPM-MIB", "slapmPolicyRuleStatsLActivated"), ("SLAPM-MIB", "slapmPolicyRuleStatsLastMapping"), ("SLAPM-MIB", "slapmPolicyRuleStatsInOctets"), ("SLAPM-MIB", "slapmPolicyRuleStatsOutOctets"), ("SLAPM-MIB", "slapmPolicyRuleStatsConnLimit"), ("SLAPM-MIB", "slapmPolicyRuleStatsCountAccepts"), ("SLAPM-MIB", "slapmPolicyRuleStatsCountDenies"), ("SLAPM-MIB", "slapmPolicyRuleStatsInDiscards"), ("SLAPM-MIB", "slapmPolicyRuleStatsOutDiscards"), ("SLAPM-MIB", "slapmPolicyRuleStatsInPackets"), ("SLAPM-MIB", "slapmPolicyRuleStatsOutPackets"), ("SLAPM-MIB", "slapmPolicyRuleStatsInProOctets"), ("SLAPM-MIB", "slapmPolicyRuleStatsOutProOctets"), ("SLAPM-MIB", "slapmPolicyRuleStatsMinRate"), ("SLAPM-MIB", "slapmPolicyRuleStatsMaxRate"), ("SLAPM-MIB", "slapmPolicyRuleStatsMaxDelay"), ("SLAPM-MIB", "slapmPolicyRuleStatsTotalRsvpFlows"), ("SLAPM-MIB", "slapmPolicyRuleStatsActRsvpFlows"),))
if mibBuilder.loadTexts: slapmPolicyRuleDeleted.setDescription('A slapmPolicyRuleDeleted notification is sent when a\n         slapmPolicyRuleStatsEntry is deleted if the value of\n         slapmPolicyTrapEnable is enabled(1).')
slapmPolicyRuleMonDeleted = NotificationType((1, 3, 6, 1, 3, 88, 0, 10)).setObjects(*(("SLAPM-MIB", "slapmPRMonControl"), ("SLAPM-MIB", "slapmPRMonStatus"), ("SLAPM-MIB", "slapmPRMonInterval"), ("SLAPM-MIB", "slapmPRMonIntTime"), ("SLAPM-MIB", "slapmPRMonCurrentInRate"), ("SLAPM-MIB", "slapmPRMonCurrentOutRate"), ("SLAPM-MIB", "slapmPRMonCurrentDelayRate"), ("SLAPM-MIB", "slapmPRMonMinRateLow"), ("SLAPM-MIB", "slapmPRMonMinRateHigh"), ("SLAPM-MIB", "slapmPRMonMaxRateHigh"), ("SLAPM-MIB", "slapmPRMonMaxRateLow"), ("SLAPM-MIB", "slapmPRMonMaxDelayHigh"), ("SLAPM-MIB", "slapmPRMonMaxDelayLow"), ("SLAPM-MIB", "slapmPRMonMinInRateNotAchieves"), ("SLAPM-MIB", "slapmPRMonMaxInRateExceeds"), ("SLAPM-MIB", "slapmPRMonMaxDelayExceeds"), ("SLAPM-MIB", "slapmPRMonMinOutRateNotAchieves"), ("SLAPM-MIB", "slapmPRMonMaxOutRateExceeds"),))
if mibBuilder.loadTexts: slapmPolicyRuleMonDeleted.setDescription('A slapmPolicyRuleMonDeleted notification is sent when a\n         slapmPRMonEntry is deleted if the value of\n\n         slapmPolicyTrapEnable is enabled(1).')
slapmSubcMonitorNotOkay = NotificationType((1, 3, 6, 1, 3, 88, 0, 11)).setObjects(*(("SLAPM-MIB", "slapmSubcomponentSystemAddress"), ("SLAPM-MIB", "slapmSubcomponentPolicyRuleIndex"), ("SLAPM-MIB", "slapmPRMonControl"), ("SLAPM-MIB", "slapmSubcomponentMonitorStatus"), ("SLAPM-MIB", "slapmSubcomponentMonitorStatus"), ("SLAPM-MIB", "slapmSubcomponentMonitorIntTime"), ("SLAPM-MIB", "slapmSubcomponentMonitorCurrentInRate"), ("SLAPM-MIB", "slapmSubcomponentMonitorCurrentOutRate"), ("SLAPM-MIB", "slapmSubcomponentTcpRoundTripTime"),))
if mibBuilder.loadTexts: slapmSubcMonitorNotOkay.setDescription('This notification is generated when a monitored value\n         does not achieved a threshold specification.  This\n         applies only towards monitoring the individual components\n         of a policy rule.  The value of the\n         corresponding slapmPRMonControl can be examined\n         to determine what is being monitored.  The first\n         slapmSubcomponentMonitorStatus value supplies the current\n         monitor status while the 2nd value supplies the\n         previous status.\n\n         Note: The corresponding slapmPRMonControl\n         BITS setting, enableSubcomponentTraps(4), MUST be selected\n         in order for this notification to potentially be generated.')
slapmSubcMonitorOkay = NotificationType((1, 3, 6, 1, 3, 88, 0, 12)).setObjects(*(("SLAPM-MIB", "slapmSubcomponentSystemAddress"), ("SLAPM-MIB", "slapmSubcomponentPolicyRuleIndex"), ("SLAPM-MIB", "slapmPRMonControl"), ("SLAPM-MIB", "slapmSubcomponentMonitorStatus"), ("SLAPM-MIB", "slapmSubcomponentMonitorStatus"), ("SLAPM-MIB", "slapmSubcomponentMonitorIntTime"), ("SLAPM-MIB", "slapmSubcomponentMonitorCurrentInRate"), ("SLAPM-MIB", "slapmSubcomponentMonitorCurrentOutRate"), ("SLAPM-MIB", "slapmSubcomponentTcpRoundTripTime"),))
if mibBuilder.loadTexts: slapmSubcMonitorOkay.setDescription('This notification is generated when a monitored value\n\n         has reached an acceptable level.\n\n         Note: The corresponding slapmPRMonControl\n         BITS setting, enableSubcomponentTraps(3), MUST be\n         selected in order for this notification to potentially\n         be generated.')
slapmCompliances = MibIdentifier((1, 3, 6, 1, 3, 88, 2, 1))
slapmGroups = MibIdentifier((1, 3, 6, 1, 3, 88, 2, 2))
slapmCompliance = ModuleCompliance((1, 3, 6, 1, 3, 88, 2, 1, 1)).setObjects(*(("SLAPM-MIB", "slapmBaseGroup2"), ("SLAPM-MIB", "slapmNotGroup2"), ("SLAPM-MIB", "slapmEndSystemGroup2"), ("SLAPM-MIB", "slapmEndSystemNotGroup2"), ("SLAPM-MIB", "slapmBaseGroup"), ("SLAPM-MIB", "slapmNotGroup"), ("SLAPM-MIB", "slapmOptionalGroup"), ("SLAPM-MIB", "slapmEndSystemGroup"), ("SLAPM-MIB", "slapmEndSystemNotGroup"),))
if mibBuilder.loadTexts: slapmCompliance.setDescription('The compliance statement for the SLAPM-MIB.')
slapmBaseGroup = ObjectGroup((1, 3, 6, 1, 3, 88, 2, 2, 1)).setObjects(*(("SLAPM-MIB", "slapmSpinLock"), ("SLAPM-MIB", "slapmPolicyCountQueries"), ("SLAPM-MIB", "slapmPolicyCountAccesses"), ("SLAPM-MIB", "slapmPolicyCountSuccessAccesses"), ("SLAPM-MIB", "slapmPolicyCountNotFounds"), ("SLAPM-MIB", "slapmPolicyPurgeTime"), ("SLAPM-MIB", "slapmPolicyTrapEnable"), ("SLAPM-MIB", "slapmPolicyStatsOperStatus"), ("SLAPM-MIB", "slapmPolicyStatsActiveConns"), ("SLAPM-MIB", "slapmPolicyStatsFirstActivated"), ("SLAPM-MIB", "slapmPolicyStatsLastMapping"), ("SLAPM-MIB", "slapmPolicyStatsInOctets"), ("SLAPM-MIB", "slapmPolicyStatsOutOctets"), ("SLAPM-MIB", "slapmPolicyStatsConnectionLimit"), ("SLAPM-MIB", "slapmPolicyStatsTotalConns"), ("SLAPM-MIB", "slapmPolicyStatsCountAccepts"), ("SLAPM-MIB", "slapmPolicyStatsCountDenies"), ("SLAPM-MIB", "slapmPolicyStatsInDiscards"), ("SLAPM-MIB", "slapmPolicyStatsOutDiscards"), ("SLAPM-MIB", "slapmPolicyStatsInPackets"), ("SLAPM-MIB", "slapmPolicyStatsOutPackets"), ("SLAPM-MIB", "slapmPolicyStatsMinRate"), ("SLAPM-MIB", "slapmPolicyStatsMaxRate"), ("SLAPM-MIB", "slapmPolicyStatsMaxDelay"), ("SLAPM-MIB", "slapmPolicyMonitorControl"), ("SLAPM-MIB", "slapmPolicyMonitorStatus"), ("SLAPM-MIB", "slapmPolicyMonitorInterval"), ("SLAPM-MIB", "slapmPolicyMonitorIntTime"), ("SLAPM-MIB", "slapmPolicyMonitorCurrentInRate"), ("SLAPM-MIB", "slapmPolicyMonitorCurrentOutRate"), ("SLAPM-MIB", "slapmPolicyMonitorMinRateLow"), ("SLAPM-MIB", "slapmPolicyMonitorMinRateHigh"), ("SLAPM-MIB", "slapmPolicyMonitorMaxRateHigh"), ("SLAPM-MIB", "slapmPolicyMonitorMaxRateLow"), ("SLAPM-MIB", "slapmPolicyMonitorMaxDelayHigh"), ("SLAPM-MIB", "slapmPolicyMonitorMaxDelayLow"), ("SLAPM-MIB", "slapmPolicyMonitorMinInRateNotAchieves"), ("SLAPM-MIB", "slapmPolicyMonitorMaxInRateExceeds"), ("SLAPM-MIB", "slapmPolicyMonitorMaxDelayExceeds"), ("SLAPM-MIB", "slapmPolicyMonitorMinOutRateNotAchieves"), ("SLAPM-MIB", "slapmPolicyMonitorMaxOutRateExceeds"), ("SLAPM-MIB", "slapmPolicyMonitorCurrentDelayRate"), ("SLAPM-MIB", "slapmPolicyMonitorRowStatus"),))
if mibBuilder.loadTexts: slapmBaseGroup.setDescription('The group of objects defined by this MIB that are\n        required for all implementations to be compliant.')
slapmOptionalGroup = ObjectGroup((1, 3, 6, 1, 3, 88, 2, 2, 2)).setObjects(*(("SLAPM-MIB", "slapmPolicyStatsInProfileOctets"), ("SLAPM-MIB", "slapmPolicyStatsOutProfileOctets"),))
if mibBuilder.loadTexts: slapmOptionalGroup.setDescription('The group of objects defined by this MIB that are\n        optional.')
slapmEndSystemGroup = ObjectGroup((1, 3, 6, 1, 3, 88, 2, 2, 3)).setObjects(*(("SLAPM-MIB", "slapmPolicyTrapFilter"), ("SLAPM-MIB", "slapmSubcomponentProtocol"), ("SLAPM-MIB", "slapmSubcomponentSystemAddress"), ("SLAPM-MIB", "slapmSubcomponentPolicyName"), ("SLAPM-MIB", "slapmSubcomponentTrafficProfileName"), ("SLAPM-MIB", "slapmSubcomponentLastActivity"), ("SLAPM-MIB", "slapmSubcomponentInOctets"), ("SLAPM-MIB", "slapmSubcomponentOutOctets"), ("SLAPM-MIB", "slapmSubcomponentTcpOutBufferedOctets"), ("SLAPM-MIB", "slapmSubcomponentTcpInBufferedOctets"), ("SLAPM-MIB", "slapmSubcomponentTcpReXmts"), ("SLAPM-MIB", "slapmSubcomponentTcpRoundTripTime"), ("SLAPM-MIB", "slapmSubcomponentTcpRoundTripVariance"), ("SLAPM-MIB", "slapmSubcomponentInPdus"), ("SLAPM-MIB", "slapmSubcomponentOutPdus"), ("SLAPM-MIB", "slapmSubcomponentApplName"), ("SLAPM-MIB", "slapmSubcomponentMonitorStatus"), ("SLAPM-MIB", "slapmSubcomponentMonitorIntTime"), ("SLAPM-MIB", "slapmSubcomponentMonitorCurrentOutRate"), ("SLAPM-MIB", "slapmSubcomponentMonitorCurrentInRate"),))
if mibBuilder.loadTexts: slapmEndSystemGroup.setDescription('The group of objects defined by this MIB that are\n         required for end system implementations.')
slapmNotGroup = NotificationGroup((1, 3, 6, 1, 3, 88, 2, 2, 4)).setObjects(*(("SLAPM-MIB", "slapmMonitoredEventNotAchieved"), ("SLAPM-MIB", "slapmMonitoredEventOkay"), ("SLAPM-MIB", "slapmPolicyProfileDeleted"), ("SLAPM-MIB", "slapmPolicyMonitorDeleted"),))
if mibBuilder.loadTexts: slapmNotGroup.setDescription('The group of notifications defined by this MIB that MUST\n         be implemented.')
slapmEndSystemNotGroup = NotificationGroup((1, 3, 6, 1, 3, 88, 2, 2, 5)).setObjects(*(("SLAPM-MIB", "slapmSubcomponentMonitoredEventNotAchieved"), ("SLAPM-MIB", "slapmSubcomponentMonitoredEventOkay"),))
if mibBuilder.loadTexts: slapmEndSystemNotGroup.setDescription('The group of objects defined by this MIB that are\n         required for end system implementations.')
slapmBaseGroup2 = ObjectGroup((1, 3, 6, 1, 3, 88, 2, 2, 6)).setObjects(*(("SLAPM-MIB", "slapmSpinLock"), ("SLAPM-MIB", "slapmPolicyCountQueries"), ("SLAPM-MIB", "slapmPolicyCountAccesses"), ("SLAPM-MIB", "slapmPolicyCountSuccessAccesses"), ("SLAPM-MIB", "slapmPolicyCountNotFounds"), ("SLAPM-MIB", "slapmPolicyPurgeTime"), ("SLAPM-MIB", "slapmPolicyTrapEnable"), ("SLAPM-MIB", "slapmPolicyNameOfRule"), ("SLAPM-MIB", "slapmPolicyRuleStatsOperStatus"), ("SLAPM-MIB", "slapmPolicyRuleStatsActiveConns"), ("SLAPM-MIB", "slapmPolicyRuleStatsTotalConns"), ("SLAPM-MIB", "slapmPolicyRuleStatsLActivated"), ("SLAPM-MIB", "slapmPolicyRuleStatsLastMapping"), ("SLAPM-MIB", "slapmPolicyRuleStatsInOctets"), ("SLAPM-MIB", "slapmPolicyRuleStatsOutOctets"), ("SLAPM-MIB", "slapmPolicyRuleStatsConnLimit"), ("SLAPM-MIB", "slapmPolicyRuleStatsCountAccepts"), ("SLAPM-MIB", "slapmPolicyRuleStatsCountDenies"), ("SLAPM-MIB", "slapmPolicyRuleStatsInDiscards"), ("SLAPM-MIB", "slapmPolicyRuleStatsOutDiscards"), ("SLAPM-MIB", "slapmPolicyRuleStatsInPackets"), ("SLAPM-MIB", "slapmPolicyRuleStatsOutPackets"), ("SLAPM-MIB", "slapmPolicyRuleStatsInProOctets"), ("SLAPM-MIB", "slapmPolicyRuleStatsOutProOctets"), ("SLAPM-MIB", "slapmPolicyRuleStatsMinRate"), ("SLAPM-MIB", "slapmPolicyRuleStatsMaxRate"), ("SLAPM-MIB", "slapmPolicyRuleStatsMaxDelay"), ("SLAPM-MIB", "slapmPolicyRuleStatsTotalRsvpFlows"), ("SLAPM-MIB", "slapmPolicyRuleStatsActRsvpFlows"), ("SLAPM-MIB", "slapmPRMonControl"), ("SLAPM-MIB", "slapmPRMonStatus"), ("SLAPM-MIB", "slapmPRMonInterval"), ("SLAPM-MIB", "slapmPRMonIntTime"), ("SLAPM-MIB", "slapmPRMonCurrentInRate"), ("SLAPM-MIB", "slapmPRMonCurrentOutRate"), ("SLAPM-MIB", "slapmPRMonMinRateLow"), ("SLAPM-MIB", "slapmPRMonMinRateHigh"), ("SLAPM-MIB", "slapmPRMonMaxRateHigh"), ("SLAPM-MIB", "slapmPRMonMaxRateLow"), ("SLAPM-MIB", "slapmPRMonMaxDelayHigh"), ("SLAPM-MIB", "slapmPRMonMaxDelayLow"), ("SLAPM-MIB", "slapmPRMonMinInRateNotAchieves"), ("SLAPM-MIB", "slapmPRMonMaxInRateExceeds"), ("SLAPM-MIB", "slapmPRMonMaxDelayExceeds"), ("SLAPM-MIB", "slapmPRMonMinOutRateNotAchieves"), ("SLAPM-MIB", "slapmPRMonMaxOutRateExceeds"), ("SLAPM-MIB", "slapmPRMonCurrentDelayRate"), ("SLAPM-MIB", "slapmPRMonRowStatus"),))
if mibBuilder.loadTexts: slapmBaseGroup2.setDescription('The group of objects defined by this MIB that are\n        required for all implementations to be compliant.')
slapmEndSystemGroup2 = ObjectGroup((1, 3, 6, 1, 3, 88, 2, 2, 7)).setObjects(*(("SLAPM-MIB", "slapmPolicyTrapFilter"), ("SLAPM-MIB", "slapmSubcomponentProtocol"), ("SLAPM-MIB", "slapmSubcomponentSystemAddress"), ("SLAPM-MIB", "slapmSubcomponentLastActivity"), ("SLAPM-MIB", "slapmSubcomponentInOctets"), ("SLAPM-MIB", "slapmSubcomponentOutOctets"), ("SLAPM-MIB", "slapmSubcomponentTcpOutBufferedOctets"), ("SLAPM-MIB", "slapmSubcomponentTcpInBufferedOctets"), ("SLAPM-MIB", "slapmSubcomponentTcpReXmts"), ("SLAPM-MIB", "slapmSubcomponentTcpRoundTripTime"), ("SLAPM-MIB", "slapmSubcomponentTcpRoundTripVariance"), ("SLAPM-MIB", "slapmSubcomponentInPdus"), ("SLAPM-MIB", "slapmSubcomponentOutPdus"), ("SLAPM-MIB", "slapmSubcomponentApplName"), ("SLAPM-MIB", "slapmSubcomponentMonitorStatus"), ("SLAPM-MIB", "slapmSubcomponentMonitorIntTime"), ("SLAPM-MIB", "slapmSubcomponentMonitorCurrentOutRate"), ("SLAPM-MIB", "slapmSubcomponentMonitorCurrentInRate"), ("SLAPM-MIB", "slapmSubcomponentPolicyRuleIndex"),))
if mibBuilder.loadTexts: slapmEndSystemGroup2.setDescription('The group of objects defined by this MIB that are\n         required for end system implementations.')
slapmNotGroup2 = NotificationGroup((1, 3, 6, 1, 3, 88, 2, 2, 8)).setObjects(*(("SLAPM-MIB", "slapmPolicyRuleMonNotOkay"), ("SLAPM-MIB", "slapmPolicyRuleMonOkay"), ("SLAPM-MIB", "slapmPolicyRuleDeleted"), ("SLAPM-MIB", "slapmPolicyRuleMonDeleted"),))
if mibBuilder.loadTexts: slapmNotGroup2.setDescription('The group of notifications defined by this MIB that MUST\n         be implemented.')
slapmEndSystemNotGroup2 = NotificationGroup((1, 3, 6, 1, 3, 88, 2, 2, 9)).setObjects(*(("SLAPM-MIB", "slapmSubcMonitorNotOkay"), ("SLAPM-MIB", "slapmSubcMonitorOkay"),))
if mibBuilder.loadTexts: slapmEndSystemNotGroup2.setDescription('The group of objects defined by this MIB that are\n         required for end system implementations.')
mibBuilder.exportSymbols("SLAPM-MIB", slapmMIB=slapmMIB, slapmBaseGroup=slapmBaseGroup, slapmPolicyRuleStatsMinRate=slapmPolicyRuleStatsMinRate, slapmPolicyMonitorMaxOutRateExceeds=slapmPolicyMonitorMaxOutRateExceeds, slapmPRMonIntTime=slapmPRMonIntTime, slapmSubcomponentMonitorCurrentInRate=slapmSubcomponentMonitorCurrentInRate, slapmNotGroup2=slapmNotGroup2, slapmEndSystemGroup=slapmEndSystemGroup, slapmPRMonMaxDelayLow=slapmPRMonMaxDelayLow, slapmPolicyMonitorMinOutRateNotAchieves=slapmPolicyMonitorMinOutRateNotAchieves, slapmNotGroup=slapmNotGroup, PYSNMP_MODULE_ID=slapmMIB, slapmPolicyMonitorCurrentOutRate=slapmPolicyMonitorCurrentOutRate, slapmPolicyRuleStatsConnLimit=slapmPolicyRuleStatsConnLimit, slapmPolicyRuleStatsTotalRsvpFlows=slapmPolicyRuleStatsTotalRsvpFlows, slapmPolicyStatsFirstActivated=slapmPolicyStatsFirstActivated, slapmPolicyRuleDeleted=slapmPolicyRuleDeleted, slapmSubcMonitorNotOkay=slapmSubcMonitorNotOkay, slapmPolicyRuleStatsActiveConns=slapmPolicyRuleStatsActiveConns, slapmPRMonInterval=slapmPRMonInterval, slapmMonitoredEventNotAchieved=slapmMonitoredEventNotAchieved, slapmPolicyMonitorPolicyName=slapmPolicyMonitorPolicyName, slapmPolicyMonitorMaxDelayExceeds=slapmPolicyMonitorMaxDelayExceeds, slapmEndSystemNotGroup=slapmEndSystemNotGroup, slapmPolicyCountNotFounds=slapmPolicyCountNotFounds, slapmSubcomponentMonitorCurrentOutRate=slapmSubcomponentMonitorCurrentOutRate, slapmPolicyStatsInProfileOctets=slapmPolicyStatsInProfileOctets, slapmTableObjects=slapmTableObjects, slapmSubcomponentOutOctets=slapmSubcomponentOutOctets, slapmEndSystemNotGroup2=slapmEndSystemNotGroup2, slapmSubcomponentLocalAddress=slapmSubcomponentLocalAddress, slapmSubcomponentMonitorStatus=slapmSubcomponentMonitorStatus, slapmPolicyStatsEntry=slapmPolicyStatsEntry, slapmBaseGroup2=slapmBaseGroup2, slapmPolicyMonitorMaxRateHigh=slapmPolicyMonitorMaxRateHigh, slapmCompliance=slapmCompliance, slapmPRMonMinRateLow=slapmPRMonMinRateLow, slapmPolicyNameEntry=slapmPolicyNameEntry, slapmPolicyStatsInOctets=slapmPolicyStatsInOctets, slapmPolicyRuleStatsCountAccepts=slapmPolicyRuleStatsCountAccepts, slapmPolicyMonitorIntTime=slapmPolicyMonitorIntTime, slapmConformance=slapmConformance, slapmSubcomponentEntry=slapmSubcomponentEntry, slapmGroups=slapmGroups, slapmPolicyRuleStatsOutPackets=slapmPolicyRuleStatsOutPackets, slapmBaseObjects=slapmBaseObjects, slapmPRMonMinInRateNotAchieves=slapmPRMonMinInRateNotAchieves, slapmMonitoredEventOkay=slapmMonitoredEventOkay, slapmSubcomponentPolicyRuleIndex=slapmSubcomponentPolicyRuleIndex, slapmPolicyRuleMonDeleted=slapmPolicyRuleMonDeleted, slapmPolicyCountQueries=slapmPolicyCountQueries, slapmPolicyRuleStatsInOctets=slapmPolicyRuleStatsInOctets, slapmPRMonIndex=slapmPRMonIndex, slapmPolicyMonitorMaxInRateExceeds=slapmPolicyMonitorMaxInRateExceeds, slapmPolicyRuleStatsOperStatus=slapmPolicyRuleStatsOperStatus, slapmSubcomponentTrafficProfileName=slapmSubcomponentTrafficProfileName, SlapmNameType=SlapmNameType, slapmPRMonSystemAddress=slapmPRMonSystemAddress, slapmPolicyCountSuccessAccesses=slapmPolicyCountSuccessAccesses, slapmPolicyStatsCountAccepts=slapmPolicyStatsCountAccepts, slapmObjects=slapmObjects, slapmEndSystemGroup2=slapmEndSystemGroup2, slapmSubcomponentInOctets=slapmSubcomponentInOctets, slapmPRMonMinRateHigh=slapmPRMonMinRateHigh, slapmSpinLock=slapmSpinLock, slapmPRMonRowStatus=slapmPRMonRowStatus, slapmSubcomponentMonitorIntTime=slapmSubcomponentMonitorIntTime, slapmPolicyMonitorDeleted=slapmPolicyMonitorDeleted, slapmPolicyRuleStatsOutProOctets=slapmPolicyRuleStatsOutProOctets, slapmPolicyMonitorTable=slapmPolicyMonitorTable, slapmPolicyNameSystemAddress=slapmPolicyNameSystemAddress, slapmPolicyRuleStatsLastMapping=slapmPolicyRuleStatsLastMapping, slapmPolicyMonitorMaxRateLow=slapmPolicyMonitorMaxRateLow, slapmSubcomponentMonitoredEventOkay=slapmSubcomponentMonitoredEventOkay, slapmPRMonCurrentOutRate=slapmPRMonCurrentOutRate, slapmPolicyNameIndex=slapmPolicyNameIndex, slapmPolicyMonitorCurrentDelayRate=slapmPolicyMonitorCurrentDelayRate, slapmSubcomponentLastActivity=slapmSubcomponentLastActivity, slapmPolicyMonitorCurrentInRate=slapmPolicyMonitorCurrentInRate, slapmOptionalGroup=slapmOptionalGroup, slapmPolicyNameTable=slapmPolicyNameTable, slapmPolicyStatsLastMapping=slapmPolicyStatsLastMapping, slapmPolicyStatsOutDiscards=slapmPolicyStatsOutDiscards, slapmPolicyRuleMonNotOkay=slapmPolicyRuleMonNotOkay, slapmPolicyRuleStatsTable=slapmPolicyRuleStatsTable, slapmSubcomponentInPdus=slapmSubcomponentInPdus, slapmPolicyRuleStatsMaxRate=slapmPolicyRuleStatsMaxRate, slapmPRMonMaxOutRateExceeds=slapmPRMonMaxOutRateExceeds, slapmSubcomponentProtocol=slapmSubcomponentProtocol, slapmPRMonCurrentInRate=slapmPRMonCurrentInRate, slapmPolicyTrapEnable=slapmPolicyTrapEnable, slapmPolicyMonitorOwnerIndex=slapmPolicyMonitorOwnerIndex, slapmPolicyRuleStatsInDiscards=slapmPolicyRuleStatsInDiscards, slapmPolicyMonitorControl=slapmPolicyMonitorControl, slapmPRMonControl=slapmPRMonControl, slapmPolicyStatsTrafficProfileName=slapmPolicyStatsTrafficProfileName, slapmSubcomponentPolicyName=slapmSubcomponentPolicyName, slapmSubcomponentTcpRoundTripTime=slapmSubcomponentTcpRoundTripTime, slapmPolicyMonitorMinRateHigh=slapmPolicyMonitorMinRateHigh, slapmSubcomponentTcpInBufferedOctets=slapmSubcomponentTcpInBufferedOctets, slapmPRMonCurrentDelayRate=slapmPRMonCurrentDelayRate, slapmPolicyPurgeTime=slapmPolicyPurgeTime, slapmNotifications=slapmNotifications, slapmPolicyStatsMaxRate=slapmPolicyStatsMaxRate, slapmPolicyMonitorMaxDelayLow=slapmPolicyMonitorMaxDelayLow, slapmPolicyRuleStatsOutOctets=slapmPolicyRuleStatsOutOctets, slapmPRMonMinOutRateNotAchieves=slapmPRMonMinOutRateNotAchieves, slapmPolicyStatsOperStatus=slapmPolicyStatsOperStatus, slapmSubcomponentApplName=slapmSubcomponentApplName, slapmCompliances=slapmCompliances, slapmPolicyRuleStatsEntry=slapmPolicyRuleStatsEntry, slapmSubcomponentRemAddress=slapmSubcomponentRemAddress, slapmSubcomponentRemPort=slapmSubcomponentRemPort, slapmSubcomponentTcpOutBufferedOctets=slapmSubcomponentTcpOutBufferedOctets, slapmPolicyRuleStatsLActivated=slapmPolicyRuleStatsLActivated, slapmPolicyMonitorMinRateLow=slapmPolicyMonitorMinRateLow, slapmPolicyRuleStatsInPackets=slapmPolicyRuleStatsInPackets, slapmPolicyProfileDeleted=slapmPolicyProfileDeleted, slapmPolicyStatsTable=slapmPolicyStatsTable, slapmPRMonTable=slapmPRMonTable, slapmPRMonMaxRateHigh=slapmPRMonMaxRateHigh, slapmPRMonOwnerIndex=slapmPRMonOwnerIndex, slapmPolicyStatsCountDenies=slapmPolicyStatsCountDenies, slapmPolicyRuleStatsInProOctets=slapmPolicyRuleStatsInProOctets, slapmPolicyMonitorSystemAddress=slapmPolicyMonitorSystemAddress, slapmPolicyCountAccesses=slapmPolicyCountAccesses, slapmPRMonMaxRateLow=slapmPRMonMaxRateLow, slapmPolicyRuleMonOkay=slapmPolicyRuleMonOkay, slapmPolicyMonitorRowStatus=slapmPolicyMonitorRowStatus, slapmPolicyStatsMaxDelay=slapmPolicyStatsMaxDelay, slapmSubcomponentMonitoredEventNotAchieved=slapmSubcomponentMonitoredEventNotAchieved, slapmPRMonMaxInRateExceeds=slapmPRMonMaxInRateExceeds, slapmSubcomponentTable=slapmSubcomponentTable, slapmPolicyMonitorStatus=slapmPolicyMonitorStatus, slapmPolicyStatsPolicyName=slapmPolicyStatsPolicyName, slapmPolicyMonitorInterval=slapmPolicyMonitorInterval, slapmPolicyRuleStatsCountDenies=slapmPolicyRuleStatsCountDenies, SlapmPolicyRuleName=SlapmPolicyRuleName, slapmPolicyRuleStatsTotalConns=slapmPolicyRuleStatsTotalConns, slapmPRMonMaxDelayExceeds=slapmPRMonMaxDelayExceeds, slapmPRMonEntry=slapmPRMonEntry, slapmPolicyStatsTotalConns=slapmPolicyStatsTotalConns, slapmPolicyStatsOutOctets=slapmPolicyStatsOutOctets, slapmPRMonStatus=slapmPRMonStatus, slapmPRMonMaxDelayHigh=slapmPRMonMaxDelayHigh, slapmPolicyMonitorMaxDelayHigh=slapmPolicyMonitorMaxDelayHigh, slapmSubcomponentLocalPort=slapmSubcomponentLocalPort, slapmPolicyStatsOutProfileOctets=slapmPolicyStatsOutProfileOctets, slapmPolicyStatsInDiscards=slapmPolicyStatsInDiscards, slapmPolicyMonitorMinInRateNotAchieves=slapmPolicyMonitorMinInRateNotAchieves, slapmPolicyMonitorEntry=slapmPolicyMonitorEntry, slapmSubcomponentSystemAddress=slapmSubcomponentSystemAddress, slapmPolicyStatsConnectionLimit=slapmPolicyStatsConnectionLimit, slapmPolicyNameOfRule=slapmPolicyNameOfRule, slapmSubcomponentOutPdus=slapmSubcomponentOutPdus, SlapmStatus=SlapmStatus, slapmPolicyStatsSystemAddress=slapmPolicyStatsSystemAddress, slapmPolicyTrapFilter=slapmPolicyTrapFilter, slapmPolicyRuleStatsMaxDelay=slapmPolicyRuleStatsMaxDelay, slapmSubcMonitorOkay=slapmSubcMonitorOkay, slapmPolicyStatsActiveConns=slapmPolicyStatsActiveConns, slapmPolicyStatsOutPackets=slapmPolicyStatsOutPackets, slapmPolicyMonitorTrafficProfileName=slapmPolicyMonitorTrafficProfileName, slapmPolicyRuleStatsActRsvpFlows=slapmPolicyRuleStatsActRsvpFlows, slapmPolicyStatsMinRate=slapmPolicyStatsMinRate, slapmSubcomponentTcpRoundTripVariance=slapmSubcomponentTcpRoundTripVariance, slapmPolicyRuleStatsOutDiscards=slapmPolicyRuleStatsOutDiscards, slapmPolicyStatsInPackets=slapmPolicyStatsInPackets, slapmSubcomponentTcpReXmts=slapmSubcomponentTcpReXmts)
