% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{degResults}
\alias{degResults}
\title{Complete report from DESeq2 analysis}
\usage{
degResults(
  res = NULL,
  dds,
  rlogMat = NULL,
  name,
  org = NULL,
  FDR = 0.05,
  do_go = FALSE,
  FC = 0.1,
  group = "condition",
  xs = "time",
  path_results = ".",
  contrast = NULL
)
}
\arguments{
\item{res}{output from \code{\link[DESeq2:results]{DESeq2::results()}} function.}

\item{dds}{\code{\link[DESeq2:DESeqDataSet]{DESeq2::DESeqDataSet()}} object.}

\item{rlogMat}{matrix from \code{\link[DESeq2:rlog]{DESeq2::rlog()}} function.}

\item{name}{string to identify results}

\item{org}{an organism annotation object, like org.Mm.eg.db.
NULL if you want to skip this step.}

\item{FDR}{int cutoff for false discovery rate.}

\item{do_go}{boolean if GO enrichment is done.}

\item{FC}{int cutoff for log2 fold change.}

\item{group}{string column name in colData(dds) that
separates samples in meaninful groups.}

\item{xs}{string column name in colData(dss)
that will be used as X axes in plots (i.e time)}

\item{path_results}{character path where files are stored.
NULL if you don't want to save any file.}

\item{contrast}{list with character vector indicating the
fold change values from different comparisons to add to the output table.}
}
\value{
ggplot2 object
}
\description{
Complete report from DESeq2 analysis
}
\examples{
data(humanGender)
library(DESeq2)
idx <- c(1:10, 75:85)
dse <- DESeqDataSetFromMatrix(assays(humanGender)[[1]][1:1000, idx],
  colData(humanGender)[idx,], design=~group)
dse <- DESeq(dse)
res <- degResults(dds = dse, name = "test", org = NULL,
  do_go = FALSE, group = "group", xs = "group", path_results = NULL)
}
