\name{simplifyNetwork}
\Rdversion{1.1}
\alias{simplifyNetwork}

\title{
Simplify the functions of a synchronous, asynchronous, or probabilistic Boolean network
}
\description{
Eliminates irrelevant variables from the inputs of the gene transition functions. This can be useful if the network was generated randomly via \code{\link{generateRandomNKNetwork}} or if it was perturbed via \code{\link{perturbNetwork}}.
}
\usage{
simplifyNetwork(network, readableFunctions = FALSE)
}

\arguments{
  \item{network}{
	A network structure of class \code{BooleanNetwork} or \code{ProbabilisticBooleanNetwork}. These networks can be read from files by \code{\link{loadNetwork}}, generated by \if{latex}{\cr}\code{\link{generateRandomNKNetwork}}, or reconstructed by \code{\link{reconstructNetwork}}.
}

  \item{readableFunctions}{
This parameter specifies if readable DNF representations of the transition function truth tables are generated and displayed when the network is printed. If set to FALSE, the truth table result column is displayed. If set to "canonical", a canonical Disjunctive Normal Form is generated from each truth table. If set to "short", the canonical DNF is minimized by joining terms (which can be time-consuming for functions with many inputs). If set to TRUE, a short DNF is generated for functions with up to 12 inputs, and a canonical DNF is generated for functions with more than 12 inputs.
}

}
\details{
The function checks whether the output of a gene transition function is independent from the states of any of the input variables. If this is the case, these input variables are dropped, and the transition function is shortened accordingly. 

In non-probabilistic Boolean networks (class \code{BooleanNetwork}), constant genes are automatically fixed (e.g. knocked-out or over-expressed). This means that they are always set to the constant value, and states with the complementary value are not considered in transition tables etc. If you would like to change this behaviour, use \code{\link{fixGenes}} to reset the fixing.
}
\value{
The simplified network of class \code{BooleanNetwork} or \code{ProbabilisticBooleanNetwork}. These classes are described in more detail in \code{\link{loadNetwork}}.
}
\seealso{
\code{\link{loadNetwork}},\code{\link{generateRandomNKNetwork}}, \code{\link{perturbNetwork}}, \code{\link{reconstructNetwork}}, \code{\link{fixGenes}}
}
\examples{
# load example data
data(cellcycle)

# perturb the network
perturbedNet <- perturbNetwork(cellcycle, perturb="functions", method="shuffle")
print(perturbedNet$interactions)

# simplify the network
perturbedNet <- simplifyNetwork(perturbedNet)
print(perturbedNet$interactions)
}
\keyword{Boolean network
  probabilistic Boolean network
  PBN
	logic
	simplify
	simplification}
