% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_cross.R
\docType{data}
\name{stat_cross}
\alias{stat_cross}
\alias{StatCross}
\title{Compute cross-tabulation statistics}
\usage{
stat_cross(
  mapping = NULL,
  data = NULL,
  geom = "point",
  position = "identity",
  ...,
  na.rm = TRUE,
  show.legend = NA,
  inherit.aes = TRUE,
  keep.zero.cells = FALSE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}} or
\code{\link[ggplot2:aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{geom}{Override the default connection between \code{\link[ggplot2]{geom_point}}
and \code{stat_prop}.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{na.rm}{If \code{TRUE}, the default, missing values are removed with a warning.
If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{keep.zero.cells}{If \code{TRUE}, cells with no observations are kept.}
}
\description{
Computes statistics of a 2-dimensional matrix using \code{\link[broom]{augment.htest}}
from \pkg{broom}.
}
\section{Aesthetics}{

\code{stat_prop} requires the \strong{x} and the \strong{y} aesthetics.
}

\section{Computed variables}{

\describe{
\item{observed}{number of observations in x,y}
\item{prop}{proportion of total}
\item{row.prop}{row proportion}
\item{col.prop}{column proportion}
\item{expected}{expected count under the null hypothesis}
\item{resid}{Pearson's residual}
\item{std.resid}{standardized residual}
}
}

\examples{
# Small function to display plots only if it's interactive
p_ <- GGally::print_if_interactive

d <- as.data.frame(Titanic)

# plot number of observations
p_(ggplot(d) +
 aes(x = Class, y = Survived, weight = Freq, size = after_stat(observed)) +
 stat_cross() +
 scale_size_area(max_size = 20))

# custom shape and fill colour based on chi-squared residuals
p_(ggplot(d) +
 aes(
   x = Class, y = Survived, weight = Freq,
   size = after_stat(observed), fill = after_stat(std.resid)
 ) +
 stat_cross(shape = 22) +
 scale_fill_steps2(breaks = c(-3, -2, 2, 3), show.limits = TRUE) +
 scale_size_area(max_size = 20))

# plotting the number of observations as a table
p_(ggplot(d) +
 aes(
   x = Class, y = Survived, weight = Freq, label = after_stat(observed)
 ) +
 geom_text(stat = "cross"))

# Row proportions with standardized residuals
p_(ggplot(d) +
  aes(
    x = Class, y = Survived, weight = Freq,
    label = scales::percent(after_stat(row.prop)),
    size = NULL, fill = after_stat(std.resid)
  ) +
  stat_cross(shape = 22, size = 30) +
  geom_text(stat = "cross") +
  scale_fill_steps2(breaks = c(-3, -2, 2, 3), show.limits = TRUE) +
  facet_grid(Sex ~ .) +
  labs(fill = "Standardized residuals") +
  theme_minimal())

# can work with continuous or character variables
data(tips, package = "reshape")
p_(ggplot(tips) +
  aes(x = tip, y = as.character(day), size = after_stat(observed)) +
  stat_cross(alpha = .1, color = "blue") +
  scale_size_area(max_size = 12))
}
\keyword{datasets}
