% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableau.R
\name{scale_colour_tableau}
\alias{scale_colour_tableau}
\alias{scale_fill_tableau}
\alias{scale_color_tableau}
\title{Tableau color scales (discrete)}
\usage{
scale_colour_tableau(palette = "Tableau 10", type = "regular",
  direction = 1, ...)

scale_fill_tableau(palette = "Tableau 10", type = "regular",
  direction = 1, ...)

scale_color_tableau(palette = "Tableau 10", type = "regular",
  direction = 1, ...)
}
\arguments{
\item{palette}{Palette name. See \funclink{tableau_color_pal}
for available palettes.}

\item{type}{Palette type. One of \code{"regular"}, \code{"sequential"},
or \code{"diverging"}. See \funclink{tableau_color_pal}.}

\item{direction}{If 1, the default, then use the original order of
colors. If -1, then reverse the order.}

\item{...}{Other arguments passed on to \funclink{discrete_scale}.}
}
\description{
Categorical (qualitative) color scales used in Tableau.
Use the function \funclink{scale_colour_gradient_tableau} for the sequential
and \funclink{scale_colour_gradient2_tableau} for the diverging continuous
color scales from Tableu.
}
\examples{
library("ggplot2")

p <- ggplot(mtcars) +
  geom_point(aes(x = wt, y = mpg, colour = factor(gear))) +
  facet_wrap(~am) +
  theme_igray()

palettes <- ggthemes_data[["tableau"]][["color-palettes"]][["regular"]]
for (palette in head(names(palettes), 3L)) {
  print(p + scale_colour_tableau(palette) +
          ggtitle(palette))
}

# the order of colour can be reversed
p + scale_color_tableau(direction = -1)
}
\seealso{
\code{\link{tableau_color_pal}()} for references.

Other colour tableau: \code{\link{scale_colour_gradient2_tableau}},
  \code{\link{scale_colour_gradient_tableau}},
  \code{\link{tableau_color_pal}},
  \code{\link{tableau_gradient_pal}}
}
\concept{colour tableau}
