% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fill.R
\name{bindFillRole}
\alias{bindFillRole}
\title{Allow tags to intelligently fill their container}
\usage{
bindFillRole(
  x,
  ...,
  item = FALSE,
  container = FALSE,
  overwrite = FALSE,
  .cssSelector = NULL
)
}
\arguments{
\item{x}{a \code{\link[=tag]{tag()}} object. Can also be a valid \code{\link[=tagQuery]{tagQuery()}} input if
\code{.cssSelector} is specified.}

\item{...}{currently unused.}

\item{item}{whether or not to treat \code{x} as a fill item.}

\item{container}{whether or not to treat \code{x} as a fill container. Note, this
will set the CSS \code{display} property on the tag to \code{flex} which can change how
its direct children are rendered. Thus, one should be careful not to
mark a tag as a fill container when it needs to rely on other \code{display}
behavior.}

\item{overwrite}{whether or not to override previous calls to
\code{bindFillRole()} (e.g., to remove the item/container role from a tag).}

\item{.cssSelector}{A character string containing a CSS selector for
targeting particular (inner) tag(s) of interest. For more details on what
selector(s) are supported, see \code{\link[=tagAppendAttributes]{tagAppendAttributes()}}.}
}
\value{
The original tag object (\code{x}) with additional attributes (and a
\code{\link[=htmlDependency]{htmlDependency()}}).
}
\description{
Create fill containers and items. If a fill item is a direct child of a fill
container, and that container has an opinionated height, then the item is
allowed to grow and shrink to its container's size.
}
\examples{

tagz <- div(
  id = "outer",
  style = css(
    height = "600px",
    border = "3px red solid"
  ),
  div(
    id = "inner",
    style = css(
      height = "400px",
      border = "3px blue solid"
    )
  )
)

# Inner doesn't fill outer
if (interactive()) browsable(tagz)

tagz <- bindFillRole(tagz, container = TRUE)
tagz <- bindFillRole(tagz, item = TRUE, .cssSelector = "#inner")

# Inner does fill outer
if (interactive()) browsable(tagz)

}
