% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractFDAFeaturesMethods.R
\name{extractFDADTWKernel}
\alias{extractFDADTWKernel}
\title{DTW kernel features}
\usage{
extractFDADTWKernel(
  ref.method = "random",
  n.refs = 0.05,
  refs = NULL,
  dtwwindow = 0.05
)
}
\arguments{
\item{ref.method}{(\code{character(1)})\cr
How should the reference curves be obtained?
Method \code{random} draws \code{n.refs} random reference curves, while \code{all} uses all curves as references.
In order to use user-provided reference curves, this parameter is set to \code{fixed}.}

\item{n.refs}{(\code{numeric(1)})\cr
Number of reference curves to be drawn (as a fraction of the number of observations in the training data).}

\item{refs}{(\code{matrix}|\code{integer(n)})\cr
Integer vector of training set row indices or a matrix of reference curves with the same length as
the functionals in the training data. Overwrites \code{ref.method} and \code{n.refs}.}

\item{dtwwindow}{(\code{numeric(1)})\cr
Size of the warping window size (as a proportion of query length).}
}
\value{
(\link{data.frame}).
}
\description{
The function extracts features from functional data based on the DTW distance with a reference dataframe.
}
\seealso{
Other fda_featextractor: 
\code{\link{extractFDABsignal}()},
\code{\link{extractFDAFPCA}()},
\code{\link{extractFDAFourier}()},
\code{\link{extractFDAMultiResFeatures}()},
\code{\link{extractFDATsfeatures}()},
\code{\link{extractFDAWavelets}()}
}
\concept{fda_featextractor}
