% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise.r
\name{summarise}
\alias{summarise}
\alias{summarize}
\title{Summarise a data frame.}
\usage{
summarise(.data, ...)
}
\arguments{
\item{.data}{the data frame to be summarised}

\item{...}{further arguments of the form var = value}
}
\description{
Summarise works in an analogous way to \code{\link{mutate}}, except
instead of adding columns to an existing data frame, it creates a new
data frame.  This is particularly useful in conjunction with
\code{\link{ddply}} as it makes it easy to perform group-wise summaries.
}
\note{
Be careful when using existing variable names; the corresponding
columns will be immediately updated with the new data and this can affect
subsequent operations referring to those variables.
}
\examples{
# Let's extract the number of teams and total period of time
# covered by the baseball dataframe
summarise(baseball,
 duration = max(year) - min(year),
 nteams = length(unique(team)))
# Combine with ddply to do that for each separate id
ddply(baseball, "id", summarise,
 duration = max(year) - min(year),
 nteams = length(unique(team)))
}
\keyword{manip}
