% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hnsw.R
\name{hnsw_search}
\alias{hnsw_search}
\title{Search an hnswlib nearest neighbor index}
\usage{
hnsw_search(
  X,
  ann,
  k,
  ef = 10,
  verbose = FALSE,
  progress = "bar",
  n_threads = 0,
  grain_size = 1,
  byrow = TRUE
)
}
\arguments{
\item{X}{A numeric matrix of data to search for neighbors. If \code{byrow = TRUE}
(the default) then each row of \code{X} is an item to be searched. Otherwise,
each item should be stored in the columns of \code{X}.}

\item{ann}{an instance of a \code{HnswL2}, \code{HnswCosine} or \code{HnswIp}
class.}

\item{k}{Number of neighbors to return. This can't be larger than the number
of items that were added to the index \code{ann}. To check the size of the
index, call \code{ann$size()}.}

\item{ef}{Size of the dynamic list used during search. Higher values lead
to improved recall at the expense of longer search time. Can take values
between \code{k} and the size of the dataset. Typical values are
\code{100 - 2000}.}

\item{verbose}{If \code{TRUE}, log messages to the console.}

\item{progress}{defunct and has no effect.}

\item{n_threads}{Maximum number of threads to use. The exact number is
determined by \code{grain_size}.}

\item{grain_size}{Minimum amount of work to do (items in \code{X} to search)
per thread. If the number of items in \code{X} isn't sufficient, then fewer
than \code{n_threads} will be used. This is useful in cases where the
overhead of context switching with too many threads outweighs the gains due
to parallelism.}

\item{byrow}{if \code{TRUE} (the default), this indicates that the items to be
searched in \code{X} are stored in each row of \code{X}. Otherwise, the items are
stored in the columns of \code{X}. Storing items in each column reduces the
overhead of copying data to a form that can be searched by the \code{hnsw}
library. Note that if \code{byrow = FALSE}, any matrices returned from this
function will also store the items by column.}
}
\value{
a list containing:
\itemize{
\item \code{idx} a matrix containing the nearest neighbor indices.
\item \code{dist} a matrix containing the nearest neighbor distances.
}

The dimensions of the matrices respect the storage (row or column-based) of
\code{X} as indicated by the \code{byrow} parameter. If \code{byrow = TRUE} (the default)
each row of \code{idx} and \code{dist} contain the neighbor information for the item
passed in the equivalent row of \code{X}, i.e. the dimensions are \verb{n x k} where
\code{n} is the number of items in \code{X}. If \code{byrow = FALSE}, then each column of
\code{idx} and \code{dist} contain the neighbor  information for the item passed in
the equivalent column of \code{X}, i.e. the dimensions are \verb{k x n}.

Every item in the dataset is considered to be a neighbor of itself, so the
first neighbor of item \code{i} should always be \code{i} itself. If that isn't the
case, then any of \code{M} or \code{ef} may need increasing.
}
\description{
Search an hnswlib nearest neighbor index
}
\examples{
irism <- as.matrix(iris[, -5])
ann <- hnsw_build(irism)
iris_nn <- hnsw_search(irism, ann, k = 5)
}
