% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/preprocessing.R
\name{NormalizeData}
\alias{NormalizeData}
\alias{NormalizeData.default}
\alias{NormalizeData.Assay}
\alias{NormalizeData.Seurat}
\title{Normalize Data}
\usage{
NormalizeData(object, ...)

\method{NormalizeData}{default}(
  object,
  normalization.method = "LogNormalize",
  scale.factor = 10000,
  margin = 1,
  block.size = NULL,
  verbose = TRUE,
  ...
)

\method{NormalizeData}{Assay}(
  object,
  normalization.method = "LogNormalize",
  scale.factor = 10000,
  margin = 1,
  verbose = TRUE,
  ...
)

\method{NormalizeData}{Seurat}(
  object,
  assay = NULL,
  normalization.method = "LogNormalize",
  scale.factor = 10000,
  margin = 1,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{object}{An object}

\item{...}{Arguments passed to other methods}

\item{normalization.method}{Method for normalization.
 \itemize{
  \item{LogNormalize: }{Feature counts for each cell are divided by the total
  counts for that cell and multiplied by the scale.factor. This is then
  natural-log transformed using log1p.}
  \item{CLR: }{Applies a centered log ratio transformation}
  \item{RC: }{Relative counts. Feature counts for each cell are divided by the total
  counts for that cell and multiplied by the scale.factor. No log-transformation is applied.
  For counts per million (CPM) set \code{scale.factor = 1e6}}
}}

\item{scale.factor}{Sets the scale factor for cell-level normalization}

\item{margin}{If performing CLR normalization, normalize across features (1) or cells (2)}

\item{block.size}{How many cells should be run in each chunk, will try to split evenly across threads}

\item{verbose}{display progress bar for normalization procedure}

\item{assay}{Name of assay to use}
}
\value{
Returns object after normalization
}
\description{
Normalize the count data present in a given assay.
}
\examples{
\dontrun{
pbmc_small
pmbc_small <- NormalizeData(object = pbmc_small)
}

}
