% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sf.R, R/sp.R, R/maps.R, R/spatstat.R
\name{st_as_sf}
\alias{st_as_sf}
\alias{st_as_sf.data.frame}
\alias{st_as_sf.sf}
\alias{st_as_sf.sfc}
\alias{st_as_sf.Spatial}
\alias{st_as_sf.map}
\alias{st_as_sf.ppp}
\alias{st_as_sf.psp}
\alias{st_as_sf.lpp}
\title{Convert foreign object to an sf object}
\usage{
st_as_sf(x, ...)

\method{st_as_sf}{data.frame}(x, ..., agr = NA_agr_, coords, wkt,
  dim = "XYZ", remove = TRUE, na.fail = TRUE,
  sf_column_name = NULL)

\method{st_as_sf}{sf}(x, ...)

\method{st_as_sf}{sfc}(x, ...)

\method{st_as_sf}{Spatial}(x, ...)

\method{st_as_sf}{map}(x, ...)

\method{st_as_sf}{ppp}(x, ...)

\method{st_as_sf}{psp}(x, ...)

\method{st_as_sf}{lpp}(x, ...)
}
\arguments{
\item{x}{object to be converted into an object class \code{sf}}

\item{...}{passed on to \link{st_sf}, might included named arguments \code{crs} or \code{precision}}

\item{agr}{character vector; see details section of \link{st_sf}}

\item{coords}{in case of point data: names or numbers of the numeric columns holding coordinates}

\item{wkt}{name or number of the character column that holds WKT encoded geometries}

\item{dim}{passed on to \link{st_point} (only when argument coords is given)}

\item{remove}{logical; when coords or wkt is given, remove these columns from data.frame?}

\item{na.fail}{logical; if \code{TRUE}, raise an error if coordinates contain missing values}

\item{sf_column_name}{character; name of the active list-column with simple feature geometries; in case
there is more than one and \code{sf_column_name} is \code{NULL}, the first one is taken.}
}
\description{
Convert foreign object to an sf object
}
\details{
setting argument \code{wkt} annihilates the use of argument \code{coords}. If \code{x} contains a column called "geometry", \code{coords} will result in overwriting of this column by the \link{sfc} geometry list-column.  Setting \code{wkt} will replace this column with the geometry list-column, unless \code{remove_coordinates} is \code{FALSE}.
}
\examples{
pt1 = st_point(c(0,1))
pt2 = st_point(c(1,1))
st_sfc(pt1, pt2)
d = data.frame(a = 1:2)
d$geom = st_sfc(pt1, pt2)
df = st_as_sf(d)
d$geom = c("POINT(0 0)", "POINT(0 1)")
df = st_as_sf(d, wkt = "geom")
d$geom2 = st_sfc(pt1, pt2)
st_as_sf(d) # should warn
data(meuse, package = "sp")
meuse_sf = st_as_sf(meuse, coords = c("x", "y"), crs = 28992, agr = "constant")
meuse_sf[1:3,]
summary(meuse_sf)
library(sp)
x = rbind(c(-1,-1), c(1,-1), c(1,1), c(-1,1), c(-1,-1))
x1 = 0.1 * x + 0.1
x2 = 0.1 * x + 0.4
x3 = 0.1 * x + 0.7
y = x + 3
y1 = x1 + 3
y3 = x3 + 3
m = matrix(c(3, 0), 5, 2, byrow = TRUE)
z = x + m
z1 = x1 + m
z2 = x2 + m
z3 = x3 + m
p1 = Polygons(list( Polygon(x[5:1,]), Polygon(x2), Polygon(x3),
   Polygon(y[5:1,]), Polygon(y1), Polygon(x1), Polygon(y3)), "ID1")
p2 = Polygons(list( Polygon(z[5:1,]), Polygon(z2), Polygon(z3), Polygon(z1)),
  "ID2")
if (require("rgeos")) {
  r = createSPComment(SpatialPolygons(list(p1,p2)))
  comment(r)
  comment(r@polygons[[1]])
  scan(text = comment(r@polygons[[1]]), quiet = TRUE)
  library(sf)
  a = st_as_sf(r)
  summary(a)
}
demo(meuse, ask = FALSE, echo = FALSE)
summary(st_as_sf(meuse))
summary(st_as_sf(meuse.grid))
summary(st_as_sf(meuse.area))
summary(st_as_sf(meuse.riv))
summary(st_as_sf(as(meuse.riv, "SpatialLines")))
pol.grd = as(meuse.grid, "SpatialPolygonsDataFrame")
summary(st_as_sf(pol.grd))
summary(st_as_sf(as(pol.grd, "SpatialLinesDataFrame")))
\dontrun{
  require(spatstat)
  g = st_as_sf(gorillas)
  # select only the points:
  g[st_is(g, "POINT"),]
}
\dontrun{ # because of spatstat interfering with units
if (require(spatstat)) {
 data(chicago)
 plot(st_as_sf(chicago)["label"])
 plot(st_as_sf(chicago)[-1,"label"])
}
}
}
