% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var_pop.R
\name{var_pop}
\alias{var_pop}
\alias{sd_pop}
\title{Calculate population variance and standard deviation}
\usage{
var_pop(x)

sd_pop(x)
}
\arguments{
\item{x}{(Numeric) vector.}
}
\value{
The population variance or standard deviation of \code{x}.
}
\description{
Calculate the population variance or standard deviation of a vector.
}
\details{
Unlike \code{\link[stats]{var}}, which returns the sample variance,
\code{var_pop()} returns the population variance. \code{sd_pop()}
returns the standard deviation based on the population variance.
}
\examples{
data(efc)

# sampling variance
var(efc$c12hour, na.rm = TRUE)
# population variance
var_pop(efc$c12hour)

# sampling sd
sd(efc$c12hour, na.rm = TRUE)
# population sd
sd_pop(efc$c12hour)
}
