% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match.R
\name{longest_match}
\alias{longest_match}
\title{Find the longest match in a trie}
\usage{
longest_match(trie, to_match, include_keys = FALSE)
}
\arguments{
\item{trie}{a trie object, created with \code{\link{trie}}}

\item{to_match}{a character vector containing the strings to match against the
trie's keys.}

\item{include_keys}{a logical value indicating whether to include the keys in the
returned results or not. If TRUE (\emph{not} the default) the returned object will
be a data.frame, rather than a vector.}
}
\description{
\code{longest_match} accepts a trie and a character vector
and returns the value associated with whichever key had the \emph{longest match}
to each entry in the character vector. A trie of "binary" and "bind", for example,
with an entry-to-compare of "binder", will match to "bind".
}
\examples{
trie <- trie(keys = c("afford", "affair", "available", "binary", "bind", "blind"),
                   values = c("afford", "affair", "available", "binary", "bind", "blind"))
longest_match(trie, "binder")

}
\seealso{
\code{\link{prefix_match}} and \code{\link{greedy_match}}
for prefix and greedy matching, respectively.
}
