/*
 *	recite - english text speech synthesizer
 *	Copyright (C) 1993 Peter Miller.
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 1, or (at your option)
 *	any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * MANIFEST: interface definition for common/frame.c
 */

#ifndef FRAME_H
#define FRAME_H

#include <main.h>

typedef struct frame_ty frame_ty;
struct frame_ty
{
	short	f0;	/* 0 */
	short	f1;	/* 1 */
	short	f2;	/* 2 */
	short	f3;	/* 3 */
	short	bw1;	/* 4 */
	short	bw2;	/* 5 */
	short	bw3;	/* 6 */
	short	fnz;	/* 7 */
	short	fnp;	/* 8 */
	short	av;	/* 9 */
	short	anp;	/* 10 */
	short	asp;	/* 11 */
	short	af;	/* 12 */
	short	a1;	/* 13 */
	short	a2;	/* 14 */
	short	a3;	/* 15 */
	short	a4;	/* 16 */
	short	a5;	/* 17 */
	short	a6;	/* 18 */
	short	ab;	/* 19 */
};

void frame_read _((char *filename, char **data, long *datalen));
void frame_write _((char *filename, char *data, long datalen));

void frame_out _((frame_ty *));
void frame_out_collect _((char **data, long *datalen));

#endif /* FRAME_H */
