#! /bin/sh
#
#	recite - english text speech synthesizer
#	Copyright (C) 1993 Peter Miller.
#	All rights reserved.
#
#	This program is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 1, or (at your option)
#	any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# MANIFEST: Test the klatt to sound translations
#

work=/tmp/$$
PAGER=cat
export PAGER

fail()
{
	set +x
	echo FAILED test of klatt to sound translations 1>&2
	cd $here
	rm -rf $work
	exit 1
}
pass()
{
	set +x
	cd $here
	rm -rf $work
	exit 0
}
trap "fail" 1 2 3 15

here=`pwd`
if test $? -ne 0 ; then exit 1; fi
mkdir $work
if test $? -ne 0 ; then exit 1; fi
cd $work
if test $? -ne 0 ; then fail; fi

#
# first
#
$here/bin/recite the quick brown fox jumps over the lazy dog -vol 50
if test $? -ne 0 ; then fail; fi

#
# second
#
$here/bin/recite now is the time for all good men
if test $? -ne 0 ; then fail; fi
$here/bin/recite to come to the aid of their party
if test $? -ne 0 ; then fail; fi

#
# third
#
$here/bin/recite It is generally believed
if test $? -ne 0 ; then fail; fi
$here/bin/recite that all doctors are turkeys
if test $? -ne 0 ; then fail; fi
$here/bin/recite this is not correct
if test $? -ne 0 ; then fail; fi
$here/bin/recite many doctors are quacks
if test $? -ne 0 ; then fail; fi

#
# Only definite negatives are possible.
# The functionality exercised by this test appears to work,
# no other guarantees are made.
#
pass
