#
#    targets.mk
#
#    $Source$
#    $Revision$
#    $Date$
#
#    Copyright (C) 2008, Network Resonance, Inc.
#    All Rights Reserved.
#

# S2C_S2C_ARCHIVE:
#    source files to compile to object and to place in a library archive
#
# S2C_S2C_ARCHIVE_NAME:
#    the library name to use to archive the object files
#
# S2C_S2C_ARCHIVE_TYPE:
#    either 'static', 'dynamic', or 'jni' (the default is 'static')
#
# S2C_S2C_AUTOGENERATED:
#    whether this targets.mk is autogenerated (either 'true' or 'false')
#
# S2C_S2C_COMPILE:
#    source files to compile to object
#
# S2C_S2C_COPY:
#    files to copy to the build directory
#
# S2C_S2C_GLOBAL_CFLAGS:
#    preprocessor and compile-time flags specific to compiling
#    everything
#
# S2C_S2C_GLOBAL_LDFLAGS:
#    link-time flags specific to linking everything
#
# S2C_S2C_LINK:
#    source files compile and link
#
# S2C_S2C_LOCAL_CFLAGS:
#    preprocessor and compile-time flags specific to compiling only
#    the files in this module directory
#
# S2C_S2C_LOCAL_LDFLAGS:
#    link-time flags specific to linking only the files in
#    this module directory
#
# S2C_S2C_PREFIX:
#    defines the module name, which also serves as the
#    prefix for all the variable names defined in this file
#
# S2C_S2C_SUBDIRS:
#    subdirectories containing additional targets.mk files
#
S2C_S2C_ARCHIVE                   = gen.c gram.y scan.l
S2C_S2C_ARCHIVE_NAME              = s2c
S2C_S2C_ARCHIVE_TYPE              =
S2C_S2C_AUTOGENERATED             = true
S2C_S2C_COMPILE                   = s2c_native.cxx
S2C_S2C_COPY                      = s2c_native.hxx
S2C_S2C_GLOBAL_CFLAGS             =
S2C_S2C_GLOBAL_LDFLAGS            =
S2C_S2C_LINK                      = s2c.c
S2C_S2C_LOCAL_CFLAGS              = -I$(RESIPROCATE_SRCDIR) -I$(RESIPROCATE_SRCDIR)rutil
S2C_S2C_LOCAL_LDFLAGS             = -L. -ls2c -L$(RESIPROCATE_SRCDIR)rutil/obj.$(RESIPROCATE_DEBUG)$(RESIPROCATE_PLATFORM) -lrutil 
S2C_S2C_PREFIX                    = S2C_S2C
S2C_S2C_SUBDIRS                   =



#
#    AUTOMATICALLY-GENERATED SECTION
#



#
#    LOCAL ENVIRONMENT
#
S2C_S2C_BUILD                     = gen.$(OBJSUFFIX) gen.d gram.$(OBJSUFFIX) \
                                    gram.d libs2c.$(ARSUFFIX) s2c \
                                    s2c.$(OBJSUFFIX) s2c.d \
                                    s2c_native.$(OBJSUFFIX) s2c_native.d \
                                    s2c_native.hxx scan.$(OBJSUFFIX) scan.d



#
#    GLOBAL ENVIRONMENT
#
GLOBAL_BUILD                     += $(S2C_S2C_BUILD)
GLOBAL_CFLAGS                    += $(S2C_S2C_GLOBAL_CFLAGS) -I$(S2C_S2C_SRCDIR)
GLOBAL_LDFLAGS                   += $(S2C_S2C_GLOBAL_LDFLAGS)



#
#    GENERIC DEPENDENCIES
#
all:                                $(S2C_S2C_BUILD)
depend:                             gen.d
depend:                             gram.d
depend:                             s2c.d
depend:                             s2c_native.d
depend:                             scan.d



#
#    BUILD DEPENDENCIES
#

gen.$(OBJSUFFIX): $(S2C_S2C_SRCDIR)gen.c gen.d
	$(COMPILE.c) $@ $< $(S2C_S2C_LOCAL_CFLAGS) $(GLOBAL_CFLAGS)

gen.d: $(S2C_S2C_SRCDIR)gen.c
	$(COMPILE.c) $@ $< -MM -MG $(S2C_S2C_LOCAL_CFLAGS) $(GLOBAL_CFLAGS)

gram.$(OBJSUFFIX): $(S2C_S2C_SRCDIR)gram.y gram.d
	$(COMPILE.y) $@ $< $(S2C_S2C_LOCAL_CFLAGS) $(GLOBAL_CFLAGS)

gram.d: $(S2C_S2C_SRCDIR)gram.y
	$(COMPILE.y) $@ $< -MM -MG $(S2C_S2C_LOCAL_CFLAGS) $(GLOBAL_CFLAGS)

s2c.$(OBJSUFFIX): $(S2C_S2C_SRCDIR)s2c.c s2c.d
	$(COMPILE.c) $@ $< $(S2C_S2C_LOCAL_CFLAGS) $(GLOBAL_CFLAGS)

s2c.d: $(S2C_S2C_SRCDIR)s2c.c
	$(COMPILE.c) $@ $< -MM -MG $(S2C_S2C_LOCAL_CFLAGS) $(GLOBAL_CFLAGS)

s2c_native.$(OBJSUFFIX): $(S2C_S2C_SRCDIR)s2c_native.cxx s2c_native.d
	$(COMPILE.cxx) $@ $< $(S2C_S2C_LOCAL_CFLAGS) $(GLOBAL_CFLAGS)

s2c_native.d: $(S2C_S2C_SRCDIR)s2c_native.cxx
	$(COMPILE.cxx) $@ $< -MM -MG $(S2C_S2C_LOCAL_CFLAGS) $(GLOBAL_CFLAGS)

scan.$(OBJSUFFIX): $(S2C_S2C_SRCDIR)scan.l scan.d
	$(COMPILE.l) $@ $< $(S2C_S2C_LOCAL_CFLAGS) $(GLOBAL_CFLAGS)

scan.d: $(S2C_S2C_SRCDIR)scan.l
	$(COMPILE.l) $@ $< -MM -MG $(S2C_S2C_LOCAL_CFLAGS) $(GLOBAL_CFLAGS)

s2c_native.hxx: $(S2C_S2C_SRCDIR)s2c_native.hxx
	$(CP) $(CPFLAGS) $(S2C_S2C_SRCDIR)$@ $@

libs2c.$(ARSUFFIX): gen.$(OBJSUFFIX)

libs2c.$(ARSUFFIX): gram.$(OBJSUFFIX)

libs2c.$(ARSUFFIX): scan.$(OBJSUFFIX)

libs2c.$(ARSUFFIX): 
	$(AR) $(ARFLAGS) $@ $?
	$(RANLIB) $@

s2c: s2c.$(OBJSUFFIX) $(GLOBAL_LIBNAME)
	$(LINK.c) $@ s2c.$(OBJSUFFIX) $(S2C_S2C_LOCAL_LDFLAGS) $(GLOBAL_LDFLAGS)
